/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.TemplateElement;
import freemarker.core.ast.TextBlock;
import freemarker.core.parser.ParsingProblem;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AttemptBlock
extends TemplateElement {
    private List<ParsingProblem> parsingProblems = new ArrayList<ParsingProblem>();

    public AttemptBlock(TemplateElement attemptBlock, TemplateElement recoveryBlock) {
        this.nestedElements = new ArrayList(2);
        this.nestedElements.add(attemptBlock);
        this.nestedElements.add(recoveryBlock);
    }

    public TemplateElement getAttemptBlock() {
        return (TemplateElement)this.nestedElements.get(0);
    }

    public TemplateElement getRecoverBlock() {
        return (TemplateElement)this.nestedElements.get(1);
    }

    @Override
    public void execute(Environment env) throws TemplateException, IOException {
        env.render(this.getAttemptBlock(), this.getRecoverBlock(), this.parsingProblems);
    }

    @Override
    public String getDescription() {
        return "attempt block";
    }

    public boolean hasParsingProblems() {
        return !this.parsingProblems.isEmpty();
    }

    public List<ParsingProblem> getParsingProblems() {
        return Collections.unmodifiableList(this.parsingProblems);
    }

    public void addParsingProblem(ParsingProblem problem) {
        this.parsingProblems.add(problem);
        this.nestedElements.set(0, TextBlock.EMPTY_BLOCK);
    }

    public void setParsingProblems(List<ParsingProblem> parsingProblems) {
        this.parsingProblems = parsingProblems;
    }
}

