/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.congocc.core.Grammar;
import org.congocc.parser.TokenSource;

public interface Node {
    public Grammar getGrammar();

    public void setGrammar(Grammar var1);

    default public Node getNamedChild(String name) {
        return null;
    }

    default public void setNamedChild(String name, Node node) {
    }

    default public List<Node> getNamedChildList(String name) {
        return null;
    }

    default public void addToNamedChildList(String name, Node node) {
    }

    default public NodeType getType() {
        return null;
    }

    default public void open() {
    }

    default public void close() {
    }

    default public String getInputSource() {
        TokenSource tokenSource = this.getTokenSource();
        return tokenSource == null ? "input" : tokenSource.getInputSource();
    }

    default public boolean hasChildNodes() {
        return this.getChildCount() > 0;
    }

    public void setParent(Node var1);

    public Node getParent();

    public void addChild(Node var1);

    public void addChild(int var1, Node var2);

    public Node getChild(int var1);

    public void setChild(int var1, Node var2);

    public Node removeChild(int var1);

    default public boolean removeChild(Node n) {
        int index = this.indexOf(n);
        if (index == -1) {
            return false;
        }
        this.removeChild(index);
        return true;
    }

    default public boolean replaceChild(Node current, Node replacement) {
        int index = this.indexOf(current);
        if (index == -1) {
            return false;
        }
        this.setChild(index, replacement);
        return true;
    }

    default public boolean prependChild(Node where, Node inserted) {
        int index = this.indexOf(where);
        if (index == -1) {
            return false;
        }
        this.addChild(index, inserted);
        return true;
    }

    default public boolean appendChild(Node where, Node inserted) {
        int index = this.indexOf(where);
        if (index == -1) {
            return false;
        }
        this.addChild(index + 1, inserted);
        return true;
    }

    default public int indexOf(Node child) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (child != this.getChild(i)) continue;
            return i;
        }
        return -1;
    }

    default public Node previousSibling() {
        Node parent = this.getParent();
        if (parent == null) {
            return null;
        }
        int idx = parent.indexOf(this);
        if (idx <= 0) {
            return null;
        }
        return parent.getChild(idx - 1);
    }

    default public Node nextSibling() {
        Node parent = this.getParent();
        if (parent == null) {
            return null;
        }
        int idx = parent.indexOf(this);
        if (idx >= parent.getChildCount() - 1) {
            return null;
        }
        return parent.getChild(idx + 1);
    }

    public void clearChildren();

    public int getChildCount();

    default public List<Node> children(boolean includeUnparsedTokens) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            TerminalNode tok;
            Node child = this.getChild(i);
            if (includeUnparsedTokens && child instanceof TerminalNode && !(tok = (TerminalNode)child).isUnparsed()) {
                result.addAll(tok.precedingUnparsedTokens());
            }
            result.add(child);
        }
        return result;
    }

    default public List<Node> children() {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            result.add(this.getChild(i));
        }
        return result;
    }

    default public List<? extends TerminalNode> getAllTokens(boolean includeCommentTokens) {
        ArrayList<TerminalNode> result = new ArrayList<TerminalNode>();
        ListIterator<Node> it = this.iterator();
        while (it.hasNext()) {
            Node child = (Node)it.next();
            if (child instanceof TerminalNode) {
                TerminalNode tn = (TerminalNode)child;
                if (tn.isUnparsed()) continue;
                if (includeCommentTokens) {
                    result.addAll(tn.precedingUnparsedTokens());
                }
                result.add(tn);
                continue;
            }
            if (child.getChildCount() <= 0) continue;
            result.addAll(child.getAllTokens(includeCommentTokens));
        }
        return result;
    }

    public TokenSource getTokenSource();

    public void setTokenSource(TokenSource var1);

    default public String getSource() {
        TokenSource tokenSource = this.getTokenSource();
        return tokenSource == null ? null : tokenSource.getText(this.getBeginOffset(), this.getEndOffset());
    }

    default public String getImage() {
        return this.getSource();
    }

    default public int getLength() {
        return this.getEndOffset() - this.getBeginOffset();
    }

    default public int getBeginLine() {
        TokenSource tokenSource = this.getTokenSource();
        return tokenSource == null ? 0 : tokenSource.getLineFromOffset(this.getBeginOffset());
    }

    default public int getEndLine() {
        TokenSource tokenSource = this.getTokenSource();
        return tokenSource == null ? 0 : tokenSource.getLineFromOffset(this.getEndOffset() - 1);
    }

    default public int getBeginColumn() {
        TokenSource tokenSource = this.getTokenSource();
        return tokenSource == null ? 0 : tokenSource.getCodePointColumnFromOffset(this.getBeginOffset());
    }

    default public int getEndColumn() {
        TokenSource tokenSource = this.getTokenSource();
        return tokenSource == null ? 0 : tokenSource.getCodePointColumnFromOffset(this.getEndOffset() - 1);
    }

    public int getBeginOffset();

    public int getEndOffset();

    public void setBeginOffset(int var1);

    public void setEndOffset(int var1);

    default public String getLocation() {
        return this.getInputSource() + ":" + this.getBeginLine() + ":" + this.getBeginColumn();
    }

    default public boolean isUnparsed() {
        return false;
    }

    public void setUnparsed(boolean var1);

    default public <T extends Node> T firstChildOfType(Class<T> clazz) {
        return this.firstChildOfType(clazz, null);
    }

    default public <T extends Node> T firstChildOfType(Class<T> clazz, Predicate<T> pred) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (!clazz.isInstance(child)) continue;
            Node t = (Node)clazz.cast(child);
            if (pred != null && !pred.test(t)) continue;
            return (T)t;
        }
        return null;
    }

    default public Node firstDescendantOfType(NodeType type, Predicate<Node> pred) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (child.getType() == type) {
                if (pred != null && !pred.test(child)) continue;
                return child;
            }
            Node tok = child.firstDescendantOfType(type, pred);
            if (tok == null) continue;
            return tok;
        }
        return null;
    }

    default public Node firstDescendantOfType(NodeType type) {
        return this.firstDescendantOfType(type, null);
    }

    default public Node firstChildOfType(NodeType type) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (child.getType() != type) continue;
            return child;
        }
        return null;
    }

    default public <T extends Node> T firstDescendantOfType(Class<T> clazz, Predicate<T> pred) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (clazz.isInstance(child)) {
                Node t = (Node)clazz.cast(child);
                if (pred != null && !pred.test(t)) continue;
                return (T)t;
            }
            T descendant = child.firstDescendantOfType(clazz, pred);
            if (descendant == null) continue;
            return descendant;
        }
        return null;
    }

    default public <T extends Node> T firstDescendantOfType(Class<T> clazz) {
        return this.firstDescendantOfType(clazz, null);
    }

    default public <T extends Node> List<T> childrenOfType(Class<T> clazz, Predicate<T> pred) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (!clazz.isInstance(child)) continue;
            Node t = (Node)clazz.cast(child);
            if (pred != null && !pred.test(t)) continue;
            result.add(t);
        }
        return result;
    }

    default public <T extends Node> List<T> childrenOfType(Class<T> clazz) {
        return this.childrenOfType(clazz, null);
    }

    default public <T extends Node> List<T> descendantsOfType(Class<T> clazz, Predicate<T> pred) {
        return this.descendants(clazz, pred);
    }

    default public <T extends Node> List<T> descendantsOfType(Class<T> clazz) {
        return this.descendants(clazz, null);
    }

    default public <T extends Node> T firstAncestorOfType(Class<T> clazz) {
        Node parent = this;
        while (parent != null) {
            if (!clazz.isInstance(parent = parent.getParent())) continue;
            return (T)((Node)clazz.cast(parent));
        }
        return null;
    }

    @Deprecated
    default public NodeType getTokenType() {
        return this.getType();
    }

    default public void copyLocationInfo(Node from) {
        this.setTokenSource(from.getTokenSource());
        this.setBeginOffset(from.getBeginOffset());
        this.setEndOffset(from.getEndOffset());
        this.setTokenSource(from.getTokenSource());
    }

    default public void copyLocationInfo(Node start, Node end) {
        this.setTokenSource(start.getTokenSource());
        if (this.getTokenSource() == null) {
            this.setTokenSource(end.getTokenSource());
        }
        this.setBeginOffset(start.getBeginOffset());
        this.setEndOffset(end.getEndOffset());
    }

    default public void replace(Node toBeReplaced) {
        this.copyLocationInfo(toBeReplaced);
        Node parent = toBeReplaced.getParent();
        if (parent != null) {
            int index = parent.indexOf(toBeReplaced);
            parent.setChild(index, this);
        }
    }

    default public Node getFirstChild() {
        return this.getChildCount() > 0 ? this.getChild(0) : null;
    }

    default public Node getLastChild() {
        int count = this.getChildCount();
        return count > 0 ? this.getChild(count - 1) : null;
    }

    default public Node getRoot() {
        Node parent = this;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    default public List<Node> descendants() {
        return this.descendants(Node.class, null);
    }

    default public List<Node> descendants(Predicate<? super Node> predicate) {
        return this.descendants(Node.class, predicate);
    }

    default public <T extends Node> List<T> descendants(Class<T> clazz) {
        return this.descendants(clazz, null);
    }

    default public <T extends Node> List<T> descendants(Class<T> clazz, Predicate<? super T> predicate) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (clazz.isInstance(child)) {
                Node t = (Node)clazz.cast(child);
                if (predicate == null || predicate.test(t)) {
                    result.add(t);
                }
            }
            result.addAll(child.descendants(clazz, predicate));
        }
        return result;
    }

    default public void dump(String prefix) {
        String output = this instanceof TerminalNode ? this.toString().trim() : String.format("<%s (%d, %d)-(%d, %d)>", this.getClass().getSimpleName(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
        if (output.length() > 0) {
            System.out.println(prefix + output);
        }
        ListIterator<Node> it = this.iterator();
        while (it.hasNext()) {
            Node child = (Node)it.next();
            child.dump(prefix + "  ");
        }
    }

    default public void dump() {
        this.dump("");
    }

    default public ListIterator<Node> iterator() {
        return new ListIterator<Node>(){
            private int current = -1;
            private boolean justModified;

            @Override
            public boolean hasNext() {
                return this.current + 1 < Node.this.getChildCount();
            }

            @Override
            public Node next() {
                this.justModified = false;
                return Node.this.getChild(++this.current);
            }

            @Override
            public Node previous() {
                this.justModified = false;
                return Node.this.getChild(--this.current);
            }

            @Override
            public void remove() {
                if (this.justModified) {
                    throw new IllegalStateException();
                }
                Node.this.removeChild(this.current);
                --this.current;
                this.justModified = true;
            }

            @Override
            public void add(Node n) {
                if (this.justModified) {
                    throw new IllegalStateException();
                }
                Node.this.addChild(this.current + 1, n);
                this.justModified = true;
            }

            @Override
            public boolean hasPrevious() {
                return this.current > 0;
            }

            @Override
            public int nextIndex() {
                return this.current + 1;
            }

            @Override
            public int previousIndex() {
                return this.current;
            }

            @Override
            public void set(Node n) {
                Node.this.setChild(this.current, n);
            }
        };
    }

    public static abstract class Visitor {
        private static Map<Class<? extends Visitor>, Map<Class<? extends Node>, Method>> mapLookup;
        private static final Method DUMMY_METHOD;
        private Map<Class<? extends Node>, Method> methodCache = mapLookup.get(this.getClass());
        protected boolean visitUnparsedTokens;

        public Visitor() {
            if (this.methodCache == null) {
                this.methodCache = new ConcurrentHashMap<Class<? extends Node>, Method>();
                mapLookup.put(this.getClass(), this.methodCache);
            }
        }

        private Method getVisitMethod(Node node) {
            Class<?> nodeClass = node.getClass();
            Method method = this.methodCache.get(nodeClass);
            if (method == null) {
                method = this.getVisitMethodImpl(nodeClass);
                this.methodCache.put(nodeClass, method);
            }
            return method;
        }

        private Method getVisitMethodImpl(Class<?> nodeClass) {
            if (nodeClass == null || !Node.class.isAssignableFrom(nodeClass)) {
                return DUMMY_METHOD;
            }
            try {
                Method m = this.getClass().getDeclaredMethod("visit", nodeClass);
                if (!Modifier.isPublic(nodeClass.getModifiers()) || !Modifier.isPublic(m.getModifiers())) {
                    m.setAccessible(true);
                }
                return m;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                for (Class<?> interf : nodeClass.getInterfaces()) {
                    if (!Node.class.isAssignableFrom(interf) || Node.class.equals(interf)) continue;
                    try {
                        Method m = this.getClass().getDeclaredMethod("visit", interf);
                        if (!Modifier.isPublic(interf.getModifiers()) || !Modifier.isPublic(m.getModifiers())) {
                            m.setAccessible(true);
                        }
                        return m;
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        // empty catch block
                    }
                }
                return this.getVisitMethodImpl(nodeClass.getSuperclass());
            }
        }

        public final void visit(Node node) {
            Method visitMethod = this.getVisitMethod(node);
            if (visitMethod == DUMMY_METHOD) {
                this.recurse(node);
            } else {
                try {
                    visitMethod.invoke((Object)this, node);
                }
                catch (InvocationTargetException ite) {
                    Throwable cause = ite.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new RuntimeException(ite);
                }
                catch (IllegalAccessException iae) {
                    throw new RuntimeException(iae);
                }
            }
        }

        public void recurse(Node node) {
            for (Node child : node.children(this.visitUnparsedTokens)) {
                this.visit(child);
            }
        }

        static {
            try {
                DUMMY_METHOD = Object.class.getMethod("toString", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            mapLookup = Collections.synchronizedMap(new HashMap());
        }
    }

    public static interface TerminalNode
    extends Node {
        public TerminalNode getNext();

        public List<? extends TerminalNode> precedingUnparsedTokens();

        default public void truncate(int amount) {
            int newEndOffset = Math.max(this.getBeginOffset(), this.getEndOffset() - amount);
            this.setEndOffset(newEndOffset);
        }
    }

    public static interface NodeType {
        public boolean isUndefined();

        public boolean isInvalid();

        public boolean isEOF();
    }
}

