/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.parser;

import java.util.BitSet;
import java.util.EnumMap;
import java.util.EnumSet;
import org.congocc.parser.InvalidToken;
import org.congocc.parser.Node;
import org.congocc.parser.Token;
import org.congocc.parser.TokenSource;

public class CongoCCLexer
extends TokenSource {
    LexicalState lexicalState = LexicalState.values()[0];
    EnumSet<Token.TokenType> activeTokenTypes = EnumSet.allOf(Token.TokenType.class);
    private static EnumMap<Token.TokenType, LexicalState> tokenTypeToLexicalStateMap = new EnumMap(Token.TokenType.class);
    static final EnumSet<Token.TokenType> regularTokens = EnumSet.of(Token.TokenType.EOF, new Token.TokenType[]{Token.TokenType._INJECT, Token.TokenType._INCLUDE, Token.TokenType._FAIL, Token.TokenType._UNCACHE_TOKENS, Token.TokenType._ACTIVE_TOKENS, Token.TokenType._ACTIVATE_TOKENS, Token.TokenType._DEACTIVATE_TOKENS, Token.TokenType._ENSURE, Token.TokenType._SCAN, Token.TokenType._IGNORE_CASE, Token.TokenType._TOKEN, Token.TokenType._CONTEXTUAL_KEYWORD, Token.TokenType._UNPARSED, Token.TokenType._MORE, Token.TokenType._SKIP, Token.TokenType._EOF, Token.TokenType._ATTEMPT, Token.TokenType._RECOVER, Token.TokenType._RECOVER_TO, Token.TokenType._ON_ERROR, Token.TokenType.HASH, Token.TokenType.BACKSLASH, Token.TokenType.RIGHT_ARROW, Token.TokenType.UP_TO_HERE, Token.TokenType._LEXICAL_STATE, Token.TokenType.SINGLE_QUOTE_STRING, Token.TokenType.START_UNPARSED, Token.TokenType.UNPARSED_CONTENT, Token.TokenType.END_UNPARSED, Token.TokenType.CTRL_Z, Token.TokenType.UNDERSCORE, Token.TokenType.ABSTRACT, Token.TokenType._ASSERT, Token.TokenType.BOOLEAN, Token.TokenType.BREAK, Token.TokenType.BYTE, Token.TokenType.CASE, Token.TokenType.CATCH, Token.TokenType.CHAR, Token.TokenType.CLASS, Token.TokenType.CONST, Token.TokenType.CONTINUE, Token.TokenType._DEFAULT, Token.TokenType.DO, Token.TokenType.DOUBLE, Token.TokenType.ELSE, Token.TokenType.ENUM, Token.TokenType.EXTENDS, Token.TokenType.FALSE, Token.TokenType.FINAL, Token.TokenType.FINALLY, Token.TokenType.FLOAT, Token.TokenType.FOR, Token.TokenType.GOTO, Token.TokenType.IF, Token.TokenType.IMPLEMENTS, Token.TokenType._IMPORT, Token.TokenType.INSTANCEOF, Token.TokenType.INT, Token.TokenType.INTERFACE, Token.TokenType.LONG, Token.TokenType.NATIVE, Token.TokenType.NEW, Token.TokenType.NULL, Token.TokenType.PACKAGE, Token.TokenType.PRIVATE, Token.TokenType.PROTECTED, Token.TokenType.PUBLIC, Token.TokenType.RETURN, Token.TokenType.RECORD, Token.TokenType.SHORT, Token.TokenType.STATIC, Token.TokenType.STRICTFP, Token.TokenType.SUPER, Token.TokenType.SWITCH, Token.TokenType.SYNCHRONIZED, Token.TokenType.THIS, Token.TokenType.THROW, Token.TokenType.THROWS, Token.TokenType.TRANSIENT, Token.TokenType.TRUE, Token.TokenType.TRY, Token.TokenType.VAR, Token.TokenType.VOID, Token.TokenType.VOLATILE, Token.TokenType.WHILE, Token.TokenType.YIELD, Token.TokenType.SEALED, Token.TokenType.NON_SEALED, Token.TokenType.PERMITS, Token.TokenType.MODULE, Token.TokenType.EXPORTS, Token.TokenType.OPEN, Token.TokenType.OPENS, Token.TokenType.PROVIDES, Token.TokenType.REQUIRES, Token.TokenType.TO, Token.TokenType.TRANSITIVE, Token.TokenType.USES, Token.TokenType.WITH, Token.TokenType.WHEN, Token.TokenType.CHARACTER_LITERAL, Token.TokenType.STRING_LITERAL, Token.TokenType.TEXT_BLOCK_LITERAL, Token.TokenType.INTEGER_LITERAL, Token.TokenType.LONG_LITERAL, Token.TokenType.FLOATING_POINT_LITERAL, Token.TokenType.LPAREN, Token.TokenType.RPAREN, Token.TokenType.LBRACE, Token.TokenType.RBRACE, Token.TokenType.LBRACKET, Token.TokenType.RBRACKET, Token.TokenType.SEMICOLON, Token.TokenType.COMMA, Token.TokenType.DOT, Token.TokenType.DOUBLE_COLON, Token.TokenType.VAR_ARGS, Token.TokenType.AT, Token.TokenType.ASSIGN, Token.TokenType.GT, Token.TokenType.LT, Token.TokenType.BANG, Token.TokenType.TILDE, Token.TokenType.HOOK, Token.TokenType.COLON, Token.TokenType.EQ, Token.TokenType.LE, Token.TokenType.GE, Token.TokenType.NE, Token.TokenType.SC_OR, Token.TokenType.SC_AND, Token.TokenType.INCR, Token.TokenType.DECR, Token.TokenType.PLUS, Token.TokenType.MINUS, Token.TokenType.STAR, Token.TokenType.SLASH, Token.TokenType.BIT_AND, Token.TokenType.BIT_OR, Token.TokenType.XOR, Token.TokenType.REM, Token.TokenType.LSHIFT, Token.TokenType.PLUSASSIGN, Token.TokenType.MINUSASSIGN, Token.TokenType.STARASSIGN, Token.TokenType.SLASHASSIGN, Token.TokenType.ANDASSIGN, Token.TokenType.ORASSIGN, Token.TokenType.XORASSIGN, Token.TokenType.REMASSIGN, Token.TokenType.LSHIFTASSIGN, Token.TokenType.RSIGNEDSHIFT, Token.TokenType.RUNSIGNEDSHIFT, Token.TokenType.RSIGNEDSHIFTASSIGN, Token.TokenType.RUNSIGNEDSHIFTASSIGN, Token.TokenType.LAMBDA, Token.TokenType.IDENTIFIER});
    static final EnumSet<Token.TokenType> unparsedTokens = EnumSet.of(Token.TokenType.MULTI_LINE_COMMENT, Token.TokenType.SINGLE_LINE_COMMENT);
    static final EnumSet<Token.TokenType> skippedTokens = EnumSet.of(Token.TokenType.WHITESPACE);
    static final EnumSet<Token.TokenType> moreTokens = EnumSet.of(Token.TokenType.SINGLE_LINE_COMMENT_START, Token.TokenType.MULTI_LINE_COMMENT_START, Token.TokenType.ANY_CHAR);
    private static final EnumMap<LexicalState, NfaFunction[]> functionTableMap;

    public static void keepWhitespace(boolean b) {
        if (b) {
            skippedTokens.remove(Token.TokenType.WHITESPACE);
            unparsedTokens.add(Token.TokenType.WHITESPACE);
        } else {
            skippedTokens.add(Token.TokenType.WHITESPACE);
            unparsedTokens.remove(Token.TokenType.WHITESPACE);
        }
    }

    public CongoCCLexer(CharSequence input) {
        this("input", input);
    }

    public CongoCCLexer(String inputSource, CharSequence input) {
        this(inputSource, input, LexicalState.JAVA, 1, 1);
    }

    public CongoCCLexer(String inputSource, CharSequence input, LexicalState lexState, int startingLine, int startingColumn) {
        super(inputSource, input, startingLine, startingColumn, 1, true, false, true, "\n");
        this.activeTokenTypes.remove(Token.TokenType._INCLUDE);
        this.activeTokenTypes.remove(Token.TokenType._INJECT);
        this.activeTokenTypes.remove(Token.TokenType._EOF);
        this.activeTokenTypes.remove(Token.TokenType.RECORD);
        this.activeTokenTypes.remove(Token.TokenType.VAR);
        this.activeTokenTypes.remove(Token.TokenType.YIELD);
        this.activeTokenTypes.remove(Token.TokenType.SEALED);
        this.activeTokenTypes.remove(Token.TokenType.NON_SEALED);
        this.activeTokenTypes.remove(Token.TokenType.PERMITS);
        this.activeTokenTypes.remove(Token.TokenType.MODULE);
        this.activeTokenTypes.remove(Token.TokenType.OPEN);
        this.activeTokenTypes.remove(Token.TokenType.OPENS);
        this.activeTokenTypes.remove(Token.TokenType.PROVIDES);
        this.activeTokenTypes.remove(Token.TokenType.REQUIRES);
        this.activeTokenTypes.remove(Token.TokenType.EXPORTS);
        this.activeTokenTypes.remove(Token.TokenType.USES);
        this.activeTokenTypes.remove(Token.TokenType.WITH);
        this.activeTokenTypes.remove(Token.TokenType.TO);
        this.activeTokenTypes.remove(Token.TokenType.TRANSITIVE);
        this.activeTokenTypes.remove(Token.TokenType.WHEN);
        if (this.lexicalState != null) {
            this.switchTo(lexState);
        }
    }

    public Token getNextToken(Token tok) {
        if (tok == null) {
            tok = this.tokenizeAt(0);
            this.cacheToken(tok);
            return tok;
        }
        Token cachedToken = tok.nextCachedToken();
        if (cachedToken != null && this.activeTokenTypes != null && !this.activeTokenTypes.contains(cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        if (cachedToken == null) {
            Token token = this.tokenizeAt(tok.getEndOffset());
            this.cacheToken(token);
            return token;
        }
        return cachedToken;
    }

    static MatchInfo getMatchInfo(CharSequence input, int position, EnumSet<Token.TokenType> activeTokenTypes, NfaFunction[] nfaFunctions) {
        if (position >= input.length()) {
            return new MatchInfo(Token.TokenType.EOF, 0);
        }
        int start = position;
        int matchLength = 0;
        Token.TokenType matchedType = Token.TokenType.INVALID;
        BitSet currentStates = new BitSet(923);
        BitSet nextStates = new BitSet(923);
        do {
            int curChar;
            if (position > start) {
                BitSet temp = currentStates;
                currentStates = nextStates;
                nextStates = temp;
                nextStates.clear();
                if (input instanceof TokenSource) {
                    position = ((TokenSource)input).nextUnignoredOffset(position);
                }
            } else {
                currentStates.set(0);
            }
            if (position >= input.length()) break;
            if ((curChar = Character.codePointAt(input, position++)) > 65535) {
                ++position;
            }
            int nextActive = currentStates.nextSetBit(0);
            while (nextActive != -1) {
                Token.TokenType returnedType = nfaFunctions[nextActive].apply(curChar, nextStates, activeTokenTypes);
                if (returnedType != null && (position - start > matchLength || returnedType.ordinal() < matchedType.ordinal())) {
                    matchedType = returnedType;
                    matchLength = position - start;
                }
                nextActive = currentStates.nextSetBit(nextActive + 1);
            }
        } while (position < input.length() && !nextStates.isEmpty());
        return new MatchInfo(matchedType, matchLength);
    }

    final Token tokenizeAt(int position) {
        int tokenBeginOffset = position;
        boolean inMore = false;
        StringBuilder invalidChars = null;
        Token matchedToken = null;
        Token.TokenType matchedType = null;
        while (matchedToken == null) {
            NfaFunction[] nfaFunctions = functionTableMap.get((Object)this.lexicalState);
            position = this.nextUnignoredOffset(position);
            if (!inMore) {
                tokenBeginOffset = position;
            }
            MatchInfo matchInfo = CongoCCLexer.getMatchInfo(this, position, this.activeTokenTypes, nfaFunctions);
            matchedType = matchInfo.matchedType;
            inMore = moreTokens.contains(matchedType);
            position += matchInfo.matchLength;
            LexicalState newState = tokenTypeToLexicalStateMap.get(matchedType);
            if (newState != null) {
                this.lexicalState = newState;
            }
            if (matchedType == Token.TokenType.INVALID) {
                if (invalidChars == null) {
                    invalidChars = new StringBuilder();
                }
                int cp = Character.codePointAt(this, tokenBeginOffset);
                invalidChars.appendCodePoint(cp);
                ++position;
                if (cp <= 65535) continue;
                ++position;
                continue;
            }
            if (invalidChars != null) {
                return new InvalidToken(this, tokenBeginOffset - invalidChars.length(), tokenBeginOffset);
            }
            if (skippedTokens.contains(matchedType)) {
                this.skipTokens(tokenBeginOffset, position);
                continue;
            }
            if (!regularTokens.contains(matchedType) && !unparsedTokens.contains(matchedType)) continue;
            matchedToken = Token.newToken(matchedType, this, tokenBeginOffset, position);
            matchedToken.setUnparsed(!regularTokens.contains(matchedType));
        }
        this.doLexicalStateSwitch(matchedToken.getType());
        matchedToken = this.tokenLexicalActions(matchedToken, matchedType);
        return matchedToken;
    }

    boolean doLexicalStateSwitch(Token.TokenType tokenType) {
        LexicalState newState = tokenTypeToLexicalStateMap.get(tokenType);
        if (newState == null) {
            return false;
        }
        return this.switchTo(newState);
    }

    public boolean switchTo(LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(Token t, LexicalState state) {
        this.uncacheTokens(t);
        if (state != null) {
            this.switchTo(state);
        } else {
            this.doLexicalStateSwitch(t.getType());
        }
    }

    void reset(Token t) {
        this.reset(t, null);
    }

    private Token tokenLexicalActions(Token matchedToken, Token.TokenType matchedType) {
        switch (matchedType) {
            case CTRL_Z: {
                matchedToken.setType(Token.TokenType.EOF);
                break;
            }
        }
        return matchedToken;
    }

    void cacheToken(Token tok) {
        if (tok.isInserted()) {
            Token next = tok.nextCachedToken();
            if (next != null) {
                this.cacheToken(next);
            }
            return;
        }
        this.cacheTokenAt(tok, tok.getBeginOffset());
    }

    @Override
    protected void uncacheTokens(Node.TerminalNode lastToken) {
        super.uncacheTokens(lastToken);
        ((Token)lastToken).unsetAppendedToken();
    }

    static {
        tokenTypeToLexicalStateMap.put(Token.TokenType.MULTI_LINE_COMMENT, LexicalState.JAVA);
        tokenTypeToLexicalStateMap.put(Token.TokenType.SINGLE_LINE_COMMENT_START, LexicalState.IN_SINGLE_LINE_COMMENT);
        tokenTypeToLexicalStateMap.put(Token.TokenType.MULTI_LINE_COMMENT_START, LexicalState.IN_MULTI_LINE_COMMENT);
        tokenTypeToLexicalStateMap.put(Token.TokenType.SINGLE_LINE_COMMENT, LexicalState.JAVA);
        functionTableMap = new EnumMap(LexicalState.class);
        JAVA.NFA_FUNCTIONS_init();
        IN_UNPARSED_CODE_BLOCK.NFA_FUNCTIONS_init();
        IN_MULTI_LINE_COMMENT.NFA_FUNCTIONS_init();
        IN_SINGLE_LINE_COMMENT.NFA_FUNCTIONS_init();
        JAVA_MODULE.NFA_FUNCTIONS_init();
    }

    private static class JAVA_MODULE {
        private static int[] NFA_MOVES_JAVA_MODULE_0 = JAVA_MODULE.NFA_MOVES_JAVA_MODULE_0_init();
        private static int[] NFA_MOVES_JAVA_MODULE_2 = JAVA_MODULE.NFA_MOVES_JAVA_MODULE_2_init();

        private JAVA_MODULE() {
        }

        private static Token.TokenType NFA_JAVA_MODULE_0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 36 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_JAVA_MODULE_0, ch)) {
                nextStates.set(1);
                if (validTypes == null || validTypes.contains(Token.TokenType.IDENTIFIER)) {
                    type = Token.TokenType.IDENTIFIER;
                }
            } else if (ch == 26 && (validTypes == null || validTypes.contains(Token.TokenType.CTRL_Z))) {
                type = Token.TokenType.CTRL_Z;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_MODULE_1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 8 || ch >= 14 && ch <= 27 || ch == 36 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 127 && ch <= 159 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_JAVA_MODULE_2, ch)) {
                nextStates.set(1);
                if (validTypes == null || validTypes.contains(Token.TokenType.IDENTIFIER)) {
                    type = Token.TokenType.IDENTIFIER;
                }
            }
            return type;
        }

        private static int[] NFA_MOVES_JAVA_MODULE_0_init() {
            return new int[]{36, 36, 65, 90, 95, 95, 97, 122, 162, 165, 170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1488, 1514, 1519, 1522, 1547, 1547, 1568, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2046, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2144, 2154, 2160, 2183, 2185, 2190, 2208, 2249, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2432, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2547, 2555, 2556, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2801, 2801, 2809, 2809, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3065, 3065, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3133, 3160, 3162, 3165, 3165, 3168, 3169, 3200, 3200, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3293, 3294, 3296, 3297, 3313, 3314, 3332, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3412, 3414, 3423, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3647, 3654, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5905, 5919, 5937, 5952, 5969, 5984, 5996, 5998, 6000, 6016, 6067, 6103, 6103, 6107, 6108, 6176, 6264, 6272, 6276, 6279, 6312, 6314, 6314, 6320, 6389, 6400, 6430, 6480, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6988, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7401, 7404, 7406, 7411, 7413, 7414, 7418, 7418, 7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8255, 8256, 8276, 8276, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11823, 11823, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539, 42560, 42606, 42623, 42653, 42656, 42735, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43064, 43064, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43261, 43262, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43488, 43492, 43494, 43503, 43514, 43518, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43638, 43642, 43642, 43646, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43741, 43744, 43754, 43762, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65284, 65284, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66176, 66204, 66208, 66256, 66304, 66335, 66349, 66378, 66384, 66421, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68096, 68112, 68115, 68117, 68119, 68121, 68149, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68324, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68899, 69248, 69289, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69445, 69488, 69505, 69552, 69572, 69600, 69622, 69635, 69687, 69745, 69746, 69749, 69749, 69763, 69807, 69840, 69864, 69891, 69926, 69956, 69956, 69959, 69959, 69968, 70002, 70006, 70006, 70019, 70066, 70081, 70084, 70106, 70106, 70108, 70108, 70144, 70161, 70163, 70187, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70366, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70461, 70461, 70480, 70480, 70493, 70497, 70656, 70708, 70727, 70730, 70751, 70753, 70784, 70831, 70852, 70853, 70855, 70855, 71040, 71086, 71128, 71131, 71168, 71215, 71236, 71236, 71296, 71338, 71352, 71352, 71424, 71450, 71488, 71494, 71680, 71723, 71840, 71903, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71983, 71999, 71999, 72001, 72001, 72096, 72103, 72106, 72144, 72161, 72161, 72163, 72163, 72192, 72192, 72203, 72242, 72250, 72250, 72272, 72272, 72284, 72329, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72750, 72768, 72768, 72818, 72847, 72960, 72966, 72968, 72969, 72971, 73008, 73030, 73030, 73056, 73061, 73063, 73064, 73066, 73097, 73112, 73112, 73440, 73458, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 82944, 83526, 92160, 92728, 92736, 92766, 92784, 92862, 92880, 92909, 92928, 92975, 92992, 92995, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94032, 94032, 94099, 94111, 94176, 94177, 94179, 94179, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 122624, 122654, 123136, 123180, 123191, 123197, 123214, 123214, 123536, 123565, 123584, 123627, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125184, 125251, 125259, 125259, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546};
        }

        private static int[] NFA_MOVES_JAVA_MODULE_2_init() {
            return new int[]{0, 8, 14, 27, 36, 36, 48, 57, 65, 90, 95, 95, 97, 122, 127, 159, 162, 165, 170, 170, 173, 173, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 768, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1155, 1159, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1488, 1514, 1519, 1522, 1536, 1541, 1547, 1547, 1552, 1562, 1564, 1564, 1568, 1641, 1646, 1747, 1749, 1757, 1759, 1768, 1770, 1788, 1791, 1791, 1807, 1866, 1869, 1969, 1984, 2037, 2042, 2042, 2045, 2093, 2112, 2139, 2144, 2154, 2160, 2183, 2185, 2190, 2192, 2193, 2200, 2403, 2406, 2415, 2417, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2500, 2503, 2504, 2507, 2510, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2547, 2555, 2556, 2558, 2558, 2561, 2563, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2649, 2652, 2654, 2654, 2662, 2677, 2689, 2691, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2787, 2790, 2799, 2801, 2801, 2809, 2815, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2876, 2884, 2887, 2888, 2891, 2893, 2901, 2903, 2908, 2909, 2911, 2915, 2918, 2927, 2929, 2929, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3024, 3024, 3031, 3031, 3046, 3055, 3065, 3065, 3072, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3132, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3160, 3162, 3165, 3165, 3168, 3171, 3174, 3183, 3200, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3260, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3293, 3294, 3296, 3299, 3302, 3311, 3313, 3314, 3328, 3340, 3342, 3344, 3346, 3396, 3398, 3400, 3402, 3406, 3412, 3415, 3423, 3427, 3430, 3439, 3450, 3455, 3457, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3558, 3567, 3570, 3571, 3585, 3642, 3647, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3807, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3948, 3953, 3972, 3974, 3991, 3993, 4028, 4038, 4038, 4096, 4169, 4176, 4253, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4957, 4959, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5909, 5919, 5940, 5952, 5971, 5984, 5996, 5998, 6000, 6002, 6003, 6016, 6099, 6103, 6103, 6107, 6109, 6112, 6121, 6155, 6169, 6176, 6264, 6272, 6314, 6320, 6389, 6400, 6430, 6432, 6443, 6448, 6459, 6470, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6608, 6617, 6656, 6683, 6688, 6750, 6752, 6780, 6783, 6793, 6800, 6809, 6823, 6823, 6832, 6845, 6847, 6862, 6912, 6988, 6992, 7001, 7019, 7027, 7040, 7155, 7168, 7223, 7232, 7241, 7245, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7376, 7378, 7380, 7418, 7424, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8203, 8207, 8234, 8238, 8255, 8256, 8276, 8276, 8288, 8292, 8294, 8303, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8400, 8412, 8417, 8417, 8421, 8432, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11647, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11744, 11775, 11823, 11823, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12348, 12353, 12438, 12441, 12442, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42539, 42560, 42607, 42612, 42621, 42623, 42737, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43047, 43052, 43052, 43064, 43064, 43072, 43123, 43136, 43205, 43216, 43225, 43232, 43255, 43259, 43259, 43261, 43309, 43312, 43347, 43360, 43388, 43392, 43456, 43471, 43481, 43488, 43518, 43520, 43574, 43584, 43597, 43600, 43609, 43616, 43638, 43642, 43714, 43739, 43741, 43744, 43759, 43762, 43766, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44010, 44012, 44013, 44016, 44025, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65024, 65039, 65056, 65071, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65279, 65279, 65284, 65284, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65529, 65531, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66045, 66045, 66176, 66204, 66208, 66256, 66272, 66272, 66304, 66335, 66349, 66378, 66384, 66426, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66720, 66729, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68099, 68101, 68102, 68108, 68115, 68117, 68119, 68121, 68149, 68152, 68154, 68159, 68159, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68326, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68903, 68912, 68921, 69248, 69289, 69291, 69292, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69456, 69488, 69509, 69552, 69572, 69600, 69622, 69632, 69702, 69734, 69749, 69759, 69818, 69821, 69821, 69826, 69826, 69837, 69837, 69840, 69864, 69872, 69881, 69888, 69940, 69942, 69951, 69956, 69959, 69968, 70003, 70006, 70006, 70016, 70084, 70089, 70092, 70094, 70106, 70108, 70108, 70144, 70161, 70163, 70199, 70206, 70206, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70378, 70384, 70393, 70400, 70403, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70459, 70468, 70471, 70472, 70475, 70477, 70480, 70480, 70487, 70487, 70493, 70499, 70502, 70508, 70512, 70516, 70656, 70730, 70736, 70745, 70750, 70753, 70784, 70853, 70855, 70855, 70864, 70873, 71040, 71093, 71096, 71104, 71128, 71133, 71168, 71232, 71236, 71236, 71248, 71257, 71296, 71352, 71360, 71369, 71424, 71450, 71453, 71467, 71472, 71481, 71488, 71494, 71680, 71738, 71840, 71913, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71989, 71991, 71992, 71995, 72003, 72016, 72025, 72096, 72103, 72106, 72151, 72154, 72161, 72163, 72164, 72192, 72254, 72263, 72263, 72272, 72345, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72758, 72760, 72768, 72784, 72793, 72818, 72847, 72850, 72871, 72873, 72886, 72960, 72966, 72968, 72969, 72971, 73014, 73018, 73018, 73020, 73021, 73023, 73031, 73040, 73049, 73056, 73061, 73063, 73064, 73066, 73102, 73104, 73105, 73107, 73112, 73120, 73129, 73440, 73462, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 78896, 78904, 82944, 83526, 92160, 92728, 92736, 92766, 92768, 92777, 92784, 92862, 92864, 92873, 92880, 92909, 92912, 92916, 92928, 92982, 92992, 92995, 93008, 93017, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94031, 94087, 94095, 94111, 94176, 94177, 94179, 94180, 94192, 94193, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 113821, 113822, 113824, 113827, 118528, 118573, 118576, 118598, 119141, 119145, 119149, 119170, 119173, 119179, 119210, 119213, 119362, 119364, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 120782, 120831, 121344, 121398, 121403, 121452, 121461, 121461, 121476, 121476, 121499, 121503, 121505, 121519, 122624, 122654, 122880, 122886, 122888, 122904, 122907, 122913, 122915, 122916, 122918, 122922, 123136, 123180, 123184, 123197, 123200, 123209, 123214, 123214, 123536, 123566, 123584, 123641, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125136, 125142, 125184, 125259, 125264, 125273, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 130032, 130041, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546, 917505, 917505, 917536, 917631, 917760, 917999};
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{JAVA_MODULE::NFA_JAVA_MODULE_0, JAVA_MODULE::NFA_JAVA_MODULE_1};
            functionTableMap.put(LexicalState.JAVA_MODULE, functions);
        }
    }

    private static class IN_SINGLE_LINE_COMMENT {
        private IN_SINGLE_LINE_COMMENT() {
        }

        private static Token.TokenType NFA_IN_SINGLE_LINE_COMMENT_0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 13) {
                nextStates.set(1);
            }
            if (ch >= 0 && (validTypes == null || validTypes.contains(Token.TokenType.ANY_CHAR))) {
                type = Token.TokenType.ANY_CHAR;
            }
            if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_LINE_COMMENT)) {
                    type = Token.TokenType.SINGLE_LINE_COMMENT;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_LINE_COMMENT)) {
                    type = Token.TokenType.SINGLE_LINE_COMMENT;
                }
            } else if (ch == 26 && (validTypes == null || validTypes.contains(Token.TokenType.CTRL_Z))) {
                type = Token.TokenType.CTRL_Z;
            }
            return type;
        }

        private static Token.TokenType NFA_IN_SINGLE_LINE_COMMENT_1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 10 && (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_LINE_COMMENT))) {
                type = Token.TokenType.SINGLE_LINE_COMMENT;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{IN_SINGLE_LINE_COMMENT::NFA_IN_SINGLE_LINE_COMMENT_0, IN_SINGLE_LINE_COMMENT::NFA_IN_SINGLE_LINE_COMMENT_1};
            functionTableMap.put(LexicalState.IN_SINGLE_LINE_COMMENT, functions);
        }
    }

    private static class IN_MULTI_LINE_COMMENT {
        private IN_MULTI_LINE_COMMENT() {
        }

        private static Token.TokenType NFA_IN_MULTI_LINE_COMMENT_0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 42) {
                nextStates.set(1);
            }
            if (ch >= 0 && (validTypes == null || validTypes.contains(Token.TokenType.ANY_CHAR))) {
                type = Token.TokenType.ANY_CHAR;
            }
            if (ch == 26 && (validTypes == null || validTypes.contains(Token.TokenType.CTRL_Z))) {
                type = Token.TokenType.CTRL_Z;
            }
            return type;
        }

        private static Token.TokenType NFA_IN_MULTI_LINE_COMMENT_1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 47 && (validTypes == null || validTypes.contains(Token.TokenType.MULTI_LINE_COMMENT))) {
                type = Token.TokenType.MULTI_LINE_COMMENT;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{IN_MULTI_LINE_COMMENT::NFA_IN_MULTI_LINE_COMMENT_0, IN_MULTI_LINE_COMMENT::NFA_IN_MULTI_LINE_COMMENT_1};
            functionTableMap.put(LexicalState.IN_MULTI_LINE_COMMENT, functions);
        }
    }

    private static class IN_UNPARSED_CODE_BLOCK {
        private IN_UNPARSED_CODE_BLOCK() {
        }

        private static Token.TokenType NFA_IN_UNPARSED_CODE_BLOCK_0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 36) {
                nextStates.set(1);
                nextStates.set(2);
            } else if (ch == 26 && (validTypes == null || validTypes.contains(Token.TokenType.CTRL_Z))) {
                type = Token.TokenType.CTRL_Z;
            }
            if (ch >= 0 && ch <= 35 || ch >= 37) {
                nextStates.set(3);
                if (validTypes == null || validTypes.contains(Token.TokenType.UNPARSED_CONTENT)) {
                    type = Token.TokenType.UNPARSED_CONTENT;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_IN_UNPARSED_CODE_BLOCK_1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 36) {
                nextStates.set(1);
            }
            if (ch >= 0 && ch <= 124 || ch >= 126) {
                nextStates.set(3);
                if (validTypes == null || validTypes.contains(Token.TokenType.UNPARSED_CONTENT)) {
                    type = Token.TokenType.UNPARSED_CONTENT;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_IN_UNPARSED_CODE_BLOCK_2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 125 && (validTypes == null || validTypes.contains(Token.TokenType.END_UNPARSED))) {
                type = Token.TokenType.END_UNPARSED;
            }
            return type;
        }

        private static Token.TokenType NFA_IN_UNPARSED_CODE_BLOCK_3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 36) {
                nextStates.set(1);
            } else if (ch >= 0 && ch <= 35 || ch >= 37) {
                nextStates.set(3);
                if (validTypes == null || validTypes.contains(Token.TokenType.UNPARSED_CONTENT)) {
                    type = Token.TokenType.UNPARSED_CONTENT;
                }
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{IN_UNPARSED_CODE_BLOCK::NFA_IN_UNPARSED_CODE_BLOCK_0, IN_UNPARSED_CODE_BLOCK::NFA_IN_UNPARSED_CODE_BLOCK_1, IN_UNPARSED_CODE_BLOCK::NFA_IN_UNPARSED_CODE_BLOCK_2, IN_UNPARSED_CODE_BLOCK::NFA_IN_UNPARSED_CODE_BLOCK_3};
            functionTableMap.put(LexicalState.IN_UNPARSED_CODE_BLOCK, functions);
        }
    }

    private static class JAVA {
        private static int[] NFA_MOVES_JAVA_793 = JAVA.NFA_MOVES_JAVA_793_init();
        private static int[] NFA_MOVES_JAVA_885 = JAVA.NFA_MOVES_JAVA_885_init();

        private JAVA() {
        }

        private static Token.TokenType NFA_JAVA_0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 33) {
                nextStates.set(282);
            } else if (ch == 34) {
                nextStates.set(337);
                nextStates.set(425);
            } else if (ch == 37) {
                nextStates.set(154);
            } else if (ch == 38) {
                nextStates.set(49);
                nextStates.set(699);
            } else if (ch == 39) {
                nextStates.set(175);
                nextStates.set(669);
            } else if (ch == 42) {
                nextStates.set(171);
            } else if (ch == 43) {
                nextStates.set(116);
                nextStates.set(257);
            } else if (ch == 45) {
                nextStates.set(272);
                nextStates.set(336);
                nextStates.set(456);
            } else if (ch == 46) {
                nextStates.set(99);
                nextStates.set(372);
            } else if (ch == 47) {
                nextStates.set(196);
                nextStates.set(247);
                nextStates.set(653);
            } else if (ch == 48) {
                nextStates.set(292);
                nextStates.set(57);
                nextStates.set(496);
                nextStates.set(232);
                nextStates.set(309);
                nextStates.set(125);
                nextStates.set(495);
                nextStates.set(331);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(211);
                nextStates.set(528);
                nextStates.set(77);
                nextStates.set(399);
            } else if (ch == 58) {
                nextStates.set(562);
            } else if (ch == 60) {
                nextStates.set(493);
                nextStates.set(308);
                nextStates.set(289);
            } else if (ch == 61) {
                nextStates.set(654);
                nextStates.set(648);
                nextStates.set(338);
            } else if (ch == 62) {
                nextStates.set(271);
                nextStates.set(678);
                nextStates.set(40);
                nextStates.set(489);
                nextStates.set(189);
            } else if (ch == 65) {
                nextStates.set(534);
                nextStates.set(596);
                nextStates.set(112);
                nextStates.set(578);
            } else if (ch == 67) {
                nextStates.set(300);
            } else if (ch == 68) {
                nextStates.set(705);
            } else if (ch == 69) {
                nextStates.set(570);
            } else if (ch == 70) {
                nextStates.set(582);
            } else if (ch == 73) {
                nextStates.set(448);
                nextStates.set(357);
                nextStates.set(666);
                nextStates.set(280);
                nextStates.set(476);
            } else if (ch == 76) {
                nextStates.set(505);
            } else if (ch == 77) {
                nextStates.set(646);
            } else if (ch == 79) {
                nextStates.set(104);
            } else if (ch == 82) {
                nextStates.set(414);
                nextStates.set(423);
                nextStates.set(281);
            } else if (ch == 83) {
                nextStates.set(226);
                nextStates.set(401);
                nextStates.set(657);
            } else if (ch == 84) {
                nextStates.set(236);
            } else if (ch == 85) {
                nextStates.set(310);
                nextStates.set(509);
            } else if (ch == 94) {
                nextStates.set(408);
            } else if (ch == 97) {
                nextStates.set(109);
                nextStates.set(643);
            } else if (ch == 98) {
                nextStates.set(593);
                nextStates.set(473);
                nextStates.set(506);
            } else if (ch == 99) {
                nextStates.set(512);
                nextStates.set(101);
                nextStates.set(156);
                nextStates.set(34);
                nextStates.set(707);
                nextStates.set(548);
            } else if (ch == 100) {
                nextStates.set(144);
                nextStates.set(567);
                nextStates.set(511);
            } else if (ch == 101) {
                nextStates.set(411);
                nextStates.set(488);
                nextStates.set(41);
                nextStates.set(131);
            } else if (ch == 102) {
                nextStates.set(134);
                nextStates.set(612);
                nextStates.set(221);
                nextStates.set(340);
                nextStates.set(123);
            } else if (ch == 103) {
                nextStates.set(38);
            } else if (ch == 105) {
                nextStates.set(346);
                nextStates.set(640);
                nextStates.set(679);
                nextStates.set(387);
                nextStates.set(20);
                nextStates.set(202);
            } else if (ch == 108) {
                nextStates.set(169);
            } else if (ch == 109) {
                nextStates.set(702);
            } else if (ch == 110) {
                nextStates.set(397);
                nextStates.set(632);
                nextStates.set(135);
                nextStates.set(628);
            } else if (ch == 111) {
                nextStates.set(656);
                nextStates.set(561);
            } else if (ch == 112) {
                nextStates.set(630);
                nextStates.set(564);
                nextStates.set(32);
                nextStates.set(3);
                nextStates.set(108);
                nextStates.set(536);
            } else if (ch == 114) {
                nextStates.set(454);
                nextStates.set(385);
                nextStates.set(291);
            } else if (ch == 115) {
                nextStates.set(96);
                nextStates.set(513);
                nextStates.set(168);
                nextStates.set(676);
                nextStates.set(139);
                nextStates.set(563);
                nextStates.set(629);
            } else if (ch == 116) {
                nextStates.set(103);
                nextStates.set(364);
                nextStates.set(153);
                nextStates.set(590);
                nextStates.set(350);
                nextStates.set(15);
                nextStates.set(115);
                nextStates.set(81);
            } else if (ch == 117) {
                nextStates.set(246);
            } else if (ch == 118) {
                nextStates.set(690);
                nextStates.set(485);
                nextStates.set(317);
            } else if (ch == 119) {
                nextStates.set(466);
                nextStates.set(54);
                nextStates.set(64);
            } else if (ch == 121) {
                nextStates.set(279);
            } else if (ch == 123) {
                nextStates.set(459);
            } else if (ch == 124) {
                nextStates.set(43);
                nextStates.set(517);
            }
            if (ch == 36 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_JAVA_793, ch)) {
                nextStates.set(652);
                if (validTypes == null || validTypes.contains(Token.TokenType.IDENTIFIER)) {
                    type = Token.TokenType.IDENTIFIER;
                }
            } else if (ch == 37) {
                if (validTypes == null || validTypes.contains(Token.TokenType.REM)) {
                    type = Token.TokenType.REM;
                }
            } else if (ch == 94) {
                if (validTypes == null || validTypes.contains(Token.TokenType.XOR)) {
                    type = Token.TokenType.XOR;
                }
            } else if (ch == 124) {
                if (validTypes == null || validTypes.contains(Token.TokenType.BIT_OR)) {
                    type = Token.TokenType.BIT_OR;
                }
            } else if (ch == 38) {
                if (validTypes == null || validTypes.contains(Token.TokenType.BIT_AND)) {
                    type = Token.TokenType.BIT_AND;
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SLASH)) {
                    type = Token.TokenType.SLASH;
                }
            } else if (ch == 42) {
                if (validTypes == null || validTypes.contains(Token.TokenType.STAR)) {
                    type = Token.TokenType.STAR;
                }
            } else if (ch == 45) {
                if (validTypes == null || validTypes.contains(Token.TokenType.MINUS)) {
                    type = Token.TokenType.MINUS;
                }
            } else if (ch == 43) {
                if (validTypes == null || validTypes.contains(Token.TokenType.PLUS)) {
                    type = Token.TokenType.PLUS;
                }
            } else if (ch == 58) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COLON)) {
                    type = Token.TokenType.COLON;
                }
            } else if (ch == 63) {
                if (validTypes == null || validTypes.contains(Token.TokenType.HOOK)) {
                    type = Token.TokenType.HOOK;
                }
            } else if (ch == 126) {
                if (validTypes == null || validTypes.contains(Token.TokenType.TILDE)) {
                    type = Token.TokenType.TILDE;
                }
            } else if (ch == 33) {
                if (validTypes == null || validTypes.contains(Token.TokenType.BANG)) {
                    type = Token.TokenType.BANG;
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LT)) {
                    type = Token.TokenType.LT;
                }
            } else if (ch == 62) {
                if (validTypes == null || validTypes.contains(Token.TokenType.GT)) {
                    type = Token.TokenType.GT;
                }
            } else if (ch == 61) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ASSIGN)) {
                    type = Token.TokenType.ASSIGN;
                }
            } else if (ch == 64) {
                if (validTypes == null || validTypes.contains(Token.TokenType.AT)) {
                    type = Token.TokenType.AT;
                }
            } else if (ch == 46) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DOT)) {
                    type = Token.TokenType.DOT;
                }
            } else if (ch == 44) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COMMA)) {
                    type = Token.TokenType.COMMA;
                }
            } else if (ch == 59) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SEMICOLON)) {
                    type = Token.TokenType.SEMICOLON;
                }
            } else if (ch == 93) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RBRACKET)) {
                    type = Token.TokenType.RBRACKET;
                }
            } else if (ch == 91) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LBRACKET)) {
                    type = Token.TokenType.LBRACKET;
                }
            } else if (ch == 125) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RBRACE)) {
                    type = Token.TokenType.RBRACE;
                }
            } else if (ch == 123) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LBRACE)) {
                    type = Token.TokenType.LBRACE;
                }
            } else if (ch == 41) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RPAREN)) {
                    type = Token.TokenType.RPAREN;
                }
            } else if (ch == 40) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LPAREN)) {
                    type = Token.TokenType.LPAREN;
                }
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(428);
                if (validTypes == null || validTypes.contains(Token.TokenType.INTEGER_LITERAL)) {
                    type = Token.TokenType.INTEGER_LITERAL;
                }
            }
            if (ch == 95) {
                if (validTypes == null || validTypes.contains(Token.TokenType.UNDERSCORE)) {
                    type = Token.TokenType.UNDERSCORE;
                }
            } else if (ch == 26) {
                if (validTypes == null || validTypes.contains(Token.TokenType.CTRL_Z)) {
                    type = Token.TokenType.CTRL_Z;
                }
            } else if (ch == 9) {
                nextStates.set(339);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 10) {
                nextStates.set(339);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 12) {
                nextStates.set(339);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 13) {
                nextStates.set(339);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 32) {
                nextStates.set(339);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 92) {
                if (validTypes == null || validTypes.contains(Token.TokenType.BACKSLASH)) {
                    type = Token.TokenType.BACKSLASH;
                }
            } else if (ch == 35 && (validTypes == null || validTypes.contains(Token.TokenType.HASH))) {
                type = Token.TokenType.HASH;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(318);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 && (validTypes == null || validTypes.contains(Token.TokenType._RECOVER_TO))) {
                type = Token.TokenType._RECOVER_TO;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(672);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73) {
                nextStates.set(203);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(540);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(46);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100) {
                nextStates.set(664);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(286);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(649);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(663);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104 && (validTypes == null || validTypes.contains(Token.TokenType.CATCH))) {
                type = Token.TokenType.CATCH;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 && (validTypes == null || validTypes.contains(Token.TokenType._MORE))) {
                type = Token.TokenType._MORE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 70 && (validTypes == null || validTypes.contains(Token.TokenType._EOF))) {
                type = Token.TokenType._EOF;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(5);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(538);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111 && (validTypes == null || validTypes.contains(Token.TokenType.TO))) {
                type = Token.TokenType.TO;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(568);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(325);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62 && (validTypes == null || validTypes.contains(Token.TokenType.RUNSIGNEDSHIFT))) {
                type = Token.TokenType.RUNSIGNEDSHIFT;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(426);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102 && (validTypes == null || validTypes.contains(Token.TokenType.IF))) {
                type = Token.TokenType.IF;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(366);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(177);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(500);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(224);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(662);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(50);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(Token.TokenType.SYNCHRONIZED))) {
                type = Token.TokenType.SYNCHRONIZED;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(635);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(22);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(471);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(412);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34 || ch == 39 || ch == 92 || ch == 98 || ch == 102 || ch == 110 || ch >= 114 && ch <= 116) {
                nextStates.set(225);
            } else if (ch >= 48 && ch <= 51) {
                nextStates.set(180);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(577);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(386);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(409);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(571);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 && (validTypes == null || validTypes.contains(Token.TokenType._UNCACHE_TOKENS))) {
                type = Token.TokenType._UNCACHE_TOKENS;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73) {
                nextStates.set(295);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43) {
                nextStates.set(490);
            } else if (ch == 124 && (validTypes == null || validTypes.contains(Token.TokenType.UP_TO_HERE))) {
                type = Token.TokenType.UP_TO_HERE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(381);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.MODULE))) {
                type = Token.TokenType.MODULE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                nextStates.set(18);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(686);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(606);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 124 && (validTypes == null || validTypes.contains(Token.TokenType.SC_OR))) {
                type = Token.TokenType.SC_OR;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(Token.TokenType.BOOLEAN))) {
                type = Token.TokenType.BOOLEAN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_45(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(464);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_46(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(269);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_47(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(620);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_48(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(358);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_49(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.ANDASSIGN))) {
                type = Token.TokenType.ANDASSIGN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_50(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.OPENS))) {
                type = Token.TokenType.OPENS;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_51(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(519);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_52(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(29);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_53(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55 || ch == 95) {
                nextStates.set(53);
            }
            if (ch >= 48 && ch <= 55 && (validTypes == null || validTypes.contains(Token.TokenType.INTEGER_LITERAL))) {
                type = Token.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_54(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(83);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_55(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.NATIVE))) {
                type = Token.TokenType.NATIVE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_56(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 86) {
                nextStates.set(695);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_57(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 66 || ch == 98) {
                nextStates.set(585);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_58(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(Token.TokenType.RECORD))) {
                type = Token.TokenType.RECORD;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_59(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(259);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_60(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77) {
                nextStates.set(498);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_61(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(598);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_62(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(11);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_63(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(231);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_64(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(344);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_65(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(611);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_66(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(634);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_67(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73) {
                nextStates.set(148);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_68(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(Token.TokenType.LONG_LITERAL))) {
                type = Token.TokenType.LONG_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_69(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34 || ch == 39 || ch == 92 || ch == 98 || ch == 102 || ch == 110 || ch >= 114 && ch <= 116) {
                nextStates.set(233);
            } else if (ch >= 48 && ch <= 51) {
                nextStates.set(625);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(79);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_70(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(70);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(136);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_71(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(71);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(430);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_72(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 89) {
                nextStates.set(243);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_73(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 && (validTypes == null || validTypes.contains(Token.TokenType._UNPARSED))) {
                type = Token.TokenType._UNPARSED;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_74(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(519);
            } else if (ch == 34) {
                nextStates.set(405);
                nextStates.set(437);
                nextStates.set(689);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(519);
            } else if (ch == 92) {
                nextStates.set(312);
                nextStates.set(145);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_75(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(484);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_76(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(102);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_77(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(28);
            }
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(696);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(22);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_78(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(212);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_79(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(233);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(233);
            } else if (ch == 92) {
                nextStates.set(368);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_QUOTE_STRING))) {
                type = Token.TokenType.SINGLE_QUOTE_STRING;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_80(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(474);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_81(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(438);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_82(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77) {
                nextStates.set(532);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_83(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(440);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_84(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 71) {
                nextStates.set(542);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_85(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83) {
                nextStates.set(294);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_86(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68) {
                nextStates.set(434);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_87(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(569);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_88(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(332);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_89(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 && (validTypes == null || validTypes.contains(Token.TokenType._LEXICAL_STATE))) {
                type = Token.TokenType._LEXICAL_STATE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_90(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(10);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_91(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(233);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(233);
            } else if (ch == 92) {
                nextStates.set(368);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_QUOTE_STRING))) {
                type = Token.TokenType.SINGLE_QUOTE_STRING;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_92(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(98);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(185);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_93(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(290);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_94(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(398);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_95(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(152);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_96(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 119) {
                nextStates.set(88);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_97(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 && (validTypes == null || validTypes.contains(Token.TokenType._FAIL))) {
                type = Token.TokenType._FAIL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_98(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(128);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(606);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_99(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(508);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_100(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(465);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_101(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(301);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_102(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104 && (validTypes == null || validTypes.contains(Token.TokenType.WITH))) {
                type = Token.TokenType.WITH;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_103(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(442);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_104(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(80);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_105(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99 && (validTypes == null || validTypes.contains(Token.TokenType.STATIC))) {
                type = Token.TokenType.STATIC;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_106(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(132);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_107(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73) {
                nextStates.set(284);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_108(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(608);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_109(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 98) {
                nextStates.set(433);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_110(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(30);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_111(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.PRIVATE))) {
                type = Token.TokenType.PRIVATE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_112(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(416);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_113(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(655);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_114(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(711);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_115(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(181);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_116(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 && (validTypes == null || validTypes.contains(Token.TokenType.INCR))) {
                type = Token.TokenType.INCR;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_117(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(192);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_118(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(260);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_119(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(119);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(193);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_120(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(417);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_121(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76) {
                nextStates.set(1);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_122(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(92);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_123(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(586);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_124(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.LSHIFTASSIGN))) {
                type = Token.TokenType.LSHIFTASSIGN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_125(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 88 || ch == 120) {
                nextStates.set(641);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_126(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(458);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(709);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_127(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76) {
                nextStates.set(197);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_128(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(606);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_129(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.INTERFACE))) {
                type = Token.TokenType.INTERFACE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_130(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(Token.TokenType.NON_SEALED))) {
                type = Token.TokenType.NON_SEALED;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_131(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 120) {
                nextStates.set(651);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_132(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(187);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_133(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(302);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_134(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(378);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_135(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(201);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_136(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(451);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_137(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34 || ch == 39 || ch == 92 || ch == 98 || ch == 102 || ch == 110 || ch >= 114 && ch <= 116) {
                nextStates.set(337);
            } else if (ch >= 48 && ch <= 51) {
                nextStates.set(198);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(694);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_138(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 && (validTypes == null || validTypes.contains(Token.TokenType._ACTIVATE_TOKENS))) {
                type = Token.TokenType._ACTIVATE_TOKENS;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_139(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(207);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_140(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 && (validTypes == null || validTypes.contains(Token.TokenType._CONTEXTUAL_KEYWORD))) {
                type = Token.TokenType._CONTEXTUAL_KEYWORD;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_141(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(82);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_142(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(445);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_143(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType.TRANSIENT))) {
                type = Token.TokenType.TRANSIENT;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_144(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111 && (validTypes == null || validTypes.contains(Token.TokenType.DO))) {
                type = Token.TokenType.DO;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_145(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 10) {
                nextStates.set(519);
            } else if (ch == 13) {
                nextStates.set(519);
                nextStates.set(161);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_146(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(345);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_147(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114 && (validTypes == null || validTypes.contains(Token.TokenType.SUPER))) {
                type = Token.TokenType.SUPER;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_148(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(245);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_149(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(583);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_150(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(526);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_151(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.RSIGNEDSHIFTASSIGN))) {
                type = Token.TokenType.RSIGNEDSHIFTASSIGN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_152(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(17);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_153(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(8);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_154(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.REMASSIGN))) {
                type = Token.TokenType.REMASSIGN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_155(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(Token.TokenType.PROTECTED))) {
                type = Token.TokenType.PROTECTED;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_156(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(374);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_157(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(379);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(9);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_158(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112 && (validTypes == null || validTypes.contains(Token.TokenType.STRICTFP))) {
                type = Token.TokenType.STRICTFP;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_159(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80) {
                nextStates.set(121);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_160(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111 && (validTypes == null || validTypes.contains(Token.TokenType.GOTO))) {
                type = Token.TokenType.GOTO;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_161(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 10) {
                nextStates.set(519);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_162(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(516);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(126);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_163(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(550);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_164(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(453);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_165(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                nextStates.set(638);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_166(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(313);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_167(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 107) {
                nextStates.set(450);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_168(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 121) {
                nextStates.set(403);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_169(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(393);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_170(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 119) {
                nextStates.set(475);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_171(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.STARASSIGN))) {
                type = Token.TokenType.STARASSIGN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_172(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(268);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_173(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN))) {
                type = Token.TokenType._TOKEN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_174(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(Token.TokenType.NULL))) {
                type = Token.TokenType.NULL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_175(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(253);
            } else if (ch == 92) {
                nextStates.set(614);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_176(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(617);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_177(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(500);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_178(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(106);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_179(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(712);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_180(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(415);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_181(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 121 && (validTypes == null || validTypes.contains(Token.TokenType.TRY))) {
                type = Token.TokenType.TRY;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_182(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(130);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_183(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114 && (validTypes == null || validTypes.contains(Token.TokenType.CHAR))) {
                type = Token.TokenType.CHAR;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_184(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(267);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_185(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(304);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(98);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(439);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_186(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 118) {
                nextStates.set(249);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_187(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(589);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_188(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(68);
            }
            if (ch >= 48 && ch <= 55 || ch == 95) {
                nextStates.set(188);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_189(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62 && (validTypes == null || validTypes.contains(Token.TokenType.RSIGNEDSHIFT))) {
                type = Token.TokenType.RSIGNEDSHIFT;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_190(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(389);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_191(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(370);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_192(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(214);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_193(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(684);
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_194(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(117);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_195(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 && (validTypes == null || validTypes.contains(Token.TokenType._ATTEMPT))) {
                type = Token.TokenType._ATTEMPT;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_196(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.SLASHASSIGN))) {
                type = Token.TokenType.SLASHASSIGN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_197(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(522);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_198(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(462);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_199(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(319);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_200(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 119 && (validTypes == null || validTypes.contains(Token.TokenType.NEW))) {
                type = Token.TokenType.NEW;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_201(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(174);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_202(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(241);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_203(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(127);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_204(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(Token.TokenType.FINAL))) {
                type = Token.TokenType.FINAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_205(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80) {
                nextStates.set(455);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_206(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(478);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_207(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(248);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_208(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(39);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_209(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(382);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(162);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_210(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83) {
                nextStates.set(333);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_211(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(122);
            }
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(549);
            } else if (ch == 46) {
                nextStates.set(92);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_212(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(520);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_213(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 && (validTypes == null || validTypes.contains(Token.TokenType._INCLUDE))) {
                type = Token.TokenType._INCLUDE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_214(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(421);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_215(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 && (validTypes == null || validTypes.contains(Token.TokenType._INJECT))) {
                type = Token.TokenType._INJECT;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_216(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(530);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_217(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(691);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_218(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 72) {
                nextStates.set(335);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_219(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 103) {
                nextStates.set(311);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_220(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(701);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_221(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(703);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_222(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(287);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_223(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(487);
            } else if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(266);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(613);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_224(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(341);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_225(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.CHARACTER_LITERAL))) {
                type = Token.TokenType.CHARACTER_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_226(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(432);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_227(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(206);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_228(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(602);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_229(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(215);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_230(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(230);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(68);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_231(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(62);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_232(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 88 || ch == 120) {
                nextStates.set(262);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_233(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(233);
            } else if (ch == 92) {
                nextStates.set(368);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_QUOTE_STRING))) {
                type = Token.TokenType.SINGLE_QUOTE_STRING;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_234(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(60);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_235(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.THIS))) {
                type = Token.TokenType.THIS;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_236(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(555);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_237(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(4);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_238(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(380);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_239(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.CONTINUE))) {
                type = Token.TokenType.CONTINUE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_240(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(446);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_241(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(52);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_242(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(227);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_243(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 87) {
                nextStates.set(113);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_244(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(142);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_245(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(659);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_246(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(61);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_247(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 42 && (validTypes == null || validTypes.contains(Token.TokenType.MULTI_LINE_COMMENT_START))) {
                type = Token.TokenType.MULTI_LINE_COMMENT_START;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_248(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(147);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_249(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(491);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_250(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(95);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_251(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(143);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_252(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(303);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_253(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(233);
            } else if (ch == 92) {
                nextStates.set(69);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_254(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(369);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_255(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(6);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_256(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(396);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_257(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.PLUSASSIGN))) {
                type = Token.TokenType.PLUSASSIGN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_258(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType._DEFAULT))) {
                type = Token.TokenType._DEFAULT;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_259(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType._ASSERT))) {
                type = Token.TokenType._ASSERT;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_260(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(166);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_261(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 && (validTypes == null || validTypes.contains(Token.TokenType._RECOVER))) {
                type = Token.TokenType._RECOVER;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_262(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(645);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_263(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(71);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(430);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(157);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_264(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(Token.TokenType.VOID))) {
                type = Token.TokenType.VOID;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_265(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.BYTE))) {
                type = Token.TokenType.BYTE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_266(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(266);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(613);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_267(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(595);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_268(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(342);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_269(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType._IMPORT))) {
                type = Token.TokenType._IMPORT;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_270(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(443);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_271(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                nextStates.set(165);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_272(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45 && (validTypes == null || validTypes.contains(Token.TokenType.DECR))) {
                type = Token.TokenType.DECR;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_273(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(63);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_274(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(588);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_275(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(265);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_276(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(467);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_277(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(2);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_278(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(603);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_279(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(553);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_280(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 71) {
                nextStates.set(23);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_281(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(48);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_282(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.NE))) {
                type = Token.TokenType.NE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_283(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73) {
                nextStates.set(97);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_284(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 86) {
                nextStates.set(254);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_285(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(497);
            }
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(285);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_286(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(170);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_287(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(114);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_288(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(222);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_289(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.LE))) {
                type = Token.TokenType.LE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_290(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(218);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_291(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(667);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_292(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(53);
                if (validTypes == null || validTypes.contains(Token.TokenType.INTEGER_LITERAL)) {
                    type = Token.TokenType.INTEGER_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_293(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(239);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_294(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(73);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_295(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 86) {
                nextStates.set(94);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_296(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(419);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_297(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(670);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_298(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46 && (validTypes == null || validTypes.contains(Token.TokenType.VAR_ARGS))) {
                type = Token.TokenType.VAR_ARGS;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_299(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(297);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_300(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(299);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_301(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(533);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_302(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(400);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_303(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 && (validTypes == null || validTypes.contains(Token.TokenType._UNPARSED))) {
                type = Token.TokenType._UNPARSED;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_304(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(304);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(439);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_305(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(176);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_306(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85) {
                nextStates.set(86);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_307(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 118) {
                nextStates.set(329);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_308(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 60) {
                nextStates.set(124);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_309(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 88 || ch == 120) {
                nextStates.set(420);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_310(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(431);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_311(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.PACKAGE))) {
                type = Token.TokenType.PACKAGE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_312(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34 || ch == 39 || ch == 92 || ch == 98 || ch == 102 || ch == 110 || ch >= 114 && ch <= 116) {
                nextStates.set(519);
            } else if (ch >= 48 && ch <= 51) {
                nextStates.set(525);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(74);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_313(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(66);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_314(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(573);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_315(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(27);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_316(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(Token.TokenType.RETURN))) {
                type = Token.TokenType.RETURN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_317(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(546);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_318(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(392);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_319(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73) {
                nextStates.set(636);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_320(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(173);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_321(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(673);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_322(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(552);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_323(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(323);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(502);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_324(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48 || ch == 49) {
                nextStates.set(68);
            }
            if (ch == 48 || ch == 49 || ch == 95) {
                nextStates.set(324);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_325(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(158);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_326(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 107 && (validTypes == null || validTypes.contains(Token.TokenType.BREAK))) {
                type = Token.TokenType.BREAK;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_327(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 88) {
                nextStates.set(67);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_328(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(314);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_329(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.TRANSITIVE))) {
                type = Token.TokenType.TRANSITIVE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_330(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(87);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_331(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 88 || ch == 120) {
                nextStates.set(383);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_332(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(296);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_333(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(256);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_334(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 103 && (validTypes == null || validTypes.contains(Token.TokenType.LONG))) {
                type = Token.TokenType.LONG;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_335(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(228);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_336(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.MINUSASSIGN))) {
                type = Token.TokenType.MINUSASSIGN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_337(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(337);
            } else if (ch == 92) {
                nextStates.set(137);
            } else if (ch == 34 && (validTypes == null || validTypes.contains(Token.TokenType.STRING_LITERAL))) {
                type = Token.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_338(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62 && (validTypes == null || validTypes.contains(Token.TokenType.RIGHT_ARROW))) {
                type = Token.TokenType.RIGHT_ARROW;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_339(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9) {
                nextStates.set(339);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 10) {
                nextStates.set(339);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 12) {
                nextStates.set(339);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 13) {
                nextStates.set(339);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 32) {
                nextStates.set(339);
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_340(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(377);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_341(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(713);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_342(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.PERMITS))) {
                type = Token.TokenType.PERMITS;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_343(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 12 || ch == 32) {
                nextStates.set(343);
            } else if (ch == 10) {
                nextStates.set(519);
            } else if (ch == 13) {
                nextStates.set(633);
                nextStates.set(519);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_344(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(668);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_345(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(190);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_346(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(100);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_347(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(375);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_348(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76) {
                nextStates.set(472);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_349(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(150);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_350(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(601);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_351(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(351);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(209);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_352(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(361);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_353(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83) {
                nextStates.set(618);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_354(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(468);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_355(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(Token.TokenType.YIELD))) {
                type = Token.TokenType.YIELD;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_356(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(347);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_357(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(13);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_358(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(56);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_359(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(483);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_360(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(463);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_361(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(65);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_362(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(504);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_363(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 121 && (validTypes == null || validTypes.contains(Token.TokenType.FINALLY))) {
                type = Token.TokenType.FINALLY;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_364(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(486);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_365(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.TRUE))) {
                type = Token.TokenType.TRUE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_366(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(Token.TokenType.SEALED))) {
                type = Token.TokenType.SEALED;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_367(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(59);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_368(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34 || ch == 39 || ch == 92 || ch == 98 || ch == 102 || ch == 110 || ch >= 114 && ch <= 116) {
                nextStates.set(233);
            } else if (ch >= 48 && ch <= 51) {
                nextStates.set(514);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(91);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_369(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(619);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_370(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.VOLATILE))) {
                type = Token.TokenType.VOLATILE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_371(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(500);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_372(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(298);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_373(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(623);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_374(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(183);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_375(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102 && (validTypes == null || validTypes.contains(Token.TokenType.INSTANCEOF))) {
                type = Token.TokenType.INSTANCEOF;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_376(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 119 && (validTypes == null || validTypes.contains(Token.TokenType.THROW))) {
                type = Token.TokenType.THROW;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_377(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(565);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_378(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(685);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_379(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(9);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_380(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(184);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_381(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(160);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_382(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(162);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_383(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(693);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_384(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(395);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_385(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(708);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_386(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 98) {
                nextStates.set(244);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_387(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(524);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_388(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(141);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_389(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(293);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_390(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(515);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_391(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.FALSE))) {
                type = Token.TokenType.FALSE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_392(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(597);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_393(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(334);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_394(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(394);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(371);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_395(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN))) {
                type = Token.TokenType._TOKEN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_396(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 && (validTypes == null || validTypes.contains(Token.TokenType._ENSURE))) {
                type = Token.TokenType._ENSURE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_397(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(545);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_398(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(328);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_399(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(683);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(68);
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(Token.TokenType.LONG_LITERAL))) {
                type = Token.TokenType.LONG_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_400(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 && (validTypes == null || validTypes.contains(Token.TokenType._ACTIVE_TOKENS))) {
                type = Token.TokenType._ACTIVE_TOKENS;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_401(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80) {
                nextStates.set(527);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_402(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(391);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_403(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(330);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_404(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(482);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_405(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34) {
                nextStates.set(710);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_406(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(316);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_407(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(26);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_408(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.XORASSIGN))) {
                type = Token.TokenType.XORASSIGN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_409(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 118) {
                nextStates.set(55);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_410(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(353);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_411(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 120) {
                nextStates.set(698);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_412(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType.ABSTRACT))) {
                type = Token.TokenType.ABSTRACT;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_413(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(233);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_414(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(305);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_415(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(225);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_416(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(234);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_417(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100) {
                nextStates.set(592);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_418(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(33);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_419(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104 && (validTypes == null || validTypes.contains(Token.TokenType.SWITCH))) {
                type = Token.TokenType.SWITCH;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_420(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(607);
                if (validTypes == null || validTypes.contains(Token.TokenType.INTEGER_LITERAL)) {
                    type = Token.TokenType.INTEGER_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_421(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 && (validTypes == null || validTypes.contains(Token.TokenType._DEACTIVATE_TOKENS))) {
                type = Token.TokenType._DEACTIVATE_TOKENS;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_422(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(671);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_423(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(84);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_424(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(554);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_425(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34) {
                nextStates.set(452);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_426(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(252);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_427(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.WHILE))) {
                type = Token.TokenType.WHILE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_428(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(428);
            }
            if (ch >= 48 && ch <= 57 && (validTypes == null || validTypes.contains(Token.TokenType.INTEGER_LITERAL))) {
                type = Token.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_429(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(680);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_430(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(157);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_431(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(93);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_432(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(644);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_433(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(557);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_434(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 && (validTypes == null || validTypes.contains(Token.TokenType._INCLUDE))) {
                type = Token.TokenType._INCLUDE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_435(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76) {
                nextStates.set(306);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_436(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 113) {
                nextStates.set(149);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_437(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(519);
            } else if (ch == 34) {
                nextStates.set(689);
            } else if (ch == 92) {
                nextStates.set(312);
                nextStates.set(145);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_438(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(444);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_439(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(98);
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_440(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(427);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_441(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(68);
            }
            if (ch >= 48 && ch <= 55 || ch == 95) {
                nextStates.set(188);
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(Token.TokenType.LONG_LITERAL))) {
                type = Token.TokenType.LONG_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_442(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(610);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_443(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(44);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_444(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(541);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_445(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99 && (validTypes == null || validTypes.contains(Token.TokenType.PUBLIC))) {
                type = Token.TokenType.PUBLIC;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_446(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(714);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_447(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(258);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_448(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(559);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_449(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(110);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_450(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(219);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_451(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(70);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(136);
                nextStates.set(451);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_452(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34) {
                nextStates.set(343);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_453(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(270);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_454(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(436);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_455(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(697);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_456(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62 && (validTypes == null || validTypes.contains(Token.TokenType.LAMBDA))) {
                type = Token.TokenType.LAMBDA;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_457(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(21);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_458(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(458);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(709);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_459(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 36 && (validTypes == null || validTypes.contains(Token.TokenType.START_UNPARSED))) {
                type = Token.TokenType.START_UNPARSED;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_460(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(233);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(253);
            } else if (ch == 92) {
                nextStates.set(69);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_461(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76) {
                nextStates.set(118);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_462(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(337);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_463(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(480);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_464(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(639);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_465(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(605);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_466(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(76);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_467(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 118) {
                nextStates.set(120);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_468(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(616);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_469(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(25);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_470(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(457);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_471(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(599);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_472(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85) {
                nextStates.set(543);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_473(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 121) {
                nextStates.set(275);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_474(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(560);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_475(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.THROWS))) {
                type = Token.TokenType.THROWS;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_476(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(604);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_477(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(89);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_478(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(182);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_479(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(242);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_480(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100) {
                nextStates.set(631);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_481(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(481);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(42);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_482(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(178);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_483(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109 && (validTypes == null || validTypes.contains(Token.TokenType.ENUM))) {
                type = Token.TokenType.ENUM;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_484(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(172);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_485(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(535);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_486(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(365);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_487(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(263);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_488(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(359);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_489(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.GE))) {
                type = Token.TokenType.GE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_490(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 && (validTypes == null || validTypes.contains(Token.TokenType.UP_TO_HERE))) {
                type = Token.TokenType.UP_TO_HERE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_491(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(111);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_492(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(Token.TokenType.OPEN))) {
                type = Token.TokenType.OPEN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_493(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 60 && (validTypes == null || validTypes.contains(Token.TokenType.LSHIFT))) {
                type = Token.TokenType.LSHIFT;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_494(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(58);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_495(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 66 || ch == 98) {
                nextStates.set(622);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_496(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(441);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_497(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(558);
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_498(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80) {
                nextStates.set(195);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_499(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE))) {
                type = Token.TokenType.DOUBLE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_500(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(394);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(500);
                nextStates.set(371);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_501(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(233);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_502(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(603);
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_503(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.CLASS))) {
                type = Token.TokenType.CLASS;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_504(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(251);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_505(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(327);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_506(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(424);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_507(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(410);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_508(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(119);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(684);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(193);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_509(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(205);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_510(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(499);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_511(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(24);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_512(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(47);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_513(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(250);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_514(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(501);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_515(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(523);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_516(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(126);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_517(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.ORASSIGN))) {
                type = Token.TokenType.ORASSIGN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_518(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73) {
                nextStates.set(675);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_519(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(519);
            } else if (ch == 34) {
                nextStates.set(405);
                nextStates.set(437);
                nextStates.set(689);
            } else if (ch == 92) {
                nextStates.set(312);
                nextStates.set(145);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_520(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(307);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_521(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(404);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_522(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(19);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_523(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(72);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_524(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType.INT))) {
                type = Token.TokenType.INT;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_525(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(51);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_526(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 122) {
                nextStates.set(407);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_527(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(237);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_528(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(497);
            }
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(285);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(558);
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_529(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(367);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_530(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(658);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_531(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(235);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_532(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77) {
                nextStates.set(626);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_533(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(591);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_534(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(199);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_535(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(264);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_536(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(75);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_537(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(551);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_538(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85) {
                nextStates.set(274);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_539(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(36);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_540(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77) {
                nextStates.set(159);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_541(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(78);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_542(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85) {
                nextStates.set(461);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_543(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68) {
                nextStates.set(240);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_544(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(576);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_545(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(479);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_546(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114 && (validTypes == null || validTypes.contains(Token.TokenType.VAR))) {
                type = Token.TokenType.VAR;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_547(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(179);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_548(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(575);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_549(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(122);
            }
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(549);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_550(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(194);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_551(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(363);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_552(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(191);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_553(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(627);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_554(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(326);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_555(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(384);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_556(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.CASE))) {
                type = Token.TokenType.CASE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_557(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(449);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_558(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(278);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(603);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_559(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(348);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_560(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(429);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_561(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(609);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_562(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 58 && (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE_COLON))) {
                type = Token.TokenType.DOUBLE_COLON;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_563(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(45);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_564(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(276);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_565(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(637);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_566(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.ELSE))) {
                type = Token.TokenType.ELSE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_567(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(422);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_568(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(687);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_569(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(706);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_570(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(12);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_571(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(90);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_572(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(688);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_573(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(647);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_574(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48 || ch == 49) {
                nextStates.set(68);
            }
            if (ch == 48 || ch == 49 || ch == 95) {
                nextStates.set(324);
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(Token.TokenType.LONG_LITERAL))) {
                type = Token.TokenType.LONG_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_575(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(556);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_576(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83) {
                nextStates.set(321);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_577(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(225);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.CHARACTER_LITERAL))) {
                type = Token.TokenType.CHARACTER_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_578(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(539);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_579(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 74) {
                nextStates.set(624);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_580(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(129);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_581(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.PROVIDES))) {
                type = Token.TokenType.PROVIDES;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_582(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(283);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_583(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(674);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_584(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(216);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_585(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48 || ch == 49) {
                nextStates.set(704);
                if (validTypes == null || validTypes.contains(Token.TokenType.INTEGER_LITERAL)) {
                    type = Token.TokenType.INTEGER_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_586(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114 && (validTypes == null || validTypes.contains(Token.TokenType.FOR))) {
                type = Token.TokenType.FOR;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_587(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 88) {
                nextStates.set(14);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_588(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76) {
                nextStates.set(390);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_589(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.IMPLEMENTS))) {
                type = Token.TokenType.IMPLEMENTS;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_590(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(531);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_591(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType.CONST))) {
                type = Token.TokenType.CONST;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_592(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(581);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_593(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(164);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_594(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(362);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_595(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(155);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_596(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83) {
                nextStates.set(210);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_597(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(273);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_598(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.USES))) {
                type = Token.TokenType.USES;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_599(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(580);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_600(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(186);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_601(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(677);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_602(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(584);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_603(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(323);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(502);
                nextStates.set(603);
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_604(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67) {
                nextStates.set(435);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_605(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(217);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_606(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(481);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(42);
                nextStates.set(606);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_607(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(607);
            }
            if ((ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) && (validTypes == null || validTypes.contains(Token.TokenType.INTEGER_LITERAL))) {
                type = Token.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_608(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(238);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_609(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(492);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_610(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(594);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_611(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.EXPORTS))) {
                type = Token.TokenType.EXPORTS;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_612(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(681);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_613(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(487);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_614(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34 || ch == 39 || ch == 92 || ch == 98 || ch == 102 || ch == 110 || ch >= 114 && ch <= 116) {
                nextStates.set(253);
            } else if (ch >= 48 && ch <= 51) {
                nextStates.set(220);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(460);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_615(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(642);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_616(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(277);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_617(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 86) {
                nextStates.set(354);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_618(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 && (validTypes == null || validTypes.contains(Token.TokenType._IGNORE_CASE))) {
                type = Token.TokenType._IGNORE_CASE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_619(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(163);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_620(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(503);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_621(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(447);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_622(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48 || ch == 49) {
                nextStates.set(574);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_623(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(322);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_624(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(229);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_625(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(413);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_626(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(213);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_627(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(355);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_628(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(200);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_629(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(16);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_630(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(600);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_631(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.EXTENDS))) {
                type = Token.TokenType.EXTENDS;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_632(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(418);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_633(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 10) {
                nextStates.set(519);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_634(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(320);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_635(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(138);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_636(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 86) {
                nextStates.set(288);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_637(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType.FLOAT))) {
                type = Token.TokenType.FLOAT;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_638(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.RUNSIGNEDSHIFTASSIGN))) {
                type = Token.TokenType.RUNSIGNEDSHIFTASSIGN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_639(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(Token.TokenType.SHORT))) {
                type = Token.TokenType.SHORT;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_640(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(521);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_641(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(487);
            } else if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(223);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_642(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 && (validTypes == null || validTypes.contains(Token.TokenType._MORE))) {
                type = Token.TokenType._MORE;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_643(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(529);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_644(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 && (validTypes == null || validTypes.contains(Token.TokenType._SCAN))) {
                type = Token.TokenType._SCAN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_645(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(382);
            } else if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(351);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(209);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(162);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_646(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(615);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_647(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(315);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_648(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.EQ))) {
                type = Token.TokenType.EQ;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_649(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(649);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(663);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_650(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(204);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_651(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(360);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_652(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 8 || ch >= 14 && ch <= 27 || ch == 36 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 127 && ch <= 159 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_JAVA_885, ch)) {
                nextStates.set(652);
                if (validTypes == null || validTypes.contains(Token.TokenType.IDENTIFIER)) {
                    type = Token.TokenType.IDENTIFIER;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_653(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 47 && (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_LINE_COMMENT_START))) {
                type = Token.TokenType.SINGLE_LINE_COMMENT_START;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_654(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                nextStates.set(665);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_655(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(140);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_656(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(469);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_657(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(518);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_658(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(35);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_659(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76) {
                nextStates.set(544);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_660(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(494);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_661(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(406);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_662(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(621);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_663(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_664(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(208);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_665(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 124) {
                nextStates.set(37);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_666(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78) {
                nextStates.set(579);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_667(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(661);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_668(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(Token.TokenType.WHEN))) {
                type = Token.TokenType.WHEN;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_669(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(225);
            } else if (ch == 92) {
                nextStates.set(31);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_670(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(587);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_671(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 98) {
                nextStates.set(510);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_672(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(167);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_673(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65) {
                nextStates.set(477);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_674(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(572);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_675(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 && (validTypes == null || validTypes.contains(Token.TokenType._SKIP))) {
                type = Token.TokenType._SKIP;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_676(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(470);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_677(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(376);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_678(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                nextStates.set(151);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_679(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(255);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_680(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79) {
                nextStates.set(692);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_681(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(402);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_682(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(507);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_683(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(683);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(68);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_684(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(700);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(451);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_685(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(537);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_686(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(566);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_687(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(105);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_688(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(Token.TokenType.REQUIRES))) {
                type = Token.TokenType.REQUIRES;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_689(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(519);
            } else if (ch == 92) {
                nextStates.set(312);
                nextStates.set(145);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_690(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(373);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_691(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(356);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_692(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 && (validTypes == null || validTypes.contains(Token.TokenType._ON_ERROR))) {
                type = Token.TokenType._ON_ERROR;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_693(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(230);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(68);
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(Token.TokenType.LONG_LITERAL))) {
                type = Token.TokenType.LONG_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_694(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(337);
            }
            if (ch >= 48 && ch <= 55) {
                nextStates.set(337);
            } else if (ch == 92) {
                nextStates.set(137);
            } else if (ch == 34 && (validTypes == null || validTypes.contains(Token.TokenType.STRING_LITERAL))) {
                type = Token.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_695(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(261);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_696(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(28);
            }
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(696);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_697(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82) {
                nextStates.set(85);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_698(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(352);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_699(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 38 && (validTypes == null || validTypes.contains(Token.TokenType.SC_AND))) {
                type = Token.TokenType.SC_AND;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_700(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(451);
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL)) {
                    type = Token.TokenType.FLOATING_POINT_LITERAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_701(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(253);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_702(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(7);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_703(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(650);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_704(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48 || ch == 49 || ch == 95) {
                nextStates.set(704);
            }
            if (!(ch != 48 && ch != 49 || validTypes != null && !validTypes.contains(Token.TokenType.INTEGER_LITERAL))) {
                type = Token.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_705(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(547);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_706(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(349);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_707(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(146);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_708(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(660);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_709(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 68 && ch != 70 && ch != 100 && ch != 102 || validTypes != null && !validTypes.contains(Token.TokenType.FLOATING_POINT_LITERAL))) {
                type = Token.TokenType.FLOATING_POINT_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_710(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34 && (validTypes == null || validTypes.contains(Token.TokenType.TEXT_BLOCK_LITERAL))) {
                type = Token.TokenType.TEXT_BLOCK_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_711(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75) {
                nextStates.set(133);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_712(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84) {
                nextStates.set(107);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_713(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(682);
            }
            return type;
        }

        private static Token.TokenType NFA_JAVA_714(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 71) {
                nextStates.set(388);
            }
            return type;
        }

        private static int[] NFA_MOVES_JAVA_793_init() {
            return new int[]{36, 36, 65, 90, 95, 95, 97, 122, 162, 165, 170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1488, 1514, 1519, 1522, 1547, 1547, 1568, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2046, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2144, 2154, 2160, 2183, 2185, 2190, 2208, 2249, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2432, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2547, 2555, 2556, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2801, 2801, 2809, 2809, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3065, 3065, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3133, 3160, 3162, 3165, 3165, 3168, 3169, 3200, 3200, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3293, 3294, 3296, 3297, 3313, 3314, 3332, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3412, 3414, 3423, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3647, 3654, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5905, 5919, 5937, 5952, 5969, 5984, 5996, 5998, 6000, 6016, 6067, 6103, 6103, 6107, 6108, 6176, 6264, 6272, 6276, 6279, 6312, 6314, 6314, 6320, 6389, 6400, 6430, 6480, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6988, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7401, 7404, 7406, 7411, 7413, 7414, 7418, 7418, 7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8255, 8256, 8276, 8276, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11823, 11823, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539, 42560, 42606, 42623, 42653, 42656, 42735, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43064, 43064, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43261, 43262, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43488, 43492, 43494, 43503, 43514, 43518, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43638, 43642, 43642, 43646, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43741, 43744, 43754, 43762, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65284, 65284, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66176, 66204, 66208, 66256, 66304, 66335, 66349, 66378, 66384, 66421, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68096, 68112, 68115, 68117, 68119, 68121, 68149, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68324, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68899, 69248, 69289, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69445, 69488, 69505, 69552, 69572, 69600, 69622, 69635, 69687, 69745, 69746, 69749, 69749, 69763, 69807, 69840, 69864, 69891, 69926, 69956, 69956, 69959, 69959, 69968, 70002, 70006, 70006, 70019, 70066, 70081, 70084, 70106, 70106, 70108, 70108, 70144, 70161, 70163, 70187, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70366, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70461, 70461, 70480, 70480, 70493, 70497, 70656, 70708, 70727, 70730, 70751, 70753, 70784, 70831, 70852, 70853, 70855, 70855, 71040, 71086, 71128, 71131, 71168, 71215, 71236, 71236, 71296, 71338, 71352, 71352, 71424, 71450, 71488, 71494, 71680, 71723, 71840, 71903, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71983, 71999, 71999, 72001, 72001, 72096, 72103, 72106, 72144, 72161, 72161, 72163, 72163, 72192, 72192, 72203, 72242, 72250, 72250, 72272, 72272, 72284, 72329, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72750, 72768, 72768, 72818, 72847, 72960, 72966, 72968, 72969, 72971, 73008, 73030, 73030, 73056, 73061, 73063, 73064, 73066, 73097, 73112, 73112, 73440, 73458, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 82944, 83526, 92160, 92728, 92736, 92766, 92784, 92862, 92880, 92909, 92928, 92975, 92992, 92995, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94032, 94032, 94099, 94111, 94176, 94177, 94179, 94179, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 122624, 122654, 123136, 123180, 123191, 123197, 123214, 123214, 123536, 123565, 123584, 123627, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125184, 125251, 125259, 125259, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546};
        }

        private static int[] NFA_MOVES_JAVA_885_init() {
            return new int[]{0, 8, 14, 27, 36, 36, 48, 57, 65, 90, 95, 95, 97, 122, 127, 159, 162, 165, 170, 170, 173, 173, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 768, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1155, 1159, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1488, 1514, 1519, 1522, 1536, 1541, 1547, 1547, 1552, 1562, 1564, 1564, 1568, 1641, 1646, 1747, 1749, 1757, 1759, 1768, 1770, 1788, 1791, 1791, 1807, 1866, 1869, 1969, 1984, 2037, 2042, 2042, 2045, 2093, 2112, 2139, 2144, 2154, 2160, 2183, 2185, 2190, 2192, 2193, 2200, 2403, 2406, 2415, 2417, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2500, 2503, 2504, 2507, 2510, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2547, 2555, 2556, 2558, 2558, 2561, 2563, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2649, 2652, 2654, 2654, 2662, 2677, 2689, 2691, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2787, 2790, 2799, 2801, 2801, 2809, 2815, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2876, 2884, 2887, 2888, 2891, 2893, 2901, 2903, 2908, 2909, 2911, 2915, 2918, 2927, 2929, 2929, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3024, 3024, 3031, 3031, 3046, 3055, 3065, 3065, 3072, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3132, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3160, 3162, 3165, 3165, 3168, 3171, 3174, 3183, 3200, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3260, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3293, 3294, 3296, 3299, 3302, 3311, 3313, 3314, 3328, 3340, 3342, 3344, 3346, 3396, 3398, 3400, 3402, 3406, 3412, 3415, 3423, 3427, 3430, 3439, 3450, 3455, 3457, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3558, 3567, 3570, 3571, 3585, 3642, 3647, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3807, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3948, 3953, 3972, 3974, 3991, 3993, 4028, 4038, 4038, 4096, 4169, 4176, 4253, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4957, 4959, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5909, 5919, 5940, 5952, 5971, 5984, 5996, 5998, 6000, 6002, 6003, 6016, 6099, 6103, 6103, 6107, 6109, 6112, 6121, 6155, 6169, 6176, 6264, 6272, 6314, 6320, 6389, 6400, 6430, 6432, 6443, 6448, 6459, 6470, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6608, 6617, 6656, 6683, 6688, 6750, 6752, 6780, 6783, 6793, 6800, 6809, 6823, 6823, 6832, 6845, 6847, 6862, 6912, 6988, 6992, 7001, 7019, 7027, 7040, 7155, 7168, 7223, 7232, 7241, 7245, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7376, 7378, 7380, 7418, 7424, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8203, 8207, 8234, 8238, 8255, 8256, 8276, 8276, 8288, 8292, 8294, 8303, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8400, 8412, 8417, 8417, 8421, 8432, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11647, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11744, 11775, 11823, 11823, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12348, 12353, 12438, 12441, 12442, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42539, 42560, 42607, 42612, 42621, 42623, 42737, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43047, 43052, 43052, 43064, 43064, 43072, 43123, 43136, 43205, 43216, 43225, 43232, 43255, 43259, 43259, 43261, 43309, 43312, 43347, 43360, 43388, 43392, 43456, 43471, 43481, 43488, 43518, 43520, 43574, 43584, 43597, 43600, 43609, 43616, 43638, 43642, 43714, 43739, 43741, 43744, 43759, 43762, 43766, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44010, 44012, 44013, 44016, 44025, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65024, 65039, 65056, 65071, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65279, 65279, 65284, 65284, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65529, 65531, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66045, 66045, 66176, 66204, 66208, 66256, 66272, 66272, 66304, 66335, 66349, 66378, 66384, 66426, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66720, 66729, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68099, 68101, 68102, 68108, 68115, 68117, 68119, 68121, 68149, 68152, 68154, 68159, 68159, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68326, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68903, 68912, 68921, 69248, 69289, 69291, 69292, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69456, 69488, 69509, 69552, 69572, 69600, 69622, 69632, 69702, 69734, 69749, 69759, 69818, 69821, 69821, 69826, 69826, 69837, 69837, 69840, 69864, 69872, 69881, 69888, 69940, 69942, 69951, 69956, 69959, 69968, 70003, 70006, 70006, 70016, 70084, 70089, 70092, 70094, 70106, 70108, 70108, 70144, 70161, 70163, 70199, 70206, 70206, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70378, 70384, 70393, 70400, 70403, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70459, 70468, 70471, 70472, 70475, 70477, 70480, 70480, 70487, 70487, 70493, 70499, 70502, 70508, 70512, 70516, 70656, 70730, 70736, 70745, 70750, 70753, 70784, 70853, 70855, 70855, 70864, 70873, 71040, 71093, 71096, 71104, 71128, 71133, 71168, 71232, 71236, 71236, 71248, 71257, 71296, 71352, 71360, 71369, 71424, 71450, 71453, 71467, 71472, 71481, 71488, 71494, 71680, 71738, 71840, 71913, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71989, 71991, 71992, 71995, 72003, 72016, 72025, 72096, 72103, 72106, 72151, 72154, 72161, 72163, 72164, 72192, 72254, 72263, 72263, 72272, 72345, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72758, 72760, 72768, 72784, 72793, 72818, 72847, 72850, 72871, 72873, 72886, 72960, 72966, 72968, 72969, 72971, 73014, 73018, 73018, 73020, 73021, 73023, 73031, 73040, 73049, 73056, 73061, 73063, 73064, 73066, 73102, 73104, 73105, 73107, 73112, 73120, 73129, 73440, 73462, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 78896, 78904, 82944, 83526, 92160, 92728, 92736, 92766, 92768, 92777, 92784, 92862, 92864, 92873, 92880, 92909, 92912, 92916, 92928, 92982, 92992, 92995, 93008, 93017, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94031, 94087, 94095, 94111, 94176, 94177, 94179, 94180, 94192, 94193, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 113821, 113822, 113824, 113827, 118528, 118573, 118576, 118598, 119141, 119145, 119149, 119170, 119173, 119179, 119210, 119213, 119362, 119364, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 120782, 120831, 121344, 121398, 121403, 121452, 121461, 121461, 121476, 121476, 121499, 121503, 121505, 121519, 122624, 122654, 122880, 122886, 122888, 122904, 122907, 122913, 122915, 122916, 122918, 122922, 123136, 123180, 123184, 123197, 123200, 123209, 123214, 123214, 123536, 123566, 123584, 123641, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125136, 125142, 125184, 125259, 125264, 125273, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 130032, 130041, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546, 917505, 917505, 917536, 917631, 917760, 917999};
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{JAVA::NFA_JAVA_0, JAVA::NFA_JAVA_1, JAVA::NFA_JAVA_2, JAVA::NFA_JAVA_3, JAVA::NFA_JAVA_4, JAVA::NFA_JAVA_5, JAVA::NFA_JAVA_6, JAVA::NFA_JAVA_7, JAVA::NFA_JAVA_8, JAVA::NFA_JAVA_9, JAVA::NFA_JAVA_10, JAVA::NFA_JAVA_11, JAVA::NFA_JAVA_12, JAVA::NFA_JAVA_13, JAVA::NFA_JAVA_14, JAVA::NFA_JAVA_15, JAVA::NFA_JAVA_16, JAVA::NFA_JAVA_17, JAVA::NFA_JAVA_18, JAVA::NFA_JAVA_19, JAVA::NFA_JAVA_20, JAVA::NFA_JAVA_21, JAVA::NFA_JAVA_22, JAVA::NFA_JAVA_23, JAVA::NFA_JAVA_24, JAVA::NFA_JAVA_25, JAVA::NFA_JAVA_26, JAVA::NFA_JAVA_27, JAVA::NFA_JAVA_28, JAVA::NFA_JAVA_29, JAVA::NFA_JAVA_30, JAVA::NFA_JAVA_31, JAVA::NFA_JAVA_32, JAVA::NFA_JAVA_33, JAVA::NFA_JAVA_34, JAVA::NFA_JAVA_35, JAVA::NFA_JAVA_36, JAVA::NFA_JAVA_37, JAVA::NFA_JAVA_38, JAVA::NFA_JAVA_39, JAVA::NFA_JAVA_40, JAVA::NFA_JAVA_41, JAVA::NFA_JAVA_42, JAVA::NFA_JAVA_43, JAVA::NFA_JAVA_44, JAVA::NFA_JAVA_45, JAVA::NFA_JAVA_46, JAVA::NFA_JAVA_47, JAVA::NFA_JAVA_48, JAVA::NFA_JAVA_49, JAVA::NFA_JAVA_50, JAVA::NFA_JAVA_51, JAVA::NFA_JAVA_52, JAVA::NFA_JAVA_53, JAVA::NFA_JAVA_54, JAVA::NFA_JAVA_55, JAVA::NFA_JAVA_56, JAVA::NFA_JAVA_57, JAVA::NFA_JAVA_58, JAVA::NFA_JAVA_59, JAVA::NFA_JAVA_60, JAVA::NFA_JAVA_61, JAVA::NFA_JAVA_62, JAVA::NFA_JAVA_63, JAVA::NFA_JAVA_64, JAVA::NFA_JAVA_65, JAVA::NFA_JAVA_66, JAVA::NFA_JAVA_67, JAVA::NFA_JAVA_68, JAVA::NFA_JAVA_69, JAVA::NFA_JAVA_70, JAVA::NFA_JAVA_71, JAVA::NFA_JAVA_72, JAVA::NFA_JAVA_73, JAVA::NFA_JAVA_74, JAVA::NFA_JAVA_75, JAVA::NFA_JAVA_76, JAVA::NFA_JAVA_77, JAVA::NFA_JAVA_78, JAVA::NFA_JAVA_79, JAVA::NFA_JAVA_80, JAVA::NFA_JAVA_81, JAVA::NFA_JAVA_82, JAVA::NFA_JAVA_83, JAVA::NFA_JAVA_84, JAVA::NFA_JAVA_85, JAVA::NFA_JAVA_86, JAVA::NFA_JAVA_87, JAVA::NFA_JAVA_88, JAVA::NFA_JAVA_89, JAVA::NFA_JAVA_90, JAVA::NFA_JAVA_91, JAVA::NFA_JAVA_92, JAVA::NFA_JAVA_93, JAVA::NFA_JAVA_94, JAVA::NFA_JAVA_95, JAVA::NFA_JAVA_96, JAVA::NFA_JAVA_97, JAVA::NFA_JAVA_98, JAVA::NFA_JAVA_99, JAVA::NFA_JAVA_100, JAVA::NFA_JAVA_101, JAVA::NFA_JAVA_102, JAVA::NFA_JAVA_103, JAVA::NFA_JAVA_104, JAVA::NFA_JAVA_105, JAVA::NFA_JAVA_106, JAVA::NFA_JAVA_107, JAVA::NFA_JAVA_108, JAVA::NFA_JAVA_109, JAVA::NFA_JAVA_110, JAVA::NFA_JAVA_111, JAVA::NFA_JAVA_112, JAVA::NFA_JAVA_113, JAVA::NFA_JAVA_114, JAVA::NFA_JAVA_115, JAVA::NFA_JAVA_116, JAVA::NFA_JAVA_117, JAVA::NFA_JAVA_118, JAVA::NFA_JAVA_119, JAVA::NFA_JAVA_120, JAVA::NFA_JAVA_121, JAVA::NFA_JAVA_122, JAVA::NFA_JAVA_123, JAVA::NFA_JAVA_124, JAVA::NFA_JAVA_125, JAVA::NFA_JAVA_126, JAVA::NFA_JAVA_127, JAVA::NFA_JAVA_128, JAVA::NFA_JAVA_129, JAVA::NFA_JAVA_130, JAVA::NFA_JAVA_131, JAVA::NFA_JAVA_132, JAVA::NFA_JAVA_133, JAVA::NFA_JAVA_134, JAVA::NFA_JAVA_135, JAVA::NFA_JAVA_136, JAVA::NFA_JAVA_137, JAVA::NFA_JAVA_138, JAVA::NFA_JAVA_139, JAVA::NFA_JAVA_140, JAVA::NFA_JAVA_141, JAVA::NFA_JAVA_142, JAVA::NFA_JAVA_143, JAVA::NFA_JAVA_144, JAVA::NFA_JAVA_145, JAVA::NFA_JAVA_146, JAVA::NFA_JAVA_147, JAVA::NFA_JAVA_148, JAVA::NFA_JAVA_149, JAVA::NFA_JAVA_150, JAVA::NFA_JAVA_151, JAVA::NFA_JAVA_152, JAVA::NFA_JAVA_153, JAVA::NFA_JAVA_154, JAVA::NFA_JAVA_155, JAVA::NFA_JAVA_156, JAVA::NFA_JAVA_157, JAVA::NFA_JAVA_158, JAVA::NFA_JAVA_159, JAVA::NFA_JAVA_160, JAVA::NFA_JAVA_161, JAVA::NFA_JAVA_162, JAVA::NFA_JAVA_163, JAVA::NFA_JAVA_164, JAVA::NFA_JAVA_165, JAVA::NFA_JAVA_166, JAVA::NFA_JAVA_167, JAVA::NFA_JAVA_168, JAVA::NFA_JAVA_169, JAVA::NFA_JAVA_170, JAVA::NFA_JAVA_171, JAVA::NFA_JAVA_172, JAVA::NFA_JAVA_173, JAVA::NFA_JAVA_174, JAVA::NFA_JAVA_175, JAVA::NFA_JAVA_176, JAVA::NFA_JAVA_177, JAVA::NFA_JAVA_178, JAVA::NFA_JAVA_179, JAVA::NFA_JAVA_180, JAVA::NFA_JAVA_181, JAVA::NFA_JAVA_182, JAVA::NFA_JAVA_183, JAVA::NFA_JAVA_184, JAVA::NFA_JAVA_185, JAVA::NFA_JAVA_186, JAVA::NFA_JAVA_187, JAVA::NFA_JAVA_188, JAVA::NFA_JAVA_189, JAVA::NFA_JAVA_190, JAVA::NFA_JAVA_191, JAVA::NFA_JAVA_192, JAVA::NFA_JAVA_193, JAVA::NFA_JAVA_194, JAVA::NFA_JAVA_195, JAVA::NFA_JAVA_196, JAVA::NFA_JAVA_197, JAVA::NFA_JAVA_198, JAVA::NFA_JAVA_199, JAVA::NFA_JAVA_200, JAVA::NFA_JAVA_201, JAVA::NFA_JAVA_202, JAVA::NFA_JAVA_203, JAVA::NFA_JAVA_204, JAVA::NFA_JAVA_205, JAVA::NFA_JAVA_206, JAVA::NFA_JAVA_207, JAVA::NFA_JAVA_208, JAVA::NFA_JAVA_209, JAVA::NFA_JAVA_210, JAVA::NFA_JAVA_211, JAVA::NFA_JAVA_212, JAVA::NFA_JAVA_213, JAVA::NFA_JAVA_214, JAVA::NFA_JAVA_215, JAVA::NFA_JAVA_216, JAVA::NFA_JAVA_217, JAVA::NFA_JAVA_218, JAVA::NFA_JAVA_219, JAVA::NFA_JAVA_220, JAVA::NFA_JAVA_221, JAVA::NFA_JAVA_222, JAVA::NFA_JAVA_223, JAVA::NFA_JAVA_224, JAVA::NFA_JAVA_225, JAVA::NFA_JAVA_226, JAVA::NFA_JAVA_227, JAVA::NFA_JAVA_228, JAVA::NFA_JAVA_229, JAVA::NFA_JAVA_230, JAVA::NFA_JAVA_231, JAVA::NFA_JAVA_232, JAVA::NFA_JAVA_233, JAVA::NFA_JAVA_234, JAVA::NFA_JAVA_235, JAVA::NFA_JAVA_236, JAVA::NFA_JAVA_237, JAVA::NFA_JAVA_238, JAVA::NFA_JAVA_239, JAVA::NFA_JAVA_240, JAVA::NFA_JAVA_241, JAVA::NFA_JAVA_242, JAVA::NFA_JAVA_243, JAVA::NFA_JAVA_244, JAVA::NFA_JAVA_245, JAVA::NFA_JAVA_246, JAVA::NFA_JAVA_247, JAVA::NFA_JAVA_248, JAVA::NFA_JAVA_249, JAVA::NFA_JAVA_250, JAVA::NFA_JAVA_251, JAVA::NFA_JAVA_252, JAVA::NFA_JAVA_253, JAVA::NFA_JAVA_254, JAVA::NFA_JAVA_255, JAVA::NFA_JAVA_256, JAVA::NFA_JAVA_257, JAVA::NFA_JAVA_258, JAVA::NFA_JAVA_259, JAVA::NFA_JAVA_260, JAVA::NFA_JAVA_261, JAVA::NFA_JAVA_262, JAVA::NFA_JAVA_263, JAVA::NFA_JAVA_264, JAVA::NFA_JAVA_265, JAVA::NFA_JAVA_266, JAVA::NFA_JAVA_267, JAVA::NFA_JAVA_268, JAVA::NFA_JAVA_269, JAVA::NFA_JAVA_270, JAVA::NFA_JAVA_271, JAVA::NFA_JAVA_272, JAVA::NFA_JAVA_273, JAVA::NFA_JAVA_274, JAVA::NFA_JAVA_275, JAVA::NFA_JAVA_276, JAVA::NFA_JAVA_277, JAVA::NFA_JAVA_278, JAVA::NFA_JAVA_279, JAVA::NFA_JAVA_280, JAVA::NFA_JAVA_281, JAVA::NFA_JAVA_282, JAVA::NFA_JAVA_283, JAVA::NFA_JAVA_284, JAVA::NFA_JAVA_285, JAVA::NFA_JAVA_286, JAVA::NFA_JAVA_287, JAVA::NFA_JAVA_288, JAVA::NFA_JAVA_289, JAVA::NFA_JAVA_290, JAVA::NFA_JAVA_291, JAVA::NFA_JAVA_292, JAVA::NFA_JAVA_293, JAVA::NFA_JAVA_294, JAVA::NFA_JAVA_295, JAVA::NFA_JAVA_296, JAVA::NFA_JAVA_297, JAVA::NFA_JAVA_298, JAVA::NFA_JAVA_299, JAVA::NFA_JAVA_300, JAVA::NFA_JAVA_301, JAVA::NFA_JAVA_302, JAVA::NFA_JAVA_303, JAVA::NFA_JAVA_304, JAVA::NFA_JAVA_305, JAVA::NFA_JAVA_306, JAVA::NFA_JAVA_307, JAVA::NFA_JAVA_308, JAVA::NFA_JAVA_309, JAVA::NFA_JAVA_310, JAVA::NFA_JAVA_311, JAVA::NFA_JAVA_312, JAVA::NFA_JAVA_313, JAVA::NFA_JAVA_314, JAVA::NFA_JAVA_315, JAVA::NFA_JAVA_316, JAVA::NFA_JAVA_317, JAVA::NFA_JAVA_318, JAVA::NFA_JAVA_319, JAVA::NFA_JAVA_320, JAVA::NFA_JAVA_321, JAVA::NFA_JAVA_322, JAVA::NFA_JAVA_323, JAVA::NFA_JAVA_324, JAVA::NFA_JAVA_325, JAVA::NFA_JAVA_326, JAVA::NFA_JAVA_327, JAVA::NFA_JAVA_328, JAVA::NFA_JAVA_329, JAVA::NFA_JAVA_330, JAVA::NFA_JAVA_331, JAVA::NFA_JAVA_332, JAVA::NFA_JAVA_333, JAVA::NFA_JAVA_334, JAVA::NFA_JAVA_335, JAVA::NFA_JAVA_336, JAVA::NFA_JAVA_337, JAVA::NFA_JAVA_338, JAVA::NFA_JAVA_339, JAVA::NFA_JAVA_340, JAVA::NFA_JAVA_341, JAVA::NFA_JAVA_342, JAVA::NFA_JAVA_343, JAVA::NFA_JAVA_344, JAVA::NFA_JAVA_345, JAVA::NFA_JAVA_346, JAVA::NFA_JAVA_347, JAVA::NFA_JAVA_348, JAVA::NFA_JAVA_349, JAVA::NFA_JAVA_350, JAVA::NFA_JAVA_351, JAVA::NFA_JAVA_352, JAVA::NFA_JAVA_353, JAVA::NFA_JAVA_354, JAVA::NFA_JAVA_355, JAVA::NFA_JAVA_356, JAVA::NFA_JAVA_357, JAVA::NFA_JAVA_358, JAVA::NFA_JAVA_359, JAVA::NFA_JAVA_360, JAVA::NFA_JAVA_361, JAVA::NFA_JAVA_362, JAVA::NFA_JAVA_363, JAVA::NFA_JAVA_364, JAVA::NFA_JAVA_365, JAVA::NFA_JAVA_366, JAVA::NFA_JAVA_367, JAVA::NFA_JAVA_368, JAVA::NFA_JAVA_369, JAVA::NFA_JAVA_370, JAVA::NFA_JAVA_371, JAVA::NFA_JAVA_372, JAVA::NFA_JAVA_373, JAVA::NFA_JAVA_374, JAVA::NFA_JAVA_375, JAVA::NFA_JAVA_376, JAVA::NFA_JAVA_377, JAVA::NFA_JAVA_378, JAVA::NFA_JAVA_379, JAVA::NFA_JAVA_380, JAVA::NFA_JAVA_381, JAVA::NFA_JAVA_382, JAVA::NFA_JAVA_383, JAVA::NFA_JAVA_384, JAVA::NFA_JAVA_385, JAVA::NFA_JAVA_386, JAVA::NFA_JAVA_387, JAVA::NFA_JAVA_388, JAVA::NFA_JAVA_389, JAVA::NFA_JAVA_390, JAVA::NFA_JAVA_391, JAVA::NFA_JAVA_392, JAVA::NFA_JAVA_393, JAVA::NFA_JAVA_394, JAVA::NFA_JAVA_395, JAVA::NFA_JAVA_396, JAVA::NFA_JAVA_397, JAVA::NFA_JAVA_398, JAVA::NFA_JAVA_399, JAVA::NFA_JAVA_400, JAVA::NFA_JAVA_401, JAVA::NFA_JAVA_402, JAVA::NFA_JAVA_403, JAVA::NFA_JAVA_404, JAVA::NFA_JAVA_405, JAVA::NFA_JAVA_406, JAVA::NFA_JAVA_407, JAVA::NFA_JAVA_408, JAVA::NFA_JAVA_409, JAVA::NFA_JAVA_410, JAVA::NFA_JAVA_411, JAVA::NFA_JAVA_412, JAVA::NFA_JAVA_413, JAVA::NFA_JAVA_414, JAVA::NFA_JAVA_415, JAVA::NFA_JAVA_416, JAVA::NFA_JAVA_417, JAVA::NFA_JAVA_418, JAVA::NFA_JAVA_419, JAVA::NFA_JAVA_420, JAVA::NFA_JAVA_421, JAVA::NFA_JAVA_422, JAVA::NFA_JAVA_423, JAVA::NFA_JAVA_424, JAVA::NFA_JAVA_425, JAVA::NFA_JAVA_426, JAVA::NFA_JAVA_427, JAVA::NFA_JAVA_428, JAVA::NFA_JAVA_429, JAVA::NFA_JAVA_430, JAVA::NFA_JAVA_431, JAVA::NFA_JAVA_432, JAVA::NFA_JAVA_433, JAVA::NFA_JAVA_434, JAVA::NFA_JAVA_435, JAVA::NFA_JAVA_436, JAVA::NFA_JAVA_437, JAVA::NFA_JAVA_438, JAVA::NFA_JAVA_439, JAVA::NFA_JAVA_440, JAVA::NFA_JAVA_441, JAVA::NFA_JAVA_442, JAVA::NFA_JAVA_443, JAVA::NFA_JAVA_444, JAVA::NFA_JAVA_445, JAVA::NFA_JAVA_446, JAVA::NFA_JAVA_447, JAVA::NFA_JAVA_448, JAVA::NFA_JAVA_449, JAVA::NFA_JAVA_450, JAVA::NFA_JAVA_451, JAVA::NFA_JAVA_452, JAVA::NFA_JAVA_453, JAVA::NFA_JAVA_454, JAVA::NFA_JAVA_455, JAVA::NFA_JAVA_456, JAVA::NFA_JAVA_457, JAVA::NFA_JAVA_458, JAVA::NFA_JAVA_459, JAVA::NFA_JAVA_460, JAVA::NFA_JAVA_461, JAVA::NFA_JAVA_462, JAVA::NFA_JAVA_463, JAVA::NFA_JAVA_464, JAVA::NFA_JAVA_465, JAVA::NFA_JAVA_466, JAVA::NFA_JAVA_467, JAVA::NFA_JAVA_468, JAVA::NFA_JAVA_469, JAVA::NFA_JAVA_470, JAVA::NFA_JAVA_471, JAVA::NFA_JAVA_472, JAVA::NFA_JAVA_473, JAVA::NFA_JAVA_474, JAVA::NFA_JAVA_475, JAVA::NFA_JAVA_476, JAVA::NFA_JAVA_477, JAVA::NFA_JAVA_478, JAVA::NFA_JAVA_479, JAVA::NFA_JAVA_480, JAVA::NFA_JAVA_481, JAVA::NFA_JAVA_482, JAVA::NFA_JAVA_483, JAVA::NFA_JAVA_484, JAVA::NFA_JAVA_485, JAVA::NFA_JAVA_486, JAVA::NFA_JAVA_487, JAVA::NFA_JAVA_488, JAVA::NFA_JAVA_489, JAVA::NFA_JAVA_490, JAVA::NFA_JAVA_491, JAVA::NFA_JAVA_492, JAVA::NFA_JAVA_493, JAVA::NFA_JAVA_494, JAVA::NFA_JAVA_495, JAVA::NFA_JAVA_496, JAVA::NFA_JAVA_497, JAVA::NFA_JAVA_498, JAVA::NFA_JAVA_499, JAVA::NFA_JAVA_500, JAVA::NFA_JAVA_501, JAVA::NFA_JAVA_502, JAVA::NFA_JAVA_503, JAVA::NFA_JAVA_504, JAVA::NFA_JAVA_505, JAVA::NFA_JAVA_506, JAVA::NFA_JAVA_507, JAVA::NFA_JAVA_508, JAVA::NFA_JAVA_509, JAVA::NFA_JAVA_510, JAVA::NFA_JAVA_511, JAVA::NFA_JAVA_512, JAVA::NFA_JAVA_513, JAVA::NFA_JAVA_514, JAVA::NFA_JAVA_515, JAVA::NFA_JAVA_516, JAVA::NFA_JAVA_517, JAVA::NFA_JAVA_518, JAVA::NFA_JAVA_519, JAVA::NFA_JAVA_520, JAVA::NFA_JAVA_521, JAVA::NFA_JAVA_522, JAVA::NFA_JAVA_523, JAVA::NFA_JAVA_524, JAVA::NFA_JAVA_525, JAVA::NFA_JAVA_526, JAVA::NFA_JAVA_527, JAVA::NFA_JAVA_528, JAVA::NFA_JAVA_529, JAVA::NFA_JAVA_530, JAVA::NFA_JAVA_531, JAVA::NFA_JAVA_532, JAVA::NFA_JAVA_533, JAVA::NFA_JAVA_534, JAVA::NFA_JAVA_535, JAVA::NFA_JAVA_536, JAVA::NFA_JAVA_537, JAVA::NFA_JAVA_538, JAVA::NFA_JAVA_539, JAVA::NFA_JAVA_540, JAVA::NFA_JAVA_541, JAVA::NFA_JAVA_542, JAVA::NFA_JAVA_543, JAVA::NFA_JAVA_544, JAVA::NFA_JAVA_545, JAVA::NFA_JAVA_546, JAVA::NFA_JAVA_547, JAVA::NFA_JAVA_548, JAVA::NFA_JAVA_549, JAVA::NFA_JAVA_550, JAVA::NFA_JAVA_551, JAVA::NFA_JAVA_552, JAVA::NFA_JAVA_553, JAVA::NFA_JAVA_554, JAVA::NFA_JAVA_555, JAVA::NFA_JAVA_556, JAVA::NFA_JAVA_557, JAVA::NFA_JAVA_558, JAVA::NFA_JAVA_559, JAVA::NFA_JAVA_560, JAVA::NFA_JAVA_561, JAVA::NFA_JAVA_562, JAVA::NFA_JAVA_563, JAVA::NFA_JAVA_564, JAVA::NFA_JAVA_565, JAVA::NFA_JAVA_566, JAVA::NFA_JAVA_567, JAVA::NFA_JAVA_568, JAVA::NFA_JAVA_569, JAVA::NFA_JAVA_570, JAVA::NFA_JAVA_571, JAVA::NFA_JAVA_572, JAVA::NFA_JAVA_573, JAVA::NFA_JAVA_574, JAVA::NFA_JAVA_575, JAVA::NFA_JAVA_576, JAVA::NFA_JAVA_577, JAVA::NFA_JAVA_578, JAVA::NFA_JAVA_579, JAVA::NFA_JAVA_580, JAVA::NFA_JAVA_581, JAVA::NFA_JAVA_582, JAVA::NFA_JAVA_583, JAVA::NFA_JAVA_584, JAVA::NFA_JAVA_585, JAVA::NFA_JAVA_586, JAVA::NFA_JAVA_587, JAVA::NFA_JAVA_588, JAVA::NFA_JAVA_589, JAVA::NFA_JAVA_590, JAVA::NFA_JAVA_591, JAVA::NFA_JAVA_592, JAVA::NFA_JAVA_593, JAVA::NFA_JAVA_594, JAVA::NFA_JAVA_595, JAVA::NFA_JAVA_596, JAVA::NFA_JAVA_597, JAVA::NFA_JAVA_598, JAVA::NFA_JAVA_599, JAVA::NFA_JAVA_600, JAVA::NFA_JAVA_601, JAVA::NFA_JAVA_602, JAVA::NFA_JAVA_603, JAVA::NFA_JAVA_604, JAVA::NFA_JAVA_605, JAVA::NFA_JAVA_606, JAVA::NFA_JAVA_607, JAVA::NFA_JAVA_608, JAVA::NFA_JAVA_609, JAVA::NFA_JAVA_610, JAVA::NFA_JAVA_611, JAVA::NFA_JAVA_612, JAVA::NFA_JAVA_613, JAVA::NFA_JAVA_614, JAVA::NFA_JAVA_615, JAVA::NFA_JAVA_616, JAVA::NFA_JAVA_617, JAVA::NFA_JAVA_618, JAVA::NFA_JAVA_619, JAVA::NFA_JAVA_620, JAVA::NFA_JAVA_621, JAVA::NFA_JAVA_622, JAVA::NFA_JAVA_623, JAVA::NFA_JAVA_624, JAVA::NFA_JAVA_625, JAVA::NFA_JAVA_626, JAVA::NFA_JAVA_627, JAVA::NFA_JAVA_628, JAVA::NFA_JAVA_629, JAVA::NFA_JAVA_630, JAVA::NFA_JAVA_631, JAVA::NFA_JAVA_632, JAVA::NFA_JAVA_633, JAVA::NFA_JAVA_634, JAVA::NFA_JAVA_635, JAVA::NFA_JAVA_636, JAVA::NFA_JAVA_637, JAVA::NFA_JAVA_638, JAVA::NFA_JAVA_639, JAVA::NFA_JAVA_640, JAVA::NFA_JAVA_641, JAVA::NFA_JAVA_642, JAVA::NFA_JAVA_643, JAVA::NFA_JAVA_644, JAVA::NFA_JAVA_645, JAVA::NFA_JAVA_646, JAVA::NFA_JAVA_647, JAVA::NFA_JAVA_648, JAVA::NFA_JAVA_649, JAVA::NFA_JAVA_650, JAVA::NFA_JAVA_651, JAVA::NFA_JAVA_652, JAVA::NFA_JAVA_653, JAVA::NFA_JAVA_654, JAVA::NFA_JAVA_655, JAVA::NFA_JAVA_656, JAVA::NFA_JAVA_657, JAVA::NFA_JAVA_658, JAVA::NFA_JAVA_659, JAVA::NFA_JAVA_660, JAVA::NFA_JAVA_661, JAVA::NFA_JAVA_662, JAVA::NFA_JAVA_663, JAVA::NFA_JAVA_664, JAVA::NFA_JAVA_665, JAVA::NFA_JAVA_666, JAVA::NFA_JAVA_667, JAVA::NFA_JAVA_668, JAVA::NFA_JAVA_669, JAVA::NFA_JAVA_670, JAVA::NFA_JAVA_671, JAVA::NFA_JAVA_672, JAVA::NFA_JAVA_673, JAVA::NFA_JAVA_674, JAVA::NFA_JAVA_675, JAVA::NFA_JAVA_676, JAVA::NFA_JAVA_677, JAVA::NFA_JAVA_678, JAVA::NFA_JAVA_679, JAVA::NFA_JAVA_680, JAVA::NFA_JAVA_681, JAVA::NFA_JAVA_682, JAVA::NFA_JAVA_683, JAVA::NFA_JAVA_684, JAVA::NFA_JAVA_685, JAVA::NFA_JAVA_686, JAVA::NFA_JAVA_687, JAVA::NFA_JAVA_688, JAVA::NFA_JAVA_689, JAVA::NFA_JAVA_690, JAVA::NFA_JAVA_691, JAVA::NFA_JAVA_692, JAVA::NFA_JAVA_693, JAVA::NFA_JAVA_694, JAVA::NFA_JAVA_695, JAVA::NFA_JAVA_696, JAVA::NFA_JAVA_697, JAVA::NFA_JAVA_698, JAVA::NFA_JAVA_699, JAVA::NFA_JAVA_700, JAVA::NFA_JAVA_701, JAVA::NFA_JAVA_702, JAVA::NFA_JAVA_703, JAVA::NFA_JAVA_704, JAVA::NFA_JAVA_705, JAVA::NFA_JAVA_706, JAVA::NFA_JAVA_707, JAVA::NFA_JAVA_708, JAVA::NFA_JAVA_709, JAVA::NFA_JAVA_710, JAVA::NFA_JAVA_711, JAVA::NFA_JAVA_712, JAVA::NFA_JAVA_713, JAVA::NFA_JAVA_714};
            functionTableMap.put(LexicalState.JAVA, functions);
        }
    }

    static interface NfaFunction {
        public Token.TokenType apply(int var1, BitSet var2, EnumSet<Token.TokenType> var3);
    }

    static class MatchInfo {
        Token.TokenType matchedType;
        int matchLength;

        MatchInfo(Token.TokenType matchedType, int matchLength) {
            this.matchedType = matchedType;
            this.matchLength = matchLength;
        }
    }

    public static enum LexicalState {
        JAVA,
        IN_UNPARSED_CODE_BLOCK,
        IN_MULTI_LINE_COMMENT,
        IN_SINGLE_LINE_COMMENT,
        JAVA_MODULE;

    }
}

