/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.congocc.app.AppSettings;
import org.congocc.app.Errors;
import org.congocc.codegen.FilesGenerator;
import org.congocc.codegen.TemplateGlobals;
import org.congocc.codegen.Translator;
import org.congocc.codegen.java.CodeInjector;
import org.congocc.core.BNFProduction;
import org.congocc.core.Expansion;
import org.congocc.core.ExpansionSequence;
import org.congocc.core.ExpansionWithNested;
import org.congocc.core.LexerData;
import org.congocc.core.NonTerminal;
import org.congocc.core.RegexpSpec;
import org.congocc.parser.CongoCCParser;
import org.congocc.parser.Node;
import org.congocc.parser.Token;
import org.congocc.parser.tree.Assertion;
import org.congocc.parser.tree.BaseNode;
import org.congocc.parser.tree.CodeBlock;
import org.congocc.parser.tree.CodeInjection;
import org.congocc.parser.tree.CompilationUnit;
import org.congocc.parser.tree.EmptyDeclaration;
import org.congocc.parser.tree.ExpansionChoice;
import org.congocc.parser.tree.GrammarFile;
import org.congocc.parser.tree.LookBehind;
import org.congocc.parser.tree.Lookahead;
import org.congocc.parser.tree.MethodDeclaration;
import org.congocc.parser.tree.OneOrMore;
import org.congocc.parser.tree.TypeDeclaration;
import org.congocc.parser.tree.ZeroOrMore;
import org.congocc.parser.tree.ZeroOrOne;

public class Grammar
extends BaseNode {
    private String defaultLexicalState;
    private LexerData lexerData = new LexerData(this);
    private int includeNesting;
    private Map<String, BNFProduction> productionTable;
    private Set<String> lexicalStates = new LinkedHashSet<String>();
    private Map<String, String> preprocessorSymbols = new HashMap<String, String>();
    private Set<String> nodeNames = new LinkedHashSet<String>();
    private Map<String, String> nodeClassNames = new HashMap<String, String>();
    private Set<String> abstractNodeNames = new HashSet<String>();
    private Set<String> interfaceNodeNames = new HashSet<String>();
    private Map<String, String> nodePackageNames = new HashMap<String, String>();
    private List<Node> codeInjections = new ArrayList<Node>();
    private List<String> lexerTokenHooks = new ArrayList<String>();
    private List<String> parserTokenHooks = new ArrayList<String>();
    private List<String> openNodeScopeHooks = new ArrayList<String>();
    private List<String> closeNodeScopeHooks = new ArrayList<String>();
    private List<String> resetTokenHooks = new ArrayList<String>();
    private Map<String, List<String>> closeNodeHooksByClass = new HashMap<String, List<String>>();
    private Set<Path> alreadyIncluded = new HashSet<Path>();
    private TemplateGlobals templateGlobals;
    private AppSettings appSettings;
    private Errors errors;
    private CodeInjector injector;

    public Grammar(Path outputDir, String codeLang, int jdkTarget, boolean quiet, Map<String, String> preprocessorSymbols) {
        if (preprocessorSymbols == null) {
            preprocessorSymbols = new HashMap<String, String>();
        }
        this.preprocessorSymbols = preprocessorSymbols;
        this.appSettings = new AppSettings(this);
        this.appSettings.setJdkTarget(jdkTarget);
        this.appSettings.setOutputDir(outputDir);
        this.appSettings.setCodeLang(codeLang);
        preprocessorSymbols.put("__" + codeLang + "__", "1");
        this.appSettings.setQuiet(quiet);
        this.templateGlobals = new TemplateGlobals(this);
    }

    public Grammar() {
        this.appSettings = new AppSettings(this);
    }

    @Override
    public AppSettings getAppSettings() {
        return this.appSettings;
    }

    public TemplateGlobals getTemplateGlobals() {
        return this.templateGlobals;
    }

    @Override
    public Errors getErrors() {
        if (this.errors == null) {
            this.errors = new Errors();
        }
        return this.errors;
    }

    public void setSettings(Map<String, Object> settings) {
        this.appSettings.setSettings(settings);
    }

    public Map<String, String> getPreprocessorSymbols() {
        return this.preprocessorSymbols;
    }

    public String[] getLexicalStates() {
        return this.lexicalStates.toArray(new String[0]);
    }

    public GrammarFile parse(Path file, boolean enterIncludes) throws IOException {
        Path canonicalPath = file.normalize();
        if (this.alreadyIncluded.contains(canonicalPath)) {
            return null;
        }
        this.alreadyIncluded.add(canonicalPath);
        CongoCCParser parser = new CongoCCParser(this, canonicalPath, this.preprocessorSymbols);
        parser.setEnterIncludes(enterIncludes);
        Path prevIncludedFileDirectory = this.appSettings.getIncludedFileDirectory();
        if (!this.isInInclude()) {
            this.appSettings.setFilename(file);
        } else {
            this.appSettings.setIncludedFileDirectory(canonicalPath.getParent());
        }
        GrammarFile rootNode = parser.Root();
        this.appSettings.setIncludedFileDirectory(prevIncludedFileDirectory);
        if (!this.isInInclude()) {
            this.addChild(rootNode);
        }
        return rootNode;
    }

    public Node include(List<String> locations, Node includeLocation) throws IOException {
        Path path = this.appSettings.resolveLocation(locations);
        if (path == null) {
            this.errors.addError(includeLocation, "Could not resolve location of include file");
            throw new FileNotFoundException(includeLocation.getLocation());
        }
        String location = path.toString();
        if (location.toLowerCase().endsWith(".java") || location.toLowerCase().endsWith(".jav")) {
            Path includeFile = Paths.get(location, new String[0]);
            String content = new String(Files.readAllBytes(path), Charset.forName("UTF-8"));
            CompilationUnit cu = CongoCCParser.parseJavaFile(includeFile.normalize().toString(), content);
            this.codeInjections.add(cu);
            return cu;
        }
        Path prevLocation = this.appSettings.getFilename();
        String prevDefaultLexicalState = this.defaultLexicalState;
        boolean prevIgnoreCase = this.appSettings.isIgnoreCase();
        ++this.includeNesting;
        GrammarFile root = this.parse(path, true);
        if (root == null) {
            return null;
        }
        --this.includeNesting;
        this.appSettings.setFilename(prevLocation);
        this.defaultLexicalState = prevDefaultLexicalState;
        this.appSettings.setIgnoreCase(prevIgnoreCase);
        return root;
    }

    public void createOutputDir() {
        Path outputDir = Paths.get(".", new String[0]);
        if (!Files.isWritable(outputDir)) {
            this.errors.addError(null, "Cannot write to the output directory : \"" + outputDir + "\"");
        }
    }

    public void generateLexer() {
        this.lexerData.buildData();
    }

    public void generateFiles() throws IOException {
        Translator translator = Translator.getTranslatorFor(this);
        this.templateGlobals.setTranslator(translator);
        new FilesGenerator(this, this.appSettings.getCodeLang()).generateAll();
    }

    public LexerData getLexerData() {
        return this.lexerData;
    }

    public String getDefaultLexicalState() {
        return this.defaultLexicalState == null ? "DEFAULT" : this.defaultLexicalState;
    }

    public void setDefaultLexicalState(String defaultLexicalState) {
        this.defaultLexicalState = defaultLexicalState;
        this.addLexicalState(defaultLexicalState);
    }

    public CodeInjector getInjector() {
        if (this.injector == null) {
            this.injector = new CodeInjector(this, this.codeInjections);
        }
        return this.injector;
    }

    public Collection<BNFProduction> getParserProductions() {
        List<BNFProduction> productions = this.descendants(BNFProduction.class);
        LinkedHashMap<String, BNFProduction> map = new LinkedHashMap<String, BNFProduction>();
        for (BNFProduction production : productions) {
            map.put(production.getName(), production);
        }
        return map.values();
    }

    public List<Expansion> getChoicePointExpansions() {
        return this.descendants(Expansion.class, Expansion::isAtChoicePoint);
    }

    public List<Expansion> getAssertionExpansions() {
        return this.descendants(Expansion.class, exp -> exp.getParent() instanceof Assertion);
    }

    public List<ExpansionSequence> getExpansionsNeedingPredicate() {
        return this.descendants(ExpansionSequence.class, ExpansionSequence::getRequiresPredicateMethod);
    }

    public List<Expansion> getExpansionsNeedingRecoverMethod() {
        HashSet<String> alreadyAdded = new HashSet<String>();
        ArrayList<Expansion> result = new ArrayList<Expansion>();
        for (Expansion exp : this.descendants(Expansion.class, Expansion::getRequiresRecoverMethod)) {
            String methodName = exp.getRecoverMethodName();
            if (alreadyAdded.contains(methodName)) continue;
            result.add(exp);
            alreadyAdded.add(methodName);
        }
        return result;
    }

    public List<String> getLexerTokenHooks() {
        return this.lexerTokenHooks;
    }

    public List<String> getParserTokenHooks() {
        return this.parserTokenHooks;
    }

    public List<String> getResetTokenHooks() {
        return this.resetTokenHooks;
    }

    public List<String> getOpenNodeScopeHooks() {
        return this.openNodeScopeHooks;
    }

    public List<String> getCloseNodeScopeHooks() {
        return this.closeNodeScopeHooks;
    }

    public Map<String, List<String>> getCloseNodeHooksByClass() {
        return this.closeNodeHooksByClass;
    }

    private List<String> getCloseNodeScopeHooks(String className) {
        List<String> result = this.closeNodeHooksByClass.get(className);
        if (result == null) {
            result = new ArrayList<String>();
            this.closeNodeHooksByClass.put(className, result);
        }
        return result;
    }

    public Map<String, BNFProduction> getProductionTable() {
        if (this.productionTable == null) {
            this.productionTable = new LinkedHashMap<String, BNFProduction>();
            for (BNFProduction production : this.descendants(BNFProduction.class)) {
                this.productionTable.put(production.getName(), production);
            }
        }
        return this.productionTable;
    }

    public BNFProduction getProductionByName(String name) {
        return this.getProductionTable().get(name);
    }

    public void addLexicalState(String name) {
        this.lexicalStates.add(name);
    }

    public List<Expansion> getExpansionsForFirstSet() {
        return this.getExpansionsForSet(0);
    }

    public List<Expansion> getExpansionsForFinalSet() {
        return this.getExpansionsForSet(1);
    }

    public List<Expansion> getExpansionsForFollowSet() {
        return this.getExpansionsForSet(2);
    }

    private List<Expansion> getExpansionsForSet(int type) {
        HashSet<String> usedNames = new HashSet<String>();
        ArrayList<Expansion> result = new ArrayList<Expansion>();
        for (Expansion expansion : this.descendants(Expansion.class)) {
            String varName;
            if (expansion.getParent() instanceof BNFProduction || (type == 0 || type == 2) && expansion instanceof CodeBlock || usedNames.contains(varName = type == 0 ? expansion.getFirstSetVarName() : (type == 1 ? expansion.getFinalSetVarName() : expansion.getFollowSetVarName()))) continue;
            result.add(expansion);
            usedNames.add(varName);
        }
        return result;
    }

    public List<Lookahead> getAllLookaheads() {
        return this.descendants(Lookahead.class);
    }

    public List<LookBehind> getAllLookBehinds() {
        return this.descendants(LookBehind.class);
    }

    public Set<String> getNodeNames() {
        return this.nodeNames;
    }

    public String getNodePrefix() {
        return this.appSettings.getNodePrefix();
    }

    public void addNodeType(String productionName, String nodeName) {
        if (nodeName.equals("void") || nodeName.equals("scan")) {
            return;
        }
        if (nodeName.equals("abstract")) {
            this.abstractNodeNames.add(productionName);
            nodeName = productionName;
        } else if (nodeName.equals("interface")) {
            this.interfaceNodeNames.add(productionName);
            nodeName = productionName;
        } else {
            this.abstractNodeNames.remove(nodeName);
            this.interfaceNodeNames.remove(nodeName);
        }
        this.nodeNames.add(nodeName);
        this.nodeClassNames.put(nodeName, this.getNodePrefix() + nodeName);
        this.nodePackageNames.put(nodeName, this.appSettings.getNodePackage());
    }

    public boolean nodeIsInterface(String nodeName) {
        return this.interfaceNodeNames.contains(nodeName);
    }

    public boolean nodeIsAbstract(String nodeName) {
        return this.abstractNodeNames.contains(nodeName);
    }

    public String getNodeClassName(String nodeName) {
        String className = this.nodeClassNames.get(nodeName);
        if (className == null) {
            return this.getNodePrefix() + nodeName;
        }
        return className;
    }

    private void checkForHooks(Node node, String className) {
        block6: {
            block9: {
                String methodName;
                String closeNodePrefix;
                block12: {
                    block14: {
                        block13: {
                            block10: {
                                String resetPrefix;
                                block11: {
                                    block7: {
                                        String typeName;
                                        TypeDeclaration typeDecl;
                                        block8: {
                                            block4: {
                                                CodeInjection ci;
                                                block5: {
                                                    if (node == null || node instanceof Token || node instanceof EmptyDeclaration) {
                                                        return;
                                                    }
                                                    if (!(node instanceof CodeInjection)) break block4;
                                                    ci = (CodeInjection)node;
                                                    if (!ci.name.equals(this.appSettings.getLexerClassName())) break block5;
                                                    this.checkForHooks(ci.body, this.appSettings.getLexerClassName());
                                                    break block6;
                                                }
                                                if (!ci.name.equals(this.appSettings.getParserClassName())) break block6;
                                                this.checkForHooks(ci.body, this.appSettings.getParserClassName());
                                                break block6;
                                            }
                                            if (!(node instanceof TypeDeclaration)) break block7;
                                            typeDecl = (TypeDeclaration)node;
                                            typeName = typeDecl.getName();
                                            if (!typeName.equals(this.appSettings.getLexerClassName()) && !typeName.endsWith("." + this.appSettings.getLexerClassName())) break block8;
                                            ListIterator<Node> it = typeDecl.iterator();
                                            while (it.hasNext()) {
                                                this.checkForHooks((Node)it.next(), this.appSettings.getLexerClassName());
                                            }
                                            break block6;
                                        }
                                        if (!typeName.equals(this.appSettings.getParserClassName()) && !typeName.endsWith("." + this.appSettings.getParserClassName())) break block6;
                                        ListIterator<Node> it = typeDecl.iterator();
                                        while (it.hasNext()) {
                                            this.checkForHooks((Node)it.next(), this.appSettings.getParserClassName());
                                        }
                                        break block6;
                                    }
                                    if (!(node instanceof MethodDeclaration)) break block9;
                                    MethodDeclaration decl = (MethodDeclaration)node;
                                    String sig = decl.getFullSignature();
                                    closeNodePrefix = this.appSettings.generateIdentifierPrefix("closeNodeHook");
                                    if (sig == null) break block6;
                                    methodName = new StringTokenizer(sig, "(\n ").nextToken();
                                    if (!className.equals(this.appSettings.getLexerClassName())) break block10;
                                    String prefix = this.appSettings.generateIdentifierPrefix("tokenHook");
                                    resetPrefix = this.appSettings.generateIdentifierPrefix("resetTokenHook");
                                    if (!methodName.startsWith(prefix) && !methodName.equals("tokenHook") && !methodName.equals("CommonTokenAction")) break block11;
                                    this.lexerTokenHooks.add(methodName);
                                    break block6;
                                }
                                if (!methodName.startsWith(resetPrefix) && !methodName.startsWith("resetTokenHook$")) break block6;
                                this.resetTokenHooks.add(methodName);
                                break block6;
                            }
                            if (!className.equals(this.appSettings.getParserClassName())) break block12;
                            if (!methodName.startsWith("tokenHook$")) break block13;
                            this.parserTokenHooks.add(methodName);
                            break block6;
                        }
                        if (!methodName.startsWith("openNodeScopeHook")) break block14;
                        this.openNodeScopeHooks.add(methodName);
                        break block6;
                    }
                    if (!methodName.startsWith("closeNodeScopeHook")) break block6;
                    this.closeNodeScopeHooks.add(methodName);
                    break block6;
                }
                if (!methodName.startsWith(closeNodePrefix) && !methodName.startsWith("closeNodeHook$")) break block6;
                this.getCloseNodeScopeHooks(className).add(methodName);
                break block6;
            }
            ListIterator<Node> it = node.iterator();
            while (it.hasNext()) {
                this.checkForHooks((Node)it.next(), className);
            }
        }
    }

    public void addCodeInjection(Node n) {
        this.checkForHooks(n, null);
        this.codeInjections.add(n);
    }

    public boolean isInInclude() {
        return this.includeNesting > 0;
    }

    private boolean checkReferences() {
        List<NonTerminal> undefinedNTs = this.descendants(NonTerminal.class, nt -> nt.getProduction() == null);
        for (NonTerminal nt2 : undefinedNTs) {
            this.errors.addError(nt2, "Non-terminal " + nt2.getName() + " has not been defined.");
        }
        return undefinedNTs.isEmpty();
    }

    public void doSanityChecks() {
        Object lexicalStateName;
        if (this.defaultLexicalState == null) {
            this.setDefaultLexicalState("DEFAULT");
        }
        for (String string : this.lexicalStates) {
            this.lexerData.addLexicalState(string);
        }
        if (!this.checkReferences()) {
            return;
        }
        for (ExpansionSequence expansionSequence : this.descendants(ExpansionSequence.class)) {
            if (expansionSequence.getHasExplicitLookahead() && !expansionSequence.isAtChoicePoint()) {
                this.errors.addError(expansionSequence, "Encountered scanahead at a non-choice location.");
            }
            if (expansionSequence.getHasExplicitScanLimit() && !expansionSequence.isAtChoicePoint()) {
                this.errors.addError(expansionSequence, "Encountered an up-to-here marker at a non-choice location.");
            }
            if (expansionSequence.getHasExplicitLookahead() && expansionSequence.getHasSeparateSyntacticLookahead() && expansionSequence.getHasExplicitScanLimit()) {
                this.errors.addError(expansionSequence, "An expansion cannot have both syntactic lookahead and a scan limit.");
            }
            if (expansionSequence.getHasExplicitNumericalLookahead() && expansionSequence.getHasExplicitScanLimit()) {
                this.errors.addError(expansionSequence, "An expansion cannot have both numerical lookahead and a scan limit.");
            }
            if (!expansionSequence.getHasExplicitLookahead() || !expansionSequence.getHasExplicitLookahead() || expansionSequence.getHasSeparateSyntacticLookahead() || expansionSequence.getHasScanLimit() || expansionSequence.getHasExplicitNumericalLookahead() || expansionSequence.getMaximumSize() <= 1) continue;
            this.errors.addWarning(expansionSequence, "Expansion defaults to a lookahead of 1. In a similar spot in JavaCC 21, it would be an indefinite lookahead here, but this changed in Congo");
        }
        for (Expansion expansion : this.descendants(Expansion.class, Expansion::isScanLimit)) {
            if (((Expansion)expansion.getParent()).isAtChoicePoint()) continue;
            this.errors.addError(expansion, "The up-to-here delimiter can only be at a choice point.");
        }
        for (Expansion expansion : this.descendants(Expansion.class)) {
            lexicalStateName = expansion.getSpecifiedLexicalState();
            if (lexicalStateName == null || this.lexerData.getLexicalState((String)lexicalStateName) != null) continue;
            this.errors.addError(expansion, "Lexical state \"" + (String)lexicalStateName + "\" has not been defined.");
        }
        for (LookBehind lookBehind : this.getAllLookBehinds()) {
            for (String name : lookBehind.getPath()) {
                if (!Character.isJavaIdentifierStart(name.codePointAt(0)) || this.getProductionByName(name) != null) continue;
                this.errors.addError(lookBehind, "Predicate refers to undefined Non-terminal: " + name);
            }
        }
        for (RegexpSpec regexpSpec : this.descendants(RegexpSpec.class)) {
            String nextLexicalState = regexpSpec.getNextLexicalState();
            if (nextLexicalState == null || this.lexerData.getLexicalState(nextLexicalState) != null) continue;
            Node lastChild = regexpSpec.getChild(regexpSpec.getChildCount() - 1);
            this.errors.addError(lastChild, "Lexical state \"" + nextLexicalState + "\" has not been defined.");
        }
        for (RegexpSpec regexpSpec : this.descendants(RegexpSpec.class)) {
            if (!regexpSpec.getRegexp().matchesEmptyString()) continue;
            this.errors.addError(regexpSpec, "Regular Expression can match empty string. This is not allowed here.");
        }
        for (BNFProduction bNFProduction : this.descendants(BNFProduction.class)) {
            lexicalStateName = bNFProduction.getLexicalState();
            if (lexicalStateName != null && this.lexerData.getLexicalState((String)lexicalStateName) == null) {
                this.errors.addError(bNFProduction, "Lexical state \"" + (String)lexicalStateName + "\" has not been defined.");
            }
            if (!bNFProduction.isLeftRecursive()) continue;
            this.errors.addError(bNFProduction, "Production " + bNFProduction.getName() + " is left recursive.");
        }
        if (this.errors.getErrorCount() > 0) {
            return;
        }
        block9: for (ExpansionChoice expansionChoice : this.descendants(ExpansionChoice.class)) {
            List<ExpansionSequence> units = expansionChoice.getChoices();
            for (int i = 0; i < units.size(); ++i) {
                ExpansionSequence seq = units.get(i);
                if (!seq.isEnteredUnconditionally() || i >= units.size() - 1) continue;
                String msg = "This expansion is entered unconditionally but is not the last choice.";
                this.errors.addWarning(seq, msg);
                continue block9;
            }
        }
        for (ZeroOrOne zeroOrOne : this.descendants(ZeroOrOne.class)) {
            if (!zeroOrOne.getNestedExpansion().isEnteredUnconditionally() || zeroOrOne.getNestedExpansion() instanceof ExpansionChoice) continue;
            this.errors.addWarning(zeroOrOne, "The expansion inside the zero or one construct is entered unconditionally. This may not be your intention.");
        }
        for (ExpansionWithNested expansionWithNested : this.descendants(ExpansionWithNested.class, e -> e instanceof ZeroOrMore || e instanceof OneOrMore)) {
            if (!expansionWithNested.getNestedExpansion().isEnteredUnconditionally()) continue;
            this.errors.addError(expansionWithNested, "The expansion inside the zero or more construct at is entered unconditionally. This is not permitted here.");
        }
    }
}

