/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.congocc.core.BNFProduction;
import org.congocc.core.EmptyExpansion;
import org.congocc.core.Expansion;
import org.congocc.core.NonTerminal;
import org.congocc.core.TokenSet;
import org.congocc.parser.Node;
import org.congocc.parser.tree.ExpansionWithParentheses;
import org.congocc.parser.tree.Expression;
import org.congocc.parser.tree.Failure;
import org.congocc.parser.tree.LookBehind;
import org.congocc.parser.tree.Lookahead;

public class ExpansionSequence
extends Expansion {
    private Lookahead lookahead;

    List<Expansion> allUnits() {
        ArrayList<Expansion> result = new ArrayList<Expansion>();
        for (Expansion unit : this.childrenOfType(Expansion.class)) {
            result.add(unit);
            if (!unit.superfluousParentheses()) continue;
            result.addAll(unit.firstChildOfType(ExpansionSequence.class).allUnits());
        }
        return result;
    }

    Expansion firstNonEmpty() {
        for (Expansion unit : this.childrenOfType(Expansion.class)) {
            if (!(unit instanceof ExpansionWithParentheses && ((ExpansionWithParentheses)unit).superfluousParentheses() ? (unit = unit.firstChildOfType(ExpansionSequence.class).firstNonEmpty()) != null : !unit.isPossiblyEmpty())) continue;
            return unit;
        }
        return null;
    }

    @Override
    public TokenSet getFirstSet() {
        if (this.firstSet == null) {
            Expansion lookaheadExpansion;
            this.firstSet = new TokenSet(this.getGrammar());
            for (Expansion child : this.allUnits()) {
                this.firstSet.or(child.getFirstSet());
                if (child.isPossiblyEmpty()) continue;
                break;
            }
            if ((lookaheadExpansion = this.getLookaheadExpansion()) != this) {
                if (!this.getLookahead().isNegated()) {
                    this.firstSet.and(lookaheadExpansion.getFirstSet());
                } else if (lookaheadExpansion.isSingleToken()) {
                    this.firstSet.andNot(lookaheadExpansion.getFirstSet());
                }
            }
        }
        return this.firstSet;
    }

    @Override
    public TokenSet getFinalSet() {
        TokenSet finalSet = new TokenSet(this.getGrammar());
        List<Expansion> children = this.childrenOfType(Expansion.class);
        Collections.reverse(children);
        for (Expansion child : children) {
            finalSet.or(child.getFinalSet());
            if (child.isPossiblyEmpty()) continue;
            break;
        }
        return finalSet;
    }

    private boolean getRequiresScanAhead() {
        Lookahead la;
        if (this.getHasExplicitScanLimit()) {
            return true;
        }
        for (Expansion unit : this.allUnits()) {
            if (unit instanceof NonTerminal) {
                NonTerminal nt = (NonTerminal)unit;
                if (nt.getHasScanLimit()) {
                    return true;
                }
                if (nt.getProduction().getHasExplicitLookahead()) {
                    return true;
                }
            }
            if (unit.getMaximumSize() <= 0) continue;
            break;
        }
        return (la = this.getLookahead()) != null && la.getRequiresScanAhead();
    }

    public void setLookahead(Lookahead lookahead) {
        this.lookahead = lookahead;
    }

    @Override
    public Lookahead getLookahead() {
        if (this.lookahead != null) {
            return this.lookahead;
        }
        for (Expansion unit : this.childrenOfType(Expansion.class)) {
            ExpansionSequence seq;
            if (unit instanceof NonTerminal) {
                NonTerminal nt = (NonTerminal)unit;
                return nt.getLookahead();
            }
            if (unit.superfluousParentheses() && (seq = unit.firstChildOfType(ExpansionSequence.class)) != null) {
                return seq.getLookahead();
            }
            if (unit.getMaximumSize() <= 0) continue;
            break;
        }
        return null;
    }

    public boolean getHasExplicitLookahead() {
        return this.lookahead != null;
    }

    @Override
    public int getMinimumSize(Set<String> visitedNonTerminals) {
        if (this.minSize >= 0) {
            return this.minSize;
        }
        int result = 0;
        for (Expansion unit : this.childrenOfType(Expansion.class)) {
            int minUnit = unit.getMinimumSize(visitedNonTerminals);
            if (minUnit == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            result += minUnit;
        }
        return result;
    }

    @Override
    public int getMaximumSize(Set<String> visitedNonTerminals) {
        if (this.maxSize >= 0) {
            return this.maxSize;
        }
        int result = 0;
        for (Expansion exp : this.childrenOfType(Expansion.class)) {
            int max = exp.getMaximumSize(visitedNonTerminals);
            if (max == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            result += max;
        }
        this.maxSize = result;
        return this.maxSize;
    }

    @Override
    public boolean getHasScanLimit() {
        boolean atStart = true;
        for (Expansion unit : this.allUnits()) {
            if (unit.isScanLimit()) {
                return true;
            }
            if (atStart && unit instanceof NonTerminal) {
                atStart = false;
                if (unit.getHasScanLimit()) {
                    return true;
                }
            }
            if (unit instanceof EmptyExpansion) continue;
            atStart = false;
        }
        return false;
    }

    @Override
    public boolean getHasExplicitScanLimit() {
        return this.allUnits().stream().anyMatch(Expansion::isScanLimit);
    }

    public List<Expansion> getUnits() {
        return this.childrenOfType(Expansion.class);
    }

    @Override
    public boolean potentiallyStartsWith(String productionName, Set<String> alreadyVisited) {
        boolean result = false;
        for (Expansion unit : this.allUnits()) {
            if (unit.potentiallyStartsWith(productionName, alreadyVisited)) {
                result = true;
            }
            if (unit.isPossiblyEmpty()) continue;
            break;
        }
        return result;
    }

    @Override
    public int getLookaheadAmount() {
        if (this.getHasExplicitScanLimit()) {
            return Integer.MAX_VALUE;
        }
        Lookahead la = this.getLookahead();
        if (la != null) {
            return la.getAmount();
        }
        return this.getRequiresScanAhead() ? Integer.MAX_VALUE : 1;
    }

    @Override
    public boolean getHasSeparateSyntacticLookahead() {
        Lookahead la = this.getLookahead();
        return la != null && la.getNestedExpansion() != null;
    }

    @Override
    public Expansion getLookaheadExpansion() {
        Lookahead la = this.getLookahead();
        Expansion exp = la == null ? null : la.getNestedExpansion();
        return exp != null ? exp : this;
    }

    @Override
    public boolean isNegated() {
        return this.getLookahead() != null && this.getLookahead().isNegated();
    }

    @Override
    public LookBehind getLookBehind() {
        Lookahead la = this.getLookahead();
        return la == null ? null : la.getLookBehind();
    }

    @Override
    public final Expression getSemanticLookahead() {
        Lookahead la = this.getLookahead();
        return la == null ? null : la.getSemanticLookahead();
    }

    @Override
    public boolean getHasNumericalLookahead() {
        Lookahead la = this.getLookahead();
        return la != null && la.getHasExplicitNumericalAmount();
    }

    public boolean getHasExplicitNumericalLookahead() {
        return this.lookahead != null && this.lookahead.getHasExplicitNumericalAmount();
    }

    @Override
    public boolean getHasSemanticLookahead() {
        Lookahead la = this.getLookahead();
        return la != null && la.hasSemanticLookahead();
    }

    @Override
    boolean getHasImplicitSyntacticLookahead() {
        if (!this.isAtChoicePoint()) {
            return false;
        }
        if (this.getHasSeparateSyntacticLookahead()) {
            return false;
        }
        if (this.getHasScanLimit()) {
            return true;
        }
        if (this.getHasExplicitNumericalLookahead() && this.getLookaheadAmount() == 0) {
            return false;
        }
        return this.getLookahead() != null;
    }

    @Override
    public boolean isSingleTokenLookahead() {
        if (!super.isSingleTokenLookahead()) {
            return false;
        }
        for (Expansion exp : this.allUnits()) {
            if (exp.getMaximumSize() != 1 || exp.isSingleTokenLookahead()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean startsWithLexicalChange() {
        Node parent = this.getParent();
        if (parent instanceof BNFProduction && ((BNFProduction)parent).getLexicalState() != null) {
            return true;
        }
        for (Expansion exp : this.childrenOfType(Expansion.class)) {
            if (exp.startsWithLexicalChange()) {
                return true;
            }
            if (exp.isPossiblyEmpty()) continue;
            break;
        }
        return false;
    }

    @Override
    public boolean startsWithGlobalCodeAction() {
        for (Expansion exp : this.allUnits()) {
            if (exp.startsWithGlobalCodeAction()) {
                return true;
            }
            if (exp.isPossiblyEmpty()) continue;
            break;
        }
        return false;
    }

    @Override
    public final boolean getRequiresPredicateMethod() {
        if (!this.isAtChoicePoint()) {
            return false;
        }
        return this.getLookahead() != null && this.getLookahead().getRequiresScanAhead() || this.getHasImplicitSyntacticLookahead() || this.startsWithGlobalCodeAction() || this.startsWithLexicalChange();
    }

    public boolean isFailure() {
        for (Expansion exp : this.allUnits()) {
            if (!(exp instanceof Failure)) continue;
            return true;
        }
        return false;
    }
}

