/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.codegen.python;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.congocc.codegen.Translator;
import org.congocc.codegen.java.CodeInjector;
import org.congocc.core.Grammar;
import org.congocc.parser.CongoCCParser;
import org.congocc.parser.Node;
import org.congocc.parser.ParseException;
import org.congocc.parser.tree.ClassOrInterfaceBodyDeclaration;
import org.congocc.parser.tree.Expression;
import org.congocc.parser.tree.FieldDeclaration;
import org.congocc.parser.tree.FormalParameter;
import org.congocc.parser.tree.MethodDeclaration;

public class PythonTranslator
extends Translator {
    private static final Set<String> specialPrefixes = new HashSet<String>();
    protected static Set<String> leaveAsMethods = new HashSet<String>(Arrays.asList("getIndents", "isConstant"));

    public PythonTranslator(Grammar grammar) {
        super(grammar);
        this.methodIndent = 4;
        this.fieldIndent = 8;
        this.includeInitializers = true;
    }

    @Override
    public String translateOperator(String operator) {
        String result;
        switch (result = operator) {
            case "||": {
                result = "or";
                break;
            }
            case "&&": {
                result = "and";
                break;
            }
            case "!": {
                result = "not";
            }
        }
        return result;
    }

    private static boolean isSpecialPrefix(String ident) {
        boolean result = false;
        for (String p : specialPrefixes) {
            if (!ident.startsWith(p)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public String translateIdentifier(String ident, Translator.TranslationContext kind) {
        String result = ident;
        if (specialPrefixes.isEmpty()) {
            specialPrefixes.add(this.grammar.getAppSettings().generateIdentifierPrefix("tokenHook"));
        }
        if (ident.equals("null")) {
            result = "None";
        } else if (ident.equals("true")) {
            result = "True";
        } else if (ident.equals("false")) {
            result = "False";
        } else if (ident.equals("this")) {
            result = "self";
        } else if (ident.equals("currentLookaheadToken") || ident.equals("lastConsumedToken")) {
            result = String.format("self.%s", PythonTranslator.camelToSnake(ident));
        } else if (ident.equals("toString")) {
            result = "__str__";
        } else if (Character.isLowerCase(ident.charAt(0)) && !PythonTranslator.isSpecialPrefix(ident)) {
            result = PythonTranslator.camelToSnake(result);
        } else if (ident.equals("LEXER_CLASS")) {
            result = "Lexer";
        } else if (ident.equals("PARSER_CLASS")) {
            result = "Parser";
        } else if (ident.equals("BASE_TOKEN_CLASS")) {
            result = "Token";
        } else if (ident.startsWith("NODE_PACKAGE.")) {
            result = ident.substring(13);
        } else if (ident.equals("DirectiveLine")) {
            result = "parse_DirectiveLine";
        }
        return result;
    }

    @Override
    public String translateGetter(String getterName) {
        if (getterName.startsWith("is")) {
            return this.translateIdentifier(getterName, Translator.TranslationContext.METHOD);
        }
        if (!getterName.startsWith("get")) {
            return this.translateIdentifier(getterName, Translator.TranslationContext.METHOD);
        }
        String result = Character.toLowerCase(getterName.charAt(3)) + getterName.substring(4);
        return this.translateIdentifier(result, Translator.TranslationContext.METHOD);
    }

    @Override
    protected boolean needsParentheses(Translator.ASTExpression expr) {
        String op;
        boolean result = true;
        if (expr instanceof Translator.ASTPrimaryExpression || expr instanceof Translator.ASTInstanceofExpression || expr instanceof Translator.ASTUnaryExpression) {
            result = false;
        } else if (expr instanceof Translator.ASTBinaryExpression && ((op = ((Translator.ASTBinaryExpression)expr).getOp()).equals(".") || op.equals("="))) {
            result = false;
        }
        return result;
    }

    private boolean shouldAddSelf(Translator.ASTPrimaryExpression expr) {
        Translator.ASTBinaryExpression be;
        boolean result = true;
        Translator.ASTHelperNode parent = expr.getParent();
        if (parent != null && parent instanceof Translator.ASTBinaryExpression && (be = (Translator.ASTBinaryExpression)parent).getOp().equals(".") && expr == be.getRhs()) {
            result = false;
        }
        return result;
    }

    @Override
    protected void translatePrimaryExpression(Translator.ASTPrimaryExpression expr, Translator.TranslationContext ctx, StringBuilder result) {
        String s = expr.getLiteral();
        String n = expr.getName();
        boolean isName = false;
        if (s == null) {
            s = this.translateIdentifier(n, Translator.TranslationContext.VARIABLE);
            isName = true;
        } else {
            switch (s) {
                case "null": {
                    s = "None";
                    break;
                }
                case "true": {
                    s = "True";
                    break;
                }
                case "false": {
                    s = "False";
                    break;
                }
                case "this": {
                    s = "self";
                }
            }
        }
        if (isName && !this.isParameterName(n) && this.findSymbol(n) == null && this.fields.containsKey(n)) {
            boolean addSelf = this.shouldAddSelf(expr);
            if (addSelf) {
                result.append("self.");
            }
            if (this.properties.containsKey(n)) {
                result.append('_');
            }
        }
        result.append(s);
    }

    @Override
    protected void translateUnaryExpression(Translator.ASTUnaryExpression expr, Translator.TranslationContext ctx, StringBuilder result) {
        String xop = this.translateOperator(expr.getOp());
        boolean parens = this.needsParentheses(expr);
        if (xop.equals("++") || xop.equals("--")) {
            this.internalTranslateExpression(expr.getOperand(), Translator.TranslationContext.UNKNOWN, result);
            result.append(' ');
            result.append(xop.charAt(0));
            result.append("= 1");
        } else {
            if (parens) {
                result.append('(');
            }
            result.append(xop);
            if (xop.equals("not")) {
                result.append(' ');
            }
            this.internalTranslateExpression(expr.getOperand(), Translator.TranslationContext.UNKNOWN, result);
            if (parens) {
                result.append(')');
            }
        }
    }

    @Override
    protected void translateBinaryExpression(Translator.ASTBinaryExpression expr, StringBuilder result) {
        String xop = this.translateOperator(expr.getOp());
        boolean parens = this.needsParentheses(expr);
        Translator.ASTExpression lhs = expr.getLhs();
        Translator.ASTExpression rhs = expr.getRhs();
        if (this.isNull(rhs)) {
            if (xop.equals("==")) {
                xop = "is";
            } else if (xop.equals("!=")) {
                xop = "is not";
            }
        }
        this.processBinaryExpression(parens, lhs, xop, rhs, result);
    }

    @Override
    protected void translateInstanceofExpression(Translator.ASTInstanceofExpression expr, StringBuilder result) {
        result.append("isinstance(");
        this.internalTranslateExpression(expr.getInstance(), Translator.TranslationContext.UNKNOWN, result);
        result.append(", ");
        this.internalTranslateExpression(expr.getType(), Translator.TranslationContext.UNKNOWN, result);
        result.append(')');
    }

    @Override
    protected void translateArrayAccess(Translator.ASTArrayAccess expr, StringBuilder result) {
        this.internalTranslateExpression(expr.getArray(), Translator.TranslationContext.UNKNOWN, result);
        result.append('[');
        this.internalTranslateExpression(expr.getIndex(), Translator.TranslationContext.UNKNOWN, result);
        result.append(']');
    }

    @Override
    protected void translateTernaryExpression(Translator.ASTTernaryExpression expr, StringBuilder result) {
        boolean parens = this.needsParentheses(expr);
        Translator.ASTExpression condition = expr.getCondition();
        Translator.ASTExpression trueValue = expr.getTrueValue();
        Translator.ASTExpression falseValue = expr.getFalseValue();
        if (parens) {
            result.append('(');
        }
        this.internalTranslateExpression(trueValue, Translator.TranslationContext.UNKNOWN, result);
        result.append(" if ");
        this.internalTranslateExpression(condition, Translator.TranslationContext.UNKNOWN, result);
        result.append(" else ");
        this.internalTranslateExpression(falseValue, Translator.TranslationContext.UNKNOWN, result);
        if (parens) {
            result.append(')');
        }
    }

    void renderReceiver(Translator.ASTExpression expr, StringBuilder result) {
        if (expr instanceof Translator.ASTBinaryExpression) {
            this.internalTranslateExpression(((Translator.ASTBinaryExpression)expr).getLhs(), Translator.TranslationContext.UNKNOWN, result);
        } else if (expr instanceof Translator.ASTPrimaryExpression) {
            result.append("self");
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected boolean treatAsProperty(String methodName) {
        return this.isGetter(methodName) || methodName.equals("previousCachedToken");
    }

    @Override
    protected void translateInvocation(Translator.ASTInvocation expr, StringBuilder result) {
        Translator.ASTExpression firstArg;
        String methodName = expr.getMethodName();
        int nargs = expr.getArgCount();
        Translator.ASTExpression receiver = expr.getReceiver();
        Translator.ASTExpression aSTExpression = firstArg = nargs != 1 ? null : expr.getArguments().get(0);
        if (methodName.equals("equals") && nargs == 1) {
            this.renderReceiver(receiver, result);
            result.append(" == ");
            this.internalTranslateExpression(firstArg, Translator.TranslationContext.UNKNOWN, result);
        } else if ((methodName.equals("contains") || methodName.equals("containsKey")) && nargs == 1) {
            this.internalTranslateExpression(firstArg, Translator.TranslationContext.UNKNOWN, result);
            result.append(" in ");
            this.renderReceiver(receiver, result);
        } else if (methodName.equals("get") && nargs == 1) {
            this.renderReceiver(receiver, result);
            result.append('[');
            this.internalTranslateExpression(firstArg, Translator.TranslationContext.UNKNOWN, result);
            result.append(']');
        } else if (methodName.equals("toString") && nargs == 0) {
            result.append("str(");
            this.renderReceiver(receiver, result);
            result.append(')');
        } else if ((methodName.equals("size") || methodName.equals("length")) && nargs == 0) {
            result.append("len(");
            this.renderReceiver(receiver, result);
            result.append(')');
        } else if (methodName.equals("charAt") && nargs == 1) {
            this.renderReceiver(receiver, result);
            result.append('[');
            this.internalTranslateExpression(firstArg, Translator.TranslationContext.PARAMETER, result);
            result.append(']');
        } else if (methodName.equals("isParserTolerant") && nargs == 0) {
            this.renderReceiver(receiver, result);
            result.append(".is_tolerant");
        } else if (nargs == 0 && this.treatAsProperty(methodName) && !leaveAsMethods.contains(methodName)) {
            this.renderReceiver(receiver, result);
            result.append('.');
            result.append(this.translateGetter(methodName));
        } else if (methodName.equals("nodeArity") && nargs == 0) {
            this.renderReceiver(receiver, result);
            result.append(".node_arity");
        } else if (methodName.equals("setUnparsed") && nargs == 1) {
            this.renderReceiver(receiver, result);
            result.append(".is_unparsed = ");
            this.internalTranslateExpression(firstArg, Translator.TranslationContext.UNKNOWN, result);
        } else if (methodName.equals("of") && this.isEnumSet(receiver)) {
            result.append("_Set({");
            if (nargs > 0) {
                this.translateArguments(expr.getArguments(), false, result);
            }
            result.append("})");
        } else if (this.isSetter(methodName) && nargs == 1) {
            String s = this.translateIdentifier(methodName, Translator.TranslationContext.METHOD);
            this.renderReceiver(receiver, result);
            result.append('.');
            result.append(s.substring(4));
            result.append(" = ");
            this.internalTranslateExpression(firstArg, Translator.TranslationContext.UNKNOWN, result);
        } else if (expr instanceof Translator.ASTAllocation) {
            if (this.isList(receiver)) {
                result.append("_List");
                this.translateArguments(expr.getArguments(), true, result);
            } else {
                this.internalTranslateExpression(receiver, Translator.TranslationContext.UNKNOWN, result);
                this.translateArguments(expr.getArguments(), true, result);
            }
        } else {
            if (!methodName.equals("newToken")) {
                this.renderReceiver(receiver, result);
                result.append('.');
            }
            String ident = this.translateIdentifier(methodName, Translator.TranslationContext.METHOD);
            result.append(ident);
            this.translateArguments(expr.getArguments(), true, result);
        }
    }

    private boolean shouldIndent(Translator.ASTStatement stmt) {
        boolean result = true;
        if (stmt instanceof Translator.ASTStatementList) {
            result = ((Translator.ASTStatementList)stmt).getStatements() == null;
        } else if (stmt instanceof Translator.ASTVariableOrFieldDeclaration) {
            Translator.ASTVariableOrFieldDeclaration d = (Translator.ASTVariableOrFieldDeclaration)stmt;
            result = d.isField() || d.hasInitializer();
        }
        return result;
    }

    protected void translateIf(Translator.ASTIfStatement stmt, int indent, boolean first, StringBuilder result) {
        if (first) {
            result.append("if ");
        } else {
            this.addIndent(indent, result);
            result.append("elif ");
        }
        this.internalTranslateExpression(stmt.getCondition(), Translator.TranslationContext.UNKNOWN, result);
        result.append(":\n");
        this.internalTranslateStatement(stmt.getThenStmts(), indent + 4, result);
        Translator.ASTStatement estmt = stmt.getElseStmts();
        if (estmt != null) {
            if (!(estmt instanceof Translator.ASTIfStatement)) {
                this.addIndent(indent, result);
                result.append("else:\n");
                this.internalTranslateStatement(estmt, indent + 4, result);
            } else {
                this.translateIf((Translator.ASTIfStatement)estmt, indent, false, result);
            }
        }
    }

    @Override
    protected void internalTranslateStatement(Translator.ASTStatement stmt, int indent, StringBuilder result) {
        boolean addNewline = false;
        boolean doIndent = this.shouldIndent(stmt);
        if (doIndent) {
            this.addIndent(indent, result);
        }
        if (stmt instanceof Translator.ASTExpressionStatement) {
            this.internalTranslateExpression(((Translator.ASTExpressionStatement)stmt).getValue(), Translator.TranslationContext.UNKNOWN, result);
            addNewline = true;
        } else if (stmt instanceof Translator.ASTStatementList) {
            List<Translator.ASTStatement> statements = ((Translator.ASTStatementList)stmt).getStatements();
            if (statements == null) {
                result.append("pass\n");
            } else {
                for (Translator.ASTStatement s : statements) {
                    this.internalTranslateStatement(s, indent, result);
                }
            }
        } else if (stmt instanceof Translator.ASTVariableOrFieldDeclaration) {
            Translator.ASTVariableOrFieldDeclaration vd = (Translator.ASTVariableOrFieldDeclaration)stmt;
            List<Translator.ASTPrimaryExpression> names = vd.getNames();
            List<Translator.ASTExpression> initializers = vd.getInitializers();
            Translator.ASTTypeExpression type = vd.getType();
            int n = names.size();
            String defaultInitializer = "None";
            boolean isProperty = vd.hasAnnotation("Property");
            boolean isField = vd.isField();
            if ((isProperty || isField) && type.isNumeric()) {
                defaultInitializer = "0";
            }
            for (int i = 0; i < n; ++i) {
                Translator.ASTPrimaryExpression name = names.get(i);
                Translator.ASTExpression initializer = initializers.get(i);
                this.processVariableDeclaration(type, name, isField, isProperty);
                if (!isField && initializer == null) continue;
                this.internalTranslateExpression(name, Translator.TranslationContext.UNKNOWN, result);
                result.append(" = ");
                if (initializer == null) {
                    result.append(defaultInitializer);
                } else {
                    this.internalTranslateExpression(initializer, Translator.TranslationContext.UNKNOWN, result);
                }
                if (i < n - 1) {
                    result.append("; ");
                }
                addNewline = true;
            }
        } else if (stmt instanceof Translator.ASTReturnStatement) {
            result.append("return");
            Translator.ASTExpression value = ((Translator.ASTReturnStatement)stmt).getValue();
            if (value != null) {
                result.append(' ');
                this.internalTranslateExpression(value, Translator.TranslationContext.UNKNOWN, result);
            }
            addNewline = true;
        } else if (stmt instanceof Translator.ASTBreakStatement) {
            result.append("break");
            addNewline = true;
        } else if (stmt instanceof Translator.ASTContinueStatement) {
            result.append("continue");
            addNewline = true;
        } else if (stmt instanceof Translator.ASTIfStatement) {
            this.translateIf((Translator.ASTIfStatement)stmt, indent, true, result);
        } else if (stmt instanceof Translator.ASTWhileStatement) {
            Translator.ASTWhileStatement s = (Translator.ASTWhileStatement)stmt;
            result.append("while ");
            this.internalTranslateExpression(s.getCondition(), Translator.TranslationContext.UNKNOWN, result);
            result.append(":\n");
            this.internalTranslateStatement(s.getStatements(), indent + 4, result);
        } else if (stmt instanceof Translator.ASTAssertStatement) {
            Translator.ASTAssertStatement s = (Translator.ASTAssertStatement)stmt;
            result.append("if not (");
            this.internalTranslateExpression(s.getCondition(), Translator.TranslationContext.UNKNOWN, result);
            result.append("):\n");
            this.addIndent(indent + 4, result);
            Translator.ASTExpression m = s.getMessage();
            if (m == null) {
                result.append("raise AssertionError()\n");
            } else {
                result.append("raise AssertionError(str(");
                this.internalTranslateExpression(m, Translator.TranslationContext.UNKNOWN, result);
                result.append("))\n");
            }
        } else if (stmt instanceof Translator.ASTForStatement) {
            Translator.ASTForStatement s = (Translator.ASTForStatement)stmt;
            Translator.ASTVariableOrFieldDeclaration decl = s.getVariable();
            Translator.ASTExpression iterable = s.getIterable();
            if (iterable != null) {
                Translator.ASTVariableOrFieldDeclaration vd = s.getVariable();
                result.append("for ");
                this.internalTranslateExpression(vd.getNames().get(0), Translator.TranslationContext.UNKNOWN, result);
                result.append(" in ");
                this.internalTranslateExpression(iterable, Translator.TranslationContext.UNKNOWN, result);
                result.append(":\n");
                this.internalTranslateStatement(s.getStatements(), indent + 4, result);
            } else {
                List<Translator.ASTPrimaryExpression> names = decl.getNames();
                List<Translator.ASTExpression> initializers = decl.getInitializers();
                int n = names.size();
                for (int i = 0; i < n; ++i) {
                    Translator.ASTExpression name = names.get(i);
                    Translator.ASTExpression initializer = initializers.get(i);
                    if (initializer == null) continue;
                    this.internalTranslateExpression(name, Translator.TranslationContext.UNKNOWN, result);
                    result.append(" = ");
                    this.internalTranslateExpression(initializer, Translator.TranslationContext.UNKNOWN, result);
                    if (i >= n - 1) continue;
                    result.append("; ");
                }
                result.append('\n');
                this.addIndent(indent, result);
                result.append("while ");
                this.internalTranslateExpression(s.getCondition(), Translator.TranslationContext.UNKNOWN, result);
                result.append(":\n");
                this.internalTranslateStatement(s.getStatements(), indent + 4, result);
                List<Translator.ASTExpression> iteration = s.getIteration();
                if (iteration != null) {
                    this.processForIteration(iteration, indent + 4, result);
                    result.append('\n');
                }
            }
        } else if (stmt instanceof Translator.ASTSwitchStatement) {
            Translator.ASTSwitchStatement s = (Translator.ASTSwitchStatement)stmt;
            String tv = this.getTempVarName();
            result.append(tv);
            result.append(" = ");
            this.internalTranslateExpression(s.getVariable(), Translator.TranslationContext.UNKNOWN, result);
            result.append('\n');
            boolean useIf = true;
            for (Translator.ASTCaseStatement c : s.getCases()) {
                List<Translator.ASTExpression> labels = c.getCaseLabels();
                int lc = labels.size();
                this.addIndent(indent, result);
                if (lc == 0) {
                    result.append("else:\n");
                } else {
                    result.append(useIf ? "if " : "elif ");
                    result.append(tv);
                    if (lc == 1) {
                        result.append(" == ");
                        this.internalTranslateExpression(labels.get(0), Translator.TranslationContext.UNKNOWN, result);
                    } else {
                        result.append(" in (");
                        for (int i = 0; i < lc; ++i) {
                            this.internalTranslateExpression(labels.get(i), Translator.TranslationContext.UNKNOWN, result);
                            if (i >= lc - 1) continue;
                            result.append(", ");
                        }
                        result.append(')');
                    }
                    result.append(":\n");
                }
                this.internalTranslateStatement(c.getStatements(), indent + 4, result);
                useIf = !c.hasBreak();
            }
        } else if (stmt instanceof Translator.ASTMethodDeclaration) {
            Translator.ASTMethodDeclaration decl = (Translator.ASTMethodDeclaration)stmt;
            String methodName = decl.isConstructor() ? "__init__" : this.translateIdentifier(decl.getName(), Translator.TranslationContext.METHOD);
            List<Translator.ASTFormalParameter> formals = decl.getParameters();
            Translator.SymbolTable symbols = new Translator.SymbolTable();
            boolean isStatic = false;
            this.pushSymbols(symbols);
            List<String> modifiers = decl.getModifiers();
            if (modifiers != null && modifiers.contains("static")) {
                result.append("@staticmethod\n");
                this.addIndent(indent, result);
                isStatic = true;
            }
            result.append("def ");
            result.append(methodName);
            if (isStatic) {
                result.append('(');
            } else {
                result.append("(self");
                if (formals != null) {
                    result.append(", ");
                }
            }
            if (formals != null) {
                this.translateFormals(formals, symbols, false, false, result);
            }
            result.append("):\n");
            this.internalTranslateStatement(decl.getStatements(), indent + 4, result);
            result.append('\n');
            this.popSymbols();
        } else if (stmt instanceof Translator.ASTTryStatement) {
            Translator.ASTStatement fb;
            Translator.ASTTryStatement tryStmt = (Translator.ASTTryStatement)stmt;
            result.append("try:\n");
            this.internalTranslateStatement(tryStmt.getBlock(), indent + 4, result);
            List<Translator.ASTExceptionInfo> catchBlocks = tryStmt.getCatchBlocks();
            if (catchBlocks != null) {
                for (Translator.ASTExceptionInfo cb : catchBlocks) {
                    boolean multiple;
                    this.addIndent(indent, result);
                    result.append("except ");
                    List<Translator.ASTTypeExpression> infos = cb.getExceptionTypes();
                    int n = infos.size();
                    boolean bl = multiple = n > 1;
                    if (multiple) {
                        result.append('(');
                    }
                    for (int i = 0; i < n; ++i) {
                        Translator.ASTTypeExpression te = infos.get(i);
                        this.internalTranslateExpression(te, Translator.TranslationContext.TYPE, result);
                        if (i >= n - 1) continue;
                        result.append(", ");
                    }
                    if (multiple) {
                        result.append(')');
                    }
                    result.append(" as ");
                    result.append(cb.getVariable());
                    result.append(":\n");
                    this.internalTranslateStatement(cb.getBlock(), indent + 4, result);
                }
            }
            if ((fb = tryStmt.getFinallyBlock()) != null) {
                this.addIndent(indent, result);
                result.append("finally:\n");
                this.internalTranslateStatement(fb, indent + 4, result);
            }
        } else if (stmt instanceof Translator.ASTEnumDeclaration) {
            Translator.ASTEnumDeclaration enumDecl = (Translator.ASTEnumDeclaration)stmt;
            result.append("@unique\n");
            this.addIndent(indent, result);
            result.append("class ");
            result.append(enumDecl.getName());
            result.append("(Enum):\n");
            List<String> values = enumDecl.getValues();
            if (values == null) {
                this.addIndent(indent + 4, result);
                result.append("pass\n\n");
            } else {
                for (String s : values) {
                    this.addIndent(indent + 4, result);
                    result.append(s);
                    result.append(" = auto()\n");
                }
                result.append('\n');
            }
        } else if (stmt instanceof Translator.ASTClassDeclaration) {
            Translator.ASTClassDeclaration classDecl = (Translator.ASTClassDeclaration)stmt;
            List<Translator.ASTStatement> decls = classDecl.getDeclarations();
            result.append("class ");
            result.append(classDecl.getName());
            result.append(":\n");
            if (decls == null) {
                this.addIndent(indent + 4, result);
                result.append("pass\n");
            } else {
                for (Translator.ASTStatement decl : decls) {
                    if (decl instanceof Translator.ASTVariableOrFieldDeclaration) continue;
                    this.internalTranslateStatement(decl, indent + 4, result);
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
        if (addNewline) {
            result.append('\n');
        }
    }

    @Override
    public void translateProperties(String name, int indent, StringBuilder result) {
        super.translateProperties(name, indent, result);
        if (!this.properties.isEmpty()) {
            for (String prop : this.properties.keySet()) {
                String s = this.translateIdentifier(prop, Translator.TranslationContext.FIELD);
                this.addIndent(indent, result);
                result.append("@property\n");
                this.addIndent(indent, result);
                result.append("def ");
                result.append(s);
                result.append("(self):\n");
                this.addIndent(indent + 4, result);
                result.append("return self._");
                result.append(s);
                result.append("\n\n");
                this.addIndent(indent, result);
                result.append('@');
                result.append(s);
                result.append(".setter\n");
                this.addIndent(indent, result);
                result.append("def ");
                result.append(s);
                result.append("(self, value):\n");
                this.addIndent(indent + 4, result);
                result.append("self._");
                result.append(s);
                result.append(" = value");
                result.append("\n\n");
            }
        }
    }

    @Override
    public String translateNonterminalArgs(String args) {
        CongoCCParser parser = new CongoCCParser(String.format("(%s)", args));
        try {
            parser.InvocationArguments();
            Node node = parser.rootNode();
            StringBuilder result = new StringBuilder();
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                Node child = node.getChild(i);
                if (!(child instanceof Expression)) continue;
                Translator.ASTExpression expr = (Translator.ASTExpression)this.transformTree(child);
                this.internalTranslateExpression(expr, Translator.TranslationContext.UNKNOWN, result);
                result.append(", ");
            }
            result.setLength(result.length() - 2);
            return result.toString();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String translateInjectedClass(CodeInjector injector, String name) {
        StringBuilder result = new StringBuilder();
        String qualifiedName = String.format("%s.%s", this.appSettings.getNodePackage(), name);
        List<String> nameList = injector.getParentClasses(qualifiedName);
        List<ClassOrInterfaceBodyDeclaration> decls = injector.getBodyDeclarations(qualifiedName);
        int n = decls.size();
        nameList.remove("Node");
        for (String s : new ArrayList<String>(nameList)) {
            String q;
            List<ClassOrInterfaceBodyDeclaration> dl;
            if (!this.grammar.nodeIsInterface(s) || (dl = injector.getBodyDeclarations(q = String.format("%s.%s", this.appSettings.getNodePackage(), s))) != null) continue;
            nameList.remove(s);
        }
        result.append("class ");
        result.append(name);
        result.append('(');
        result.append(String.join((CharSequence)", ", nameList));
        result.append("):");
        if (n == 0) {
            result.append(" pass\n");
        } else {
            result.append('\n');
            ArrayList<FieldDeclaration> fieldDecls = new ArrayList<FieldDeclaration>();
            for (ClassOrInterfaceBodyDeclaration decl : decls) {
                if (!(decl instanceof FieldDeclaration)) continue;
                fieldDecls.add((FieldDeclaration)decl);
            }
            this.clearFields();
            if (!fieldDecls.isEmpty()) {
                result.append("    def __init__(self, input_source=None):\n");
                result.append("        super().__init__(input_source)\n");
                for (FieldDeclaration fd : fieldDecls) {
                    this.translateStatement(fd, 8, result);
                }
                result.append('\n');
            }
            this.translateProperties(name, 4, result);
            for (ClassOrInterfaceBodyDeclaration decl : decls) {
                if (decl instanceof FieldDeclaration) continue;
                if (decl instanceof MethodDeclaration) {
                    this.translateStatement(decl, 4, result);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
        return result.toString();
    }

    @Override
    protected void translateCast(Translator.ASTTypeExpression cast, StringBuilder result) {
    }

    @Override
    public void translateFormals(List<FormalParameter> formals, Translator.SymbolTable symbols, StringBuilder result) {
        this.translateFormals(this.transformFormals(formals), symbols, false, false, result);
    }

    @Override
    public void translateImport(String javaName, StringBuilder result) {
        int n;
        String prefix = String.format("%s.", this.grammar.getAppSettings().getParserPackage());
        if (!javaName.startsWith(prefix)) {
            throw new UnsupportedOperationException();
        }
        javaName = javaName.substring(prefix.length());
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(javaName.split("\\.")));
        String from = null;
        String s = (String)parts.get(0);
        if (Character.isLowerCase(s.charAt(0))) {
            from = String.format("%sparser", s);
            parts.remove(0);
        }
        if ((n = parts.size()) == 0 || n > 2) {
            throw new UnsupportedOperationException();
        }
        s = (String)parts.get(0);
        String suffix = null;
        if (s.endsWith("Parser")) {
            suffix = "Parser";
        } else if (s.endsWith("Lexer")) {
            suffix = "Lexer";
        }
        if (n == 1) {
            if (suffix != null) {
                result.append("from ").append(from).append(" import ").append(suffix).append(" as ").append(s).append('\n');
            }
        } else {
            result.append("from ").append(from);
            if (suffix != null) {
                result.append('.').append(suffix.toLowerCase());
            }
            result.append(" import ").append((String)parts.get(1)).append('\n');
        }
    }

    @Override
    public void endClass(String name, boolean fields, StringBuilder result) {
        if (!fields && this.nestedDeclarations != null) {
            result.append('\n');
            for (Map.Entry kv : this.nestedDeclarations.entrySet()) {
                String cn = (String)kv.getKey();
                if (cn.endsWith("Lexer")) {
                    cn = "Lexer";
                } else if (cn.endsWith("Parser")) {
                    cn = "Parser";
                }
                for (String s : (Set)kv.getValue()) {
                    result.append(s).append(" = ").append(cn).append('.').append(s).append('\n');
                }
            }
        }
        super.endClass(name, fields, result);
    }

    @Override
    public void translateEmptyBlock(int indent, StringBuilder result) {
        this.addIndent(indent, result);
        result.append("pass  # empty code block\n");
    }
}

