/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.codegen.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.congocc.app.AppSettings;
import org.congocc.core.Grammar;
import org.congocc.parser.Node;
import org.congocc.parser.tree.Annotation;
import org.congocc.parser.tree.ClassOrInterfaceBody;
import org.congocc.parser.tree.ClassOrInterfaceBodyDeclaration;
import org.congocc.parser.tree.CodeInjection;
import org.congocc.parser.tree.CompilationUnit;
import org.congocc.parser.tree.ImportDeclaration;
import org.congocc.parser.tree.InterfaceDeclaration;
import org.congocc.parser.tree.MethodDeclaration;
import org.congocc.parser.tree.ObjectType;
import org.congocc.parser.tree.TypeDeclaration;
import org.congocc.parser.tree.TypeParameters;

public class CodeInjector {
    private final Map<String, TypeDeclaration> types = new HashMap<String, TypeDeclaration>();
    private final Map<String, Set<ImportDeclaration>> injectedImportsMap = new HashMap<String, Set<ImportDeclaration>>();
    private final Map<String, Set<Annotation>> injectedAnnotationsMap = new HashMap<String, Set<Annotation>>();
    private final Map<String, List<ObjectType>> extendsLists = new HashMap<String, List<ObjectType>>();
    private final Map<String, List<ObjectType>> implementsLists = new HashMap<String, List<ObjectType>>();
    private final Map<String, TypeParameters> typeParameterLists = new HashMap<String, TypeParameters>();
    private final Map<String, List<ClassOrInterfaceBodyDeclaration>> bodyDeclarations = new HashMap<String, List<ClassOrInterfaceBodyDeclaration>>();
    private final Set<String> overriddenMethods = new HashSet<String>();
    private final Set<String> typeNames = new HashSet<String>();
    private final Set<String> interfaces = new HashSet<String>();
    private final Grammar grammar;
    private AppSettings appSettings;

    public CodeInjector(Grammar grammar, List<Node> codeInjections) {
        this.grammar = grammar;
        this.appSettings = grammar.getAppSettings();
        for (Node n : codeInjections) {
            if (n instanceof CompilationUnit) {
                this.add((CompilationUnit)n);
                continue;
            }
            if (!(n instanceof CodeInjection)) continue;
            CodeInjection ci = (CodeInjection)n;
            String name = ci.name;
            this.add(name, ci.importDeclarations, ci.annotations, ci.extendsList, ci.implementsList, ci.body, ci.isInterface);
        }
    }

    private boolean isInNodePackage(String classname) {
        return !classname.equals(this.appSettings.getParserClassName()) && !classname.equals(this.appSettings.getLexerClassName()) && !classname.equals("ParseException") && !classname.equals(this.appSettings.getBaseTokenClassName()) && !classname.equals("InvalidToken") && !classname.equals("Node");
    }

    private void add(CompilationUnit jcu) {
        ArrayList<ImportDeclaration> importDecls = new ArrayList<ImportDeclaration>(jcu.getImportDeclarations());
        for (TypeDeclaration dec : jcu.getTypeDeclarations()) {
            String packageName;
            String name = dec.getName();
            this.typeNames.add(name);
            String string = packageName = this.isInNodePackage(name) ? this.appSettings.getNodePackage() : this.appSettings.getParserPackage();
            if (packageName.length() > 0) {
                name = packageName + "." + name;
            }
            this.types.put(name, dec);
            if (dec instanceof InterfaceDeclaration) {
                this.interfaces.add(name);
            }
            if (!importDecls.isEmpty()) {
                Set injectedImports = this.injectedImportsMap.computeIfAbsent(name, k -> new LinkedHashSet());
                injectedImports.addAll(importDecls);
            }
            List<Object> extendsList = dec.getExtendsList() == null ? new ArrayList() : dec.getExtendsList().getTypes();
            List<ObjectType> existingOne = this.extendsLists.get(name);
            if (existingOne == null) {
                this.extendsLists.put(name, extendsList);
            } else {
                existingOne.addAll(extendsList);
            }
            List<Object> implementsList = dec.getImplementsList() == null ? new ArrayList() : dec.getImplementsList().getTypes();
            List<ObjectType> existing = this.implementsLists.get(name);
            if (existing == null) {
                this.implementsLists.put(name, implementsList);
            } else {
                existing.addAll(implementsList);
            }
            TypeParameters typeParameters = dec.getTypeParameters();
            if (typeParameters != null) {
                TypeParameters injectedList = this.typeParameterLists.get(name);
                if (injectedList == null) {
                    this.typeParameterLists.put(name, typeParameters);
                } else {
                    injectedList.add(typeParameters);
                }
            }
            ArrayList<ClassOrInterfaceBodyDeclaration> injectedCode = new ArrayList<ClassOrInterfaceBodyDeclaration>();
            ListIterator<Node> it = dec.getBody().iterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (!(n instanceof ClassOrInterfaceBodyDeclaration)) continue;
                injectedCode.add((ClassOrInterfaceBodyDeclaration)n);
            }
            List<ClassOrInterfaceBodyDeclaration> existingCode = this.bodyDeclarations.get(name);
            if (existingCode == null) {
                this.bodyDeclarations.put(name, injectedCode);
            } else {
                existingCode.addAll(injectedCode);
            }
            for (ClassOrInterfaceBodyDeclaration decl : injectedCode) {
                String key = null;
                if (decl instanceof MethodDeclaration) {
                    key = ((MethodDeclaration)decl).getFullSignature();
                }
                if (key == null) continue;
                this.overriddenMethods.add(key);
            }
        }
    }

    private void addToDependencies(String name, List<ObjectType> listToAdd, Map<String, List<ObjectType>> mapOfExistingLists) {
        List<ObjectType> existingList = mapOfExistingLists.get(name);
        if (existingList == null) {
            mapOfExistingLists.put(name, listToAdd);
        } else {
            for (ObjectType ot : listToAdd) {
                if (existingList.contains(ot)) continue;
                existingList.add(ot);
            }
        }
    }

    private void add(String name, List<ImportDeclaration> importDeclarations, List<Annotation> annotations, List<ObjectType> extendsList, List<ObjectType> implementsList, ClassOrInterfaceBody body, boolean isInterface) {
        String packageName;
        this.typeNames.add(name);
        if (isInterface) {
            this.interfaces.add(name);
        }
        String string = packageName = this.isInNodePackage(name) ? this.appSettings.getNodePackage() : this.appSettings.getParserPackage();
        if (packageName.length() > 0) {
            name = packageName + "." + name;
        }
        if (importDeclarations != null && !importDeclarations.isEmpty()) {
            Set existingImports = this.injectedImportsMap.computeIfAbsent(name, k -> new LinkedHashSet());
            existingImports.addAll(importDeclarations);
        }
        if (annotations != null && !annotations.isEmpty()) {
            Set existingAnnotations = this.injectedAnnotationsMap.computeIfAbsent(name, k -> new LinkedHashSet());
            existingAnnotations.addAll(annotations);
        }
        if (extendsList != null) {
            this.addToDependencies(name, extendsList, this.extendsLists);
        }
        if (implementsList != null) {
            this.addToDependencies(name, implementsList, this.implementsLists);
        }
        List existingDecls = this.bodyDeclarations.computeIfAbsent(name, k -> new ArrayList());
        if (body != null) {
            existingDecls.addAll(body.childrenOfType(ClassOrInterfaceBodyDeclaration.class));
        }
    }

    public void injectCode(CompilationUnit jcu) {
        String packageName = jcu.getPackageName();
        HashSet<ImportDeclaration> allInjectedImports = new HashSet<ImportDeclaration>();
        for (TypeDeclaration typeDecl : jcu.getTypeDeclarations()) {
            List<ClassOrInterfaceBodyDeclaration> injectedCode;
            Set<Annotation> annotations;
            TypeParameters typeParameters;
            List<ObjectType> injectedImplements;
            List<ObjectType> injectedExtends;
            Set<ImportDeclaration> injectedImports;
            String fullName = typeDecl.getName();
            if (packageName != null) {
                fullName = packageName + "." + fullName;
            }
            if ((injectedImports = this.injectedImportsMap.get(fullName)) != null) {
                allInjectedImports.addAll(injectedImports);
            }
            if ((injectedExtends = this.extendsLists.get(fullName)) != null) {
                for (ObjectType objectType : injectedExtends) {
                    typeDecl.addExtends(objectType);
                }
            }
            if ((injectedImplements = this.implementsLists.get(fullName)) != null) {
                for (ObjectType type2 : injectedImplements) {
                    typeDecl.addImplements(type2);
                }
            }
            if ((typeParameters = this.typeParameterLists.get(fullName)) != null) {
                TypeParameters typeParameters2 = typeDecl.getTypeParameters();
                typeParameters2.add(typeParameters);
            }
            if ((annotations = this.injectedAnnotationsMap.get(fullName)) != null) {
                typeDecl.addAnnotations(annotations);
            }
            if ((injectedCode = this.bodyDeclarations.get(fullName)) == null) continue;
            typeDecl.addElements(injectedCode);
        }
        this.injectImportDeclarations(jcu, allInjectedImports);
    }

    private void injectImportDeclarations(CompilationUnit jcu, Collection<ImportDeclaration> importDecls) {
        List<ImportDeclaration> importDeclarations = jcu.getImportDeclarations();
        for (ImportDeclaration importDecl : importDecls) {
            if (importDeclarations.contains(importDecl)) continue;
            jcu.addImportDeclaration(importDecl);
        }
    }

    public boolean hasInjectedCode(String typename) {
        return this.typeNames.contains(typename);
    }

    public List<ObjectType> getExtendsList(String qualifiedName) {
        return this.extendsLists.get(qualifiedName);
    }

    public List<ObjectType> getImplementsList(String qualifiedName) {
        return this.implementsLists.get(qualifiedName);
    }

    public Set<ImportDeclaration> getImportDeclarations(String qualifiedName) {
        return this.injectedImportsMap.get(qualifiedName);
    }

    public Map<String, List<ClassOrInterfaceBodyDeclaration>> getBodyDeclarations() {
        return this.bodyDeclarations;
    }

    public List<ClassOrInterfaceBodyDeclaration> getBodyDeclarations(String qualifiedName) {
        return this.bodyDeclarations.get(qualifiedName);
    }

    public List<String> getParentClasses(String qualifiedName) {
        ArrayList<String> result = new ArrayList<String>();
        List<ObjectType> extendsList = this.getExtendsList(qualifiedName);
        List<ObjectType> implementsList = this.getImplementsList(qualifiedName);
        String name = qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
        if (extendsList.isEmpty() && implementsList.isEmpty()) {
            if (this.grammar.nodeIsInterface(name)) {
                result.add("Node");
            } else {
                result.add(this.appSettings.getBaseNodeClassName());
                result.add("Node");
            }
        } else {
            if (extendsList.isEmpty()) {
                result.add(this.appSettings.getBaseNodeClassName());
            } else {
                for (ObjectType ot : extendsList) {
                    result.add(ot.toString());
                }
            }
            for (ObjectType ot : implementsList) {
                result.add(ot.toString());
            }
        }
        return result;
    }

    public Map<String, TypeParameters> getTypeParameterLists() {
        return this.typeParameterLists;
    }
}

