/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.core.Environment;
import freemarker.ext.dom.NodeModel;
import freemarker.template.Parameters;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.xml.sax.InputSource;

@Parameters(value="var")
public class XMLParser
implements TemplateTransformModel,
TemplateMethodModel {
    private String varname;

    public Writer getWriter(Writer out, Map args) throws TemplateModelException {
        final StringBuilder buf = new StringBuilder();
        final Environment env = Environment.getCurrentEnvironment();
        TemplateModel name = (TemplateModel)args.get("var");
        if (name == null) {
            throw new TemplateModelException("You must specify a var= parameter to say the name of the variable to assign the XML node to.");
        }
        if (!(name instanceof TemplateScalarModel)) {
            throw new TemplateModelException("The var parameter must be a string.");
        }
        this.varname = ((TemplateScalarModel)name).getAsString();
        return new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
                buf.append(cbuf, off, len);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                TemplateNodeModel root = null;
                try {
                    root = XMLParser.xmlNodeFromString(buf.toString());
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new IOException(e.getMessage());
                }
                env.setVariable(XMLParser.this.varname, root);
            }
        };
    }

    @Override
    public Object exec(List args) {
        if (args.size() != 1) {
            throw new TemplateModelException("Expecting one argument (a string containing an XML document)");
        }
        try {
            return XMLParser.xmlNodeFromString((String)args.get(0));
        }
        catch (Exception e) {
            throw new TemplateModelException(e.getMessage());
        }
    }

    public static TemplateNodeModel xmlNodeFromString(String s) throws Exception {
        InputSource is = new InputSource(new StringReader(s));
        return NodeModel.parse(is);
    }
}

