/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.core.Environment;
import freemarker.core.ast.Include;
import freemarker.core.ast.UnifiedCall;
import freemarker.core.parser.TemplateLocation;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TemplateException
extends RuntimeException {
    private static final long serialVersionUID = -5875559384037048115L;
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Environment env;
    private List<TemplateLocation> ftlStack;

    public TemplateException(Environment env) {
        this(null, null, env);
    }

    public TemplateException(String description, Environment env) {
        this(description, null, env);
    }

    public TemplateException(Exception cause, Environment env) {
        this(null, cause, env);
    }

    public TemplateException(String description, Exception cause, Environment env) {
        super(TemplateException.getDescription(description, cause), cause);
        this.env = env;
        if (env != null) {
            this.ftlStack = new ArrayList<TemplateLocation>();
            for (TemplateLocation templateLocation : env.getElementStack()) {
                this.ftlStack.add(templateLocation);
            }
            Collections.reverse(this.ftlStack);
        }
    }

    private static String getDescription(String description, Exception cause) {
        if (description != null) {
            return description;
        }
        if (cause != null) {
            return cause.getClass().getName() + ": " + cause.getMessage();
        }
        return "No error message";
    }

    public Exception getCauseException() {
        return (Exception)this.getCause();
    }

    public String getFTLInstructionStack() {
        StringBuilder buf = new StringBuilder("----------\n");
        if (this.ftlStack != null) {
            boolean atFirstElement = true;
            for (TemplateLocation location : this.ftlStack) {
                String line;
                if (atFirstElement) {
                    atFirstElement = false;
                    buf.append("==> ");
                    buf.append(location.getDescription());
                    buf.append(" [");
                    buf.append(location.getStartLocation());
                    buf.append("]\n");
                    continue;
                }
                if (!(location instanceof UnifiedCall) && !(location instanceof Include) || (line = location.getDescription() + " [" + location.getStartLocation() + "]") == null || line.length() <= 0) continue;
                buf.append(" in ");
                buf.append(line);
                buf.append("\n");
            }
            buf.append("----------\n");
        }
        return buf.toString();
    }

    public List<TemplateLocation> getFTLStack() {
        if (this.ftlStack == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.ftlStack);
    }

    public Environment getEnvironment() {
        return this.env;
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(ps), true);
        this.printStackTrace(pw);
        pw.flush();
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        pw.println();
        pw.println(this.getMessage());
        pw.println(this.getFTLInstructionStack());
        pw.println("Java backtrace for programmers:");
        pw.println("----------");
        super.printStackTrace(pw);
        try {
            Throwable causeException = this.getCause();
            Method m = causeException.getClass().getMethod("getRootCause", EMPTY_CLASS_ARRAY);
            Throwable rootCause = (Throwable)m.invoke((Object)causeException, EMPTY_OBJECT_ARRAY);
            if (rootCause != null) {
                Throwable j14Cause = null;
                if (causeException != null) {
                    m = causeException.getClass().getMethod("getCause", EMPTY_CLASS_ARRAY);
                    j14Cause = (Throwable)m.invoke((Object)causeException, EMPTY_OBJECT_ARRAY);
                }
                if (j14Cause == null) {
                    pw.println("ServletException root cause: ");
                    rootCause.printStackTrace(pw);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

