/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.core.Configurable;
import freemarker.core.Environment;
import freemarker.core.TemplateCore;
import freemarker.core.ast.ASTVisitor;
import freemarker.core.ast.LibraryLoad;
import freemarker.core.ast.TemplateElement;
import freemarker.core.ast.TemplateHeaderElement;
import freemarker.core.parser.FMParser;
import freemarker.core.parser.ParseException;
import freemarker.core.parser.ParsingProblem;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.PostParseVisitor;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateNodeModel;
import freemarker.template.WhitespaceAdjuster;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Template
extends TemplateCore {
    public static final String DEFAULT_NAMESPACE_PREFIX = "D";
    public static final String NO_NS_PREFIX = "N";
    protected char[] templateText;
    private List<LibraryLoad> imports = new Vector<LibraryLoad>();
    private String encoding;
    private String defaultNS;
    private final String name;
    private int[] lineStartOffsets;
    private byte[] lineInfoTable;
    private Map<String, String> prefixToNamespaceURILookup = new HashMap<String, String>();
    private Map<String, String> namespaceURIToPrefixLookup = new HashMap<String, String>();
    private Set<String> declaredVariables = new HashSet<String>();
    private Set<String> implicitlyDeclaredVariables = new HashSet<String>();
    boolean stripWhitespace;
    private boolean strictVariableDeclaration;
    private List<ParsingProblem> parsingProblems = new ArrayList<ParsingProblem>();
    private TemplateHeaderElement headerElement;

    public int getAbsoluteOffset(int line, int column) {
        return this.lineStartOffsets[line - 1] + column - 1;
    }

    protected Template(String name, Configuration cfg) {
        super(cfg != null ? cfg : Configuration.getDefaultConfiguration());
        this.name = name;
    }

    public Template(String name, Reader reader, Configuration cfg, String encoding) throws IOException {
        this(name, cfg);
        this.encoding = encoding;
        this.readInTemplateText(reader);
        try {
            int syntaxSetting = this.getConfiguration().getTagSyntax();
            this.stripWhitespace = this.getConfiguration().getWhitespaceStripping();
            this.strictVariableDeclaration = this.getConfiguration().getStrictVariableDefinition();
            FMParser parser = new FMParser(this, new String(this.templateText), syntaxSetting);
            parser.setInputSource(this.getName());
            this.setRootElement(parser.Root());
            PostParseVisitor ppv = new PostParseVisitor(this);
            ppv.visit(this);
            WhitespaceAdjuster wadj = new WhitespaceAdjuster(this);
            wadj.visit(this);
            for (ASTVisitor visitor : cfg.getAutoVisitors()) {
                if (visitor instanceof Cloneable) {
                    visitor = visitor.clone();
                }
                visitor.visit(this);
            }
        }
        catch (ParseException e) {
            e.setTemplateName(name);
            throw e;
        }
        this.namespaceURIToPrefixLookup = Collections.unmodifiableMap(this.namespaceURIToPrefixLookup);
        this.prefixToNamespaceURILookup = Collections.unmodifiableMap(this.prefixToNamespaceURILookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readInTemplateText(Reader reader) throws IOException {
        int charsRead = 0;
        StringBuilder buf = new StringBuilder();
        char[] chars = new char[65536];
        try {
            do {
                if ((charsRead = reader.read(chars)) <= 0) continue;
                buf.append(chars, 0, charsRead);
            } while (charsRead >= 0);
        }
        finally {
            reader.close();
        }
        this.templateText = new char[buf.length()];
        buf.getChars(0, buf.length(), this.templateText, 0);
        this.lineStartOffsets = Template.createLineTable(this.templateText);
        this.lineInfoTable = new byte[this.lineStartOffsets.length];
    }

    public Template(String name, Reader reader, Configuration cfg) throws IOException {
        this(name, reader, cfg, null);
    }

    public Template(String name, Reader reader) throws IOException {
        this(name, reader, null);
    }

    public static Template getPlainTextTemplate(String name, String content, Configuration config) {
        Template template = new Template(name, config);
        final char[] text = content.toCharArray();
        template.templateText = text;
        template.setRootElement(new TemplateElement(){

            @Override
            public void execute(Environment env) throws IOException {
                env.getOut().write(text);
            }
        });
        return template;
    }

    public void setStripWhitespace(boolean stripWhitespace) {
        this.stripWhitespace = stripWhitespace;
    }

    public void process(Object rootMap, Writer out) throws TemplateException, IOException {
        this.createProcessingEnvironment(rootMap, out, null).process();
    }

    public void process(Object rootMap, Writer out, ObjectWrapper wrapper, TemplateNodeModel rootNode) throws TemplateException, IOException {
        Environment env = this.createProcessingEnvironment(rootMap, out, wrapper);
        if (rootNode != null) {
            env.setCurrentVisitorNode(rootNode);
        }
        env.process();
    }

    public void process(Object rootMap, Writer out, ObjectWrapper wrapper) throws TemplateException, IOException {
        this.process(rootMap, out, wrapper, null);
    }

    public Environment createProcessingEnvironment(Object rootMap, Writer out, ObjectWrapper wrapper) throws TemplateException {
        TemplateHashModel root = null;
        if (rootMap instanceof TemplateHashModel) {
            root = (TemplateHashModel)rootMap;
        } else {
            if (wrapper == null) {
                wrapper = this.getObjectWrapper();
            }
            try {
                TemplateHashModel templateHashModel = root = rootMap != null ? (TemplateHashModel)wrapper.wrap(rootMap) : new SimpleHash(wrapper);
                if (root == null) {
                    throw new IllegalArgumentException(wrapper.getClass().getName() + " converted " + (rootMap == null ? "null" : rootMap.getClass().getName()) + " to null.");
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(wrapper.getClass().getName() + " could not convert " + (rootMap == null ? "null" : rootMap.getClass().getName()) + " to a TemplateHashModel.");
            }
        }
        return new Environment(this, root, out);
    }

    public Environment createProcessingEnvironment(Object rootMap, Writer out) throws TemplateException, IOException {
        return this.createProcessingEnvironment(rootMap, out, null);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.dump(sw);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
        return sw.toString();
    }

    public String getName() {
        return this.name;
    }

    public Configuration getConfiguration() {
        return (Configuration)this.getParent();
    }

    public List<ParsingProblem> getParsingProblems() {
        return this.parsingProblems;
    }

    public boolean hasParsingProblems() {
        return !this.parsingProblems.isEmpty();
    }

    public void addParsingProblem(ParsingProblem problem) {
        this.parsingProblems.add(problem);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void addImport(LibraryLoad ll) {
        this.imports.add(ll);
    }

    public void setHeaderElement(TemplateHeaderElement headerElement) {
        this.headerElement = headerElement;
    }

    public TemplateHeaderElement getHeaderElement() {
        return this.headerElement;
    }

    public boolean declaresVariable(String name) {
        return this.declaredVariables.contains(name);
    }

    public Set<String> getDeclaredVariables() {
        return Collections.unmodifiableSet(this.declaredVariables);
    }

    public void declareVariable(String name) {
        if (this.declaredVariables == null) {
            this.declaredVariables = new HashSet<String>();
        }
        this.declaredVariables.add(name);
    }

    public void setImplicitlyDeclaredVariables(Set<String> names) {
        this.implicitlyDeclaredVariables = names;
    }

    public boolean isImplicitlyDeclared(String varname) {
        return this.implicitlyDeclaredVariables.contains(varname);
    }

    public boolean strictVariableDeclaration() {
        return this.strictVariableDeclaration;
    }

    public void setStrictVariableDeclaration(boolean strictVariableDeclaration) {
        this.strictVariableDeclaration = strictVariableDeclaration;
    }

    public String getSource(int beginColumn, int beginLine, int endColumn, int endLine) {
        int startOffset = this.lineStartOffsets[--beginLine] + --beginColumn;
        int endOffset = this.lineStartOffsets[--endLine] + --endColumn;
        int numChars = 1 + endOffset - startOffset;
        return new String(this.templateText, startOffset, numChars);
    }

    public String getLine(int lineNumber) {
        int lineStartOffset = this.lineStartOffsets[--lineNumber];
        int numChars = lineNumber == this.lineStartOffsets.length - 1 ? this.templateText.length - lineStartOffset : this.lineStartOffsets[lineNumber + 1] - lineStartOffset;
        return new String(this.templateText, lineStartOffset, numChars);
    }

    public int getTabAdjustedColumn(int lineNumber, int column, int tabSize) {
        if (tabSize == 1 || column == 1) {
            return column;
        }
        int lineStartOffset = this.lineStartOffsets[lineNumber - 1];
        int result = 1;
        char c = '\u0000';
        for (int i = 0; i < column - 1; ++i) {
            c = this.templateText[lineStartOffset + i];
            if (c == '\t') {
                result += tabSize - i % tabSize;
                continue;
            }
            ++result;
        }
        return result;
    }

    public void writeTextAt(Writer out, int beginColumn, int beginLine, int endColumn, int endLine) throws IOException {
        int startOffset = this.lineStartOffsets[--beginLine] + --beginColumn;
        int endOffset = this.lineStartOffsets[--endLine] + --endColumn;
        out.write(this.templateText, startOffset, 1 + endOffset - startOffset);
    }

    public void writeTemplateText(Writer out) throws IOException {
        out.write(this.templateText);
    }

    private static int countLines(char[] chars) {
        if (chars == null || chars.length == 0) {
            return 0;
        }
        int numLines = 1;
        for (int i = 0; i < chars.length; ++i) {
            boolean isLastChar;
            boolean bl = isLastChar = i == chars.length - 1;
            if (chars[i] == '\r') {
                if (isLastChar || chars[i + 1] == '\n') continue;
                ++numLines;
                continue;
            }
            if (chars[i] != '\n' || isLastChar) continue;
            ++numLines;
        }
        return numLines;
    }

    private static int[] createLineTable(char[] text) {
        int numLines = Template.countLines(text);
        int[] table = new int[numLines];
        int lineNumber = 0;
        boolean newLine = true;
        for (int i = 0; i < text.length; ++i) {
            if (newLine) {
                table[lineNumber++] = i;
            }
            newLine = false;
            if (text[i] == '\r') {
                newLine = i != text.length - 1 && text[i + 1] != '\n';
                continue;
            }
            if (text[i] != '\n') continue;
            newLine = true;
        }
        return table;
    }

    public void setLineSaysLeftTrim(int i) {
        this.lineInfoTable[--i] = (byte)(this.lineInfoTable[i] | 1);
    }

    public void setLineSaysRightTrim(int i) {
        this.lineInfoTable[--i] = (byte)(this.lineInfoTable[i] | 2);
    }

    public void setLineSaysTrim(int i) {
        this.lineInfoTable[--i] = (byte)(this.lineInfoTable[i] | 3);
    }

    public void setLineSaysNoTrim(int i) {
        this.lineInfoTable[--i] = (byte)(this.lineInfoTable[i] | 4);
    }

    public boolean lineSaysLeftTrim(int i) {
        return (this.lineInfoTable[--i] & 1) != 0;
    }

    public boolean lineSaysRightTrim(int i) {
        return (this.lineInfoTable[--i] & 2) != 0;
    }

    public boolean lineSaysNoTrim(int i) {
        return (this.lineInfoTable[--i] & 4) != 0;
    }

    public void markAsOutputtingLine(int lineNumber, boolean inMacro) {
        int bitMask = inMacro ? 16 : 8;
        this.lineInfoTable[--lineNumber] = inMacro ? (byte)(this.lineInfoTable[lineNumber] | bitMask) : (byte)(this.lineInfoTable[lineNumber] | bitMask);
    }

    public boolean isOutputtingLine(int i, boolean inMacro) {
        int bitMask = inMacro ? 16 : 8;
        return (this.lineInfoTable[--i] & bitMask) != 0;
    }

    public TemplateElement getRootTreeNode() {
        return this.getRootElement();
    }

    @Override
    public void setParent(Configurable parent) {
        super.setParent(parent);
    }

    public List<LibraryLoad> getImports() {
        return this.imports;
    }

    public void addPrefixNSMapping(String prefix, String nsURI) {
        if (nsURI.length() == 0) {
            throw new IllegalArgumentException("Cannot map empty string URI");
        }
        if (prefix.length() == 0) {
            throw new IllegalArgumentException("Cannot map empty string prefix");
        }
        if (prefix.equals(NO_NS_PREFIX)) {
            throw new IllegalArgumentException("The prefix: " + prefix + " cannot be registered, it is reserved for special internal use.");
        }
        if (this.prefixToNamespaceURILookup.containsKey(prefix)) {
            throw new IllegalArgumentException("The prefix: '" + prefix + "' was repeated. This is illegal.");
        }
        if (this.namespaceURIToPrefixLookup.containsKey(nsURI)) {
            throw new IllegalArgumentException("The namespace URI: " + nsURI + " cannot be mapped to 2 different prefixes.");
        }
        if (prefix.equals(DEFAULT_NAMESPACE_PREFIX)) {
            this.defaultNS = nsURI;
        } else {
            this.prefixToNamespaceURILookup.put(prefix, nsURI);
            this.namespaceURIToPrefixLookup.put(nsURI, prefix);
        }
    }

    public String getDefaultNS() {
        return this.defaultNS;
    }

    public String getNamespaceForPrefix(String prefix) {
        if (prefix.equals("")) {
            return this.defaultNS == null ? "" : this.defaultNS;
        }
        return this.prefixToNamespaceURILookup.get(prefix);
    }

    public String getPrefixForNamespace(String nsURI) {
        if (nsURI == null) {
            return null;
        }
        if (nsURI.length() == 0) {
            return this.defaultNS == null ? "" : NO_NS_PREFIX;
        }
        if (nsURI.equals(this.defaultNS)) {
            return "";
        }
        return this.namespaceURIToPrefixLookup.get(nsURI);
    }

    public String getPrefixedName(String localName, String nsURI) {
        if (nsURI == null || nsURI.length() == 0) {
            if (this.defaultNS != null) {
                return "N:" + localName;
            }
            return localName;
        }
        if (nsURI.equals(this.defaultNS)) {
            return localName;
        }
        String prefix = this.getPrefixForNamespace(nsURI);
        if (prefix == null) {
            return null;
        }
        return prefix + ":" + localName;
    }

    public List<TemplateElement> containingElements(int column, int line) {
        ArrayList<TemplateElement> elements = new ArrayList<TemplateElement>();
        TemplateElement element = this.getRootElement();
        block0: while (element.contains(column, line)) {
            elements.add(element);
            Enumeration enumeration = element.children();
            while (enumeration.hasMoreElements()) {
                TemplateElement elem = (TemplateElement)enumeration.nextElement();
                if (!elem.contains(column, line)) continue;
                element = elem;
                continue block0;
            }
            break block0;
        }
        if (elements.isEmpty()) {
            return null;
        }
        return elements;
    }

    public static class WrongEncodingException
    extends RuntimeException {
        private static final long serialVersionUID = 3716984277969927605L;
        public String specifiedEncoding;

        public WrongEncodingException(String specifiedEncoding) {
            this.specifiedEncoding = specifiedEncoding;
        }
    }
}

