/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.core.ast.ASTVisitor;
import freemarker.core.ast.AndExpression;
import freemarker.core.ast.ArithmeticExpression;
import freemarker.core.ast.AssignmentInstruction;
import freemarker.core.ast.BlockAssignment;
import freemarker.core.ast.BodyInstruction;
import freemarker.core.ast.BreakInstruction;
import freemarker.core.ast.BuiltInExpression;
import freemarker.core.ast.Case;
import freemarker.core.ast.ComparisonExpression;
import freemarker.core.ast.ConditionalBlock;
import freemarker.core.ast.Dot;
import freemarker.core.ast.DynamicKeyName;
import freemarker.core.ast.EscapeBlock;
import freemarker.core.ast.Expression;
import freemarker.core.ast.FallbackInstruction;
import freemarker.core.ast.HashLiteral;
import freemarker.core.ast.IfBlock;
import freemarker.core.ast.Include;
import freemarker.core.ast.Interpolation;
import freemarker.core.ast.InvalidExpression;
import freemarker.core.ast.IteratorBlock;
import freemarker.core.ast.LibraryLoad;
import freemarker.core.ast.Macro;
import freemarker.core.ast.MixedContent;
import freemarker.core.ast.NoEscapeBlock;
import freemarker.core.ast.NumericalOutput;
import freemarker.core.ast.OOParamElement;
import freemarker.core.ast.OrExpression;
import freemarker.core.ast.PropertySetting;
import freemarker.core.ast.Range;
import freemarker.core.ast.ReturnInstruction;
import freemarker.core.ast.StringLiteral;
import freemarker.core.ast.SwitchBlock;
import freemarker.core.ast.TemplateElement;
import freemarker.core.ast.TemplateHeaderElement;
import freemarker.core.ast.TemplateNode;
import freemarker.core.ast.TextBlock;
import freemarker.core.ast.TrimBlock;
import freemarker.core.ast.TrimInstruction;
import freemarker.core.ast.UnaryPlusMinusExpression;
import freemarker.core.ast.UnifiedCall;
import freemarker.core.ast.VarDirective;
import freemarker.core.parser.ParseException;
import freemarker.core.parser.ParsingProblem;
import freemarker.core.parser.TemplateLocation;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.DeepUnwrap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PostParseVisitor
extends ASTVisitor {
    private Template template;
    private List<EscapeBlock> escapes = new ArrayList<EscapeBlock>();

    public PostParseVisitor(Template template) {
        this.template = template;
    }

    private Expression escapedExpression(Expression exp) {
        if (this.escapes.isEmpty()) {
            return exp;
        }
        EscapeBlock lastEscape = this.escapes.get(this.escapes.size() - 1);
        return lastEscape.doEscape(exp);
    }

    @Override
    public void visit(TemplateHeaderElement header) {
        if (header == null) {
            return;
        }
        for (Map.Entry<String, Expression> entry : header.getParams().entrySet()) {
            String key = entry.getKey();
            try {
                TemplateModelIterator it;
                TemplateCollectionModel keys;
                if (key.equals("strip_whitespace")) {
                    this.template.setStripWhitespace(header.getBooleanParameter("strip_whitespace"));
                    continue;
                }
                if (key.equals("ns_prefixes")) {
                    TemplateHashModelEx prefixMap = (TemplateHashModelEx)header.getParameter("ns_prefixes");
                    keys = prefixMap.keys();
                    it = keys.iterator();
                    while (it.hasNext()) {
                        String prefix = ((TemplateScalarModel)it.next()).getAsString();
                        TemplateModel valueModel = prefixMap.get(prefix);
                        String nsURI = ((TemplateScalarModel)valueModel).getAsString();
                        this.template.addPrefixNSMapping(prefix, nsURI);
                    }
                    continue;
                }
                if (key.equals("attributes")) {
                    TemplateHashModelEx attributeMap = (TemplateHashModelEx)header.getParameter("attributes");
                    keys = attributeMap.keys();
                    it = keys.iterator();
                    while (it.hasNext()) {
                        String attName = ((TemplateScalarModel)it.next()).getAsString();
                        Object attValue = DeepUnwrap.unwrap(attributeMap.get(attName));
                        this.template.setCustomAttribute(attName, attValue);
                    }
                    continue;
                }
                if (key.equals("strict_vars")) {
                    boolean strictVariableDeclaration = header.getBooleanParameter("strict_vars");
                    this.template.setStrictVariableDeclaration(strictVariableDeclaration);
                    continue;
                }
                if (key.equals("strip_text") || key.equals("encoding")) continue;
                ParsingProblem problem = new ParsingProblem("Unknown ftl header parameter: " + entry.getKey(), header);
                this.template.addParsingProblem(problem);
            }
            catch (Exception e) {
                ParsingProblem problem = new ParsingProblem(e.getMessage(), header);
                this.template.addParsingProblem(problem);
            }
        }
    }

    @Override
    public void visit(Include node) {
        if (this.template.strictVariableDeclaration() && !node.useFreshNamespace()) {
            ParsingProblem problem = new ParsingProblem("The legacy #include instruction is not permitted in strict_vars mode. Use #embed or possibly #import.", node);
            this.template.addParsingProblem(problem);
        }
        super.visit(node);
    }

    @Override
    public void visit(InvalidExpression node) {
        this.template.addParsingProblem(new ParsingProblem(node.getMessage() + " " + node.getSource(), node));
    }

    @Override
    public void visit(AndExpression node) {
        this.visit(node.getLeft());
        this.checkLiteralInBooleanContext(node.getLeft());
        this.visit(node.getRight());
        this.checkLiteralInBooleanContext(node.getRight());
    }

    @Override
    public void visit(AssignmentInstruction node) {
        super.visit(node);
        if (this.template.strictVariableDeclaration()) {
            ParsingProblem problem;
            if (node.getType() == 1) {
                problem = new ParsingProblem("The assign directive is deprecated and cannot be used in strict_vars mode. See the var and set directives.", node);
                this.template.addParsingProblem(problem);
            }
            if (node.getType() == 3) {
                problem = new ParsingProblem("The local directive is deprecated and cannot be used in strict_vars mode. See the var and set directives.", node);
                this.template.addParsingProblem(problem);
            }
        }
        if (node.getType() == 3) {
            Macro macro = PostParseVisitor.getContainingMacro(node);
            if (macro == null) {
                ParsingProblem problem = new ParsingProblem("The local directive can only be used inside a function or macro.", node);
                this.template.addParsingProblem(problem);
            } else {
                for (String varname : node.getVarNames()) {
                    if (macro.declaresVariable(varname)) continue;
                    macro.declareVariable(varname);
                }
            }
        }
    }

    @Override
    public void visit(BlockAssignment node) {
        super.visit(node);
        if (this.template.strictVariableDeclaration()) {
            ParsingProblem problem;
            if (node.getType() == 1) {
                problem = new ParsingProblem("The assign directive is deprecated and cannot be used in strict_vars mode. See the var and set directives.", node);
                this.template.addParsingProblem(problem);
            }
            if (node.getType() == 3) {
                problem = new ParsingProblem("The local directive is deprecated and cannot be used in strict_vars mode. See the var and set directives.", node);
                this.template.addParsingProblem(problem);
            }
        }
        if (node.getType() == 3) {
            Macro macro = PostParseVisitor.getContainingMacro(node);
            if (macro == null) {
                this.template.addParsingProblem(new ParsingProblem("The local directive can only be used inside a function or macro.", node));
            } else if (!macro.declaresVariable(node.getVarName())) {
                macro.declareVariable(node.getVarName());
            }
        }
    }

    @Override
    public void visit(BuiltInExpression node) {
        super.visit(node);
        if (node.getBuiltIn() == null) {
            ParsingProblem problem = new ParsingProblem("Unknown builtin: " + node.getName(), node);
            this.template.addParsingProblem(problem);
        }
    }

    @Override
    public void visit(Interpolation node) {
        super.visit(node);
        this.markAsProducingOutput(node);
        Expression escapedExpression = this.escapedExpression(node.getExpression());
        node.setEscapedExpression(escapedExpression);
        this.checkLiteralInScalarContext(escapedExpression);
    }

    @Override
    public void visit(IfBlock node) {
        if (node.getChildCount() == 1) {
            ConditionalBlock cblock = (ConditionalBlock)node.getChildAt(0);
            cblock.setIsSimple(true);
            cblock.setLocation(node.getTemplate(), (TemplateLocation)cblock, (TemplateLocation)node);
            node.getParent().replace(node, cblock);
            this.visit(cblock);
        } else {
            super.visit(node);
        }
    }

    @Override
    public void visit(EscapeBlock node) {
        Expression escapedExpression = this.escapedExpression(node.getExpression());
        node.setEscapedExpression(escapedExpression);
        this.escapes.add(node);
        super.visit(node);
        this.escapes.remove(this.escapes.size() - 1);
    }

    @Override
    public void visit(Macro node) {
        String macroName = node.getName();
        if (this.template.strictVariableDeclaration() && this.template.declaresVariable(macroName)) {
            ParsingProblem problem = new ParsingProblem("You already have declared a variable (or declared another macro) as " + macroName + ". You cannot reuse the variable name in the same template.", node);
            this.template.addParsingProblem(problem);
        }
        if (this.template.strictVariableDeclaration()) {
            this.template.declareVariable(macroName);
            TemplateElement parent = node.getParent();
            while (parent != null) {
                if ((parent = parent.getParent()) == null || parent instanceof EscapeBlock || parent instanceof NoEscapeBlock || parent instanceof MixedContent) continue;
                ParsingProblem problem = new ParsingProblem("Macro " + macroName + " is within a " + parent.getDescription() + ". It must be a top-level element.");
                this.template.addParsingProblem(problem);
            }
        }
        this.template.addMacro(node);
        super.visit(node);
    }

    @Override
    public void visit(NoEscapeBlock node) {
        TemplateElement parent;
        for (parent = node; parent != null && !(parent instanceof EscapeBlock); parent = parent.getParent()) {
        }
        if (parent == null) {
            this.template.addParsingProblem(new ParsingProblem("The noescape directive only makes sense inside an escape block.", node));
        }
        EscapeBlock last = this.escapes.remove(this.escapes.size() - 1);
        super.visit(node);
        this.escapes.add(last);
    }

    @Override
    public void visit(IteratorBlock node) {
        node.declareVariable(node.getIndexName());
        node.declareVariable(node.getIndexName() + "_has_next");
        node.declareVariable(node.getIndexName() + "_index");
        super.visit(node);
    }

    @Override
    public void visit(MixedContent node) {
        if (node.getChildCount() == 1 && node.getParent() != null) {
            node.getParent().replace(node, node.getChildAt(0));
        }
        super.visit(node);
    }

    @Override
    public void visit(FallbackInstruction node) {
        super.visit(node);
        if (PostParseVisitor.getContainingMacro(node) == null) {
            this.template.addParsingProblem(new ParsingProblem("The fallback directive can only be used inside a macro", node));
        }
    }

    @Override
    public void visit(BreakInstruction node) {
        TemplateElement parent;
        super.visit(node);
        for (parent = node; parent != null && !(parent instanceof SwitchBlock) && !(parent instanceof IteratorBlock); parent = parent.getParent()) {
        }
        if (parent == null) {
            this.template.addParsingProblem(new ParsingProblem("The break directive can only be used within a loop or a switch-case construct.", node));
        }
    }

    @Override
    public void visit(BodyInstruction node) {
        super.visit(node);
        Macro macro = PostParseVisitor.getContainingMacro(node);
        if (macro == null) {
            this.template.addParsingProblem(new ParsingProblem("The nested directive can only be used inside a function or macro.", node));
        }
    }

    @Override
    public void visit(ReturnInstruction node) {
        TemplateElement parent;
        super.visit(node);
        for (parent = node; parent != null && !(parent instanceof Macro); parent = parent.getParent()) {
        }
        if (parent == null) {
            this.template.addParsingProblem(new ParsingProblem("The return directive can only be used inside a function or macro.", node));
        } else {
            Macro macro = (Macro)parent;
            if (!macro.isFunction() && node.returnExp != null) {
                this.template.addParsingProblem(new ParsingProblem("Can only return a value from a function, not a macro", node));
            } else if (macro.isFunction() && node.returnExp == null) {
                this.template.addParsingProblem(new ParsingProblem("A function must return a value.", node));
            }
        }
    }

    @Override
    public void visit(VarDirective node) {
        TemplateElement parent = node.getParent();
        while (parent instanceof MixedContent || parent instanceof EscapeBlock || parent instanceof NoEscapeBlock || parent instanceof TrimBlock) {
            parent = parent.getParent();
        }
        for (String key : node.getVariables().keySet()) {
            if (parent == null) {
                this.template.declareVariable(key);
                continue;
            }
            if (parent.declaresVariable(key)) {
                String msg = "The variable " + key + " has already been declared in this block.";
                if (parent instanceof Macro) {
                    String macroName = ((Macro)parent).getName();
                    msg = "The variable " + key + " has already been declared in macro " + macroName + ".";
                }
                this.template.addParsingProblem(new ParsingProblem(msg, node));
            }
            parent.declareVariable(key);
        }
    }

    public void visit(OOParamElement node) {
        TemplateElement parent = node.getParent();
        while (parent instanceof MixedContent || parent instanceof EscapeBlock || parent instanceof NoEscapeBlock || parent instanceof TrimBlock) {
            parent = parent.getParent();
        }
        if (!(parent instanceof UnifiedCall) && !(parent instanceof OOParamElement)) {
            String msg = "A #param directive must be directly nested in a macro invocation or in another #param directive.";
            this.template.addParsingProblem(new ParsingProblem(msg, node));
        } else {
            parent.declareVariable(node.getName());
        }
    }

    @Override
    public void visit(SwitchBlock node) {
        super.visit(node);
        boolean foundDefaultCase = false;
        for (TemplateNode templateNode : node.getCases()) {
            if (!((Case)templateNode).isDefault()) continue;
            if (foundDefaultCase) {
                this.template.addParsingProblem(new ParsingProblem("You can only have one default case in a switch construct.", node));
            }
            foundDefaultCase = true;
        }
    }

    @Override
    public void visit(TextBlock node) {
        int type = node.getType();
        if (type == 0) {
            for (int i = node.getBeginLine(); i <= node.getEndLine(); ++i) {
                boolean inMacro;
                boolean bl = inMacro = PostParseVisitor.getContainingMacro(node) != null;
                if (i <= 0) continue;
                this.template.markAsOutputtingLine(i, inMacro);
            }
        } else if (type == 1) {
            // empty if block
        }
    }

    @Override
    public void visit(OrExpression node) {
        this.visit(node.getLeft());
        this.checkLiteralInBooleanContext(node.getLeft());
        this.visit(node.getRight());
        this.checkLiteralInBooleanContext(node.getRight());
    }

    @Override
    public void visit(ArithmeticExpression node) {
        this.visit(node.getLeft());
        this.checkLiteralInNumericalContext(node.getLeft());
        this.visit(node.getRight());
        this.checkLiteralInNumericalContext(node.getRight());
    }

    @Override
    public void visit(ComparisonExpression node) {
        this.visit(node.getLeft());
        this.checkLiteralInScalarContext(node.getLeft());
        this.visit(node.getRight());
        this.checkLiteralInScalarContext(node.getRight());
    }

    @Override
    public void visit(NumericalOutput node) {
        super.visit(node);
        try {
            node.parseFormat();
        }
        catch (Exception e) {
            String msg = e.getMessage();
            ParsingProblem problem = new ParsingProblem(msg, node);
            this.template.addParsingProblem(problem);
        }
        this.markAsProducingOutput(node);
        this.checkLiteralInNumericalContext(node.getExpression());
    }

    @Override
    public void visit(Dot node) {
        super.visit(node);
        TemplateModel target = node.getTarget().literalValue();
        if (target != null && !(target instanceof TemplateHashModel)) {
            this.template.addParsingProblem(new ParsingProblem("Expression " + node.getTarget().getSource() + " is not a hash type.", node.getTarget()));
        }
    }

    @Override
    public void visit(DynamicKeyName node) {
        super.visit(node);
        TemplateModel target = node.getTarget().literalValue();
        if (target != null && !(target instanceof TemplateHashModel) && !(target instanceof TemplateSequenceModel)) {
            String msg = "Expression: " + node.getTarget().getSource() + " is not a hash or sequence type.";
            this.template.addParsingProblem(new ParsingProblem(msg, node.getTarget()));
        }
        if (!(node.getNameExpression() instanceof Range)) {
            this.checkLiteralInScalarContext(node.getNameExpression());
        }
    }

    @Override
    public void visit(HashLiteral node) {
        for (Expression key : node.getKeys()) {
            this.checkLiteralInStringContext(key);
        }
        super.visit(node);
    }

    @Override
    public void visit(StringLiteral node) {
        if (!node.isRaw()) {
            try {
                node.checkInterpolation();
            }
            catch (ParseException pe) {
                String msg = "Error in string " + node.getStartLocation();
                msg = msg + "\n" + pe.getMessage();
                this.template.addParsingProblem(new ParsingProblem(msg, node));
            }
        }
    }

    @Override
    public void visit(LibraryLoad node) {
        String namespaceName = node.getNamespace();
        if (this.template.strictVariableDeclaration() && this.template.declaresVariable(namespaceName)) {
            String msg = "The variable " + namespaceName + " is already declared and should not be used as a namespace name to import.";
            this.template.addParsingProblem(new ParsingProblem(msg, node));
        }
        this.template.declareVariable(namespaceName);
        super.visit(node);
    }

    @Override
    public void visit(Range node) {
        super.visit(node);
        this.checkLiteralInNumericalContext(node.getLeft());
        if (node.getRight() != null) {
            this.checkLiteralInNumericalContext(node.getRight());
        }
    }

    @Override
    public void visit(UnaryPlusMinusExpression node) {
        this.checkLiteralInNumericalContext(node.getTarget());
        super.visit(node);
    }

    @Override
    public void visit(TrimInstruction node) {
        for (int i = node.getBeginLine(); i <= node.getEndLine(); ++i) {
            if (node.isLeft()) {
                this.template.setLineSaysLeftTrim(i);
            }
            if (node.isRight()) {
                this.template.setLineSaysRightTrim(i);
            }
            if (node.isLeft() || node.isRight()) continue;
            this.template.setLineSaysNoTrim(i);
        }
    }

    @Override
    public void visit(TrimBlock node) {
        int beginLine = node.getBeginLine();
        int endLine = node.getEndLine();
        if (node.isRight()) {
            this.template.setLineSaysRightTrim(beginLine++);
        }
        if (node.isLeft()) {
            this.template.setLineSaysLeftTrim(endLine--);
        }
        for (int i = beginLine; i <= endLine; ++i) {
            if (node.isLeft()) {
                this.template.setLineSaysLeftTrim(i);
            }
            if (node.isRight()) {
                this.template.setLineSaysRightTrim(i);
            }
            if (node.isLeft() || node.isRight()) continue;
            this.template.setLineSaysNoTrim(i);
        }
        super.visit(node);
    }

    @Override
    public void visit(PropertySetting node) {
        String key = node.getKey();
        if (!(key.equals("locale") || key.equals("number_format") || key.equals("time_format") || key.equals("date_format") || key.equals("datetime_format") || key.equals("time_zone") || key.equals("boolean_format") || key.equals("url_escaping_charset"))) {
            ParsingProblem problem = new ParsingProblem("Invalid setting name, or it is not allowed to change the value of the setting with FTL: " + key, node);
            this.template.addParsingProblem(problem);
        }
    }

    private void checkLiteralInBooleanContext(Expression exp) {
        TemplateModel value = exp.literalValue();
        if (value != null && !(value instanceof TemplateBooleanModel)) {
            String msg = value == TemplateModel.INVALID_EXPRESSION ? "Invalid expression: " + exp.getSource() : "Expression: " + exp.getSource() + " is not a boolean (true/false) value.";
            this.template.addParsingProblem(new ParsingProblem(msg, exp));
        }
    }

    private void checkLiteralInStringContext(Expression exp) {
        TemplateModel value = exp.literalValue();
        if (value != null && !(value instanceof TemplateScalarModel)) {
            String msg = value == TemplateModel.INVALID_EXPRESSION ? "Invalid expression: " + exp.getSource() : "Expression: " + exp.getSource() + " is not a string.";
            this.template.addParsingProblem(new ParsingProblem(msg, exp));
        }
    }

    private void checkLiteralInNumericalContext(Expression exp) {
        TemplateModel value = exp.literalValue();
        if (value != null && !(value instanceof TemplateNumberModel)) {
            String msg = value == TemplateModel.INVALID_EXPRESSION ? "Invalid expression: " + exp.getSource() : "Expression: " + exp.getSource() + " is not a numerical value.";
            this.template.addParsingProblem(new ParsingProblem(msg, exp));
        }
    }

    private void checkLiteralInScalarContext(Expression exp) {
        TemplateModel value = exp.literalValue();
        if (!(value == null || value instanceof TemplateScalarModel || value instanceof TemplateNumberModel || value instanceof TemplateDateModel)) {
            String msg = value == TemplateModel.INVALID_EXPRESSION ? "Invalid expression: " + exp.getSource() : "Expression: " + exp.getSource() + " is not a string, date, or number.";
            this.template.addParsingProblem(new ParsingProblem(msg, exp));
        }
    }

    static Macro getContainingMacro(TemplateNode node) {
        TemplateNode parent;
        for (parent = node; parent != null && !(parent instanceof Macro); parent = parent.getParentNode()) {
        }
        return (Macro)parent;
    }

    private void markAsProducingOutput(TemplateNode node) {
        for (int i = node.getBeginLine(); i <= node.getEndLine(); ++i) {
            boolean inMacro = PostParseVisitor.getContainingMacro(node) != null;
            this.template.markAsOutputtingLine(i, inMacro);
        }
    }

    public String firstLine(TemplateNode node) {
        String line = this.template.getLine(node.getBeginLine());
        if (node.getBeginLine() == node.getEndLine()) {
            line = line.substring(0, node.getEndColumn());
        }
        return line.substring(node.getBeginColumn() - 1);
    }

    public String lastLine(TemplateNode node) {
        String line = this.template.getLine(node.getEndLine());
        line = line.substring(0, node.getEndColumn());
        if (node.getBeginLine() == node.getEndLine()) {
            line = line.substring(node.getBeginColumn() - 1);
        }
        return line;
    }
}

