/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.TemplateCache;
import freemarker.cache.TemplateLoader;
import freemarker.core.Configurable;
import freemarker.core.Environment;
import freemarker.core.Scope;
import freemarker.core.ast.ASTVisitor;
import freemarker.core.parser.ParseException;
import freemarker.template.ObjectWrapper;
import freemarker.template.SettingStringParser;
import freemarker.template.SimpleCollection;
import freemarker.template.Template;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.HtmlEscape;
import freemarker.template.utility.NormalizeNewlines;
import freemarker.template.utility.StandardCompress;
import freemarker.template.utility.StringUtil;
import freemarker.template.utility.XmlEscape;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Configuration
extends Configurable
implements Cloneable,
Scope {
    public static final String DEFAULT_ENCODING_KEY = "default_encoding";
    public static final String LOCALIZED_LOOKUP_KEY = "localized_lookup";
    public static final String STRICT_SYNTAX_KEY = "strict_syntax";
    public static final String WHITESPACE_STRIPPING_KEY = "whitespace_stripping";
    public static final String CACHE_STORAGE_KEY = "cache_storage";
    public static final String TEMPLATE_UPDATE_DELAY_KEY = "template_update_delay";
    public static final String AUTO_IMPORT_KEY = "auto_import";
    public static final String AUTO_INCLUDE_KEY = "auto_include";
    public static final String STRICT_VARS_KEY = "strict_vars";
    public static final String SECURE = "secure";
    public static final int AUTO_DETECT_TAG_SYNTAX = 0;
    public static final int ANGLE_BRACKET_TAG_SYNTAX = 1;
    public static final int SQUARE_BRACKET_TAG_SYNTAX = 2;
    private static Configuration defaultConfig = new Configuration();
    private boolean localizedLookup = true;
    private boolean whitespaceStripping = true;
    private boolean strictVariableDefinition = false;
    private TemplateCache cache;
    private HashMap<String, TemplateModel> variables = new HashMap();
    private HashMap<String, String> encodingMap = new HashMap();
    private Map<String, String> autoImportMap = new HashMap<String, String>();
    private ArrayList<String> autoImports = new ArrayList();
    private ArrayList<String> autoIncludes = new ArrayList();
    private ArrayList<ASTVisitor> autoVisitors = new ArrayList();
    private String defaultEncoding = "UTF-8";
    private boolean tolerateParsingProblems = false;
    private int tagSyntax = 0;

    public Configuration() {
        this.cache = new TemplateCache();
        this.cache.setConfiguration(this);
        this.cache.setDelay(5000L);
        this.loadBuiltInSharedVariables();
    }

    public void setTemplateCache(TemplateCache cache) {
        this.cache = cache;
        cache.setConfiguration(this);
        cache.setDelay(5000L);
    }

    public TemplateCache getTemplateCache() {
        return this.cache;
    }

    @Override
    public Object clone() {
        try {
            Configuration copy = (Configuration)super.clone();
            copy.variables = new HashMap<String, TemplateModel>(this.variables);
            copy.encodingMap = new HashMap<String, String>(this.encodingMap);
            copy.createTemplateCache(this.cache.getTemplateLoader(), this.cache.getCacheStorage());
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone is not supported, but it should be: " + e.getMessage());
        }
    }

    private void loadBuiltInSharedVariables() {
        this.variables.put("compress", StandardCompress.INSTANCE);
        this.variables.put("html_escape", new HtmlEscape());
        this.variables.put("normalize_newlines", new NormalizeNewlines());
        this.variables.put("xml_escape", new XmlEscape());
    }

    public void loadBuiltInEncodingMap() {
        this.encodingMap.clear();
        this.encodingMap.put("ar", "ISO-8859-6");
        this.encodingMap.put("be", "ISO-8859-5");
        this.encodingMap.put("bg", "ISO-8859-5");
        this.encodingMap.put("ca", "ISO-8859-1");
        this.encodingMap.put("cs", "ISO-8859-2");
        this.encodingMap.put("da", "ISO-8859-1");
        this.encodingMap.put("de", "ISO-8859-1");
        this.encodingMap.put("el", "ISO-8859-7");
        this.encodingMap.put("en", "ISO-8859-1");
        this.encodingMap.put("es", "ISO-8859-1");
        this.encodingMap.put("et", "ISO-8859-1");
        this.encodingMap.put("fi", "ISO-8859-1");
        this.encodingMap.put("fr", "ISO-8859-1");
        this.encodingMap.put("hr", "ISO-8859-2");
        this.encodingMap.put("hu", "ISO-8859-2");
        this.encodingMap.put("is", "ISO-8859-1");
        this.encodingMap.put("it", "ISO-8859-1");
        this.encodingMap.put("iw", "ISO-8859-8");
        this.encodingMap.put("ja", "Shift_JIS");
        this.encodingMap.put("ko", "EUC-KR");
        this.encodingMap.put("lt", "ISO-8859-2");
        this.encodingMap.put("lv", "ISO-8859-2");
        this.encodingMap.put("mk", "ISO-8859-5");
        this.encodingMap.put("nl", "ISO-8859-1");
        this.encodingMap.put("no", "ISO-8859-1");
        this.encodingMap.put("pl", "ISO-8859-2");
        this.encodingMap.put("pt", "ISO-8859-1");
        this.encodingMap.put("ro", "ISO-8859-2");
        this.encodingMap.put("ru", "ISO-8859-5");
        this.encodingMap.put("sh", "ISO-8859-5");
        this.encodingMap.put("sk", "ISO-8859-2");
        this.encodingMap.put("sl", "ISO-8859-2");
        this.encodingMap.put("sq", "ISO-8859-2");
        this.encodingMap.put("sr", "ISO-8859-5");
        this.encodingMap.put("sv", "ISO-8859-1");
        this.encodingMap.put("tr", "ISO-8859-9");
        this.encodingMap.put("uk", "ISO-8859-5");
        this.encodingMap.put("zh", "GB2312");
        this.encodingMap.put("zh_TW", "Big5");
    }

    public void clearEncodingMap() {
        this.encodingMap.clear();
    }

    public static Configuration getDefaultConfiguration() {
        return defaultConfig;
    }

    public static Configuration getCurrentConfiguration() {
        Environment env = Environment.getCurrentEnvironment();
        return env != null ? env.getConfiguration() : defaultConfig;
    }

    public static ObjectWrapper getCurrentObjectWrapper() {
        return Configuration.getCurrentConfiguration().getObjectWrapper();
    }

    public static void setDefaultConfiguration(Configuration config) {
        defaultConfig = config;
    }

    public synchronized void setTemplateLoader(TemplateLoader loader) {
        this.createTemplateCache(loader, this.cache.getCacheStorage());
    }

    private void setTemplateLoaderNoCheck(TemplateLoader loader) {
        this.createTemplateCache(loader, this.cache.getCacheStorage());
    }

    private void createTemplateCache(TemplateLoader loader, CacheStorage storage) {
        TemplateCache oldCache = this.cache;
        this.cache = new TemplateCache(loader, storage);
        this.cache.setDelay(oldCache.getDelay());
        this.cache.setConfiguration(this);
        this.cache.setLocalizedLookup(this.localizedLookup);
    }

    public synchronized TemplateLoader getTemplateLoader() {
        return this.cache.getTemplateLoader();
    }

    public synchronized void setCacheStorage(CacheStorage storage) {
        this.createTemplateCache(this.cache.getTemplateLoader(), storage);
    }

    public void setDirectoryForTemplateLoading(File dir) throws IOException {
        String path;
        TemplateLoader tl = this.getTemplateLoader();
        if (tl instanceof FileTemplateLoader && (path = ((FileTemplateLoader)tl).baseDir.getCanonicalPath()).equals(dir.getCanonicalPath())) {
            return;
        }
        this.setTemplateLoaderNoCheck(new FileTemplateLoader(dir));
    }

    public void setServletContextForTemplateLoading(Object sctxt, String path) {
        try {
            if (path == null) {
                this.setTemplateLoaderNoCheck((TemplateLoader)Class.forName("freemarker.cache.WebappTemplateLoader").getConstructor(Class.forName("javax.servlet.ServletContext")).newInstance(sctxt));
            } else {
                this.setTemplateLoaderNoCheck((TemplateLoader)Class.forName("freemarker.cache.WebappTemplateLoader").getConstructor(Class.forName("javax.servlet.ServletContext"), String.class).newInstance(sctxt, path));
            }
        }
        catch (Exception exc) {
            throw new RuntimeException("Internal FreeMarker error: " + exc);
        }
    }

    public void setClassForTemplateLoading(Class clazz, String pathPrefix) {
        this.setTemplateLoaderNoCheck(new ClassTemplateLoader(clazz, pathPrefix));
    }

    public void setTemplateUpdateDelay(int delay) {
        this.cache.setDelay(1000L * (long)delay);
    }

    public void setTagSyntax(int tagSyntax) {
        if (tagSyntax != 0 && tagSyntax != 2 && tagSyntax != 1) {
            throw new IllegalArgumentException("This can only be set to one of three settings: Configuration.AUTO_DETECT_TAG_SYNTAX, Configuration.ANGLE_BRACKET_SYNTAX, or Configuration.SQAUARE_BRACKET_SYNTAX");
        }
        this.tagSyntax = tagSyntax;
    }

    public int getTagSyntax() {
        return this.tagSyntax;
    }

    public void setStrictVariableDefinition(boolean b) {
        this.strictVariableDefinition = b;
    }

    public boolean getStrictVariableDefinition() {
        return this.strictVariableDefinition;
    }

    public void setWhitespaceStripping(boolean b) {
        this.whitespaceStripping = b;
    }

    public boolean getWhitespaceStripping() {
        return this.whitespaceStripping;
    }

    public Template getTemplate(String name) throws IOException {
        Locale loc = this.getLocale();
        return this.getTemplate(name, loc, this.getEncoding(loc), true);
    }

    public Template getTemplate(String name, Locale locale) throws IOException {
        return this.getTemplate(name, locale, this.getEncoding(locale), true);
    }

    public Template getTemplate(String name, String encoding) throws IOException {
        return this.getTemplate(name, this.getLocale(), encoding, true);
    }

    public Template getTemplate(String name, Locale locale, String encoding) throws IOException {
        return this.getTemplate(name, locale, encoding, true);
    }

    public Template getTemplate(String name, Locale locale, String encoding, boolean parse) throws IOException {
        Template result = this.cache.getTemplate(name, locale, encoding, parse);
        if (result == null) {
            throw new FileNotFoundException("Template " + name + " not found.");
        }
        if (result.hasParsingProblems() && !this.tolerateParsingProblems) {
            throw new ParseException(result.getParsingProblems());
        }
        return result;
    }

    public void setDefaultEncoding(String encoding) {
        this.defaultEncoding = encoding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getEncoding(Locale loc) {
        String charset = this.encodingMap.get(loc.toString());
        if (charset == null) {
            Locale l;
            if (loc.getVariant().length() > 0 && (charset = this.encodingMap.get((l = new Locale(loc.getLanguage(), loc.getCountry())).toString())) != null) {
                this.encodingMap.put(loc.toString(), charset);
            }
            if ((charset = this.encodingMap.get(loc.getLanguage())) != null) {
                this.encodingMap.put(loc.toString(), charset);
            }
        }
        return charset != null ? charset : this.defaultEncoding;
    }

    public void setEncoding(Locale locale, String encoding) {
        this.encodingMap.put(locale.toString(), encoding);
    }

    public void setSharedVariable(String name, TemplateModel tm) {
        this.variables.put(name, tm);
    }

    public Set<String> getSharedVariableNames() {
        return new HashSet<String>(this.variables.keySet());
    }

    public void setSharedVariable(String name, Object obj) {
        this.setSharedVariable(name, this.getObjectWrapper().wrap(obj));
    }

    public void setAllSharedVariables(TemplateHashModelEx hash) {
        TemplateModelIterator keys = hash.keys().iterator();
        TemplateModelIterator values = hash.values().iterator();
        while (keys.hasNext()) {
            this.setSharedVariable(((TemplateScalarModel)keys.next()).getAsString(), values.next());
        }
    }

    public TemplateModel getSharedVariable(String name) {
        return this.variables.get(name);
    }

    public void clearSharedVariables() {
        this.variables.clear();
        this.loadBuiltInSharedVariables();
    }

    public void clearTemplateCache() {
        this.cache.clear();
    }

    public boolean getLocalizedLookup() {
        return this.cache.getLocalizedLookup();
    }

    public void setLocalizedLookup(boolean localizedLookup) {
        this.localizedLookup = localizedLookup;
        this.cache.setLocalizedLookup(localizedLookup);
    }

    @Override
    public void setSetting(String key, String value) {
        block24: {
            if ("TemplateUpdateInterval".equalsIgnoreCase(key)) {
                key = TEMPLATE_UPDATE_DELAY_KEY;
            } else if ("DefaultEncoding".equalsIgnoreCase(key)) {
                key = DEFAULT_ENCODING_KEY;
            }
            try {
                if (DEFAULT_ENCODING_KEY.equalsIgnoreCase(key)) {
                    this.setDefaultEncoding(value);
                    break block24;
                }
                if (LOCALIZED_LOOKUP_KEY.equalsIgnoreCase(key)) {
                    this.setLocalizedLookup(StringUtil.getYesNo(value));
                    break block24;
                }
                if (STRICT_SYNTAX_KEY.equalsIgnoreCase(key)) break block24;
                if (STRICT_VARS_KEY.equalsIgnoreCase(key)) {
                    this.setStrictVariableDefinition(StringUtil.getYesNo(value));
                    break block24;
                }
                if (WHITESPACE_STRIPPING_KEY.equalsIgnoreCase(key)) {
                    this.setWhitespaceStripping(StringUtil.getYesNo(value));
                    break block24;
                }
                if (CACHE_STORAGE_KEY.equalsIgnoreCase(key)) {
                    if (value.indexOf(46) == -1) {
                        int strongSize = 0;
                        int softSize = 0;
                        Map<String, String> map = StringUtil.parseNameValuePairList(value, String.valueOf(Integer.MAX_VALUE));
                        for (Map.Entry<String, String> ent : map.entrySet()) {
                            int pvalue;
                            String pname = ent.getKey();
                            try {
                                pvalue = Integer.parseInt(ent.getValue());
                            }
                            catch (NumberFormatException e) {
                                throw this.invalidSettingValueException(key, value);
                            }
                            if ("soft".equalsIgnoreCase(pname)) {
                                softSize = pvalue;
                                continue;
                            }
                            if ("strong".equalsIgnoreCase(pname)) {
                                strongSize = pvalue;
                                continue;
                            }
                            throw this.invalidSettingValueException(key, value);
                        }
                        if (softSize == 0 && strongSize == 0) {
                            throw this.invalidSettingValueException(key, value);
                        }
                        this.setCacheStorage(new MruCacheStorage(strongSize, softSize));
                        break block24;
                    }
                    this.setCacheStorage((CacheStorage)Class.forName(value).newInstance());
                    break block24;
                }
                if (TEMPLATE_UPDATE_DELAY_KEY.equalsIgnoreCase(key)) {
                    this.setTemplateUpdateDelay(Integer.parseInt(value));
                } else if (AUTO_INCLUDE_KEY.equalsIgnoreCase(key)) {
                    this.setAutoIncludes(new SettingStringParser(value).parseAsList());
                } else if (AUTO_IMPORT_KEY.equalsIgnoreCase(key)) {
                    this.setAutoImports(new SettingStringParser(value).parseAsImportList());
                } else {
                    super.setSetting(key, value);
                }
            }
            catch (TemplateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TemplateException("Failed to set setting " + key + " to value " + value, e, this.getEnvironment());
            }
        }
    }

    public synchronized void addAutoImport(String namespace, String template) {
        this.autoImports.remove(namespace);
        this.autoImports.add(namespace);
        this.autoImportMap.put(namespace, template);
    }

    public synchronized void removeAutoImport(String namespace) {
        this.autoImports.remove(namespace);
        this.autoImportMap.remove(namespace);
    }

    public synchronized void setAutoImports(Map<String, String> map) {
        this.autoImports = new ArrayList<String>(map.keySet());
        this.autoImportMap = new HashMap<String, String>(map);
    }

    @Override
    protected void doAutoImportsAndIncludes(Environment env) throws TemplateException, IOException {
        for (String namespace : this.autoImports) {
            String templateName = this.autoImportMap.get(namespace);
            env.importLib(templateName, namespace);
        }
        for (String templateName : this.autoIncludes) {
            env.include(this.getTemplate(templateName, env.getLocale()), false);
        }
    }

    public synchronized void addAutoInclude(String templateName) {
        this.autoIncludes.remove(templateName);
        this.autoIncludes.add(templateName);
    }

    public synchronized void setAutoIncludes(List<String> templateNames) {
        this.autoIncludes.clear();
        this.autoIncludes.addAll(templateNames);
    }

    public synchronized void removeAutoInclude(String templateName) {
        this.autoIncludes.remove(templateName);
    }

    public synchronized void addAutoTemplateVisitors(ASTVisitor ... visitors) {
        for (ASTVisitor visitor : visitors) {
            this.autoVisitors.remove(visitor);
            this.autoVisitors.add(visitor);
        }
    }

    public synchronized void removeAutoTemplateVisitors(ASTVisitor ... visitors) {
        for (ASTVisitor visitor : visitors) {
            this.autoVisitors.remove(visitor);
        }
    }

    public synchronized void setAutoTemplateVisitors(ASTVisitor ... visitors) {
        this.autoVisitors.clear();
        for (ASTVisitor visitor : visitors) {
            this.autoVisitors.add(visitor);
        }
    }

    synchronized List<ASTVisitor> getAutoVisitors() {
        return new ArrayList<ASTVisitor>(this.autoVisitors);
    }

    public static String getVersionNumber() {
        return "3.0 Preview";
    }

    public void setTolerateParsingProblems(boolean tolerateParsingProblems) {
        this.tolerateParsingProblems = tolerateParsingProblems;
    }

    @Override
    public Scope getEnclosingScope() {
        return null;
    }

    @Override
    public boolean definesVariable(String name) {
        return this.getSharedVariable(name) != null;
    }

    @Override
    public Template getTemplate() {
        return null;
    }

    @Override
    public void put(String varname, TemplateModel value) {
        this.setSharedVariable(varname, value);
    }

    @Override
    public TemplateModel get(String name) {
        return this.variables.get(name);
    }

    @Override
    public TemplateModel resolveVariable(String name) {
        return this.variables.get(name);
    }

    @Override
    public Collection<String> getDirectVariableNames() {
        return Collections.unmodifiableCollection(this.variables.keySet());
    }

    @Override
    public TemplateModel remove(String varname) {
        return this.variables.remove(varname);
    }

    @Override
    public boolean isEmpty() {
        return this.variables.isEmpty();
    }

    @Override
    public int size() {
        return this.variables.size();
    }

    @Override
    public TemplateCollectionModel keys() {
        return new SimpleCollection(this.variables.keySet(), this.getObjectWrapper());
    }

    @Override
    public TemplateCollectionModel values() {
        return new SimpleCollection(this.variables.values(), this.getObjectWrapper());
    }
}

