/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.MemberAndArguments;
import freemarker.ext.beans.MethodMap;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

class OverloadedMethodModel
implements TemplateMethodModelEx,
TemplateSequenceModel {
    private final Object object;
    private final MethodMap<Method> methodMap;

    public OverloadedMethodModel(Object object, MethodMap<Method> methodMap) {
        this.object = object;
        this.methodMap = methodMap;
    }

    @Override
    public Object exec(List arguments) throws TemplateModelException {
        MemberAndArguments<Method> maa = this.methodMap.getMemberAndArguments(arguments);
        Method method = maa.getMember();
        try {
            return this.methodMap.getWrapper().invokeMethod(this.object, method, maa.getArgs());
        }
        catch (Exception e) {
            Object[] args;
            Throwable t;
            while (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof Exception) {
                e = (Exception)t;
            }
            if ((method.getModifiers() & 8) != 0) {
                throw new TemplateModelException("Method " + method + " threw an exception", e);
            }
            StringBuilder buf = new StringBuilder();
            for (Object arg : args = maa.getArgs()) {
                buf.append(arg == null ? "null" : arg.getClass().getName()).append(',');
            }
            throw new TemplateModelException("Method " + method + " threw an exception when invoked on " + this.object + " with arguments of types [" + buf + "]", e);
        }
    }

    @Override
    public TemplateModel get(int index) throws TemplateModelException {
        return (TemplateModel)this.exec(Collections.singletonList(new SimpleNumber((Number)index)));
    }

    @Override
    public int size() throws TemplateModelException {
        throw new TemplateModelException("?size is unsupported for: " + this.getClass().getName());
    }
}

