/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.MemberAndArguments;
import freemarker.ext.beans.OverloadedMethod;
import freemarker.template.TemplateModel;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class OverloadedFixArgMethod<T extends Member>
extends OverloadedMethod<T> {
    OverloadedFixArgMethod() {
    }

    @Override
    void onAddSignature(T member, Class<?>[] argTypes) {
    }

    @Override
    void updateSignature(int l) {
    }

    @Override
    void afterSignatureAdded(int l) {
    }

    @Override
    Object getMemberAndArguments(List<TemplateModel> arguments, BeansWrapper w) {
        if (arguments == null) {
            arguments = Collections.emptyList();
        }
        int l = arguments.size();
        Class<?>[][] marshalTypes = this.getMarshalTypes();
        if (marshalTypes.length <= l) {
            return NO_SUCH_METHOD;
        }
        Class<?>[] types = marshalTypes[l];
        if (types == null) {
            return NO_SUCH_METHOD;
        }
        assert (types.length == l);
        Object[] args = new Object[l];
        Iterator<TemplateModel> it = arguments.iterator();
        for (int i = 0; i < l; ++i) {
            Object obj = w.unwrap(it.next(), types[i]);
            if (obj == BeansWrapper.CAN_NOT_UNWRAP) {
                return NO_SUCH_METHOD;
            }
            args[i] = obj;
        }
        Object objMember = this.getMemberForArgs(args, false);
        if (objMember instanceof Member) {
            Member member = (Member)objMember;
            BeansWrapper.coerceBigDecimals(this.getSignature(member), args);
            return new MemberAndArguments<Member>(member, args);
        }
        return objMember;
    }
}

