/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.parser;

import freemarker.core.ast.TemplateNode;
import freemarker.core.parser.FMParser;
import freemarker.core.parser.NonTerminalCall;
import freemarker.core.parser.ParsingProblem;
import freemarker.core.parser.Token;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ParseException
extends RuntimeException {
    int lineNumber;
    int columnNumber;
    String templateName;
    public List<ParsingProblem> problems;
    private Token token;
    private EnumSet<Token.TokenType> expectedTypes;
    private List<NonTerminalCall> callStack;
    private boolean alreadyAdjusted;

    public ParseException(String message, int lineNumber, int columnNumber) {
        super(message);
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public ParseException(String message, TemplateNode tobj) {
        super(message);
        this.lineNumber = tobj.getBeginLine();
        this.columnNumber = tobj.getBeginColumn();
        this.problems = new ArrayList<ParsingProblem>();
        this.problems.add(new ParsingProblem(message, tobj));
    }

    public ParseException(List<ParsingProblem> problems) {
        this.problems = problems;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    private void setInfo(Token token, EnumSet<Token.TokenType> expectedTypes, List<NonTerminalCall> callStack) {
        if (token != null && !token.getType().isEOF() && token.getNext() != null) {
            token = token.getNext();
        }
        this.token = token;
        this.expectedTypes = expectedTypes;
        this.callStack = new ArrayList<NonTerminalCall>(callStack);
    }

    public boolean hitEOF() {
        return this.token != null && this.token.getType().isEOF();
    }

    public ParseException(FMParser parser, Token token, EnumSet<Token.TokenType> expectedTypes, List<NonTerminalCall> callStack) {
        this.setInfo(token, expectedTypes, callStack);
    }

    public ParseException(FMParser parser, String message) {
        super(message);
    }

    public ParseException(FMParser parser, EnumSet<Token.TokenType> expectedTypes, List<NonTerminalCall> callStack) {
        this(parser, parser.lastConsumedToken, expectedTypes, callStack);
    }

    public ParseException(Token token) {
        this.token = token;
    }

    public ParseException() {
    }

    public ParseException(String message) {
        super(message);
    }

    @Override
    public String getMessage() {
        String content;
        String msg = super.getMessage();
        if (this.token == null && this.expectedTypes == null) {
            return msg;
        }
        StringBuilder buf = new StringBuilder();
        if (msg != null) {
            buf.append(msg);
        }
        buf.append("\nEncountered an error at (or somewhere around) " + this.token.getLocation());
        if (this.expectedTypes != null && this.token != null && this.expectedTypes.contains((Object)this.token.getType())) {
            return buf.toString();
        }
        if (this.expectedTypes != null) {
            buf.append("\nWas expecting one of the following:\n");
            boolean isFirst = true;
            for (Token.TokenType type : this.expectedTypes) {
                if (!isFirst) {
                    buf.append(", ");
                }
                isFirst = false;
                buf.append((Object)type);
            }
        }
        if ((content = this.token.getImage()) == null) {
            content = "";
        }
        if (content.length() > 32) {
            content = content.substring(0, 32) + "...";
        }
        buf.append("\nFound string \"" + ParseException.addEscapes(content) + "\" of type " + (Object)((Object)this.token.getType()));
        return buf.toString();
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        this.adjustStackTrace();
        return super.getStackTrace();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.adjustStackTrace();
        super.printStackTrace(s);
    }

    public Token getToken() {
        return this.token;
    }

    private void adjustStackTrace() {
        StackTraceElement[] jvmCallStack;
        if (this.alreadyAdjusted || this.callStack == null || this.callStack.isEmpty()) {
            return;
        }
        LinkedList<StackTraceElement> fullTrace = new LinkedList<StackTraceElement>();
        LinkedList<StackTraceElement> ourCallStack = new LinkedList<StackTraceElement>();
        for (NonTerminalCall nonTerminalCall : this.callStack) {
            ourCallStack.add(nonTerminalCall.createStackTraceElement());
        }
        for (StackTraceElement regularEntry : jvmCallStack = super.getStackTrace()) {
            if (ourCallStack.isEmpty()) break;
            String methodName = regularEntry.getMethodName();
            StackTraceElement ourEntry = this.lastElementWithName(ourCallStack, methodName);
            if (ourEntry != null) {
                fullTrace.add(ourEntry);
            }
            fullTrace.add(regularEntry);
        }
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[fullTrace.size()];
        this.setStackTrace(fullTrace.toArray(stackTraceElementArray));
        this.alreadyAdjusted = true;
    }

    private StackTraceElement lastElementWithName(List<StackTraceElement> elements, String methodName) {
        ListIterator<StackTraceElement> it = elements.listIterator(elements.size());
        while (it.hasPrevious()) {
            StackTraceElement elem = it.previous();
            if (!elem.getMethodName().equals(methodName)) continue;
            it.remove();
            return elem;
        }
        return null;
    }

    private static String addEscapes(String str) {
        StringBuilder retval = new StringBuilder();
        block10: for (int ch : str.codePoints().toArray()) {
            switch (ch) {
                case 8: {
                    retval.append("\\b");
                    continue block10;
                }
                case 9: {
                    retval.append("\\t");
                    continue block10;
                }
                case 10: {
                    retval.append("\\n");
                    continue block10;
                }
                case 12: {
                    retval.append("\\f");
                    continue block10;
                }
                case 13: {
                    retval.append("\\r");
                    continue block10;
                }
                case 34: {
                    retval.append("\\\"");
                    continue block10;
                }
                case 39: {
                    retval.append("\\'");
                    continue block10;
                }
                case 92: {
                    retval.append("\\\\");
                    continue block10;
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block10;
                    }
                    retval.appendCodePoint(ch);
                    continue block10;
                }
            }
        }
        return retval.toString();
    }
}

