/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.parser;

import freemarker.core.parser.InvalidToken;
import freemarker.core.parser.Token;
import freemarker.core.parser.TokenSource;
import freemarker.template.utility.StringUtil;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.EnumSet;

public class FMLexer
extends TokenSource {
    private Token.TokenType noparseType;
    private int hashLiteralNesting;
    private int parenthesisNesting;
    private int bracketNesting;
    boolean onlyTextOutput;
    boolean directiveSyntaxEstablished;
    boolean altDirectiveSyntax;
    boolean inInvocation;
    boolean justAfterDot;
    String templateName;
    private BitSet nextStates = new BitSet(661);
    private BitSet currentStates = new BitSet(661);
    EnumSet<Token.TokenType> activeTokenTypes = EnumSet.allOf(Token.TokenType.class);
    private static EnumMap<Token.TokenType, LexicalState> tokenTypeToLexicalStateMap = new EnumMap(Token.TokenType.class);
    static final EnumSet<Token.TokenType> regularTokens = EnumSet.of(Token.TokenType.EOF, new Token.TokenType[]{Token.TokenType.CLOSE_DIRECTIVE_BLOCK, Token.TokenType._ATTEMPT, Token.TokenType._RECOVER, Token.TokenType.BLOCKTRIM, Token.TokenType.BLOCKTRIML, Token.TokenType.BLOCKTRIMR, Token.TokenType.BLOCKNOTRIM, Token.TokenType.IF, Token.TokenType.ELSE_IF, Token.TokenType.LIST, Token.TokenType.FOREACH, Token.TokenType.SWITCH, Token.TokenType.CASE, Token.TokenType.ASSIGN, Token.TokenType.GLOBALASSIGN, Token.TokenType.LOCALASSIGN, Token.TokenType.SET, Token.TokenType._INCLUDE, Token.TokenType.IMPORT, Token.TokenType.FUNCTION, Token.TokenType.MACRO, Token.TokenType.PARAM, Token.TokenType.TRANSFORM, Token.TokenType.VISIT, Token.TokenType.STOP, Token.TokenType.RETURN, Token.TokenType.CALL, Token.TokenType.SETTING, Token.TokenType.EMBED, Token.TokenType.VAR, Token.TokenType.COMPRESS, Token.TokenType.COMMENT, Token.TokenType.TERSE_COMMENT, Token.TokenType.NOPARSE, Token.TokenType.ELSE, Token.TokenType.BREAK, Token.TokenType.SIMPLE_RETURN, Token.TokenType.HALT, Token.TokenType.FLUSH, Token.TokenType.TRIM, Token.TokenType.LTRIM, Token.TokenType.RTRIM, Token.TokenType.NOTRIM, Token.TokenType.DEFAUL, Token.TokenType.SIMPLE_NESTED, Token.TokenType.NESTED, Token.TokenType.SIMPLE_RECURSE, Token.TokenType.RECURSE, Token.TokenType.FALLBACK, Token.TokenType.ESCAPE, Token.TokenType.NOESCAPE, Token.TokenType.UNIFIED_CALL, Token.TokenType.UNIFIED_CALL_END, Token.TokenType.FTL_HEADER, Token.TokenType.TRIVIAL_FTL_HEADER, Token.TokenType.UNKNOWN_DIRECTIVE, Token.TokenType.WHITESPACE, Token.TokenType.PRINTABLE_CHARS, Token.TokenType.OUTPUT_ESCAPE, Token.TokenType.NUMERICAL_ESCAPE, Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.FALSE, Token.TokenType.TRUE, Token.TokenType.NULL, Token.TokenType.INTEGER, Token.TokenType.DECIMAL, Token.TokenType.DOT, Token.TokenType.DOT_DOT, Token.TokenType.BUILT_IN, Token.TokenType.EXISTS, Token.TokenType.EQUALS, Token.TokenType.DOUBLE_EQUALS, Token.TokenType.NOT_EQUALS, Token.TokenType.GREATER_THAN, Token.TokenType.GREATER_THAN_EQUALS, Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.LESS_THAN, Token.TokenType.LESS_THAN_EQUALS, Token.TokenType.ESCAPED_GT, Token.TokenType.ESCAPED_GTE, Token.TokenType.PLUS, Token.TokenType.MINUS, Token.TokenType.TIMES, Token.TokenType.DOUBLE_STAR, Token.TokenType.ELLIPSIS, Token.TokenType.DIVIDE, Token.TokenType.PERCENT, Token.TokenType.AND, Token.TokenType.OR, Token.TokenType.EXCLAM, Token.TokenType.COMMA, Token.TokenType.SEMICOLON, Token.TokenType.COLON, Token.TokenType.OPEN_BRACKET, Token.TokenType.CLOSE_BRACKET, Token.TokenType.OPEN_PAREN, Token.TokenType.CLOSE_PAREN, Token.TokenType.OPEN_BRACE, Token.TokenType.CLOSE_BRACE, Token.TokenType.IN, Token.TokenType.AS, Token.TokenType.USING, Token.TokenType.TERMINATING_WHITESPACE, Token.TokenType.TERSE_COMMENT_END, Token.TokenType.COMMENT_END, Token.TokenType.NOPARSE_END, Token.TokenType.DIRECTIVE_END, Token.TokenType.ID});
    private static final EnumSet<Token.TokenType> unparsedTokens = EnumSet.noneOf(Token.TokenType.class);
    static final EnumSet<Token.TokenType> skippedTokens = EnumSet.of(Token.TokenType._TOKEN_61, Token.TokenType._TOKEN_62, Token.TokenType._TOKEN_63, Token.TokenType._TOKEN_64, Token.TokenType._TOKEN_65);
    static final EnumSet<Token.TokenType> moreTokens = EnumSet.of(Token.TokenType._TOKEN_110);
    LexicalState lexicalState = LexicalState.values()[0];
    private static final EnumMap<LexicalState, NfaFunction[]> functionTableMap;

    public void setOnlyTextOutput(boolean b) {
        this.onlyTextOutput = b;
    }

    void setAltDirectiveSyntax(boolean b) {
        this.altDirectiveSyntax = b;
        this.directiveSyntaxEstablished = true;
    }

    private Token tokenHook$FMLexer_ccc$68$19(Token token) {
        String chopFirst;
        if (token.getType() == Token.TokenType.EOF) {
            return token;
        }
        String tokText = token.getImage();
        char firstChar = tokText.charAt(0);
        if (this.justAfterDot && (StringUtil.isFTLIdentifier(tokText) || tokText.equals("*") || tokText.equals("**"))) {
            token.setType(Token.TokenType.ID);
            return token;
        }
        if ((firstChar == '[' || firstChar == '<') && ((chopFirst = tokText.substring(1)).startsWith("#") || chopFirst.startsWith("/#") || chopFirst.startsWith("@") || chopFirst.startsWith("/@"))) {
            boolean squareBracket;
            if (this.onlyTextOutput) {
                token.setType(Token.TokenType.PRINTABLE_CHARS);
                return token;
            }
            boolean bl = squareBracket = firstChar == '[';
            if (!this.directiveSyntaxEstablished) {
                this.setAltDirectiveSyntax(squareBracket);
            } else if (this.altDirectiveSyntax != squareBracket) {
                token.setType(Token.TokenType.PRINTABLE_CHARS);
                return token;
            }
            if (token.getType() == Token.TokenType.UNKNOWN_DIRECTIVE) {
                int index = tokText.indexOf(35);
                String s = tokText.substring(index);
                String msg = "Unknown directive: " + s + " on line: " + token.getBeginLine() + ", column: " + token.getBeginColumn() + 1 + ", in template: " + this.templateName;
                throw new RuntimeException(msg);
            }
        }
        switch (token.getType()) {
            case FTL_HEADER: {
                this.switchTo(LexicalState.EXPRESSION);
                break;
            }
            case GREATER_THAN_EQUALS: 
            case GREATER_THAN: {
                if (this.parenthesisNesting != 0 || this.altDirectiveSyntax) break;
                if (token.getType() == Token.TokenType.GREATER_THAN_EQUALS) {
                    this.backup(1);
                    token.setEndOffset(token.getEndOffset() - 1);
                }
                token.setType(Token.TokenType.DIRECTIVE_END);
                this.switchTo(LexicalState.DEFAULT);
                break;
            }
            case OPEN_PAREN: {
                ++this.parenthesisNesting;
                this.switchTo(LexicalState.EXPRESSION);
                break;
            }
            case CLOSE_PAREN: {
                --this.parenthesisNesting;
                break;
            }
            case OPEN_BRACKET: {
                ++this.bracketNesting;
                break;
            }
            case CLOSE_BRACKET: {
                if (this.bracketNesting > 0) {
                    --this.bracketNesting;
                    break;
                }
                token.setType(Token.TokenType.DIRECTIVE_END);
                this.switchTo(LexicalState.DEFAULT);
                break;
            }
            case OPEN_BRACE: {
                ++this.hashLiteralNesting;
                break;
            }
            case CLOSE_BRACE: {
                if (this.hashLiteralNesting > 0) {
                    --this.hashLiteralNesting;
                    break;
                }
                this.switchTo(LexicalState.DEFAULT);
                break;
            }
            case UNIFIED_CALL: {
                this.switchTo(LexicalState.NO_SPACE_EXPRESSION);
                break;
            }
            case NOPARSE: {
                this.noparseType = Token.TokenType.NOPARSE;
                this.switchTo(LexicalState.NO_PARSE);
                break;
            }
            case TERSE_COMMENT: {
                this.noparseType = Token.TokenType.TERSE_COMMENT;
                this.switchTo(LexicalState.NO_PARSE);
                break;
            }
            case COMMENT: {
                this.noparseType = Token.TokenType.COMMENT;
                this.switchTo(LexicalState.NO_PARSE);
                break;
            }
            case NOPARSE_END: {
                if (this.noparseType != Token.TokenType.NOPARSE) {
                    token.setType(Token.TokenType.PRINTABLE_CHARS);
                    break;
                }
            }
            case COMMENT_END: {
                if (token.getType() == Token.TokenType.COMMENT_END && this.noparseType != Token.TokenType.COMMENT) {
                    token.setType(Token.TokenType.PRINTABLE_CHARS);
                    break;
                }
                char lastChar = tokText.charAt(tokText.length() - 1);
                int startTagChar = lastChar == ']' ? 91 : 60;
                String extraChars = tokText.substring(0, tokText.lastIndexOf(startTagChar));
                if (extraChars.length() > 0) {
                    this.backup(tokText.length() - extraChars.length());
                    token.setEndOffset(token.getEndOffset() - (tokText.length() - extraChars.length()));
                    token.setType(Token.TokenType.PRINTABLE_CHARS);
                    break;
                }
                this.switchTo(LexicalState.DEFAULT);
                break;
            }
            case TERSE_COMMENT_END: {
                if (this.noparseType != Token.TokenType.TERSE_COMMENT) {
                    token.setType(Token.TokenType.PRINTABLE_CHARS);
                    break;
                }
                if (tokText.length() == 3) {
                    this.switchTo(LexicalState.DEFAULT);
                    break;
                }
                this.backup(3);
                token.setEndOffset(token.getEndOffset() - 3);
                token.setType(Token.TokenType.PRINTABLE_CHARS);
                break;
            }
            case FUNCTION: 
            case MACRO: 
            case PARAM: 
            case NESTED: 
            case TRANSFORM: 
            case STOP: 
            case RETURN: 
            case CALL: 
            case IF: 
            case ELSE_IF: 
            case VISIT: 
            case RECURSE: 
            case VAR: 
            case SET: 
            case ASSIGN: 
            case LOCALASSIGN: 
            case GLOBALASSIGN: 
            case LIST: 
            case FOREACH: 
            case SWITCH: 
            case CASE: 
            case _INCLUDE: 
            case IMPORT: 
            case EMBED: 
            case ESCAPE: 
            case SETTING: {
                this.switchTo(LexicalState.EXPRESSION);
            }
        }
        return token;
    }

    public FMLexer(CharSequence input) {
        this("input", input);
    }

    public FMLexer(String inputSource, CharSequence input) {
        this(inputSource, input, LexicalState.DEFAULT, 1, 1);
    }

    public FMLexer(String inputSource, CharSequence input, LexicalState lexState, int startingLine, int startingColumn) {
        super(inputSource, input, startingLine, startingColumn);
        this.setContent(FMLexer.mungeContent(input, true, this.getTabSize(), false, false, false));
        this.createLineOffsetsTable();
        this.createTokenLocationTable();
        this.setStartingPos(startingLine, startingColumn);
        this.switchTo(lexState);
    }

    private Token getNextToken() {
        InvalidToken invalidToken = null;
        Token token = this.nextToken();
        while (token instanceof InvalidToken) {
            if (invalidToken == null) {
                invalidToken = (InvalidToken)token;
            } else {
                invalidToken.setEndOffset(token.getEndOffset());
            }
            token = this.nextToken();
        }
        if (invalidToken != null) {
            this.cacheToken(invalidToken);
        }
        this.cacheToken(token);
        if (invalidToken != null) {
            this.goTo(invalidToken.getEndOffset());
            return invalidToken;
        }
        return token;
    }

    public Token getNextToken(Token tok) {
        if (tok == null) {
            return this.getNextToken();
        }
        Token cachedToken = tok.nextCachedToken();
        if (cachedToken != null && !this.activeTokenTypes.contains((Object)cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        return cachedToken != null ? cachedToken : this.getNextToken(tok.getEndOffset());
    }

    public Token getNextToken(int offset) {
        this.goTo(offset);
        return this.getNextToken();
    }

    private final Token nextToken() {
        Token matchedToken = null;
        boolean inMore = false;
        int tokenBeginOffset = this.getBufferPosition();
        int firstChar = 0;
        while (matchedToken == null) {
            int curChar;
            int codePointsRead = 0;
            int matchedPos = 0;
            Token.TokenType matchedType = null;
            boolean reachedEnd = false;
            if (inMore) {
                curChar = this.readChar();
                if (curChar == -1) {
                    reachedEnd = true;
                }
            } else {
                tokenBeginOffset = this.getBufferPosition();
                firstChar = curChar = this.readChar();
                if (curChar == -1) {
                    matchedType = Token.TokenType.EOF;
                    reachedEnd = true;
                }
            }
            NfaFunction[] nfaFunctions = functionTableMap.get((Object)this.lexicalState);
            if (!reachedEnd) {
                do {
                    int nextActive;
                    Token.TokenType newType = null;
                    if (codePointsRead > 0) {
                        BitSet temp = this.currentStates;
                        this.currentStates = this.nextStates;
                        this.nextStates = temp;
                        int retval = this.readChar();
                        if (retval >= 0) {
                            curChar = retval;
                        } else {
                            reachedEnd = true;
                            break;
                        }
                    }
                    this.nextStates.clear();
                    int n = nextActive = codePointsRead == 0 ? 0 : this.currentStates.nextSetBit(0);
                    do {
                        Token.TokenType returnedType;
                        if ((returnedType = nfaFunctions[nextActive].apply(curChar, this.nextStates, this.activeTokenTypes)) == null || newType != null && returnedType.ordinal() >= newType.ordinal()) continue;
                        newType = returnedType;
                    } while ((nextActive = codePointsRead == 0 ? -1 : this.currentStates.nextSetBit(nextActive + 1)) != -1);
                    ++codePointsRead;
                    if (newType == null) continue;
                    matchedType = newType;
                    inMore = moreTokens.contains((Object)matchedType);
                    matchedPos = codePointsRead;
                } while (!this.nextStates.isEmpty());
            }
            if (matchedType == null) {
                this.setBufferPosition(tokenBeginOffset);
                this.forward(1);
                return new InvalidToken(this, tokenBeginOffset, this.getBufferPosition());
            }
            this.backup(codePointsRead - matchedPos);
            if (skippedTokens.contains((Object)matchedType)) {
                this.skipTokens(tokenBeginOffset, this.getBufferPosition());
            } else if (regularTokens.contains((Object)matchedType) || unparsedTokens.contains((Object)matchedType)) {
                matchedToken = Token.newToken(matchedType, this, tokenBeginOffset, this.getBufferPosition());
                matchedToken.setUnparsed(!regularTokens.contains((Object)matchedType));
            }
            this.doLexicalStateSwitch(matchedType);
        }
        matchedToken = this.tokenHook$FMLexer_ccc$68$19(matchedToken);
        return matchedToken;
    }

    boolean doLexicalStateSwitch(Token.TokenType tokenType) {
        LexicalState newState = tokenTypeToLexicalStateMap.get((Object)tokenType);
        if (newState == null) {
            return false;
        }
        return this.switchTo(newState);
    }

    public boolean switchTo(LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(Token t, LexicalState state) {
        this.goTo(t.getEndOffset());
        this.uncacheTokens(t);
        if (state != null) {
            this.switchTo(state);
        } else {
            this.doLexicalStateSwitch(t.getType());
        }
    }

    void reset(Token t) {
        this.reset(t, null);
    }

    void cacheToken(Token tok) {
        this.cacheTokenAt(tok, tok.getBeginOffset());
    }

    static {
        tokenTypeToLexicalStateMap.put(Token.TokenType.OUTPUT_ESCAPE, LexicalState.EXPRESSION);
        tokenTypeToLexicalStateMap.put(Token.TokenType.NUMERICAL_ESCAPE, LexicalState.EXPRESSION);
        tokenTypeToLexicalStateMap.put(Token.TokenType._TOKEN_62, LexicalState.EXPRESSION_COMMENT);
        tokenTypeToLexicalStateMap.put(Token.TokenType._TOKEN_64, LexicalState.EXPRESSION);
        tokenTypeToLexicalStateMap.put(Token.TokenType._TOKEN_65, LexicalState.EXPRESSION);
        tokenTypeToLexicalStateMap.put(Token.TokenType.EMPTY_DIRECTIVE_END, LexicalState.DEFAULT);
        tokenTypeToLexicalStateMap.put(Token.TokenType.TERMINATING_WHITESPACE, LexicalState.EXPRESSION);
        functionTableMap = new EnumMap(LexicalState.class);
        DEFAULT.NFA_FUNCTIONS_init();
        NODIRECTIVE.NFA_FUNCTIONS_init();
        EXPRESSION.NFA_FUNCTIONS_init();
        EXPRESSION_COMMENT.NFA_FUNCTIONS_init();
        NO_SPACE_EXPRESSION.NFA_FUNCTIONS_init();
        NO_PARSE.NFA_FUNCTIONS_init();
        PHONY.NFA_FUNCTIONS_init();
    }

    private static class PHONY {
        private PHONY() {
        }

        private static Token.TokenType NFA_PHONY_0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.DIRECTIVE_END)) {
                    type = Token.TokenType.DIRECTIVE_END;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.DIRECTIVE_END)) {
                type = Token.TokenType.DIRECTIVE_END;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{PHONY::NFA_PHONY_0};
            functionTableMap.put(LexicalState.PHONY, functions);
        }
    }

    private static class NO_PARSE {
        private NO_PARSE() {
        }

        private static Token.TokenType NFA_NO_PARSE_0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(16);
                nextStates.set(13);
            } else if (ch == 60) {
                nextStates.set(30);
                nextStates.set(25);
            } else if (ch == 91) {
                nextStates.set(34);
                nextStates.set(26);
            }
            if (ch >= 0 && validTypes.contains((Object)Token.TokenType._TOKEN_110)) {
                type = Token.TokenType._TOKEN_110;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(21);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(32);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(1);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(4);
            } else if (ch == 62 && validTypes.contains((Object)Token.TokenType.COMMENT_END)) {
                type = Token.TokenType.COMMENT_END;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 93 && validTypes.contains((Object)Token.TokenType.TERSE_COMMENT_END)) {
                type = Token.TokenType.TERSE_COMMENT_END;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(36);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(9);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(35);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(41);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(39);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(17);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(15);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(18);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(24);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(15);
            } else if (ch == 62 && validTypes.contains((Object)Token.TokenType.NOPARSE_END)) {
                type = Token.TokenType.NOPARSE_END;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(5);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(3);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62 && validTypes.contains((Object)Token.TokenType.TERSE_COMMENT_END)) {
                type = Token.TokenType.TERSE_COMMENT_END;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(31);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(33);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(20);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(38);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(29);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(12);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 47) {
                nextStates.set(44);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 47) {
                nextStates.set(19);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(11);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(6);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(42);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 47) {
                nextStates.set(27);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(37);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(7);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(4);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 47) {
                nextStates.set(23);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(35);
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.NOPARSE_END)) {
                type = Token.TokenType.NOPARSE_END;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(8);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(2);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(10);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(14);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(28);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(43);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(40);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(43);
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.COMMENT_END)) {
                type = Token.TokenType.COMMENT_END;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_PARSE_44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(22);
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{NO_PARSE::NFA_NO_PARSE_0, NO_PARSE::NFA_NO_PARSE_1, NO_PARSE::NFA_NO_PARSE_2, NO_PARSE::NFA_NO_PARSE_3, NO_PARSE::NFA_NO_PARSE_4, NO_PARSE::NFA_NO_PARSE_5, NO_PARSE::NFA_NO_PARSE_6, NO_PARSE::NFA_NO_PARSE_7, NO_PARSE::NFA_NO_PARSE_8, NO_PARSE::NFA_NO_PARSE_9, NO_PARSE::NFA_NO_PARSE_10, NO_PARSE::NFA_NO_PARSE_11, NO_PARSE::NFA_NO_PARSE_12, NO_PARSE::NFA_NO_PARSE_13, NO_PARSE::NFA_NO_PARSE_14, NO_PARSE::NFA_NO_PARSE_15, NO_PARSE::NFA_NO_PARSE_16, NO_PARSE::NFA_NO_PARSE_17, NO_PARSE::NFA_NO_PARSE_18, NO_PARSE::NFA_NO_PARSE_19, NO_PARSE::NFA_NO_PARSE_20, NO_PARSE::NFA_NO_PARSE_21, NO_PARSE::NFA_NO_PARSE_22, NO_PARSE::NFA_NO_PARSE_23, NO_PARSE::NFA_NO_PARSE_24, NO_PARSE::NFA_NO_PARSE_25, NO_PARSE::NFA_NO_PARSE_26, NO_PARSE::NFA_NO_PARSE_27, NO_PARSE::NFA_NO_PARSE_28, NO_PARSE::NFA_NO_PARSE_29, NO_PARSE::NFA_NO_PARSE_30, NO_PARSE::NFA_NO_PARSE_31, NO_PARSE::NFA_NO_PARSE_32, NO_PARSE::NFA_NO_PARSE_33, NO_PARSE::NFA_NO_PARSE_34, NO_PARSE::NFA_NO_PARSE_35, NO_PARSE::NFA_NO_PARSE_36, NO_PARSE::NFA_NO_PARSE_37, NO_PARSE::NFA_NO_PARSE_38, NO_PARSE::NFA_NO_PARSE_39, NO_PARSE::NFA_NO_PARSE_40, NO_PARSE::NFA_NO_PARSE_41, NO_PARSE::NFA_NO_PARSE_42, NO_PARSE::NFA_NO_PARSE_43, NO_PARSE::NFA_NO_PARSE_44};
            functionTableMap.put(LexicalState.NO_PARSE, functions);
        }
    }

    private static class NO_SPACE_EXPRESSION {
        private static int[] NFA_MOVES_NO_SPACE_EXPRESSION_82 = NO_SPACE_EXPRESSION.NFA_MOVES_NO_SPACE_EXPRESSION_82_init();
        private static int[] NFA_MOVES_NO_SPACE_EXPRESSION_102 = NO_SPACE_EXPRESSION.NFA_MOVES_NO_SPACE_EXPRESSION_102_init();

        private NO_SPACE_EXPRESSION() {
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 33) {
                nextStates.set(41);
            } else if (ch == 34) {
                nextStates.set(5);
            } else if (ch == 38) {
                nextStates.set(27);
                nextStates.set(43);
                nextStates.set(47);
                nextStates.set(17);
                nextStates.set(2);
            } else if (ch == 39) {
                nextStates.set(48);
            } else if (ch == 42) {
                nextStates.set(46);
            } else if (ch == 46) {
                nextStates.set(59);
                nextStates.set(32);
            } else if (ch == 47) {
                nextStates.set(34);
                nextStates.set(38);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(52);
            } else if (ch == 60) {
                nextStates.set(50);
            } else if (ch == 61) {
                nextStates.set(26);
            } else if (ch == 62) {
                nextStates.set(16);
            } else if (ch == 63) {
                nextStates.set(54);
            } else if (ch == 92) {
                nextStates.set(39);
                nextStates.set(51);
            } else if (ch == 97) {
                nextStates.set(63);
            } else if (ch == 102) {
                nextStates.set(29);
            } else if (ch == 103) {
                nextStates.set(60);
                nextStates.set(28);
            } else if (ch == 105) {
                nextStates.set(55);
            } else if (ch == 108) {
                nextStates.set(53);
                nextStates.set(4);
            } else if (ch == 110) {
                nextStates.set(49);
            } else if (ch == 114) {
                nextStates.set(58);
            } else if (ch == 116) {
                nextStates.set(45);
            } else if (ch == 117) {
                nextStates.set(9);
            } else if (ch == 124) {
                nextStates.set(44);
            }
            if (ch == 36 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_NO_SPACE_EXPRESSION_102, ch)) {
                nextStates.set(1);
                if (validTypes.contains((Object)Token.TokenType.ID)) {
                    type = Token.TokenType.ID;
                }
            } else if (ch == 64) {
                nextStates.set(1);
                if (validTypes.contains((Object)Token.TokenType.ID)) {
                    type = Token.TokenType.ID;
                }
            } else if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(42);
                if (validTypes.contains((Object)Token.TokenType.TERMINATING_WHITESPACE)) {
                    type = Token.TokenType.TERMINATING_WHITESPACE;
                }
            } else if (ch == 125) {
                if (validTypes.contains((Object)Token.TokenType.CLOSE_BRACE)) {
                    type = Token.TokenType.CLOSE_BRACE;
                }
            } else if (ch == 123) {
                if (validTypes.contains((Object)Token.TokenType.OPEN_BRACE)) {
                    type = Token.TokenType.OPEN_BRACE;
                }
            } else if (ch == 41) {
                if (validTypes.contains((Object)Token.TokenType.CLOSE_PAREN)) {
                    type = Token.TokenType.CLOSE_PAREN;
                }
            } else if (ch == 40) {
                if (validTypes.contains((Object)Token.TokenType.OPEN_PAREN)) {
                    type = Token.TokenType.OPEN_PAREN;
                }
            } else if (ch == 93) {
                if (validTypes.contains((Object)Token.TokenType.CLOSE_BRACKET)) {
                    type = Token.TokenType.CLOSE_BRACKET;
                }
            } else if (ch == 91) {
                if (validTypes.contains((Object)Token.TokenType.OPEN_BRACKET)) {
                    type = Token.TokenType.OPEN_BRACKET;
                }
            } else if (ch == 58) {
                if (validTypes.contains((Object)Token.TokenType.COLON)) {
                    type = Token.TokenType.COLON;
                }
            } else if (ch == 59) {
                if (validTypes.contains((Object)Token.TokenType.SEMICOLON)) {
                    type = Token.TokenType.SEMICOLON;
                }
            } else if (ch == 44) {
                if (validTypes.contains((Object)Token.TokenType.COMMA)) {
                    type = Token.TokenType.COMMA;
                }
            } else if (ch == 33) {
                if (validTypes.contains((Object)Token.TokenType.EXCLAM)) {
                    type = Token.TokenType.EXCLAM;
                }
            } else if (ch == 124) {
                if (validTypes.contains((Object)Token.TokenType.OR)) {
                    type = Token.TokenType.OR;
                }
            } else if (ch == 38) {
                if (validTypes.contains((Object)Token.TokenType.AND)) {
                    type = Token.TokenType.AND;
                }
            } else if (ch == 37) {
                if (validTypes.contains((Object)Token.TokenType.PERCENT)) {
                    type = Token.TokenType.PERCENT;
                }
            } else if (ch == 47) {
                if (validTypes.contains((Object)Token.TokenType.DIVIDE)) {
                    type = Token.TokenType.DIVIDE;
                }
            } else if (ch == 42) {
                if (validTypes.contains((Object)Token.TokenType.TIMES)) {
                    type = Token.TokenType.TIMES;
                }
            } else if (ch == 45) {
                if (validTypes.contains((Object)Token.TokenType.MINUS)) {
                    type = Token.TokenType.MINUS;
                }
            } else if (ch == 43) {
                if (validTypes.contains((Object)Token.TokenType.PLUS)) {
                    type = Token.TokenType.PLUS;
                }
            } else if (ch == 60) {
                if (validTypes.contains((Object)Token.TokenType.LESS_THAN)) {
                    type = Token.TokenType.LESS_THAN;
                }
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.GREATER_THAN)) {
                    type = Token.TokenType.GREATER_THAN;
                }
            } else if (ch == 61) {
                if (validTypes.contains((Object)Token.TokenType.EQUALS)) {
                    type = Token.TokenType.EQUALS;
                }
            } else if (ch == 63) {
                if (validTypes.contains((Object)Token.TokenType.BUILT_IN)) {
                    type = Token.TokenType.BUILT_IN;
                }
            } else if (ch == 46) {
                if (validTypes.contains((Object)Token.TokenType.DOT)) {
                    type = Token.TokenType.DOT;
                }
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(20);
                if (validTypes.contains((Object)Token.TokenType.INTEGER)) {
                    type = Token.TokenType.INTEGER;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 8 || ch >= 14 && ch <= 27 || ch == 36 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 127 && ch <= 159 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_NO_SPACE_EXPRESSION_82, ch)) {
                nextStates.set(1);
                if (validTypes.contains((Object)Token.TokenType.ID)) {
                    type = Token.TokenType.ID;
                }
            } else if (ch == 64) {
                nextStates.set(1);
                if (validTypes.contains((Object)Token.TokenType.ID)) {
                    type = Token.TokenType.ID;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 38 && validTypes.contains((Object)Token.TokenType.AND)) {
                type = Token.TokenType.AND;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(10);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && validTypes.contains((Object)Token.TokenType.LESS_THAN)) {
                type = Token.TokenType.LESS_THAN;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(5);
            } else if (ch == 92) {
                nextStates.set(15);
            } else if (ch == 34 && validTypes.contains((Object)Token.TokenType.STRING_LITERAL)) {
                type = Token.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 59 && validTypes.contains((Object)Token.TokenType.LESS_THAN)) {
                type = Token.TokenType.LESS_THAN;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 59) {
                nextStates.set(24);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 59) {
                nextStates.set(31);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(33);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108 && validTypes.contains((Object)Token.TokenType.NULL)) {
                type = Token.TokenType.NULL;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(11);
            } else if (ch == 34 && validTypes.contains((Object)Token.TokenType.RAW_STRING)) {
                type = Token.TokenType.RAW_STRING;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 103 && validTypes.contains((Object)Token.TokenType.USING)) {
                type = Token.TokenType.USING;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(13);
            } else if (ch == 39 && validTypes.contains((Object)Token.TokenType.RAW_STRING)) {
                type = Token.TokenType.RAW_STRING;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && validTypes.contains((Object)Token.TokenType.TRUE)) {
                type = Token.TokenType.TRUE;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0) {
                nextStates.set(5);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && validTypes.contains((Object)Token.TokenType.GREATER_THAN_EQUALS)) {
                type = Token.TokenType.GREATER_THAN_EQUALS;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(66);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 59 && validTypes.contains((Object)Token.TokenType.ESCAPED_GT)) {
                type = Token.TokenType.ESCAPED_GT;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(8);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(20);
                if (validTypes.contains((Object)Token.TokenType.INTEGER)) {
                    type = Token.TokenType.INTEGER;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && validTypes.contains((Object)Token.TokenType.ESCAPED_GT)) {
                type = Token.TokenType.ESCAPED_GT;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && validTypes.contains((Object)Token.TokenType.ESCAPED_GTE)) {
                type = Token.TokenType.ESCAPED_GTE;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(14);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && validTypes.contains((Object)Token.TokenType.LESS_THAN_EQUALS)) {
                type = Token.TokenType.LESS_THAN_EQUALS;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && validTypes.contains((Object)Token.TokenType.LESS_THAN_EQUALS)) {
                type = Token.TokenType.LESS_THAN_EQUALS;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && validTypes.contains((Object)Token.TokenType.DOUBLE_EQUALS)) {
                type = Token.TokenType.DOUBLE_EQUALS;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 103) {
                nextStates.set(57);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(62);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(35);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0) {
                nextStates.set(48);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && validTypes.contains((Object)Token.TokenType.ESCAPED_GTE)) {
                type = Token.TokenType.ESCAPED_GTE;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(65);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(40);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62 && validTypes.contains((Object)Token.TokenType.EMPTY_DIRECTIVE_END)) {
                type = Token.TokenType.EMPTY_DIRECTIVE_END;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(36);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(56);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(37);
                if (validTypes.contains((Object)Token.TokenType.DECIMAL)) {
                    type = Token.TokenType.DECIMAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 93 && validTypes.contains((Object)Token.TokenType.EMPTY_DIRECTIVE_END)) {
                type = Token.TokenType.EMPTY_DIRECTIVE_END;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 103) {
                nextStates.set(64);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(12);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && validTypes.contains((Object)Token.TokenType.NOT_EQUALS)) {
                type = Token.TokenType.NOT_EQUALS;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(42);
                if (validTypes.contains((Object)Token.TokenType.TERMINATING_WHITESPACE)) {
                    type = Token.TokenType.TERMINATING_WHITESPACE;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(61);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 124 && validTypes.contains((Object)Token.TokenType.OR)) {
                type = Token.TokenType.OR;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_45(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(23);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_46(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 42 && validTypes.contains((Object)Token.TokenType.DOUBLE_STAR)) {
                type = Token.TokenType.DOUBLE_STAR;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_47(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 103) {
                nextStates.set(19);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_48(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(48);
            } else if (ch == 92) {
                nextStates.set(30);
            } else if (ch == 39 && validTypes.contains((Object)Token.TokenType.STRING_LITERAL)) {
                type = Token.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_49(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(3);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_50(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && validTypes.contains((Object)Token.TokenType.LESS_THAN_EQUALS)) {
                type = Token.TokenType.LESS_THAN_EQUALS;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_51(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 103) {
                nextStates.set(21);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_52(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(37);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(52);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_53(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(25);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_54(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 63 && validTypes.contains((Object)Token.TokenType.EXISTS)) {
                type = Token.TokenType.EXISTS;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_55(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110 && validTypes.contains((Object)Token.TokenType.IN)) {
                type = Token.TokenType.IN;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_56(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && validTypes.contains((Object)Token.TokenType.FALSE)) {
                type = Token.TokenType.FALSE;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_57(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(18);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_58(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34) {
                nextStates.set(11);
            } else if (ch == 39) {
                nextStates.set(13);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_59(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46 && validTypes.contains((Object)Token.TokenType.DOT_DOT)) {
                type = Token.TokenType.DOT_DOT;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_60(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && validTypes.contains((Object)Token.TokenType.ESCAPED_GT)) {
                type = Token.TokenType.ESCAPED_GT;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_61(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(6);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_62(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && validTypes.contains((Object)Token.TokenType.ESCAPED_GTE)) {
                type = Token.TokenType.ESCAPED_GTE;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_63(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && validTypes.contains((Object)Token.TokenType.AS)) {
                type = Token.TokenType.AS;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_64(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(22);
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_65(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46 && validTypes.contains((Object)Token.TokenType.ELLIPSIS)) {
                type = Token.TokenType.ELLIPSIS;
            }
            return type;
        }

        private static Token.TokenType NFA_NO_SPACE_EXPRESSION_66(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(7);
            }
            return type;
        }

        private static int[] NFA_MOVES_NO_SPACE_EXPRESSION_82_init() {
            return new int[]{0, 8, 14, 27, 36, 36, 48, 57, 65, 90, 95, 95, 97, 122, 127, 159, 162, 165, 170, 170, 173, 173, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 768, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1155, 1159, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1488, 1514, 1519, 1522, 1536, 1541, 1547, 1547, 1552, 1562, 1564, 1564, 1568, 1641, 1646, 1747, 1749, 1757, 1759, 1768, 1770, 1788, 1791, 1791, 1807, 1866, 1869, 1969, 1984, 2037, 2042, 2042, 2045, 2093, 2112, 2139, 2144, 2154, 2160, 2183, 2185, 2190, 2192, 2193, 2200, 2403, 2406, 2415, 2417, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2500, 2503, 2504, 2507, 2510, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2547, 2555, 2556, 2558, 2558, 2561, 2563, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2649, 2652, 2654, 2654, 2662, 2677, 2689, 2691, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2787, 2790, 2799, 2801, 2801, 2809, 2815, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2876, 2884, 2887, 2888, 2891, 2893, 2901, 2903, 2908, 2909, 2911, 2915, 2918, 2927, 2929, 2929, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3024, 3024, 3031, 3031, 3046, 3055, 3065, 3065, 3072, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3132, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3160, 3162, 3165, 3165, 3168, 3171, 3174, 3183, 3200, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3260, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3293, 3294, 3296, 3299, 3302, 3311, 3313, 3314, 3328, 3340, 3342, 3344, 3346, 3396, 3398, 3400, 3402, 3406, 3412, 3415, 3423, 3427, 3430, 3439, 3450, 3455, 3457, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3558, 3567, 3570, 3571, 3585, 3642, 3647, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3807, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3948, 3953, 3972, 3974, 3991, 3993, 4028, 4038, 4038, 4096, 4169, 4176, 4253, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4957, 4959, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5909, 5919, 5940, 5952, 5971, 5984, 5996, 5998, 6000, 6002, 6003, 6016, 6099, 6103, 6103, 6107, 6109, 6112, 6121, 6155, 6169, 6176, 6264, 6272, 6314, 6320, 6389, 6400, 6430, 6432, 6443, 6448, 6459, 6470, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6608, 6617, 6656, 6683, 6688, 6750, 6752, 6780, 6783, 6793, 6800, 6809, 6823, 6823, 6832, 6845, 6847, 6862, 6912, 6988, 6992, 7001, 7019, 7027, 7040, 7155, 7168, 7223, 7232, 7241, 7245, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7376, 7378, 7380, 7418, 7424, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8203, 8207, 8234, 8238, 8255, 8256, 8276, 8276, 8288, 8292, 8294, 8303, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8400, 8412, 8417, 8417, 8421, 8432, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11647, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11744, 11775, 11823, 11823, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12348, 12353, 12438, 12441, 12442, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42539, 42560, 42607, 42612, 42621, 42623, 42737, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43047, 43052, 43052, 43064, 43064, 43072, 43123, 43136, 43205, 43216, 43225, 43232, 43255, 43259, 43259, 43261, 43309, 43312, 43347, 43360, 43388, 43392, 43456, 43471, 43481, 43488, 43518, 43520, 43574, 43584, 43597, 43600, 43609, 43616, 43638, 43642, 43714, 43739, 43741, 43744, 43759, 43762, 43766, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44010, 44012, 44013, 44016, 44025, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65024, 65039, 65056, 65071, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65279, 65279, 65284, 65284, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65529, 65531, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66045, 66045, 66176, 66204, 66208, 66256, 66272, 66272, 66304, 66335, 66349, 66378, 66384, 66426, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66720, 66729, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68099, 68101, 68102, 68108, 68115, 68117, 68119, 68121, 68149, 68152, 68154, 68159, 68159, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68326, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68903, 68912, 68921, 69248, 69289, 69291, 69292, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69456, 69488, 69509, 69552, 69572, 69600, 69622, 69632, 69702, 69734, 69749, 69759, 69818, 69821, 69821, 69826, 69826, 69837, 69837, 69840, 69864, 69872, 69881, 69888, 69940, 69942, 69951, 69956, 69959, 69968, 70003, 70006, 70006, 70016, 70084, 70089, 70092, 70094, 70106, 70108, 70108, 70144, 70161, 70163, 70199, 70206, 70206, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70378, 70384, 70393, 70400, 70403, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70459, 70468, 70471, 70472, 70475, 70477, 70480, 70480, 70487, 70487, 70493, 70499, 70502, 70508, 70512, 70516, 70656, 70730, 70736, 70745, 70750, 70753, 70784, 70853, 70855, 70855, 70864, 70873, 71040, 71093, 71096, 71104, 71128, 71133, 71168, 71232, 71236, 71236, 71248, 71257, 71296, 71352, 71360, 71369, 71424, 71450, 71453, 71467, 71472, 71481, 71488, 71494, 71680, 71738, 71840, 71913, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71989, 71991, 71992, 71995, 72003, 72016, 72025, 72096, 72103, 72106, 72151, 72154, 72161, 72163, 72164, 72192, 72254, 72263, 72263, 72272, 72345, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72758, 72760, 72768, 72784, 72793, 72818, 72847, 72850, 72871, 72873, 72886, 72960, 72966, 72968, 72969, 72971, 73014, 73018, 73018, 73020, 73021, 73023, 73031, 73040, 73049, 73056, 73061, 73063, 73064, 73066, 73102, 73104, 73105, 73107, 73112, 73120, 73129, 73440, 73462, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 78896, 78904, 82944, 83526, 92160, 92728, 92736, 92766, 92768, 92777, 92784, 92862, 92864, 92873, 92880, 92909, 92912, 92916, 92928, 92982, 92992, 92995, 93008, 93017, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94031, 94087, 94095, 94111, 94176, 94177, 94179, 94180, 94192, 94193, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 113821, 113822, 113824, 113827, 118528, 118573, 118576, 118598, 119141, 119145, 119149, 119170, 119173, 119179, 119210, 119213, 119362, 119364, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 120782, 120831, 121344, 121398, 121403, 121452, 121461, 121461, 121476, 121476, 121499, 121503, 121505, 121519, 122624, 122654, 122880, 122886, 122888, 122904, 122907, 122913, 122915, 122916, 122918, 122922, 123136, 123180, 123184, 123197, 123200, 123209, 123214, 123214, 123536, 123566, 123584, 123641, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125136, 125142, 125184, 125259, 125264, 125273, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 130032, 130041, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546, 917505, 917505, 917536, 917631, 917760, 917999};
        }

        private static int[] NFA_MOVES_NO_SPACE_EXPRESSION_102_init() {
            return new int[]{36, 36, 65, 90, 95, 95, 97, 122, 162, 165, 170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1488, 1514, 1519, 1522, 1547, 1547, 1568, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2046, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2144, 2154, 2160, 2183, 2185, 2190, 2208, 2249, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2432, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2547, 2555, 2556, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2801, 2801, 2809, 2809, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3065, 3065, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3133, 3160, 3162, 3165, 3165, 3168, 3169, 3200, 3200, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3293, 3294, 3296, 3297, 3313, 3314, 3332, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3412, 3414, 3423, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3647, 3654, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5905, 5919, 5937, 5952, 5969, 5984, 5996, 5998, 6000, 6016, 6067, 6103, 6103, 6107, 6108, 6176, 6264, 6272, 6276, 6279, 6312, 6314, 6314, 6320, 6389, 6400, 6430, 6480, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6988, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7401, 7404, 7406, 7411, 7413, 7414, 7418, 7418, 7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8255, 8256, 8276, 8276, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11823, 11823, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539, 42560, 42606, 42623, 42653, 42656, 42735, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43064, 43064, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43261, 43262, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43488, 43492, 43494, 43503, 43514, 43518, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43638, 43642, 43642, 43646, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43741, 43744, 43754, 43762, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65284, 65284, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66176, 66204, 66208, 66256, 66304, 66335, 66349, 66378, 66384, 66421, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68096, 68112, 68115, 68117, 68119, 68121, 68149, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68324, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68899, 69248, 69289, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69445, 69488, 69505, 69552, 69572, 69600, 69622, 69635, 69687, 69745, 69746, 69749, 69749, 69763, 69807, 69840, 69864, 69891, 69926, 69956, 69956, 69959, 69959, 69968, 70002, 70006, 70006, 70019, 70066, 70081, 70084, 70106, 70106, 70108, 70108, 70144, 70161, 70163, 70187, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70366, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70461, 70461, 70480, 70480, 70493, 70497, 70656, 70708, 70727, 70730, 70751, 70753, 70784, 70831, 70852, 70853, 70855, 70855, 71040, 71086, 71128, 71131, 71168, 71215, 71236, 71236, 71296, 71338, 71352, 71352, 71424, 71450, 71488, 71494, 71680, 71723, 71840, 71903, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71983, 71999, 71999, 72001, 72001, 72096, 72103, 72106, 72144, 72161, 72161, 72163, 72163, 72192, 72192, 72203, 72242, 72250, 72250, 72272, 72272, 72284, 72329, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72750, 72768, 72768, 72818, 72847, 72960, 72966, 72968, 72969, 72971, 73008, 73030, 73030, 73056, 73061, 73063, 73064, 73066, 73097, 73112, 73112, 73440, 73458, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 82944, 83526, 92160, 92728, 92736, 92766, 92784, 92862, 92880, 92909, 92928, 92975, 92992, 92995, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94032, 94032, 94099, 94111, 94176, 94177, 94179, 94179, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 122624, 122654, 123136, 123180, 123191, 123197, 123214, 123214, 123536, 123565, 123584, 123627, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125184, 125251, 125259, 125259, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546};
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_0, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_1, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_2, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_3, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_4, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_5, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_6, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_7, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_8, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_9, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_10, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_11, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_12, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_13, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_14, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_15, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_16, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_17, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_18, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_19, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_20, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_21, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_22, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_23, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_24, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_25, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_26, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_27, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_28, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_29, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_30, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_31, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_32, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_33, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_34, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_35, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_36, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_37, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_38, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_39, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_40, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_41, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_42, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_43, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_44, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_45, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_46, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_47, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_48, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_49, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_50, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_51, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_52, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_53, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_54, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_55, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_56, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_57, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_58, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_59, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_60, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_61, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_62, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_63, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_64, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_65, NO_SPACE_EXPRESSION::NFA_NO_SPACE_EXPRESSION_66};
            functionTableMap.put(LexicalState.NO_SPACE_EXPRESSION, functions);
        }
    }

    private static class EXPRESSION_COMMENT {
        private EXPRESSION_COMMENT() {
        }

        private static Token.TokenType NFA_EXPRESSION_COMMENT_0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(1);
                nextStates.set(4);
            }
            if (ch >= 0 && validTypes.contains((Object)Token.TokenType._TOKEN_63)) {
                type = Token.TokenType._TOKEN_63;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_COMMENT_1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(2);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_COMMENT_2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 93 && validTypes.contains((Object)Token.TokenType._TOKEN_65)) {
                type = Token.TokenType._TOKEN_65;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_COMMENT_3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62 && validTypes.contains((Object)Token.TokenType._TOKEN_64)) {
                type = Token.TokenType._TOKEN_64;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_COMMENT_4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(3);
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{EXPRESSION_COMMENT::NFA_EXPRESSION_COMMENT_0, EXPRESSION_COMMENT::NFA_EXPRESSION_COMMENT_1, EXPRESSION_COMMENT::NFA_EXPRESSION_COMMENT_2, EXPRESSION_COMMENT::NFA_EXPRESSION_COMMENT_3, EXPRESSION_COMMENT::NFA_EXPRESSION_COMMENT_4};
            functionTableMap.put(LexicalState.EXPRESSION_COMMENT, functions);
        }
    }

    private static class EXPRESSION {
        private static int[] NFA_MOVES_EXPRESSION_69 = EXPRESSION.NFA_MOVES_EXPRESSION_69_init();
        private static int[] NFA_MOVES_EXPRESSION_107 = EXPRESSION.NFA_MOVES_EXPRESSION_107_init();

        private EXPRESSION() {
        }

        private static Token.TokenType NFA_EXPRESSION_0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 33) {
                nextStates.set(22);
            } else if (ch == 34) {
                nextStates.set(10);
            } else if (ch == 38) {
                nextStates.set(4);
                nextStates.set(7);
                nextStates.set(34);
                nextStates.set(9);
                nextStates.set(15);
            } else if (ch == 39) {
                nextStates.set(11);
            } else if (ch == 42) {
                nextStates.set(39);
            } else if (ch == 46) {
                nextStates.set(43);
                nextStates.set(66);
            } else if (ch == 47) {
                nextStates.set(58);
                nextStates.set(61);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(48);
            } else if (ch == 60 || ch == 91) {
                nextStates.set(8);
            }
            if (ch == 60) {
                nextStates.set(60);
            } else if (ch == 61) {
                nextStates.set(52);
            } else if (ch == 62) {
                nextStates.set(24);
            } else if (ch == 63) {
                nextStates.set(41);
            } else if (ch == 92) {
                nextStates.set(20);
                nextStates.set(2);
            } else if (ch == 97) {
                nextStates.set(56);
            } else if (ch == 102) {
                nextStates.set(54);
            } else if (ch == 103) {
                nextStates.set(35);
                nextStates.set(69);
            } else if (ch == 105) {
                nextStates.set(29);
            } else if (ch == 108) {
                nextStates.set(21);
                nextStates.set(49);
            } else if (ch == 110) {
                nextStates.set(68);
            } else if (ch == 114) {
                nextStates.set(63);
            } else if (ch == 116) {
                nextStates.set(12);
            } else if (ch == 117) {
                nextStates.set(13);
            } else if (ch == 124) {
                nextStates.set(25);
            }
            if (ch == 36 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_EXPRESSION_107, ch)) {
                nextStates.set(1);
                if (validTypes.contains((Object)Token.TokenType.ID)) {
                    type = Token.TokenType.ID;
                }
            } else if (ch == 64) {
                nextStates.set(1);
                if (validTypes.contains((Object)Token.TokenType.ID)) {
                    type = Token.TokenType.ID;
                }
            } else if (ch == 125) {
                if (validTypes.contains((Object)Token.TokenType.CLOSE_BRACE)) {
                    type = Token.TokenType.CLOSE_BRACE;
                }
            } else if (ch == 123) {
                if (validTypes.contains((Object)Token.TokenType.OPEN_BRACE)) {
                    type = Token.TokenType.OPEN_BRACE;
                }
            } else if (ch == 41) {
                if (validTypes.contains((Object)Token.TokenType.CLOSE_PAREN)) {
                    type = Token.TokenType.CLOSE_PAREN;
                }
            } else if (ch == 40) {
                if (validTypes.contains((Object)Token.TokenType.OPEN_PAREN)) {
                    type = Token.TokenType.OPEN_PAREN;
                }
            } else if (ch == 93) {
                if (validTypes.contains((Object)Token.TokenType.CLOSE_BRACKET)) {
                    type = Token.TokenType.CLOSE_BRACKET;
                }
            } else if (ch == 91) {
                if (validTypes.contains((Object)Token.TokenType.OPEN_BRACKET)) {
                    type = Token.TokenType.OPEN_BRACKET;
                }
            } else if (ch == 58) {
                if (validTypes.contains((Object)Token.TokenType.COLON)) {
                    type = Token.TokenType.COLON;
                }
            } else if (ch == 59) {
                if (validTypes.contains((Object)Token.TokenType.SEMICOLON)) {
                    type = Token.TokenType.SEMICOLON;
                }
            } else if (ch == 44) {
                if (validTypes.contains((Object)Token.TokenType.COMMA)) {
                    type = Token.TokenType.COMMA;
                }
            } else if (ch == 33) {
                if (validTypes.contains((Object)Token.TokenType.EXCLAM)) {
                    type = Token.TokenType.EXCLAM;
                }
            } else if (ch == 124) {
                if (validTypes.contains((Object)Token.TokenType.OR)) {
                    type = Token.TokenType.OR;
                }
            } else if (ch == 38) {
                if (validTypes.contains((Object)Token.TokenType.AND)) {
                    type = Token.TokenType.AND;
                }
            } else if (ch == 37) {
                if (validTypes.contains((Object)Token.TokenType.PERCENT)) {
                    type = Token.TokenType.PERCENT;
                }
            } else if (ch == 47) {
                if (validTypes.contains((Object)Token.TokenType.DIVIDE)) {
                    type = Token.TokenType.DIVIDE;
                }
            } else if (ch == 42) {
                if (validTypes.contains((Object)Token.TokenType.TIMES)) {
                    type = Token.TokenType.TIMES;
                }
            } else if (ch == 45) {
                if (validTypes.contains((Object)Token.TokenType.MINUS)) {
                    type = Token.TokenType.MINUS;
                }
            } else if (ch == 43) {
                if (validTypes.contains((Object)Token.TokenType.PLUS)) {
                    type = Token.TokenType.PLUS;
                }
            } else if (ch == 60) {
                if (validTypes.contains((Object)Token.TokenType.LESS_THAN)) {
                    type = Token.TokenType.LESS_THAN;
                }
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.GREATER_THAN)) {
                    type = Token.TokenType.GREATER_THAN;
                }
            } else if (ch == 61) {
                if (validTypes.contains((Object)Token.TokenType.EQUALS)) {
                    type = Token.TokenType.EQUALS;
                }
            } else if (ch == 63) {
                if (validTypes.contains((Object)Token.TokenType.BUILT_IN)) {
                    type = Token.TokenType.BUILT_IN;
                }
            } else if (ch == 46) {
                if (validTypes.contains((Object)Token.TokenType.DOT)) {
                    type = Token.TokenType.DOT;
                }
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(5);
                if (validTypes.contains((Object)Token.TokenType.INTEGER)) {
                    type = Token.TokenType.INTEGER;
                }
            } else if (ch == 9) {
                nextStates.set(65);
                if (validTypes.contains((Object)Token.TokenType._TOKEN_61)) {
                    type = Token.TokenType._TOKEN_61;
                }
            } else if (ch == 10) {
                nextStates.set(65);
                if (validTypes.contains((Object)Token.TokenType._TOKEN_61)) {
                    type = Token.TokenType._TOKEN_61;
                }
            } else if (ch == 13) {
                nextStates.set(65);
                if (validTypes.contains((Object)Token.TokenType._TOKEN_61)) {
                    type = Token.TokenType._TOKEN_61;
                }
            } else if (ch == 32) {
                nextStates.set(65);
                if (validTypes.contains((Object)Token.TokenType._TOKEN_61)) {
                    type = Token.TokenType._TOKEN_61;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 8 || ch >= 14 && ch <= 27 || ch == 36 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 127 && ch <= 159 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_EXPRESSION_69, ch)) {
                nextStates.set(1);
                if (validTypes.contains((Object)Token.TokenType.ID)) {
                    type = Token.TokenType.ID;
                }
            } else if (ch == 64) {
                nextStates.set(1);
                if (validTypes.contains((Object)Token.TokenType.ID)) {
                    type = Token.TokenType.ID;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 103) {
                nextStates.set(28);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(3);
            } else if (ch == 39 && validTypes.contains((Object)Token.TokenType.RAW_STRING)) {
                type = Token.TokenType.RAW_STRING;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 38 && validTypes.contains((Object)Token.TokenType.AND)) {
                type = Token.TokenType.AND;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(5);
                if (validTypes.contains((Object)Token.TokenType.INTEGER)) {
                    type = Token.TokenType.INTEGER;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108 && validTypes.contains((Object)Token.TokenType.NULL)) {
                type = Token.TokenType.NULL;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(23);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 33 || ch == 35) {
                nextStates.set(36);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(26);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(10);
            } else if (ch == 92) {
                nextStates.set(62);
            } else if (ch == 34 && validTypes.contains((Object)Token.TokenType.STRING_LITERAL)) {
                type = Token.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(11);
            } else if (ch == 92) {
                nextStates.set(18);
            } else if (ch == 39 && validTypes.contains((Object)Token.TokenType.STRING_LITERAL)) {
                type = Token.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(32);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(37);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(64);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 103) {
                nextStates.set(14);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(6);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && validTypes.contains((Object)Token.TokenType.ESCAPED_GT)) {
                type = Token.TokenType.ESCAPED_GT;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0) {
                nextStates.set(11);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && validTypes.contains((Object)Token.TokenType.ESCAPED_GTE)) {
                type = Token.TokenType.ESCAPED_GTE;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 103) {
                nextStates.set(17);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && validTypes.contains((Object)Token.TokenType.LESS_THAN)) {
                type = Token.TokenType.LESS_THAN;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && validTypes.contains((Object)Token.TokenType.NOT_EQUALS)) {
                type = Token.TokenType.NOT_EQUALS;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(50);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && validTypes.contains((Object)Token.TokenType.GREATER_THAN_EQUALS)) {
                type = Token.TokenType.GREATER_THAN_EQUALS;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 124 && validTypes.contains((Object)Token.TokenType.OR)) {
                type = Token.TokenType.OR;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(45);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && validTypes.contains((Object)Token.TokenType.ESCAPED_GTE)) {
                type = Token.TokenType.ESCAPED_GTE;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(19);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110 && validTypes.contains((Object)Token.TokenType.IN)) {
                type = Token.TokenType.IN;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 59) {
                nextStates.set(27);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(55);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(53);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && validTypes.contains((Object)Token.TokenType.ESCAPED_GTE)) {
                type = Token.TokenType.ESCAPED_GTE;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 103) {
                nextStates.set(44);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116 && validTypes.contains((Object)Token.TokenType.ESCAPED_GT)) {
                type = Token.TokenType.ESCAPED_GT;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(57);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(31);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(38);
            } else if (ch == 34 && validTypes.contains((Object)Token.TokenType.RAW_STRING)) {
                type = Token.TokenType.RAW_STRING;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 42 && validTypes.contains((Object)Token.TokenType.DOUBLE_STAR)) {
                type = Token.TokenType.DOUBLE_STAR;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(40);
                if (validTypes.contains((Object)Token.TokenType.DECIMAL)) {
                    type = Token.TokenType.DECIMAL;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 63 && validTypes.contains((Object)Token.TokenType.EXISTS)) {
                type = Token.TokenType.EXISTS;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && validTypes.contains((Object)Token.TokenType.LESS_THAN_EQUALS)) {
                type = Token.TokenType.LESS_THAN_EQUALS;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46 && validTypes.contains((Object)Token.TokenType.DOT_DOT)) {
                type = Token.TokenType.DOT_DOT;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(30);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_45(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 59 && validTypes.contains((Object)Token.TokenType.LESS_THAN)) {
                type = Token.TokenType.LESS_THAN;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_46(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(59);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_47(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && validTypes.contains((Object)Token.TokenType.LESS_THAN_EQUALS)) {
                type = Token.TokenType.LESS_THAN_EQUALS;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_48(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(40);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(48);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_49(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(47);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_50(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 59) {
                nextStates.set(42);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_51(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && validTypes.contains((Object)Token.TokenType.FALSE)) {
                type = Token.TokenType.FALSE;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_52(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && validTypes.contains((Object)Token.TokenType.DOUBLE_EQUALS)) {
                type = Token.TokenType.DOUBLE_EQUALS;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_53(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && validTypes.contains((Object)Token.TokenType.TRUE)) {
                type = Token.TokenType.TRUE;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_54(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(46);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_55(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 103 && validTypes.contains((Object)Token.TokenType.USING)) {
                type = Token.TokenType.USING;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_56(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115 && validTypes.contains((Object)Token.TokenType.AS)) {
                type = Token.TokenType.AS;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_57(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45 && validTypes.contains((Object)Token.TokenType._TOKEN_62)) {
                type = Token.TokenType._TOKEN_62;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_58(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 93 && validTypes.contains((Object)Token.TokenType.EMPTY_DIRECTIVE_END)) {
                type = Token.TokenType.EMPTY_DIRECTIVE_END;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_59(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(51);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_60(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && validTypes.contains((Object)Token.TokenType.LESS_THAN_EQUALS)) {
                type = Token.TokenType.LESS_THAN_EQUALS;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_61(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62 && validTypes.contains((Object)Token.TokenType.EMPTY_DIRECTIVE_END)) {
                type = Token.TokenType.EMPTY_DIRECTIVE_END;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_62(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0) {
                nextStates.set(10);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_63(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 34) {
                nextStates.set(38);
            } else if (ch == 39) {
                nextStates.set(3);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_64(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 59 && validTypes.contains((Object)Token.TokenType.ESCAPED_GT)) {
                type = Token.TokenType.ESCAPED_GT;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_65(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9) {
                nextStates.set(65);
                if (validTypes.contains((Object)Token.TokenType._TOKEN_61)) {
                    type = Token.TokenType._TOKEN_61;
                }
            } else if (ch == 10) {
                nextStates.set(65);
                if (validTypes.contains((Object)Token.TokenType._TOKEN_61)) {
                    type = Token.TokenType._TOKEN_61;
                }
            } else if (ch == 13) {
                nextStates.set(65);
                if (validTypes.contains((Object)Token.TokenType._TOKEN_61)) {
                    type = Token.TokenType._TOKEN_61;
                }
            } else if (ch == 32) {
                nextStates.set(65);
                if (validTypes.contains((Object)Token.TokenType._TOKEN_61)) {
                    type = Token.TokenType._TOKEN_61;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_66(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(67);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_67(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46 && validTypes.contains((Object)Token.TokenType.ELLIPSIS)) {
                type = Token.TokenType.ELLIPSIS;
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_68(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(16);
            }
            return type;
        }

        private static Token.TokenType NFA_EXPRESSION_69(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(33);
            }
            return type;
        }

        private static int[] NFA_MOVES_EXPRESSION_69_init() {
            return new int[]{0, 8, 14, 27, 36, 36, 48, 57, 65, 90, 95, 95, 97, 122, 127, 159, 162, 165, 170, 170, 173, 173, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 768, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1155, 1159, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1488, 1514, 1519, 1522, 1536, 1541, 1547, 1547, 1552, 1562, 1564, 1564, 1568, 1641, 1646, 1747, 1749, 1757, 1759, 1768, 1770, 1788, 1791, 1791, 1807, 1866, 1869, 1969, 1984, 2037, 2042, 2042, 2045, 2093, 2112, 2139, 2144, 2154, 2160, 2183, 2185, 2190, 2192, 2193, 2200, 2403, 2406, 2415, 2417, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2500, 2503, 2504, 2507, 2510, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2547, 2555, 2556, 2558, 2558, 2561, 2563, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2649, 2652, 2654, 2654, 2662, 2677, 2689, 2691, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2787, 2790, 2799, 2801, 2801, 2809, 2815, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2876, 2884, 2887, 2888, 2891, 2893, 2901, 2903, 2908, 2909, 2911, 2915, 2918, 2927, 2929, 2929, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3024, 3024, 3031, 3031, 3046, 3055, 3065, 3065, 3072, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3132, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3160, 3162, 3165, 3165, 3168, 3171, 3174, 3183, 3200, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3260, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3293, 3294, 3296, 3299, 3302, 3311, 3313, 3314, 3328, 3340, 3342, 3344, 3346, 3396, 3398, 3400, 3402, 3406, 3412, 3415, 3423, 3427, 3430, 3439, 3450, 3455, 3457, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3558, 3567, 3570, 3571, 3585, 3642, 3647, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3807, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3948, 3953, 3972, 3974, 3991, 3993, 4028, 4038, 4038, 4096, 4169, 4176, 4253, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4957, 4959, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5909, 5919, 5940, 5952, 5971, 5984, 5996, 5998, 6000, 6002, 6003, 6016, 6099, 6103, 6103, 6107, 6109, 6112, 6121, 6155, 6169, 6176, 6264, 6272, 6314, 6320, 6389, 6400, 6430, 6432, 6443, 6448, 6459, 6470, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6608, 6617, 6656, 6683, 6688, 6750, 6752, 6780, 6783, 6793, 6800, 6809, 6823, 6823, 6832, 6845, 6847, 6862, 6912, 6988, 6992, 7001, 7019, 7027, 7040, 7155, 7168, 7223, 7232, 7241, 7245, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7376, 7378, 7380, 7418, 7424, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8203, 8207, 8234, 8238, 8255, 8256, 8276, 8276, 8288, 8292, 8294, 8303, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8400, 8412, 8417, 8417, 8421, 8432, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11647, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11744, 11775, 11823, 11823, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12348, 12353, 12438, 12441, 12442, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42539, 42560, 42607, 42612, 42621, 42623, 42737, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43047, 43052, 43052, 43064, 43064, 43072, 43123, 43136, 43205, 43216, 43225, 43232, 43255, 43259, 43259, 43261, 43309, 43312, 43347, 43360, 43388, 43392, 43456, 43471, 43481, 43488, 43518, 43520, 43574, 43584, 43597, 43600, 43609, 43616, 43638, 43642, 43714, 43739, 43741, 43744, 43759, 43762, 43766, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44010, 44012, 44013, 44016, 44025, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65024, 65039, 65056, 65071, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65279, 65279, 65284, 65284, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65529, 65531, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66045, 66045, 66176, 66204, 66208, 66256, 66272, 66272, 66304, 66335, 66349, 66378, 66384, 66426, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66720, 66729, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68099, 68101, 68102, 68108, 68115, 68117, 68119, 68121, 68149, 68152, 68154, 68159, 68159, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68326, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68903, 68912, 68921, 69248, 69289, 69291, 69292, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69456, 69488, 69509, 69552, 69572, 69600, 69622, 69632, 69702, 69734, 69749, 69759, 69818, 69821, 69821, 69826, 69826, 69837, 69837, 69840, 69864, 69872, 69881, 69888, 69940, 69942, 69951, 69956, 69959, 69968, 70003, 70006, 70006, 70016, 70084, 70089, 70092, 70094, 70106, 70108, 70108, 70144, 70161, 70163, 70199, 70206, 70206, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70378, 70384, 70393, 70400, 70403, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70459, 70468, 70471, 70472, 70475, 70477, 70480, 70480, 70487, 70487, 70493, 70499, 70502, 70508, 70512, 70516, 70656, 70730, 70736, 70745, 70750, 70753, 70784, 70853, 70855, 70855, 70864, 70873, 71040, 71093, 71096, 71104, 71128, 71133, 71168, 71232, 71236, 71236, 71248, 71257, 71296, 71352, 71360, 71369, 71424, 71450, 71453, 71467, 71472, 71481, 71488, 71494, 71680, 71738, 71840, 71913, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71989, 71991, 71992, 71995, 72003, 72016, 72025, 72096, 72103, 72106, 72151, 72154, 72161, 72163, 72164, 72192, 72254, 72263, 72263, 72272, 72345, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72758, 72760, 72768, 72784, 72793, 72818, 72847, 72850, 72871, 72873, 72886, 72960, 72966, 72968, 72969, 72971, 73014, 73018, 73018, 73020, 73021, 73023, 73031, 73040, 73049, 73056, 73061, 73063, 73064, 73066, 73102, 73104, 73105, 73107, 73112, 73120, 73129, 73440, 73462, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 78896, 78904, 82944, 83526, 92160, 92728, 92736, 92766, 92768, 92777, 92784, 92862, 92864, 92873, 92880, 92909, 92912, 92916, 92928, 92982, 92992, 92995, 93008, 93017, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94031, 94087, 94095, 94111, 94176, 94177, 94179, 94180, 94192, 94193, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 113821, 113822, 113824, 113827, 118528, 118573, 118576, 118598, 119141, 119145, 119149, 119170, 119173, 119179, 119210, 119213, 119362, 119364, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 120782, 120831, 121344, 121398, 121403, 121452, 121461, 121461, 121476, 121476, 121499, 121503, 121505, 121519, 122624, 122654, 122880, 122886, 122888, 122904, 122907, 122913, 122915, 122916, 122918, 122922, 123136, 123180, 123184, 123197, 123200, 123209, 123214, 123214, 123536, 123566, 123584, 123641, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125136, 125142, 125184, 125259, 125264, 125273, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 130032, 130041, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546, 917505, 917505, 917536, 917631, 917760, 917999};
        }

        private static int[] NFA_MOVES_EXPRESSION_107_init() {
            return new int[]{36, 36, 65, 90, 95, 95, 97, 122, 162, 165, 170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1488, 1514, 1519, 1522, 1547, 1547, 1568, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2046, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2144, 2154, 2160, 2183, 2185, 2190, 2208, 2249, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2432, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2547, 2555, 2556, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2801, 2801, 2809, 2809, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3065, 3065, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3133, 3160, 3162, 3165, 3165, 3168, 3169, 3200, 3200, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3293, 3294, 3296, 3297, 3313, 3314, 3332, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3412, 3414, 3423, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3647, 3654, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5905, 5919, 5937, 5952, 5969, 5984, 5996, 5998, 6000, 6016, 6067, 6103, 6103, 6107, 6108, 6176, 6264, 6272, 6276, 6279, 6312, 6314, 6314, 6320, 6389, 6400, 6430, 6480, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6988, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7401, 7404, 7406, 7411, 7413, 7414, 7418, 7418, 7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8255, 8256, 8276, 8276, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11823, 11823, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539, 42560, 42606, 42623, 42653, 42656, 42735, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43064, 43064, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43261, 43262, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43488, 43492, 43494, 43503, 43514, 43518, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43638, 43642, 43642, 43646, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43741, 43744, 43754, 43762, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65284, 65284, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66176, 66204, 66208, 66256, 66304, 66335, 66349, 66378, 66384, 66421, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68096, 68112, 68115, 68117, 68119, 68121, 68149, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68324, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68899, 69248, 69289, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69445, 69488, 69505, 69552, 69572, 69600, 69622, 69635, 69687, 69745, 69746, 69749, 69749, 69763, 69807, 69840, 69864, 69891, 69926, 69956, 69956, 69959, 69959, 69968, 70002, 70006, 70006, 70019, 70066, 70081, 70084, 70106, 70106, 70108, 70108, 70144, 70161, 70163, 70187, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70366, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70461, 70461, 70480, 70480, 70493, 70497, 70656, 70708, 70727, 70730, 70751, 70753, 70784, 70831, 70852, 70853, 70855, 70855, 71040, 71086, 71128, 71131, 71168, 71215, 71236, 71236, 71296, 71338, 71352, 71352, 71424, 71450, 71488, 71494, 71680, 71723, 71840, 71903, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71983, 71999, 71999, 72001, 72001, 72096, 72103, 72106, 72144, 72161, 72161, 72163, 72163, 72192, 72192, 72203, 72242, 72250, 72250, 72272, 72272, 72284, 72329, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72750, 72768, 72768, 72818, 72847, 72960, 72966, 72968, 72969, 72971, 73008, 73030, 73030, 73056, 73061, 73063, 73064, 73066, 73097, 73112, 73112, 73440, 73458, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 82944, 83526, 92160, 92728, 92736, 92766, 92784, 92862, 92880, 92909, 92928, 92975, 92992, 92995, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94032, 94032, 94099, 94111, 94176, 94177, 94179, 94179, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 122624, 122654, 123136, 123180, 123191, 123197, 123214, 123214, 123536, 123565, 123584, 123627, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125184, 125251, 125259, 125259, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546};
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{EXPRESSION::NFA_EXPRESSION_0, EXPRESSION::NFA_EXPRESSION_1, EXPRESSION::NFA_EXPRESSION_2, EXPRESSION::NFA_EXPRESSION_3, EXPRESSION::NFA_EXPRESSION_4, EXPRESSION::NFA_EXPRESSION_5, EXPRESSION::NFA_EXPRESSION_6, EXPRESSION::NFA_EXPRESSION_7, EXPRESSION::NFA_EXPRESSION_8, EXPRESSION::NFA_EXPRESSION_9, EXPRESSION::NFA_EXPRESSION_10, EXPRESSION::NFA_EXPRESSION_11, EXPRESSION::NFA_EXPRESSION_12, EXPRESSION::NFA_EXPRESSION_13, EXPRESSION::NFA_EXPRESSION_14, EXPRESSION::NFA_EXPRESSION_15, EXPRESSION::NFA_EXPRESSION_16, EXPRESSION::NFA_EXPRESSION_17, EXPRESSION::NFA_EXPRESSION_18, EXPRESSION::NFA_EXPRESSION_19, EXPRESSION::NFA_EXPRESSION_20, EXPRESSION::NFA_EXPRESSION_21, EXPRESSION::NFA_EXPRESSION_22, EXPRESSION::NFA_EXPRESSION_23, EXPRESSION::NFA_EXPRESSION_24, EXPRESSION::NFA_EXPRESSION_25, EXPRESSION::NFA_EXPRESSION_26, EXPRESSION::NFA_EXPRESSION_27, EXPRESSION::NFA_EXPRESSION_28, EXPRESSION::NFA_EXPRESSION_29, EXPRESSION::NFA_EXPRESSION_30, EXPRESSION::NFA_EXPRESSION_31, EXPRESSION::NFA_EXPRESSION_32, EXPRESSION::NFA_EXPRESSION_33, EXPRESSION::NFA_EXPRESSION_34, EXPRESSION::NFA_EXPRESSION_35, EXPRESSION::NFA_EXPRESSION_36, EXPRESSION::NFA_EXPRESSION_37, EXPRESSION::NFA_EXPRESSION_38, EXPRESSION::NFA_EXPRESSION_39, EXPRESSION::NFA_EXPRESSION_40, EXPRESSION::NFA_EXPRESSION_41, EXPRESSION::NFA_EXPRESSION_42, EXPRESSION::NFA_EXPRESSION_43, EXPRESSION::NFA_EXPRESSION_44, EXPRESSION::NFA_EXPRESSION_45, EXPRESSION::NFA_EXPRESSION_46, EXPRESSION::NFA_EXPRESSION_47, EXPRESSION::NFA_EXPRESSION_48, EXPRESSION::NFA_EXPRESSION_49, EXPRESSION::NFA_EXPRESSION_50, EXPRESSION::NFA_EXPRESSION_51, EXPRESSION::NFA_EXPRESSION_52, EXPRESSION::NFA_EXPRESSION_53, EXPRESSION::NFA_EXPRESSION_54, EXPRESSION::NFA_EXPRESSION_55, EXPRESSION::NFA_EXPRESSION_56, EXPRESSION::NFA_EXPRESSION_57, EXPRESSION::NFA_EXPRESSION_58, EXPRESSION::NFA_EXPRESSION_59, EXPRESSION::NFA_EXPRESSION_60, EXPRESSION::NFA_EXPRESSION_61, EXPRESSION::NFA_EXPRESSION_62, EXPRESSION::NFA_EXPRESSION_63, EXPRESSION::NFA_EXPRESSION_64, EXPRESSION::NFA_EXPRESSION_65, EXPRESSION::NFA_EXPRESSION_66, EXPRESSION::NFA_EXPRESSION_67, EXPRESSION::NFA_EXPRESSION_68, EXPRESSION::NFA_EXPRESSION_69};
            functionTableMap.put(LexicalState.EXPRESSION, functions);
        }
    }

    private static class NODIRECTIVE {
        private static int[] NFA_MOVES_NODIRECTIVE_2 = NODIRECTIVE.NFA_MOVES_NODIRECTIVE_2_init();

        private NODIRECTIVE() {
        }

        private static Token.TokenType NFA_NODIRECTIVE_0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(4);
            } else if (ch == 36) {
                nextStates.set(1);
            } else if (ch >= 0 && ch <= 8 || ch == 11 || ch == 12 || ch >= 14 && ch <= 31 || ch == 33 || ch == 34 || ch >= 37 && ch <= 59 || ch >= 61 && ch <= 90 || ch >= 92 && ch <= 122 || ch >= 124 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_NODIRECTIVE_2, ch)) {
                nextStates.set(3);
                if (validTypes.contains((Object)Token.TokenType.PRINTABLE_CHARS)) {
                    type = Token.TokenType.PRINTABLE_CHARS;
                }
            }
            if (ch == 35) {
                if (validTypes.contains((Object)Token.TokenType.PRINTABLE_CHARS)) {
                    type = Token.TokenType.PRINTABLE_CHARS;
                }
            } else if (ch == 36) {
                if (validTypes.contains((Object)Token.TokenType.PRINTABLE_CHARS)) {
                    type = Token.TokenType.PRINTABLE_CHARS;
                }
            } else if (ch == 60) {
                if (validTypes.contains((Object)Token.TokenType.PRINTABLE_CHARS)) {
                    type = Token.TokenType.PRINTABLE_CHARS;
                }
            } else if (ch == 91) {
                if (validTypes.contains((Object)Token.TokenType.PRINTABLE_CHARS)) {
                    type = Token.TokenType.PRINTABLE_CHARS;
                }
            } else if (ch == 123) {
                if (validTypes.contains((Object)Token.TokenType.PRINTABLE_CHARS)) {
                    type = Token.TokenType.PRINTABLE_CHARS;
                }
            } else if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(2);
                if (validTypes.contains((Object)Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_NODIRECTIVE_1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 123 && validTypes.contains((Object)Token.TokenType.OUTPUT_ESCAPE)) {
                type = Token.TokenType.OUTPUT_ESCAPE;
            }
            return type;
        }

        private static Token.TokenType NFA_NODIRECTIVE_2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(2);
                if (validTypes.contains((Object)Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_NODIRECTIVE_3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 8 || ch == 11 || ch == 12 || ch >= 14 && ch <= 31 || ch == 33 || ch == 34 || ch >= 37 && ch <= 59 || ch >= 61 && ch <= 90 || ch >= 92 && ch <= 122 || ch >= 124 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_NODIRECTIVE_2, ch)) {
                nextStates.set(3);
                if (validTypes.contains((Object)Token.TokenType.PRINTABLE_CHARS)) {
                    type = Token.TokenType.PRINTABLE_CHARS;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_NODIRECTIVE_4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 123 && validTypes.contains((Object)Token.TokenType.NUMERICAL_ESCAPE)) {
                type = Token.TokenType.NUMERICAL_ESCAPE;
            }
            return type;
        }

        private static int[] NFA_MOVES_NODIRECTIVE_2_init() {
            return new int[]{0, 8, 11, 12, 14, 31, 33, 34, 37, 59, 61, 90, 92, 122, 124, 0x10FFFF};
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{NODIRECTIVE::NFA_NODIRECTIVE_0, NODIRECTIVE::NFA_NODIRECTIVE_1, NODIRECTIVE::NFA_NODIRECTIVE_2, NODIRECTIVE::NFA_NODIRECTIVE_3, NODIRECTIVE::NFA_NODIRECTIVE_4};
            functionTableMap.put(LexicalState.NODIRECTIVE, functions);
        }
    }

    private static class DEFAULT {
        private static int[] NFA_MOVES_146 = DEFAULT.NFA_MOVES_146_init();
        private static int[] NFA_MOVES_193 = DEFAULT.NFA_MOVES_193_init();
        private static int[] NFA_MOVES_275 = DEFAULT.NFA_MOVES_275_init();
        private static int[] NFA_MOVES_399 = DEFAULT.NFA_MOVES_399_init();
        private static int[] NFA_MOVES_508 = DEFAULT.NFA_MOVES_508_init();

        private DEFAULT() {
        }

        private static Token.TokenType NFA_0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(115);
            } else if (ch == 36) {
                nextStates.set(87);
            } else if (ch == 60) {
                nextStates.set(404);
                nextStates.set(249);
                nextStates.set(384);
                nextStates.set(474);
                nextStates.set(294);
                nextStates.set(409);
                nextStates.set(355);
                nextStates.set(257);
                nextStates.set(27);
                nextStates.set(349);
                nextStates.set(35);
                nextStates.set(272);
                nextStates.set(251);
                nextStates.set(360);
                nextStates.set(92);
                nextStates.set(15);
                nextStates.set(29);
                nextStates.set(194);
                nextStates.set(357);
                nextStates.set(166);
                nextStates.set(246);
                nextStates.set(258);
                nextStates.set(408);
                nextStates.set(265);
                nextStates.set(83);
                nextStates.set(8);
                nextStates.set(461);
                nextStates.set(69);
                nextStates.set(206);
                nextStates.set(210);
                nextStates.set(280);
                nextStates.set(342);
                nextStates.set(431);
                nextStates.set(320);
                nextStates.set(47);
                nextStates.set(394);
                nextStates.set(358);
                nextStates.set(288);
                nextStates.set(154);
                nextStates.set(5);
                nextStates.set(65);
                nextStates.set(10);
                nextStates.set(113);
                nextStates.set(283);
                nextStates.set(356);
                nextStates.set(16);
                nextStates.set(133);
                nextStates.set(321);
                nextStates.set(146);
                nextStates.set(295);
                nextStates.set(50);
                nextStates.set(100);
                nextStates.set(344);
                nextStates.set(90);
                nextStates.set(262);
                nextStates.set(22);
                nextStates.set(11);
            } else if (ch == 91) {
                nextStates.set(338);
                nextStates.set(67);
                nextStates.set(181);
                nextStates.set(478);
                nextStates.set(340);
                nextStates.set(191);
                nextStates.set(198);
                nextStates.set(475);
                nextStates.set(454);
                nextStates.set(316);
                nextStates.set(129);
                nextStates.set(460);
                nextStates.set(121);
                nextStates.set(95);
                nextStates.set(311);
                nextStates.set(322);
                nextStates.set(326);
                nextStates.set(422);
                nextStates.set(443);
                nextStates.set(381);
                nextStates.set(276);
                nextStates.set(282);
                nextStates.set(18);
                nextStates.set(69);
                nextStates.set(417);
                nextStates.set(70);
                nextStates.set(290);
                nextStates.set(162);
                nextStates.set(484);
                nextStates.set(226);
                nextStates.set(13);
                nextStates.set(236);
                nextStates.set(52);
                nextStates.set(4);
                nextStates.set(292);
                nextStates.set(173);
                nextStates.set(357);
                nextStates.set(108);
                nextStates.set(218);
                nextStates.set(157);
                nextStates.set(291);
                nextStates.set(82);
                nextStates.set(274);
                nextStates.set(109);
                nextStates.set(471);
                nextStates.set(329);
                nextStates.set(371);
                nextStates.set(410);
                nextStates.set(388);
                nextStates.set(84);
                nextStates.set(331);
                nextStates.set(466);
                nextStates.set(58);
                nextStates.set(204);
                nextStates.set(195);
                nextStates.set(86);
                nextStates.set(452);
            } else if (ch >= 0 && ch <= 8 || ch == 11 || ch == 12 || ch >= 14 && ch <= 31 || ch == 33 || ch == 34 || ch >= 37 && ch <= 59 || ch >= 61 && ch <= 90 || ch >= 92 && ch <= 122 || ch >= 124 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_146, ch)) {
                nextStates.set(479);
                if (validTypes.contains((Object)Token.TokenType.PRINTABLE_CHARS)) {
                    type = Token.TokenType.PRINTABLE_CHARS;
                }
            }
            if (ch == 35) {
                if (validTypes.contains((Object)Token.TokenType.PRINTABLE_CHARS)) {
                    type = Token.TokenType.PRINTABLE_CHARS;
                }
            } else if (ch == 36) {
                if (validTypes.contains((Object)Token.TokenType.PRINTABLE_CHARS)) {
                    type = Token.TokenType.PRINTABLE_CHARS;
                }
            } else if (ch == 60) {
                if (validTypes.contains((Object)Token.TokenType.PRINTABLE_CHARS)) {
                    type = Token.TokenType.PRINTABLE_CHARS;
                }
            } else if (ch == 91) {
                if (validTypes.contains((Object)Token.TokenType.PRINTABLE_CHARS)) {
                    type = Token.TokenType.PRINTABLE_CHARS;
                }
            } else if (ch == 123) {
                if (validTypes.contains((Object)Token.TokenType.PRINTABLE_CHARS)) {
                    type = Token.TokenType.PRINTABLE_CHARS;
                }
            } else if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(172);
                if (validTypes.contains((Object)Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(348);
            }
            return type;
        }

        private static Token.TokenType NFA_2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(433);
            }
            return type;
        }

        private static Token.TokenType NFA_3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(193);
            }
            return type;
        }

        private static Token.TokenType NFA_4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(299);
            }
            return type;
        }

        private static Token.TokenType NFA_5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 47) {
                nextStates.set(1);
            }
            return type;
        }

        private static Token.TokenType NFA_6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(413);
            }
            return type;
        }

        private static Token.TokenType NFA_7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(379);
            }
            return type;
        }

        private static Token.TokenType NFA_8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(362);
            }
            return type;
        }

        private static Token.TokenType NFA_9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(312);
            }
            return type;
        }

        private static Token.TokenType NFA_10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(254);
            }
            return type;
        }

        private static Token.TokenType NFA_11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(297);
            }
            return type;
        }

        private static Token.TokenType NFA_12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 118) {
                nextStates.set(266);
            }
            return type;
        }

        private static Token.TokenType NFA_13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(31);
            }
            return type;
        }

        private static Token.TokenType NFA_14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(405);
            }
            return type;
        }

        private static Token.TokenType NFA_15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(49);
            }
            return type;
        }

        private static Token.TokenType NFA_16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(202);
            }
            return type;
        }

        private static Token.TokenType NFA_17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(469);
            }
            return type;
        }

        private static Token.TokenType NFA_18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(428);
            }
            return type;
        }

        private static Token.TokenType NFA_19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 98) {
                nextStates.set(337);
            }
            return type;
        }

        private static Token.TokenType NFA_20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(418);
            }
            return type;
        }

        private static Token.TokenType NFA_21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(229);
            }
            return type;
        }

        private static Token.TokenType NFA_22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(3);
            }
            return type;
        }

        private static Token.TokenType NFA_23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(336);
            }
            return type;
        }

        private static Token.TokenType NFA_24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(55);
            }
            return type;
        }

        private static Token.TokenType NFA_25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(477);
            }
            return type;
        }

        private static Token.TokenType NFA_26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(255);
            }
            return type;
        }

        private static Token.TokenType NFA_27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(117);
            }
            return type;
        }

        private static Token.TokenType NFA_28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(267);
            }
            return type;
        }

        private static Token.TokenType NFA_29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(182);
            }
            return type;
        }

        private static Token.TokenType NFA_30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(453);
            }
            return type;
        }

        private static Token.TokenType NFA_31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(444);
            }
            return type;
        }

        private static Token.TokenType NFA_32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(143);
            }
            return type;
        }

        private static Token.TokenType NFA_33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(315);
            }
            return type;
        }

        private static Token.TokenType NFA_34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(373);
            }
            return type;
        }

        private static Token.TokenType NFA_35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(168);
            }
            return type;
        }

        private static Token.TokenType NFA_36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(199);
            }
            return type;
        }

        private static Token.TokenType NFA_37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(175);
            }
            return type;
        }

        private static Token.TokenType NFA_38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(150);
            }
            return type;
        }

        private static Token.TokenType NFA_39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.SETTING)) {
                type = Token.TokenType.SETTING;
            }
            return type;
        }

        private static Token.TokenType NFA_40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(330);
            }
            return type;
        }

        private static Token.TokenType NFA_41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(414);
            }
            return type;
        }

        private static Token.TokenType NFA_42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100) {
                nextStates.set(376);
            }
            return type;
        }

        private static Token.TokenType NFA_43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(397);
            }
            return type;
        }

        private static Token.TokenType NFA_44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.FLUSH)) {
                    type = Token.TokenType.FLUSH;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.FLUSH)) {
                type = Token.TokenType.FLUSH;
            }
            return type;
        }

        private static Token.TokenType NFA_45(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.SWITCH)) {
                type = Token.TokenType.SWITCH;
            }
            return type;
        }

        private static Token.TokenType NFA_46(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(161);
            }
            return type;
        }

        private static Token.TokenType NFA_47(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(137);
            }
            return type;
        }

        private static Token.TokenType NFA_48(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(103);
            }
            return type;
        }

        private static Token.TokenType NFA_49(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 118) {
                nextStates.set(14);
            }
            return type;
        }

        private static Token.TokenType NFA_50(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(269);
            }
            return type;
        }

        private static Token.TokenType NFA_51(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(36);
            }
            return type;
        }

        private static Token.TokenType NFA_52(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(213);
            }
            return type;
        }

        private static Token.TokenType NFA_53(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(66);
            }
            return type;
        }

        private static Token.TokenType NFA_54(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(75);
            }
            return type;
        }

        private static Token.TokenType NFA_55(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 47) {
                nextStates.set(63);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.TRIVIAL_FTL_HEADER)) {
                    type = Token.TokenType.TRIVIAL_FTL_HEADER;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.TRIVIAL_FTL_HEADER)) {
                type = Token.TokenType.TRIVIAL_FTL_HEADER;
            }
            return type;
        }

        private static Token.TokenType NFA_56(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(343);
            }
            return type;
        }

        private static Token.TokenType NFA_57(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(370);
            }
            return type;
        }

        private static Token.TokenType NFA_58(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(130);
            }
            return type;
        }

        private static Token.TokenType NFA_59(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(30);
            }
            return type;
        }

        private static Token.TokenType NFA_60(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(307);
            }
            return type;
        }

        private static Token.TokenType NFA_61(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(223);
            }
            return type;
        }

        private static Token.TokenType NFA_62(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(110);
            }
            return type;
        }

        private static Token.TokenType NFA_63(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.TRIVIAL_FTL_HEADER)) {
                    type = Token.TokenType.TRIVIAL_FTL_HEADER;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.TRIVIAL_FTL_HEADER)) {
                type = Token.TokenType.TRIVIAL_FTL_HEADER;
            }
            return type;
        }

        private static Token.TokenType NFA_64(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100) {
                nextStates.set(200);
            }
            return type;
        }

        private static Token.TokenType NFA_65(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(470);
            }
            return type;
        }

        private static Token.TokenType NFA_66(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(365);
            }
            return type;
        }

        private static Token.TokenType NFA_67(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(297);
            }
            return type;
        }

        private static Token.TokenType NFA_68(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(24);
            }
            return type;
        }

        private static Token.TokenType NFA_69(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(61);
            }
            return type;
        }

        private static Token.TokenType NFA_70(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(273);
            }
            return type;
        }

        private static Token.TokenType NFA_71(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(472);
            }
            return type;
        }

        private static Token.TokenType NFA_72(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(102);
            }
            return type;
        }

        private static Token.TokenType NFA_73(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(73);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.BLOCKTRIM)) {
                    type = Token.TokenType.BLOCKTRIM;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.BLOCKTRIM)) {
                type = Token.TokenType.BLOCKTRIM;
            }
            return type;
        }

        private static Token.TokenType NFA_74(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(298);
            }
            return type;
        }

        private static Token.TokenType NFA_75(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(40);
            }
            return type;
        }

        private static Token.TokenType NFA_76(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(287);
            }
            return type;
        }

        private static Token.TokenType NFA_77(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(457);
            }
            return type;
        }

        private static Token.TokenType NFA_78(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(78);
            } else if (ch == 47) {
                nextStates.set(216);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.FALLBACK)) {
                    type = Token.TokenType.FALLBACK;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.FALLBACK)) {
                type = Token.TokenType.FALLBACK;
            }
            return type;
        }

        private static Token.TokenType NFA_79(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(234);
            }
            return type;
        }

        private static Token.TokenType NFA_80(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(144);
            }
            return type;
        }

        private static Token.TokenType NFA_81(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(284);
            }
            return type;
        }

        private static Token.TokenType NFA_82(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(205);
            }
            return type;
        }

        private static Token.TokenType NFA_83(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(449);
            }
            return type;
        }

        private static Token.TokenType NFA_84(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(43);
            }
            return type;
        }

        private static Token.TokenType NFA_85(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.SIMPLE_NESTED)) {
                    type = Token.TokenType.SIMPLE_NESTED;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.SIMPLE_NESTED)) {
                type = Token.TokenType.SIMPLE_NESTED;
            }
            return type;
        }

        private static Token.TokenType NFA_86(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(429);
            }
            return type;
        }

        private static Token.TokenType NFA_87(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 123 && validTypes.contains((Object)Token.TokenType.OUTPUT_ESCAPE)) {
                type = Token.TokenType.OUTPUT_ESCAPE;
            }
            return type;
        }

        private static Token.TokenType NFA_88(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(441);
            }
            return type;
        }

        private static Token.TokenType NFA_89(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(38);
            }
            return type;
        }

        private static Token.TokenType NFA_90(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 47) {
                nextStates.set(208);
            }
            return type;
        }

        private static Token.TokenType NFA_91(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100) {
                nextStates.set(271);
            }
            return type;
        }

        private static Token.TokenType NFA_92(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(377);
            }
            return type;
        }

        private static Token.TokenType NFA_93(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 36 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_275, ch)) {
                nextStates.set(448);
            } else if (ch == 64) {
                nextStates.set(448);
            }
            return type;
        }

        private static Token.TokenType NFA_94(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(248);
            }
            return type;
        }

        private static Token.TokenType NFA_95(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(51);
            }
            return type;
        }

        private static Token.TokenType NFA_96(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(131);
            }
            return type;
        }

        private static Token.TokenType NFA_97(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(56);
            }
            return type;
        }

        private static Token.TokenType NFA_98(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(91);
            }
            return type;
        }

        private static Token.TokenType NFA_99(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(189);
            }
            return type;
        }

        private static Token.TokenType NFA_100(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(317);
            }
            return type;
        }

        private static Token.TokenType NFA_101(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(180);
            }
            return type;
        }

        private static Token.TokenType NFA_102(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 103) {
                nextStates.set(167);
            }
            return type;
        }

        private static Token.TokenType NFA_103(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(169);
            }
            return type;
        }

        private static Token.TokenType NFA_104(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(361);
            }
            return type;
        }

        private static Token.TokenType NFA_105(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(374);
            }
            return type;
        }

        private static Token.TokenType NFA_106(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(275);
            }
            return type;
        }

        private static Token.TokenType NFA_107(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(139);
            }
            return type;
        }

        private static Token.TokenType NFA_108(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(231);
            }
            return type;
        }

        private static Token.TokenType NFA_109(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(3);
            }
            return type;
        }

        private static Token.TokenType NFA_110(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.STOP)) {
                type = Token.TokenType.STOP;
            }
            return type;
        }

        private static Token.TokenType NFA_111(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(464);
            }
            return type;
        }

        private static Token.TokenType NFA_112(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.FOREACH)) {
                type = Token.TokenType.FOREACH;
            }
            return type;
        }

        private static Token.TokenType NFA_113(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(273);
            }
            return type;
        }

        private static Token.TokenType NFA_114(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(142);
            }
            return type;
        }

        private static Token.TokenType NFA_115(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 123 && validTypes.contains((Object)Token.TokenType.NUMERICAL_ESCAPE)) {
                type = Token.TokenType.NUMERICAL_ESCAPE;
            }
            return type;
        }

        private static Token.TokenType NFA_116(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(252);
            }
            return type;
        }

        private static Token.TokenType NFA_117(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(480);
            }
            return type;
        }

        private static Token.TokenType NFA_118(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(196);
            }
            return type;
        }

        private static Token.TokenType NFA_119(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(366);
            }
            return type;
        }

        private static Token.TokenType NFA_120(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.TRANSFORM)) {
                type = Token.TokenType.TRANSFORM;
            }
            return type;
        }

        private static Token.TokenType NFA_121(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(465);
            }
            return type;
        }

        private static Token.TokenType NFA_122(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(281);
            }
            return type;
        }

        private static Token.TokenType NFA_123(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.CALL)) {
                type = Token.TokenType.CALL;
            }
            return type;
        }

        private static Token.TokenType NFA_124(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(346);
            }
            return type;
        }

        private static Token.TokenType NFA_125(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(305);
            }
            return type;
        }

        private static Token.TokenType NFA_126(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 98) {
                nextStates.set(303);
            }
            return type;
        }

        private static Token.TokenType NFA_127(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(123);
            }
            return type;
        }

        private static Token.TokenType NFA_128(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(188);
            }
            return type;
        }

        private static Token.TokenType NFA_129(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 64 && validTypes.contains((Object)Token.TokenType.UNIFIED_CALL)) {
                type = Token.TokenType.UNIFIED_CALL;
            }
            return type;
        }

        private static Token.TokenType NFA_130(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(325);
            }
            return type;
        }

        private static Token.TokenType NFA_131(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(53);
            }
            return type;
        }

        private static Token.TokenType NFA_132(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(482);
            }
            return type;
        }

        private static Token.TokenType NFA_133(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(213);
            }
            return type;
        }

        private static Token.TokenType NFA_134(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(183);
            }
            return type;
        }

        private static Token.TokenType NFA_135(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(176);
            }
            return type;
        }

        private static Token.TokenType NFA_136(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(136);
            } else if (ch == 47) {
                nextStates.set(442);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.BREAK)) {
                    type = Token.TokenType.BREAK;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.BREAK)) {
                type = Token.TokenType.BREAK;
            }
            return type;
        }

        private static Token.TokenType NFA_137(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(483);
            }
            return type;
        }

        private static Token.TokenType NFA_138(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(187);
            }
            return type;
        }

        private static Token.TokenType NFA_139(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.SET)) {
                type = Token.TokenType.SET;
            }
            return type;
        }

        private static Token.TokenType NFA_140(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(214);
            }
            return type;
        }

        private static Token.TokenType NFA_141(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(228);
            }
            return type;
        }

        private static Token.TokenType NFA_142(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(209);
            }
            return type;
        }

        private static Token.TokenType NFA_143(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 107) {
                nextStates.set(78);
            }
            return type;
        }

        private static Token.TokenType NFA_144(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(395);
            }
            return type;
        }

        private static Token.TokenType NFA_145(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(211);
            }
            return type;
        }

        private static Token.TokenType NFA_146(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(215);
            }
            return type;
        }

        private static Token.TokenType NFA_147(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(359);
            }
            return type;
        }

        private static Token.TokenType NFA_148(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(306);
            }
            return type;
        }

        private static Token.TokenType NFA_149(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(21);
            }
            return type;
        }

        private static Token.TokenType NFA_150(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(41);
            }
            return type;
        }

        private static Token.TokenType NFA_151(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(243);
            }
            return type;
        }

        private static Token.TokenType NFA_152(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.IMPORT)) {
                type = Token.TokenType.IMPORT;
            }
            return type;
        }

        private static Token.TokenType NFA_153(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(153);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.DEFAUL)) {
                    type = Token.TokenType.DEFAUL;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.DEFAUL)) {
                type = Token.TokenType.DEFAUL;
            }
            return type;
        }

        private static Token.TokenType NFA_154(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(455);
            }
            return type;
        }

        private static Token.TokenType NFA_155(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(225);
            }
            return type;
        }

        private static Token.TokenType NFA_156(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.CASE)) {
                type = Token.TokenType.CASE;
            }
            return type;
        }

        private static Token.TokenType NFA_157(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(145);
            }
            return type;
        }

        private static Token.TokenType NFA_158(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(106);
            }
            return type;
        }

        private static Token.TokenType NFA_159(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.LIST)) {
                type = Token.TokenType.LIST;
            }
            return type;
        }

        private static Token.TokenType NFA_160(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(389);
            }
            return type;
        }

        private static Token.TokenType NFA_161(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(45);
            }
            return type;
        }

        private static Token.TokenType NFA_162(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(148);
            }
            return type;
        }

        private static Token.TokenType NFA_163(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.RECURSE)) {
                type = Token.TokenType.RECURSE;
            }
            return type;
        }

        private static Token.TokenType NFA_164(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(456);
            }
            return type;
        }

        private static Token.TokenType NFA_165(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(435);
            }
            return type;
        }

        private static Token.TokenType NFA_166(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(429);
            }
            return type;
        }

        private static Token.TokenType NFA_167(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(481);
            }
            return type;
        }

        private static Token.TokenType NFA_168(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 98) {
                nextStates.set(411);
            }
            return type;
        }

        private static Token.TokenType NFA_169(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(432);
            }
            return type;
        }

        private static Token.TokenType NFA_170(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(6);
            }
            return type;
        }

        private static Token.TokenType NFA_171(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(335);
            }
            return type;
        }

        private static Token.TokenType NFA_172(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(172);
                if (validTypes.contains((Object)Token.TokenType.WHITESPACE)) {
                    type = Token.TokenType.WHITESPACE;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_173(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(362);
            }
            return type;
        }

        private static Token.TokenType NFA_174(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(99);
            }
            return type;
        }

        private static Token.TokenType NFA_175(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(71);
            }
            return type;
        }

        private static Token.TokenType NFA_176(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(119);
            }
            return type;
        }

        private static Token.TokenType NFA_177(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(127);
            }
            return type;
        }

        private static Token.TokenType NFA_178(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(178);
            } else if (ch == 47) {
                nextStates.set(462);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.SIMPLE_RETURN)) {
                    type = Token.TokenType.SIMPLE_RETURN;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.SIMPLE_RETURN)) {
                type = Token.TokenType.SIMPLE_RETURN;
            }
            return type;
        }

        private static Token.TokenType NFA_179(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.ELSE)) {
                    type = Token.TokenType.ELSE;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.ELSE)) {
                type = Token.TokenType.ELSE;
            }
            return type;
        }

        private static Token.TokenType NFA_180(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(327);
            }
            return type;
        }

        private static Token.TokenType NFA_181(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(403);
            }
            return type;
        }

        private static Token.TokenType NFA_182(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(400);
            }
            return type;
        }

        private static Token.TokenType NFA_183(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(183);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.COMMENT)) {
                    type = Token.TokenType.COMMENT;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.COMMENT)) {
                type = Token.TokenType.COMMENT;
            }
            return type;
        }

        private static Token.TokenType NFA_184(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(132);
            }
            return type;
        }

        private static Token.TokenType NFA_185(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(201);
            }
            return type;
        }

        private static Token.TokenType NFA_186(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(186);
            } else if (ch == 47) {
                nextStates.set(393);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.BLOCKTRIML)) {
                    type = Token.TokenType.BLOCKTRIML;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.BLOCKTRIML)) {
                type = Token.TokenType.BLOCKTRIML;
            }
            return type;
        }

        private static Token.TokenType NFA_187(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100) {
                nextStates.set(463);
            }
            return type;
        }

        private static Token.TokenType NFA_188(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(188);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType._RECOVER)) {
                    type = Token.TokenType._RECOVER;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType._RECOVER)) {
                type = Token.TokenType._RECOVER;
            }
            return type;
        }

        private static Token.TokenType NFA_189(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(120);
            }
            return type;
        }

        private static Token.TokenType NFA_190(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(46);
            }
            return type;
        }

        private static Token.TokenType NFA_191(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(446);
            }
            return type;
        }

        private static Token.TokenType NFA_192(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.RTRIM)) {
                    type = Token.TokenType.RTRIM;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.RTRIM)) {
                type = Token.TokenType.RTRIM;
            }
            return type;
        }

        private static Token.TokenType NFA_193(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(126);
            }
            return type;
        }

        private static Token.TokenType NFA_194(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(299);
            }
            return type;
        }

        private static Token.TokenType NFA_195(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(168);
            }
            return type;
        }

        private static Token.TokenType NFA_196(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.VISIT)) {
                type = Token.TokenType.VISIT;
            }
            return type;
        }

        private static Token.TokenType NFA_197(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(156);
            }
            return type;
        }

        private static Token.TokenType NFA_198(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(253);
            }
            return type;
        }

        private static Token.TokenType NFA_199(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(401);
            }
            return type;
        }

        private static Token.TokenType NFA_200(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(155);
            }
            return type;
        }

        private static Token.TokenType NFA_201(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(473);
            }
            return type;
        }

        private static Token.TokenType NFA_202(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(34);
            }
            return type;
        }

        private static Token.TokenType NFA_203(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 107) {
                nextStates.set(136);
            }
            return type;
        }

        private static Token.TokenType NFA_204(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(399);
            }
            return type;
        }

        private static Token.TokenType NFA_205(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 103) {
                nextStates.set(147);
            }
            return type;
        }

        private static Token.TokenType NFA_206(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(253);
            }
            return type;
        }

        private static Token.TokenType NFA_207(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(88);
            }
            return type;
        }

        private static Token.TokenType NFA_208(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(317);
            }
            return type;
        }

        private static Token.TokenType NFA_209(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(418);
            }
            return type;
        }

        private static Token.TokenType NFA_210(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(446);
            }
            return type;
        }

        private static Token.TokenType NFA_211(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(391);
            }
            return type;
        }

        private static Token.TokenType NFA_212(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(212);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.BLOCKTRIMR)) {
                    type = Token.TokenType.BLOCKTRIMR;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.BLOCKTRIMR)) {
                type = Token.TokenType.BLOCKTRIMR;
            }
            return type;
        }

        private static Token.TokenType NFA_213(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(259);
            }
            return type;
        }

        private static Token.TokenType NFA_214(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(415);
            }
            return type;
        }

        private static Token.TokenType NFA_215(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(437);
            }
            return type;
        }

        private static Token.TokenType NFA_216(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.FALLBACK)) {
                    type = Token.TokenType.FALLBACK;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.FALLBACK)) {
                type = Token.TokenType.FALLBACK;
            }
            return type;
        }

        private static Token.TokenType NFA_217(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 104) {
                nextStates.set(112);
            }
            return type;
        }

        private static Token.TokenType NFA_218(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(33);
            }
            return type;
        }

        private static Token.TokenType NFA_219(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.LTRIM)) {
                    type = Token.TokenType.LTRIM;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.LTRIM)) {
                type = Token.TokenType.LTRIM;
            }
            return type;
        }

        private static Token.TokenType NFA_220(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(250);
            }
            return type;
        }

        private static Token.TokenType NFA_221(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(467);
            }
            return type;
        }

        private static Token.TokenType NFA_222(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(48);
            }
            return type;
        }

        private static Token.TokenType NFA_223(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45 && validTypes.contains((Object)Token.TokenType.TERSE_COMMENT)) {
                type = Token.TokenType.TERSE_COMMENT;
            }
            return type;
        }

        private static Token.TokenType NFA_224(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(98);
            }
            return type;
        }

        private static Token.TokenType NFA_225(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(160);
            }
            return type;
        }

        private static Token.TokenType NFA_226(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(470);
            }
            return type;
        }

        private static Token.TokenType NFA_227(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(332);
            }
            return type;
        }

        private static Token.TokenType NFA_228(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(396);
            }
            return type;
        }

        private static Token.TokenType NFA_229(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(74);
            }
            return type;
        }

        private static Token.TokenType NFA_230(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(247);
            }
            return type;
        }

        private static Token.TokenType NFA_231(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(301);
            }
            return type;
        }

        private static Token.TokenType NFA_232(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(232);
            } else if (ch == 47) {
                nextStates.set(85);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.SIMPLE_NESTED)) {
                    type = Token.TokenType.SIMPLE_NESTED;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.SIMPLE_NESTED)) {
                type = Token.TokenType.SIMPLE_NESTED;
            }
            return type;
        }

        private static Token.TokenType NFA_233(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(233);
            } else if (ch == 47) {
                nextStates.set(240);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.NOTRIM)) {
                    type = Token.TokenType.NOTRIM;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.NOTRIM)) {
                type = Token.TokenType.NOTRIM;
            }
            return type;
        }

        private static Token.TokenType NFA_234(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(402);
            }
            return type;
        }

        private static Token.TokenType NFA_235(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(230);
            }
            return type;
        }

        private static Token.TokenType NFA_236(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(416);
            }
            return type;
        }

        private static Token.TokenType NFA_237(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.VAR)) {
                type = Token.TokenType.VAR;
            }
            return type;
        }

        private static Token.TokenType NFA_238(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType._INCLUDE)) {
                type = Token.TokenType._INCLUDE;
            }
            return type;
        }

        private static Token.TokenType NFA_239(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(138);
            }
            return type;
        }

        private static Token.TokenType NFA_240(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.NOTRIM)) {
                    type = Token.TokenType.NOTRIM;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.NOTRIM)) {
                type = Token.TokenType.NOTRIM;
            }
            return type;
        }

        private static Token.TokenType NFA_241(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(328);
            }
            return type;
        }

        private static Token.TokenType NFA_242(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(81);
            }
            return type;
        }

        private static Token.TokenType NFA_243(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(318);
            }
            return type;
        }

        private static Token.TokenType NFA_244(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.SIMPLE_RECURSE)) {
                    type = Token.TokenType.SIMPLE_RECURSE;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.SIMPLE_RECURSE)) {
                type = Token.TokenType.SIMPLE_RECURSE;
            }
            return type;
        }

        private static Token.TokenType NFA_245(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(324);
            }
            return type;
        }

        private static Token.TokenType NFA_246(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(416);
            }
            return type;
        }

        private static Token.TokenType NFA_247(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(430);
            }
            return type;
        }

        private static Token.TokenType NFA_248(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(450);
            }
            return type;
        }

        private static Token.TokenType NFA_249(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(37);
            }
            return type;
        }

        private static Token.TokenType NFA_250(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(224);
            }
            return type;
        }

        private static Token.TokenType NFA_251(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(43);
            }
            return type;
        }

        private static Token.TokenType NFA_252(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(118);
            }
            return type;
        }

        private static Token.TokenType NFA_253(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(261);
            }
            return type;
        }

        private static Token.TokenType NFA_254(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(97);
            }
            return type;
        }

        private static Token.TokenType NFA_255(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100) {
                nextStates.set(232);
            }
            return type;
        }

        private static Token.TokenType NFA_256(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(186);
            }
            return type;
        }

        private static Token.TokenType NFA_257(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(7);
            }
            return type;
        }

        private static Token.TokenType NFA_258(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(130);
            }
            return type;
        }

        private static Token.TokenType NFA_259(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 119) {
                nextStates.set(385);
            }
            return type;
        }

        private static Token.TokenType NFA_260(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(60);
            }
            return type;
        }

        private static Token.TokenType NFA_261(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(278);
            }
            return type;
        }

        private static Token.TokenType NFA_262(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(222);
            }
            return type;
        }

        private static Token.TokenType NFA_263(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(124);
            }
            return type;
        }

        private static Token.TokenType NFA_264(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(350);
            }
            return type;
        }

        private static Token.TokenType NFA_265(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(145);
            }
            return type;
        }

        private static Token.TokenType NFA_266(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(128);
            }
            return type;
        }

        private static Token.TokenType NFA_267(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(239);
            }
            return type;
        }

        private static Token.TokenType NFA_268(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 103) {
                nextStates.set(39);
            }
            return type;
        }

        private static Token.TokenType NFA_269(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(96);
            }
            return type;
        }

        private static Token.TokenType NFA_270(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.LOCALASSIGN)) {
                type = Token.TokenType.LOCALASSIGN;
            }
            return type;
        }

        private static Token.TokenType NFA_271(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.NESTED)) {
                type = Token.TokenType.NESTED;
            }
            return type;
        }

        private static Token.TokenType NFA_272(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(165);
            }
            return type;
        }

        private static Token.TokenType NFA_273(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(468);
            }
            return type;
        }

        private static Token.TokenType NFA_274(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(455);
            }
            return type;
        }

        private static Token.TokenType NFA_275(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(386);
            }
            return type;
        }

        private static Token.TokenType NFA_276(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(37);
            }
            return type;
        }

        private static Token.TokenType NFA_277(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(445);
            }
            return type;
        }

        private static Token.TokenType NFA_278(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(141);
            }
            return type;
        }

        private static Token.TokenType NFA_279(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(378);
            }
            return type;
        }

        private static Token.TokenType NFA_280(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(64);
            }
            return type;
        }

        private static Token.TokenType NFA_281(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(159);
            }
            return type;
        }

        private static Token.TokenType NFA_282(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(135);
            }
            return type;
        }

        private static Token.TokenType NFA_283(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(420);
            }
            return type;
        }

        private static Token.TokenType NFA_284(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(284);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.BLOCKNOTRIM)) {
                    type = Token.TokenType.BLOCKNOTRIM;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.BLOCKNOTRIM)) {
                type = Token.TokenType.BLOCKNOTRIM;
            }
            return type;
        }

        private static Token.TokenType NFA_285(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.ESCAPE)) {
                type = Token.TokenType.ESCAPE;
            }
            return type;
        }

        private static Token.TokenType NFA_286(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(105);
            }
            return type;
        }

        private static Token.TokenType NFA_287(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(392);
            }
            return type;
        }

        private static Token.TokenType NFA_288(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 64 && validTypes.contains((Object)Token.TokenType.UNIFIED_CALL)) {
                type = Token.TokenType.UNIFIED_CALL;
            }
            return type;
        }

        private static Token.TokenType NFA_289(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(334);
            }
            return type;
        }

        private static Token.TokenType NFA_290(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(182);
            }
            return type;
        }

        private static Token.TokenType NFA_291(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(420);
            }
            return type;
        }

        private static Token.TokenType NFA_292(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(286);
            }
            return type;
        }

        private static Token.TokenType NFA_293(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(333);
            }
            return type;
        }

        private static Token.TokenType NFA_294(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(148);
            }
            return type;
        }

        private static Token.TokenType NFA_295(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(286);
            }
            return type;
        }

        private static Token.TokenType NFA_296(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(26);
            }
            return type;
        }

        private static Token.TokenType NFA_297(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(79);
            }
            return type;
        }

        private static Token.TokenType NFA_298(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(390);
            }
            return type;
        }

        private static Token.TokenType NFA_299(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(436);
            }
            return type;
        }

        private static Token.TokenType NFA_300(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.HALT)) {
                    type = Token.TokenType.HALT;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.HALT)) {
                type = Token.TokenType.HALT;
            }
            return type;
        }

        private static Token.TokenType NFA_301(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(301);
            } else if (ch == 47) {
                nextStates.set(351);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.TRIM)) {
                    type = Token.TokenType.TRIM;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.TRIM)) {
                type = Token.TokenType.TRIM;
            }
            return type;
        }

        private static Token.TokenType NFA_302(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(302);
            } else if (ch == 47) {
                nextStates.set(219);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.LTRIM)) {
                    type = Token.TokenType.LTRIM;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.LTRIM)) {
                type = Token.TokenType.LTRIM;
            }
            return type;
        }

        private static Token.TokenType NFA_303(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(42);
            }
            return type;
        }

        private static Token.TokenType NFA_304(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(426);
            }
            return type;
        }

        private static Token.TokenType NFA_305(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 92 || ch >= 94) {
                nextStates.set(305);
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.CLOSE_DIRECTIVE_BLOCK)) {
                type = Token.TokenType.CLOSE_DIRECTIVE_BLOCK;
            }
            return type;
        }

        private static Token.TokenType NFA_306(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(279);
            }
            return type;
        }

        private static Token.TokenType NFA_307(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(412);
            }
            return type;
        }

        private static Token.TokenType NFA_308(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(62);
            }
            return type;
        }

        private static Token.TokenType NFA_309(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(364);
            }
            return type;
        }

        private static Token.TokenType NFA_310(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 8 || ch >= 14 && ch <= 27 || ch == 36 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 127 && ch <= 159 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_193, ch)) {
                nextStates.set(310);
            } else if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(372);
            } else if (ch == 46) {
                nextStates.set(93);
            } else if (ch == 64) {
                nextStates.set(310);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.UNIFIED_CALL_END)) {
                    type = Token.TokenType.UNIFIED_CALL_END;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.UNIFIED_CALL_END)) {
                type = Token.TokenType.UNIFIED_CALL_END;
            }
            return type;
        }

        private static Token.TokenType NFA_311(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(449);
            }
            return type;
        }

        private static Token.TokenType NFA_312(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(80);
            }
            return type;
        }

        private static Token.TokenType NFA_313(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 98) {
                nextStates.set(421);
            }
            return type;
        }

        private static Token.TokenType NFA_314(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(178);
            }
            return type;
        }

        private static Token.TokenType NFA_315(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(398);
            }
            return type;
        }

        private static Token.TokenType NFA_316(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(89);
            }
            return type;
        }

        private static Token.TokenType NFA_317(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(317);
                if (validTypes.contains((Object)Token.TokenType.UNKNOWN_DIRECTIVE)) {
                    type = Token.TokenType.UNKNOWN_DIRECTIVE;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_318(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(318);
            } else if (ch == 47) {
                nextStates.set(244);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.SIMPLE_RECURSE)) {
                    type = Token.TokenType.SIMPLE_RECURSE;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.SIMPLE_RECURSE)) {
                type = Token.TokenType.SIMPLE_RECURSE;
            }
            return type;
        }

        private static Token.TokenType NFA_319(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(368);
            }
            return type;
        }

        private static Token.TokenType NFA_320(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(76);
            }
            return type;
        }

        private static Token.TokenType NFA_321(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(406);
            }
            return type;
        }

        private static Token.TokenType NFA_322(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 47) {
                nextStates.set(347);
            }
            return type;
        }

        private static Token.TokenType NFA_323(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(59);
            }
            return type;
        }

        private static Token.TokenType NFA_324(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(134);
            }
            return type;
        }

        private static Token.TokenType NFA_325(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(424);
            }
            return type;
        }

        private static Token.TokenType NFA_326(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 47) {
                nextStates.set(125);
            }
            return type;
        }

        private static Token.TokenType NFA_327(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(260);
            }
            return type;
        }

        private static Token.TokenType NFA_328(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(174);
            }
            return type;
        }

        private static Token.TokenType NFA_329(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(222);
            }
            return type;
        }

        private static Token.TokenType NFA_330(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(314);
            }
            return type;
        }

        private static Token.TokenType NFA_331(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(459);
            }
            return type;
        }

        private static Token.TokenType NFA_332(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(72);
            }
            return type;
        }

        private static Token.TokenType NFA_333(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(207);
            }
            return type;
        }

        private static Token.TokenType NFA_334(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(170);
            }
            return type;
        }

        private static Token.TokenType NFA_335(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(335);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.NOPARSE)) {
                    type = Token.TokenType.NOPARSE;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.NOPARSE)) {
                type = Token.TokenType.NOPARSE;
            }
            return type;
        }

        private static Token.TokenType NFA_336(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(73);
            }
            return type;
        }

        private static Token.TokenType NFA_337(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(319);
            }
            return type;
        }

        private static Token.TokenType NFA_338(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(49);
            }
            return type;
        }

        private static Token.TokenType NFA_339(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 64) {
                nextStates.set(353);
            }
            return type;
        }

        private static Token.TokenType NFA_340(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(425);
            }
            return type;
        }

        private static Token.TokenType NFA_341(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(268);
            }
            return type;
        }

        private static Token.TokenType NFA_342(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(51);
            }
            return type;
        }

        private static Token.TokenType NFA_343(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(407);
            }
            return type;
        }

        private static Token.TokenType NFA_344(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(140);
            }
            return type;
        }

        private static Token.TokenType NFA_345(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(354);
            }
            return type;
        }

        private static Token.TokenType NFA_346(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(256);
            }
            return type;
        }

        private static Token.TokenType NFA_347(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(317);
            }
            return type;
        }

        private static Token.TokenType NFA_348(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 61 || ch >= 63) {
                nextStates.set(348);
            } else if (ch == 62 && validTypes.contains((Object)Token.TokenType.CLOSE_DIRECTIVE_BLOCK)) {
                type = Token.TokenType.CLOSE_DIRECTIVE_BLOCK;
            }
            return type;
        }

        private static Token.TokenType NFA_349(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(158);
            }
            return type;
        }

        private static Token.TokenType NFA_350(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(12);
            }
            return type;
        }

        private static Token.TokenType NFA_351(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.TRIM)) {
                    type = Token.TokenType.TRIM;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.TRIM)) {
                type = Token.TokenType.TRIM;
            }
            return type;
        }

        private static Token.TokenType NFA_352(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.MACRO)) {
                type = Token.TokenType.MACRO;
            }
            return type;
        }

        private static Token.TokenType NFA_353(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(372);
            } else if (ch == 36 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_399, ch)) {
                nextStates.set(310);
            } else if (ch == 64) {
                nextStates.set(310);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.UNIFIED_CALL_END)) {
                    type = Token.TokenType.UNIFIED_CALL_END;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.UNIFIED_CALL_END)) {
                type = Token.TokenType.UNIFIED_CALL_END;
            }
            return type;
        }

        private static Token.TokenType NFA_354(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(242);
            }
            return type;
        }

        private static Token.TokenType NFA_355(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(459);
            }
            return type;
        }

        private static Token.TokenType NFA_356(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(31);
            }
            return type;
        }

        private static Token.TokenType NFA_357(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 47) {
                nextStates.set(339);
            }
            return type;
        }

        private static Token.TokenType NFA_358(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(231);
            }
            return type;
        }

        private static Token.TokenType NFA_359(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(19);
            }
            return type;
        }

        private static Token.TokenType NFA_360(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(399);
            }
            return type;
        }

        private static Token.TokenType NFA_361(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(361);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.COMPRESS)) {
                    type = Token.TokenType.COMPRESS;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.COMPRESS)) {
                type = Token.TokenType.COMPRESS;
            }
            return type;
        }

        private static Token.TokenType NFA_362(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(28);
            }
            return type;
        }

        private static Token.TokenType NFA_363(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(104);
            }
            return type;
        }

        private static Token.TokenType NFA_364(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(438);
            }
            return type;
        }

        private static Token.TokenType NFA_365(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(365);
            } else if (ch == 47) {
                nextStates.set(44);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.FLUSH)) {
                    type = Token.TokenType.FLUSH;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.FLUSH)) {
                type = Token.TokenType.FLUSH;
            }
            return type;
        }

        private static Token.TokenType NFA_366(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(184);
            }
            return type;
        }

        private static Token.TokenType NFA_367(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(304);
            }
            return type;
        }

        private static Token.TokenType NFA_368(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.GLOBALASSIGN)) {
                type = Token.TokenType.GLOBALASSIGN;
            }
            return type;
        }

        private static Token.TokenType NFA_369(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(451);
            }
            return type;
        }

        private static Token.TokenType NFA_370(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(427);
            }
            return type;
        }

        private static Token.TokenType NFA_371(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(215);
            }
            return type;
        }

        private static Token.TokenType NFA_372(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(372);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.UNIFIED_CALL_END)) {
                    type = Token.TokenType.UNIFIED_CALL_END;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.UNIFIED_CALL_END)) {
                type = Token.TokenType.UNIFIED_CALL_END;
            }
            return type;
        }

        private static Token.TokenType NFA_373(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(373);
            } else if (ch == 47) {
                nextStates.set(192);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.RTRIM)) {
                    type = Token.TokenType.RTRIM;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.RTRIM)) {
                type = Token.TokenType.RTRIM;
            }
            return type;
        }

        private static Token.TokenType NFA_374(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(439);
            }
            return type;
        }

        private static Token.TokenType NFA_375(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(153);
            }
            return type;
        }

        private static Token.TokenType NFA_376(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.EMBED)) {
                type = Token.TokenType.EMBED;
            }
            return type;
        }

        private static Token.TokenType NFA_377(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(289);
            }
            return type;
        }

        private static Token.TokenType NFA_378(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(313);
            }
            return type;
        }

        private static Token.TokenType NFA_379(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(380);
            }
            return type;
        }

        private static Token.TokenType NFA_380(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(55);
            }
            return type;
        }

        private static Token.TokenType NFA_381(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(269);
            }
            return type;
        }

        private static Token.TokenType NFA_382(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(241);
            }
            return type;
        }

        private static Token.TokenType NFA_383(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(302);
            }
            return type;
        }

        private static Token.TokenType NFA_384(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(425);
            }
            return type;
        }

        private static Token.TokenType NFA_385(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(190);
            }
            return type;
        }

        private static Token.TokenType NFA_386(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(423);
            }
            return type;
        }

        private static Token.TokenType NFA_387(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(116);
            }
            return type;
        }

        private static Token.TokenType NFA_388(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(165);
            }
            return type;
        }

        private static Token.TokenType NFA_389(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(375);
            }
            return type;
        }

        private static Token.TokenType NFA_390(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.FUNCTION)) {
                type = Token.TokenType.FUNCTION;
            }
            return type;
        }

        private static Token.TokenType NFA_391(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.IF)) {
                type = Token.TokenType.IF;
            }
            return type;
        }

        private static Token.TokenType NFA_392(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(382);
            }
            return type;
        }

        private static Token.TokenType NFA_393(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.BLOCKTRIML)) {
                    type = Token.TokenType.BLOCKTRIML;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.BLOCKTRIML)) {
                type = Token.TokenType.BLOCKTRIML;
            }
            return type;
        }

        private static Token.TokenType NFA_394(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(89);
            }
            return type;
        }

        private static Token.TokenType NFA_395(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.ELSE_IF)) {
                type = Token.TokenType.ELSE_IF;
            }
            return type;
        }

        private static Token.TokenType NFA_396(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.PARAM)) {
                type = Token.TokenType.PARAM;
            }
            return type;
        }

        private static Token.TokenType NFA_397(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(177);
            }
            return type;
        }

        private static Token.TokenType NFA_398(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(296);
            }
            return type;
        }

        private static Token.TokenType NFA_399(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(323);
            }
            return type;
        }

        private static Token.TokenType NFA_400(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(77);
            }
            return type;
        }

        private static Token.TokenType NFA_401(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(263);
            }
            return type;
        }

        private static Token.TokenType NFA_402(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(367);
            }
            return type;
        }

        private static Token.TokenType NFA_403(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(68);
            }
            return type;
        }

        private static Token.TokenType NFA_404(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(205);
            }
            return type;
        }

        private static Token.TokenType NFA_405(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(237);
            }
            return type;
        }

        private static Token.TokenType NFA_406(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(227);
            }
            return type;
        }

        private static Token.TokenType NFA_407(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(151);
            }
            return type;
        }

        private static Token.TokenType NFA_408(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(465);
            }
            return type;
        }

        private static Token.TokenType NFA_409(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(33);
            }
            return type;
        }

        private static Token.TokenType NFA_410(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(117);
            }
            return type;
        }

        private static Token.TokenType NFA_411(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(164);
            }
            return type;
        }

        private static Token.TokenType NFA_412(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(412);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.NOESCAPE)) {
                    type = Token.TokenType.NOESCAPE;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.NOESCAPE)) {
                type = Token.TokenType.NOESCAPE;
            }
            return type;
        }

        private static Token.TokenType NFA_413(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(285);
            }
            return type;
        }

        private static Token.TokenType NFA_414(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(414);
            } else if (ch == 47) {
                nextStates.set(179);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.ELSE)) {
                    type = Token.TokenType.ELSE;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.ELSE)) {
                type = Token.TokenType.ELSE;
            }
            return type;
        }

        private static Token.TokenType NFA_415(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(197);
            }
            return type;
        }

        private static Token.TokenType NFA_416(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(458);
            }
            return type;
        }

        private static Token.TokenType NFA_417(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(202);
            }
            return type;
        }

        private static Token.TokenType NFA_418(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.FTL_HEADER)) {
                type = Token.TokenType.FTL_HEADER;
            }
            return type;
        }

        private static Token.TokenType NFA_419(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(419);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType._ATTEMPT)) {
                    type = Token.TokenType._ATTEMPT;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType._ATTEMPT)) {
                type = Token.TokenType._ATTEMPT;
            }
            return type;
        }

        private static Token.TokenType NFA_420(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(94);
            }
            return type;
        }

        private static Token.TokenType NFA_421(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(32);
            }
            return type;
        }

        private static Token.TokenType NFA_422(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(158);
            }
            return type;
        }

        private static Token.TokenType NFA_423(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(270);
            }
            return type;
        }

        private static Token.TokenType NFA_424(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(17);
            }
            return type;
        }

        private static Token.TokenType NFA_425(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(383);
            }
            return type;
        }

        private static Token.TokenType NFA_426(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(419);
            }
            return type;
        }

        private static Token.TokenType NFA_427(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.RETURN)) {
                type = Token.TokenType.RETURN;
            }
            return type;
        }

        private static Token.TokenType NFA_428(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(434);
            }
            return type;
        }

        private static Token.TokenType NFA_429(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 118) {
                nextStates.set(387);
            }
            return type;
        }

        private static Token.TokenType NFA_430(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(430);
            } else if (ch == 47) {
                nextStates.set(300);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.HALT)) {
                    type = Token.TokenType.HALT;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.HALT)) {
                type = Token.TokenType.HALT;
            }
            return type;
        }

        private static Token.TokenType NFA_431(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(447);
            }
            return type;
        }

        private static Token.TokenType NFA_432(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(352);
            }
            return type;
        }

        private static Token.TokenType NFA_433(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(149);
            }
            return type;
        }

        private static Token.TokenType NFA_434(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(20);
            }
            return type;
        }

        private static Token.TokenType NFA_435(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(277);
            }
            return type;
        }

        private static Token.TokenType NFA_436(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(25);
            }
            return type;
        }

        private static Token.TokenType NFA_437(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(308);
            }
            return type;
        }

        private static Token.TokenType NFA_438(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(476);
            }
            return type;
        }

        private static Token.TokenType NFA_439(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(369);
            }
            return type;
        }

        private static Token.TokenType NFA_440(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(122);
            }
            return type;
        }

        private static Token.TokenType NFA_441(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(152);
            }
            return type;
        }

        private static Token.TokenType NFA_442(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.BREAK)) {
                    type = Token.TokenType.BREAK;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.BREAK)) {
                type = Token.TokenType.BREAK;
            }
            return type;
        }

        private static Token.TokenType NFA_443(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(137);
            }
            return type;
        }

        private static Token.TokenType NFA_444(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(107);
            }
            return type;
        }

        private static Token.TokenType NFA_445(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(57);
            }
            return type;
        }

        private static Token.TokenType NFA_446(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(54);
            }
            return type;
        }

        private static Token.TokenType NFA_447(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(440);
            }
            return type;
        }

        private static Token.TokenType NFA_448(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 8 || ch >= 14 && ch <= 27 || ch == 36 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 127 && ch <= 159 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_508, ch)) {
                nextStates.set(448);
            } else if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(372);
            } else if (ch == 46) {
                nextStates.set(93);
            } else if (ch == 64) {
                nextStates.set(448);
            } else if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.UNIFIED_CALL_END)) {
                    type = Token.TokenType.UNIFIED_CALL_END;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.UNIFIED_CALL_END)) {
                type = Token.TokenType.UNIFIED_CALL_END;
            }
            return type;
        }

        private static Token.TokenType NFA_449(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(185);
            }
            return type;
        }

        private static Token.TokenType NFA_450(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(345);
            }
            return type;
        }

        private static Token.TokenType NFA_451(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(171);
            }
            return type;
        }

        private static Token.TokenType NFA_452(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(140);
            }
            return type;
        }

        private static Token.TokenType NFA_453(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(23);
            }
            return type;
        }

        private static Token.TokenType NFA_454(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(377);
            }
            return type;
        }

        private static Token.TokenType NFA_455(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(235);
            }
            return type;
        }

        private static Token.TokenType NFA_456(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(203);
            }
            return type;
        }

        private static Token.TokenType NFA_457(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 109) {
                nextStates.set(245);
            }
            return type;
        }

        private static Token.TokenType NFA_458(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(264);
            }
            return type;
        }

        private static Token.TokenType NFA_459(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(220);
            }
            return type;
        }

        private static Token.TokenType NFA_460(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(317);
            }
            return type;
        }

        private static Token.TokenType NFA_461(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(135);
            }
            return type;
        }

        private static Token.TokenType NFA_462(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                if (validTypes.contains((Object)Token.TokenType.SIMPLE_RETURN)) {
                    type = Token.TokenType.SIMPLE_RETURN;
                }
            } else if (ch == 93 && validTypes.contains((Object)Token.TokenType.SIMPLE_RETURN)) {
                type = Token.TokenType.SIMPLE_RETURN;
            }
            return type;
        }

        private static Token.TokenType NFA_463(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(238);
            }
            return type;
        }

        private static Token.TokenType NFA_464(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(363);
            }
            return type;
        }

        private static Token.TokenType NFA_465(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(293);
            }
            return type;
        }

        private static Token.TokenType NFA_466(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(64);
            }
            return type;
        }

        private static Token.TokenType NFA_467(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 99) {
                nextStates.set(217);
            }
            return type;
        }

        private static Token.TokenType NFA_468(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(233);
            }
            return type;
        }

        private static Token.TokenType NFA_469(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(341);
            }
            return type;
        }

        private static Token.TokenType NFA_470(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(2);
            }
            return type;
        }

        private static Token.TokenType NFA_471(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(76);
            }
            return type;
        }

        private static Token.TokenType NFA_472(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 112) {
                nextStates.set(111);
            }
            return type;
        }

        private static Token.TokenType NFA_473(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(309);
            }
            return type;
        }

        private static Token.TokenType NFA_474(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(114);
            }
            return type;
        }

        private static Token.TokenType NFA_475(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(406);
            }
            return type;
        }

        private static Token.TokenType NFA_476(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(212);
            }
            return type;
        }

        private static Token.TokenType NFA_477(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(221);
            }
            return type;
        }

        private static Token.TokenType NFA_478(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(447);
            }
            return type;
        }

        private static Token.TokenType NFA_479(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 8 || ch == 11 || ch == 12 || ch >= 14 && ch <= 31 || ch == 33 || ch == 34 || ch >= 37 && ch <= 59 || ch >= 61 && ch <= 90 || ch >= 92 && ch <= 122 || ch >= 124 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_146, ch)) {
                nextStates.set(479);
                if (validTypes.contains((Object)Token.TokenType.PRINTABLE_CHARS)) {
                    type = Token.TokenType.PRINTABLE_CHARS;
                }
            }
            return type;
        }

        private static Token.TokenType NFA_480(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(9);
            }
            return type;
        }

        private static Token.TokenType NFA_481(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if ((ch == 9 || ch == 10 || ch == 13 || ch == 32) && validTypes.contains((Object)Token.TokenType.ASSIGN)) {
                type = Token.TokenType.ASSIGN;
            }
            return type;
        }

        private static Token.TokenType NFA_482(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(163);
            }
            return type;
        }

        private static Token.TokenType NFA_483(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(101);
            }
            return type;
        }

        private static Token.TokenType NFA_484(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 35) {
                nextStates.set(254);
            }
            return type;
        }

        private static int[] NFA_MOVES_146_init() {
            return new int[]{0, 8, 11, 12, 14, 31, 33, 34, 37, 59, 61, 90, 92, 122, 124, 0x10FFFF};
        }

        private static int[] NFA_MOVES_193_init() {
            return new int[]{0, 8, 14, 27, 36, 36, 48, 57, 65, 90, 95, 95, 97, 122, 127, 159, 162, 165, 170, 170, 173, 173, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 768, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1155, 1159, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1488, 1514, 1519, 1522, 1536, 1541, 1547, 1547, 1552, 1562, 1564, 1564, 1568, 1641, 1646, 1747, 1749, 1757, 1759, 1768, 1770, 1788, 1791, 1791, 1807, 1866, 1869, 1969, 1984, 2037, 2042, 2042, 2045, 2093, 2112, 2139, 2144, 2154, 2160, 2183, 2185, 2190, 2192, 2193, 2200, 2403, 2406, 2415, 2417, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2500, 2503, 2504, 2507, 2510, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2547, 2555, 2556, 2558, 2558, 2561, 2563, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2649, 2652, 2654, 2654, 2662, 2677, 2689, 2691, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2787, 2790, 2799, 2801, 2801, 2809, 2815, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2876, 2884, 2887, 2888, 2891, 2893, 2901, 2903, 2908, 2909, 2911, 2915, 2918, 2927, 2929, 2929, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3024, 3024, 3031, 3031, 3046, 3055, 3065, 3065, 3072, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3132, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3160, 3162, 3165, 3165, 3168, 3171, 3174, 3183, 3200, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3260, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3293, 3294, 3296, 3299, 3302, 3311, 3313, 3314, 3328, 3340, 3342, 3344, 3346, 3396, 3398, 3400, 3402, 3406, 3412, 3415, 3423, 3427, 3430, 3439, 3450, 3455, 3457, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3558, 3567, 3570, 3571, 3585, 3642, 3647, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3807, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3948, 3953, 3972, 3974, 3991, 3993, 4028, 4038, 4038, 4096, 4169, 4176, 4253, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4957, 4959, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5909, 5919, 5940, 5952, 5971, 5984, 5996, 5998, 6000, 6002, 6003, 6016, 6099, 6103, 6103, 6107, 6109, 6112, 6121, 6155, 6169, 6176, 6264, 6272, 6314, 6320, 6389, 6400, 6430, 6432, 6443, 6448, 6459, 6470, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6608, 6617, 6656, 6683, 6688, 6750, 6752, 6780, 6783, 6793, 6800, 6809, 6823, 6823, 6832, 6845, 6847, 6862, 6912, 6988, 6992, 7001, 7019, 7027, 7040, 7155, 7168, 7223, 7232, 7241, 7245, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7376, 7378, 7380, 7418, 7424, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8203, 8207, 8234, 8238, 8255, 8256, 8276, 8276, 8288, 8292, 8294, 8303, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8400, 8412, 8417, 8417, 8421, 8432, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11647, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11744, 11775, 11823, 11823, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12348, 12353, 12438, 12441, 12442, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42539, 42560, 42607, 42612, 42621, 42623, 42737, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43047, 43052, 43052, 43064, 43064, 43072, 43123, 43136, 43205, 43216, 43225, 43232, 43255, 43259, 43259, 43261, 43309, 43312, 43347, 43360, 43388, 43392, 43456, 43471, 43481, 43488, 43518, 43520, 43574, 43584, 43597, 43600, 43609, 43616, 43638, 43642, 43714, 43739, 43741, 43744, 43759, 43762, 43766, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44010, 44012, 44013, 44016, 44025, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65024, 65039, 65056, 65071, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65279, 65279, 65284, 65284, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65529, 65531, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66045, 66045, 66176, 66204, 66208, 66256, 66272, 66272, 66304, 66335, 66349, 66378, 66384, 66426, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66720, 66729, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68099, 68101, 68102, 68108, 68115, 68117, 68119, 68121, 68149, 68152, 68154, 68159, 68159, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68326, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68903, 68912, 68921, 69248, 69289, 69291, 69292, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69456, 69488, 69509, 69552, 69572, 69600, 69622, 69632, 69702, 69734, 69749, 69759, 69818, 69821, 69821, 69826, 69826, 69837, 69837, 69840, 69864, 69872, 69881, 69888, 69940, 69942, 69951, 69956, 69959, 69968, 70003, 70006, 70006, 70016, 70084, 70089, 70092, 70094, 70106, 70108, 70108, 70144, 70161, 70163, 70199, 70206, 70206, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70378, 70384, 70393, 70400, 70403, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70459, 70468, 70471, 70472, 70475, 70477, 70480, 70480, 70487, 70487, 70493, 70499, 70502, 70508, 70512, 70516, 70656, 70730, 70736, 70745, 70750, 70753, 70784, 70853, 70855, 70855, 70864, 70873, 71040, 71093, 71096, 71104, 71128, 71133, 71168, 71232, 71236, 71236, 71248, 71257, 71296, 71352, 71360, 71369, 71424, 71450, 71453, 71467, 71472, 71481, 71488, 71494, 71680, 71738, 71840, 71913, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71989, 71991, 71992, 71995, 72003, 72016, 72025, 72096, 72103, 72106, 72151, 72154, 72161, 72163, 72164, 72192, 72254, 72263, 72263, 72272, 72345, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72758, 72760, 72768, 72784, 72793, 72818, 72847, 72850, 72871, 72873, 72886, 72960, 72966, 72968, 72969, 72971, 73014, 73018, 73018, 73020, 73021, 73023, 73031, 73040, 73049, 73056, 73061, 73063, 73064, 73066, 73102, 73104, 73105, 73107, 73112, 73120, 73129, 73440, 73462, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 78896, 78904, 82944, 83526, 92160, 92728, 92736, 92766, 92768, 92777, 92784, 92862, 92864, 92873, 92880, 92909, 92912, 92916, 92928, 92982, 92992, 92995, 93008, 93017, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94031, 94087, 94095, 94111, 94176, 94177, 94179, 94180, 94192, 94193, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 113821, 113822, 113824, 113827, 118528, 118573, 118576, 118598, 119141, 119145, 119149, 119170, 119173, 119179, 119210, 119213, 119362, 119364, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 120782, 120831, 121344, 121398, 121403, 121452, 121461, 121461, 121476, 121476, 121499, 121503, 121505, 121519, 122624, 122654, 122880, 122886, 122888, 122904, 122907, 122913, 122915, 122916, 122918, 122922, 123136, 123180, 123184, 123197, 123200, 123209, 123214, 123214, 123536, 123566, 123584, 123641, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125136, 125142, 125184, 125259, 125264, 125273, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 130032, 130041, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546, 917505, 917505, 917536, 917631, 917760, 917999};
        }

        private static int[] NFA_MOVES_275_init() {
            return new int[]{36, 36, 65, 90, 95, 95, 97, 122, 162, 165, 170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1488, 1514, 1519, 1522, 1547, 1547, 1568, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2046, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2144, 2154, 2160, 2183, 2185, 2190, 2208, 2249, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2432, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2547, 2555, 2556, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2801, 2801, 2809, 2809, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3065, 3065, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3133, 3160, 3162, 3165, 3165, 3168, 3169, 3200, 3200, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3293, 3294, 3296, 3297, 3313, 3314, 3332, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3412, 3414, 3423, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3647, 3654, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5905, 5919, 5937, 5952, 5969, 5984, 5996, 5998, 6000, 6016, 6067, 6103, 6103, 6107, 6108, 6176, 6264, 6272, 6276, 6279, 6312, 6314, 6314, 6320, 6389, 6400, 6430, 6480, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6988, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7401, 7404, 7406, 7411, 7413, 7414, 7418, 7418, 7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8255, 8256, 8276, 8276, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11823, 11823, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539, 42560, 42606, 42623, 42653, 42656, 42735, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43064, 43064, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43261, 43262, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43488, 43492, 43494, 43503, 43514, 43518, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43638, 43642, 43642, 43646, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43741, 43744, 43754, 43762, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65284, 65284, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66176, 66204, 66208, 66256, 66304, 66335, 66349, 66378, 66384, 66421, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68096, 68112, 68115, 68117, 68119, 68121, 68149, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68324, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68899, 69248, 69289, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69445, 69488, 69505, 69552, 69572, 69600, 69622, 69635, 69687, 69745, 69746, 69749, 69749, 69763, 69807, 69840, 69864, 69891, 69926, 69956, 69956, 69959, 69959, 69968, 70002, 70006, 70006, 70019, 70066, 70081, 70084, 70106, 70106, 70108, 70108, 70144, 70161, 70163, 70187, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70366, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70461, 70461, 70480, 70480, 70493, 70497, 70656, 70708, 70727, 70730, 70751, 70753, 70784, 70831, 70852, 70853, 70855, 70855, 71040, 71086, 71128, 71131, 71168, 71215, 71236, 71236, 71296, 71338, 71352, 71352, 71424, 71450, 71488, 71494, 71680, 71723, 71840, 71903, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71983, 71999, 71999, 72001, 72001, 72096, 72103, 72106, 72144, 72161, 72161, 72163, 72163, 72192, 72192, 72203, 72242, 72250, 72250, 72272, 72272, 72284, 72329, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72750, 72768, 72768, 72818, 72847, 72960, 72966, 72968, 72969, 72971, 73008, 73030, 73030, 73056, 73061, 73063, 73064, 73066, 73097, 73112, 73112, 73440, 73458, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 82944, 83526, 92160, 92728, 92736, 92766, 92784, 92862, 92880, 92909, 92928, 92975, 92992, 92995, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94032, 94032, 94099, 94111, 94176, 94177, 94179, 94179, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 122624, 122654, 123136, 123180, 123191, 123197, 123214, 123214, 123536, 123565, 123584, 123627, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125184, 125251, 125259, 125259, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546};
        }

        private static int[] NFA_MOVES_399_init() {
            return new int[]{36, 36, 65, 90, 95, 95, 97, 122, 162, 165, 170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1488, 1514, 1519, 1522, 1547, 1547, 1568, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2046, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2144, 2154, 2160, 2183, 2185, 2190, 2208, 2249, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2432, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2547, 2555, 2556, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2801, 2801, 2809, 2809, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3065, 3065, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3133, 3160, 3162, 3165, 3165, 3168, 3169, 3200, 3200, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3293, 3294, 3296, 3297, 3313, 3314, 3332, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3412, 3414, 3423, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3647, 3654, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5905, 5919, 5937, 5952, 5969, 5984, 5996, 5998, 6000, 6016, 6067, 6103, 6103, 6107, 6108, 6176, 6264, 6272, 6276, 6279, 6312, 6314, 6314, 6320, 6389, 6400, 6430, 6480, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6988, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7401, 7404, 7406, 7411, 7413, 7414, 7418, 7418, 7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8255, 8256, 8276, 8276, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11823, 11823, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539, 42560, 42606, 42623, 42653, 42656, 42735, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43064, 43064, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43261, 43262, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43488, 43492, 43494, 43503, 43514, 43518, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43638, 43642, 43642, 43646, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43741, 43744, 43754, 43762, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65284, 65284, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66176, 66204, 66208, 66256, 66304, 66335, 66349, 66378, 66384, 66421, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68096, 68112, 68115, 68117, 68119, 68121, 68149, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68324, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68899, 69248, 69289, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69445, 69488, 69505, 69552, 69572, 69600, 69622, 69635, 69687, 69745, 69746, 69749, 69749, 69763, 69807, 69840, 69864, 69891, 69926, 69956, 69956, 69959, 69959, 69968, 70002, 70006, 70006, 70019, 70066, 70081, 70084, 70106, 70106, 70108, 70108, 70144, 70161, 70163, 70187, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70366, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70461, 70461, 70480, 70480, 70493, 70497, 70656, 70708, 70727, 70730, 70751, 70753, 70784, 70831, 70852, 70853, 70855, 70855, 71040, 71086, 71128, 71131, 71168, 71215, 71236, 71236, 71296, 71338, 71352, 71352, 71424, 71450, 71488, 71494, 71680, 71723, 71840, 71903, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71983, 71999, 71999, 72001, 72001, 72096, 72103, 72106, 72144, 72161, 72161, 72163, 72163, 72192, 72192, 72203, 72242, 72250, 72250, 72272, 72272, 72284, 72329, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72750, 72768, 72768, 72818, 72847, 72960, 72966, 72968, 72969, 72971, 73008, 73030, 73030, 73056, 73061, 73063, 73064, 73066, 73097, 73112, 73112, 73440, 73458, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 82944, 83526, 92160, 92728, 92736, 92766, 92784, 92862, 92880, 92909, 92928, 92975, 92992, 92995, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94032, 94032, 94099, 94111, 94176, 94177, 94179, 94179, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 122624, 122654, 123136, 123180, 123191, 123197, 123214, 123214, 123536, 123565, 123584, 123627, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125184, 125251, 125259, 125259, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546};
        }

        private static int[] NFA_MOVES_508_init() {
            return new int[]{0, 8, 14, 27, 36, 36, 48, 57, 65, 90, 95, 95, 97, 122, 127, 159, 162, 165, 170, 170, 173, 173, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 768, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1155, 1159, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1488, 1514, 1519, 1522, 1536, 1541, 1547, 1547, 1552, 1562, 1564, 1564, 1568, 1641, 1646, 1747, 1749, 1757, 1759, 1768, 1770, 1788, 1791, 1791, 1807, 1866, 1869, 1969, 1984, 2037, 2042, 2042, 2045, 2093, 2112, 2139, 2144, 2154, 2160, 2183, 2185, 2190, 2192, 2193, 2200, 2403, 2406, 2415, 2417, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2500, 2503, 2504, 2507, 2510, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2547, 2555, 2556, 2558, 2558, 2561, 2563, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2649, 2652, 2654, 2654, 2662, 2677, 2689, 2691, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2787, 2790, 2799, 2801, 2801, 2809, 2815, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2876, 2884, 2887, 2888, 2891, 2893, 2901, 2903, 2908, 2909, 2911, 2915, 2918, 2927, 2929, 2929, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3024, 3024, 3031, 3031, 3046, 3055, 3065, 3065, 3072, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3132, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3160, 3162, 3165, 3165, 3168, 3171, 3174, 3183, 3200, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3260, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3293, 3294, 3296, 3299, 3302, 3311, 3313, 3314, 3328, 3340, 3342, 3344, 3346, 3396, 3398, 3400, 3402, 3406, 3412, 3415, 3423, 3427, 3430, 3439, 3450, 3455, 3457, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3558, 3567, 3570, 3571, 3585, 3642, 3647, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3807, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3948, 3953, 3972, 3974, 3991, 3993, 4028, 4038, 4038, 4096, 4169, 4176, 4253, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4957, 4959, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5909, 5919, 5940, 5952, 5971, 5984, 5996, 5998, 6000, 6002, 6003, 6016, 6099, 6103, 6103, 6107, 6109, 6112, 6121, 6155, 6169, 6176, 6264, 6272, 6314, 6320, 6389, 6400, 6430, 6432, 6443, 6448, 6459, 6470, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6608, 6617, 6656, 6683, 6688, 6750, 6752, 6780, 6783, 6793, 6800, 6809, 6823, 6823, 6832, 6845, 6847, 6862, 6912, 6988, 6992, 7001, 7019, 7027, 7040, 7155, 7168, 7223, 7232, 7241, 7245, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7376, 7378, 7380, 7418, 7424, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8203, 8207, 8234, 8238, 8255, 8256, 8276, 8276, 8288, 8292, 8294, 8303, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8400, 8412, 8417, 8417, 8421, 8432, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11647, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11744, 11775, 11823, 11823, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12348, 12353, 12438, 12441, 12442, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42539, 42560, 42607, 42612, 42621, 42623, 42737, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43047, 43052, 43052, 43064, 43064, 43072, 43123, 43136, 43205, 43216, 43225, 43232, 43255, 43259, 43259, 43261, 43309, 43312, 43347, 43360, 43388, 43392, 43456, 43471, 43481, 43488, 43518, 43520, 43574, 43584, 43597, 43600, 43609, 43616, 43638, 43642, 43714, 43739, 43741, 43744, 43759, 43762, 43766, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44010, 44012, 44013, 44016, 44025, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65024, 65039, 65056, 65071, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65279, 65279, 65284, 65284, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65529, 65531, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66045, 66045, 66176, 66204, 66208, 66256, 66272, 66272, 66304, 66335, 66349, 66378, 66384, 66426, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66720, 66729, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68099, 68101, 68102, 68108, 68115, 68117, 68119, 68121, 68149, 68152, 68154, 68159, 68159, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68326, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68903, 68912, 68921, 69248, 69289, 69291, 69292, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69456, 69488, 69509, 69552, 69572, 69600, 69622, 69632, 69702, 69734, 69749, 69759, 69818, 69821, 69821, 69826, 69826, 69837, 69837, 69840, 69864, 69872, 69881, 69888, 69940, 69942, 69951, 69956, 69959, 69968, 70003, 70006, 70006, 70016, 70084, 70089, 70092, 70094, 70106, 70108, 70108, 70144, 70161, 70163, 70199, 70206, 70206, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70378, 70384, 70393, 70400, 70403, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70459, 70468, 70471, 70472, 70475, 70477, 70480, 70480, 70487, 70487, 70493, 70499, 70502, 70508, 70512, 70516, 70656, 70730, 70736, 70745, 70750, 70753, 70784, 70853, 70855, 70855, 70864, 70873, 71040, 71093, 71096, 71104, 71128, 71133, 71168, 71232, 71236, 71236, 71248, 71257, 71296, 71352, 71360, 71369, 71424, 71450, 71453, 71467, 71472, 71481, 71488, 71494, 71680, 71738, 71840, 71913, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71989, 71991, 71992, 71995, 72003, 72016, 72025, 72096, 72103, 72106, 72151, 72154, 72161, 72163, 72164, 72192, 72254, 72263, 72263, 72272, 72345, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72758, 72760, 72768, 72784, 72793, 72818, 72847, 72850, 72871, 72873, 72886, 72960, 72966, 72968, 72969, 72971, 73014, 73018, 73018, 73020, 73021, 73023, 73031, 73040, 73049, 73056, 73061, 73063, 73064, 73066, 73102, 73104, 73105, 73107, 73112, 73120, 73129, 73440, 73462, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 78896, 78904, 82944, 83526, 92160, 92728, 92736, 92766, 92768, 92777, 92784, 92862, 92864, 92873, 92880, 92909, 92912, 92916, 92928, 92982, 92992, 92995, 93008, 93017, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94031, 94087, 94095, 94111, 94176, 94177, 94179, 94180, 94192, 94193, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 113821, 113822, 113824, 113827, 118528, 118573, 118576, 118598, 119141, 119145, 119149, 119170, 119173, 119179, 119210, 119213, 119362, 119364, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 120782, 120831, 121344, 121398, 121403, 121452, 121461, 121461, 121476, 121476, 121499, 121503, 121505, 121519, 122624, 122654, 122880, 122886, 122888, 122904, 122907, 122913, 122915, 122916, 122918, 122922, 123136, 123180, 123184, 123197, 123200, 123209, 123214, 123214, 123536, 123566, 123584, 123641, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125136, 125142, 125184, 125259, 125264, 125273, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 130032, 130041, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546, 917505, 917505, 917536, 917631, 917760, 917999};
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{DEFAULT::NFA_0, DEFAULT::NFA_1, DEFAULT::NFA_2, DEFAULT::NFA_3, DEFAULT::NFA_4, DEFAULT::NFA_5, DEFAULT::NFA_6, DEFAULT::NFA_7, DEFAULT::NFA_8, DEFAULT::NFA_9, DEFAULT::NFA_10, DEFAULT::NFA_11, DEFAULT::NFA_12, DEFAULT::NFA_13, DEFAULT::NFA_14, DEFAULT::NFA_15, DEFAULT::NFA_16, DEFAULT::NFA_17, DEFAULT::NFA_18, DEFAULT::NFA_19, DEFAULT::NFA_20, DEFAULT::NFA_21, DEFAULT::NFA_22, DEFAULT::NFA_23, DEFAULT::NFA_24, DEFAULT::NFA_25, DEFAULT::NFA_26, DEFAULT::NFA_27, DEFAULT::NFA_28, DEFAULT::NFA_29, DEFAULT::NFA_30, DEFAULT::NFA_31, DEFAULT::NFA_32, DEFAULT::NFA_33, DEFAULT::NFA_34, DEFAULT::NFA_35, DEFAULT::NFA_36, DEFAULT::NFA_37, DEFAULT::NFA_38, DEFAULT::NFA_39, DEFAULT::NFA_40, DEFAULT::NFA_41, DEFAULT::NFA_42, DEFAULT::NFA_43, DEFAULT::NFA_44, DEFAULT::NFA_45, DEFAULT::NFA_46, DEFAULT::NFA_47, DEFAULT::NFA_48, DEFAULT::NFA_49, DEFAULT::NFA_50, DEFAULT::NFA_51, DEFAULT::NFA_52, DEFAULT::NFA_53, DEFAULT::NFA_54, DEFAULT::NFA_55, DEFAULT::NFA_56, DEFAULT::NFA_57, DEFAULT::NFA_58, DEFAULT::NFA_59, DEFAULT::NFA_60, DEFAULT::NFA_61, DEFAULT::NFA_62, DEFAULT::NFA_63, DEFAULT::NFA_64, DEFAULT::NFA_65, DEFAULT::NFA_66, DEFAULT::NFA_67, DEFAULT::NFA_68, DEFAULT::NFA_69, DEFAULT::NFA_70, DEFAULT::NFA_71, DEFAULT::NFA_72, DEFAULT::NFA_73, DEFAULT::NFA_74, DEFAULT::NFA_75, DEFAULT::NFA_76, DEFAULT::NFA_77, DEFAULT::NFA_78, DEFAULT::NFA_79, DEFAULT::NFA_80, DEFAULT::NFA_81, DEFAULT::NFA_82, DEFAULT::NFA_83, DEFAULT::NFA_84, DEFAULT::NFA_85, DEFAULT::NFA_86, DEFAULT::NFA_87, DEFAULT::NFA_88, DEFAULT::NFA_89, DEFAULT::NFA_90, DEFAULT::NFA_91, DEFAULT::NFA_92, DEFAULT::NFA_93, DEFAULT::NFA_94, DEFAULT::NFA_95, DEFAULT::NFA_96, DEFAULT::NFA_97, DEFAULT::NFA_98, DEFAULT::NFA_99, DEFAULT::NFA_100, DEFAULT::NFA_101, DEFAULT::NFA_102, DEFAULT::NFA_103, DEFAULT::NFA_104, DEFAULT::NFA_105, DEFAULT::NFA_106, DEFAULT::NFA_107, DEFAULT::NFA_108, DEFAULT::NFA_109, DEFAULT::NFA_110, DEFAULT::NFA_111, DEFAULT::NFA_112, DEFAULT::NFA_113, DEFAULT::NFA_114, DEFAULT::NFA_115, DEFAULT::NFA_116, DEFAULT::NFA_117, DEFAULT::NFA_118, DEFAULT::NFA_119, DEFAULT::NFA_120, DEFAULT::NFA_121, DEFAULT::NFA_122, DEFAULT::NFA_123, DEFAULT::NFA_124, DEFAULT::NFA_125, DEFAULT::NFA_126, DEFAULT::NFA_127, DEFAULT::NFA_128, DEFAULT::NFA_129, DEFAULT::NFA_130, DEFAULT::NFA_131, DEFAULT::NFA_132, DEFAULT::NFA_133, DEFAULT::NFA_134, DEFAULT::NFA_135, DEFAULT::NFA_136, DEFAULT::NFA_137, DEFAULT::NFA_138, DEFAULT::NFA_139, DEFAULT::NFA_140, DEFAULT::NFA_141, DEFAULT::NFA_142, DEFAULT::NFA_143, DEFAULT::NFA_144, DEFAULT::NFA_145, DEFAULT::NFA_146, DEFAULT::NFA_147, DEFAULT::NFA_148, DEFAULT::NFA_149, DEFAULT::NFA_150, DEFAULT::NFA_151, DEFAULT::NFA_152, DEFAULT::NFA_153, DEFAULT::NFA_154, DEFAULT::NFA_155, DEFAULT::NFA_156, DEFAULT::NFA_157, DEFAULT::NFA_158, DEFAULT::NFA_159, DEFAULT::NFA_160, DEFAULT::NFA_161, DEFAULT::NFA_162, DEFAULT::NFA_163, DEFAULT::NFA_164, DEFAULT::NFA_165, DEFAULT::NFA_166, DEFAULT::NFA_167, DEFAULT::NFA_168, DEFAULT::NFA_169, DEFAULT::NFA_170, DEFAULT::NFA_171, DEFAULT::NFA_172, DEFAULT::NFA_173, DEFAULT::NFA_174, DEFAULT::NFA_175, DEFAULT::NFA_176, DEFAULT::NFA_177, DEFAULT::NFA_178, DEFAULT::NFA_179, DEFAULT::NFA_180, DEFAULT::NFA_181, DEFAULT::NFA_182, DEFAULT::NFA_183, DEFAULT::NFA_184, DEFAULT::NFA_185, DEFAULT::NFA_186, DEFAULT::NFA_187, DEFAULT::NFA_188, DEFAULT::NFA_189, DEFAULT::NFA_190, DEFAULT::NFA_191, DEFAULT::NFA_192, DEFAULT::NFA_193, DEFAULT::NFA_194, DEFAULT::NFA_195, DEFAULT::NFA_196, DEFAULT::NFA_197, DEFAULT::NFA_198, DEFAULT::NFA_199, DEFAULT::NFA_200, DEFAULT::NFA_201, DEFAULT::NFA_202, DEFAULT::NFA_203, DEFAULT::NFA_204, DEFAULT::NFA_205, DEFAULT::NFA_206, DEFAULT::NFA_207, DEFAULT::NFA_208, DEFAULT::NFA_209, DEFAULT::NFA_210, DEFAULT::NFA_211, DEFAULT::NFA_212, DEFAULT::NFA_213, DEFAULT::NFA_214, DEFAULT::NFA_215, DEFAULT::NFA_216, DEFAULT::NFA_217, DEFAULT::NFA_218, DEFAULT::NFA_219, DEFAULT::NFA_220, DEFAULT::NFA_221, DEFAULT::NFA_222, DEFAULT::NFA_223, DEFAULT::NFA_224, DEFAULT::NFA_225, DEFAULT::NFA_226, DEFAULT::NFA_227, DEFAULT::NFA_228, DEFAULT::NFA_229, DEFAULT::NFA_230, DEFAULT::NFA_231, DEFAULT::NFA_232, DEFAULT::NFA_233, DEFAULT::NFA_234, DEFAULT::NFA_235, DEFAULT::NFA_236, DEFAULT::NFA_237, DEFAULT::NFA_238, DEFAULT::NFA_239, DEFAULT::NFA_240, DEFAULT::NFA_241, DEFAULT::NFA_242, DEFAULT::NFA_243, DEFAULT::NFA_244, DEFAULT::NFA_245, DEFAULT::NFA_246, DEFAULT::NFA_247, DEFAULT::NFA_248, DEFAULT::NFA_249, DEFAULT::NFA_250, DEFAULT::NFA_251, DEFAULT::NFA_252, DEFAULT::NFA_253, DEFAULT::NFA_254, DEFAULT::NFA_255, DEFAULT::NFA_256, DEFAULT::NFA_257, DEFAULT::NFA_258, DEFAULT::NFA_259, DEFAULT::NFA_260, DEFAULT::NFA_261, DEFAULT::NFA_262, DEFAULT::NFA_263, DEFAULT::NFA_264, DEFAULT::NFA_265, DEFAULT::NFA_266, DEFAULT::NFA_267, DEFAULT::NFA_268, DEFAULT::NFA_269, DEFAULT::NFA_270, DEFAULT::NFA_271, DEFAULT::NFA_272, DEFAULT::NFA_273, DEFAULT::NFA_274, DEFAULT::NFA_275, DEFAULT::NFA_276, DEFAULT::NFA_277, DEFAULT::NFA_278, DEFAULT::NFA_279, DEFAULT::NFA_280, DEFAULT::NFA_281, DEFAULT::NFA_282, DEFAULT::NFA_283, DEFAULT::NFA_284, DEFAULT::NFA_285, DEFAULT::NFA_286, DEFAULT::NFA_287, DEFAULT::NFA_288, DEFAULT::NFA_289, DEFAULT::NFA_290, DEFAULT::NFA_291, DEFAULT::NFA_292, DEFAULT::NFA_293, DEFAULT::NFA_294, DEFAULT::NFA_295, DEFAULT::NFA_296, DEFAULT::NFA_297, DEFAULT::NFA_298, DEFAULT::NFA_299, DEFAULT::NFA_300, DEFAULT::NFA_301, DEFAULT::NFA_302, DEFAULT::NFA_303, DEFAULT::NFA_304, DEFAULT::NFA_305, DEFAULT::NFA_306, DEFAULT::NFA_307, DEFAULT::NFA_308, DEFAULT::NFA_309, DEFAULT::NFA_310, DEFAULT::NFA_311, DEFAULT::NFA_312, DEFAULT::NFA_313, DEFAULT::NFA_314, DEFAULT::NFA_315, DEFAULT::NFA_316, DEFAULT::NFA_317, DEFAULT::NFA_318, DEFAULT::NFA_319, DEFAULT::NFA_320, DEFAULT::NFA_321, DEFAULT::NFA_322, DEFAULT::NFA_323, DEFAULT::NFA_324, DEFAULT::NFA_325, DEFAULT::NFA_326, DEFAULT::NFA_327, DEFAULT::NFA_328, DEFAULT::NFA_329, DEFAULT::NFA_330, DEFAULT::NFA_331, DEFAULT::NFA_332, DEFAULT::NFA_333, DEFAULT::NFA_334, DEFAULT::NFA_335, DEFAULT::NFA_336, DEFAULT::NFA_337, DEFAULT::NFA_338, DEFAULT::NFA_339, DEFAULT::NFA_340, DEFAULT::NFA_341, DEFAULT::NFA_342, DEFAULT::NFA_343, DEFAULT::NFA_344, DEFAULT::NFA_345, DEFAULT::NFA_346, DEFAULT::NFA_347, DEFAULT::NFA_348, DEFAULT::NFA_349, DEFAULT::NFA_350, DEFAULT::NFA_351, DEFAULT::NFA_352, DEFAULT::NFA_353, DEFAULT::NFA_354, DEFAULT::NFA_355, DEFAULT::NFA_356, DEFAULT::NFA_357, DEFAULT::NFA_358, DEFAULT::NFA_359, DEFAULT::NFA_360, DEFAULT::NFA_361, DEFAULT::NFA_362, DEFAULT::NFA_363, DEFAULT::NFA_364, DEFAULT::NFA_365, DEFAULT::NFA_366, DEFAULT::NFA_367, DEFAULT::NFA_368, DEFAULT::NFA_369, DEFAULT::NFA_370, DEFAULT::NFA_371, DEFAULT::NFA_372, DEFAULT::NFA_373, DEFAULT::NFA_374, DEFAULT::NFA_375, DEFAULT::NFA_376, DEFAULT::NFA_377, DEFAULT::NFA_378, DEFAULT::NFA_379, DEFAULT::NFA_380, DEFAULT::NFA_381, DEFAULT::NFA_382, DEFAULT::NFA_383, DEFAULT::NFA_384, DEFAULT::NFA_385, DEFAULT::NFA_386, DEFAULT::NFA_387, DEFAULT::NFA_388, DEFAULT::NFA_389, DEFAULT::NFA_390, DEFAULT::NFA_391, DEFAULT::NFA_392, DEFAULT::NFA_393, DEFAULT::NFA_394, DEFAULT::NFA_395, DEFAULT::NFA_396, DEFAULT::NFA_397, DEFAULT::NFA_398, DEFAULT::NFA_399, DEFAULT::NFA_400, DEFAULT::NFA_401, DEFAULT::NFA_402, DEFAULT::NFA_403, DEFAULT::NFA_404, DEFAULT::NFA_405, DEFAULT::NFA_406, DEFAULT::NFA_407, DEFAULT::NFA_408, DEFAULT::NFA_409, DEFAULT::NFA_410, DEFAULT::NFA_411, DEFAULT::NFA_412, DEFAULT::NFA_413, DEFAULT::NFA_414, DEFAULT::NFA_415, DEFAULT::NFA_416, DEFAULT::NFA_417, DEFAULT::NFA_418, DEFAULT::NFA_419, DEFAULT::NFA_420, DEFAULT::NFA_421, DEFAULT::NFA_422, DEFAULT::NFA_423, DEFAULT::NFA_424, DEFAULT::NFA_425, DEFAULT::NFA_426, DEFAULT::NFA_427, DEFAULT::NFA_428, DEFAULT::NFA_429, DEFAULT::NFA_430, DEFAULT::NFA_431, DEFAULT::NFA_432, DEFAULT::NFA_433, DEFAULT::NFA_434, DEFAULT::NFA_435, DEFAULT::NFA_436, DEFAULT::NFA_437, DEFAULT::NFA_438, DEFAULT::NFA_439, DEFAULT::NFA_440, DEFAULT::NFA_441, DEFAULT::NFA_442, DEFAULT::NFA_443, DEFAULT::NFA_444, DEFAULT::NFA_445, DEFAULT::NFA_446, DEFAULT::NFA_447, DEFAULT::NFA_448, DEFAULT::NFA_449, DEFAULT::NFA_450, DEFAULT::NFA_451, DEFAULT::NFA_452, DEFAULT::NFA_453, DEFAULT::NFA_454, DEFAULT::NFA_455, DEFAULT::NFA_456, DEFAULT::NFA_457, DEFAULT::NFA_458, DEFAULT::NFA_459, DEFAULT::NFA_460, DEFAULT::NFA_461, DEFAULT::NFA_462, DEFAULT::NFA_463, DEFAULT::NFA_464, DEFAULT::NFA_465, DEFAULT::NFA_466, DEFAULT::NFA_467, DEFAULT::NFA_468, DEFAULT::NFA_469, DEFAULT::NFA_470, DEFAULT::NFA_471, DEFAULT::NFA_472, DEFAULT::NFA_473, DEFAULT::NFA_474, DEFAULT::NFA_475, DEFAULT::NFA_476, DEFAULT::NFA_477, DEFAULT::NFA_478, DEFAULT::NFA_479, DEFAULT::NFA_480, DEFAULT::NFA_481, DEFAULT::NFA_482, DEFAULT::NFA_483, DEFAULT::NFA_484};
            functionTableMap.put(LexicalState.DEFAULT, functions);
        }
    }

    static interface NfaFunction {
        public Token.TokenType apply(int var1, BitSet var2, EnumSet<Token.TokenType> var3);
    }

    public static enum LexicalState {
        DEFAULT,
        NODIRECTIVE,
        EXPRESSION,
        EXPRESSION_COMMENT,
        NO_SPACE_EXPRESSION,
        NO_PARSE,
        PHONY;

    }
}

