/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.helpers;

import freemarker.core.Environment;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ast.Expression;
import freemarker.template.TemplateModel;
import java.util.Locale;

public class DefaultReferenceChecker {
    public static final DefaultReferenceChecker instance = new DefaultReferenceChecker();
    private Locale locale;

    protected DefaultReferenceChecker() {
    }

    public void assertNonNull(TemplateModel model, Expression exp, Environment env) throws InvalidReferenceException {
        this.assertIsDefined(model, exp, env);
        if (model == TemplateModel.JAVA_NULL) {
            throw new InvalidReferenceException("Expression " + exp + " is null " + exp.getStartLocation() + ".", env);
        }
    }

    public void assertIsDefined(TemplateModel model, Expression exp, Environment env) throws InvalidReferenceException {
        if (model == null) {
            throw new InvalidReferenceException("Expression " + exp + " is undefined " + exp.getStartLocation() + ".", env);
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

