/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.builtins;

import freemarker.core.Environment;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ast.BuiltInExpression;
import freemarker.core.ast.TemplateNode;
import freemarker.core.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class StringFunctions
extends ExpressionEvaluatingBuiltIn {
    private static HashMap<String, Pattern> patternLookup = new HashMap();
    private static LinkedList<String> patterns = new LinkedList();
    private static final int PATTERN_CACHE_SIZE = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Pattern getPattern(String patternString, String flagString) {
        int flags = 0;
        String patternKey = patternString + '\u0000' + flagString;
        Pattern result = patternLookup.get(patternKey);
        if (result != null) {
            return result;
        }
        if (flagString == null || flagString.length() == 0) {
            try {
                result = Pattern.compile(patternString);
            }
            catch (PatternSyntaxException e) {
                throw new TemplateModelException(e);
            }
        }
        if (flagString.indexOf(105) >= 0) {
            flags |= 2;
        }
        if (flagString.indexOf(109) >= 0) {
            flags |= 8;
        }
        if (flagString.indexOf(99) >= 0) {
            flags |= 4;
        }
        if (flagString.indexOf(115) >= 0) {
            flags |= 0x20;
        }
        try {
            result = Pattern.compile(patternString, flags);
        }
        catch (PatternSyntaxException e) {
            throw new TemplateModelException(e);
        }
        LinkedList<String> linkedList = patterns;
        synchronized (linkedList) {
            patterns.add(patternKey);
            patternLookup.put(patternKey, result);
            if (patterns.size() > 100) {
                String first = patterns.removeFirst();
                patterns.remove(first);
            }
        }
        return result;
    }

    @Override
    public TemplateModel get(Environment env, BuiltInExpression caller, TemplateModel model) throws TemplateException {
        try {
            String string = ((TemplateScalarModel)model).getAsString();
            return this.apply(string, env, caller);
        }
        catch (ClassCastException cce) {
            throw TemplateNode.invalidTypeException(model, caller.getTarget(), env, "string");
        }
        catch (NullPointerException npe) {
            throw new InvalidReferenceException("String is undefined", env);
        }
    }

    public abstract TemplateModel apply(String var1, Environment var2, BuiltInExpression var3) throws TemplateException;

    static class ContainsMethod
    implements TemplateMethodModelEx {
        private String s;

        private ContainsMethod(String s) {
            this.s = s;
        }

        @Override
        public Object exec(List args) {
            int ln = args.size();
            if (ln != 1) {
                throw new TemplateModelException("?contains(...) expects one argument.");
            }
            Object obj = args.get(0);
            if (!(obj instanceof TemplateScalarModel)) {
                throw new TemplateModelException("?contains(...) expects a string as its first argument.");
            }
            String sub = ((TemplateScalarModel)obj).getAsString();
            return this.s.indexOf(sub) != -1 ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class IndexOfMethod
    implements TemplateMethodModelEx {
        private final String s;
        private final boolean reverse;

        IndexOfMethod(String s, boolean reverse) {
            this.s = s;
            this.reverse = reverse;
        }

        private String getName() {
            return "?" + (this.reverse ? "last_" : "") + "index_of";
        }

        @Override
        public Object exec(List args) {
            int fidx;
            int ln = args.size();
            if (ln == 0) {
                throw new TemplateModelException(this.getName() + "(...) expects at least one argument.");
            }
            if (ln > 2) {
                throw new TemplateModelException(this.getName() + "(...) expects at most two arguments.");
            }
            Object obj = args.get(0);
            if (!(obj instanceof TemplateScalarModel)) {
                throw new TemplateModelException(this.getName() + "(...) expects a string as its first argument.");
            }
            String sub = ((TemplateScalarModel)obj).getAsString();
            if (ln > 1) {
                obj = args.get(1);
                if (!(obj instanceof TemplateNumberModel)) {
                    throw new TemplateModelException(this.getName() + "(...) expects a number as its second argument.");
                }
                fidx = ((TemplateNumberModel)obj).getAsNumber().intValue();
            } else {
                fidx = 0;
            }
            int index = this.reverse ? (ln > 1 ? this.s.lastIndexOf(sub, fidx) : this.s.lastIndexOf(sub)) : this.s.indexOf(sub, fidx);
            return new SimpleNumber(index);
        }
    }

    static class StartsOrEndsWithMethod
    implements TemplateMethodModelEx {
        private final String string;
        private final boolean reverse;

        private StartsOrEndsWithMethod(String string, boolean reverse) {
            this.string = string;
            this.reverse = reverse;
        }

        private String getName() {
            return this.reverse ? "?ends_with" : "?starts_with";
        }

        @Override
        public Object exec(List args) {
            if (args.size() != 1) {
                throw new TemplateModelException(this.getName() + "(...) expects exactly 1 argument.");
            }
            Object obj = args.get(0);
            if (!(obj instanceof TemplateScalarModel)) {
                throw new TemplateModelException(this.getName() + "(...) expects a string argument");
            }
            String sub = ((TemplateScalarModel)obj).getAsString();
            boolean result = this.reverse ? this.string.endsWith(sub) : this.string.startsWith(sub);
            return result ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class urlBIResult
    implements TemplateScalarModel,
    TemplateMethodModel {
        private final String target;
        private final Environment env;
        private String cachedResult;

        private urlBIResult(String target, Environment env) {
            this.target = target;
            this.env = env;
        }

        @Override
        public String getAsString() {
            if (this.cachedResult == null) {
                String cs = this.env.getEffectiveURLEscapingCharset();
                if (cs == null) {
                    throw new TemplateModelException("To do URL encoding, the framework that encloses FreeMarker must specify the output encoding or the URL encoding charset, so ask the programmers to fix it. Or, as a last chance, you can set the url_encoding_charset setting in the template, e.g. <#setting url_escaping_charset='ISO-8859-1'>, or give the charset explicitly to the buit-in, e.g. foo?url('ISO-8859-1').");
                }
                try {
                    this.cachedResult = StringUtil.URLEnc(this.target, cs);
                }
                catch (UnsupportedEncodingException e) {
                    throw new TemplateModelException("Failed to execute URL encoding.", e);
                }
            }
            return this.cachedResult;
        }

        @Override
        public Object exec(List args) {
            if (args.size() != 1) {
                throw new TemplateModelException("The \"url\" built-in needs exactly 1 parameter, the charset.");
            }
            try {
                return new SimpleScalar(StringUtil.URLEnc(this.target, (String)args.get(0)));
            }
            catch (UnsupportedEncodingException e) {
                throw new TemplateModelException("Failed to execute URL encoding.", e);
            }
        }
    }

    static class RightPadMethod
    implements TemplateMethodModelEx {
        private String string;

        private RightPadMethod(String string) {
            this.string = string;
        }

        @Override
        public Object exec(List args) {
            int ln = args.size();
            if (ln == 0) {
                throw new TemplateModelException("?right_pad(...) expects at least 1 argument.");
            }
            if (ln > 2) {
                throw new TemplateModelException("?right_pad(...) expects at most 2 arguments.");
            }
            Object obj = args.get(0);
            if (!(obj instanceof TemplateNumberModel)) {
                throw new TemplateModelException("?right_pad(...) expects a number as its 1st argument.");
            }
            int width = ((TemplateNumberModel)obj).getAsNumber().intValue();
            if (ln > 1) {
                obj = args.get(1);
                if (!(obj instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("?right_pad(...) expects a string as its 2nd argument.");
                }
                String filling = ((TemplateScalarModel)obj).getAsString();
                try {
                    return new SimpleScalar(StringUtil.rightPad(this.string, width, filling));
                }
                catch (IllegalArgumentException e) {
                    if (filling.length() == 0) {
                        throw new TemplateModelException("The 2nd argument of ?right_pad(...) can't be a 0 length string.");
                    }
                    throw new TemplateModelException("Error while executing the ?right_pad(...) built-in.", e);
                }
            }
            return new SimpleScalar(StringUtil.rightPad(this.string, width));
        }
    }

    static class LeftPadMethod
    implements TemplateMethodModelEx {
        private String string;

        LeftPadMethod(String s) {
            this.string = s;
        }

        @Override
        public Object exec(List args) {
            int ln = args.size();
            if (ln == 0) {
                throw new TemplateModelException("?left_pad(...) expects at least 1 argument.");
            }
            if (ln > 2) {
                throw new TemplateModelException("?left_pad(...) expects at most 2 arguments.");
            }
            Object obj = args.get(0);
            if (!(obj instanceof TemplateNumberModel)) {
                throw new TemplateModelException("?left_pad(...) expects a number as its 1st argument.");
            }
            int width = ((TemplateNumberModel)obj).getAsNumber().intValue();
            if (ln > 1) {
                obj = args.get(1);
                if (!(obj instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("?left_pad(...) expects a string as its 2nd argument.");
                }
                String filling = ((TemplateScalarModel)obj).getAsString();
                try {
                    return new SimpleScalar(StringUtil.leftPad(this.string, width, filling));
                }
                catch (IllegalArgumentException e) {
                    if (filling.length() == 0) {
                        throw new TemplateModelException("The 2nd argument of ?left_pad(...) can't be a 0 length string.");
                    }
                    throw new TemplateModelException("Error while executing the ?left_pad(...) built-in.", e);
                }
            }
            return new SimpleScalar(StringUtil.leftPad(this.string, width));
        }
    }

    static class RegexMatchModel
    implements TemplateBooleanModel,
    TemplateCollectionModel,
    TemplateSequenceModel {
        Matcher matcher;
        String input;
        final boolean matches;
        TemplateSequenceModel groups;
        private ArrayList<TemplateModel> data;

        RegexMatchModel(Matcher matcher, String input) {
            this.matcher = matcher;
            this.input = input;
            this.matches = matcher.matches();
        }

        @Override
        public boolean getAsBoolean() {
            return this.matches;
        }

        @Override
        public TemplateModel get(int i) {
            if (this.data == null) {
                this.initSequence();
            }
            return this.data.get(i);
        }

        @Override
        public int size() {
            if (this.data == null) {
                this.initSequence();
            }
            return this.data.size();
        }

        private void initSequence() {
            this.data = new ArrayList();
            TemplateModelIterator it = this.iterator();
            while (it.hasNext()) {
                this.data.add(it.next());
            }
        }

        public TemplateModel getGroups() {
            if (this.groups == null) {
                this.groups = new TemplateSequenceModel(){

                    @Override
                    public int size() {
                        try {
                            return matcher.groupCount() + 1;
                        }
                        catch (Exception e) {
                            throw new TemplateModelException(e);
                        }
                    }

                    @Override
                    public TemplateModel get(int i) {
                        try {
                            return new SimpleScalar(matcher.group(i));
                        }
                        catch (Exception e) {
                            throw new TemplateModelException(e);
                        }
                    }
                };
            }
            return this.groups;
        }

        @Override
        public TemplateModelIterator iterator() {
            this.matcher.reset();
            return new TemplateModelIterator(){
                boolean hasFindInfo;
                {
                    this.hasFindInfo = matcher.find();
                }

                @Override
                public boolean hasNext() {
                    return this.hasFindInfo;
                }

                @Override
                public TemplateModel next() {
                    if (!this.hasNext()) {
                        throw new TemplateModelException("No more matches");
                    }
                    Match result = new Match();
                    this.hasFindInfo = matcher.find();
                    return result;
                }
            };
        }

        class Match
        implements TemplateScalarModel {
            String match;
            SimpleSequence subs = new SimpleSequence();

            Match() {
                this.match = RegexMatchModel.this.input.substring(RegexMatchModel.this.matcher.start(), RegexMatchModel.this.matcher.end());
                for (int i = 0; i < RegexMatchModel.this.matcher.groupCount() + 1; ++i) {
                    this.subs.add(RegexMatchModel.this.matcher.group(i));
                }
            }

            @Override
            public String getAsString() {
                return this.match;
            }
        }
    }

    static class MatcherBuilder
    implements TemplateMethodModel {
        String matchString;

        MatcherBuilder(String matchString) {
            this.matchString = matchString;
        }

        @Override
        public Object exec(List args) {
            int numArgs = args.size();
            if (numArgs == 0) {
                throw new TemplateModelException("Expecting at least one argument");
            }
            if (numArgs > 2) {
                throw new TemplateModelException("Expecting at most two argumnets");
            }
            String patternString = (String)args.get(0);
            String flagString = numArgs > 1 ? (String)args.get(1) : "";
            Pattern pattern = StringFunctions.getPattern(patternString, flagString);
            Matcher matcher = pattern.matcher(this.matchString);
            return new RegexMatchModel(matcher, this.matchString);
        }
    }

    static class SplitMethod
    implements TemplateMethodModel {
        private String string;

        SplitMethod(String string) {
            this.string = string;
        }

        @Override
        public Object exec(List args) {
            int numArgs = args.size();
            if (numArgs < 1 || numArgs > 2) {
                throw new TemplateModelException("?replace(...) needs 1 or 2 arguments.");
            }
            String splitString = (String)args.get(0);
            String flags = numArgs > 1 ? (String)args.get(1) : "";
            boolean caseInsensitive = flags.indexOf(105) >= 0;
            boolean useRegexp = flags.indexOf(114) >= 0;
            String[] result = null;
            if (!useRegexp) {
                result = StringUtil.split(this.string, splitString, caseInsensitive);
            } else {
                Pattern pattern = StringFunctions.getPattern(splitString, flags);
                result = pattern.split(this.string);
            }
            return ObjectWrapper.DEFAULT_WRAPPER.wrap(result);
        }
    }

    static class SubstringMethod
    implements TemplateMethodModelEx {
        private final String string;

        SubstringMethod(String string) {
            this.string = string;
        }

        @Override
        public Object exec(List args) {
            int argCount = args.size();
            int left = 0;
            int right = 0;
            if (argCount != 1 && argCount != 2) {
                throw new TemplateModelException("Expecting 1 or 2 numerical arguments for ?substring(...)");
            }
            try {
                TemplateNumberModel tnm = (TemplateNumberModel)args.get(0);
                left = tnm.getAsNumber().intValue();
                if (argCount == 2) {
                    tnm = (TemplateNumberModel)args.get(1);
                    right = tnm.getAsNumber().intValue();
                }
            }
            catch (ClassCastException cce) {
                throw new TemplateModelException("Expecting numerical arguments for ?substring(...)");
            }
            if (argCount == 1) {
                return new SimpleScalar(this.string.substring(left));
            }
            return new SimpleScalar(this.string.substring(left, right));
        }
    }

    static class ReplaceMethod
    implements TemplateMethodModel {
        String string;

        ReplaceMethod(String string) {
            this.string = string;
        }

        @Override
        public Object exec(List args) {
            int numArgs = args.size();
            if (numArgs < 2 || numArgs > 3) {
                throw new TemplateModelException("?replace(...) needs 2 or 3 arguments.");
            }
            String first = (String)args.get(0);
            String second = (String)args.get(1);
            String flags = numArgs > 2 ? (String)args.get(2) : "";
            boolean caseInsensitive = flags.indexOf(105) >= 0;
            boolean useRegexp = flags.indexOf(114) >= 0;
            boolean firstOnly = flags.indexOf(102) >= 0;
            String result = null;
            if (!useRegexp) {
                result = StringUtil.replace(this.string, first, second, caseInsensitive, firstOnly);
            } else {
                Pattern pattern = StringFunctions.getPattern(first, flags);
                Matcher matcher = pattern.matcher(this.string);
                result = firstOnly ? matcher.replaceFirst(second) : matcher.replaceAll(second);
            }
            return new SimpleScalar(result);
        }
    }

    public static class Url
    extends StringFunctions {
        @Override
        public TemplateModel apply(String string, Environment env, BuiltInExpression caller) {
            return new urlBIResult(string, env);
        }
    }

    public static class WordList
    extends StringFunctions {
        @Override
        public TemplateModel apply(String string, Environment env, BuiltInExpression caller) {
            StringTokenizer st = new StringTokenizer(string);
            SimpleSequence result = new SimpleSequence();
            while (st.hasMoreTokens()) {
                result.add(st.nextToken());
            }
            return result;
        }
    }

    public static class RightPad
    extends StringFunctions {
        @Override
        public TemplateModel apply(String string, Environment env, BuiltInExpression caller) {
            return new RightPadMethod(string);
        }
    }

    public static class LeftPad
    extends StringFunctions {
        @Override
        public TemplateModel apply(String string, Environment env, BuiltInExpression caller) {
            return new LeftPadMethod(string);
        }
    }

    public static class Contains
    extends StringFunctions {
        @Override
        public TemplateModel apply(String string, Environment env, BuiltInExpression caller) {
            return new ContainsMethod(string);
        }
    }

    public static class LastIndexOf
    extends StringFunctions {
        @Override
        public TemplateModel apply(String string, Environment env, BuiltInExpression caller) {
            return new IndexOfMethod(string, true);
        }
    }

    public static class IndexOf
    extends StringFunctions {
        @Override
        public TemplateModel apply(String string, Environment env, BuiltInExpression caller) {
            return new IndexOfMethod(string, false);
        }
    }

    public static class Matches
    extends StringFunctions {
        @Override
        public TemplateModel apply(String string, Environment env, BuiltInExpression caller) {
            return new MatcherBuilder(string);
        }
    }

    public static class Split
    extends StringFunctions {
        @Override
        public TemplateModel apply(String string, Environment env, BuiltInExpression caller) {
            return new SplitMethod(string);
        }
    }

    public static class Replace
    extends StringFunctions {
        @Override
        public TemplateModel apply(String string, Environment env, BuiltInExpression caller) {
            return new ReplaceMethod(string);
        }
    }

    public static class Substring
    extends StringFunctions {
        @Override
        public TemplateModel apply(String string, Environment env, BuiltInExpression caller) {
            return new SubstringMethod(string);
        }
    }

    public static class EndsWith
    extends StringFunctions {
        @Override
        public TemplateModel apply(String string, Environment env, BuiltInExpression caller) {
            return new StartsOrEndsWithMethod(string, true);
        }
    }

    public static class StartsWith
    extends StringFunctions {
        @Override
        public TemplateModel apply(String string, Environment env, BuiltInExpression caller) {
            return new StartsOrEndsWithMethod(string, false);
        }
    }

    public static class Length
    extends StringFunctions {
        @Override
        public TemplateModel apply(String string, Environment env, BuiltInExpression caller) {
            return new SimpleNumber((Number)string.length());
        }
    }
}

