/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.builtins;

import freemarker.core.Environment;
import freemarker.core.ast.ArithmeticEngine;
import freemarker.core.ast.BuiltInExpression;
import freemarker.core.ast.TemplateNode;
import freemarker.core.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.core.builtins.ModelComparator;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelListSequence;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.StringUtil;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public abstract class SequenceFunctions
extends ExpressionEvaluatingBuiltIn {
    static final int KEY_TYPE_STRING = 1;
    static final int KEY_TYPE_NUMBER = 2;
    static final int KEY_TYPE_DATE = 3;

    @Override
    public TemplateModel get(Environment env, BuiltInExpression caller, TemplateModel model) {
        if (!(model instanceof TemplateSequenceModel)) {
            throw TemplateNode.invalidTypeException(model, caller.getTarget(), env, "sequence");
        }
        return this.apply((TemplateSequenceModel)model);
    }

    public abstract TemplateModel apply(TemplateSequenceModel var1) throws TemplateException;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static TemplateSequenceModel sort(TemplateSequenceModel seq, String[] keys) {
        int keyType;
        int i;
        int keyCnt;
        int ln = seq.size();
        if (ln == 0) {
            return seq;
        }
        ArrayList<Object> res = new ArrayList<Object>(ln);
        TemplateModel item = seq.get(0);
        if (keys != null) {
            keyCnt = keys.length;
            if (keyCnt == 0) {
                keys = null;
            } else {
                for (i = 0; i < keyCnt; ++i) {
                    if (!(item instanceof TemplateHashModel)) {
                        throw new TemplateModelException("sorting failed: " + (i == 0 ? "You can't use ?sort_by when the sequence items are not hashes." : "The subvariable " + StringUtil.jQuote(keys[i - 1]) + " is not a hash, so ?sort_by can't proceed by getting the " + StringUtil.jQuote(keys[i]) + " subvariable."));
                    }
                    if ((item = ((TemplateHashModel)item).get(keys[i])) != null) continue;
                    throw new TemplateModelException("sorting failed: The " + StringUtil.jQuote(keys[i]) + " subvariable " + (keyCnt == 1 ? "was not found." : "(specified by ?sort_by argument number " + (i + 1) + ") was not found."));
                }
            }
        } else {
            keyCnt = 0;
        }
        if (item instanceof TemplateScalarModel) {
            keyType = 1;
        } else if (item instanceof TemplateNumberModel) {
            keyType = 2;
        } else {
            if (!(item instanceof TemplateDateModel)) throw new TemplateModelException("sorting failed: Values used for sorting must be numbers, strings, or date/time values.");
            keyType = 3;
        }
        if (keys == null) {
            if (keyType == 1) {
                for (i = 0; i < ln; ++i) {
                    item = seq.get(i);
                    try {
                        res.add(new KVP(((TemplateScalarModel)item).getAsString(), item));
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        if (item instanceof TemplateScalarModel) throw classCastException;
                        throw new TemplateModelException("Failure of ?sort built-in: All values in the sequence must be strings, because the first value was a string. The value at index " + i + " is not string.");
                    }
                }
            } else if (keyType == 2) {
                for (i = 0; i < ln; ++i) {
                    item = seq.get(i);
                    try {
                        res.add(new KVP(((TemplateNumberModel)item).getAsNumber(), item));
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        if (item instanceof TemplateNumberModel) throw classCastException;
                        throw new TemplateModelException("sorting failed: All values in the sequence must be numbers, because the first value was a number. The value at index " + i + " is not number.");
                    }
                }
            } else {
                if (keyType != 3) throw new RuntimeException("FreeMarker bug: Bad key type");
                for (i = 0; i < ln; ++i) {
                    item = seq.get(i);
                    try {
                        res.add(new KVP(((TemplateDateModel)item).getAsDate(), item));
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        if (item instanceof TemplateNumberModel) throw classCastException;
                        throw new TemplateModelException("sorting failed: All values in the sequence must be date/time values, because the first value was a date/time. The value at index " + i + " is not date/time.");
                    }
                }
            }
        } else {
            for (i = 0; i < ln; ++i) {
                void var8_11;
                TemplateModel templateModel = item = seq.get(i);
                for (int j = 0; j < keyCnt; ++j) {
                    TemplateModel templateModel2;
                    try {
                        templateModel2 = ((TemplateHashModel)var8_11).get(keys[j]);
                    }
                    catch (ClassCastException e) {
                        if (var8_11 instanceof TemplateHashModel) throw e;
                        throw new TemplateModelException("sorting failed: Problem with the sequence item at index " + i + ": Can't get the " + StringUtil.jQuote(keys[j]) + " subvariable, because the value is not a hash.");
                    }
                    if (templateModel2 != null) continue;
                    throw new TemplateModelException("sorting failed Problem with the sequence item at index " + i + ": The " + StringUtil.jQuote(keys[j]) + " subvariable was not found.");
                }
                if (keyType == 1) {
                    try {
                        res.add(new KVP(((TemplateScalarModel)var8_11).getAsString(), item));
                        continue;
                    }
                    catch (ClassCastException e) {
                        if (var8_11 instanceof TemplateScalarModel) throw e;
                        throw new TemplateModelException("sorting failed: All key values in the sequence must be date/time values, because the first key value was a date/time. The key value at index " + i + " is not a date/time.");
                    }
                }
                if (keyType == 2) {
                    try {
                        res.add(new KVP(((TemplateNumberModel)var8_11).getAsNumber(), item));
                        continue;
                    }
                    catch (ClassCastException e) {
                        if (var8_11 instanceof TemplateNumberModel) continue;
                        throw new TemplateModelException("sorting failed: All key values in the sequence must be numbers, because the first key value was a number. The key value at index " + i + " is not a number.");
                    }
                }
                if (keyType != 3) throw new RuntimeException("FreeMarker bug: Bad key type");
                try {
                    res.add(new KVP(((TemplateDateModel)var8_11).getAsDate(), item));
                    continue;
                }
                catch (ClassCastException e) {
                    if (var8_11 instanceof TemplateDateModel) continue;
                    throw new TemplateModelException("sorting failed: All key values in the sequence must be dates, because the first key value was a date. The key value at index " + i + " is not a date.");
                }
            }
        }
        if (keyType == 1) {
            LexicalKVPComparator lexicalKVPComparator = new LexicalKVPComparator(Environment.getCurrentEnvironment().getCollator());
        } else if (keyType == 2) {
            NumericalKVPComparator numericalKVPComparator = new NumericalKVPComparator(Environment.getCurrentEnvironment().getArithmeticEngine());
        } else {
            if (keyType != 3) throw new RuntimeException("FreeMarker bug: Bad key type");
            DateKVPComparator dateKVPComparator = DateKVPComparator.INSTANCE;
        }
        try {
            void var8_17;
            Collections.sort(res, var8_17);
        }
        catch (ClassCastException exc) {
            throw new TemplateModelException("Unexpected error while sorting:" + exc, exc);
        }
        for (i = 0; i < ln; ++i) {
            res.set(i, ((KVP)res.get(i)).value);
        }
        return new TemplateModelListSequence(res);
    }

    static class SequenceIndexOf
    implements TemplateMethodModelEx {
        private final TemplateSequenceModel sequence;
        private final boolean reverse;

        SequenceIndexOf(TemplateSequenceModel sequence, boolean reverse) {
            this.sequence = sequence;
            this.reverse = reverse;
        }

        @Override
        public TemplateModel exec(List args) {
            int startIndex;
            int argc = args.size();
            if (argc != 1 && argc != 2) {
                throw new TemplateModelException("Expecting one or two arguments for ?seq_" + (this.reverse ? "last_" : "") + "index_of");
            }
            TemplateModel compareToThis = (TemplateModel)args.get(0);
            if (argc == 2) {
                try {
                    startIndex = ((TemplateNumberModel)args.get(1)).getAsNumber().intValue();
                }
                catch (ClassCastException cce) {
                    throw new TemplateModelException("Expecting number as second argument to ?seq_" + (this.reverse ? "last_" : "") + "index_of");
                }
            } else {
                startIndex = this.reverse ? this.sequence.size() - 1 : 0;
            }
            Environment env = Environment.getCurrentEnvironment();
            ModelComparator comparator = new ModelComparator(env);
            if (this.reverse) {
                for (int i = startIndex; i > -1; --i) {
                    if (!comparator.modelsEqual(this.sequence.get(i), compareToThis)) continue;
                    return new SimpleNumber(i);
                }
            } else {
                int s = this.sequence.size();
                for (int i = startIndex; i < s; ++i) {
                    if (!comparator.modelsEqual(this.sequence.get(i), compareToThis)) continue;
                    return new SimpleNumber(i);
                }
            }
            return new SimpleNumber(-1);
        }
    }

    static class SortByMethod
    implements TemplateMethodModelEx {
        TemplateSequenceModel seq;

        SortByMethod(TemplateSequenceModel seq) {
            this.seq = seq;
        }

        @Override
        public Object exec(List params) {
            String[] subvars;
            if (params.size() == 0) {
                throw new TemplateModelException("?sort_by(key) needs exactly 1 argument.");
            }
            Object obj = params.get(0);
            if (obj instanceof TemplateScalarModel) {
                subvars = new String[]{((TemplateScalarModel)obj).getAsString()};
            } else if (obj instanceof TemplateSequenceModel) {
                TemplateSequenceModel seq = (TemplateSequenceModel)obj;
                int ln = seq.size();
                subvars = new String[ln];
                for (int i = 0; i < ln; ++i) {
                    TemplateModel item = seq.get(i);
                    try {
                        subvars[i] = ((TemplateScalarModel)item).getAsString();
                        continue;
                    }
                    catch (ClassCastException e) {
                        if (item instanceof TemplateScalarModel) continue;
                        throw new TemplateModelException("The argument to ?sort_by(key), when it is a sequence, must be a sequence of strings, but the item at index " + i + " is not a string.");
                    }
                }
            } else {
                throw new TemplateModelException("The argument to ?sort_by(key) must be a string (the name of the subvariable), or a sequence of strings (the \"path\" to the subvariable).");
            }
            return SequenceFunctions.sort(this.seq, subvars);
        }
    }

    static class DateKVPComparator
    implements Comparator {
        static final DateKVPComparator INSTANCE = new DateKVPComparator();

        DateKVPComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            return ((Date)((KVP)arg0).key).compareTo((Date)((KVP)arg1).key);
        }
    }

    static class LexicalKVPComparator
    implements Comparator {
        private Collator collator;

        LexicalKVPComparator(Collator collator) {
            this.collator = collator;
        }

        public int compare(Object arg0, Object arg1) {
            return this.collator.compare(((KVP)arg0).key, ((KVP)arg1).key);
        }
    }

    static class NumericalKVPComparator
    implements Comparator {
        private ArithmeticEngine ae;

        private NumericalKVPComparator(ArithmeticEngine ae) {
            this.ae = ae;
        }

        public int compare(Object arg0, Object arg1) {
            try {
                return this.ae.compareNumbers((Number)((KVP)arg0).key, (Number)((KVP)arg1).key);
            }
            catch (TemplateException e) {
                throw new ClassCastException("Failed to compare numbers: " + e);
            }
        }
    }

    static class KVP {
        private Object key;
        private Object value;

        private KVP(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }

    static class ChunkedSequence
    implements TemplateSequenceModel {
        private final TemplateSequenceModel wrappedTsm;
        private final int chunkSize;
        private final TemplateModel fillerItem;
        private final int numberOfChunks;

        private ChunkedSequence(TemplateSequenceModel wrappedTsm, int chunkSize, TemplateModel fillerItem) {
            if (chunkSize < 1) {
                throw new TemplateModelException("The 1st argument to ?chunk(...) must be at least 1.");
            }
            this.wrappedTsm = wrappedTsm;
            this.chunkSize = chunkSize;
            this.fillerItem = fillerItem;
            this.numberOfChunks = (wrappedTsm.size() + chunkSize - 1) / chunkSize;
        }

        @Override
        public TemplateModel get(final int chunkIndex) {
            if (chunkIndex >= this.numberOfChunks) {
                return null;
            }
            return new TemplateSequenceModel(){
                private final int baseIndex;
                {
                    this.baseIndex = chunkIndex * chunkSize;
                }

                @Override
                public TemplateModel get(int relIndex) {
                    int absIndex = this.baseIndex + relIndex;
                    if (absIndex < wrappedTsm.size()) {
                        return wrappedTsm.get(absIndex);
                    }
                    return absIndex < numberOfChunks * chunkSize ? fillerItem : null;
                }

                @Override
                public int size() {
                    return fillerItem != null || chunkIndex + 1 < numberOfChunks ? chunkSize : wrappedTsm.size() - this.baseIndex;
                }
            };
        }

        @Override
        public int size() {
            return this.numberOfChunks;
        }
    }

    static class ChunkFunction
    implements TemplateMethodModelEx {
        private final TemplateSequenceModel tsm;

        private ChunkFunction(TemplateSequenceModel tsm) {
            this.tsm = tsm;
        }

        @Override
        public Object exec(List args) {
            int numArgs = args.size();
            if (numArgs != 1 && numArgs != 2) {
                throw new TemplateModelException("?chunk(...) expects 1 or 2 arguments.");
            }
            Object chunkSize = args.get(0);
            if (!(chunkSize instanceof TemplateNumberModel)) {
                throw new TemplateModelException("?chunk(...) expects a number as its 1st argument.");
            }
            return new ChunkedSequence(this.tsm, ((TemplateNumberModel)chunkSize).getAsNumber().intValue(), numArgs > 1 ? (TemplateModel)args.get(1) : null);
        }
    }

    static class ReverseSequence
    implements TemplateSequenceModel {
        private final TemplateSequenceModel seq;

        ReverseSequence(TemplateSequenceModel seq) {
            this.seq = seq;
        }

        @Override
        public int size() {
            return this.seq.size();
        }

        @Override
        public TemplateModel get(int index) {
            return this.seq.get(this.seq.size() - 1 - index);
        }
    }

    public static class LastIndexOf
    extends SequenceFunctions {
        @Override
        public boolean isSideEffectFree() {
            return false;
        }

        @Override
        public TemplateModel apply(TemplateSequenceModel sequence) {
            return new SequenceIndexOf(sequence, true);
        }
    }

    public static class IndexOf
    extends SequenceFunctions {
        @Override
        public boolean isSideEffectFree() {
            return false;
        }

        @Override
        public TemplateModel apply(TemplateSequenceModel sequence) {
            return new SequenceIndexOf(sequence, false);
        }
    }

    public static class Chunk
    extends SequenceFunctions {
        @Override
        public TemplateModel apply(TemplateSequenceModel sequence) {
            return new ChunkFunction(sequence);
        }
    }

    public static class SortBy
    extends SequenceFunctions {
        @Override
        public boolean isSideEffectFree() {
            return false;
        }

        @Override
        public TemplateModel apply(TemplateSequenceModel sequence) {
            return new SortByMethod(sequence);
        }
    }

    public static class Sort
    extends SequenceFunctions {
        @Override
        public boolean isSideEffectFree() {
            return false;
        }

        @Override
        public TemplateModel apply(TemplateSequenceModel sequence) {
            return Sort.sort(sequence, null);
        }
    }

    public static class Reverse
    extends SequenceFunctions {
        @Override
        public TemplateModel apply(TemplateSequenceModel sequence) {
            return new ReverseSequence(sequence);
        }
    }

    public static class Last
    extends SequenceFunctions {
        @Override
        public TemplateModel apply(TemplateSequenceModel sequence) {
            return sequence.size() > 0 ? sequence.get(sequence.size() - 1) : null;
        }
    }

    public static class First
    extends SequenceFunctions {
        @Override
        public TemplateModel apply(TemplateSequenceModel sequence) {
            return sequence.size() > 0 ? sequence.get(0) : null;
        }
    }
}

