/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.builtins;

import freemarker.core.Environment;
import freemarker.core.ast.ArithmeticEngine;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import java.text.Collator;
import java.util.Date;

public class ModelComparator {
    private final ArithmeticEngine arithmeticEngine;
    private final Collator collator;

    public ModelComparator(Environment env) {
        this.arithmeticEngine = env.getArithmeticEngine();
        this.collator = env.getCollator();
    }

    public boolean modelsEqual(TemplateModel model1, TemplateModel model2) {
        if (model1 instanceof TemplateNumberModel && model2 instanceof TemplateNumberModel) {
            try {
                return this.arithmeticEngine.compareNumbers(((TemplateNumberModel)model1).getAsNumber(), ((TemplateNumberModel)model2).getAsNumber()) == 0;
            }
            catch (TemplateException ex) {
                throw new TemplateModelException(ex);
            }
        }
        if (model1 instanceof TemplateDateModel && model2 instanceof TemplateDateModel) {
            Date second;
            int rtype;
            TemplateDateModel ltdm = (TemplateDateModel)model1;
            TemplateDateModel rtdm = (TemplateDateModel)model2;
            int ltype = ltdm.getDateType();
            if (ltype != (rtype = rtdm.getDateType())) {
                throw new TemplateModelException("Can not compare dates of different type. Left date is of " + TemplateDateModel.TYPE_NAMES.get(ltype) + " type, right date is of " + TemplateDateModel.TYPE_NAMES.get(rtype) + " type.");
            }
            if (ltype == 0) {
                throw new TemplateModelException("Left date is of UNKNOWN type, and can not be compared.");
            }
            if (rtype == 0) {
                throw new TemplateModelException("Right date is of UNKNOWN type, and can not be compared.");
            }
            Date first = ltdm.getAsDate();
            return first.compareTo(second = rtdm.getAsDate()) == 0;
        }
        if (model1 instanceof TemplateScalarModel && model2 instanceof TemplateScalarModel) {
            return this.collator.compare(((TemplateScalarModel)model1).getAsString(), ((TemplateScalarModel)model2).getAsString()) == 0;
        }
        if (model1 instanceof TemplateBooleanModel && model2 instanceof TemplateBooleanModel) {
            return ((TemplateBooleanModel)model1).getAsBoolean() == ((TemplateBooleanModel)model2).getAsBoolean();
        }
        return false;
    }
}

