/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.ArgsList;
import freemarker.core.ast.Expression;
import freemarker.core.ast.OOParamElement;
import freemarker.core.ast.ParameterList;
import freemarker.core.ast.TemplateNode;
import freemarker.template.LazilyEvaluatableArguments;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.UndeclaredThrowableException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PositionalArgsList
extends ArgsList {
    List<Expression> args = new ArrayList<Expression>();

    public List<Expression> getArgs() {
        return this.args;
    }

    public void addArg(Expression exp) {
        this.args.add(exp);
        exp.parent = this;
    }

    @Override
    Map<String, TemplateModel> getParameterMap(TemplateModel target, Environment env) {
        Map<String, TemplateModel> result = new HashMap<String, TemplateModel>();
        ParameterList annotatedParameterList = PositionalArgsList.getParameterList(target);
        if (annotatedParameterList == null) {
            if (!this.args.isEmpty()) {
                throw new TemplateModelException("Cannot pass positional arguments to this TemplateTransformModel");
            }
        } else {
            result = annotatedParameterList.getParameterMap(this, env, false);
        }
        return result;
    }

    @Override
    List getParameterSequence(TemplateModel target, Environment env) {
        ParameterList annotatedParameterList = PositionalArgsList.getParameterList(target);
        if (annotatedParameterList == null) {
            return target instanceof TemplateMethodModelEx ? (target instanceof LazilyEvaluatableArguments ? this.getLazyModelList(env) : this.getModelList(env)) : (target instanceof LazilyEvaluatableArguments ? this.getLazyValueList(env) : this.getValueList(env));
        }
        List<TemplateModel> result = annotatedParameterList.getParameterSequence(this, env);
        if (target instanceof TemplateMethodModel && !(target instanceof TemplateMethodModelEx)) {
            ArrayList<String> strings = new ArrayList<String>();
            for (int i = 0; i < result.size(); ++i) {
                TemplateModel value = result.get(i);
                Expression exp = i < this.args.size() ? this.args.get(i) : annotatedParameterList.getDefaultExpression(i);
                strings.add(Expression.getStringValue(value, exp, env));
            }
            return strings;
        }
        return result;
    }

    @Override
    public int size() {
        return this.args == null ? 0 : this.args.size();
    }

    @Override
    public String getStartLocation() {
        if (this.args != null && this.args.size() > 0) {
            return this.args.get(0).getStartLocation();
        }
        return "";
    }

    public TemplateModel getValueAt(int i, Environment env) {
        Expression exp = this.args.get(i);
        TemplateModel value = exp.getAsTemplateModel(env);
        TemplateNode.assertIsDefined(value, exp, env);
        return value;
    }

    private List getList(Environment env, ExpressionTransformator transformator) {
        int size = this.args.size();
        switch (size) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections.singletonList(transformator.transform(this.args.get(0), env));
            }
        }
        ArrayList<Object> result = new ArrayList<Object>(this.args.size());
        for (Expression arg : this.args) {
            result.add(transformator.transform(arg, env));
        }
        return result;
    }

    List getValueList(Environment env) {
        return this.getList(env, ToValueTransformator.INSTANCE);
    }

    List getModelList(Environment env) {
        return this.getList(env, ToModelTransformator.INSTANCE);
    }

    List getLazyValueList(Environment env) {
        return new LazyEvaluationList(ToValueTransformator.INSTANCE, env);
    }

    List getLazyModelList(Environment env) {
        return new LazyEvaluationList(ToModelTransformator.INSTANCE, env);
    }

    @Override
    ArgsList deepClone(String name, Expression subst) {
        PositionalArgsList result = new PositionalArgsList();
        for (Expression arg : this.args) {
            result.addArg(arg.deepClone(name, subst));
        }
        return result;
    }

    @Override
    void addOOParamArg(OOParamElement param) {
        this.addArg(param.asExp());
    }

    private class LazyEvaluationList
    extends AbstractList {
        private final ExpressionTransformator transformator;
        private final Environment env;
        private final Object[] resolvedValues;
        private final boolean[] resolved;

        LazyEvaluationList(ExpressionTransformator transformator, Environment env) {
            this.transformator = transformator;
            this.env = env;
            int size = PositionalArgsList.this.args.size();
            this.resolvedValues = new Object[size];
            this.resolved = new boolean[size];
        }

        @Override
        public int size() {
            return this.resolvedValues.length;
        }

        @Override
        public Object get(int index) {
            if (this.resolved[index]) {
                return this.resolvedValues[index];
            }
            Expression exp = PositionalArgsList.this.args.get(index);
            try {
                Object obj = this.transformator.transform(exp, this.env);
                this.resolved[index] = true;
                this.resolvedValues[index] = obj;
                return this.resolvedValues[index];
            }
            catch (TemplateException e) {
                throw new UndeclaredThrowableException(e);
            }
        }
    }

    private static class ToModelTransformator
    extends ExpressionTransformator {
        static final ExpressionTransformator INSTANCE = new ToModelTransformator();

        private ToModelTransformator() {
        }

        @Override
        Object transform(Expression exp, Environment env) {
            return exp.getAsTemplateModel(env);
        }
    }

    private static class ToValueTransformator
    extends ExpressionTransformator {
        static final ExpressionTransformator INSTANCE = new ToValueTransformator();

        private ToValueTransformator() {
        }

        @Override
        Object transform(Expression exp, Environment env) {
            return exp.getStringValue(env);
        }
    }

    private static abstract class ExpressionTransformator {
        private ExpressionTransformator() {
        }

        abstract Object transform(Expression var1, Environment var2) throws TemplateException;
    }
}

