/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.Expression;
import freemarker.core.ast.Identifier;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;

public class Dot
extends Expression {
    private Expression target;
    private String key;

    public Dot(Expression target, String key) {
        this.target = target;
        target.parent = this;
        this.key = key;
    }

    public Expression getTarget() {
        return this.target;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        TemplateModel leftModel = this.target.getAsTemplateModel(env);
        if (leftModel instanceof TemplateHashModel) {
            return ((TemplateHashModel)leftModel).get(this.key);
        }
        throw Dot.invalidTypeException(leftModel, this.target, env, "hash");
    }

    @Override
    boolean isLiteral() {
        return this.target.isLiteral();
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        return new Dot(this.target.deepClone(name, subst), this.key);
    }

    public boolean onlyHasIdentifiers() {
        return this.target instanceof Identifier || this.target instanceof Dot && ((Dot)this.target).onlyHasIdentifiers();
    }
}

