/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.Expression;
import freemarker.core.ast.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;

public class ConditionalBlock
extends TemplateElement {
    private Expression condition;
    private boolean isFirst;
    boolean isSimple;

    public ConditionalBlock(Expression condition, TemplateElement nestedBlock, boolean isFirst) {
        this.condition = condition;
        this.nestedBlock = nestedBlock;
        this.isFirst = isFirst;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    @Override
    public void execute(Environment env) throws TemplateException, IOException {
        if (this.isSimple && this.condition != null && !this.condition.isTrue(env)) {
            return;
        }
        env.render(this.nestedBlock);
    }

    public boolean isLoneIfBlock() {
        return this.isSimple;
    }

    public void setIsSimple(boolean isSimple) {
        this.isSimple = isSimple;
    }

    @Override
    public String getDescription() {
        String s = "if ";
        if (this.condition == null) {
            s = "else ";
        } else if (!this.isFirst) {
            s = "elseif ";
        }
        String cond = this.condition != null ? this.condition.toString() : "";
        return s + cond;
    }
}

