/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.Expression;
import freemarker.core.ast.Macro;
import freemarker.core.parser.ParseException;
import freemarker.template.Configuration;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;

public class BuiltinVariable
extends Expression {
    static final String TEMPLATE_NAME = "template_name";
    static final String NAMESPACE = "namespace";
    static final String MAIN = "main";
    static final String GLOBALS = "globals";
    static final String LOCALS = "locals";
    static final String DATA_MODEL = "data_model";
    static final String LANG = "lang";
    static final String LOCALE = "locale";
    static final String CURRENT_NODE = "current_node";
    static final String NODE = "node";
    static final String PASS = "pass";
    static final String VARS = "vars";
    static final String VERSION = "version";
    static final String ERROR = "error";
    static final String OUTPUT_ENCODING = "output_encoding";
    static final String SCOPE = "scope";
    static final String URL_ESCAPING_CHARSET = "url_escaping_charset";
    private String name;

    public BuiltinVariable(String name) {
        this.name = name = name.intern();
        if (name != NAMESPACE && name != TEMPLATE_NAME && name != MAIN && name != GLOBALS && name != LOCALS && name != LANG && name != LOCALE && name != DATA_MODEL && name != CURRENT_NODE && name != NODE && name != PASS && name != VARS && name != SCOPE && name != VERSION && name != OUTPUT_ENCODING && name != URL_ESCAPING_CHARSET && name != ERROR) {
            throw new ParseException("Unknown built-in variable: " + name, this);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) {
        if (this.name == NAMESPACE) {
            return env.getCurrentNamespace();
        }
        if (this.name == MAIN) {
            return env.getMainNamespace();
        }
        if (this.name == GLOBALS) {
            return env;
        }
        if (this.name == LOCALS) {
            return env.getCurrentMacroContext();
        }
        if (this.name == DATA_MODEL) {
            return env.getDataModel();
        }
        if (this.name == SCOPE) {
            return env.getCurrentScope();
        }
        if (this.name == VARS) {
            return new VarsHash(env);
        }
        if (this.name == LOCALE) {
            return new SimpleScalar(env.getLocale().toString());
        }
        if (this.name == LANG) {
            return new SimpleScalar(env.getLocale().getLanguage());
        }
        if (this.name == CURRENT_NODE || this.name == NODE) {
            return env.getCurrentVisitorNode();
        }
        if (this.name == PASS) {
            return Macro.DO_NOTHING_MACRO;
        }
        if (this.name == TEMPLATE_NAME) {
            return new SimpleScalar(env.getTemplate().getName());
        }
        if (this.name == VERSION) {
            return new SimpleScalar(Configuration.getVersionNumber());
        }
        if (this.name == OUTPUT_ENCODING) {
            String s = env.getOutputEncoding();
            return s != null ? new SimpleScalar(s) : null;
        }
        if (this.name == URL_ESCAPING_CHARSET) {
            String s = env.getURLEscapingCharset();
            return s != null ? new SimpleScalar(s) : null;
        }
        if (this.name == ERROR) {
            return new SimpleScalar(env.getCurrentRecoveredErrorMessage());
        }
        throw new TemplateException("Invalid built-in variable: " + this, env);
    }

    @Override
    public String toString() {
        return "." + this.name;
    }

    @Override
    boolean isLiteral() {
        return false;
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        return this;
    }

    static class VarsHash
    implements TemplateHashModel {
        private final Environment env;

        VarsHash(Environment env) {
            this.env = env;
        }

        @Override
        public TemplateModel get(String key) {
            return this.env.getVariable(key);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }
}

