/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.ArithmeticEngine;
import freemarker.core.ast.EvaluationUtil;
import freemarker.core.ast.Expression;
import freemarker.core.ast.NonNumericalException;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;

public class ArithmeticExpression
extends Expression {
    public static final int SUBTRACTION = 0;
    public static final int MULTIPLICATION = 1;
    public static final int DIVISION = 2;
    public static final int MODULUS = 3;
    private Expression left;
    private Expression right;
    private int operation;

    public ArithmeticExpression(Expression left, Expression right, int operation) {
        this.left = left;
        this.right = right;
        this.operation = operation;
        left.parent = this;
        right.parent = this;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public int getOperation() {
        return this.operation;
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        boolean bothNumbers;
        TemplateModel leftModel = this.left.getAsTemplateModel(env);
        TemplateModel rightModel = this.right.getAsTemplateModel(env);
        boolean leftIsNumber = leftModel instanceof TemplateNumberModel;
        boolean rightIsNumber = rightModel instanceof TemplateNumberModel;
        boolean bl = bothNumbers = leftIsNumber && rightIsNumber;
        if (!bothNumbers) {
            String msg = "Error " + this.getStartLocation();
            if (!leftIsNumber) {
                msg = msg + "\nExpression " + this.left + " is not numerical";
            }
            if (!rightIsNumber) {
                msg = msg + "\nExpression " + this.right + " is not numerical";
            }
            throw new NonNumericalException(msg, env);
        }
        Number first = EvaluationUtil.getNumber(leftModel, this.left, env);
        Number second = EvaluationUtil.getNumber(rightModel, this.right, env);
        ArithmeticEngine ae = env != null ? env.getArithmeticEngine() : this.getTemplate().getArithmeticEngine();
        switch (this.operation) {
            case 0: {
                return new SimpleNumber(ae.subtract(first, second));
            }
            case 1: {
                return new SimpleNumber(ae.multiply(first, second));
            }
            case 2: {
                return new SimpleNumber(ae.divide(first, second));
            }
            case 3: {
                return new SimpleNumber(ae.modulus(first, second));
            }
        }
        throw new TemplateException("unknown operation : " + this.operation, env);
    }

    @Override
    boolean isLiteral() {
        return this.constantValue != null || this.left.isLiteral() && this.right.isLiteral();
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        return new ArithmeticExpression(this.left.deepClone(name, subst), this.right.deepClone(name, subst), this.operation);
    }
}

