/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BreakException;
import freemarker.core.Configurable;
import freemarker.core.IncludedTemplateNamespace;
import freemarker.core.InvalidReferenceException;
import freemarker.core.LoopContext;
import freemarker.core.MacroContext;
import freemarker.core.MacroInvocationBodyContext;
import freemarker.core.ReturnException;
import freemarker.core.Scope;
import freemarker.core.StopException;
import freemarker.core.TemplateNamespace;
import freemarker.core.TemplateRunnable;
import freemarker.core.UndeclaredVariableException;
import freemarker.core.ast.ArgsList;
import freemarker.core.ast.Expression;
import freemarker.core.ast.Identifier;
import freemarker.core.ast.Include;
import freemarker.core.ast.Macro;
import freemarker.core.ast.ParameterList;
import freemarker.core.ast.TemplateElement;
import freemarker.core.ast.TemplateNode;
import freemarker.core.ast.UnifiedCall;
import freemarker.core.helpers.NamedParameterListScope;
import freemarker.core.parser.ParseException;
import freemarker.core.parser.ParsingProblem;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.SimpleCollection;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.Template;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.TemplateTransformModel;
import freemarker.template.TransformControl;
import freemarker.template.utility.UndeclaredThrowableException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class Environment
extends Configurable
implements Scope {
    private static final ThreadLocal<Environment> threadEnv = new ThreadLocal();
    static final Logger logger = Logger.getLogger("freemarker.runtime");
    private static final Logger attemptLogger = Logger.getLogger("freemarker.runtime.attempt");
    private static final Map<NumberFormatKey, NumberFormat> localizedNumberFormats = new HashMap<NumberFormatKey, NumberFormat>();
    private static final Map<DateFormatKey, DateFormat> localizedDateFormats = new HashMap<DateFormatKey, DateFormat>();
    private static final DecimalFormat C_NUMBER_FORMAT = new DecimalFormat("0.################", new DecimalFormatSymbols(Locale.US));
    private final TemplateHashModel rootDataModel;
    private final List<TemplateElement> elementStack = new ArrayList<TemplateElement>();
    private final List<String> recoveredErrorStack = new ArrayList<String>();
    private NumberFormat numberFormat;
    private Map<String, NumberFormat> numberFormats;
    private DateFormat timeFormat;
    private DateFormat dateFormat;
    private DateFormat dateTimeFormat;
    private Map<String, DateFormat>[] dateFormats;
    private NumberFormat cNumberFormat;
    private Collator collator;
    private Writer out;
    private MacroContext currentMacroContext;
    private TemplateNamespace mainNamespace;
    private Scope currentScope;
    private Map<Macro, MacroContext> macroContextLookup = new HashMap<Macro, MacroContext>();
    private Map<Macro, TemplateNamespace> macroToNamespaceLookup = new HashMap<Macro, TemplateNamespace>();
    private HashMap<String, TemplateModel> globalVariables = new HashMap();
    private HashMap<String, TemplateNamespace> loadedLibs;
    private Throwable lastThrowable;
    private TemplateModel lastReturnValue;
    private TemplateNodeModel currentVisitorNode;
    private TemplateSequenceModel nodeNamespaces;
    private int nodeNamespaceIndex;
    private String currentNodeName;
    private String currentNodeNS;
    private String cachedURLEscapingCharset;
    private boolean urlEscapingCharsetCached;
    private static final TemplateModel[] NO_OUT_ARGS;
    public static final Writer NULL_WRITER;
    private static final Writer EMPTY_BODY_WRITER;

    public static Environment getCurrentEnvironment() {
        return threadEnv.get();
    }

    public Environment(Template template, TemplateHashModel rootDataModel, Writer out) {
        super(template);
        this.mainNamespace = new TemplateNamespace(this, template);
        this.currentScope = this.mainNamespace;
        this.out = out;
        this.rootDataModel = rootDataModel;
        this.importMacros(template);
    }

    @Override
    public Template getTemplate() {
        return (Template)this.getParent();
    }

    private void clearCachedValues() {
        this.numberFormats = null;
        this.numberFormat = null;
        this.dateFormats = null;
        this.collator = null;
        this.cachedURLEscapingCharset = null;
        this.urlEscapingCharsetCached = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws TemplateException, IOException {
        Environment savedEnv = threadEnv.get();
        threadEnv.set(this);
        try {
            this.clearCachedValues();
            try {
                this.doAutoImportsAndIncludes(this);
                Template template = this.getTemplate();
                this.render(template.getRootElement());
                this.out.flush();
            }
            finally {
                this.clearCachedValues();
            }
        }
        finally {
            threadEnv.set(savedEnv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(TemplateElement element) throws TemplateException, IOException {
        this.pushElement(element);
        boolean createNewScope = element.createsScope();
        Scope prevScope = this.currentScope;
        if (createNewScope) {
            this.currentScope = element.createLocalScope(this.currentScope);
        }
        try {
            element.execute(this);
        }
        catch (TemplateException te) {
            this.handleTemplateException(te);
        }
        finally {
            this.popElement();
            this.currentScope = prevScope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(final TemplateElement element, TemplateDirectiveModel directiveModel, Map<String, TemplateModel> args, List<String> bodyParameterNames) throws TemplateException, IOException {
        TemplateDirectiveBody nested = null;
        boolean createsNewScope = false;
        if (element != null) {
            createsNewScope = element.getParent().createsScope();
            nested = new TemplateDirectiveBody(){

                @Override
                public void render(Writer newOut) throws TemplateException, IOException {
                    Writer prevOut = Environment.this.out;
                    Environment.this.out = newOut;
                    try {
                        Environment.this.render(element);
                    }
                    finally {
                        Environment.this.out = prevOut;
                    }
                }
            };
        }
        TemplateModel[] outArgs = bodyParameterNames == null || bodyParameterNames.isEmpty() ? NO_OUT_ARGS : new TemplateModel[bodyParameterNames.size()];
        Scope scope = this.currentScope;
        if (createsNewScope) {
            this.currentScope = new NamedParameterListScope(scope, bodyParameterNames, Arrays.asList(outArgs), true);
        }
        try {
            directiveModel.execute(this, args, outArgs, nested);
        }
        finally {
            this.currentScope = scope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(TemplateElement element, TemplateTransformModel transform, Map<String, TemplateModel> args) throws TemplateException, IOException {
        block17: {
            try {
                Writer tw = transform.getWriter(this.out, args);
                if (tw == null) {
                    tw = EMPTY_BODY_WRITER;
                }
                TransformControl tc = tw instanceof TransformControl ? (TransformControl)((Object)tw) : null;
                Writer prevOut = this.out;
                this.out = tw;
                try {
                    if (tc == null || tc.onStart() != 0) {
                        do {
                            if (element == null) continue;
                            this.render(element);
                        } while (tc != null && tc.afterBody() == 0);
                    }
                }
                catch (Throwable t) {
                    try {
                        if (tc != null) {
                            tc.onError(t);
                            break block17;
                        }
                        throw t;
                    }
                    catch (TemplateException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new UndeclaredThrowableException(e);
                    }
                }
                finally {
                    this.out = prevOut;
                    tw.close();
                }
            }
            catch (TemplateException te) {
                this.handleTemplateException(te);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(TemplateElement attemptBlock, TemplateElement recoveryBlock, List<ParsingProblem> parsingProblems) throws TemplateException, IOException {
        Writer prevOut = this.out;
        StringWriter sw = new StringWriter();
        this.out = sw;
        TemplateException thrownException = null;
        try {
            if (!parsingProblems.isEmpty()) {
                throw new TemplateException(new ParseException(parsingProblems), this);
            }
            this.render(attemptBlock);
        }
        catch (TemplateException te) {
            thrownException = te;
        }
        finally {
            this.out = prevOut;
        }
        if (thrownException != null) {
            if (attemptLogger.isDebugEnabled()) {
                logger.debug("Error in attempt block " + attemptBlock.getStartLocation(), thrownException);
            }
            try {
                this.recoveredErrorStack.add(thrownException.getMessage());
                this.render(recoveryBlock);
            }
            finally {
                this.recoveredErrorStack.remove(this.recoveredErrorStack.size() - 1);
            }
        } else {
            this.out.write(sw.toString());
        }
    }

    public String getCurrentRecoveredErrorMessage() {
        if (this.recoveredErrorStack.isEmpty()) {
            throw new TemplateException(".error is not available outside of a <#recover> block", this);
        }
        return this.recoveredErrorStack.get(this.recoveredErrorStack.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(MacroInvocationBodyContext bctxt) throws TemplateException, IOException {
        MacroContext invokingMacroContext = this.getCurrentMacroContext();
        TemplateElement body = invokingMacroContext.body;
        if (body != null) {
            this.currentMacroContext = invokingMacroContext.invokingMacroContext;
            Configurable prevParent = this.getParent();
            Scope prevScope = this.currentScope;
            this.setParent(this.getCurrentNamespace().getTemplate());
            this.currentScope = bctxt;
            try {
                this.render(body);
            }
            finally {
                this.currentScope = prevScope;
                this.currentMacroContext = invokingMacroContext;
                this.setParent(prevParent);
                this.currentScope = prevScope;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(LoopContext ictxt) throws IOException {
        Scope prevScope = this.currentScope;
        this.currentScope = ictxt;
        try {
            ictxt.runLoop();
        }
        catch (BreakException breakException) {
        }
        catch (TemplateException te) {
            this.handleTemplateException(te);
        }
        finally {
            this.currentScope = prevScope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(TemplateNodeModel node, TemplateSequenceModel namespaces) throws TemplateException, IOException {
        block15: {
            if (this.nodeNamespaces == null) {
                SimpleSequence ss = new SimpleSequence(1);
                ss.add(this.getCurrentNamespace());
                this.nodeNamespaces = ss;
            }
            int prevNodeNamespaceIndex = this.nodeNamespaceIndex;
            String prevNodeName = this.currentNodeName;
            String prevNodeNS = this.currentNodeNS;
            TemplateSequenceModel prevNodeNamespaces = this.nodeNamespaces;
            TemplateNodeModel prevVisitorNode = this.currentVisitorNode;
            this.currentVisitorNode = node;
            if (namespaces != null) {
                this.nodeNamespaces = namespaces;
            }
            try {
                TemplateModel macroOrTransform = this.getNodeProcessor(node);
                if (macroOrTransform instanceof Macro) {
                    this.render((Macro)macroOrTransform, (ArgsList)null, null, null);
                    break block15;
                }
                if (macroOrTransform instanceof TemplateTransformModel) {
                    this.render(null, (TemplateTransformModel)macroOrTransform, null);
                    break block15;
                }
                String nodeType = node.getNodeType();
                if (nodeType != null) {
                    if (nodeType.equals("text") && node instanceof TemplateScalarModel) {
                        this.out.write(((TemplateScalarModel)((Object)node)).getAsString());
                    } else if (nodeType.equals("document")) {
                        this.process(node, namespaces);
                    } else if (!(nodeType.equals("pi") || nodeType.equals("comment") || nodeType.equals("document_type"))) {
                        String nsBit = "";
                        String ns = node.getNodeNamespace();
                        if (ns != null) {
                            nsBit = ns.length() > 0 ? " and namespace " + ns : " and no namespace";
                        }
                        throw new TemplateException("No macro or transform defined for node named " + node.getNodeName() + nsBit + ", and there is no fallback handler called @" + nodeType + " either.", this);
                    }
                    break block15;
                }
                String nsBit = "";
                String ns = node.getNodeNamespace();
                if (ns != null) {
                    nsBit = ns.length() > 0 ? " and namespace " + ns : " and no namespace";
                }
                throw new TemplateException("No macro or transform defined for node with name " + node.getNodeName() + nsBit + ", and there is no macro or transform called @default either.", this);
            }
            finally {
                this.currentVisitorNode = prevVisitorNode;
                this.nodeNamespaceIndex = prevNodeNamespaceIndex;
                this.currentNodeName = prevNodeName;
                this.currentNodeNS = prevNodeNS;
                this.nodeNamespaces = prevNodeNamespaces;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runInScope(Scope scope, TemplateRunnable<T> runnable) throws TemplateException, IOException {
        Scope currentScope = this.currentScope;
        this.currentScope = scope;
        try {
            T t = runnable.run();
            return t;
        }
        finally {
            this.currentScope = currentScope;
        }
    }

    public void fallback() throws TemplateException, IOException {
        TemplateModel macroOrTransform = this.getNodeProcessor(this.currentNodeName, this.currentNodeNS, this.nodeNamespaceIndex);
        if (macroOrTransform instanceof Macro) {
            this.render((Macro)macroOrTransform, (ArgsList)null, null, null);
        } else if (macroOrTransform instanceof TemplateTransformModel) {
            this.render(null, (TemplateTransformModel)macroOrTransform, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void render(Macro macro, ArgsList args, ParameterList bodyParameters, TemplateElement nestedBlock) throws TemplateException, IOException {
        block17: {
            if (macro == Macro.DO_NOTHING_MACRO) {
                return;
            }
            this.pushElement(macro);
            try {
                MacroContext mc = new MacroContext(macro, this, nestedBlock, bodyParameters);
                MacroContext prevMc = this.macroContextLookup.get(macro);
                this.macroContextLookup.put(macro, mc);
                if (args != null) {
                    Map<String, TemplateModel> argsMap = macro.getParams().getParameterMap(args, this);
                    for (Map.Entry<String, TemplateModel> entry : argsMap.entrySet()) {
                        mc.put(entry.getKey(), entry.getValue());
                    }
                }
                Scope prevScope = this.currentScope;
                Configurable prevParent = this.getParent();
                this.currentMacroContext = mc;
                this.currentScope = this.currentMacroContext;
                try {
                    mc.runMacro();
                }
                catch (ReturnException entry) {
                    if (prevMc != null) {
                        this.macroContextLookup.put(macro, prevMc);
                    } else {
                        this.macroContextLookup.remove(macro);
                    }
                    this.currentMacroContext = mc.invokingMacroContext;
                    this.currentScope = prevScope;
                    this.setParent(prevParent);
                }
                catch (TemplateException te) {
                    this.handleTemplateException(te);
                    break block17;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (prevMc != null) {
                        this.macroContextLookup.put(macro, prevMc);
                    } else {
                        this.macroContextLookup.remove(macro);
                    }
                    this.currentMacroContext = mc.invokingMacroContext;
                    this.currentScope = prevScope;
                    this.setParent(prevParent);
                }
            }
            finally {
                this.popElement();
            }
        }
    }

    public void visitMacroDef(Macro macro) {
        if (this.currentMacroContext == null) {
            this.macroToNamespaceLookup.put(macro, this.getCurrentNamespace());
            this.unqualifiedSet(macro.getName(), macro);
        }
    }

    public TemplateNamespace getMacroNamespace(Macro macro) {
        TemplateNamespace result = this.macroToNamespaceLookup.get(macro);
        if (result == null) {
            result = this.mainNamespace;
        }
        return result;
    }

    public MacroContext getMacroContext(Macro macro) {
        return this.macroContextLookup.get(macro);
    }

    public void setCurriedMacroNamespace(Macro curriedMacro, Macro baseMacro) {
        TemplateNamespace tns = this.macroToNamespaceLookup.get(baseMacro);
        this.macroToNamespaceLookup.put(curriedMacro, tns);
    }

    public void process(TemplateNodeModel node, TemplateSequenceModel namespaces) throws TemplateException, IOException {
        if (node == null && (node = this.getCurrentVisitorNode()) == null) {
            throw new TemplateModelException("The target node of recursion is missing or null.");
        }
        TemplateSequenceModel children = node.getChildNodes();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            TemplateNodeModel child = (TemplateNodeModel)children.get(i);
            if (child == null) continue;
            this.render(child, namespaces);
        }
    }

    public MacroContext getCurrentMacroContext() {
        return this.currentMacroContext;
    }

    private void handleTemplateException(TemplateException te) {
        if (this.lastThrowable == te) {
            throw te;
        }
        this.lastThrowable = te;
        if (logger.isErrorEnabled()) {
            logger.error(te.getMessage(), te);
        }
        if (te instanceof StopException) {
            throw te;
        }
        this.getTemplateExceptionHandler().handleTemplateException(te, this, this.out);
    }

    @Override
    public void setTemplateExceptionHandler(TemplateExceptionHandler templateExceptionHandler) {
        super.setTemplateExceptionHandler(templateExceptionHandler);
        this.lastThrowable = null;
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.numberFormats = null;
        this.numberFormat = null;
        this.dateFormats = null;
        this.dateTimeFormat = null;
        this.dateFormat = null;
        this.timeFormat = null;
        this.collator = null;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        super.setTimeZone(timeZone);
        this.dateFormats = null;
        this.dateTimeFormat = null;
        this.dateFormat = null;
        this.timeFormat = null;
    }

    @Override
    public void setURLEscapingCharset(String urlEscapingCharset) {
        this.urlEscapingCharsetCached = false;
        super.setURLEscapingCharset(urlEscapingCharset);
    }

    @Override
    public void setOutputEncoding(String outputEncoding) {
        this.urlEscapingCharsetCached = false;
        super.setOutputEncoding(outputEncoding);
    }

    public String getEffectiveURLEscapingCharset() {
        if (!this.urlEscapingCharsetCached) {
            this.cachedURLEscapingCharset = this.getURLEscapingCharset();
            if (this.cachedURLEscapingCharset == null) {
                this.cachedURLEscapingCharset = this.getOutputEncoding();
            }
            this.urlEscapingCharsetCached = true;
        }
        return this.cachedURLEscapingCharset;
    }

    public Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance(this.getLocale());
        }
        return this.collator;
    }

    public void setOut(Writer out) {
        this.out = out;
    }

    public Writer getOut() {
        return this.out;
    }

    public String formatNumber(Number number) {
        if (this.numberFormat == null) {
            this.numberFormat = this.getNumberFormatObject(this.getNumberFormat());
        }
        return this.numberFormat.format(number);
    }

    @Override
    public void setNumberFormat(String formatName) {
        super.setNumberFormat(formatName);
        this.numberFormat = null;
    }

    public String formatDate(Date date, int type) {
        DateFormat df = this.getDateFormatObject(type);
        if (df == null) {
            throw new TemplateModelException("Can't convert the date to string, because it is not known which parts of the date variable are in use. Use ?date, ?time or ?datetime built-in, or ?string.<format> or ?string(format) built-in with this date.");
        }
        return df.format(date);
    }

    @Override
    public void setTimeFormat(String formatName) {
        super.setTimeFormat(formatName);
        this.timeFormat = null;
    }

    @Override
    public void setDateFormat(String formatName) {
        super.setDateFormat(formatName);
        this.dateFormat = null;
    }

    @Override
    public void setDateTimeFormat(String formatName) {
        super.setDateTimeFormat(formatName);
        this.dateTimeFormat = null;
    }

    public Configuration getConfiguration() {
        return this.getTemplate().getConfiguration();
    }

    public TemplateModel getLastReturnValue() {
        return this.lastReturnValue;
    }

    public void setLastReturnValue(TemplateModel lastReturnValue) {
        this.lastReturnValue = lastReturnValue;
    }

    void clearLastReturnValue() {
        this.lastReturnValue = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumberFormat getNumberFormatObject(String pattern) {
        NumberFormat format;
        if (this.numberFormats == null) {
            this.numberFormats = new HashMap<String, NumberFormat>();
        }
        if ((format = this.numberFormats.get(pattern)) != null) {
            return format;
        }
        Map<NumberFormatKey, NumberFormat> map = localizedNumberFormats;
        synchronized (map) {
            Locale locale = this.getLocale();
            NumberFormatKey fk = new NumberFormatKey(pattern, locale);
            format = localizedNumberFormats.get(fk);
            if (format == null) {
                format = "number".equals(pattern) ? NumberFormat.getNumberInstance(locale) : ("currency".equals(pattern) ? NumberFormat.getCurrencyInstance(locale) : ("percent".equals(pattern) ? NumberFormat.getPercentInstance(locale) : ("computer".equals(pattern) ? this.getCNumberFormat() : new DecimalFormat(pattern, new DecimalFormatSymbols(this.getLocale())))));
                localizedNumberFormats.put(fk, format);
            }
        }
        format = (NumberFormat)format.clone();
        this.numberFormats.put(pattern, format);
        return format;
    }

    public DateFormat getDateFormatObject(int dateType) {
        switch (dateType) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.timeFormat == null) {
                    this.timeFormat = this.getDateFormatObject(dateType, this.getTimeFormat());
                }
                return this.timeFormat;
            }
            case 2: {
                if (this.dateFormat == null) {
                    this.dateFormat = this.getDateFormatObject(dateType, this.getDateFormat());
                }
                return this.dateFormat;
            }
            case 3: {
                if (this.dateTimeFormat == null) {
                    this.dateTimeFormat = this.getDateFormatObject(dateType, this.getDateTimeFormat());
                }
                return this.dateTimeFormat;
            }
        }
        throw new TemplateModelException("Unrecognized date type " + dateType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateFormat getDateFormatObject(int dateType, String pattern) {
        Map<String, DateFormat> typedDateFormat;
        DateFormat format;
        if (this.dateFormats == null) {
            this.dateFormats = new Map[4];
            this.dateFormats[0] = new HashMap<String, DateFormat>();
            this.dateFormats[1] = new HashMap<String, DateFormat>();
            this.dateFormats[2] = new HashMap<String, DateFormat>();
            this.dateFormats[3] = new HashMap<String, DateFormat>();
        }
        if ((format = (typedDateFormat = this.dateFormats[dateType]).get(pattern)) != null) {
            return format;
        }
        Map<DateFormatKey, DateFormat> map = localizedDateFormats;
        synchronized (map) {
            Locale locale = this.getLocale();
            TimeZone timeZone = this.getTimeZone();
            DateFormatKey fk = new DateFormatKey(dateType, pattern, locale, timeZone);
            format = localizedDateFormats.get(fk);
            if (format == null) {
                int style;
                StringTokenizer tok = new StringTokenizer(pattern, "_");
                int n = style = tok.hasMoreTokens() ? this.parseDateStyleToken(tok.nextToken()) : 2;
                if (style != -1) {
                    switch (dateType) {
                        case 0: {
                            throw new TemplateModelException("Can't convert the date to string using a built-in format, because it is not known which parts of the date variable are in use. Use ?date, ?time or ?datetime built-in, or ?string.<format> or ?string(<format>) built-in with explicit formatting pattern with this date.");
                        }
                        case 1: {
                            format = DateFormat.getTimeInstance(style, locale);
                            break;
                        }
                        case 2: {
                            format = DateFormat.getDateInstance(style, locale);
                            break;
                        }
                        case 3: {
                            int timestyle;
                            int n2 = timestyle = tok.hasMoreTokens() ? this.parseDateStyleToken(tok.nextToken()) : style;
                            if (timestyle == -1) break;
                            format = DateFormat.getDateTimeInstance(style, timestyle, locale);
                            break;
                        }
                    }
                }
                if (format == null) {
                    try {
                        format = new SimpleDateFormat(pattern, locale);
                    }
                    catch (IllegalArgumentException e) {
                        throw new TemplateModelException("Can't parse " + pattern + " to a date format.", e);
                    }
                }
                format.setTimeZone(timeZone);
                localizedDateFormats.put(fk, format);
            }
        }
        format = (DateFormat)format.clone();
        typedDateFormat.put(pattern, format);
        return format;
    }

    int parseDateStyleToken(String token) {
        if ("short".equals(token)) {
            return 3;
        }
        if ("medium".equals(token)) {
            return 2;
        }
        if ("long".equals(token)) {
            return 1;
        }
        if ("full".equals(token)) {
            return 0;
        }
        return -1;
    }

    public NumberFormat getCNumberFormat() {
        if (this.cNumberFormat == null) {
            this.cNumberFormat = Environment.getNewCNumberFormat();
        }
        return this.cNumberFormat;
    }

    public static NumberFormat getNewCNumberFormat() {
        return (NumberFormat)C_NUMBER_FORMAT.clone();
    }

    public TemplateTransformModel getTransform(Expression exp) {
        TemplateTransformModel ttm = null;
        TemplateModel tm = exp.getAsTemplateModel(this);
        if (tm instanceof TemplateTransformModel) {
            ttm = (TemplateTransformModel)tm;
        } else if (exp instanceof Identifier && (tm = this.getConfiguration().getSharedVariable(exp.toString())) instanceof TemplateTransformModel) {
            ttm = (TemplateTransformModel)tm;
        }
        return ttm;
    }

    @Override
    public TemplateModel resolveVariable(String name) throws TemplateModelException {
        return this.get(name);
    }

    public TemplateModel getVariable(String name) {
        return this.currentScope.resolveVariable(name);
    }

    @Override
    public TemplateModel get(String name) {
        TemplateModel result = this.globalVariables.get(name);
        if (result == null) {
            result = this.rootDataModel.get(name);
        }
        if (result == null) {
            result = this.getConfiguration().getSharedVariable(name);
        }
        return result;
    }

    @Override
    public Collection<String> getDirectVariableNames() {
        HashSet<String> coll = new HashSet<String>(this.globalVariables.keySet());
        if (this.rootDataModel instanceof TemplateHashModelEx) {
            TemplateModelIterator rootNames = ((TemplateHashModelEx)this.rootDataModel).keys().iterator();
            while (rootNames.hasNext()) {
                coll.add(((TemplateScalarModel)rootNames.next()).getAsString());
            }
        }
        return coll;
    }

    public void setGlobalVariable(String name, TemplateModel model) {
        this.globalVariables.put(name, model);
    }

    public void setVariable(String name, TemplateModel model) {
        this.getCurrentNamespace().put(name, model);
    }

    public void setLocalVariable(String name, TemplateModel model) {
        if (this.currentMacroContext == null) {
            throw new IllegalStateException("Not executing macro body");
        }
        this.currentMacroContext.put(name, model);
    }

    public void unqualifiedSet(String name, TemplateModel model) {
        Scope scope = this.currentScope;
        while (!(scope instanceof TemplateNamespace)) {
            if (scope.get(name) != null) {
                scope.put(name, model);
                return;
            }
            scope = scope.getEnclosingScope();
        }
        try {
            scope.put(name, model);
        }
        catch (UndeclaredVariableException uve) {
            if (this.globalVariables.containsKey(name)) {
                this.globalVariables.put(name, model);
            }
            throw new TemplateException(uve, this);
        }
    }

    public Scope getCurrentScope() {
        return this.currentScope;
    }

    public Collection<String> getKnownVariableNames() {
        HashSet<String> coll = new HashSet<String>();
        for (Scope scope = this.currentScope; scope != null; scope = scope.getEnclosingScope()) {
            coll.addAll(scope.getDirectVariableNames());
        }
        return coll;
    }

    public void outputInstructionStack(PrintWriter pw) {
        TemplateNode prev;
        pw.println("----------");
        ListIterator<TemplateElement> iter = this.elementStack.listIterator(this.elementStack.size());
        if (iter.hasPrevious()) {
            pw.print("==> ");
            prev = iter.previous();
            pw.print(prev.getDescription());
            pw.print(" [");
            pw.print(prev.getStartLocation());
            pw.println("]");
        }
        while (iter.hasPrevious()) {
            String location;
            prev = iter.previous();
            if (!(prev instanceof UnifiedCall) && !(prev instanceof Include) || (location = prev.getDescription() + " [" + prev.getStartLocation() + "]") == null || location.length() <= 0) continue;
            pw.print(" in ");
            pw.println(location);
        }
        pw.println("----------");
        pw.flush();
    }

    @Override
    public Environment getEnvironment() {
        return this;
    }

    @Override
    public Scope getEnclosingScope() {
        return null;
    }

    @Override
    public boolean definesVariable(String name) {
        try {
            return this.globalVariables.containsKey(name) || this.rootDataModel.get(name) != null;
        }
        catch (TemplateModelException tme) {
            return false;
        }
    }

    @Override
    public void put(String varname, TemplateModel value) {
        this.globalVariables.put(varname, value);
    }

    @Override
    public TemplateModel remove(String varname) {
        return this.globalVariables.remove(varname);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        if (this.rootDataModel instanceof TemplateHashModelEx) {
            TemplateHashModelEx root = (TemplateHashModelEx)this.rootDataModel;
            return this.globalVariables.size() + root.size() + this.getEnclosingScope().size();
        }
        throw new TemplateModelException("The size() method is not applicable because the root data model does not expose a size() method.");
    }

    @Override
    public TemplateCollectionModel keys() {
        if (!(this.rootDataModel instanceof TemplateHashModelEx)) {
            throw new TemplateModelException("The keys() method is not applicable because the root data model does not expose a keys() method.");
        }
        TemplateHashModelEx root = (TemplateHashModelEx)this.rootDataModel;
        TemplateCollectionModel rootKeys = root.keys();
        TemplateCollectionModel sharedVariableKeys = this.getEnclosingScope().keys();
        LinkedHashSet<TemplateModel> aggregate = new LinkedHashSet<TemplateModel>();
        TemplateModelIterator tmi = sharedVariableKeys.iterator();
        while (tmi.hasNext()) {
            aggregate.add(tmi.next());
        }
        tmi = rootKeys.iterator();
        while (tmi.hasNext()) {
            aggregate.add(tmi.next());
        }
        for (String varname : this.globalVariables.keySet()) {
            aggregate.add(new SimpleScalar(varname));
        }
        return new SimpleCollection(aggregate, this.getObjectWrapper());
    }

    @Override
    public TemplateCollectionModel values() {
        if (!(this.rootDataModel instanceof TemplateHashModelEx)) {
            throw new TemplateModelException("The keys() method is not applicable because the root data model does not expose a keys() method.");
        }
        TemplateHashModelEx root = (TemplateHashModelEx)this.rootDataModel;
        TemplateCollectionModel rootValues = root.values();
        TemplateCollectionModel sharedVariableValues = this.getEnclosingScope().values();
        LinkedHashSet<TemplateModel> aggregate = new LinkedHashSet<TemplateModel>();
        TemplateModelIterator tmi = sharedVariableValues.iterator();
        while (tmi.hasNext()) {
            aggregate.add(tmi.next());
        }
        tmi = rootValues.iterator();
        while (tmi.hasNext()) {
            aggregate.add(tmi.next());
        }
        for (TemplateModel value : this.globalVariables.values()) {
            aggregate.add(value);
        }
        return new SimpleCollection(aggregate, this.getObjectWrapper());
    }

    public TemplateNamespace getNamespace(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (this.loadedLibs != null) {
            return this.loadedLibs.get(name);
        }
        return null;
    }

    public TemplateNamespace getMainNamespace() {
        return this.mainNamespace;
    }

    public TemplateNamespace getCurrentNamespace() {
        Scope scope = this.currentScope;
        while (!(scope instanceof TemplateNamespace)) {
            scope = scope.getEnclosingScope();
        }
        return (TemplateNamespace)scope;
    }

    public Scope getGlobalNamespace() {
        return this;
    }

    public TemplateHashModel getDataModel() {
        final TemplateHashModel result = new TemplateHashModel(){

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public TemplateModel get(String key) {
                TemplateModel value = Environment.this.rootDataModel.get(key);
                if (value == null) {
                    value = Environment.this.getConfiguration().getSharedVariable(key);
                }
                return value;
            }
        };
        if (this.rootDataModel instanceof TemplateHashModelEx) {
            return new TemplateHashModelEx(){

                @Override
                public boolean isEmpty() {
                    return result.isEmpty();
                }

                @Override
                public TemplateModel get(String key) {
                    return result.get(key);
                }

                @Override
                public TemplateCollectionModel values() {
                    return ((TemplateHashModelEx)Environment.this.rootDataModel).values();
                }

                @Override
                public TemplateCollectionModel keys() {
                    return ((TemplateHashModelEx)Environment.this.rootDataModel).keys();
                }

                @Override
                public int size() {
                    return ((TemplateHashModelEx)Environment.this.rootDataModel).size();
                }
            };
        }
        return result;
    }

    public List<TemplateElement> getElementStack() {
        return Collections.unmodifiableList(this.elementStack);
    }

    private void pushElement(TemplateElement element) {
        this.elementStack.add(element);
    }

    private void popElement() {
        this.elementStack.remove(this.elementStack.size() - 1);
    }

    public TemplateNodeModel getCurrentVisitorNode() {
        return this.currentVisitorNode;
    }

    public void setCurrentVisitorNode(TemplateNodeModel node) {
        this.currentVisitorNode = node;
    }

    TemplateModel getNodeProcessor(TemplateNodeModel node) {
        String nodeName = node.getNodeName();
        if (nodeName == null) {
            throw new TemplateException("Node name is null.", this);
        }
        TemplateModel result = this.getNodeProcessor(nodeName, node.getNodeNamespace(), 0);
        if (result == null) {
            String type = node.getNodeType();
            if (type != null) {
                result = this.getNodeProcessor("@" + type, null, 0);
            }
            if (result == null) {
                result = this.getNodeProcessor("@default", null, 0);
            }
        }
        return result;
    }

    private TemplateModel getNodeProcessor(String nodeName, String nsURI, int startIndex) {
        int i;
        TemplateModel result = null;
        for (i = startIndex; i < this.nodeNamespaces.size(); ++i) {
            TemplateNamespace ns = null;
            try {
                ns = (TemplateNamespace)this.nodeNamespaces.get(i);
            }
            catch (ClassCastException cce) {
                throw new InvalidReferenceException("A using clause should contain a sequence of namespaces or strings that indicate the location of importable macro libraries.", this);
            }
            result = this.getNodeProcessor(ns, nodeName, nsURI);
            if (result != null) break;
        }
        if (result != null) {
            this.nodeNamespaceIndex = i + 1;
            this.currentNodeName = nodeName;
            this.currentNodeNS = nsURI;
        }
        return result;
    }

    private TemplateModel getNodeProcessor(TemplateNamespace ns, String localName, String nsURI) {
        TemplateModel result = null;
        if (nsURI == null) {
            result = ns.get(localName);
            if (!(result instanceof Macro) && !(result instanceof TemplateTransformModel)) {
                result = null;
            }
        } else {
            Template template = ns.getTemplate();
            String prefix = template.getPrefixForNamespace(nsURI);
            if (prefix == null) {
                return null;
            }
            if (prefix.length() > 0) {
                result = ns.get(prefix + ":" + localName);
                if (!(result instanceof Macro) && !(result instanceof TemplateTransformModel)) {
                    result = null;
                }
            } else {
                if (nsURI.length() == 0 && !((result = ns.get("N:" + localName)) instanceof Macro) && !(result instanceof TemplateTransformModel)) {
                    result = null;
                }
                if (nsURI.equals(template.getDefaultNS()) && !((result = ns.get("D:" + localName)) instanceof Macro) && !(result instanceof TemplateTransformModel)) {
                    result = null;
                }
                if (result == null && !((result = ns.get(localName)) instanceof Macro) && !(result instanceof TemplateTransformModel)) {
                    result = null;
                }
            }
        }
        return result;
    }

    public void include(String name, String encoding, boolean parse) throws IOException, TemplateException {
        this.include(this.getTemplateForInclusion(name, encoding, parse), false);
    }

    public Template getTemplateForInclusion(String name, String encoding, boolean parse) throws IOException {
        if (encoding == null) {
            encoding = this.getTemplate().getEncoding();
        }
        if (encoding == null) {
            encoding = this.getConfiguration().getEncoding(this.getLocale());
        }
        return this.getConfiguration().getTemplate(name, this.getLocale(), encoding, parse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(Template includedTemplate, boolean freshNamespace) throws TemplateException, IOException {
        Template prevTemplate = this.getTemplate();
        this.setParent(includedTemplate);
        Scope prevScope = this.currentScope;
        if (freshNamespace) {
            this.currentScope = new TemplateNamespace(this, includedTemplate);
            this.importMacros(includedTemplate);
        } else {
            this.currentScope = new IncludedTemplateNamespace(includedTemplate, prevScope);
            this.importMacros(includedTemplate);
        }
        try {
            this.render(includedTemplate.getRootElement());
        }
        finally {
            this.currentScope = prevScope;
            this.setParent(prevTemplate);
        }
    }

    public TemplateNamespace importLib(String name, String namespace) throws IOException, TemplateException {
        return this.importLib(this.getTemplateForImporting(name), namespace, true);
    }

    public Template getTemplateForImporting(String name) throws IOException {
        return this.getTemplateForInclusion(name, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateNamespace importLib(Template loadedTemplate, String namespace, boolean global) throws IOException, TemplateException {
        String templateName;
        TemplateNamespace existingNamespace;
        if (this.loadedLibs == null) {
            this.loadedLibs = new HashMap();
        }
        if ((existingNamespace = this.loadedLibs.get(templateName = loadedTemplate.getName())) != null) {
            if (namespace != null) {
                this.setVariable(namespace, existingNamespace);
            }
        } else {
            TemplateNamespace newNamespace = new TemplateNamespace(this, loadedTemplate);
            if (namespace != null) {
                if (global) {
                    this.setGlobalVariable(namespace, newNamespace);
                } else {
                    this.setVariable(namespace, newNamespace);
                }
                if (this.getCurrentNamespace() == this.mainNamespace) {
                    this.put(namespace, newNamespace);
                }
            }
            this.loadedLibs.put(templateName, newNamespace);
            Scope prevScope = this.currentScope;
            this.currentScope = newNamespace;
            Writer prevOut = this.out;
            Configurable prevParent = this.getParent();
            this.out = NULL_WRITER;
            this.setParent(loadedTemplate);
            try {
                this.render(loadedTemplate.getRootElement());
            }
            finally {
                this.out = prevOut;
                this.currentScope = prevScope;
                this.setParent(prevParent);
            }
        }
        return this.loadedLibs.get(templateName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderElementToString(TemplateElement te) throws IOException, TemplateException {
        Writer prevOut = this.out;
        try {
            StringWriter sw = new StringWriter();
            this.out = sw;
            this.render(te);
            String string = sw.toString();
            return string;
        }
        finally {
            this.out = prevOut;
        }
    }

    void importMacros(Template template) {
        for (Macro macro : template.getMacros().values()) {
            this.visitMacroDef(macro);
        }
    }

    public String getNamespaceForPrefix(String prefix) {
        return this.getCurrentNamespace().getTemplate().getNamespaceForPrefix(prefix);
    }

    public String getPrefixForNamespace(String nsURI) {
        return this.getCurrentNamespace().getTemplate().getPrefixForNamespace(nsURI);
    }

    public String getDefaultNS() {
        return this.getCurrentNamespace().getTemplate().getDefaultNS();
    }

    static {
        C_NUMBER_FORMAT.setGroupingUsed(false);
        C_NUMBER_FORMAT.setDecimalSeparatorAlwaysShown(false);
        NO_OUT_ARGS = new TemplateModel[0];
        NULL_WRITER = new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
        EMPTY_BODY_WRITER = new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                if (len > 0) {
                    throw new IOException("This transform does not allow nested content.");
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
    }

    private static final class DateFormatKey {
        private final int dateType;
        private final String pattern;
        private final Locale locale;
        private final TimeZone timeZone;

        DateFormatKey(int dateType, String pattern, Locale locale, TimeZone timeZone) {
            this.dateType = dateType;
            this.pattern = pattern;
            this.locale = locale;
            this.timeZone = timeZone;
        }

        public boolean equals(Object o) {
            if (o instanceof DateFormatKey) {
                DateFormatKey fk = (DateFormatKey)o;
                return this.dateType == fk.dateType && fk.pattern.equals(this.pattern) && fk.locale.equals(this.locale) && fk.timeZone.equals(this.timeZone);
            }
            return false;
        }

        public int hashCode() {
            return this.dateType ^ this.pattern.hashCode() ^ this.locale.hashCode() ^ this.timeZone.hashCode();
        }
    }

    private static final class NumberFormatKey {
        private final String pattern;
        private final Locale locale;

        NumberFormatKey(String pattern, Locale locale) {
            this.pattern = pattern;
            this.locale = locale;
        }

        public boolean equals(Object o) {
            if (o instanceof NumberFormatKey) {
                NumberFormatKey fk = (NumberFormatKey)o;
                return fk.pattern.equals(this.pattern) && fk.locale.equals(this.locale);
            }
            return false;
        }

        public int hashCode() {
            return this.pattern.hashCode() ^ this.locale.hashCode();
        }
    }
}

