/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class CommandLine {
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            CommandLine.info();
        }
        CommandLine.processTemplate(args[0]);
    }

    public static void processTemplate(String filename) throws IOException {
        File file = new File(filename).getCanonicalFile();
        Configuration conf = new Configuration();
        conf.setDirectoryForTemplateLoading(file.getParentFile());
        Template template = conf.getTemplate(file.getName());
        OutputStreamWriter out = new OutputStreamWriter(System.out);
        template.process(null, out);
    }

    public static void info() {
        System.out.println();
        System.out.print("FreeMarker version ");
        System.out.println(Configuration.getVersionNumber());
        System.out.println();
        System.out.println("Copyright (c) 2023 Jonathan Revusky.");
        System.out.println("All rights reserved.");
        System.out.println();
        System.out.println("This is Free software. Please read the LICENSE.md");
        System.out.println("for more details.");
        System.out.println();
        System.out.println("For more information and for updates visit:");
        System.out.println("https://discuss.congocc.org/");
        System.out.println();
    }
}

