/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.AbstractScope;
import freemarker.core.Scope;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateModel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class BaseScope
extends AbstractScope {
    private HashMap<String, TemplateModel> variables = new HashMap();
    static ObjectWrapper TRIVIAL_WRAPPER = new ObjectWrapper(){

        @Override
        public TemplateModel wrap(Object obj) {
            if (obj instanceof String) {
                return new SimpleScalar((String)obj);
            }
            return (TemplateModel)obj;
        }
    };

    BaseScope(Scope enclosingScope) {
        super(enclosingScope);
    }

    @Override
    public void put(String key, TemplateModel value) {
        this.variables.put(key, value);
    }

    @Override
    public TemplateModel remove(String key) {
        return this.variables.remove(key);
    }

    @Override
    public TemplateModel get(String key) {
        return this.variables.get(key);
    }

    @Override
    public boolean definesVariable(String key) {
        return this.variables.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.variables.isEmpty();
    }

    @Override
    public TemplateCollectionModel keys() {
        return new SimpleCollection(this.variables.keySet(), TRIVIAL_WRAPPER);
    }

    @Override
    public TemplateCollectionModel values() {
        return new SimpleCollection(this.variables.values(), TRIVIAL_WRAPPER);
    }

    @Override
    public int size() {
        return this.variables.size();
    }

    public void clear() {
        this.variables.clear();
    }

    @Override
    public Collection<String> getDirectVariableNames() {
        return Collections.unmodifiableCollection(this.variables.keySet());
    }
}

