/*
 * Decompiled with CFR 0.152.
 */
package org.parsers.csharp.ppline;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.BitSet;
import org.parsers.csharp.ppline.Token;

public abstract class TokenSource
implements CharSequence {
    private int tabSize = 1;
    private String inputSource = "input";
    private static final Token SKIPPED = new Token();
    private Token[] tokenLocationTable;
    private BitSet tokenOffsets;
    private BitSet needToCalculateColumns = new BitSet();
    private int[] lineOffsets;
    private CharSequence content;
    private int startingLine;
    private int startingColumn;

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    protected int getTabSize() {
        return this.tabSize;
    }

    public void setStartingPos(int startingLine, int startingColumn) {
        this.startingLine = startingLine;
        this.startingColumn = startingColumn;
    }

    protected TokenSource(String inputSource, CharSequence input, int startingLine, int startingColumn, int tabSize, boolean preserveTabs, boolean preserveLineEndings, boolean javaUnicodeEscape, String terminatingString) {
        this.inputSource = inputSource;
        this.tabSize = tabSize;
        this.startingLine = startingLine;
        this.startingColumn = startingColumn;
        this.content = TokenSource.mungeContent(input, preserveTabs, tabSize, preserveLineEndings, javaUnicodeEscape, terminatingString);
        this.createLineOffsetsTable();
        this.createTokenLocationTable();
    }

    protected static String mungeContent(CharSequence content, boolean preserveTabs, int tabSize, boolean preserveLines, boolean javaUnicodeEscape, String terminatingString) {
        if (preserveTabs && preserveLines && !javaUnicodeEscape) {
            if (!terminatingString.isEmpty()) {
                if (content.length() == 0) {
                    content = terminatingString;
                } else {
                    char lastChar = content.charAt(content.length() - 1);
                    if (lastChar != '\n' && lastChar != '\r') {
                        if (content instanceof StringBuilder) {
                            ((StringBuilder)content).append('\n');
                        } else {
                            StringBuilder buf = new StringBuilder(content);
                            buf.append(terminatingString);
                            content = buf.toString();
                        }
                    }
                }
            }
            return content.toString();
        }
        StringBuilder buf = new StringBuilder();
        int col = 0;
        int index = 0;
        int contentLength = content.length();
        while (index < contentLength) {
            int i;
            char ch;
            if ((ch = content.charAt(index++)) == '\n') {
                buf.append(ch);
                col = 0;
                continue;
            }
            if (javaUnicodeEscape && ch == '\\' && index < contentLength && content.charAt(index) == 'u') {
                int numPrecedingSlashes = 0;
                for (i = index - 1; i >= 0 && content.charAt(i) == '\\'; --i) {
                    ++numPrecedingSlashes;
                }
                if (numPrecedingSlashes % 2 == 0) {
                    buf.append('\\');
                    ++col;
                    continue;
                }
                int numConsecutiveUs = 0;
                for (int i2 = index; i2 < contentLength && content.charAt(i2) == 'u'; ++i2) {
                    ++numConsecutiveUs;
                }
                String fourHexDigits = content.subSequence(index + numConsecutiveUs, index + numConsecutiveUs + 4).toString();
                buf.append((char)Integer.parseInt(fourHexDigits, 16));
                index += numConsecutiveUs + 4;
                ++col;
                continue;
            }
            if (!preserveLines && ch == '\r') {
                buf.append('\n');
                col = 0;
                if (index >= contentLength || content.charAt(index) != '\n') continue;
                ++index;
                continue;
            }
            if (ch == '\t' && !preserveTabs) {
                int spacesToAdd = tabSize - col % tabSize;
                for (i = 0; i < spacesToAdd; ++i) {
                    buf.append(' ');
                    ++col;
                }
                continue;
            }
            buf.append(ch);
            if (Character.isLowSurrogate(ch)) continue;
            ++col;
        }
        if (!terminatingString.isEmpty()) {
            if (buf.length() == 0) {
                return terminatingString;
            }
            if (buf.length() < terminatingString.length()) {
                buf.append(terminatingString);
            } else if (!buf.substring(buf.length() - terminatingString.length()).equals(terminatingString)) {
                buf.append(terminatingString);
            }
        }
        return buf.toString();
    }

    private final void createTokenLocationTable() {
        int size = this.content.length() + 1;
        this.tokenLocationTable = new Token[size];
        this.tokenOffsets = new BitSet(size);
    }

    protected final void skipTokens(int begin, int end) {
        for (int i = begin; i < end; ++i) {
            this.tokenLocationTable[i] = SKIPPED;
        }
    }

    @Override
    public final char charAt(int pos) {
        return this.content.charAt(pos);
    }

    @Override
    public final int length() {
        return this.content.length();
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        return this.content.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.content.toString();
    }

    protected final void cacheTokenAt(Token tok, int offset) {
        this.tokenOffsets.set(offset);
        this.tokenLocationTable[offset] = tok;
    }

    protected void uncacheTokens(Token lastToken) {
        int endOffset = lastToken.getEndOffset();
        if (endOffset < this.tokenOffsets.length()) {
            this.tokenOffsets.clear(lastToken.getEndOffset(), this.tokenOffsets.length());
        }
    }

    public Token nextCachedToken(int offset) {
        int nextOffset = this.tokenOffsets.nextSetBit(offset);
        return nextOffset != -1 ? this.tokenLocationTable[nextOffset] : null;
    }

    public Token previousCachedToken(int offset) {
        int prevOffset = this.tokenOffsets.previousSetBit(offset - 1);
        return prevOffset == -1 ? null : this.tokenLocationTable[prevOffset];
    }

    protected static boolean checkIntervals(int[] ranges, int ch) {
        int result = Arrays.binarySearch(ranges, ch);
        return result >= 0 || result % 2 == 0;
    }

    public int getLineStartOffset(int lineNumber) {
        int realLineNumber = lineNumber - this.startingLine;
        if (realLineNumber <= 0) {
            return 0;
        }
        if (realLineNumber >= this.lineOffsets.length) {
            return this.content.length();
        }
        return this.lineOffsets[realLineNumber];
    }

    public int getLineEndOffset(int lineNumber) {
        int realLineNumber = lineNumber - this.startingLine;
        if (realLineNumber < 0) {
            return 0;
        }
        if (realLineNumber >= this.lineOffsets.length) {
            return this.content.length();
        }
        if (realLineNumber == this.lineOffsets.length - 1) {
            return this.content.length() - 1;
        }
        return this.lineOffsets[realLineNumber + 1] - 1;
    }

    public int getLineFromOffset(int pos) {
        if (pos >= this.content.length()) {
            if (this.content.charAt(this.content.length() - 1) == '\n') {
                return this.startingLine + this.lineOffsets.length;
            }
            return this.startingLine + this.lineOffsets.length - 1;
        }
        int bsearchResult = Arrays.binarySearch(this.lineOffsets, pos);
        if (bsearchResult >= 0) {
            return Math.max(this.startingLine, this.startingLine + bsearchResult);
        }
        return Math.max(this.startingLine, this.startingLine - (bsearchResult + 2));
    }

    private void createLineOffsetsTable() {
        if (this.content.length() == 0) {
            this.lineOffsets = new int[0];
            return;
        }
        int lineCount = 0;
        int length = this.content.length();
        for (int i = 0; i < length; ++i) {
            char ch = this.content.charAt(i);
            if (ch == '\t' || Character.isHighSurrogate(ch)) {
                this.needToCalculateColumns.set(lineCount);
            }
            if (ch != '\n') continue;
            ++lineCount;
        }
        if (this.content.charAt(length - 1) != '\n') {
            ++lineCount;
        }
        int[] lineOffsets = new int[lineCount];
        lineOffsets[0] = 0;
        int index = 1;
        for (int i = 0; i < length; ++i) {
            char ch = this.content.charAt(i);
            if (ch != '\n') continue;
            if (i + 1 == length) break;
            lineOffsets[index++] = i + 1;
        }
        this.lineOffsets = lineOffsets;
    }

    public int getCodePointColumnFromOffset(int pos) {
        if (pos >= this.content.length()) {
            return 1;
        }
        if (pos == 0) {
            return this.startingColumn;
        }
        int line = this.getLineFromOffset(pos) - this.startingLine;
        int lineStart = this.lineOffsets[line];
        int startColumnAdjustment = line > 0 ? 1 : this.startingColumn;
        int unadjustedColumn = pos - lineStart + startColumnAdjustment;
        if (!this.needToCalculateColumns.get(line)) {
            return unadjustedColumn;
        }
        if (Character.isLowSurrogate(this.content.charAt(pos))) {
            --pos;
        }
        int result = startColumnAdjustment;
        for (int i = lineStart; i < pos; ++i) {
            char ch = this.content.charAt(i);
            if (ch == '\t') {
                result += this.tabSize - (result - 1) % this.tabSize;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                ++result;
                ++i;
                continue;
            }
            ++result;
        }
        return result;
    }

    int getLineLength(int lineNumber) {
        int startOffset = this.getLineStartOffset(lineNumber);
        int endOffset = this.getLineEndOffset(lineNumber);
        return 1 + endOffset - startOffset;
    }

    public String getText(int startOffset, int endOffset) {
        return this.subSequence(startOffset, endOffset).toString();
    }

    public String getInputSource() {
        return this.inputSource;
    }

    public void setInputSource(String inputSource) {
        this.inputSource = inputSource;
    }

    public static String stringFromBytes(byte[] bytes, Charset charset) throws CharacterCodingException {
        CoderResult r;
        int arrayLength = bytes.length;
        if (charset == null) {
            int fourthByte;
            int firstByte = arrayLength > 0 ? Byte.toUnsignedInt(bytes[0]) : 1;
            int secondByte = arrayLength > 1 ? Byte.toUnsignedInt(bytes[1]) : 1;
            int thirdByte = arrayLength > 2 ? Byte.toUnsignedInt(bytes[2]) : 1;
            int n = fourthByte = arrayLength > 3 ? Byte.toUnsignedInt(bytes[3]) : 1;
            if (firstByte == 239 && secondByte == 187 && thirdByte == 191) {
                return new String(bytes, 3, bytes.length - 3, Charset.forName("UTF-8"));
            }
            if (firstByte == 0 && secondByte == 0 && thirdByte == 254 && fourthByte == 255) {
                return new String(bytes, 4, bytes.length - 4, Charset.forName("UTF-32BE"));
            }
            if (firstByte == 255 && secondByte == 254 && thirdByte == 0 && fourthByte == 0) {
                return new String(bytes, 4, bytes.length - 4, Charset.forName("UTF-32LE"));
            }
            if (firstByte == 254 && secondByte == 255) {
                return new String(bytes, 2, bytes.length - 2, Charset.forName("UTF-16BE"));
            }
            if (firstByte == 255 && secondByte == 254) {
                return new String(bytes, 2, bytes.length - 2, Charset.forName("UTF-16LE"));
            }
            charset = StandardCharsets.UTF_8;
        }
        CharsetDecoder decoder = charset.newDecoder();
        ByteBuffer b = ByteBuffer.wrap(bytes);
        CharBuffer c = CharBuffer.allocate(bytes.length);
        while ((r = decoder.decode(b, c, false)).isError()) {
            if (!r.isMalformed()) {
                r.throwException();
            }
            int n = r.length();
            b.position(b.position() + n);
            for (int i = 0; i < n; ++i) {
                c.put('\ufffd');
            }
        }
        ((Buffer)c).limit(c.position());
        ((Buffer)c).rewind();
        return c.toString();
    }

    public static String stringFromBytes(byte[] bytes) throws CharacterCodingException {
        return TokenSource.stringFromBytes(bytes, null);
    }
}

