/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.parser.python;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.congocc.parser.Node;
import org.congocc.parser.TokenSource;
import org.congocc.parser.python.InvalidToken;
import org.congocc.parser.python.PythonToken;
import org.congocc.parser.python.ast.DedentToken;
import org.congocc.parser.python.ast.IndentToken;

public class PythonLexer
extends TokenSource {
    private PythonToken danglingIndentation;
    private int bracketNesting;
    private int parenthesesNesting;
    private int braceNesting;
    private List<Integer> indentationStack = PythonLexer.initIndentationStack();
    LexicalState lexicalState = LexicalState.values()[0];
    EnumSet<PythonToken.TokenType> activeTokenTypes = EnumSet.allOf(PythonToken.TokenType.class);
    static final EnumSet<PythonToken.TokenType> regularTokens = EnumSet.of(PythonToken.TokenType.EOF, new PythonToken.TokenType[]{PythonToken.TokenType.NEWLINE, PythonToken.TokenType.ASSIGN, PythonToken.TokenType.AT, PythonToken.TokenType.COLON, PythonToken.TokenType.COMMA, PythonToken.TokenType.EQ, PythonToken.TokenType.LBRACE, PythonToken.TokenType.RBRACE, PythonToken.TokenType.LBRACKET, PythonToken.TokenType.RBRACKET, PythonToken.TokenType.LPAREN, PythonToken.TokenType.RPAREN, PythonToken.TokenType.SEMICOLON, PythonToken.TokenType.STAR, PythonToken.TokenType.STAR_STAR, PythonToken.TokenType.MINUSASSIGN, PythonToken.TokenType.PLUSASSIGN, PythonToken.TokenType.STARASSIGN, PythonToken.TokenType.ATASSIGN, PythonToken.TokenType.SLASHASSIGN, PythonToken.TokenType.REMASSIGN, PythonToken.TokenType.ANDASSIGN, PythonToken.TokenType.ORASSIGN, PythonToken.TokenType.XORASSIGN, PythonToken.TokenType.LSHIFTASSIGN, PythonToken.TokenType.RSHIFTASSIGN, PythonToken.TokenType.STARSTARASSIGN, PythonToken.TokenType.SLASHSLASHASSIGN, PythonToken.TokenType.BIT_AND, PythonToken.TokenType.BIT_OR, PythonToken.TokenType.XOR, PythonToken.TokenType.TILDE, PythonToken.TokenType.COLONEQUALS, PythonToken.TokenType.DOT, PythonToken.TokenType.ELLIPSIS, PythonToken.TokenType.LE, PythonToken.TokenType.GE, PythonToken.TokenType.NE, PythonToken.TokenType.GT, PythonToken.TokenType.LT, PythonToken.TokenType.MINUS, PythonToken.TokenType.PLUS, PythonToken.TokenType.SLASH, PythonToken.TokenType.SLASHSLASH, PythonToken.TokenType.PERCENT, PythonToken.TokenType.LSHIFT, PythonToken.TokenType.RSHIFT, PythonToken.TokenType.HOOK, PythonToken.TokenType.RARROW, PythonToken.TokenType.AND, PythonToken.TokenType.AS, PythonToken.TokenType._ASSERT, PythonToken.TokenType.ASYNC, PythonToken.TokenType.AWAIT, PythonToken.TokenType.BREAK, PythonToken.TokenType.CASE, PythonToken.TokenType.CLASS, PythonToken.TokenType.CONTINUE, PythonToken.TokenType.DEF, PythonToken.TokenType.DEL, PythonToken.TokenType.EXCEPT, PythonToken.TokenType.FINALLY, PythonToken.TokenType.FOR, PythonToken.TokenType.FROM, PythonToken.TokenType.GLOBAL, PythonToken.TokenType.IF, PythonToken.TokenType.IN, PythonToken.TokenType.IS, PythonToken.TokenType.ELIF, PythonToken.TokenType.ELSE, PythonToken.TokenType.FALSE, PythonToken.TokenType.IMPORT, PythonToken.TokenType.LAMBDA, PythonToken.TokenType.MATCH, PythonToken.TokenType.NONLOCAL, PythonToken.TokenType.NONE, PythonToken.TokenType.NOT, PythonToken.TokenType.OR, PythonToken.TokenType.PASS, PythonToken.TokenType.PEG_PARSER, PythonToken.TokenType.RAISE, PythonToken.TokenType.RETURN, PythonToken.TokenType.TRUE, PythonToken.TokenType.TRY, PythonToken.TokenType.WHILE, PythonToken.TokenType.WITH, PythonToken.TokenType.YIELD, PythonToken.TokenType.DECNUMBER, PythonToken.TokenType.BADDECNUMBER, PythonToken.TokenType.HEXNUMBER, PythonToken.TokenType.OCTNUMBER, PythonToken.TokenType.BINNUMBER, PythonToken.TokenType.FLOAT, PythonToken.TokenType.COMPLEX, PythonToken.TokenType.STRING_LITERAL, PythonToken.TokenType.NAME, PythonToken.TokenType.BADNAME});
    static final EnumSet<PythonToken.TokenType> unparsedTokens = EnumSet.of(PythonToken.TokenType.CONTINUE_LINE, PythonToken.TokenType.COMMENT);
    static final EnumSet<PythonToken.TokenType> skippedTokens = EnumSet.of(PythonToken.TokenType.SPACE);
    private static final EnumSet<PythonToken.TokenType> moreTokens = EnumSet.noneOf(PythonToken.TokenType.class);
    private static NfaFunction[] nfaFunctions;

    private static List<Integer> initIndentationStack() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(1);
        return result;
    }

    private PythonToken tokenHook$PythonLexer_ccc$32$29(PythonToken tok) {
        int indentation;
        boolean lineJoiningOn = this.bracketNesting > 0 || this.parenthesesNesting > 0 || this.braceNesting > 0;
        PythonToken.TokenType type = tok.getType();
        switch (type) {
            case LBRACE: {
                ++this.braceNesting;
                break;
            }
            case RBRACE: {
                --this.braceNesting;
                break;
            }
            case LPAREN: {
                ++this.parenthesesNesting;
                break;
            }
            case RPAREN: {
                --this.parenthesesNesting;
                break;
            }
            case LBRACKET: {
                ++this.bracketNesting;
                break;
            }
            case RBRACKET: {
                --this.bracketNesting;
                break;
            }
            case NEWLINE: {
                if (lineJoiningOn || tok.startsLine()) {
                    tok.setUnparsed(true);
                }
                return tok;
            }
        }
        if (this.danglingIndentation != null) {
            tok.preInsert(this.danglingIndentation);
        }
        if (lineJoiningOn || tok.isUnparsed() || this.danglingIndentation == null && !tok.startsLine()) {
            return tok;
        }
        this.danglingIndentation = null;
        int beginColumn = tok.getBeginColumn();
        if (beginColumn > (indentation = this.indentationStack.get(this.indentationStack.size() - 1).intValue())) {
            this.indentationStack.add(beginColumn);
            return IndentToken.makeIndentToken(tok, this, this.indentationStack);
        }
        if (beginColumn < indentation) {
            return this.handleDedent(tok, beginColumn);
        }
        return tok;
    }

    private PythonToken handleDedent(PythonToken tok, int offset) {
        int dedentIndex = this.indentationStack.indexOf(offset);
        if (dedentIndex < 0) {
            InvalidToken invalidDedent = new InvalidToken(this, 0, 0);
            invalidDedent.setImage("Invalid Dedent");
            tok.preInsert(invalidDedent);
            return invalidDedent;
        }
        PythonToken firstDedent = null;
        for (int i = this.indentationStack.size() - 1; i > dedentIndex; --i) {
            int dedentAmount = this.indentationStack.get(i) - this.indentationStack.get(i - 1);
            this.indentationStack.remove(i);
            PythonToken dedent = DedentToken.makeDedentToken(tok, this, this.indentationStack, dedentAmount);
            if (firstDedent != null) continue;
            firstDedent = dedent;
        }
        return firstDedent;
    }

    private void resetTokenHook$PythonLexer_ccc$85$17(PythonToken tok) {
        this.parenthesesNesting = 0;
        this.bracketNesting = 0;
        this.braceNesting = 0;
        if (tok.getType() == PythonToken.TokenType.INDENT || tok.getType() == PythonToken.TokenType.DEDENT) {
            this.danglingIndentation = tok;
            this.indentationStack = tok.getIndents();
            return;
        }
        Iterator<PythonToken> toks = tok.precedingTokens();
        while (toks.hasNext()) {
            PythonToken previous = toks.next();
            PythonToken.TokenType prevType = previous.getType();
            switch (prevType) {
                case LBRACE: {
                    ++this.braceNesting;
                    break;
                }
                case RBRACE: {
                    --this.braceNesting;
                    break;
                }
                case LPAREN: {
                    ++this.parenthesesNesting;
                    break;
                }
                case RPAREN: {
                    --this.parenthesesNesting;
                    break;
                }
                case LBRACKET: {
                    ++this.bracketNesting;
                    break;
                }
                case RBRACKET: {
                    --this.bracketNesting;
                    break;
                }
                case INDENT: 
                case DEDENT: {
                    this.indentationStack = previous.getIndents();
                    return;
                }
            }
        }
    }

    public PythonLexer(CharSequence input) {
        this("input", input);
    }

    public PythonLexer(String inputSource, CharSequence input) {
        this(inputSource, input, LexicalState.PYTHON, 1, 1);
    }

    public PythonLexer(String inputSource, CharSequence input, LexicalState lexState, int startingLine, int startingColumn) {
        super(inputSource, input, startingLine, startingColumn, 1, true, false, false, "");
        this.activeTokenTypes.remove(PythonToken.TokenType.MATCH);
        this.activeTokenTypes.remove(PythonToken.TokenType.CASE);
        regularTokens.add(PythonToken.TokenType.INDENT);
        regularTokens.add(PythonToken.TokenType.DEDENT);
        if (this.lexicalState != null) {
            this.switchTo(lexState);
        }
    }

    public PythonToken getNextToken(PythonToken tok) {
        if (tok == null) {
            tok = this.tokenizeAt(0);
            this.cacheToken(tok);
            return tok;
        }
        PythonToken cachedToken = tok.nextCachedToken();
        if (cachedToken != null && this.activeTokenTypes != null && !this.activeTokenTypes.contains(cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        if (cachedToken == null) {
            PythonToken token = this.tokenizeAt(tok.getEndOffset());
            this.cacheToken(token);
            return token;
        }
        return cachedToken;
    }

    static MatchInfo getMatchInfo(CharSequence input, int position, EnumSet<PythonToken.TokenType> activeTokenTypes, NfaFunction[] nfaFunctions) {
        if (position >= input.length()) {
            return new MatchInfo(PythonToken.TokenType.EOF, 0);
        }
        int start = position;
        int matchLength = 0;
        PythonToken.TokenType matchedType = null;
        BitSet currentStates = new BitSet(585);
        BitSet nextStates = new BitSet(585);
        do {
            int curChar;
            if (position > start) {
                BitSet temp = currentStates;
                currentStates = nextStates;
                nextStates = temp;
                nextStates.clear();
            } else {
                currentStates.set(0);
            }
            if (position >= input.length()) break;
            if ((curChar = Character.codePointAt(input, position++)) > 65535) {
                ++position;
            }
            int nextActive = currentStates.nextSetBit(0);
            while (nextActive != -1) {
                PythonToken.TokenType returnedType = nfaFunctions[nextActive].apply(curChar, nextStates, activeTokenTypes);
                if (returnedType != null && (position - start > matchLength || returnedType.ordinal() < matchedType.ordinal())) {
                    matchedType = returnedType;
                    matchLength = position - start;
                }
                nextActive = currentStates.nextSetBit(nextActive + 1);
            }
        } while (position < input.length() && !nextStates.isEmpty());
        return new MatchInfo(matchedType, matchLength);
    }

    final PythonToken tokenizeAt(int position) {
        int tokenBeginOffset = position;
        boolean inMore = false;
        StringBuilder invalidChars = null;
        PythonToken matchedToken = null;
        PythonToken.TokenType matchedType = null;
        while (matchedToken == null) {
            if (!inMore) {
                tokenBeginOffset = position;
            }
            MatchInfo matchInfo = PythonLexer.getMatchInfo(this, position, this.activeTokenTypes, nfaFunctions);
            matchedType = matchInfo.matchedType;
            inMore = moreTokens.contains(matchedType);
            position += matchInfo.matchLength;
            if (matchedType == null) {
                if (invalidChars == null) {
                    invalidChars = new StringBuilder();
                }
                int cp = Character.codePointAt(this, tokenBeginOffset);
                invalidChars.appendCodePoint(cp);
                ++position;
                if (cp <= 65535) continue;
                ++position;
                continue;
            }
            if (invalidChars != null) {
                position = tokenBeginOffset;
                return new InvalidToken(this, tokenBeginOffset - invalidChars.length(), tokenBeginOffset);
            }
            if (skippedTokens.contains(matchedType)) {
                this.skipTokens(tokenBeginOffset, position);
                continue;
            }
            if (!regularTokens.contains(matchedType) && !unparsedTokens.contains(matchedType)) continue;
            matchedToken = PythonToken.newToken(matchedType, this, tokenBeginOffset, position);
            matchedToken.setUnparsed(!regularTokens.contains(matchedType));
        }
        matchedToken = this.tokenHook$PythonLexer_ccc$32$29(matchedToken);
        return matchedToken;
    }

    public boolean switchTo(LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(PythonToken t, LexicalState state) {
        this.resetTokenHook$PythonLexer_ccc$85$17(t);
        this.uncacheTokens(t);
        if (state != null) {
            this.switchTo(state);
        }
    }

    void reset(PythonToken t) {
        this.reset(t, null);
    }

    void cacheToken(PythonToken tok) {
        if (tok.isInserted()) {
            PythonToken next = tok.nextCachedToken();
            if (next != null) {
                this.cacheToken(next);
            }
            return;
        }
        this.cacheTokenAt(tok, tok.getBeginOffset());
    }

    @Override
    protected void uncacheTokens(Node.TerminalNode lastToken) {
        super.uncacheTokens(lastToken);
        ((PythonToken)lastToken).unsetAppendedToken();
    }

    static /* synthetic */ NfaFunction[] access$302(NfaFunction[] x0) {
        nfaFunctions = x0;
        return x0;
    }

    static {
        PYTHON.NFA_FUNCTIONS_init();
    }

    private static class PYTHON {
        private static int[] NFA_MOVES_PYTHON_99 = PYTHON.NFA_MOVES_PYTHON_99_init();
        private static int[] NFA_MOVES_PYTHON_196 = PYTHON.NFA_MOVES_PYTHON_196_init();

        private PYTHON() {
        }

        private static PythonToken.TokenType NFA_PYTHON_0(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 12) {
                nextStates.set(260);
            } else if (ch == 32) {
                nextStates.set(260);
            } else if (ch == 33) {
                nextStates.set(140);
            } else if (ch == 34) {
                nextStates.set(50);
                nextStates.set(113);
            } else if (ch == 37) {
                nextStates.set(173);
            } else if (ch == 38) {
                nextStates.set(339);
            } else if (ch == 39) {
                nextStates.set(337);
                nextStates.set(199);
            } else if (ch == 42) {
                nextStates.set(75);
                nextStates.set(221);
                nextStates.set(44);
            } else if (ch == 43) {
                nextStates.set(308);
            } else if (ch == 45) {
                nextStates.set(53);
                nextStates.set(174);
            } else if (ch == 46) {
                nextStates.set(3);
                nextStates.set(12);
                nextStates.set(269);
            } else if (ch == 47) {
                nextStates.set(100);
                nextStates.set(303);
                nextStates.set(223);
            } else if (ch == 48) {
                nextStates.set(341);
                nextStates.set(117);
                nextStates.set(336);
                nextStates.set(333);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(288);
                nextStates.set(263);
                nextStates.set(22);
                nextStates.set(13);
                nextStates.set(241);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(19);
            } else if (ch == 58) {
                nextStates.set(142);
            } else if (ch == 60) {
                nextStates.set(9);
                nextStates.set(193);
                nextStates.set(197);
            } else if (ch == 61) {
                nextStates.set(229);
            } else if (ch == 62) {
                nextStates.set(1);
                nextStates.set(253);
                nextStates.set(231);
            } else if (ch == 63) {
                nextStates.set(252);
            } else if (ch == 64) {
                nextStates.set(57);
            } else if (ch == 66) {
                nextStates.set(317);
                nextStates.set(311);
                nextStates.set(258);
                nextStates.set(207);
                nextStates.set(201);
                nextStates.set(314);
                nextStates.set(245);
                nextStates.set(98);
                nextStates.set(259);
                nextStates.set(34);
                nextStates.set(125);
                nextStates.set(208);
            } else if (ch == 70) {
                nextStates.set(16);
                nextStates.set(88);
                nextStates.set(149);
                nextStates.set(282);
                nextStates.set(49);
                nextStates.set(38);
                nextStates.set(77);
                nextStates.set(78);
                nextStates.set(97);
                nextStates.set(232);
                nextStates.set(62);
                nextStates.set(111);
                nextStates.set(103);
            } else if (ch == 78) {
                nextStates.set(68);
            } else if (ch == 82) {
                nextStates.set(184);
                nextStates.set(279);
                nextStates.set(5);
                nextStates.set(335);
                nextStates.set(42);
                nextStates.set(257);
                nextStates.set(8);
                nextStates.set(222);
                nextStates.set(47);
                nextStates.set(111);
                nextStates.set(282);
                nextStates.set(72);
                nextStates.set(161);
                nextStates.set(156);
                nextStates.set(214);
                nextStates.set(112);
                nextStates.set(350);
                nextStates.set(149);
                nextStates.set(88);
                nextStates.set(138);
            } else if (ch == 84) {
                nextStates.set(56);
            } else if (ch == 85) {
                nextStates.set(149);
                nextStates.set(282);
                nextStates.set(111);
                nextStates.set(88);
            } else if (ch == 92) {
                nextStates.set(31);
            } else if (ch == 94) {
                nextStates.set(264);
            } else if (ch == 95) {
                nextStates.set(342);
            } else if (ch == 97) {
                nextStates.set(322);
                nextStates.set(306);
                nextStates.set(352);
                nextStates.set(330);
                nextStates.set(80);
            } else if (ch == 98) {
                nextStates.set(4);
                nextStates.set(91);
                nextStates.set(102);
                nextStates.set(313);
                nextStates.set(107);
                nextStates.set(258);
                nextStates.set(216);
                nextStates.set(259);
                nextStates.set(326);
                nextStates.set(317);
                nextStates.set(201);
                nextStates.set(247);
                nextStates.set(316);
            } else if (ch == 99) {
                nextStates.set(30);
                nextStates.set(291);
                nextStates.set(110);
            } else if (ch == 100) {
                nextStates.set(286);
                nextStates.set(41);
            } else if (ch == 101) {
                nextStates.set(43);
                nextStates.set(17);
                nextStates.set(61);
            } else if (ch == 102) {
                nextStates.set(282);
                nextStates.set(20);
                nextStates.set(219);
                nextStates.set(88);
                nextStates.set(274);
                nextStates.set(66);
                nextStates.set(188);
                nextStates.set(158);
                nextStates.set(149);
                nextStates.set(33);
                nextStates.set(60);
                nextStates.set(111);
                nextStates.set(297);
                nextStates.set(191);
                nextStates.set(254);
            } else if (ch == 103) {
                nextStates.set(295);
            } else if (ch == 105) {
                nextStates.set(194);
                nextStates.set(243);
                nextStates.set(271);
                nextStates.set(127);
            } else if (ch == 108) {
                nextStates.set(233);
            } else if (ch == 109) {
                nextStates.set(157);
            } else if (ch == 110) {
                nextStates.set(329);
                nextStates.set(244);
            } else if (ch == 111) {
                nextStates.set(298);
            } else if (ch == 112) {
                nextStates.set(305);
            } else if (ch == 114) {
                nextStates.set(289);
                nextStates.set(347);
                nextStates.set(282);
                nextStates.set(238);
                nextStates.set(338);
                nextStates.set(64);
                nextStates.set(340);
                nextStates.set(328);
                nextStates.set(139);
                nextStates.set(111);
                nextStates.set(170);
                nextStates.set(343);
                nextStates.set(88);
                nextStates.set(81);
                nextStates.set(354);
                nextStates.set(149);
                nextStates.set(85);
                nextStates.set(106);
                nextStates.set(159);
                nextStates.set(63);
                nextStates.set(87);
                nextStates.set(145);
            } else if (ch == 116) {
                nextStates.set(218);
            } else if (ch == 117) {
                nextStates.set(111);
                nextStates.set(282);
                nextStates.set(88);
                nextStates.set(149);
            } else if (ch == 119) {
                nextStates.set(320);
                nextStates.set(281);
            } else if (ch == 121) {
                nextStates.set(126);
            } else if (ch == 124) {
                nextStates.set(155);
            }
            if (ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && ch <= 65535) {
                nextStates.set(94);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BADNAME)) {
                    type = PythonToken.TokenType.BADNAME;
                }
            }
            if (ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && PythonLexer.checkIntervals(PYTHON.NFA_MOVES_PYTHON_196, ch)) {
                nextStates.set(324);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.NAME)) {
                    type = PythonToken.TokenType.NAME;
                }
            } else if (ch == 48) {
                nextStates.set(83);
                nextStates.set(266);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.DECNUMBER)) {
                    type = PythonToken.TokenType.DECNUMBER;
                }
            } else if (ch >= 49 && ch <= 57) {
                nextStates.set(331);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.DECNUMBER)) {
                    type = PythonToken.TokenType.DECNUMBER;
                }
            } else if (ch == 37) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.PERCENT)) {
                    type = PythonToken.TokenType.PERCENT;
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.SLASH)) {
                    type = PythonToken.TokenType.SLASH;
                }
            } else if (ch == 43) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.PLUS)) {
                    type = PythonToken.TokenType.PLUS;
                }
            } else if (ch == 45) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.MINUS)) {
                    type = PythonToken.TokenType.MINUS;
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.LT)) {
                    type = PythonToken.TokenType.LT;
                }
            } else if (ch == 62) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.GT)) {
                    type = PythonToken.TokenType.GT;
                }
            } else if (ch == 46) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.DOT)) {
                    type = PythonToken.TokenType.DOT;
                }
            } else if (ch == 126) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.TILDE)) {
                    type = PythonToken.TokenType.TILDE;
                }
            } else if (ch == 94) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.XOR)) {
                    type = PythonToken.TokenType.XOR;
                }
            } else if (ch == 124) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BIT_OR)) {
                    type = PythonToken.TokenType.BIT_OR;
                }
            } else if (ch == 38) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BIT_AND)) {
                    type = PythonToken.TokenType.BIT_AND;
                }
            } else if (ch == 42) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.STAR)) {
                    type = PythonToken.TokenType.STAR;
                }
            } else if (ch == 59) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.SEMICOLON)) {
                    type = PythonToken.TokenType.SEMICOLON;
                }
            } else if (ch == 41) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.RPAREN)) {
                    type = PythonToken.TokenType.RPAREN;
                }
            } else if (ch == 40) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.LPAREN)) {
                    type = PythonToken.TokenType.LPAREN;
                }
            } else if (ch == 93) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.RBRACKET)) {
                    type = PythonToken.TokenType.RBRACKET;
                }
            } else if (ch == 91) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.LBRACKET)) {
                    type = PythonToken.TokenType.LBRACKET;
                }
            } else if (ch == 125) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.RBRACE)) {
                    type = PythonToken.TokenType.RBRACE;
                }
            } else if (ch == 123) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.LBRACE)) {
                    type = PythonToken.TokenType.LBRACE;
                }
            } else if (ch == 44) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.COMMA)) {
                    type = PythonToken.TokenType.COMMA;
                }
            } else if (ch == 58) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.COLON)) {
                    type = PythonToken.TokenType.COLON;
                }
            } else if (ch == 64) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.AT)) {
                    type = PythonToken.TokenType.AT;
                }
            } else if (ch == 61) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.ASSIGN)) {
                    type = PythonToken.TokenType.ASSIGN;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.NEWLINE)) {
                    type = PythonToken.TokenType.NEWLINE;
                }
            } else if (ch == 35) {
                nextStates.set(202);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.COMMENT)) {
                    type = PythonToken.TokenType.COMMENT;
                }
            } else if (ch == 12) {
                nextStates.set(51);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.SPACE)) {
                    type = PythonToken.TokenType.SPACE;
                }
            } else if (ch == 32) {
                nextStates.set(51);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.SPACE)) {
                    type = PythonToken.TokenType.SPACE;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_1(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 62 && (validTypes == null || validTypes.contains(PythonToken.TokenType.RSHIFT))) {
                type = PythonToken.TokenType.RSHIFT;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_2(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(PythonToken.TokenType.ELSE))) {
                type = PythonToken.TokenType.ELSE;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_3(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 46) {
                nextStates.set(172);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_4(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(201);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_5(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 70) {
                nextStates.set(282);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_6(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(151);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_7(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(137);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_8(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(317);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_9(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.LE))) {
                type = PythonToken.TokenType.LE;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_10(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(73);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_11(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 127) {
                nextStates.set(228);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_12(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(262);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_13(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(13);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(210);
            } else if (ch == 95) {
                nextStates.set(168);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_14(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(121);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_15(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(321);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_16(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(149);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_17(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(248);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_18(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(45);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(18);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_19(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(19);
            } else if (ch == 76 || ch == 108) {
                nextStates.set(55);
            } else if (ch == 95) {
                nextStates.set(261);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_20(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(149);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_21(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 104 && (validTypes == null || validTypes.contains(PythonToken.TokenType.WITH))) {
                type = PythonToken.TokenType.WITH;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_22(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(132);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(153);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BADDECNUMBER)) {
                    type = PythonToken.TokenType.BADDECNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_23(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(PythonToken.TokenType.RAISE))) {
                type = PythonToken.TokenType.RAISE;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_24(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(227);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_25(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 127) {
                nextStates.set(74);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_26(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(144);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_27(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(195);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_28(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114 && (validTypes == null || validTypes.contains(PythonToken.TokenType.FOR))) {
                type = PythonToken.TokenType.FOR;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_29(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(PythonToken.TokenType.CONTINUE))) {
                type = PythonToken.TokenType.CONTINUE;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_30(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(236);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_31(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 10 && (validTypes == null || validTypes.contains(PythonToken.TokenType.CONTINUE_LINE))) {
                type = PythonToken.TokenType.CONTINUE_LINE;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_32(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(315);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_33(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(349);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_34(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(259);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_35(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.RSHIFTASSIGN))) {
                type = PythonToken.TokenType.RSHIFTASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_36(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(348);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_37(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(288);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_38(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(88);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_39(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(PythonToken.TokenType.YIELD))) {
                type = PythonToken.TokenType.YIELD;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_40(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(162);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_41(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(167);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_42(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(111);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_43(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(6);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_44(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STARASSIGN))) {
                type = PythonToken.TokenType.STARASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_45(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(18);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_46(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(268);
            } else if (ch == 39) {
                nextStates.set(190);
            }
            if (ch == 92) {
                nextStates.set(196);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_47(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 66) {
                nextStates.set(201);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_48(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(148);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(315);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_49(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(88);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_50(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(237);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_51(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 12) {
                nextStates.set(51);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.SPACE)) {
                    type = PythonToken.TokenType.SPACE;
                }
            } else if (ch == 32) {
                nextStates.set(51);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.SPACE)) {
                    type = PythonToken.TokenType.SPACE;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_52(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(PythonToken.TokenType.RETURN))) {
                type = PythonToken.TokenType.RETURN;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_53(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.MINUSASSIGN))) {
                type = PythonToken.TokenType.MINUSASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_54(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(251);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_55(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_56(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(225);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_57(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.ATASSIGN))) {
                type = PythonToken.TokenType.ATASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_58(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(345);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_59(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(PythonToken.TokenType.TRUE))) {
                type = PythonToken.TokenType.TRUE;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_60(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(88);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_61(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 120) {
                nextStates.set(235);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_62(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(282);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_63(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(88);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_64(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 66) {
                nextStates.set(201);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_65(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(224);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_66(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(86);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_67(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(268);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_68(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(65);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_69(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(300);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_70(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(309);
            }
            if (ch == 92) {
                nextStates.set(76);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_71(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(24);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_72(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(282);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_73(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STRING_LITERAL))) {
                type = PythonToken.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_74(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(74);
            } else if (ch == 34) {
                nextStates.set(124);
                nextStates.set(206);
            }
            if (ch == 92) {
                nextStates.set(25);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_75(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 42 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STAR_STAR))) {
                type = PythonToken.TokenType.STAR_STAR;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_76(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0) {
                nextStates.set(309);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_77(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(111);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_78(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(282);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_79(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97 && (validTypes == null || validTypes.contains(PythonToken.TokenType.LAMBDA))) {
                type = PythonToken.TokenType.LAMBDA;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_80(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(212);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_81(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(209);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_82(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(PythonToken.TokenType.FALSE))) {
                type = PythonToken.TokenType.FALSE;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_83(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(181);
            } else if (ch == 48 || ch == 49) {
                nextStates.set(92);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BINNUMBER)) {
                    type = PythonToken.TokenType.BINNUMBER;
                }
            } else if (ch == 66 || ch == 98) {
                nextStates.set(92);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BINNUMBER)) {
                    type = PythonToken.TokenType.BINNUMBER;
                }
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(PythonToken.TokenType.BINNUMBER))) {
                type = PythonToken.TokenType.BINNUMBER;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_84(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(147);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_85(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(259);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_86(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(131);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_87(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(204);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_88(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(199);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_89(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(134);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_90(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(272);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(18);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_91(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(259);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_92(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(181);
            } else if (ch == 48 || ch == 49) {
                nextStates.set(92);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BINNUMBER)) {
                    type = PythonToken.TokenType.BINNUMBER;
                }
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(PythonToken.TokenType.BINNUMBER))) {
                type = PythonToken.TokenType.BINNUMBER;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_93(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(109);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_94(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && ch <= 65535) {
                nextStates.set(94);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BADNAME)) {
                    type = PythonToken.TokenType.BADNAME;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_95(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(166);
            } else if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(95);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.HEXNUMBER)) {
                    type = PythonToken.TokenType.HEXNUMBER;
                }
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(PythonToken.TokenType.HEXNUMBER))) {
                type = PythonToken.TokenType.HEXNUMBER;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_96(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(PythonToken.TokenType.NOT))) {
                type = PythonToken.TokenType.NOT;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_97(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(111);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_98(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(317);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_99(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(154);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_100(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.SLASHASSIGN))) {
                type = PythonToken.TokenType.SLASHASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_101(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(241);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_102(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(317);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_103(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(149);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_104(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(217);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_105(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(PythonToken.TokenType.NONLOCAL))) {
                type = PythonToken.TokenType.NONLOCAL;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_106(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 66) {
                nextStates.set(317);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_107(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(201);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_108(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(39);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_109(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(116);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_110(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(319);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_111(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(337);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_112(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 70) {
                nextStates.set(149);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_113(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(113);
            } else if (ch == 92) {
                nextStates.set(152);
            } else if (ch == 34 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STRING_LITERAL))) {
                type = PythonToken.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_114(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(292);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_115(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(351);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_116(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 121 && (validTypes == null || validTypes.contains(PythonToken.TokenType.FINALLY))) {
                type = PythonToken.TokenType.FINALLY;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_117(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 48) {
                nextStates.set(117);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_118(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(284);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_119(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STARSTARASSIGN))) {
                type = PythonToken.TokenType.STARSTARASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_120(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(215);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_121(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(120);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_122(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(278);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_123(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(123);
            } else if (ch == 92) {
                nextStates.set(280);
            } else if (ch == 34 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STRING_LITERAL))) {
                type = PythonToken.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_124(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(74);
            } else if (ch == 34) {
                nextStates.set(226);
            }
            if (ch == 92) {
                nextStates.set(25);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_125(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(317);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_126(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(239);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_127(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(PythonToken.TokenType.IS))) {
                type = PythonToken.TokenType.IS;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_128(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(186);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_129(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(93);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_130(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(27);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(195);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_131(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 109 && (validTypes == null || validTypes.contains(PythonToken.TokenType.FROM))) {
                type = PythonToken.TokenType.FROM;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_132(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(153);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BADDECNUMBER)) {
                    type = PythonToken.TokenType.BADDECNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_133(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 109) {
                nextStates.set(255);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_134(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(134);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(48);
            } else if (ch == 95) {
                nextStates.set(89);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_135(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(135);
            } else if (ch == 39) {
                nextStates.set(171);
                nextStates.set(299);
            }
            if (ch == 92) {
                nextStates.set(177);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_136(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(135);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_137(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(PythonToken.TokenType.CLASS))) {
                type = PythonToken.TokenType.CLASS;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_138(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(258);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_139(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 70) {
                nextStates.set(282);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_140(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.NE))) {
                type = PythonToken.TokenType.NE;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_141(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(150);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.OCTNUMBER)) {
                    type = PythonToken.TokenType.OCTNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_142(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.COLONEQUALS))) {
                type = PythonToken.TokenType.COLONEQUALS;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_143(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 112) {
                nextStates.set(99);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_144(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(187);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_145(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(282);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_146(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STRING_LITERAL))) {
                type = PythonToken.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_147(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(310);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_148(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(315);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_149(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(113);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_150(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(141);
            } else if (ch >= 48 && ch <= 55) {
                nextStates.set(150);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.OCTNUMBER)) {
                    type = PythonToken.TokenType.OCTNUMBER;
                }
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(PythonToken.TokenType.OCTNUMBER))) {
                type = PythonToken.TokenType.OCTNUMBER;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_151(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102 && (validTypes == null || validTypes.contains(PythonToken.TokenType.ELIF))) {
                type = PythonToken.TokenType.ELIF;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_152(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0) {
                nextStates.set(113);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_153(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(132);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(153);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BADDECNUMBER)) {
                    type = PythonToken.TokenType.BADDECNUMBER;
                }
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(PythonToken.TokenType.BADDECNUMBER))) {
                type = PythonToken.TokenType.BADDECNUMBER;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_154(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 103) {
                nextStates.set(250);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_155(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.ORASSIGN))) {
                type = PythonToken.TokenType.ORASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_156(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(201);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_157(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(84);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_158(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(111);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_159(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 70) {
                nextStates.set(111);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_160(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(186);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_161(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 70) {
                nextStates.set(111);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_162(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(162);
            } else if (ch == 95) {
                nextStates.set(40);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_163(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 48) {
                nextStates.set(163);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_164(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(169);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_165(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(213);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_166(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(95);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.HEXNUMBER)) {
                    type = PythonToken.TokenType.HEXNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_167(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(PythonToken.TokenType.DEL))) {
                type = PythonToken.TokenType.DEL;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_168(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(13);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_169(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(130);
            } else if (ch == 95) {
                nextStates.set(164);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(169);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_170(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(317);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_171(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(146);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_172(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 46 && (validTypes == null || validTypes.contains(PythonToken.TokenType.ELLIPSIS))) {
                type = PythonToken.TokenType.ELLIPSIS;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_173(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.REMASSIGN))) {
                type = PythonToken.TokenType.REMASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_174(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 62 && (validTypes == null || validTypes.contains(PythonToken.TokenType.RARROW))) {
                type = PythonToken.TokenType.RARROW;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_175(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(PythonToken.TokenType.EXCEPT))) {
                type = PythonToken.TokenType.EXCEPT;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_176(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(180);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_177(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0) {
                nextStates.set(135);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_178(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(263);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_179(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 112) {
                nextStates.set(175);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_180(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(180);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(325);
            } else if (ch == 95) {
                nextStates.set(176);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_181(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 48 || ch == 49) {
                nextStates.set(92);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.BINNUMBER)) {
                    type = PythonToken.TokenType.BINNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_182(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STRING_LITERAL))) {
                type = PythonToken.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_183(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(195);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_184(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 70) {
                nextStates.set(88);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_185(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(351);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_186(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(186);
            } else if (ch == 95) {
                nextStates.set(160);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_187(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 107 && (validTypes == null || validTypes.contains(PythonToken.TokenType.BREAK))) {
                type = PythonToken.TokenType.BREAK;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_188(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(88);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_189(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(PythonToken.TokenType.PASS))) {
                type = PythonToken.TokenType.PASS;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_190(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(268);
            }
            if (ch == 92) {
                nextStates.set(196);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_191(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(111);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_192(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(67);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_193(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 60 && (validTypes == null || validTypes.contains(PythonToken.TokenType.LSHIFT))) {
                type = PythonToken.TokenType.LSHIFT;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_194(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102 && (validTypes == null || validTypes.contains(PythonToken.TokenType.IF))) {
                type = PythonToken.TokenType.IF;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_195(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(183);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(195);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_196(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 127) {
                nextStates.set(268);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_197(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 60) {
                nextStates.set(275);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_198(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(331);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.DECNUMBER)) {
                    type = PythonToken.TokenType.DECNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_199(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(136);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_200(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 112) {
                nextStates.set(118);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_201(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(302);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_202(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch >= 11) {
                nextStates.set(202);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.COMMENT)) {
                    type = PythonToken.TokenType.COMMENT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_203(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95 && (validTypes == null || validTypes.contains(PythonToken.TokenType.PEG_PARSER))) {
                type = PythonToken.TokenType.PEG_PARSER;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_204(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(285);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_205(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 100) {
                nextStates.set(79);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_206(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(182);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_207(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(258);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_208(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(258);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_209(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(122);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_210(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(211);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(162);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_211(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(162);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_212(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 121) {
                nextStates.set(346);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_213(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(312);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_214(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(259);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_215(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(PythonToken.TokenType._ASSERT))) {
                type = PythonToken.TokenType._ASSERT;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_216(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(258);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_217(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STRING_LITERAL))) {
                type = PythonToken.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_218(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(283);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_219(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(282);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_220(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(189);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_221(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 42) {
                nextStates.set(119);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_222(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(149);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_223(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 47 && (validTypes == null || validTypes.contains(PythonToken.TokenType.SLASHSLASH))) {
                type = PythonToken.TokenType.SLASHSLASH;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_224(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(PythonToken.TokenType.NONE))) {
                type = PythonToken.TokenType.NONE;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_225(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(59);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_226(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(74);
            }
            if (ch == 92) {
                nextStates.set(25);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_227(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(29);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_228(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(228);
            } else if (ch == 92) {
                nextStates.set(11);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STRING_LITERAL))) {
                type = PythonToken.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_229(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.EQ))) {
                type = PythonToken.TokenType.EQ;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_230(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102 && (validTypes == null || validTypes.contains(PythonToken.TokenType.DEF))) {
                type = PythonToken.TokenType.DEF;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_231(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 62) {
                nextStates.set(35);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_232(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(294);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_233(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(133);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_234(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 99 && (validTypes == null || validTypes.contains(PythonToken.TokenType.ASYNC))) {
                type = PythonToken.TokenType.ASYNC;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_235(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(265);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_236(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(323);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_237(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(309);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_238(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(258);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_239(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(108);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_240(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(74);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_241(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 46) {
                nextStates.set(134);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(241);
            } else if (ch == 95) {
                nextStates.set(101);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_242(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(262);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_243(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 109) {
                nextStates.set(200);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_244(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(96);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_245(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(259);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_246(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(318);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_247(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(259);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_248(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(2);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_249(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(PythonToken.TokenType.WHILE))) {
                type = PythonToken.TokenType.WHILE;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_250(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(353);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_251(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(256);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_252(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 32 && (validTypes == null || validTypes.contains(PythonToken.TokenType.HOOK))) {
                type = PythonToken.TokenType.HOOK;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_253(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.GE))) {
                type = PythonToken.TokenType.GE;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_254(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(149);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_255(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(205);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_256(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(246);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_257(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 66) {
                nextStates.set(259);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_258(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(192);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_259(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(123);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_260(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 12) {
                nextStates.set(260);
            } else if (ch == 32) {
                nextStates.set(260);
            } else if (ch == 10 && (validTypes == null || validTypes.contains(PythonToken.TokenType.NEWLINE))) {
                type = PythonToken.TokenType.NEWLINE;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_261(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(19);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_262(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(90);
            } else if (ch == 95) {
                nextStates.set(242);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(262);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_263(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(263);
            } else if (ch == 95) {
                nextStates.set(178);
            } else if (ch == 46) {
                nextStates.set(169);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_264(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.XORASSIGN))) {
                type = PythonToken.TokenType.XORASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_265(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(179);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_266(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 48) {
                nextStates.set(266);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.DECNUMBER)) {
                    type = PythonToken.TokenType.DECNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_267(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(105);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_268(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(268);
            } else if (ch == 39) {
                nextStates.set(46);
                nextStates.set(104);
            }
            if (ch == 92) {
                nextStates.set(196);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_269(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(180);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_270(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(PythonToken.TokenType.IMPORT))) {
                type = PythonToken.TokenType.IMPORT;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_271(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(PythonToken.TokenType.IN))) {
                type = PythonToken.TokenType.IN;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_272(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(18);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_273(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(PythonToken.TokenType.AWAIT))) {
                type = PythonToken.TokenType.AWAIT;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_274(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(282);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_275(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.LSHIFTASSIGN))) {
                type = PythonToken.TokenType.LSHIFTASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_276(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(135);
            }
            if (ch == 92) {
                nextStates.set(177);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_277(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.SLASHSLASHASSIGN))) {
                type = PythonToken.TokenType.SLASHSLASHASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_278(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(52);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_279(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 66) {
                nextStates.set(317);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_280(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 127) {
                nextStates.set(123);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_281(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 104) {
                nextStates.set(58);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_282(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(50);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_283(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 121 && (validTypes == null || validTypes.contains(PythonToken.TokenType.TRY))) {
                type = PythonToken.TokenType.TRY;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_284(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(270);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_285(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(23);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_286(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(230);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_287(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(166);
            } else if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(95);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.HEXNUMBER)) {
                    type = PythonToken.TokenType.HEXNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_288(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(288);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(290);
            } else if (ch == 95) {
                nextStates.set(37);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_289(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 70) {
                nextStates.set(149);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_290(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(115);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(351);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_291(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(69);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_292(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(36);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_293(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0) {
                nextStates.set(337);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_294(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(301);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_295(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(114);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_296(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(PythonToken.TokenType.AND))) {
                type = PythonToken.TokenType.AND;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_297(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(28);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_298(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114 && (validTypes == null || validTypes.contains(PythonToken.TokenType.OR))) {
                type = PythonToken.TokenType.OR;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_299(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(135);
            } else if (ch == 39) {
                nextStates.set(276);
            }
            if (ch == 92) {
                nextStates.set(177);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_300(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(PythonToken.TokenType.CASE))) {
                type = PythonToken.TokenType.CASE;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_301(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(82);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_302(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(240);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_303(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 47) {
                nextStates.set(277);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_304(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(203);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_305(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(220);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_306(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(296);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_307(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(309);
            } else if (ch == 34) {
                nextStates.set(70);
            }
            if (ch == 92) {
                nextStates.set(76);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_308(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.PLUSASSIGN))) {
                type = PythonToken.TokenType.PLUSASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_309(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(309);
            } else if (ch == 34) {
                nextStates.set(10);
                nextStates.set(307);
            }
            if (ch == 92) {
                nextStates.set(76);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_310(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 104 && (validTypes == null || validTypes.contains(PythonToken.TokenType.MATCH))) {
                type = PythonToken.TokenType.MATCH;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_311(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(201);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_312(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(267);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_313(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(26);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_314(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(201);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_315(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(315);
            } else if (ch == 95) {
                nextStates.set(32);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_316(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(317);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_317(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 39) {
                nextStates.set(228);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_318(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(304);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_319(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(7);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_320(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(332);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_321(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(273);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_322(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 119) {
                nextStates.set(15);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_323(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(71);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_324(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && PythonLexer.checkIntervals(PYTHON.NFA_MOVES_PYTHON_99, ch)) {
                nextStates.set(324);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.NAME)) {
                    type = PythonToken.TokenType.NAME;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_325(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(128);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(186);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_326(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 82) {
                nextStates.set(258);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_327(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(334);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_328(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(201);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_329(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(344);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_330(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(PythonToken.TokenType.AS))) {
                type = PythonToken.TokenType.AS;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_331(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(198);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(331);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.DECNUMBER)) {
                    type = PythonToken.TokenType.DECNUMBER;
                }
            } else if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(PythonToken.TokenType.DECNUMBER))) {
                type = PythonToken.TokenType.DECNUMBER;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_332(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(21);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_333(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 48) {
                nextStates.set(163);
            } else if (ch >= 49 && ch <= 57) {
                nextStates.set(334);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_334(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(334);
            } else if (ch == 76 || ch == 108) {
                nextStates.set(55);
            } else if (ch == 95) {
                nextStates.set(327);
            } else if (!(ch != 74 && ch != 106 || validTypes != null && !validTypes.contains(PythonToken.TokenType.COMPLEX))) {
                type = PythonToken.TokenType.COMPLEX;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_335(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(88);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_336(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(150);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.OCTNUMBER)) {
                    type = PythonToken.TokenType.OCTNUMBER;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_337(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch >= 11 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(337);
            } else if (ch == 92) {
                nextStates.set(293);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(PythonToken.TokenType.STRING_LITERAL))) {
                type = PythonToken.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_338(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(149);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_339(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(PythonToken.TokenType.ANDASSIGN))) {
                type = PythonToken.TokenType.ANDASSIGN;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_340(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(111);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_341(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 88 || ch == 120) {
                nextStates.set(287);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_342(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(143);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_343(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 66) {
                nextStates.set(259);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_344(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(165);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_345(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(249);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_346(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(234);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_347(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 66) {
                nextStates.set(258);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_348(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(PythonToken.TokenType.GLOBAL))) {
                type = PythonToken.TokenType.GLOBAL;
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_349(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(129);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_350(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 66) {
                nextStates.set(258);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_351(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(185);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(351);
                if (validTypes == null || validTypes.contains(PythonToken.TokenType.FLOAT)) {
                    type = PythonToken.TokenType.FLOAT;
                }
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_352(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(14);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_353(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 112) {
                nextStates.set(54);
            }
            return type;
        }

        private static PythonToken.TokenType NFA_PYTHON_354(int ch, BitSet nextStates, EnumSet<PythonToken.TokenType> validTypes) {
            PythonToken.TokenType type = null;
            if (ch == 70) {
                nextStates.set(88);
            }
            return type;
        }

        private static int[] NFA_MOVES_PYTHON_99_init() {
            return new int[]{48, 57, 65, 90, 95, 95, 97, 122, 170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 318, 321, 705, 710, 721, 736, 740, 748, 748, 750, 750, 768, 884, 886, 887, 891, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1155, 1159, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1488, 1514, 1519, 1522, 1552, 1562, 1568, 1641, 1646, 1747, 1749, 1756, 1759, 1768, 1770, 1788, 1791, 1791, 1808, 1866, 1869, 1969, 1984, 2037, 2042, 2042, 2045, 2045, 2048, 2093, 2112, 2139, 2144, 2154, 2208, 2228, 2230, 2247, 2259, 2273, 2275, 2403, 2406, 2415, 2417, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2500, 2503, 2504, 2507, 2510, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2545, 2556, 2556, 2558, 2558, 2561, 2563, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2649, 2652, 2654, 2654, 2662, 2677, 2689, 2691, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2787, 2790, 2799, 2809, 2815, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2876, 2884, 2887, 2888, 2891, 2893, 2901, 2903, 2908, 2909, 2911, 2915, 2918, 2927, 2929, 2929, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3024, 3024, 3031, 3031, 3046, 3055, 3072, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3160, 3162, 3168, 3171, 3174, 3183, 3200, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3260, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3294, 3294, 3296, 3299, 3302, 3311, 3313, 3314, 3328, 3340, 3342, 3344, 3346, 3396, 3398, 3400, 3402, 3406, 3412, 3415, 3423, 3427, 3430, 3439, 3450, 3455, 3457, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3558, 3567, 3570, 3571, 3585, 3642, 3648, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3807, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3948, 3953, 3972, 3974, 3991, 3993, 4028, 4038, 4038, 4096, 4169, 4176, 4253, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4957, 4959, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5900, 5902, 5908, 5920, 5940, 5952, 5971, 5984, 5996, 5998, 6000, 6002, 6003, 6016, 6099, 6103, 6103, 6108, 6109, 6112, 6121, 6155, 6157, 6160, 6169, 6176, 6264, 6272, 6314, 6320, 6389, 6400, 6430, 6432, 6443, 6448, 6459, 6470, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6608, 6617, 6656, 6683, 6688, 6750, 6752, 6780, 6783, 6793, 6800, 6809, 6823, 6823, 6832, 6845, 6847, 6848, 6912, 6987, 6992, 7001, 7019, 7027, 7040, 7155, 7168, 7223, 7232, 7241, 7245, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7376, 7378, 7380, 7418, 7424, 7673, 7675, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8255, 8256, 8276, 8276, 8305, 8305, 8319, 8319, 8336, 8348, 8400, 8412, 8417, 8417, 8421, 8432, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11310, 11312, 11358, 11360, 11492, 11499, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11647, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11744, 11775, 11823, 11823, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12348, 12353, 12438, 12441, 12442, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 40956, 40960, 42124, 42192, 42237, 42240, 42508, 42512, 42539, 42560, 42607, 42612, 42621, 42623, 42737, 42775, 42783, 42786, 42888, 42891, 42943, 42946, 42954, 42997, 43047, 43052, 43052, 43072, 43123, 43136, 43205, 43216, 43225, 43232, 43255, 43259, 43259, 43261, 43309, 43312, 43347, 43360, 43388, 43392, 43456, 43471, 43481, 43488, 43518, 43520, 43574, 43584, 43597, 43600, 43609, 43616, 43638, 43642, 43714, 43739, 43741, 43744, 43759, 43762, 43766, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44010, 44012, 44013, 44016, 44025, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64605, 64612, 64829, 64848, 64911, 64914, 64967, 65008, 65017, 65024, 65039, 65056, 65071, 65075, 65076, 65101, 65103, 65137, 65137, 65139, 65139, 65143, 65143, 65145, 65145, 65147, 65147, 65149, 65149, 65151, 65276, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66045, 66045, 66176, 66204, 66208, 66256, 66272, 66272, 66304, 66335, 66349, 66378, 66384, 66426, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66720, 66729, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 67072, 67382, 67392, 67413, 67424, 67431, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68099, 68101, 68102, 68108, 68115, 68117, 68119, 68121, 68149, 68152, 68154, 68159, 68159, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68326, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68903, 68912, 68921, 69248, 69289, 69291, 69292, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69456, 69552, 69572, 69600, 69622, 69632, 69702, 69734, 69743, 69759, 69818, 69840, 69864, 69872, 69881, 69888, 69940, 69942, 69951, 69956, 69959, 69968, 70003, 70006, 70006, 70016, 70084, 70089, 70092, 70094, 70106, 70108, 70108, 70144, 70161, 70163, 70199, 70206, 70206, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70378, 70384, 70393, 70400, 70403, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70459, 70468, 70471, 70472, 70475, 70477, 70480, 70480, 70487, 70487, 70493, 70499, 70502, 70508, 70512, 70516, 70656, 70730, 70736, 70745, 70750, 70753, 70784, 70853, 70855, 70855, 70864, 70873, 71040, 71093, 71096, 71104, 71128, 71133, 71168, 71232, 71236, 71236, 71248, 71257, 71296, 71352, 71360, 71369, 71424, 71450, 71453, 71467, 71472, 71481, 71680, 71738, 71840, 71913, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71989, 71991, 71992, 71995, 72003, 72016, 72025, 72096, 72103, 72106, 72151, 72154, 72161, 72163, 72164, 72192, 72254, 72263, 72263, 72272, 72345, 72349, 72349, 72384, 72440, 72704, 72712, 72714, 72758, 72760, 72768, 72784, 72793, 72818, 72847, 72850, 72871, 72873, 72886, 72960, 72966, 72968, 72969, 72971, 73014, 73018, 73018, 73020, 73021, 73023, 73031, 73040, 73049, 73056, 73061, 73063, 73064, 73066, 73102, 73104, 73105, 73107, 73112, 73120, 73129, 73440, 73462, 73648, 73648, 73728, 74649, 74752, 74862, 74880, 75075, 77824, 78894, 82944, 83526, 92160, 92728, 92736, 92766, 92768, 92777, 92880, 92909, 92912, 92916, 92928, 92982, 92992, 92995, 93008, 93017, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94031, 94087, 94095, 94111, 94176, 94177, 94179, 94180, 94192, 94193, 94208, 100343, 100352, 101589, 101632, 101640, 110592, 110878, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 113821, 113822, 119141, 119145, 119149, 119154, 119163, 119170, 119173, 119179, 119210, 119213, 119362, 119364, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 120782, 120831, 121344, 121398, 121403, 121452, 121461, 121461, 121476, 121476, 121499, 121503, 121505, 121519, 122880, 122886, 122888, 122904, 122907, 122913, 122915, 122916, 122918, 122922, 123136, 123180, 123184, 123197, 123200, 123209, 123214, 123214, 123584, 123641, 124928, 125124, 125136, 125142, 125184, 125259, 125264, 125273, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 130032, 130041, 131072, 173789, 173824, 177972, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546, 917760, 917999};
        }

        private static int[] NFA_MOVES_PYTHON_196_init() {
            return new int[]{65, 90, 95, 95, 97, 122, 170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 318, 321, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 884, 886, 887, 891, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1488, 1514, 1519, 1522, 1568, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2048, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2144, 2154, 2208, 2228, 2230, 2247, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2432, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2545, 2556, 2556, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2809, 2809, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3133, 3160, 3162, 3168, 3169, 3200, 3200, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3294, 3294, 3296, 3297, 3313, 3314, 3332, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3412, 3414, 3423, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3634, 3648, 3654, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3760, 3762, 3762, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5900, 5902, 5905, 5920, 5937, 5952, 5969, 5984, 5996, 5998, 6000, 6016, 6067, 6103, 6103, 6108, 6108, 6176, 6264, 6272, 6276, 6279, 6312, 6314, 6314, 6320, 6389, 6400, 6430, 6480, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6987, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7401, 7404, 7406, 7411, 7413, 7414, 7418, 7418, 7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8305, 8305, 8319, 8319, 8336, 8348, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11310, 11312, 11358, 11360, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11823, 11823, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 40956, 40960, 42124, 42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539, 42560, 42606, 42623, 42653, 42656, 42735, 42775, 42783, 42786, 42888, 42891, 42943, 42946, 42954, 42997, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43261, 43262, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43488, 43492, 43494, 43503, 43514, 43518, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43638, 43642, 43642, 43646, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43741, 43744, 43754, 43762, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64605, 64612, 64829, 64848, 64911, 64914, 64967, 65008, 65017, 65137, 65137, 65139, 65139, 65143, 65143, 65145, 65145, 65147, 65147, 65149, 65149, 65151, 65276, 65313, 65338, 65345, 65370, 65382, 65437, 65440, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66176, 66204, 66208, 66256, 66304, 66335, 66349, 66378, 66384, 66421, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 67072, 67382, 67392, 67413, 67424, 67431, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68096, 68112, 68115, 68117, 68119, 68121, 68149, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68324, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68899, 69248, 69289, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69445, 69552, 69572, 69600, 69622, 69635, 69687, 69763, 69807, 69840, 69864, 69891, 69926, 69956, 69956, 69959, 69959, 69968, 70002, 70006, 70006, 70019, 70066, 70081, 70084, 70106, 70106, 70108, 70108, 70144, 70161, 70163, 70187, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70366, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70461, 70461, 70480, 70480, 70493, 70497, 70656, 70708, 70727, 70730, 70751, 70753, 70784, 70831, 70852, 70853, 70855, 70855, 71040, 71086, 71128, 71131, 71168, 71215, 71236, 71236, 71296, 71338, 71352, 71352, 71424, 71450, 71680, 71723, 71840, 71903, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71983, 71999, 71999, 72001, 72001, 72096, 72103, 72106, 72144, 72161, 72161, 72163, 72163, 72192, 72192, 72203, 72242, 72250, 72250, 72272, 72272, 72284, 72329, 72349, 72349, 72384, 72440, 72704, 72712, 72714, 72750, 72768, 72768, 72818, 72847, 72960, 72966, 72968, 72969, 72971, 73008, 73030, 73030, 73056, 73061, 73063, 73064, 73066, 73097, 73112, 73112, 73440, 73458, 73648, 73648, 73728, 74649, 74752, 74862, 74880, 75075, 77824, 78894, 82944, 83526, 92160, 92728, 92736, 92766, 92880, 92909, 92928, 92975, 92992, 92995, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94032, 94032, 94099, 94111, 94176, 94177, 94179, 94179, 94208, 100343, 100352, 101589, 101632, 101640, 110592, 110878, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 123136, 123180, 123191, 123197, 123214, 123214, 123584, 123627, 124928, 125124, 125184, 125251, 125259, 125259, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 131072, 173789, 173824, 177972, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546};
        }

        private static void NFA_FUNCTIONS_init() {
            PythonLexer.access$302(new NfaFunction[]{PYTHON::NFA_PYTHON_0, PYTHON::NFA_PYTHON_1, PYTHON::NFA_PYTHON_2, PYTHON::NFA_PYTHON_3, PYTHON::NFA_PYTHON_4, PYTHON::NFA_PYTHON_5, PYTHON::NFA_PYTHON_6, PYTHON::NFA_PYTHON_7, PYTHON::NFA_PYTHON_8, PYTHON::NFA_PYTHON_9, PYTHON::NFA_PYTHON_10, PYTHON::NFA_PYTHON_11, PYTHON::NFA_PYTHON_12, PYTHON::NFA_PYTHON_13, PYTHON::NFA_PYTHON_14, PYTHON::NFA_PYTHON_15, PYTHON::NFA_PYTHON_16, PYTHON::NFA_PYTHON_17, PYTHON::NFA_PYTHON_18, PYTHON::NFA_PYTHON_19, PYTHON::NFA_PYTHON_20, PYTHON::NFA_PYTHON_21, PYTHON::NFA_PYTHON_22, PYTHON::NFA_PYTHON_23, PYTHON::NFA_PYTHON_24, PYTHON::NFA_PYTHON_25, PYTHON::NFA_PYTHON_26, PYTHON::NFA_PYTHON_27, PYTHON::NFA_PYTHON_28, PYTHON::NFA_PYTHON_29, PYTHON::NFA_PYTHON_30, PYTHON::NFA_PYTHON_31, PYTHON::NFA_PYTHON_32, PYTHON::NFA_PYTHON_33, PYTHON::NFA_PYTHON_34, PYTHON::NFA_PYTHON_35, PYTHON::NFA_PYTHON_36, PYTHON::NFA_PYTHON_37, PYTHON::NFA_PYTHON_38, PYTHON::NFA_PYTHON_39, PYTHON::NFA_PYTHON_40, PYTHON::NFA_PYTHON_41, PYTHON::NFA_PYTHON_42, PYTHON::NFA_PYTHON_43, PYTHON::NFA_PYTHON_44, PYTHON::NFA_PYTHON_45, PYTHON::NFA_PYTHON_46, PYTHON::NFA_PYTHON_47, PYTHON::NFA_PYTHON_48, PYTHON::NFA_PYTHON_49, PYTHON::NFA_PYTHON_50, PYTHON::NFA_PYTHON_51, PYTHON::NFA_PYTHON_52, PYTHON::NFA_PYTHON_53, PYTHON::NFA_PYTHON_54, PYTHON::NFA_PYTHON_55, PYTHON::NFA_PYTHON_56, PYTHON::NFA_PYTHON_57, PYTHON::NFA_PYTHON_58, PYTHON::NFA_PYTHON_59, PYTHON::NFA_PYTHON_60, PYTHON::NFA_PYTHON_61, PYTHON::NFA_PYTHON_62, PYTHON::NFA_PYTHON_63, PYTHON::NFA_PYTHON_64, PYTHON::NFA_PYTHON_65, PYTHON::NFA_PYTHON_66, PYTHON::NFA_PYTHON_67, PYTHON::NFA_PYTHON_68, PYTHON::NFA_PYTHON_69, PYTHON::NFA_PYTHON_70, PYTHON::NFA_PYTHON_71, PYTHON::NFA_PYTHON_72, PYTHON::NFA_PYTHON_73, PYTHON::NFA_PYTHON_74, PYTHON::NFA_PYTHON_75, PYTHON::NFA_PYTHON_76, PYTHON::NFA_PYTHON_77, PYTHON::NFA_PYTHON_78, PYTHON::NFA_PYTHON_79, PYTHON::NFA_PYTHON_80, PYTHON::NFA_PYTHON_81, PYTHON::NFA_PYTHON_82, PYTHON::NFA_PYTHON_83, PYTHON::NFA_PYTHON_84, PYTHON::NFA_PYTHON_85, PYTHON::NFA_PYTHON_86, PYTHON::NFA_PYTHON_87, PYTHON::NFA_PYTHON_88, PYTHON::NFA_PYTHON_89, PYTHON::NFA_PYTHON_90, PYTHON::NFA_PYTHON_91, PYTHON::NFA_PYTHON_92, PYTHON::NFA_PYTHON_93, PYTHON::NFA_PYTHON_94, PYTHON::NFA_PYTHON_95, PYTHON::NFA_PYTHON_96, PYTHON::NFA_PYTHON_97, PYTHON::NFA_PYTHON_98, PYTHON::NFA_PYTHON_99, PYTHON::NFA_PYTHON_100, PYTHON::NFA_PYTHON_101, PYTHON::NFA_PYTHON_102, PYTHON::NFA_PYTHON_103, PYTHON::NFA_PYTHON_104, PYTHON::NFA_PYTHON_105, PYTHON::NFA_PYTHON_106, PYTHON::NFA_PYTHON_107, PYTHON::NFA_PYTHON_108, PYTHON::NFA_PYTHON_109, PYTHON::NFA_PYTHON_110, PYTHON::NFA_PYTHON_111, PYTHON::NFA_PYTHON_112, PYTHON::NFA_PYTHON_113, PYTHON::NFA_PYTHON_114, PYTHON::NFA_PYTHON_115, PYTHON::NFA_PYTHON_116, PYTHON::NFA_PYTHON_117, PYTHON::NFA_PYTHON_118, PYTHON::NFA_PYTHON_119, PYTHON::NFA_PYTHON_120, PYTHON::NFA_PYTHON_121, PYTHON::NFA_PYTHON_122, PYTHON::NFA_PYTHON_123, PYTHON::NFA_PYTHON_124, PYTHON::NFA_PYTHON_125, PYTHON::NFA_PYTHON_126, PYTHON::NFA_PYTHON_127, PYTHON::NFA_PYTHON_128, PYTHON::NFA_PYTHON_129, PYTHON::NFA_PYTHON_130, PYTHON::NFA_PYTHON_131, PYTHON::NFA_PYTHON_132, PYTHON::NFA_PYTHON_133, PYTHON::NFA_PYTHON_134, PYTHON::NFA_PYTHON_135, PYTHON::NFA_PYTHON_136, PYTHON::NFA_PYTHON_137, PYTHON::NFA_PYTHON_138, PYTHON::NFA_PYTHON_139, PYTHON::NFA_PYTHON_140, PYTHON::NFA_PYTHON_141, PYTHON::NFA_PYTHON_142, PYTHON::NFA_PYTHON_143, PYTHON::NFA_PYTHON_144, PYTHON::NFA_PYTHON_145, PYTHON::NFA_PYTHON_146, PYTHON::NFA_PYTHON_147, PYTHON::NFA_PYTHON_148, PYTHON::NFA_PYTHON_149, PYTHON::NFA_PYTHON_150, PYTHON::NFA_PYTHON_151, PYTHON::NFA_PYTHON_152, PYTHON::NFA_PYTHON_153, PYTHON::NFA_PYTHON_154, PYTHON::NFA_PYTHON_155, PYTHON::NFA_PYTHON_156, PYTHON::NFA_PYTHON_157, PYTHON::NFA_PYTHON_158, PYTHON::NFA_PYTHON_159, PYTHON::NFA_PYTHON_160, PYTHON::NFA_PYTHON_161, PYTHON::NFA_PYTHON_162, PYTHON::NFA_PYTHON_163, PYTHON::NFA_PYTHON_164, PYTHON::NFA_PYTHON_165, PYTHON::NFA_PYTHON_166, PYTHON::NFA_PYTHON_167, PYTHON::NFA_PYTHON_168, PYTHON::NFA_PYTHON_169, PYTHON::NFA_PYTHON_170, PYTHON::NFA_PYTHON_171, PYTHON::NFA_PYTHON_172, PYTHON::NFA_PYTHON_173, PYTHON::NFA_PYTHON_174, PYTHON::NFA_PYTHON_175, PYTHON::NFA_PYTHON_176, PYTHON::NFA_PYTHON_177, PYTHON::NFA_PYTHON_178, PYTHON::NFA_PYTHON_179, PYTHON::NFA_PYTHON_180, PYTHON::NFA_PYTHON_181, PYTHON::NFA_PYTHON_182, PYTHON::NFA_PYTHON_183, PYTHON::NFA_PYTHON_184, PYTHON::NFA_PYTHON_185, PYTHON::NFA_PYTHON_186, PYTHON::NFA_PYTHON_187, PYTHON::NFA_PYTHON_188, PYTHON::NFA_PYTHON_189, PYTHON::NFA_PYTHON_190, PYTHON::NFA_PYTHON_191, PYTHON::NFA_PYTHON_192, PYTHON::NFA_PYTHON_193, PYTHON::NFA_PYTHON_194, PYTHON::NFA_PYTHON_195, PYTHON::NFA_PYTHON_196, PYTHON::NFA_PYTHON_197, PYTHON::NFA_PYTHON_198, PYTHON::NFA_PYTHON_199, PYTHON::NFA_PYTHON_200, PYTHON::NFA_PYTHON_201, PYTHON::NFA_PYTHON_202, PYTHON::NFA_PYTHON_203, PYTHON::NFA_PYTHON_204, PYTHON::NFA_PYTHON_205, PYTHON::NFA_PYTHON_206, PYTHON::NFA_PYTHON_207, PYTHON::NFA_PYTHON_208, PYTHON::NFA_PYTHON_209, PYTHON::NFA_PYTHON_210, PYTHON::NFA_PYTHON_211, PYTHON::NFA_PYTHON_212, PYTHON::NFA_PYTHON_213, PYTHON::NFA_PYTHON_214, PYTHON::NFA_PYTHON_215, PYTHON::NFA_PYTHON_216, PYTHON::NFA_PYTHON_217, PYTHON::NFA_PYTHON_218, PYTHON::NFA_PYTHON_219, PYTHON::NFA_PYTHON_220, PYTHON::NFA_PYTHON_221, PYTHON::NFA_PYTHON_222, PYTHON::NFA_PYTHON_223, PYTHON::NFA_PYTHON_224, PYTHON::NFA_PYTHON_225, PYTHON::NFA_PYTHON_226, PYTHON::NFA_PYTHON_227, PYTHON::NFA_PYTHON_228, PYTHON::NFA_PYTHON_229, PYTHON::NFA_PYTHON_230, PYTHON::NFA_PYTHON_231, PYTHON::NFA_PYTHON_232, PYTHON::NFA_PYTHON_233, PYTHON::NFA_PYTHON_234, PYTHON::NFA_PYTHON_235, PYTHON::NFA_PYTHON_236, PYTHON::NFA_PYTHON_237, PYTHON::NFA_PYTHON_238, PYTHON::NFA_PYTHON_239, PYTHON::NFA_PYTHON_240, PYTHON::NFA_PYTHON_241, PYTHON::NFA_PYTHON_242, PYTHON::NFA_PYTHON_243, PYTHON::NFA_PYTHON_244, PYTHON::NFA_PYTHON_245, PYTHON::NFA_PYTHON_246, PYTHON::NFA_PYTHON_247, PYTHON::NFA_PYTHON_248, PYTHON::NFA_PYTHON_249, PYTHON::NFA_PYTHON_250, PYTHON::NFA_PYTHON_251, PYTHON::NFA_PYTHON_252, PYTHON::NFA_PYTHON_253, PYTHON::NFA_PYTHON_254, PYTHON::NFA_PYTHON_255, PYTHON::NFA_PYTHON_256, PYTHON::NFA_PYTHON_257, PYTHON::NFA_PYTHON_258, PYTHON::NFA_PYTHON_259, PYTHON::NFA_PYTHON_260, PYTHON::NFA_PYTHON_261, PYTHON::NFA_PYTHON_262, PYTHON::NFA_PYTHON_263, PYTHON::NFA_PYTHON_264, PYTHON::NFA_PYTHON_265, PYTHON::NFA_PYTHON_266, PYTHON::NFA_PYTHON_267, PYTHON::NFA_PYTHON_268, PYTHON::NFA_PYTHON_269, PYTHON::NFA_PYTHON_270, PYTHON::NFA_PYTHON_271, PYTHON::NFA_PYTHON_272, PYTHON::NFA_PYTHON_273, PYTHON::NFA_PYTHON_274, PYTHON::NFA_PYTHON_275, PYTHON::NFA_PYTHON_276, PYTHON::NFA_PYTHON_277, PYTHON::NFA_PYTHON_278, PYTHON::NFA_PYTHON_279, PYTHON::NFA_PYTHON_280, PYTHON::NFA_PYTHON_281, PYTHON::NFA_PYTHON_282, PYTHON::NFA_PYTHON_283, PYTHON::NFA_PYTHON_284, PYTHON::NFA_PYTHON_285, PYTHON::NFA_PYTHON_286, PYTHON::NFA_PYTHON_287, PYTHON::NFA_PYTHON_288, PYTHON::NFA_PYTHON_289, PYTHON::NFA_PYTHON_290, PYTHON::NFA_PYTHON_291, PYTHON::NFA_PYTHON_292, PYTHON::NFA_PYTHON_293, PYTHON::NFA_PYTHON_294, PYTHON::NFA_PYTHON_295, PYTHON::NFA_PYTHON_296, PYTHON::NFA_PYTHON_297, PYTHON::NFA_PYTHON_298, PYTHON::NFA_PYTHON_299, PYTHON::NFA_PYTHON_300, PYTHON::NFA_PYTHON_301, PYTHON::NFA_PYTHON_302, PYTHON::NFA_PYTHON_303, PYTHON::NFA_PYTHON_304, PYTHON::NFA_PYTHON_305, PYTHON::NFA_PYTHON_306, PYTHON::NFA_PYTHON_307, PYTHON::NFA_PYTHON_308, PYTHON::NFA_PYTHON_309, PYTHON::NFA_PYTHON_310, PYTHON::NFA_PYTHON_311, PYTHON::NFA_PYTHON_312, PYTHON::NFA_PYTHON_313, PYTHON::NFA_PYTHON_314, PYTHON::NFA_PYTHON_315, PYTHON::NFA_PYTHON_316, PYTHON::NFA_PYTHON_317, PYTHON::NFA_PYTHON_318, PYTHON::NFA_PYTHON_319, PYTHON::NFA_PYTHON_320, PYTHON::NFA_PYTHON_321, PYTHON::NFA_PYTHON_322, PYTHON::NFA_PYTHON_323, PYTHON::NFA_PYTHON_324, PYTHON::NFA_PYTHON_325, PYTHON::NFA_PYTHON_326, PYTHON::NFA_PYTHON_327, PYTHON::NFA_PYTHON_328, PYTHON::NFA_PYTHON_329, PYTHON::NFA_PYTHON_330, PYTHON::NFA_PYTHON_331, PYTHON::NFA_PYTHON_332, PYTHON::NFA_PYTHON_333, PYTHON::NFA_PYTHON_334, PYTHON::NFA_PYTHON_335, PYTHON::NFA_PYTHON_336, PYTHON::NFA_PYTHON_337, PYTHON::NFA_PYTHON_338, PYTHON::NFA_PYTHON_339, PYTHON::NFA_PYTHON_340, PYTHON::NFA_PYTHON_341, PYTHON::NFA_PYTHON_342, PYTHON::NFA_PYTHON_343, PYTHON::NFA_PYTHON_344, PYTHON::NFA_PYTHON_345, PYTHON::NFA_PYTHON_346, PYTHON::NFA_PYTHON_347, PYTHON::NFA_PYTHON_348, PYTHON::NFA_PYTHON_349, PYTHON::NFA_PYTHON_350, PYTHON::NFA_PYTHON_351, PYTHON::NFA_PYTHON_352, PYTHON::NFA_PYTHON_353, PYTHON::NFA_PYTHON_354});
        }
    }

    static interface NfaFunction {
        public PythonToken.TokenType apply(int var1, BitSet var2, EnumSet<PythonToken.TokenType> var3);
    }

    static class MatchInfo {
        PythonToken.TokenType matchedType;
        int matchLength;

        MatchInfo(PythonToken.TokenType matchedType, int matchLength) {
            this.matchedType = matchedType;
            this.matchLength = matchLength;
        }
    }

    public static enum LexicalState {
        PYTHON;

    }
}

