/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.parser.csharp;

import java.util.BitSet;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.congocc.parser.TokenSource;
import org.congocc.parser.csharp.CSToken;
import org.congocc.parser.csharp.InvalidToken;
import org.parsers.csharp.ppline.PPDirectiveLineParser;

public class CSLexer
extends TokenSource {
    private String pendingString = "";
    private int startingQuotes;
    private int startingDollars;
    private boolean parsingOn = true;
    private boolean alreadyHandled;
    private boolean seenElse;
    private int ifNesting;
    private int turnedOffPoint;
    private BitSet parsingOnStack = new BitSet(1000);
    private BitSet seenElseStack = new BitSet(1000);
    private BitSet alreadyHandledStack = new BitSet(1000);
    private Set<String> ppSymbols = new HashSet<String>();
    LexicalState lexicalState;
    EnumSet<CSToken.TokenType> activeTokenTypes;
    private static EnumMap<CSToken.TokenType, LexicalState> tokenTypeToLexicalStateMap = new EnumMap(CSToken.TokenType.class);
    static final EnumSet<CSToken.TokenType> regularTokens = EnumSet.of(CSToken.TokenType.EOF, new CSToken.TokenType[]{CSToken.TokenType.INTEGER_LITERAL, CSToken.TokenType.REAL_LITERAL, CSToken.TokenType.FALSE, CSToken.TokenType.TRUE, CSToken.TokenType.NULL, CSToken.TokenType.LPAREN, CSToken.TokenType.RPAREN, CSToken.TokenType.RBRACE, CSToken.TokenType.LBRACKET, CSToken.TokenType.RBRACKET, CSToken.TokenType.SEMICOLON, CSToken.TokenType.COMMA, CSToken.TokenType.GT, CSToken.TokenType.LT, CSToken.TokenType.BANG, CSToken.TokenType.TILDE, CSToken.TokenType.HOOK, CSToken.TokenType.DOUBLE_HOOK, CSToken.TokenType.DOUBLE_HOOK_EQUALS, CSToken.TokenType.COLON, CSToken.TokenType.EQ, CSToken.TokenType.LE, CSToken.TokenType.GE, CSToken.TokenType.NE, CSToken.TokenType.SC_OR, CSToken.TokenType.SC_AND, CSToken.TokenType.INCR, CSToken.TokenType.DECR, CSToken.TokenType.PLUS, CSToken.TokenType.MINUS, CSToken.TokenType.STAR, CSToken.TokenType.SLASH, CSToken.TokenType.BIT_AND, CSToken.TokenType.BIT_OR, CSToken.TokenType.HAT, CSToken.TokenType.REM, CSToken.TokenType.LEFT_SHIFT, CSToken.TokenType.PLUSASSIGN, CSToken.TokenType.MINUSASSIGN, CSToken.TokenType.STARASSIGN, CSToken.TokenType.SLASHASSIGN, CSToken.TokenType.ANDASSIGN, CSToken.TokenType.ORASSIGN, CSToken.TokenType.XORASSIGN, CSToken.TokenType.REMASSIGN, CSToken.TokenType.LEFT_SHIFT_ASSIGN, CSToken.TokenType.RIGHT_SHIFT, CSToken.TokenType.RIGHT_SHIFT_ASSIGN, CSToken.TokenType.ARROW, CSToken.TokenType.POINTER_ACCESS, CSToken.TokenType.ASSIGN, CSToken.TokenType.DOUBLE_COLON, CSToken.TokenType.DOT, CSToken.TokenType.RANGE, CSToken.TokenType.VAR_ARGS, CSToken.TokenType.AT, CSToken.TokenType.ABSTRACT, CSToken.TokenType.AS, CSToken.TokenType.BASE, CSToken.TokenType.BOOL, CSToken.TokenType.BREAK, CSToken.TokenType.BYTE, CSToken.TokenType.CASE, CSToken.TokenType.CATCH, CSToken.TokenType.CHAR, CSToken.TokenType.CHECKED, CSToken.TokenType.CLASS, CSToken.TokenType.CONST, CSToken.TokenType.CONTINUE, CSToken.TokenType.DECIMAL, CSToken.TokenType.DEFAULT, CSToken.TokenType.DELEGATE, CSToken.TokenType.DO, CSToken.TokenType.DOUBLE, CSToken.TokenType.DYNAMIC, CSToken.TokenType.ELSE, CSToken.TokenType.ENUM, CSToken.TokenType.EVENT, CSToken.TokenType.EXPLICIT, CSToken.TokenType.EXTERN, CSToken.TokenType.FINALLY, CSToken.TokenType.FIXED, CSToken.TokenType.FLOAT, CSToken.TokenType.FOR, CSToken.TokenType.FOREACH, CSToken.TokenType.GOTO, CSToken.TokenType.IF, CSToken.TokenType.IMPLICIT, CSToken.TokenType.IN, CSToken.TokenType.INT, CSToken.TokenType.INTERFACE, CSToken.TokenType.INTERNAL, CSToken.TokenType.IS, CSToken.TokenType.LOCK, CSToken.TokenType.LONG, CSToken.TokenType.NAMESPACE, CSToken.TokenType.NEW, CSToken.TokenType.OBJECT, CSToken.TokenType.OPERATOR, CSToken.TokenType.OUT, CSToken.TokenType.OVERRIDE, CSToken.TokenType.PARAMS, CSToken.TokenType.PRIVATE, CSToken.TokenType.PROTECTED, CSToken.TokenType.PUBLIC, CSToken.TokenType.READONLY, CSToken.TokenType.REF, CSToken.TokenType.RETURN, CSToken.TokenType.SBYTE, CSToken.TokenType.SEALED, CSToken.TokenType.SHORT, CSToken.TokenType.SIZEOF, CSToken.TokenType.STACKALLOC, CSToken.TokenType.STATIC, CSToken.TokenType.STRING, CSToken.TokenType.STRUCT, CSToken.TokenType.SWITCH, CSToken.TokenType.THIS, CSToken.TokenType.THROW, CSToken.TokenType.TRY, CSToken.TokenType.TYPEOF, CSToken.TokenType.UINT, CSToken.TokenType.ULONG, CSToken.TokenType.UNCHECKED, CSToken.TokenType.UNSAFE, CSToken.TokenType.USHORT, CSToken.TokenType.USING, CSToken.TokenType.VIRTUAL, CSToken.TokenType.VOID, CSToken.TokenType.VOLATILE, CSToken.TokenType.WHILE, CSToken.TokenType.ARGLIST, CSToken.TokenType.ADD, CSToken.TokenType.ASSEMBLY, CSToken.TokenType.ASYNC, CSToken.TokenType.AWAIT, CSToken.TokenType.GET, CSToken.TokenType.INIT, CSToken.TokenType.MODULE, CSToken.TokenType.NAMEOF, CSToken.TokenType.PARTIAL, CSToken.TokenType.RECORD, CSToken.TokenType.REMOVE, CSToken.TokenType.REQUIRED, CSToken.TokenType.SET, CSToken.TokenType.VAR, CSToken.TokenType.WHEN, CSToken.TokenType.YIELD, CSToken.TokenType.AND, CSToken.TokenType.OR, CSToken.TokenType.NOT, CSToken.TokenType.WITH, CSToken.TokenType.ASCENDING, CSToken.TokenType.BY, CSToken.TokenType.DESCENDING, CSToken.TokenType.EQUALS, CSToken.TokenType.FROM, CSToken.TokenType.GROUP, CSToken.TokenType.INTO, CSToken.TokenType.JOIN, CSToken.TokenType.LET, CSToken.TokenType.ON, CSToken.TokenType.ORDERBY, CSToken.TokenType.SELECT, CSToken.TokenType.WHERE, CSToken.TokenType.IDENTIFIER, CSToken.TokenType.CHARACTER_LITERAL, CSToken.TokenType.REGULAR_STRING_LITERAL, CSToken.TokenType.VERBATIM_STRING_LITERAL, CSToken.TokenType.REGULAR_INTERPOLATION_START, CSToken.TokenType.MULTI_INTERPOLATION_START, CSToken.TokenType.INTERPOLATED_RAW_STRING_START, CSToken.TokenType.NON_INTERPOLATED_TEXT, CSToken.TokenType.NON_INTERPOLATED_TEXT2, CSToken.TokenType.LBRACE, CSToken.TokenType.ENDING_QUOTE, CSToken.TokenType.START_INTERPOLATION, CSToken.TokenType.NON_INTERPOLATED_TEXT3, CSToken.TokenType.END_RAW_INTERPOLATION, CSToken.TokenType.INTERPOLATED_RAW_STRING_END, CSToken.TokenType.RAW_STRING_LITERAL});
    static final EnumSet<CSToken.TokenType> unparsedTokens = EnumSet.of(CSToken.TokenType.MULTI_LINE_COMMENT, new CSToken.TokenType[]{CSToken.TokenType.SINGLE_LINE_COMMENT, CSToken.TokenType.HASH_IF, CSToken.TokenType.HASH_ELIF, CSToken.TokenType.HASH_ELSE, CSToken.TokenType.HASH_ENDIF, CSToken.TokenType.HASH});
    static final EnumSet<CSToken.TokenType> skippedTokens = EnumSet.of(CSToken.TokenType.WHITESPACE, CSToken.TokenType._TOKEN_184);
    static final EnumSet<CSToken.TokenType> moreTokens = EnumSet.of(CSToken.TokenType.RAW_STRING_START, CSToken.TokenType.ANY_CHAR);
    private static final EnumMap<LexicalState, NfaFunction[]> functionTableMap;

    private CSToken tokenHook$CSharpLexer_ccc$349$29(CSToken tok) {
        CSToken.TokenType type = tok.getType();
        if (type == CSToken.TokenType.INTERPOLATED_RAW_STRING_START) {
            String image = tok.getImage();
            this.startingDollars = 0;
            this.startingQuotes = 0;
            for (int i = 0; i < image.length(); ++i) {
                char ch = image.charAt(i);
                if (ch == '\"') {
                    ++this.startingQuotes;
                    continue;
                }
                if (ch == '$') {
                    ++this.startingDollars;
                    continue;
                }
                break;
            }
        } else {
            if (type == CSToken.TokenType.INTERPOLATED_RAW_STRING_END) {
                if (tok.getImage().length() < this.startingQuotes) {
                    tok.setType(CSToken.TokenType.NON_INTERPOLATED_TEXT3);
                }
                return tok;
            }
            if (type == CSToken.TokenType.NON_INTERPOLATED_TEXT3) {
                int amountToExtend;
                int followingOpenBraces = 0;
                for (int k = tok.getEndOffset(); k < this.length(); ++k) {
                    if (this.isIgnored(k)) continue;
                    if (this.charAt(k) != '{') break;
                    ++followingOpenBraces;
                }
                if ((amountToExtend = followingOpenBraces - this.startingDollars) < 0) {
                    amountToExtend = followingOpenBraces;
                }
                tok.setEndOffset(tok.getEndOffset() + amountToExtend);
            } else {
                if (type == CSToken.TokenType.START_INTERPOLATION) {
                    int tokLength = tok.getImage().length();
                    if (tokLength > this.startingDollars) {
                        tok.setEndOffset(tok.getEndOffset() - (tokLength - this.startingDollars));
                        tok.setType(CSToken.TokenType.NON_INTERPOLATED_TEXT3);
                        return tok;
                    }
                    if (tok.getImage().length() < this.startingDollars) {
                        tok.setType(CSToken.TokenType.NON_INTERPOLATED_TEXT3);
                        return tok;
                    }
                    return tok;
                }
                if (type == CSToken.TokenType.END_RAW_INTERPOLATION) {
                    if (tok.getImage().length() < this.startingDollars) {
                        tok.setType(CSToken.TokenType.NON_INTERPOLATED_TEXT3);
                        return tok;
                    }
                    return tok;
                }
                if (tok.getType() == CSToken.TokenType.RAW_STRING_LITERAL) {
                    String image = tok.getImage();
                    if (this.pendingString == "" && this.endsWithEnoughQuotes(image)) {
                        this.switchTo(LexicalState.CSHARP);
                        return tok;
                    }
                    this.pendingString = this.pendingString + tok.getImage();
                    if (this.endsWithEnoughQuotes(this.pendingString)) {
                        tok.setBeginOffset(tok.getEndOffset() - this.pendingString.length());
                        this.pendingString = "";
                        this.switchTo(LexicalState.CSHARP);
                        return tok;
                    }
                    tok.setUnparsed(true);
                }
            }
        }
        return tok;
    }

    private boolean endsWithEnoughQuotes(String img) {
        int startingQuotes = 0;
        int endingQuotes = 0;
        for (int i = 0; i < img.length() && img.charAt(i) == '\"'; ++i) {
            ++startingQuotes;
        }
        for (int j = img.length() - 1; j >= 0 && img.charAt(j) == '\"'; --j) {
            ++endingQuotes;
        }
        return endingQuotes >= startingQuotes;
    }

    void addSymbols(Set<String> symbols) {
        this.ppSymbols.addAll(symbols);
    }

    private CSToken tokenHook$CSharpLexer_ccc$460$29(CSToken tok) {
        CSToken.TokenType type = tok.getType();
        if (type == CSToken.TokenType.EOF) {
            assert (this.ifNesting == 0) : "unclosed #if";
            return tok;
        }
        String image = tok.getImage();
        if (image.length() == 0 || image.charAt(0) != '#') {
            return tok;
        }
        if (!this.atLineStart(tok)) {
            return tok;
        }
        CSToken prevToken = tok.previousCachedToken();
        String line = this.getLine(tok);
        PPDirectiveLineParser.Info info = PPDirectiveLineParser.evaluate(line, this.ppSymbols);
        PPDirectiveLineParser.DirectiveType directiveType = info.directiveType;
        this.setLineSkipped(tok);
        if (directiveType == PPDirectiveLineParser.DirectiveType.UNKNOWN) {
            tok.setType(CSToken.TokenType.INVALID);
            return tok;
        }
        if (this.ifNesting == 0 && (directiveType == PPDirectiveLineParser.DirectiveType.ELIF || directiveType == PPDirectiveLineParser.DirectiveType.ELSE || directiveType == PPDirectiveLineParser.DirectiveType.ENDIF)) {
            tok.setType(CSToken.TokenType.INVALID);
            return tok;
        }
        if (this.seenElse && (directiveType == PPDirectiveLineParser.DirectiveType.ELIF || directiveType == PPDirectiveLineParser.DirectiveType.ELSE)) {
            tok.setType(CSToken.TokenType.INVALID);
            return tok;
        }
        if (directiveType == PPDirectiveLineParser.DirectiveType.ENDIF) {
            this.seenElse = this.seenElseStack.get(this.ifNesting);
            this.alreadyHandled = this.alreadyHandledStack.get(this.ifNesting);
            this.setParsingEnabled(this.parsingOnStack.get(this.ifNesting), tok);
            --this.ifNesting;
        } else if (directiveType == PPDirectiveLineParser.DirectiveType.ELSE) {
            this.seenElse = true;
            this.setParsingEnabled(this.parsingOnStack.get(this.ifNesting) && !this.alreadyHandled, tok);
        } else if (directiveType == PPDirectiveLineParser.DirectiveType.ELIF) {
            this.setParsingEnabled(this.parsingOnStack.get(this.ifNesting) && !this.alreadyHandled && info.evaluationResult, tok);
            this.alreadyHandled |= info.evaluationResult;
        } else if (directiveType == PPDirectiveLineParser.DirectiveType.IF) {
            ++this.ifNesting;
            this.alreadyHandledStack.set(this.ifNesting, this.alreadyHandled);
            this.seenElseStack.set(this.ifNesting, this.seenElse);
            this.parsingOnStack.set(this.ifNesting, this.parsingOn);
            this.seenElse = false;
            this.alreadyHandled = info.evaluationResult;
            this.setParsingEnabled(this.parsingOn && info.evaluationResult, tok);
        }
        return tok;
    }

    void setParsingEnabled(boolean parsingOn, CSToken tok) {
        boolean turnedOff;
        boolean turnedOn = !this.parsingOn && parsingOn;
        boolean bl = turnedOff = this.parsingOn && !parsingOn;
        if (turnedOn) {
            this.switchTo(LexicalState.CSHARP);
            int endRegion = this.getLineEndOffset(tok.getEndLine()) + 1;
            this.setRegionIgnore(this.turnedOffPoint, endRegion);
        }
        if (turnedOff) {
            this.turnedOffPoint = this.getLineStartOffset(tok.getBeginLine());
            this.switchTo(LexicalState.IN_IGNORED_SECTION);
        }
        this.parsingOn = parsingOn;
    }

    public CSLexer(CharSequence input) {
        this("input", input);
    }

    public CSLexer(String inputSource, CharSequence input) {
        this(inputSource, input, LexicalState.CSHARP, 1, 1);
    }

    public CSLexer(String inputSource, CharSequence input, LexicalState lexState, int startingLine, int startingColumn) {
        super(inputSource, input, startingLine, startingColumn, 4, false, false, false, "");
        this.parsingOnStack.set(0);
        this.lexicalState = LexicalState.values()[0];
        this.activeTokenTypes = EnumSet.allOf(CSToken.TokenType.class);
        this.activeTokenTypes.remove(CSToken.TokenType.ADD);
        this.activeTokenTypes.remove(CSToken.TokenType.ASSEMBLY);
        this.activeTokenTypes.remove(CSToken.TokenType.ASYNC);
        this.activeTokenTypes.remove(CSToken.TokenType.AWAIT);
        this.activeTokenTypes.remove(CSToken.TokenType.INTO);
        this.activeTokenTypes.remove(CSToken.TokenType.MODULE);
        this.activeTokenTypes.remove(CSToken.TokenType.NAMEOF);
        this.activeTokenTypes.remove(CSToken.TokenType.PARTIAL);
        this.activeTokenTypes.remove(CSToken.TokenType.RECORD);
        this.activeTokenTypes.remove(CSToken.TokenType.REMOVE);
        this.activeTokenTypes.remove(CSToken.TokenType.VAR);
        this.activeTokenTypes.remove(CSToken.TokenType.WHEN);
        this.activeTokenTypes.remove(CSToken.TokenType.YIELD);
        this.activeTokenTypes.remove(CSToken.TokenType.ARGLIST);
        this.activeTokenTypes.remove(CSToken.TokenType.GET);
        this.activeTokenTypes.remove(CSToken.TokenType.SET);
        this.activeTokenTypes.remove(CSToken.TokenType.INIT);
        this.activeTokenTypes.remove(CSToken.TokenType.WITH);
        this.activeTokenTypes.remove(CSToken.TokenType.REQUIRED);
        this.activeTokenTypes.remove(CSToken.TokenType.AND);
        this.activeTokenTypes.remove(CSToken.TokenType.OR);
        this.activeTokenTypes.remove(CSToken.TokenType.NOT);
        this.activeTokenTypes.remove(CSToken.TokenType.ASCENDING);
        this.activeTokenTypes.remove(CSToken.TokenType.BY);
        this.activeTokenTypes.remove(CSToken.TokenType.DESCENDING);
        this.activeTokenTypes.remove(CSToken.TokenType.EQUALS);
        this.activeTokenTypes.remove(CSToken.TokenType.FROM);
        this.activeTokenTypes.remove(CSToken.TokenType.GROUP);
        this.activeTokenTypes.remove(CSToken.TokenType.JOIN);
        this.activeTokenTypes.remove(CSToken.TokenType.LET);
        this.activeTokenTypes.remove(CSToken.TokenType.ON);
        this.activeTokenTypes.remove(CSToken.TokenType.ORDERBY);
        this.activeTokenTypes.remove(CSToken.TokenType.SELECT);
        this.activeTokenTypes.remove(CSToken.TokenType.WHERE);
        if (this.lexicalState != null) {
            this.switchTo(lexState);
        }
    }

    public CSToken getNextToken(CSToken tok) {
        if (tok == null) {
            tok = this.tokenizeAt(0);
            this.cacheToken(tok);
            return tok;
        }
        CSToken cachedToken = tok.nextCachedToken();
        if (cachedToken != null && this.activeTokenTypes != null && !this.activeTokenTypes.contains(cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        if (cachedToken == null) {
            CSToken token = this.tokenizeAt(tok.getEndOffset());
            this.cacheToken(token);
            return token;
        }
        return cachedToken;
    }

    static MatchInfo getMatchInfo(CharSequence input, int position, EnumSet<CSToken.TokenType> activeTokenTypes, NfaFunction[] nfaFunctions) {
        if (position >= input.length()) {
            return new MatchInfo(CSToken.TokenType.EOF, 0);
        }
        int start = position;
        int matchLength = 0;
        CSToken.TokenType matchedType = null;
        BitSet currentStates = new BitSet(837);
        BitSet nextStates = new BitSet(837);
        do {
            int curChar;
            if (position > start) {
                BitSet temp = currentStates;
                currentStates = nextStates;
                nextStates = temp;
                nextStates.clear();
            } else {
                currentStates.set(0);
            }
            if (position >= input.length()) break;
            if ((curChar = Character.codePointAt(input, position++)) > 65535) {
                ++position;
            }
            int nextActive = currentStates.nextSetBit(0);
            while (nextActive != -1) {
                CSToken.TokenType returnedType = nfaFunctions[nextActive].apply(curChar, nextStates, activeTokenTypes);
                if (returnedType != null && (position - start > matchLength || returnedType.ordinal() < matchedType.ordinal())) {
                    matchedType = returnedType;
                    matchLength = position - start;
                }
                nextActive = currentStates.nextSetBit(nextActive + 1);
            }
        } while (position < input.length() && !nextStates.isEmpty());
        return new MatchInfo(matchedType, matchLength);
    }

    final CSToken tokenizeAt(int position) {
        int tokenBeginOffset = position;
        boolean inMore = false;
        StringBuilder invalidChars = null;
        CSToken matchedToken = null;
        CSToken.TokenType matchedType = null;
        while (matchedToken == null) {
            NfaFunction[] nfaFunctions = functionTableMap.get((Object)this.lexicalState);
            if (!inMore) {
                tokenBeginOffset = position;
            }
            MatchInfo matchInfo = CSLexer.getMatchInfo(this, position, this.activeTokenTypes, nfaFunctions);
            matchedType = matchInfo.matchedType;
            inMore = moreTokens.contains(matchedType);
            position += matchInfo.matchLength;
            LexicalState newState = tokenTypeToLexicalStateMap.get(matchedType);
            if (newState != null) {
                this.lexicalState = newState;
            }
            if (matchedType == null) {
                if (invalidChars == null) {
                    invalidChars = new StringBuilder();
                }
                int cp = Character.codePointAt(this, tokenBeginOffset);
                invalidChars.appendCodePoint(cp);
                ++position;
                if (cp <= 65535) continue;
                ++position;
                continue;
            }
            if (invalidChars != null) {
                position = tokenBeginOffset;
                return new InvalidToken(this, tokenBeginOffset - invalidChars.length(), tokenBeginOffset);
            }
            if (skippedTokens.contains(matchedType)) {
                this.skipTokens(tokenBeginOffset, position);
                continue;
            }
            if (!regularTokens.contains(matchedType) && !unparsedTokens.contains(matchedType)) continue;
            matchedToken = CSToken.newToken(matchedType, this, tokenBeginOffset, position);
            matchedToken.setUnparsed(!regularTokens.contains(matchedType));
        }
        this.doLexicalStateSwitch(matchedToken.getType());
        matchedToken = this.tokenHook$CSharpLexer_ccc$349$29(matchedToken);
        matchedToken = this.tokenHook$CSharpLexer_ccc$460$29(matchedToken);
        return matchedToken;
    }

    boolean doLexicalStateSwitch(CSToken.TokenType tokenType) {
        LexicalState newState = tokenTypeToLexicalStateMap.get(tokenType);
        if (newState == null) {
            return false;
        }
        return this.switchTo(newState);
    }

    public boolean switchTo(LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(CSToken t, LexicalState state) {
        this.uncacheTokens(t);
        if (state != null) {
            this.switchTo(state);
        } else {
            this.doLexicalStateSwitch(t.getType());
        }
    }

    void reset(CSToken t) {
        this.reset(t, null);
    }

    void cacheToken(CSToken tok) {
        this.cacheTokenAt(tok, tok.getBeginOffset());
    }

    private void setRegionIgnore(int start, int end) {
        this.setIgnoredRange(start, end);
    }

    private boolean atLineStart(CSToken tok) {
        int offset = tok.getBeginOffset();
        while (offset > 0) {
            char c;
            if (!Character.isWhitespace(c = this.charAt(--offset))) {
                return false;
            }
            if (c != '\n') continue;
            break;
        }
        return true;
    }

    private String getLine(CSToken tok) {
        int lineNum = tok.getBeginLine();
        return this.getText(this.getLineStartOffset(lineNum), this.getLineEndOffset(lineNum) + 1);
    }

    static {
        tokenTypeToLexicalStateMap.put(CSToken.TokenType.RAW_STRING_START, LexicalState.IN_RAW_STRING);
        functionTableMap = new EnumMap(LexicalState.class);
        CSHARP.NFA_FUNCTIONS_init();
        IN_REGULAR_INTERPOLATION.NFA_FUNCTIONS_init();
        IN_MULTI_INTERPOLATION.NFA_FUNCTIONS_init();
        IN_IGNORED_SECTION.NFA_FUNCTIONS_init();
        IN_INTERPOLATED_RAW_STRING.NFA_FUNCTIONS_init();
        IN_RAW_STRING.NFA_FUNCTIONS_init();
    }

    private static class IN_RAW_STRING {
        private IN_RAW_STRING() {
        }

        private static CSToken.TokenType NFA_IN_RAW_STRING_0(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(1);
            }
            if (ch >= 0 && (validTypes == null || validTypes.contains(CSToken.TokenType.ANY_CHAR))) {
                type = CSToken.TokenType.ANY_CHAR;
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_RAW_STRING_1(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(3);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_RAW_STRING_2(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(2);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.RAW_STRING_LITERAL)) {
                    type = CSToken.TokenType.RAW_STRING_LITERAL;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_RAW_STRING_3(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(2);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.RAW_STRING_LITERAL)) {
                    type = CSToken.TokenType.RAW_STRING_LITERAL;
                }
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{IN_RAW_STRING::NFA_IN_RAW_STRING_0, IN_RAW_STRING::NFA_IN_RAW_STRING_1, IN_RAW_STRING::NFA_IN_RAW_STRING_2, IN_RAW_STRING::NFA_IN_RAW_STRING_3};
            functionTableMap.put(LexicalState.IN_RAW_STRING, functions);
        }
    }

    private static class IN_INTERPOLATED_RAW_STRING {
        private IN_INTERPOLATED_RAW_STRING() {
        }

        private static CSToken.TokenType NFA_IN_INTERPOLATED_RAW_STRING_0(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(4);
            } else if (ch == 125) {
                nextStates.set(3);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.END_RAW_INTERPOLATION)) {
                    type = CSToken.TokenType.END_RAW_INTERPOLATION;
                }
            } else if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(2);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT3)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT3;
                }
            }
            if (ch == 34) {
                nextStates.set(5);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT3)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT3;
                }
            } else if (ch == 123) {
                nextStates.set(6);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.START_INTERPOLATION)) {
                    type = CSToken.TokenType.START_INTERPOLATION;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_INTERPOLATED_RAW_STRING_1(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(7);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTERPOLATED_RAW_STRING_END)) {
                    type = CSToken.TokenType.INTERPOLATED_RAW_STRING_END;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_INTERPOLATED_RAW_STRING_2(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(2);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT3)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT3;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_INTERPOLATED_RAW_STRING_3(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 125) {
                nextStates.set(3);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.END_RAW_INTERPOLATION)) {
                    type = CSToken.TokenType.END_RAW_INTERPOLATION;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_INTERPOLATED_RAW_STRING_4(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(1);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_INTERPOLATED_RAW_STRING_5(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34 && (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT3))) {
                type = CSToken.TokenType.NON_INTERPOLATED_TEXT3;
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_INTERPOLATED_RAW_STRING_6(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 123) {
                nextStates.set(6);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.START_INTERPOLATION)) {
                    type = CSToken.TokenType.START_INTERPOLATION;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_INTERPOLATED_RAW_STRING_7(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(7);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTERPOLATED_RAW_STRING_END)) {
                    type = CSToken.TokenType.INTERPOLATED_RAW_STRING_END;
                }
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{IN_INTERPOLATED_RAW_STRING::NFA_IN_INTERPOLATED_RAW_STRING_0, IN_INTERPOLATED_RAW_STRING::NFA_IN_INTERPOLATED_RAW_STRING_1, IN_INTERPOLATED_RAW_STRING::NFA_IN_INTERPOLATED_RAW_STRING_2, IN_INTERPOLATED_RAW_STRING::NFA_IN_INTERPOLATED_RAW_STRING_3, IN_INTERPOLATED_RAW_STRING::NFA_IN_INTERPOLATED_RAW_STRING_4, IN_INTERPOLATED_RAW_STRING::NFA_IN_INTERPOLATED_RAW_STRING_5, IN_INTERPOLATED_RAW_STRING::NFA_IN_INTERPOLATED_RAW_STRING_6, IN_INTERPOLATED_RAW_STRING::NFA_IN_INTERPOLATED_RAW_STRING_7};
            functionTableMap.put(LexicalState.IN_INTERPOLATED_RAW_STRING, functions);
        }
    }

    private static class IN_IGNORED_SECTION {
        private static int[] NFA_MOVES_IN_IGNORED_SECTION_1 = IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_1_init();
        private static int[] NFA_MOVES_IN_IGNORED_SECTION_9 = IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_9_init();
        private static int[] NFA_MOVES_IN_IGNORED_SECTION_13 = IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_13_init();
        private static int[] NFA_MOVES_IN_IGNORED_SECTION_15 = IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_15_init();
        private static int[] NFA_MOVES_IN_IGNORED_SECTION_17 = IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_17_init();
        private static int[] NFA_MOVES_IN_IGNORED_SECTION_19 = IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_19_init();
        private static int[] NFA_MOVES_IN_IGNORED_SECTION_22 = IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_22_init();
        private static int[] NFA_MOVES_IN_IGNORED_SECTION_30 = IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_30_init();

        private IN_IGNORED_SECTION() {
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_0(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 35) {
                nextStates.set(14);
                nextStates.set(20);
                nextStates.set(19);
                nextStates.set(10);
            }
            if (ch >= 0 && (validTypes == null || validTypes.contains(CSToken.TokenType._TOKEN_184))) {
                type = CSToken.TokenType._TOKEN_184;
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_1(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(12);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_2(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 47) {
                nextStates.set(13);
            } else if (ch == 9 || ch == 11 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_22, ch)) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.HASH_ELSE)) {
                    type = CSToken.TokenType.HASH_ELSE;
                }
            } else if (ch == 10 && (validTypes == null || validTypes.contains(CSToken.TokenType.HASH_ELSE))) {
                type = CSToken.TokenType.HASH_ELSE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_3(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 47) {
                nextStates.set(15);
            } else if (ch == 9 || ch == 11 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_15, ch)) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.HASH_ENDIF)) {
                    type = CSToken.TokenType.HASH_ENDIF;
                }
            } else if (ch == 10 && (validTypes == null || validTypes.contains(CSToken.TokenType.HASH_ENDIF))) {
                type = CSToken.TokenType.HASH_ENDIF;
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_4(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(9);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_5(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if ((ch == 9 || ch == 11 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_19, ch)) && (validTypes == null || validTypes.contains(CSToken.TokenType.HASH_IF))) {
                type = CSToken.TokenType.HASH_IF;
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_6(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(7);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_7(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(2);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_8(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(6);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_9(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100) {
                nextStates.set(21);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_10(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 9 || ch == 11 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_17, ch)) {
                nextStates.set(10);
            } else if (ch == 101) {
                nextStates.set(1);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_11(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(16);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_12(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(11);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_13(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 47 && (validTypes == null || validTypes.contains(CSToken.TokenType.HASH_ELSE))) {
                type = CSToken.TokenType.HASH_ELSE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_14(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 9 || ch == 11 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_1, ch)) {
                nextStates.set(14);
            } else if (ch == 101) {
                nextStates.set(8);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_15(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 47 && (validTypes == null || validTypes.contains(CSToken.TokenType.HASH_ENDIF))) {
                type = CSToken.TokenType.HASH_ENDIF;
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_16(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if ((ch == 9 || ch == 11 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_30, ch)) && (validTypes == null || validTypes.contains(CSToken.TokenType.HASH_ELIF))) {
                type = CSToken.TokenType.HASH_ELIF;
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_17(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(5);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_18(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(3);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_19(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 9 || ch == 11 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_9, ch)) {
                nextStates.set(19);
            } else if (ch == 105) {
                nextStates.set(17);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_20(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 9 || ch == 11 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_13, ch)) {
                nextStates.set(20);
            } else if (ch == 101) {
                nextStates.set(4);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_IGNORED_SECTION_21(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(18);
            }
            return type;
        }

        private static int[] NFA_MOVES_IN_IGNORED_SECTION_1_init() {
            return new int[]{9, 9, 11, 11, 32, 32, 160, 160, 5760, 5760, 8192, 8202, 8239, 8239, 8287, 8287, 12288, 12288};
        }

        private static int[] NFA_MOVES_IN_IGNORED_SECTION_9_init() {
            return new int[]{9, 9, 11, 11, 32, 32, 160, 160, 5760, 5760, 8192, 8202, 8239, 8239, 8287, 8287, 12288, 12288};
        }

        private static int[] NFA_MOVES_IN_IGNORED_SECTION_13_init() {
            return new int[]{9, 9, 11, 11, 32, 32, 160, 160, 5760, 5760, 8192, 8202, 8239, 8239, 8287, 8287, 12288, 12288};
        }

        private static int[] NFA_MOVES_IN_IGNORED_SECTION_15_init() {
            return new int[]{9, 9, 11, 11, 32, 32, 160, 160, 5760, 5760, 8192, 8202, 8239, 8239, 8287, 8287, 12288, 12288};
        }

        private static int[] NFA_MOVES_IN_IGNORED_SECTION_17_init() {
            return new int[]{9, 9, 11, 11, 32, 32, 160, 160, 5760, 5760, 8192, 8202, 8239, 8239, 8287, 8287, 12288, 12288};
        }

        private static int[] NFA_MOVES_IN_IGNORED_SECTION_19_init() {
            return new int[]{9, 9, 11, 11, 32, 32, 160, 160, 5760, 5760, 8192, 8202, 8239, 8239, 8287, 8287, 12288, 12288};
        }

        private static int[] NFA_MOVES_IN_IGNORED_SECTION_22_init() {
            return new int[]{9, 9, 11, 11, 32, 32, 160, 160, 5760, 5760, 8192, 8202, 8239, 8239, 8287, 8287, 12288, 12288};
        }

        private static int[] NFA_MOVES_IN_IGNORED_SECTION_30_init() {
            return new int[]{9, 9, 11, 11, 32, 32, 160, 160, 5760, 5760, 8192, 8202, 8239, 8239, 8287, 8287, 12288, 12288};
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_0, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_1, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_2, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_3, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_4, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_5, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_6, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_7, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_8, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_9, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_10, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_11, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_12, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_13, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_14, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_15, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_16, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_17, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_18, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_19, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_20, IN_IGNORED_SECTION::NFA_IN_IGNORED_SECTION_21};
            functionTableMap.put(LexicalState.IN_IGNORED_SECTION, functions);
        }
    }

    private static class IN_MULTI_INTERPOLATION {
        private IN_MULTI_INTERPOLATION() {
        }

        private static CSToken.TokenType NFA_IN_MULTI_INTERPOLATION_0(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(2);
            } else if (ch == 123) {
                nextStates.set(1);
            } else if (ch == 125) {
                nextStates.set(4);
            }
            if (ch == 34) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ENDING_QUOTE)) {
                    type = CSToken.TokenType.ENDING_QUOTE;
                }
            } else if (ch == 123) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.LBRACE)) {
                    type = CSToken.TokenType.LBRACE;
                }
            } else if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(3);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT2)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT2;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_MULTI_INTERPOLATION_1(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 123) {
                nextStates.set(3);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT2)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT2;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_MULTI_INTERPOLATION_2(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(3);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT2)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT2;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_MULTI_INTERPOLATION_3(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(2);
            } else if (ch == 123) {
                nextStates.set(1);
            } else if (ch == 125) {
                nextStates.set(4);
            } else if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(3);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT2)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT2;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_MULTI_INTERPOLATION_4(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 125) {
                nextStates.set(3);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT2)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT2;
                }
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{IN_MULTI_INTERPOLATION::NFA_IN_MULTI_INTERPOLATION_0, IN_MULTI_INTERPOLATION::NFA_IN_MULTI_INTERPOLATION_1, IN_MULTI_INTERPOLATION::NFA_IN_MULTI_INTERPOLATION_2, IN_MULTI_INTERPOLATION::NFA_IN_MULTI_INTERPOLATION_3, IN_MULTI_INTERPOLATION::NFA_IN_MULTI_INTERPOLATION_4};
            functionTableMap.put(LexicalState.IN_MULTI_INTERPOLATION, functions);
        }
    }

    private static class IN_REGULAR_INTERPOLATION {
        private static int[] NFA_MOVES_IN_REGULAR_INTERPOLATION_18 = IN_REGULAR_INTERPOLATION.NFA_MOVES_IN_REGULAR_INTERPOLATION_18_init();

        private IN_REGULAR_INTERPOLATION() {
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_0(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 92) {
                nextStates.set(15);
            } else if (ch == 123) {
                nextStates.set(19);
            } else if (ch == 125) {
                nextStates.set(17);
            } else if (ch == 34 && (validTypes == null || validTypes.contains(CSToken.TokenType.ENDING_QUOTE))) {
                type = CSToken.TokenType.ENDING_QUOTE;
            }
            if (ch == 123) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.LBRACE)) {
                    type = CSToken.TokenType.LBRACE;
                }
            } else if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(6);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_1(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 92) {
                nextStates.set(15);
            } else if (ch == 123) {
                nextStates.set(19);
            } else if (ch == 125) {
                nextStates.set(17);
            } else if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(6);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
                }
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(6);
                nextStates.set(11);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_2(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(7);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_3(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(20);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_4(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 92) {
                nextStates.set(15);
            } else if (ch == 123) {
                nextStates.set(19);
            } else if (ch == 125) {
                nextStates.set(17);
            } else if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(6);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
                }
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(1);
                nextStates.set(6);
                nextStates.set(11);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_5(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(8);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_6(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 92) {
                nextStates.set(15);
            } else if (ch == 123) {
                nextStates.set(19);
            } else if (ch == 125) {
                nextStates.set(17);
            } else if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(6);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_7(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(5);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_8(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(16);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_9(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(6);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_10(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(6);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_11(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 92) {
                nextStates.set(15);
            } else if (ch == 123) {
                nextStates.set(19);
            } else if (ch == 125) {
                nextStates.set(17);
            } else if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(6);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
                }
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(6);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_12(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(13);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_13(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(2);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_14(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(4);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_15(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 85) {
                nextStates.set(12);
            } else if (ch == 117) {
                nextStates.set(3);
            } else if (ch == 120) {
                nextStates.set(14);
            } else if (CSLexer.checkIntervals(IN_REGULAR_INTERPOLATION.NFA_MOVES_IN_REGULAR_INTERPOLATION_18, ch)) {
                nextStates.set(6);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_16(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(9);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_17(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 125) {
                nextStates.set(6);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_18(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(10);
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_19(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 123) {
                nextStates.set(6);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_IN_REGULAR_INTERPOLATION_20(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(18);
            }
            return type;
        }

        private static int[] NFA_MOVES_IN_REGULAR_INTERPOLATION_18_init() {
            return new int[]{34, 34, 39, 39, 48, 48, 92, 92, 97, 98, 102, 102, 110, 110, 114, 114, 116, 116, 118, 118};
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_0, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_1, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_2, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_3, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_4, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_5, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_6, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_7, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_8, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_9, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_10, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_11, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_12, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_13, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_14, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_15, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_16, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_17, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_18, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_19, IN_REGULAR_INTERPOLATION::NFA_IN_REGULAR_INTERPOLATION_20};
            functionTableMap.put(LexicalState.IN_REGULAR_INTERPOLATION, functions);
        }
    }

    private static class CSHARP {
        private static int[] NFA_MOVES_CSHARP_47 = CSHARP.NFA_MOVES_CSHARP_47_init();
        private static int[] NFA_MOVES_CSHARP_82 = CSHARP.NFA_MOVES_CSHARP_82_init();
        private static int[] NFA_MOVES_CSHARP_289 = CSHARP.NFA_MOVES_CSHARP_289_init();
        private static int[] NFA_MOVES_CSHARP_531 = CSHARP.NFA_MOVES_CSHARP_531_init();
        private static int[] NFA_MOVES_CSHARP_697 = CSHARP.NFA_MOVES_CSHARP_697_init();

        private CSHARP() {
        }

        private static CSToken.TokenType NFA_CSHARP_0(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 33) {
                nextStates.set(103);
            } else if (ch == 34) {
                nextStates.set(558);
                nextStates.set(380);
            } else if (ch == 36) {
                nextStates.set(338);
                nextStates.set(464);
                nextStates.set(104);
            } else if (ch == 37) {
                nextStates.set(612);
            } else if (ch == 38) {
                nextStates.set(535);
                nextStates.set(499);
            } else if (ch == 39) {
                nextStates.set(285);
            } else if (ch == 42) {
                nextStates.set(391);
            } else if (ch == 43) {
                nextStates.set(229);
                nextStates.set(555);
            } else if (ch == 45) {
                nextStates.set(530);
                nextStates.set(289);
                nextStates.set(279);
            } else if (ch == 46) {
                nextStates.set(178);
                nextStates.set(91);
                nextStates.set(181);
            } else if (ch == 47) {
                nextStates.set(432);
                nextStates.set(218);
                nextStates.set(248);
            } else if (ch == 48) {
                nextStates.set(473);
                nextStates.set(601);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(352);
            } else if (ch == 58) {
                nextStates.set(410);
            } else if (ch == 60) {
                nextStates.set(115);
                nextStates.set(75);
                nextStates.set(291);
            } else if (ch == 61) {
                nextStates.set(162);
                nextStates.set(78);
            } else if (ch == 62) {
                nextStates.set(266);
                nextStates.set(336);
                nextStates.set(511);
            } else if (ch == 63) {
                nextStates.set(406);
                nextStates.set(451);
            } else if (ch == 64) {
                nextStates.set(344);
                nextStates.set(460);
                nextStates.set(604);
            } else if (ch == 92) {
                nextStates.set(416);
            } else if (ch == 94) {
                nextStates.set(20);
            } else if (ch == 95) {
                nextStates.set(249);
            } else if (ch == 97) {
                nextStates.set(174);
                nextStates.set(452);
                nextStates.set(381);
                nextStates.set(294);
                nextStates.set(167);
                nextStates.set(23);
                nextStates.set(305);
                nextStates.set(198);
            } else if (ch == 98) {
                nextStates.set(596);
                nextStates.set(311);
                nextStates.set(480);
                nextStates.set(144);
                nextStates.set(621);
            } else if (ch == 99) {
                nextStates.set(9);
                nextStates.set(27);
                nextStates.set(496);
                nextStates.set(589);
                nextStates.set(533);
                nextStates.set(428);
                nextStates.set(16);
            } else if (ch == 100) {
                nextStates.set(276);
                nextStates.set(534);
                nextStates.set(335);
                nextStates.set(197);
                nextStates.set(259);
                nextStates.set(307);
                nextStates.set(454);
            } else if (ch == 101) {
                nextStates.set(278);
                nextStates.set(47);
                nextStates.set(186);
                nextStates.set(81);
                nextStates.set(512);
                nextStates.set(490);
            } else if (ch == 102) {
                nextStates.set(25);
                nextStates.set(39);
                nextStates.set(243);
                nextStates.set(177);
                nextStates.set(242);
                nextStates.set(502);
                nextStates.set(5);
            } else if (ch == 103) {
                nextStates.set(93);
                nextStates.set(80);
                nextStates.set(85);
            } else if (ch == 105) {
                nextStates.set(199);
                nextStates.set(447);
                nextStates.set(145);
                nextStates.set(54);
                nextStates.set(616);
                nextStates.set(489);
                nextStates.set(227);
                nextStates.set(143);
                nextStates.set(396);
            } else if (ch == 106) {
                nextStates.set(95);
            } else if (ch == 108) {
                nextStates.set(409);
                nextStates.set(482);
                nextStates.set(503);
            } else if (ch == 109) {
                nextStates.set(556);
            } else if (ch == 110) {
                nextStates.set(148);
                nextStates.set(526);
                nextStates.set(109);
                nextStates.set(448);
                nextStates.set(185);
            } else if (ch == 111) {
                nextStates.set(244);
                nextStates.set(342);
                nextStates.set(384);
                nextStates.set(200);
                nextStates.set(282);
                nextStates.set(379);
                nextStates.set(205);
            } else if (ch == 112) {
                nextStates.set(557);
                nextStates.set(376);
                nextStates.set(117);
                nextStates.set(488);
                nextStates.set(272);
            } else if (ch == 114) {
                nextStates.set(357);
                nextStates.set(592);
                nextStates.set(257);
                nextStates.set(245);
                nextStates.set(388);
                nextStates.set(343);
            } else if (ch == 115) {
                nextStates.set(537);
                nextStates.set(586);
                nextStates.set(367);
                nextStates.set(518);
                nextStates.set(18);
                nextStates.set(421);
                nextStates.set(371);
                nextStates.set(60);
                nextStates.set(544);
                nextStates.set(322);
                nextStates.set(548);
            } else if (ch == 116) {
                nextStates.set(280);
                nextStates.set(33);
                nextStates.set(250);
                nextStates.set(400);
                nextStates.set(267);
            } else if (ch == 117) {
                nextStates.set(551);
                nextStates.set(122);
                nextStates.set(465);
                nextStates.set(470);
                nextStates.set(226);
                nextStates.set(337);
            } else if (ch == 118) {
                nextStates.set(608);
                nextStates.set(83);
                nextStates.set(509);
                nextStates.set(221);
            } else if (ch == 119) {
                nextStates.set(97);
                nextStates.set(461);
                nextStates.set(481);
                nextStates.set(28);
            } else if (ch == 121) {
                nextStates.set(486);
            } else if (ch == 124) {
                nextStates.set(131);
                nextStates.set(208);
            } else if (ch == 35) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.HASH)) {
                    type = CSToken.TokenType.HASH;
                }
            } else if (ch == 123 && (validTypes == null || validTypes.contains(CSToken.TokenType.LBRACE))) {
                type = CSToken.TokenType.LBRACE;
            }
            if (ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_82, ch)) {
                nextStates.set(565);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.IDENTIFIER)) {
                    type = CSToken.TokenType.IDENTIFIER;
                }
            } else if (ch == 64) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.AT)) {
                    type = CSToken.TokenType.AT;
                }
            } else if (ch == 46) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.DOT)) {
                    type = CSToken.TokenType.DOT;
                }
            } else if (ch == 61) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ASSIGN)) {
                    type = CSToken.TokenType.ASSIGN;
                }
            } else if (ch == 37) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REM)) {
                    type = CSToken.TokenType.REM;
                }
            } else if (ch == 94) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.HAT)) {
                    type = CSToken.TokenType.HAT;
                }
            } else if (ch == 124) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.BIT_OR)) {
                    type = CSToken.TokenType.BIT_OR;
                }
            } else if (ch == 38) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.BIT_AND)) {
                    type = CSToken.TokenType.BIT_AND;
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.SLASH)) {
                    type = CSToken.TokenType.SLASH;
                }
            } else if (ch == 42) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.STAR)) {
                    type = CSToken.TokenType.STAR;
                }
            } else if (ch == 45) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.MINUS)) {
                    type = CSToken.TokenType.MINUS;
                }
            } else if (ch == 43) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.PLUS)) {
                    type = CSToken.TokenType.PLUS;
                }
            } else if (ch == 58) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.COLON)) {
                    type = CSToken.TokenType.COLON;
                }
            } else if (ch == 63) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.HOOK)) {
                    type = CSToken.TokenType.HOOK;
                }
            } else if (ch == 126) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.TILDE)) {
                    type = CSToken.TokenType.TILDE;
                }
            } else if (ch == 33) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.BANG)) {
                    type = CSToken.TokenType.BANG;
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.LT)) {
                    type = CSToken.TokenType.LT;
                }
            } else if (ch == 62) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.GT)) {
                    type = CSToken.TokenType.GT;
                }
            } else if (ch == 44) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.COMMA)) {
                    type = CSToken.TokenType.COMMA;
                }
            } else if (ch == 59) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.SEMICOLON)) {
                    type = CSToken.TokenType.SEMICOLON;
                }
            } else if (ch == 93) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.RBRACKET)) {
                    type = CSToken.TokenType.RBRACKET;
                }
            } else if (ch == 91) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.LBRACKET)) {
                    type = CSToken.TokenType.LBRACKET;
                }
            } else if (ch == 125) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.RBRACE)) {
                    type = CSToken.TokenType.RBRACE;
                }
            } else if (ch == 41) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.RPAREN)) {
                    type = CSToken.TokenType.RPAREN;
                }
            } else if (ch == 40) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.LPAREN)) {
                    type = CSToken.TokenType.LPAREN;
                }
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(135);
                nextStates.set(478);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    type = CSToken.TokenType.INTEGER_LITERAL;
                }
            } else if (ch >= 9 && ch <= 11 || ch == 13 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_47, ch)) {
                nextStates.set(373);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.WHITESPACE)) {
                    type = CSToken.TokenType.WHITESPACE;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_1(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.AWAIT))) {
                type = CSToken.TokenType.AWAIT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_2(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(283);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_3(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(565);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.IDENTIFIER)) {
                    type = CSToken.TokenType.IDENTIFIER;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_4(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(565);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.IDENTIFIER)) {
                    type = CSToken.TokenType.IDENTIFIER;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_5(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(256);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_6(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.SHORT))) {
                type = CSToken.TokenType.SHORT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_7(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(3);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_8(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(455);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_9(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(138);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_10(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(317);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_11(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(542);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_12(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34 && (validTypes == null || validTypes.contains(CSToken.TokenType.MULTI_INTERPOLATION_START))) {
                type = CSToken.TokenType.MULTI_INTERPOLATION_START;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_13(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 112 && (validTypes == null || validTypes.contains(CSToken.TokenType.GROUP))) {
                type = CSToken.TokenType.GROUP;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_14(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(CSToken.TokenType.FIXED))) {
                type = CSToken.TokenType.FIXED;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_15(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111 && (validTypes == null || validTypes.contains(CSToken.TokenType.GOTO))) {
                type = CSToken.TokenType.GOTO;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_16(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(587);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_17(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 39 && (validTypes == null || validTypes.contains(CSToken.TokenType.CHARACTER_LITERAL))) {
                type = CSToken.TokenType.CHARACTER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_18(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(351);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_19(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(45);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_20(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(CSToken.TokenType.XORASSIGN))) {
                type = CSToken.TokenType.XORASSIGN;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_21(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(42);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_22(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(359);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_23(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(607);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_24(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(559);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_25(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(440);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_26(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.BYTE))) {
                type = CSToken.TokenType.BYTE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_27(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(479);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_28(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(418);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_29(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(303);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_30(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 102 && (validTypes == null || validTypes.contains(CSToken.TokenType.REF))) {
                type = CSToken.TokenType.REF;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_31(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(210);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_32(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(558);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(558);
            } else if (ch == 92) {
                nextStates.set(328);
            } else if (ch == 34 && (validTypes == null || validTypes.contains(CSToken.TokenType.REGULAR_STRING_LITERAL))) {
                type = CSToken.TokenType.REGULAR_STRING_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_33(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(74);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_34(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(501);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_35(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 118) {
                nextStates.set(619);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_36(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(254);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.RAW_STRING_START)) {
                    type = CSToken.TokenType.RAW_STRING_START;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_37(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(184);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_38(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(CSToken.TokenType.EXTERN))) {
                type = CSToken.TokenType.EXTERN;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_39(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(151);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_40(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111 && (validTypes == null || validTypes.contains(CSToken.TokenType.INTO))) {
                type = CSToken.TokenType.INTO;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_41(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(41);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(420);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    type = CSToken.TokenType.INTEGER_LITERAL;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_42(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(238);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_43(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99 && (validTypes == null || validTypes.contains(CSToken.TokenType.DYNAMIC))) {
                type = CSToken.TokenType.DYNAMIC;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_44(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(558);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(588);
                nextStates.set(558);
                nextStates.set(32);
            } else if (ch == 92) {
                nextStates.set(328);
            } else if (ch == 34 && (validTypes == null || validTypes.contains(CSToken.TokenType.REGULAR_STRING_LITERAL))) {
                type = CSToken.TokenType.REGULAR_STRING_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_45(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(577);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_46(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(188);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_47(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 120) {
                nextStates.set(413);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_48(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 102 && (validTypes == null || validTypes.contains(CSToken.TokenType.TYPEOF))) {
                type = CSToken.TokenType.TYPEOF;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_49(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(220);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(536);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REAL_LITERAL)) {
                    type = CSToken.TokenType.REAL_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 77 && ch != 100 && ch != 102 && ch != 109 || validTypes != null && !validTypes.contains(CSToken.TokenType.REAL_LITERAL))) {
                type = CSToken.TokenType.REAL_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_50(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 109) {
                nextStates.set(262);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_51(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(CSToken.TokenType.BOOL))) {
                type = CSToken.TokenType.BOOL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_52(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 104 && (validTypes == null || validTypes.contains(CSToken.TokenType.CATCH))) {
                type = CSToken.TokenType.CATCH;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_53(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(408);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_54(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 109) {
                nextStates.set(430);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_55(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(543);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_56(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(493);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_57(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(520);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_58(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.LET))) {
                type = CSToken.TokenType.LET;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_59(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(6);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_60(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 104) {
                nextStates.set(211);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_61(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(517);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_62(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(136);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_63(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(76);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_64(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(234);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_65(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(362);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_66(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 104 && (validTypes == null || validTypes.contains(CSToken.TokenType.FOREACH))) {
                type = CSToken.TokenType.FOREACH;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_67(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 103 && (validTypes == null || validTypes.contains(CSToken.TokenType.ULONG))) {
                type = CSToken.TokenType.ULONG;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_68(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(133);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_69(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(334);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_70(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(50);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_71(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 117 && (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL))) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_72(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(86);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_73(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(99);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_74(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 121 && (validTypes == null || validTypes.contains(CSToken.TokenType.TRY))) {
                type = CSToken.TokenType.TRY;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_75(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 60 && (validTypes == null || validTypes.contains(CSToken.TokenType.LEFT_SHIFT))) {
                type = CSToken.TokenType.LEFT_SHIFT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_76(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(116);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_77(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(487);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_78(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 62 && (validTypes == null || validTypes.contains(CSToken.TokenType.ARROW))) {
                type = CSToken.TokenType.ARROW;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_79(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(44);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_80(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(404);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_81(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 118) {
                nextStates.set(296);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_82(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(CSToken.TokenType.PARAMS))) {
                type = CSToken.TokenType.PARAMS;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_83(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(468);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_84(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 122) {
                nextStates.set(263);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_85(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(142);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_86(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 121 && (validTypes == null || validTypes.contains(CSToken.TokenType.FINALLY))) {
                type = CSToken.TokenType.FINALLY;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_87(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 103) {
                nextStates.set(393);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_88(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(378);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_89(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(450);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_90(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99 && (validTypes == null || validTypes.contains(CSToken.TokenType.PUBLIC))) {
                type = CSToken.TokenType.PUBLIC;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_91(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 46 && (validTypes == null || validTypes.contains(CSToken.TokenType.RANGE))) {
                type = CSToken.TokenType.RANGE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_92(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(358);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_93(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(613);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_94(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch >= 11) {
                nextStates.set(94);
            } else if (ch == 10 && (validTypes == null || validTypes.contains(CSToken.TokenType.SINGLE_LINE_COMMENT))) {
                type = CSToken.TokenType.SINGLE_LINE_COMMENT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_95(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(521);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_96(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(123);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_97(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 104) {
                nextStates.set(192);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_98(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(394);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_99(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99 && (validTypes == null || validTypes.contains(CSToken.TokenType.STATIC))) {
                type = CSToken.TokenType.STATIC;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_100(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(1);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_101(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 104 && (validTypes == null || validTypes.contains(CSToken.TokenType.WITH))) {
                type = CSToken.TokenType.WITH;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_102(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(CSToken.TokenType.PARTIAL))) {
                type = CSToken.TokenType.PARTIAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_103(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(CSToken.TokenType.NE))) {
                type = CSToken.TokenType.NE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_104(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(120);
            } else if (ch == 36) {
                nextStates.set(104);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_105(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(308);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_106(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(189);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_107(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(375);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_108(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(22);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_109(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(576);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_110(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(553);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_111(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(431);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_112(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 41 || ch >= 43) {
                nextStates.set(112);
            } else if (ch == 42) {
                nextStates.set(561);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_113(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(87);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_114(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 103 && (validTypes == null || validTypes.contains(CSToken.TokenType.STRING))) {
                type = CSToken.TokenType.STRING;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_115(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(CSToken.TokenType.LE))) {
                type = CSToken.TokenType.LE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_116(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(299);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_117(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(2);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_118(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(574);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_119(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(52);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_120(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(176);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_121(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(274);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_122(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(356);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_123(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(494);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_124(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(582);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_125(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(325);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_126(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(70);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_127(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(168);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_128(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 41 || ch >= 43) {
                nextStates.set(128);
            } else if (ch == 42) {
                nextStates.set(561);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_129(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 103 && (validTypes == null || validTypes.contains(CSToken.TokenType.ASCENDING))) {
                type = CSToken.TokenType.ASCENDING;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_130(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.VOLATILE))) {
                type = CSToken.TokenType.VOLATILE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_131(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 124 && (validTypes == null || validTypes.contains(CSToken.TokenType.SC_OR))) {
                type = CSToken.TokenType.SC_OR;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_132(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.OVERRIDE))) {
                type = CSToken.TokenType.OVERRIDE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_133(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(453);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_134(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 112) {
                nextStates.set(236);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_135(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(591);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(623);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(219);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REAL_LITERAL)) {
                    type = CSToken.TokenType.REAL_LITERAL;
                }
            } else if (!(ch != 68 && ch != 70 && ch != 77 && ch != 100 && ch != 102 && ch != 109 || validTypes != null && !validTypes.contains(CSToken.TokenType.REAL_LITERAL))) {
                type = CSToken.TokenType.REAL_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_136(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.CONST))) {
                type = CSToken.TokenType.CONST;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_137(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(476);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_138(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(370);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_139(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(491);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_140(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(360);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_141(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(183);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_142(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(15);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_143(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(CSToken.TokenType.IS))) {
                type = CSToken.TokenType.IS;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_144(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 121 && (validTypes == null || validTypes.contains(CSToken.TokenType.BY))) {
                type = CSToken.TokenType.BY;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_145(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(602);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_146(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99 && (validTypes == null || validTypes.contains(CSToken.TokenType.ASYNC))) {
                type = CSToken.TokenType.ASYNC;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_147(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(CSToken.TokenType.LEFT_SHIFT_ASSIGN))) {
                type = CSToken.TokenType.LEFT_SHIFT_ASSIGN;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_148(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(187);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_149(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34 && (validTypes == null || validTypes.contains(CSToken.TokenType.MULTI_INTERPOLATION_START))) {
                type = CSToken.TokenType.MULTI_INTERPOLATION_START;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_150(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(329);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_151(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 120) {
                nextStates.set(622);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_152(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114 && (validTypes == null || validTypes.contains(CSToken.TokenType.OPERATOR))) {
                type = CSToken.TokenType.OPERATOR;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_153(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(387);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_154(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(483);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_155(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 112) {
                nextStates.set(546);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_156(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(603);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_157(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 107) {
                nextStates.set(372);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_158(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(475);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_159(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(159);
            } else if (ch == 34) {
                nextStates.set(456);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.VERBATIM_STRING_LITERAL)) {
                    type = CSToken.TokenType.VERBATIM_STRING_LITERAL;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_160(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(63);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_161(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(402);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_162(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(CSToken.TokenType.EQ))) {
                type = CSToken.TokenType.EQ;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_163(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(158);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_164(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(247);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_165(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(597);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_166(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(CSToken.TokenType.SEALED))) {
                type = CSToken.TokenType.SEALED;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_167(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100) {
                nextStates.set(424);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_168(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(72);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_169(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 107) {
                nextStates.set(429);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_170(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(17);
                nextStates.set(346);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(CSToken.TokenType.CHARACTER_LITERAL))) {
                type = CSToken.TokenType.CHARACTER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_171(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(17);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_172(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(624);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_173(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(CSToken.TokenType.RIGHT_SHIFT_ASSIGN))) {
                type = CSToken.TokenType.RIGHT_SHIFT_ASSIGN;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_174(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(CSToken.TokenType.AS))) {
                type = CSToken.TokenType.AS;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_175(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(241);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_176(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(500);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTERPOLATED_RAW_STRING_START)) {
                    type = CSToken.TokenType.INTERPOLATED_RAW_STRING_START;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_177(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(231);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_178(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 46) {
                nextStates.set(575);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_179(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.CONTINUE))) {
                type = CSToken.TokenType.CONTINUE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_180(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(625);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_181(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(135);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REAL_LITERAL)) {
                    type = CSToken.TokenType.REAL_LITERAL;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_182(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 117 && (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL))) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_183(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(310);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_184(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(611);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_185(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(284);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_186(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(302);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_187(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.NOT))) {
                type = CSToken.TokenType.NOT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_188(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.UINT))) {
                type = CSToken.TokenType.UINT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_189(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 107 && (validTypes == null || validTypes.contains(CSToken.TokenType.LOCK))) {
                type = CSToken.TokenType.LOCK;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_190(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 107) {
                nextStates.set(281);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_191(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.UNSAFE))) {
                type = CSToken.TokenType.UNSAFE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_192(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(88);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_193(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL))) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_194(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(403);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_195(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99 && (validTypes == null || validTypes.contains(CSToken.TokenType.STACKALLOC))) {
                type = CSToken.TokenType.STACKALLOC;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_196(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 85) {
                nextStates.set(513);
            } else if (ch == 117) {
                nextStates.set(29);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_197(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(55);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_198(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(318);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_199(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(332);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_200(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 112) {
                nextStates.set(217);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_201(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.ELSE))) {
                type = CSToken.TokenType.ELSE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_202(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(590);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_203(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(298);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_204(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(258);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_205(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(374);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_206(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(140);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_207(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(CSToken.TokenType.UNCHECKED))) {
                type = CSToken.TokenType.UNCHECKED;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_208(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(CSToken.TokenType.ORASSIGN))) {
                type = CSToken.TokenType.ORASSIGN;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_209(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(209);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(420);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    type = CSToken.TokenType.INTEGER_LITERAL;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_210(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(CSToken.TokenType.VIRTUAL))) {
                type = CSToken.TokenType.VIRTUAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_211(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(59);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_212(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.STRUCT))) {
                type = CSToken.TokenType.STRUCT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_213(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(382);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_214(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.FALSE))) {
                type = CSToken.TokenType.FALSE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_215(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(49);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REAL_LITERAL)) {
                    type = CSToken.TokenType.REAL_LITERAL;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_216(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(567);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_217(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(560);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_218(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 42) {
                nextStates.set(112);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_219(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(623);
            } else if (!(ch != 68 && ch != 70 && ch != 77 && ch != 100 && ch != 102 && ch != 109 || validTypes != null && !validTypes.contains(CSToken.TokenType.REAL_LITERAL))) {
                type = CSToken.TokenType.REAL_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_220(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(220);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(536);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REAL_LITERAL)) {
                    type = CSToken.TokenType.REAL_LITERAL;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_221(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(564);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_222(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(65);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_223(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(11);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_224(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 76 && (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL))) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_225(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(436);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_226(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(419);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_227(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 102 && (validTypes == null || validTypes.contains(CSToken.TokenType.IF))) {
                type = CSToken.TokenType.IF;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_228(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100) {
                nextStates.set(132);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_229(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 43 && (validTypes == null || validTypes.contains(CSToken.TokenType.INCR))) {
                type = CSToken.TokenType.INCR;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_230(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(457);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_231(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(154);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_232(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(163);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_233(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(600);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_234(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(17);
                nextStates.set(346);
                nextStates.set(170);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(CSToken.TokenType.CHARACTER_LITERAL))) {
                type = CSToken.TokenType.CHARACTER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_235(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(165);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_236(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(426);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_237(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(527);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_238(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(524);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_239(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(618);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_240(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 103) {
                nextStates.set(366);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_241(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(CSToken.TokenType.RECORD))) {
                type = CSToken.TokenType.RECORD;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_242(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(172);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_243(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(264);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_244(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114 && (validTypes == null || validTypes.contains(CSToken.TokenType.OR))) {
                type = CSToken.TokenType.OR;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_245(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(516);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_246(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(313);
            }
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(246);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_247(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(339);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_248(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(CSToken.TokenType.SLASHASSIGN))) {
                type = CSToken.TokenType.SLASHASSIGN;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_249(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 95) {
                nextStates.set(89);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_250(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 121) {
                nextStates.set(155);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_251(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.PRIVATE))) {
                type = CSToken.TokenType.PRIVATE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_252(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(CSToken.TokenType.PROTECTED))) {
                type = CSToken.TokenType.PROTECTED;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_253(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(579);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_254(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(254);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.RAW_STRING_START)) {
                    type = CSToken.TokenType.RAW_STRING_START;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_255(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(92);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_256(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114 && (validTypes == null || validTypes.contains(CSToken.TokenType.FOR))) {
                type = CSToken.TokenType.FOR;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_257(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(395);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_258(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(114);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_259(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(126);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_260(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(204);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_261(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(331);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_262(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(525);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_263(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(203);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_264(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(614);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_265(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(48);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_266(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(CSToken.TokenType.GE))) {
                type = CSToken.TokenType.GE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_267(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 104) {
                nextStates.set(68);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_268(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 76 && (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL))) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_269(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(363);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_270(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(569);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_271(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(270);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_272(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(271);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_273(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(118);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_274(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.BASE))) {
                type = CSToken.TokenType.BASE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_275(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.SET))) {
                type = CSToken.TokenType.SET;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_276(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 121) {
                nextStates.set(10);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_277(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(43);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_278(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 120) {
                nextStates.set(547);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_279(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(CSToken.TokenType.MINUSASSIGN))) {
                type = CSToken.TokenType.MINUSASSIGN;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_280(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(230);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_281(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(514);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_282(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(CSToken.TokenType.ON))) {
                type = CSToken.TokenType.ON;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_283(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 118) {
                nextStates.set(340);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_284(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 119 && (validTypes == null || validTypes.contains(CSToken.TokenType.NEW))) {
                type = CSToken.TokenType.NEW;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_285(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(17);
            } else if (ch == 92) {
                nextStates.set(595);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_286(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(100);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_287(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(570);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_288(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(467);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_289(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 62 && (validTypes == null || validTypes.contains(CSToken.TokenType.POINTER_ACCESS))) {
                type = CSToken.TokenType.POINTER_ACCESS;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_290(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(146);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_291(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 60) {
                nextStates.set(147);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_292(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(615);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_293(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(327);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_294(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(605);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_295(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(62);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_296(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(269);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_297(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(130);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_298(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 102 && (validTypes == null || validTypes.contains(CSToken.TokenType.SIZEOF))) {
                type = CSToken.TokenType.SIZEOF;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_299(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(580);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_300(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(609);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_301(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.INIT))) {
                type = CSToken.TokenType.INIT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_302(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(519);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_303(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(98);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_304(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(324);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_305(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(398);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_306(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(113);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_307(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(314);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_308(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.DELEGATE))) {
                type = CSToken.TokenType.DELEGATE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_309(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(304);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_310(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(7);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_311(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(326);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_312(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 48 || ch == 49 || ch == 95) {
                nextStates.set(598);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    type = CSToken.TokenType.INTEGER_LITERAL;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_313(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 46) {
                nextStates.set(181);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_314(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(61);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_315(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(427);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_316(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(107);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_317(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(383);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_318(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(CSToken.TokenType.AND))) {
                type = CSToken.TokenType.AND;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_319(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(300);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_320(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(423);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_321(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(545);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_322(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(34);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_323(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(529);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_324(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(562);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_325(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(584);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_326(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(51);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_327(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(297);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_328(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_697, ch)) {
                nextStates.set(558);
            } else if (ch == 85) {
                nextStates.set(57);
            } else if (ch == 117) {
                nextStates.set(438);
            } else if (ch == 120) {
                nextStates.set(79);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_329(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(152);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_330(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(434);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_331(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.IMPLICIT))) {
                type = CSToken.TokenType.IMPLICIT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_332(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(40);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_333(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(129);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_334(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.ARGLIST))) {
                type = CSToken.TokenType.ARGLIST;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_335(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(306);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_336(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 62 && (validTypes == null || validTypes.contains(CSToken.TokenType.RIGHT_SHIFT))) {
                type = CSToken.TokenType.RIGHT_SHIFT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_337(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(439);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_338(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 64) {
                nextStates.set(12);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_339(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.SELECT))) {
                type = CSToken.TokenType.SELECT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_340(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(507);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_341(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.NAMESPACE))) {
                type = CSToken.TokenType.NAMESPACE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_342(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(368);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_343(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(30);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_344(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(159);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_345(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(462);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_346(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(17);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(CSToken.TokenType.CHARACTER_LITERAL))) {
                type = CSToken.TokenType.CHARACTER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_347(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(31);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_348(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(69);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_349(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(412);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_350(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(190);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_351(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(164);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_352(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 46) {
                nextStates.set(181);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(313);
            }
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(246);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_353(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 109) {
                nextStates.set(53);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_354(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(127);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_355(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(CSToken.TokenType.VOID))) {
                type = CSToken.TokenType.VOID;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_356(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(620);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_357(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(216);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_358(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(606);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_359(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.USHORT))) {
                type = CSToken.TokenType.USHORT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_360(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.WHERE))) {
                type = CSToken.TokenType.WHERE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_361(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(610);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_362(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(195);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_363(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.EVENT))) {
                type = CSToken.TokenType.EVENT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_364(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(578);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_365(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(26);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_366(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(348);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_367(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(275);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_368(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.OUT))) {
                type = CSToken.TokenType.OUT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_369(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(495);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_370(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(437);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_371(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(84);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_372(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(207);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_373(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 9 && ch <= 11 || ch == 13 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_47, ch)) {
                nextStates.set(373);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.WHITESPACE)) {
                    type = CSToken.TokenType.WHITESPACE;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_374(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100) {
                nextStates.set(550);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_375(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.DOUBLE))) {
                type = CSToken.TokenType.DOUBLE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_376(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(21);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_377(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(139);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_378(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.WHILE))) {
                type = CSToken.TokenType.WHILE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_379(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 118) {
                nextStates.set(515);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_380(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(36);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_381(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 119) {
                nextStates.set(286);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_382(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100) {
                nextStates.set(626);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_383(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 109) {
                nextStates.set(277);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_384(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(435);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_385(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(472);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_386(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 104) {
                nextStates.set(108);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_387(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 103 && (validTypes == null || validTypes.contains(CSToken.TokenType.LONG))) {
                type = CSToken.TokenType.LONG;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_388(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(377);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_389(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(433);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_390(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(194);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_391(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(CSToken.TokenType.STARASSIGN))) {
                type = CSToken.TokenType.STARASSIGN;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_392(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(38);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_393(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(105);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_394(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(565);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.IDENTIFIER)) {
                    type = CSToken.TokenType.IDENTIFIER;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_395(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 109) {
                nextStates.set(568);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_396(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(CSToken.TokenType.IN))) {
                type = CSToken.TokenType.IN;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_397(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(565);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.IDENTIFIER)) {
                    type = CSToken.TokenType.IDENTIFIER;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_398(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(463);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_399(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(292);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_400(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 104) {
                nextStates.set(56);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_401(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(CSToken.TokenType.NULL))) {
                type = CSToken.TokenType.NULL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_402(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 104 && (validTypes == null || validTypes.contains(CSToken.TokenType.SWITCH))) {
                type = CSToken.TokenType.SWITCH;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_403(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(369);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_404(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(538);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_405(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 109) {
                nextStates.set(82);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_406(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 63 && (validTypes == null || validTypes.contains(CSToken.TokenType.DOUBLE_HOOK))) {
                type = CSToken.TokenType.DOUBLE_HOOK;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_407(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(124);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_408(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(583);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_409(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(106);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_410(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 58 && (validTypes == null || validTypes.contains(CSToken.TokenType.DOUBLE_COLON))) {
                type = CSToken.TokenType.DOUBLE_COLON;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_411(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(233);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_412(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(166);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_413(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(522);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_414(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(119);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_415(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(471);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_416(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 85) {
                nextStates.set(19);
            } else if (ch == 117) {
                nextStates.set(319);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_417(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(485);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_418(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(101);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_419(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(111);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_420(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 76) {
                nextStates.set(182);
                nextStates.set(458);
            } else if (ch == 85) {
                nextStates.set(268);
                nextStates.set(193);
            } else if (ch == 108) {
                nextStates.set(71);
                nextStates.set(474);
            } else if (ch == 117) {
                nextStates.set(224);
                nextStates.set(528);
            }
            if (ch == 76) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    type = CSToken.TokenType.INTEGER_LITERAL;
                }
            } else if (ch == 85) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    type = CSToken.TokenType.INTEGER_LITERAL;
                }
            } else if (ch == 108) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    type = CSToken.TokenType.INTEGER_LITERAL;
                }
            } else if (ch == 117 && (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL))) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_421(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 119) {
                nextStates.set(459);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_422(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(558);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_423(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(175);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_424(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(CSToken.TokenType.ADD))) {
                type = CSToken.TokenType.ADD;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_425(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(161);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_426(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(341);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_427(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(228);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_428(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(295);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_429(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(222);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_430(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 112) {
                nextStates.set(411);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_431(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(191);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_432(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 47) {
                nextStates.set(94);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_433(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 102) {
                nextStates.set(273);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_434(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(169);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_435(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 106) {
                nextStates.set(223);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_436(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(CSToken.TokenType.YIELD))) {
                type = CSToken.TokenType.YIELD;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_437(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(CSToken.TokenType.CLASS))) {
                type = CSToken.TokenType.CLASS;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_438(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(96);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_439(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(442);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_440(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(417);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_441(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(349);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_442(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(67);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_443(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(66);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_444(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 103 && (validTypes == null || validTypes.contains(CSToken.TokenType.DESCENDING))) {
                type = CSToken.TokenType.DESCENDING;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_445(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114 && (validTypes == null || validTypes.contains(CSToken.TokenType.CHAR))) {
                type = CSToken.TokenType.CHAR;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_446(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(353);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_447(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(160);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_448(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(563);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_449(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(212);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_450(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(240);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_451(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 63) {
                nextStates.set(532);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_452(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(477);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_453(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 119 && (validTypes == null || validTypes.contains(CSToken.TokenType.THROW))) {
                type = CSToken.TokenType.THROW;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_454(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(466);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_455(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(252);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_456(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(159);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_457(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.TRUE))) {
                type = CSToken.TokenType.TRUE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_458(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 85 && (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL))) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_459(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(425);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_460(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 36) {
                nextStates.set(149);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_461(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 104) {
                nextStates.set(206);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_462(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(CSToken.TokenType.REQUIRED))) {
                type = CSToken.TokenType.REQUIRED;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_463(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(213);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_464(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34 && (validTypes == null || validTypes.contains(CSToken.TokenType.REGULAR_INTERPOLATION_START))) {
                type = CSToken.TokenType.REGULAR_INTERPOLATION_START;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_465(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(407);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_466(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(316);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_467(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(179);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_468(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(594);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_469(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.CASE))) {
                type = CSToken.TokenType.CASE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_470(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(386);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_471(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(444);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_472(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.DEFAULT))) {
                type = CSToken.TokenType.DEFAULT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_473(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 88 || ch == 120) {
                nextStates.set(209);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_474(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 85 && (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL))) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_475(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(523);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_476(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(506);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_477(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(541);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_478(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(41);
            } else if (ch == 76) {
                nextStates.set(182);
                nextStates.set(458);
            } else if (ch == 85) {
                nextStates.set(268);
                nextStates.set(193);
            } else if (ch == 108) {
                nextStates.set(71);
                nextStates.set(474);
            } else if (ch == 117) {
                nextStates.set(224);
                nextStates.set(528);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(420);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    type = CSToken.TokenType.INTEGER_LITERAL;
                }
            } else if (ch == 76) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    type = CSToken.TokenType.INTEGER_LITERAL;
                }
            } else if (ch == 85) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    type = CSToken.TokenType.INTEGER_LITERAL;
                }
            } else if (ch == 108) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    type = CSToken.TokenType.INTEGER_LITERAL;
                }
            } else if (ch == 117 && (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL))) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_479(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(469);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_480(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(137);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_481(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 104) {
                nextStates.set(571);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_482(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(58);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_483(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.FLOAT))) {
                type = CSToken.TokenType.FLOAT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_484(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(401);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_485(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(443);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_486(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(585);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_487(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 121 && (validTypes == null || validTypes.contains(CSToken.TokenType.READONLY))) {
                type = CSToken.TokenType.READONLY;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_488(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(287);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_489(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(156);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_490(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 113) {
                nextStates.set(255);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_491(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(572);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_492(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(201);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_493(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(CSToken.TokenType.THIS))) {
                type = CSToken.TokenType.THIS;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_494(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(558);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_495(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.EXPLICIT))) {
                type = CSToken.TokenType.EXPLICIT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_496(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 104) {
                nextStates.set(497);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_497(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(445);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_498(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(8);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_499(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(CSToken.TokenType.ANDASSIGN))) {
                type = CSToken.TokenType.ANDASSIGN;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_500(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(500);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTERPOLATED_RAW_STRING_START)) {
                    type = CSToken.TokenType.INTERPOLATED_RAW_STRING_START;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_501(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(449);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_502(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(354);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_503(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(153);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_504(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(315);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_505(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100) {
                nextStates.set(399);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_506(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 107 && (validTypes == null || validTypes.contains(CSToken.TokenType.BREAK))) {
                type = CSToken.TokenType.BREAK;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_507(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(251);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_508(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(CSToken.TokenType.JOIN))) {
                type = CSToken.TokenType.JOIN;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_509(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(554);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_510(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(150);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_511(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 62) {
                nextStates.set(173);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_512(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108) {
                nextStates.set(492);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_513(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(202);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_514(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(CSToken.TokenType.CHECKED))) {
                type = CSToken.TokenType.CHECKED;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_515(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(504);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_516(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 113) {
                nextStates.set(321);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_517(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(385);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_518(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(253);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_519(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 109 && (validTypes == null || validTypes.contains(CSToken.TokenType.ENUM))) {
                type = CSToken.TokenType.ENUM;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_520(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(232);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_521(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(508);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_522(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(392);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_523(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(422);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_524(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(102);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_525(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(CSToken.TokenType.DECIMAL))) {
                type = CSToken.TokenType.DECIMAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_526(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(484);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_527(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(90);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_528(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL))) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_529(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(288);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_530(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 45 && (validTypes == null || validTypes.contains(CSToken.TokenType.DECR))) {
                type = CSToken.TokenType.DECR;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_531(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(301);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_532(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(CSToken.TokenType.DOUBLE_HOOK_EQUALS))) {
                type = CSToken.TokenType.DOUBLE_HOOK_EQUALS;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_533(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 104) {
                nextStates.set(552);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_534(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111 && (validTypes == null || validTypes.contains(CSToken.TokenType.DO))) {
                type = CSToken.TokenType.DO;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_535(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 38 && (validTypes == null || validTypes.contains(CSToken.TokenType.SC_AND))) {
                type = CSToken.TokenType.SC_AND;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_536(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (!(ch != 68 && ch != 70 && ch != 77 && ch != 100 && ch != 102 && ch != 109 || validTypes != null && !validTypes.contains(CSToken.TokenType.REAL_LITERAL))) {
                type = CSToken.TokenType.REAL_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_537(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(540);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_538(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(13);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_539(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(171);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_540(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 121) {
                nextStates.set(110);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_541(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(599);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_542(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.OBJECT))) {
                type = CSToken.TokenType.OBJECT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_543(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(235);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_544(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(260);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_545(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(593);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_546(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(265);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_547(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 112) {
                nextStates.set(390);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_548(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(441);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_549(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(237);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_550(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(125);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_551(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(46);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_552(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(350);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_553(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.SBYTE))) {
                type = CSToken.TokenType.SBYTE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_554(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(355);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_555(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(CSToken.TokenType.PLUSASSIGN))) {
                type = CSToken.TokenType.PLUSASSIGN;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_556(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(505);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_557(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(549);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_558(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(558);
            } else if (ch == 92) {
                nextStates.set(328);
            } else if (ch == 34 && (validTypes == null || validTypes.contains(CSToken.TokenType.REGULAR_STRING_LITERAL))) {
                type = CSToken.TokenType.REGULAR_STRING_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_559(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(566);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_560(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(510);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_561(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 41 || ch >= 43 && ch <= 46 || ch >= 48) {
                nextStates.set(128);
            } else if (ch == 42) {
                nextStates.set(561);
            } else if (ch == 47 && (validTypes == null || validTypes.contains(CSToken.TokenType.MULTI_LINE_COMMENT))) {
                type = CSToken.TokenType.MULTI_LINE_COMMENT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_562(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(397);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_563(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 109) {
                nextStates.set(24);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_564(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114 && (validTypes == null || validTypes.contains(CSToken.TokenType.VAR))) {
                type = CSToken.TokenType.VAR;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_565(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 92) {
                nextStates.set(196);
            } else if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_531, ch)) {
                nextStates.set(565);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.IDENTIFIER)) {
                    type = CSToken.TokenType.IDENTIFIER;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_566(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 102 && (validTypes == null || validTypes.contains(CSToken.TokenType.NAMEOF))) {
                type = CSToken.TokenType.NAMEOF;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_567(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100) {
                nextStates.set(364);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_568(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 111) {
                nextStates.set(35);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_569(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(498);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_570(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(405);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_571(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(617);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_572(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(CSToken.TokenType.RETURN))) {
                type = CSToken.TokenType.RETURN;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_573(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(157);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_574(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.INTERFACE))) {
                type = CSToken.TokenType.INTERFACE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_575(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 46 && (validTypes == null || validTypes.contains(CSToken.TokenType.VAR_ARGS))) {
                type = CSToken.TokenType.VAR_ARGS;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_576(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 109) {
                nextStates.set(180);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_577(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(141);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_578(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(77);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_579(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(73);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_580(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 108 && (validTypes == null || validTypes.contains(CSToken.TokenType.INTERNAL))) {
                type = CSToken.TokenType.INTERNAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_581(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(573);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_582(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 103 && (validTypes == null || validTypes.contains(CSToken.TokenType.USING))) {
                type = CSToken.TokenType.USING;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_583(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 121 && (validTypes == null || validTypes.contains(CSToken.TokenType.ASSEMBLY))) {
                type = CSToken.TokenType.ASSEMBLY;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_584(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 121 && (validTypes == null || validTypes.contains(CSToken.TokenType.ORDERBY))) {
                type = CSToken.TokenType.ORDERBY;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_585(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(225);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_586(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(330);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_587(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(323);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_588(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(558);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(558);
                nextStates.set(32);
            } else if (ch == 92) {
                nextStates.set(328);
            } else if (ch == 34 && (validTypes == null || validTypes.contains(CSToken.TokenType.REGULAR_STRING_LITERAL))) {
                type = CSToken.TokenType.REGULAR_STRING_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_589(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(414);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_590(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(309);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_591(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(591);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(219);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REAL_LITERAL)) {
                    type = CSToken.TokenType.REAL_LITERAL;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_592(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(320);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_593(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(345);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_594(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(293);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_595(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_289, ch)) {
                nextStates.set(17);
            } else if (ch == 117) {
                nextStates.set(239);
            } else if (ch == 120) {
                nextStates.set(64);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_596(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 121) {
                nextStates.set(365);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_597(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 100) {
                nextStates.set(415);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_598(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 76) {
                nextStates.set(182);
                nextStates.set(458);
            } else if (ch == 85) {
                nextStates.set(268);
                nextStates.set(193);
            } else if (ch == 108) {
                nextStates.set(71);
                nextStates.set(474);
            } else if (ch == 117) {
                nextStates.set(224);
                nextStates.set(528);
            } else if (ch == 48 || ch == 49) {
                nextStates.set(420);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    type = CSToken.TokenType.INTEGER_LITERAL;
                }
            }
            if (ch == 48 || ch == 49 || ch == 95) {
                nextStates.set(598);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    type = CSToken.TokenType.INTEGER_LITERAL;
                }
            } else if (ch == 76) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    type = CSToken.TokenType.INTEGER_LITERAL;
                }
            } else if (ch == 85) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    type = CSToken.TokenType.INTEGER_LITERAL;
                }
            } else if (ch == 108) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    type = CSToken.TokenType.INTEGER_LITERAL;
                }
            } else if (ch == 117 && (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL))) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_599(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 114) {
                nextStates.set(37);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_600(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 99) {
                nextStates.set(261);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_601(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 98) {
                nextStates.set(312);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_602(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.INT))) {
                type = CSToken.TokenType.INT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_603(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(389);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_604(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 92) {
                nextStates.set(416);
            } else if (ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_82, ch)) {
                nextStates.set(565);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.IDENTIFIER)) {
                    type = CSToken.TokenType.IDENTIFIER;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_605(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 121) {
                nextStates.set(290);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_606(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115 && (validTypes == null || validTypes.contains(CSToken.TokenType.EQUALS))) {
                type = CSToken.TokenType.EQUALS;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_607(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(446);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_608(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(361);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_609(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(4);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_610(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116) {
                nextStates.set(347);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_611(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.ABSTRACT))) {
                type = CSToken.TokenType.ABSTRACT;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_612(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(CSToken.TokenType.REMASSIGN))) {
                type = CSToken.TokenType.REMASSIGN;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_613(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 116 && (validTypes == null || validTypes.contains(CSToken.TokenType.GET))) {
                type = CSToken.TokenType.GET;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_614(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 109 && (validTypes == null || validTypes.contains(CSToken.TokenType.FROM))) {
                type = CSToken.TokenType.FROM;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_615(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.MODULE))) {
                type = CSToken.TokenType.MODULE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_616(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110) {
                nextStates.set(531);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_617(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 110 && (validTypes == null || validTypes.contains(CSToken.TokenType.WHEN))) {
                type = CSToken.TokenType.WHEN;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_618(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(539);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_619(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(CSToken.TokenType.REMOVE))) {
                type = CSToken.TokenType.REMOVE;
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_620(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 104) {
                nextStates.set(581);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_621(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 97) {
                nextStates.set(121);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_622(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 101) {
                nextStates.set(14);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_623(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(215);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(49);
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REAL_LITERAL)) {
                    type = CSToken.TokenType.REAL_LITERAL;
                }
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_624(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(214);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_625(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 115) {
                nextStates.set(134);
            }
            return type;
        }

        private static CSToken.TokenType NFA_CSHARP_626(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes) {
            CSToken.TokenType type = null;
            if (ch == 105) {
                nextStates.set(333);
            }
            return type;
        }

        private static int[] NFA_MOVES_CSHARP_47_init() {
            return new int[]{9, 11, 13, 13, 32, 32, 160, 160, 5760, 5760, 8192, 8202, 8239, 8239, 8287, 8287, 12288, 12288};
        }

        private static int[] NFA_MOVES_CSHARP_82_init() {
            return new int[]{65, 90, 95, 95, 97, 122, 170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1488, 1514, 1519, 1522, 1568, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2048, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2144, 2154, 2208, 2228, 2230, 2247, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2432, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2545, 2556, 2556, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2809, 2809, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3133, 3160, 3162, 3168, 3169, 3200, 3200, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3294, 3294, 3296, 3297, 3313, 3314, 3332, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3412, 3414, 3423, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3648, 3654, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5900, 5902, 5905, 5920, 5937, 5952, 5969, 5984, 5996, 5998, 6000, 6016, 6067, 6103, 6103, 6108, 6108, 6176, 6264, 6272, 6276, 6279, 6312, 6314, 6314, 6320, 6389, 6400, 6430, 6480, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6987, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7401, 7404, 7406, 7411, 7413, 7414, 7418, 7418, 7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8305, 8305, 8319, 8319, 8336, 8348, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11310, 11312, 11358, 11360, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11823, 11823, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 40956, 40960, 42124, 42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539, 42560, 42606, 42623, 42653, 42656, 42735, 42775, 42783, 42786, 42888, 42891, 42943, 42946, 42954, 42997, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43261, 43262, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43488, 43492, 43494, 43503, 43514, 43518, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43638, 43642, 43642, 43646, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43741, 43744, 43754, 43762, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65136, 65140, 65142, 65276, 65313, 65338, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66176, 66204, 66208, 66256, 66304, 66335, 66349, 66378, 66384, 66421, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 67072, 67382, 67392, 67413, 67424, 67431, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68096, 68112, 68115, 68117, 68119, 68121, 68149, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68324, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68899, 69248, 69289, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69445, 69552, 69572, 69600, 69622, 69635, 69687, 69763, 69807, 69840, 69864, 69891, 69926, 69956, 69956, 69959, 69959, 69968, 70002, 70006, 70006, 70019, 70066, 70081, 70084, 70106, 70106, 70108, 70108, 70144, 70161, 70163, 70187, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70366, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70461, 70461, 70480, 70480, 70493, 70497, 70656, 70708, 70727, 70730, 70751, 70753, 70784, 70831, 70852, 70853, 70855, 70855, 71040, 71086, 71128, 71131, 71168, 71215, 71236, 71236, 71296, 71338, 71352, 71352, 71424, 71450, 71680, 71723, 71840, 71903, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71983, 71999, 71999, 72001, 72001, 72096, 72103, 72106, 72144, 72161, 72161, 72163, 72163, 72192, 72192, 72203, 72242, 72250, 72250, 72272, 72272, 72284, 72329, 72349, 72349, 72384, 72440, 72704, 72712, 72714, 72750, 72768, 72768, 72818, 72847, 72960, 72966, 72968, 72969, 72971, 73008, 73030, 73030, 73056, 73061, 73063, 73064, 73066, 73097, 73112, 73112, 73440, 73458, 73648, 73648, 73728, 74649, 74752, 74862, 74880, 75075, 77824, 78894, 82944, 83526, 92160, 92728, 92736, 92766, 92880, 92909, 92928, 92975, 92992, 92995, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94032, 94032, 94099, 94111, 94176, 94177, 94179, 94179, 94208, 100343, 100352, 101589, 101632, 101640, 110592, 110878, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 123136, 123180, 123191, 123197, 123214, 123214, 123584, 123627, 124928, 125124, 125184, 125251, 125259, 125259, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 131072, 173789, 173824, 177972, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546};
        }

        private static int[] NFA_MOVES_CSHARP_289_init() {
            return new int[]{34, 34, 39, 39, 48, 48, 92, 92, 97, 98, 102, 102, 110, 110, 114, 114, 116, 116, 118, 118};
        }

        private static int[] NFA_MOVES_CSHARP_531_init() {
            return new int[]{48, 57, 65, 90, 95, 95, 97, 122, 170, 170, 173, 173, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 768, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1155, 1159, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1488, 1514, 1519, 1522, 1536, 1541, 1552, 1562, 1564, 1564, 1568, 1641, 1646, 1747, 1749, 1757, 1759, 1768, 1770, 1788, 1791, 1791, 1807, 1866, 1869, 1969, 1984, 2037, 2042, 2042, 2045, 2045, 2048, 2093, 2112, 2139, 2144, 2154, 2208, 2228, 2230, 2247, 2259, 2403, 2406, 2415, 2417, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2500, 2503, 2504, 2507, 2510, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2545, 2556, 2556, 2558, 2558, 2561, 2563, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2649, 2652, 2654, 2654, 2662, 2677, 2689, 2691, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2787, 2790, 2799, 2809, 2815, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2876, 2884, 2887, 2888, 2891, 2893, 2901, 2903, 2908, 2909, 2911, 2915, 2918, 2927, 2929, 2929, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3024, 3024, 3031, 3031, 3046, 3055, 3072, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3160, 3162, 3168, 3171, 3174, 3183, 3200, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3260, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3294, 3294, 3296, 3299, 3302, 3311, 3313, 3314, 3328, 3340, 3342, 3344, 3346, 3396, 3398, 3400, 3402, 3406, 3412, 3415, 3423, 3427, 3430, 3439, 3450, 3455, 3457, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3558, 3567, 3570, 3571, 3585, 3642, 3648, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3807, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3948, 3953, 3972, 3974, 3991, 3993, 4028, 4038, 4038, 4096, 4169, 4176, 4253, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4957, 4959, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5900, 5902, 5908, 5920, 5940, 5952, 5971, 5984, 5996, 5998, 6000, 6002, 6003, 6016, 6099, 6103, 6103, 6108, 6109, 6112, 6121, 6155, 6158, 6160, 6169, 6176, 6264, 6272, 6314, 6320, 6389, 6400, 6430, 6432, 6443, 6448, 6459, 6470, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6608, 6617, 6656, 6683, 6688, 6750, 6752, 6780, 6783, 6793, 6800, 6809, 6823, 6823, 6832, 6845, 6847, 6848, 6912, 6987, 6992, 7001, 7019, 7027, 7040, 7155, 7168, 7223, 7232, 7241, 7245, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7376, 7378, 7380, 7418, 7424, 7673, 7675, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8203, 8207, 8234, 8238, 8255, 8256, 8276, 8276, 8288, 8292, 8294, 8303, 8305, 8305, 8319, 8319, 8336, 8348, 8400, 8412, 8417, 8417, 8421, 8432, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11310, 11312, 11358, 11360, 11492, 11499, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11647, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11744, 11775, 11823, 11823, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12348, 12353, 12438, 12441, 12442, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 40956, 40960, 42124, 42192, 42237, 42240, 42508, 42512, 42539, 42560, 42607, 42612, 42621, 42623, 42737, 42775, 42783, 42786, 42888, 42891, 42943, 42946, 42954, 42997, 43047, 43052, 43052, 43072, 43123, 43136, 43205, 43216, 43225, 43232, 43255, 43259, 43259, 43261, 43309, 43312, 43347, 43360, 43388, 43392, 43456, 43471, 43481, 43488, 43518, 43520, 43574, 43584, 43597, 43600, 43609, 43616, 43638, 43642, 43714, 43739, 43741, 43744, 43759, 43762, 43766, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44010, 44012, 44013, 44016, 44025, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65024, 65039, 65056, 65071, 65075, 65076, 65101, 65103, 65136, 65140, 65142, 65276, 65279, 65279, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65529, 65531, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66045, 66045, 66176, 66204, 66208, 66256, 66272, 66272, 66304, 66335, 66349, 66378, 66384, 66426, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66720, 66729, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 67072, 67382, 67392, 67413, 67424, 67431, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68099, 68101, 68102, 68108, 68115, 68117, 68119, 68121, 68149, 68152, 68154, 68159, 68159, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68326, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68903, 68912, 68921, 69248, 69289, 69291, 69292, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69456, 69552, 69572, 69600, 69622, 69632, 69702, 69734, 69743, 69759, 69818, 69821, 69821, 69837, 69837, 69840, 69864, 69872, 69881, 69888, 69940, 69942, 69951, 69956, 69959, 69968, 70003, 70006, 70006, 70016, 70084, 70089, 70092, 70094, 70106, 70108, 70108, 70144, 70161, 70163, 70199, 70206, 70206, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70378, 70384, 70393, 70400, 70403, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70459, 70468, 70471, 70472, 70475, 70477, 70480, 70480, 70487, 70487, 70493, 70499, 70502, 70508, 70512, 70516, 70656, 70730, 70736, 70745, 70750, 70753, 70784, 70853, 70855, 70855, 70864, 70873, 71040, 71093, 71096, 71104, 71128, 71133, 71168, 71232, 71236, 71236, 71248, 71257, 71296, 71352, 71360, 71369, 71424, 71450, 71453, 71467, 71472, 71481, 71680, 71738, 71840, 71913, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71989, 71991, 71992, 71995, 72003, 72016, 72025, 72096, 72103, 72106, 72151, 72154, 72161, 72163, 72164, 72192, 72254, 72263, 72263, 72272, 72345, 72349, 72349, 72384, 72440, 72704, 72712, 72714, 72758, 72760, 72768, 72784, 72793, 72818, 72847, 72850, 72871, 72873, 72886, 72960, 72966, 72968, 72969, 72971, 73014, 73018, 73018, 73020, 73021, 73023, 73031, 73040, 73049, 73056, 73061, 73063, 73064, 73066, 73102, 73104, 73105, 73107, 73112, 73120, 73129, 73440, 73462, 73648, 73648, 73728, 74649, 74752, 74862, 74880, 75075, 77824, 78894, 78896, 78904, 82944, 83526, 92160, 92728, 92736, 92766, 92768, 92777, 92880, 92909, 92912, 92916, 92928, 92982, 92992, 92995, 93008, 93017, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94031, 94087, 94095, 94111, 94176, 94177, 94179, 94180, 94192, 94193, 94208, 100343, 100352, 101589, 101632, 101640, 110592, 110878, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 113821, 113822, 113824, 113827, 119141, 119145, 119149, 119170, 119173, 119179, 119210, 119213, 119362, 119364, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 120782, 120831, 121344, 121398, 121403, 121452, 121461, 121461, 121476, 121476, 121499, 121503, 121505, 121519, 122880, 122886, 122888, 122904, 122907, 122913, 122915, 122916, 122918, 122922, 123136, 123180, 123184, 123197, 123200, 123209, 123214, 123214, 123584, 123641, 124928, 125124, 125136, 125142, 125184, 125259, 125264, 125273, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 130032, 130041, 131072, 173789, 173824, 177972, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546, 917505, 917505, 917536, 917631, 917760, 917999};
        }

        private static int[] NFA_MOVES_CSHARP_697_init() {
            return new int[]{34, 34, 39, 39, 48, 48, 92, 92, 97, 98, 102, 102, 110, 110, 114, 114, 116, 116, 118, 118};
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{CSHARP::NFA_CSHARP_0, CSHARP::NFA_CSHARP_1, CSHARP::NFA_CSHARP_2, CSHARP::NFA_CSHARP_3, CSHARP::NFA_CSHARP_4, CSHARP::NFA_CSHARP_5, CSHARP::NFA_CSHARP_6, CSHARP::NFA_CSHARP_7, CSHARP::NFA_CSHARP_8, CSHARP::NFA_CSHARP_9, CSHARP::NFA_CSHARP_10, CSHARP::NFA_CSHARP_11, CSHARP::NFA_CSHARP_12, CSHARP::NFA_CSHARP_13, CSHARP::NFA_CSHARP_14, CSHARP::NFA_CSHARP_15, CSHARP::NFA_CSHARP_16, CSHARP::NFA_CSHARP_17, CSHARP::NFA_CSHARP_18, CSHARP::NFA_CSHARP_19, CSHARP::NFA_CSHARP_20, CSHARP::NFA_CSHARP_21, CSHARP::NFA_CSHARP_22, CSHARP::NFA_CSHARP_23, CSHARP::NFA_CSHARP_24, CSHARP::NFA_CSHARP_25, CSHARP::NFA_CSHARP_26, CSHARP::NFA_CSHARP_27, CSHARP::NFA_CSHARP_28, CSHARP::NFA_CSHARP_29, CSHARP::NFA_CSHARP_30, CSHARP::NFA_CSHARP_31, CSHARP::NFA_CSHARP_32, CSHARP::NFA_CSHARP_33, CSHARP::NFA_CSHARP_34, CSHARP::NFA_CSHARP_35, CSHARP::NFA_CSHARP_36, CSHARP::NFA_CSHARP_37, CSHARP::NFA_CSHARP_38, CSHARP::NFA_CSHARP_39, CSHARP::NFA_CSHARP_40, CSHARP::NFA_CSHARP_41, CSHARP::NFA_CSHARP_42, CSHARP::NFA_CSHARP_43, CSHARP::NFA_CSHARP_44, CSHARP::NFA_CSHARP_45, CSHARP::NFA_CSHARP_46, CSHARP::NFA_CSHARP_47, CSHARP::NFA_CSHARP_48, CSHARP::NFA_CSHARP_49, CSHARP::NFA_CSHARP_50, CSHARP::NFA_CSHARP_51, CSHARP::NFA_CSHARP_52, CSHARP::NFA_CSHARP_53, CSHARP::NFA_CSHARP_54, CSHARP::NFA_CSHARP_55, CSHARP::NFA_CSHARP_56, CSHARP::NFA_CSHARP_57, CSHARP::NFA_CSHARP_58, CSHARP::NFA_CSHARP_59, CSHARP::NFA_CSHARP_60, CSHARP::NFA_CSHARP_61, CSHARP::NFA_CSHARP_62, CSHARP::NFA_CSHARP_63, CSHARP::NFA_CSHARP_64, CSHARP::NFA_CSHARP_65, CSHARP::NFA_CSHARP_66, CSHARP::NFA_CSHARP_67, CSHARP::NFA_CSHARP_68, CSHARP::NFA_CSHARP_69, CSHARP::NFA_CSHARP_70, CSHARP::NFA_CSHARP_71, CSHARP::NFA_CSHARP_72, CSHARP::NFA_CSHARP_73, CSHARP::NFA_CSHARP_74, CSHARP::NFA_CSHARP_75, CSHARP::NFA_CSHARP_76, CSHARP::NFA_CSHARP_77, CSHARP::NFA_CSHARP_78, CSHARP::NFA_CSHARP_79, CSHARP::NFA_CSHARP_80, CSHARP::NFA_CSHARP_81, CSHARP::NFA_CSHARP_82, CSHARP::NFA_CSHARP_83, CSHARP::NFA_CSHARP_84, CSHARP::NFA_CSHARP_85, CSHARP::NFA_CSHARP_86, CSHARP::NFA_CSHARP_87, CSHARP::NFA_CSHARP_88, CSHARP::NFA_CSHARP_89, CSHARP::NFA_CSHARP_90, CSHARP::NFA_CSHARP_91, CSHARP::NFA_CSHARP_92, CSHARP::NFA_CSHARP_93, CSHARP::NFA_CSHARP_94, CSHARP::NFA_CSHARP_95, CSHARP::NFA_CSHARP_96, CSHARP::NFA_CSHARP_97, CSHARP::NFA_CSHARP_98, CSHARP::NFA_CSHARP_99, CSHARP::NFA_CSHARP_100, CSHARP::NFA_CSHARP_101, CSHARP::NFA_CSHARP_102, CSHARP::NFA_CSHARP_103, CSHARP::NFA_CSHARP_104, CSHARP::NFA_CSHARP_105, CSHARP::NFA_CSHARP_106, CSHARP::NFA_CSHARP_107, CSHARP::NFA_CSHARP_108, CSHARP::NFA_CSHARP_109, CSHARP::NFA_CSHARP_110, CSHARP::NFA_CSHARP_111, CSHARP::NFA_CSHARP_112, CSHARP::NFA_CSHARP_113, CSHARP::NFA_CSHARP_114, CSHARP::NFA_CSHARP_115, CSHARP::NFA_CSHARP_116, CSHARP::NFA_CSHARP_117, CSHARP::NFA_CSHARP_118, CSHARP::NFA_CSHARP_119, CSHARP::NFA_CSHARP_120, CSHARP::NFA_CSHARP_121, CSHARP::NFA_CSHARP_122, CSHARP::NFA_CSHARP_123, CSHARP::NFA_CSHARP_124, CSHARP::NFA_CSHARP_125, CSHARP::NFA_CSHARP_126, CSHARP::NFA_CSHARP_127, CSHARP::NFA_CSHARP_128, CSHARP::NFA_CSHARP_129, CSHARP::NFA_CSHARP_130, CSHARP::NFA_CSHARP_131, CSHARP::NFA_CSHARP_132, CSHARP::NFA_CSHARP_133, CSHARP::NFA_CSHARP_134, CSHARP::NFA_CSHARP_135, CSHARP::NFA_CSHARP_136, CSHARP::NFA_CSHARP_137, CSHARP::NFA_CSHARP_138, CSHARP::NFA_CSHARP_139, CSHARP::NFA_CSHARP_140, CSHARP::NFA_CSHARP_141, CSHARP::NFA_CSHARP_142, CSHARP::NFA_CSHARP_143, CSHARP::NFA_CSHARP_144, CSHARP::NFA_CSHARP_145, CSHARP::NFA_CSHARP_146, CSHARP::NFA_CSHARP_147, CSHARP::NFA_CSHARP_148, CSHARP::NFA_CSHARP_149, CSHARP::NFA_CSHARP_150, CSHARP::NFA_CSHARP_151, CSHARP::NFA_CSHARP_152, CSHARP::NFA_CSHARP_153, CSHARP::NFA_CSHARP_154, CSHARP::NFA_CSHARP_155, CSHARP::NFA_CSHARP_156, CSHARP::NFA_CSHARP_157, CSHARP::NFA_CSHARP_158, CSHARP::NFA_CSHARP_159, CSHARP::NFA_CSHARP_160, CSHARP::NFA_CSHARP_161, CSHARP::NFA_CSHARP_162, CSHARP::NFA_CSHARP_163, CSHARP::NFA_CSHARP_164, CSHARP::NFA_CSHARP_165, CSHARP::NFA_CSHARP_166, CSHARP::NFA_CSHARP_167, CSHARP::NFA_CSHARP_168, CSHARP::NFA_CSHARP_169, CSHARP::NFA_CSHARP_170, CSHARP::NFA_CSHARP_171, CSHARP::NFA_CSHARP_172, CSHARP::NFA_CSHARP_173, CSHARP::NFA_CSHARP_174, CSHARP::NFA_CSHARP_175, CSHARP::NFA_CSHARP_176, CSHARP::NFA_CSHARP_177, CSHARP::NFA_CSHARP_178, CSHARP::NFA_CSHARP_179, CSHARP::NFA_CSHARP_180, CSHARP::NFA_CSHARP_181, CSHARP::NFA_CSHARP_182, CSHARP::NFA_CSHARP_183, CSHARP::NFA_CSHARP_184, CSHARP::NFA_CSHARP_185, CSHARP::NFA_CSHARP_186, CSHARP::NFA_CSHARP_187, CSHARP::NFA_CSHARP_188, CSHARP::NFA_CSHARP_189, CSHARP::NFA_CSHARP_190, CSHARP::NFA_CSHARP_191, CSHARP::NFA_CSHARP_192, CSHARP::NFA_CSHARP_193, CSHARP::NFA_CSHARP_194, CSHARP::NFA_CSHARP_195, CSHARP::NFA_CSHARP_196, CSHARP::NFA_CSHARP_197, CSHARP::NFA_CSHARP_198, CSHARP::NFA_CSHARP_199, CSHARP::NFA_CSHARP_200, CSHARP::NFA_CSHARP_201, CSHARP::NFA_CSHARP_202, CSHARP::NFA_CSHARP_203, CSHARP::NFA_CSHARP_204, CSHARP::NFA_CSHARP_205, CSHARP::NFA_CSHARP_206, CSHARP::NFA_CSHARP_207, CSHARP::NFA_CSHARP_208, CSHARP::NFA_CSHARP_209, CSHARP::NFA_CSHARP_210, CSHARP::NFA_CSHARP_211, CSHARP::NFA_CSHARP_212, CSHARP::NFA_CSHARP_213, CSHARP::NFA_CSHARP_214, CSHARP::NFA_CSHARP_215, CSHARP::NFA_CSHARP_216, CSHARP::NFA_CSHARP_217, CSHARP::NFA_CSHARP_218, CSHARP::NFA_CSHARP_219, CSHARP::NFA_CSHARP_220, CSHARP::NFA_CSHARP_221, CSHARP::NFA_CSHARP_222, CSHARP::NFA_CSHARP_223, CSHARP::NFA_CSHARP_224, CSHARP::NFA_CSHARP_225, CSHARP::NFA_CSHARP_226, CSHARP::NFA_CSHARP_227, CSHARP::NFA_CSHARP_228, CSHARP::NFA_CSHARP_229, CSHARP::NFA_CSHARP_230, CSHARP::NFA_CSHARP_231, CSHARP::NFA_CSHARP_232, CSHARP::NFA_CSHARP_233, CSHARP::NFA_CSHARP_234, CSHARP::NFA_CSHARP_235, CSHARP::NFA_CSHARP_236, CSHARP::NFA_CSHARP_237, CSHARP::NFA_CSHARP_238, CSHARP::NFA_CSHARP_239, CSHARP::NFA_CSHARP_240, CSHARP::NFA_CSHARP_241, CSHARP::NFA_CSHARP_242, CSHARP::NFA_CSHARP_243, CSHARP::NFA_CSHARP_244, CSHARP::NFA_CSHARP_245, CSHARP::NFA_CSHARP_246, CSHARP::NFA_CSHARP_247, CSHARP::NFA_CSHARP_248, CSHARP::NFA_CSHARP_249, CSHARP::NFA_CSHARP_250, CSHARP::NFA_CSHARP_251, CSHARP::NFA_CSHARP_252, CSHARP::NFA_CSHARP_253, CSHARP::NFA_CSHARP_254, CSHARP::NFA_CSHARP_255, CSHARP::NFA_CSHARP_256, CSHARP::NFA_CSHARP_257, CSHARP::NFA_CSHARP_258, CSHARP::NFA_CSHARP_259, CSHARP::NFA_CSHARP_260, CSHARP::NFA_CSHARP_261, CSHARP::NFA_CSHARP_262, CSHARP::NFA_CSHARP_263, CSHARP::NFA_CSHARP_264, CSHARP::NFA_CSHARP_265, CSHARP::NFA_CSHARP_266, CSHARP::NFA_CSHARP_267, CSHARP::NFA_CSHARP_268, CSHARP::NFA_CSHARP_269, CSHARP::NFA_CSHARP_270, CSHARP::NFA_CSHARP_271, CSHARP::NFA_CSHARP_272, CSHARP::NFA_CSHARP_273, CSHARP::NFA_CSHARP_274, CSHARP::NFA_CSHARP_275, CSHARP::NFA_CSHARP_276, CSHARP::NFA_CSHARP_277, CSHARP::NFA_CSHARP_278, CSHARP::NFA_CSHARP_279, CSHARP::NFA_CSHARP_280, CSHARP::NFA_CSHARP_281, CSHARP::NFA_CSHARP_282, CSHARP::NFA_CSHARP_283, CSHARP::NFA_CSHARP_284, CSHARP::NFA_CSHARP_285, CSHARP::NFA_CSHARP_286, CSHARP::NFA_CSHARP_287, CSHARP::NFA_CSHARP_288, CSHARP::NFA_CSHARP_289, CSHARP::NFA_CSHARP_290, CSHARP::NFA_CSHARP_291, CSHARP::NFA_CSHARP_292, CSHARP::NFA_CSHARP_293, CSHARP::NFA_CSHARP_294, CSHARP::NFA_CSHARP_295, CSHARP::NFA_CSHARP_296, CSHARP::NFA_CSHARP_297, CSHARP::NFA_CSHARP_298, CSHARP::NFA_CSHARP_299, CSHARP::NFA_CSHARP_300, CSHARP::NFA_CSHARP_301, CSHARP::NFA_CSHARP_302, CSHARP::NFA_CSHARP_303, CSHARP::NFA_CSHARP_304, CSHARP::NFA_CSHARP_305, CSHARP::NFA_CSHARP_306, CSHARP::NFA_CSHARP_307, CSHARP::NFA_CSHARP_308, CSHARP::NFA_CSHARP_309, CSHARP::NFA_CSHARP_310, CSHARP::NFA_CSHARP_311, CSHARP::NFA_CSHARP_312, CSHARP::NFA_CSHARP_313, CSHARP::NFA_CSHARP_314, CSHARP::NFA_CSHARP_315, CSHARP::NFA_CSHARP_316, CSHARP::NFA_CSHARP_317, CSHARP::NFA_CSHARP_318, CSHARP::NFA_CSHARP_319, CSHARP::NFA_CSHARP_320, CSHARP::NFA_CSHARP_321, CSHARP::NFA_CSHARP_322, CSHARP::NFA_CSHARP_323, CSHARP::NFA_CSHARP_324, CSHARP::NFA_CSHARP_325, CSHARP::NFA_CSHARP_326, CSHARP::NFA_CSHARP_327, CSHARP::NFA_CSHARP_328, CSHARP::NFA_CSHARP_329, CSHARP::NFA_CSHARP_330, CSHARP::NFA_CSHARP_331, CSHARP::NFA_CSHARP_332, CSHARP::NFA_CSHARP_333, CSHARP::NFA_CSHARP_334, CSHARP::NFA_CSHARP_335, CSHARP::NFA_CSHARP_336, CSHARP::NFA_CSHARP_337, CSHARP::NFA_CSHARP_338, CSHARP::NFA_CSHARP_339, CSHARP::NFA_CSHARP_340, CSHARP::NFA_CSHARP_341, CSHARP::NFA_CSHARP_342, CSHARP::NFA_CSHARP_343, CSHARP::NFA_CSHARP_344, CSHARP::NFA_CSHARP_345, CSHARP::NFA_CSHARP_346, CSHARP::NFA_CSHARP_347, CSHARP::NFA_CSHARP_348, CSHARP::NFA_CSHARP_349, CSHARP::NFA_CSHARP_350, CSHARP::NFA_CSHARP_351, CSHARP::NFA_CSHARP_352, CSHARP::NFA_CSHARP_353, CSHARP::NFA_CSHARP_354, CSHARP::NFA_CSHARP_355, CSHARP::NFA_CSHARP_356, CSHARP::NFA_CSHARP_357, CSHARP::NFA_CSHARP_358, CSHARP::NFA_CSHARP_359, CSHARP::NFA_CSHARP_360, CSHARP::NFA_CSHARP_361, CSHARP::NFA_CSHARP_362, CSHARP::NFA_CSHARP_363, CSHARP::NFA_CSHARP_364, CSHARP::NFA_CSHARP_365, CSHARP::NFA_CSHARP_366, CSHARP::NFA_CSHARP_367, CSHARP::NFA_CSHARP_368, CSHARP::NFA_CSHARP_369, CSHARP::NFA_CSHARP_370, CSHARP::NFA_CSHARP_371, CSHARP::NFA_CSHARP_372, CSHARP::NFA_CSHARP_373, CSHARP::NFA_CSHARP_374, CSHARP::NFA_CSHARP_375, CSHARP::NFA_CSHARP_376, CSHARP::NFA_CSHARP_377, CSHARP::NFA_CSHARP_378, CSHARP::NFA_CSHARP_379, CSHARP::NFA_CSHARP_380, CSHARP::NFA_CSHARP_381, CSHARP::NFA_CSHARP_382, CSHARP::NFA_CSHARP_383, CSHARP::NFA_CSHARP_384, CSHARP::NFA_CSHARP_385, CSHARP::NFA_CSHARP_386, CSHARP::NFA_CSHARP_387, CSHARP::NFA_CSHARP_388, CSHARP::NFA_CSHARP_389, CSHARP::NFA_CSHARP_390, CSHARP::NFA_CSHARP_391, CSHARP::NFA_CSHARP_392, CSHARP::NFA_CSHARP_393, CSHARP::NFA_CSHARP_394, CSHARP::NFA_CSHARP_395, CSHARP::NFA_CSHARP_396, CSHARP::NFA_CSHARP_397, CSHARP::NFA_CSHARP_398, CSHARP::NFA_CSHARP_399, CSHARP::NFA_CSHARP_400, CSHARP::NFA_CSHARP_401, CSHARP::NFA_CSHARP_402, CSHARP::NFA_CSHARP_403, CSHARP::NFA_CSHARP_404, CSHARP::NFA_CSHARP_405, CSHARP::NFA_CSHARP_406, CSHARP::NFA_CSHARP_407, CSHARP::NFA_CSHARP_408, CSHARP::NFA_CSHARP_409, CSHARP::NFA_CSHARP_410, CSHARP::NFA_CSHARP_411, CSHARP::NFA_CSHARP_412, CSHARP::NFA_CSHARP_413, CSHARP::NFA_CSHARP_414, CSHARP::NFA_CSHARP_415, CSHARP::NFA_CSHARP_416, CSHARP::NFA_CSHARP_417, CSHARP::NFA_CSHARP_418, CSHARP::NFA_CSHARP_419, CSHARP::NFA_CSHARP_420, CSHARP::NFA_CSHARP_421, CSHARP::NFA_CSHARP_422, CSHARP::NFA_CSHARP_423, CSHARP::NFA_CSHARP_424, CSHARP::NFA_CSHARP_425, CSHARP::NFA_CSHARP_426, CSHARP::NFA_CSHARP_427, CSHARP::NFA_CSHARP_428, CSHARP::NFA_CSHARP_429, CSHARP::NFA_CSHARP_430, CSHARP::NFA_CSHARP_431, CSHARP::NFA_CSHARP_432, CSHARP::NFA_CSHARP_433, CSHARP::NFA_CSHARP_434, CSHARP::NFA_CSHARP_435, CSHARP::NFA_CSHARP_436, CSHARP::NFA_CSHARP_437, CSHARP::NFA_CSHARP_438, CSHARP::NFA_CSHARP_439, CSHARP::NFA_CSHARP_440, CSHARP::NFA_CSHARP_441, CSHARP::NFA_CSHARP_442, CSHARP::NFA_CSHARP_443, CSHARP::NFA_CSHARP_444, CSHARP::NFA_CSHARP_445, CSHARP::NFA_CSHARP_446, CSHARP::NFA_CSHARP_447, CSHARP::NFA_CSHARP_448, CSHARP::NFA_CSHARP_449, CSHARP::NFA_CSHARP_450, CSHARP::NFA_CSHARP_451, CSHARP::NFA_CSHARP_452, CSHARP::NFA_CSHARP_453, CSHARP::NFA_CSHARP_454, CSHARP::NFA_CSHARP_455, CSHARP::NFA_CSHARP_456, CSHARP::NFA_CSHARP_457, CSHARP::NFA_CSHARP_458, CSHARP::NFA_CSHARP_459, CSHARP::NFA_CSHARP_460, CSHARP::NFA_CSHARP_461, CSHARP::NFA_CSHARP_462, CSHARP::NFA_CSHARP_463, CSHARP::NFA_CSHARP_464, CSHARP::NFA_CSHARP_465, CSHARP::NFA_CSHARP_466, CSHARP::NFA_CSHARP_467, CSHARP::NFA_CSHARP_468, CSHARP::NFA_CSHARP_469, CSHARP::NFA_CSHARP_470, CSHARP::NFA_CSHARP_471, CSHARP::NFA_CSHARP_472, CSHARP::NFA_CSHARP_473, CSHARP::NFA_CSHARP_474, CSHARP::NFA_CSHARP_475, CSHARP::NFA_CSHARP_476, CSHARP::NFA_CSHARP_477, CSHARP::NFA_CSHARP_478, CSHARP::NFA_CSHARP_479, CSHARP::NFA_CSHARP_480, CSHARP::NFA_CSHARP_481, CSHARP::NFA_CSHARP_482, CSHARP::NFA_CSHARP_483, CSHARP::NFA_CSHARP_484, CSHARP::NFA_CSHARP_485, CSHARP::NFA_CSHARP_486, CSHARP::NFA_CSHARP_487, CSHARP::NFA_CSHARP_488, CSHARP::NFA_CSHARP_489, CSHARP::NFA_CSHARP_490, CSHARP::NFA_CSHARP_491, CSHARP::NFA_CSHARP_492, CSHARP::NFA_CSHARP_493, CSHARP::NFA_CSHARP_494, CSHARP::NFA_CSHARP_495, CSHARP::NFA_CSHARP_496, CSHARP::NFA_CSHARP_497, CSHARP::NFA_CSHARP_498, CSHARP::NFA_CSHARP_499, CSHARP::NFA_CSHARP_500, CSHARP::NFA_CSHARP_501, CSHARP::NFA_CSHARP_502, CSHARP::NFA_CSHARP_503, CSHARP::NFA_CSHARP_504, CSHARP::NFA_CSHARP_505, CSHARP::NFA_CSHARP_506, CSHARP::NFA_CSHARP_507, CSHARP::NFA_CSHARP_508, CSHARP::NFA_CSHARP_509, CSHARP::NFA_CSHARP_510, CSHARP::NFA_CSHARP_511, CSHARP::NFA_CSHARP_512, CSHARP::NFA_CSHARP_513, CSHARP::NFA_CSHARP_514, CSHARP::NFA_CSHARP_515, CSHARP::NFA_CSHARP_516, CSHARP::NFA_CSHARP_517, CSHARP::NFA_CSHARP_518, CSHARP::NFA_CSHARP_519, CSHARP::NFA_CSHARP_520, CSHARP::NFA_CSHARP_521, CSHARP::NFA_CSHARP_522, CSHARP::NFA_CSHARP_523, CSHARP::NFA_CSHARP_524, CSHARP::NFA_CSHARP_525, CSHARP::NFA_CSHARP_526, CSHARP::NFA_CSHARP_527, CSHARP::NFA_CSHARP_528, CSHARP::NFA_CSHARP_529, CSHARP::NFA_CSHARP_530, CSHARP::NFA_CSHARP_531, CSHARP::NFA_CSHARP_532, CSHARP::NFA_CSHARP_533, CSHARP::NFA_CSHARP_534, CSHARP::NFA_CSHARP_535, CSHARP::NFA_CSHARP_536, CSHARP::NFA_CSHARP_537, CSHARP::NFA_CSHARP_538, CSHARP::NFA_CSHARP_539, CSHARP::NFA_CSHARP_540, CSHARP::NFA_CSHARP_541, CSHARP::NFA_CSHARP_542, CSHARP::NFA_CSHARP_543, CSHARP::NFA_CSHARP_544, CSHARP::NFA_CSHARP_545, CSHARP::NFA_CSHARP_546, CSHARP::NFA_CSHARP_547, CSHARP::NFA_CSHARP_548, CSHARP::NFA_CSHARP_549, CSHARP::NFA_CSHARP_550, CSHARP::NFA_CSHARP_551, CSHARP::NFA_CSHARP_552, CSHARP::NFA_CSHARP_553, CSHARP::NFA_CSHARP_554, CSHARP::NFA_CSHARP_555, CSHARP::NFA_CSHARP_556, CSHARP::NFA_CSHARP_557, CSHARP::NFA_CSHARP_558, CSHARP::NFA_CSHARP_559, CSHARP::NFA_CSHARP_560, CSHARP::NFA_CSHARP_561, CSHARP::NFA_CSHARP_562, CSHARP::NFA_CSHARP_563, CSHARP::NFA_CSHARP_564, CSHARP::NFA_CSHARP_565, CSHARP::NFA_CSHARP_566, CSHARP::NFA_CSHARP_567, CSHARP::NFA_CSHARP_568, CSHARP::NFA_CSHARP_569, CSHARP::NFA_CSHARP_570, CSHARP::NFA_CSHARP_571, CSHARP::NFA_CSHARP_572, CSHARP::NFA_CSHARP_573, CSHARP::NFA_CSHARP_574, CSHARP::NFA_CSHARP_575, CSHARP::NFA_CSHARP_576, CSHARP::NFA_CSHARP_577, CSHARP::NFA_CSHARP_578, CSHARP::NFA_CSHARP_579, CSHARP::NFA_CSHARP_580, CSHARP::NFA_CSHARP_581, CSHARP::NFA_CSHARP_582, CSHARP::NFA_CSHARP_583, CSHARP::NFA_CSHARP_584, CSHARP::NFA_CSHARP_585, CSHARP::NFA_CSHARP_586, CSHARP::NFA_CSHARP_587, CSHARP::NFA_CSHARP_588, CSHARP::NFA_CSHARP_589, CSHARP::NFA_CSHARP_590, CSHARP::NFA_CSHARP_591, CSHARP::NFA_CSHARP_592, CSHARP::NFA_CSHARP_593, CSHARP::NFA_CSHARP_594, CSHARP::NFA_CSHARP_595, CSHARP::NFA_CSHARP_596, CSHARP::NFA_CSHARP_597, CSHARP::NFA_CSHARP_598, CSHARP::NFA_CSHARP_599, CSHARP::NFA_CSHARP_600, CSHARP::NFA_CSHARP_601, CSHARP::NFA_CSHARP_602, CSHARP::NFA_CSHARP_603, CSHARP::NFA_CSHARP_604, CSHARP::NFA_CSHARP_605, CSHARP::NFA_CSHARP_606, CSHARP::NFA_CSHARP_607, CSHARP::NFA_CSHARP_608, CSHARP::NFA_CSHARP_609, CSHARP::NFA_CSHARP_610, CSHARP::NFA_CSHARP_611, CSHARP::NFA_CSHARP_612, CSHARP::NFA_CSHARP_613, CSHARP::NFA_CSHARP_614, CSHARP::NFA_CSHARP_615, CSHARP::NFA_CSHARP_616, CSHARP::NFA_CSHARP_617, CSHARP::NFA_CSHARP_618, CSHARP::NFA_CSHARP_619, CSHARP::NFA_CSHARP_620, CSHARP::NFA_CSHARP_621, CSHARP::NFA_CSHARP_622, CSHARP::NFA_CSHARP_623, CSHARP::NFA_CSHARP_624, CSHARP::NFA_CSHARP_625, CSHARP::NFA_CSHARP_626};
            functionTableMap.put(LexicalState.CSHARP, functions);
        }
    }

    static interface NfaFunction {
        public CSToken.TokenType apply(int var1, BitSet var2, EnumSet<CSToken.TokenType> var3);
    }

    static class MatchInfo {
        CSToken.TokenType matchedType;
        int matchLength;

        MatchInfo(CSToken.TokenType matchedType, int matchLength) {
            this.matchedType = matchedType;
            this.matchLength = matchLength;
        }
    }

    public static enum LexicalState {
        CSHARP,
        IN_REGULAR_INTERPOLATION,
        IN_MULTI_INTERPOLATION,
        IN_IGNORED_SECTION,
        IN_INTERPOLATED_RAW_STRING,
        IN_RAW_STRING;

    }
}

