/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.codegen;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.ast.ArithmeticEngine;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.congocc.app.AppSettings;
import org.congocc.app.Errors;
import org.congocc.codegen.java.CodeInjector;
import org.congocc.codegen.java.JavaCodeUtils;
import org.congocc.codegen.java.JavaFormatter;
import org.congocc.core.Grammar;
import org.congocc.core.LexerData;
import org.congocc.core.RegularExpression;
import org.congocc.parser.CongoCCParser;
import org.congocc.parser.ParseException;
import org.congocc.parser.tree.CompilationUnit;

public class FilesGenerator {
    private final Configuration fmConfig = new Configuration();
    private final Grammar grammar;
    private final LexerData lexerData;
    private final AppSettings appSettings;
    private final Errors errors;
    private final CodeInjector codeInjector;
    private final Set<String> tokenSubclassFileNames = new HashSet<String>();
    private final HashMap<String, String> superClassLookup = new HashMap();
    private final String codeLang;
    private final boolean generateRootApi;
    private final Set<String> nonNodeNames = new HashSet<String>(){
        {
            this.add("ParseException.java");
            this.add("ParsingProblem.java");
            this.add("Token.java");
            this.add("InvalidToken.java");
            this.add("Node.java");
            this.add("TokenSource.java");
            this.add("NonTerminalCall.java");
        }
    };

    void initializeTemplateEngine() throws IOException {
        Path filename = this.appSettings.getFilename().toAbsolutePath();
        Path dir = filename.getParent();
        String templateFolder = "/templates/".concat(this.codeLang);
        Path altDir = dir.resolve(templateFolder.substring(1));
        ArrayList<TemplateLoader> loaders = new ArrayList<TemplateLoader>();
        loaders.add(new FileTemplateLoader(dir.toFile()));
        if (Files.exists(altDir, new LinkOption[0])) {
            loaders.add(new FileTemplateLoader(altDir.toFile()));
        }
        loaders.add(new ClassTemplateLoader(this.getClass(), templateFolder));
        MultiTemplateLoader templateLoader = new MultiTemplateLoader(loaders.toArray(new TemplateLoader[0]));
        this.fmConfig.setTemplateLoader(templateLoader);
        this.fmConfig.setObjectWrapper(new BeansWrapper());
        this.fmConfig.setNumberFormat("computer");
        this.fmConfig.setArithmeticEngine(ArithmeticEngine.CONSERVATIVE_ENGINE);
        this.fmConfig.setStrictVariableDefinition(true);
        this.fmConfig.setSharedVariable("grammar", this.grammar);
        this.fmConfig.setSharedVariable("globals", this.grammar.getTemplateGlobals());
        this.fmConfig.setSharedVariable("settings", this.grammar.getAppSettings());
        this.fmConfig.setSharedVariable("lexerData", this.grammar.getLexerData());
        this.fmConfig.setSharedVariable("generated_by", "CongoCC Parser Generator");
        if (this.codeLang.equals("java")) {
            this.fmConfig.addAutoImport("CU", "CommonUtils.java.ftl");
        }
    }

    public FilesGenerator(Grammar grammar, String codeLang) {
        this.grammar = grammar;
        this.lexerData = grammar.getLexerData();
        this.appSettings = grammar.getAppSettings();
        this.codeLang = this.appSettings.getCodeLang();
        this.errors = grammar.getErrors();
        this.generateRootApi = this.appSettings.getRootAPIPackage() == null;
        this.codeInjector = grammar.getInjector();
    }

    public void generateAll() throws IOException {
        if (this.errors.getErrorCount() != 0) {
            throw new ParseException();
        }
        this.initializeTemplateEngine();
        switch (this.codeLang) {
            case "java": {
                this.generateToken();
                this.generateLexer();
                this.generateOtherFiles();
                if (!this.grammar.getProductionTable().isEmpty()) {
                    if (this.generateRootApi) {
                        this.generateParseException();
                    }
                    this.generateParser();
                }
                if (this.appSettings.getFaultTolerant() && this.generateRootApi) {
                    this.generateInvalidNode();
                    this.generateParsingProblem();
                }
                if (!this.appSettings.getTreeBuildingEnabled()) break;
                this.generateTreeBuildingFiles();
                break;
            }
            case "python": {
                String[] paths = new String[]{"__init__.py", "utils.py", "tokens.py", "lexer.py", "parser.py"};
                Path outDir = this.appSettings.getParserOutputDirectory();
                for (String p : paths) {
                    Path outputFile = outDir.resolve(p);
                    this.generate(outputFile);
                }
                break;
            }
            case "csharp": {
                String[] paths = new String[]{"Utils.cs", "Tokens.cs", "Lexer.cs", "Parser.cs", null};
                String csPackageName = this.grammar.getTemplateGlobals().getPreprocessorSymbol("cs.package", this.appSettings.getParserPackage());
                paths[paths.length - 1] = csPackageName + ".csproj";
                Path outDir = this.appSettings.getParserOutputDirectory();
                for (String p : paths) {
                    Path outputFile = outDir.resolve(p);
                    this.generate(outputFile);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Code generation in '%s' is currently not supported.", this.codeLang));
            }
        }
    }

    public void generate(Path outputFile) throws IOException {
        this.generate(null, outputFile);
    }

    private String getTemplateName(String outputFilename) {
        String result = outputFilename + ".ftl";
        if (this.codeLang.equals("java")) {
            if (outputFilename.equals(this.appSettings.getBaseTokenClassName() + ".java")) {
                result = "Token.java.ftl";
            } else if (this.tokenSubclassFileNames.contains(outputFilename)) {
                result = "ASTToken.java.ftl";
            } else if (outputFilename.equals(this.appSettings.getParserClassName() + ".java")) {
                result = "Parser.java.ftl";
            } else if (outputFilename.endsWith("Lexer.java") || outputFilename.equals(this.appSettings.getLexerClassName() + ".java")) {
                result = "Lexer.java.ftl";
            } else if (outputFilename.equals(this.appSettings.getBaseNodeClassName() + ".java")) {
                result = "BaseNode.java.ftl";
            } else if (outputFilename.startsWith(this.appSettings.getNodePrefix()) && !this.nonNodeNames.contains(outputFilename) && !outputFilename.equals(this.appSettings.getBaseTokenClassName() + ".java")) {
                result = "ASTNode.java.ftl";
            }
        } else if (this.codeLang.equals("csharp") && outputFilename.endsWith(".csproj")) {
            result = "project.csproj.ftl";
        }
        return result;
    }

    public void generate(String nodeName, Path outputFile) throws IOException {
        String currentFilename = outputFile.getFileName().toString();
        String templateName = this.getTemplateName(currentFilename);
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("filename", currentFilename);
        dataModel.put("isAbstract", this.grammar.nodeIsAbstract(nodeName));
        dataModel.put("isInterface", this.grammar.nodeIsInterface(nodeName));
        String classname = currentFilename.substring(0, currentFilename.length() - 5);
        String superClassName = this.superClassLookup.get(classname);
        if (superClassName == null) {
            superClassName = this.appSettings.getBaseTokenClassName();
        }
        dataModel.put("superclass", superClassName);
        StringWriter out = new StringWriter();
        Template template = this.fmConfig.getTemplate(templateName);
        dataModel.put("injector", this.grammar.getInjector());
        template.process(dataModel, out);
        String code = ((Object)out).toString();
        if (!this.appSettings.isQuiet()) {
            System.out.println("Outputting: " + outputFile.normalize());
        }
        if (outputFile.getFileName().toString().endsWith(".java")) {
            this.outputJavaFile(code, outputFile);
        } else {
            try (BufferedWriter outfile = Files.newBufferedWriter(outputFile, new OpenOption[0]);){
                outfile.write(code);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void outputJavaFile(String code, Path outputFile) throws IOException {
        CompilationUnit jcu;
        Path dir = outputFile.getParent();
        if (Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        BufferedWriter out = Files.newBufferedWriter(outputFile, new OpenOption[0]);
        try {
            jcu = CongoCCParser.parseJavaFile(outputFile.getFileName().toString(), code);
        }
        catch (Exception e) {
            out.write(code);
            return;
        }
        finally {
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        try (BufferedWriter output = Files.newBufferedWriter(outputFile, new OpenOption[0]);){
            this.codeInjector.injectCode(jcu);
            JavaCodeUtils.removeWrongJDKElements(jcu, this.grammar.getAppSettings().getJdkTarget());
            JavaCodeUtils.addGetterSetters(jcu);
            JavaCodeUtils.stripUnused(jcu);
            JavaFormatter formatter = new JavaFormatter();
            output.write(formatter.format(jcu));
        }
    }

    void generateOtherFiles() throws IOException {
        if (this.generateRootApi) {
            Path outputFile = this.appSettings.getParserOutputDirectory().resolve("TokenSource.java");
            this.generate(outputFile);
            outputFile = this.appSettings.getParserOutputDirectory().resolve("NonTerminalCall.java");
            this.generate(outputFile);
        }
    }

    void generateParseException() throws IOException {
        Path outputFile = this.appSettings.getParserOutputDirectory().resolve("ParseException.java");
        if (this.regenerate(outputFile)) {
            this.generate(outputFile);
        }
    }

    void generateParsingProblem() throws IOException {
        Path outputFile = this.appSettings.getParserOutputDirectory().resolve("ParsingProblem.java");
        if (this.regenerate(outputFile)) {
            this.generate(outputFile);
        }
    }

    void generateInvalidNode() throws IOException {
        Path outputFile = this.appSettings.getNodeOutputDirectory().resolve("InvalidNode.java");
        if (this.regenerate(outputFile)) {
            this.generate(outputFile);
        }
    }

    void generateToken() throws IOException {
        String filename = this.appSettings.getBaseTokenClassName() + ".java";
        Path outputFile = this.appSettings.getParserOutputDirectory().resolve(filename);
        if (this.regenerate(outputFile)) {
            this.generate(outputFile);
        }
        if (this.regenerate(outputFile = this.appSettings.getParserOutputDirectory().resolve("InvalidToken.java"))) {
            this.generate(outputFile);
        }
    }

    void generateLexer() throws IOException {
        String filename = this.appSettings.getLexerClassName() + ".java";
        Path outputFile = this.appSettings.getParserOutputDirectory().resolve(filename);
        this.generate(outputFile);
    }

    void generateParser() throws IOException {
        if (this.errors.getErrorCount() != 0) {
            throw new ParseException();
        }
        String filename = this.appSettings.getParserClassName() + ".java";
        Path outputFile = this.appSettings.getParserOutputDirectory().resolve(filename);
        this.generate(outputFile);
    }

    void generateNodeFile() throws IOException {
        Path outputFile = this.appSettings.getParserOutputDirectory().resolve("Node.java");
        if (this.regenerate(outputFile)) {
            this.generate(outputFile);
        }
    }

    private boolean regenerate(Path file) throws IOException {
        String extension;
        if (!Files.exists(file, new LinkOption[0])) {
            return true;
        }
        String ourName = file.getFileName().toString();
        String canonicalName = file.normalize().getFileName().toString();
        if (canonicalName.equalsIgnoreCase(ourName) && !canonicalName.equals(ourName)) {
            String msg = "You cannot have two files that differ only in case, as in " + ourName + " and " + canonicalName + "\nThis does work on a case-sensitive file system but fails on a case-insensitive one (i.e. Mac/Windows) \nYou will need to rename something in your grammar!";
            throw new IOException(msg);
        }
        String filename = file.getFileName().toString();
        String string = this.codeLang.equals("java") ? ".java" : (extension = this.codeLang.equals("python") ? ".py" : ".cs");
        if (filename.endsWith(extension)) {
            String typename = filename.substring(0, filename.length() - extension.length());
            if (this.codeInjector.hasInjectedCode(typename)) {
                return true;
            }
            if (typename.equals(this.appSettings.getBaseTokenClassName())) {
                return true;
            }
        }
        return extension.equals(".py") || extension.equals(".cs");
    }

    void generateTreeBuildingFiles() throws IOException {
        Path outputFile;
        if (this.generateRootApi) {
            this.generateNodeFile();
        }
        LinkedHashMap<String, Path> files = new LinkedHashMap<String, Path>();
        files.put(this.appSettings.getBaseNodeClassName(), this.getOutputFile(this.appSettings.getBaseNodeClassName()));
        for (RegularExpression regularExpression : this.lexerData.getOrderedNamedTokens()) {
            if (regularExpression.isPrivate()) continue;
            String tokenClassName = regularExpression.getGeneratedClassName();
            outputFile = this.getOutputFile(tokenClassName);
            files.put(tokenClassName, outputFile);
            this.tokenSubclassFileNames.add(outputFile.getFileName().toString());
            String superClassName = regularExpression.getGeneratedSuperClassName();
            if (superClassName == null) continue;
            outputFile = this.getOutputFile(superClassName);
            files.put(superClassName, outputFile);
            this.tokenSubclassFileNames.add(outputFile.getFileName().toString());
            this.superClassLookup.put(tokenClassName, superClassName);
        }
        for (Map.Entry entry : this.appSettings.getExtraTokens().entrySet()) {
            String value = (String)entry.getValue();
            outputFile = this.getOutputFile(value);
            files.put(value, outputFile);
            this.tokenSubclassFileNames.add(outputFile.getFileName().toString());
        }
        for (String string : this.grammar.getNodeNames()) {
            if (string.indexOf(46) > 0) continue;
            Path outputFile2 = this.getOutputFile(string);
            if (this.tokenSubclassFileNames.contains(outputFile2.getFileName().toString())) {
                String name = outputFile2.getFileName().toString();
                name = name.substring(0, name.length() - 5);
                this.errors.addError("The name " + name + " is already used as a Token subclass.");
            }
            files.put(string, outputFile2);
        }
        for (Map.Entry entry : files.entrySet()) {
            if (!this.regenerate((Path)entry.getValue())) continue;
            this.generate((String)entry.getKey(), (Path)entry.getValue());
        }
    }

    private Path getOutputFile(String nodeName) throws IOException {
        if (nodeName.equals(this.appSettings.getBaseNodeClassName())) {
            return this.appSettings.getNodeOutputDirectory().resolve(nodeName + ".java");
        }
        String className = this.grammar.getNodeClassName(nodeName);
        if (nodeName.equals(this.appSettings.getBaseNodeClassName())) {
            className = nodeName;
        }
        return this.appSettings.getNodeOutputDirectory().resolve(className + ".java");
    }
}

