/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.app;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.congocc.app.Errors;
import org.congocc.core.Grammar;
import org.congocc.core.LexerData;
import org.congocc.parser.Node;

public class AppSettings {
    private static Pattern extraTokenPattern = Pattern.compile("^(\\w+)(#\\w+)?$");
    private Grammar grammar;
    private Errors errors;
    private Map<String, Object> settings = new HashMap<String, Object>();
    private Path outputDir;
    private Path filename;
    private Path includedFileDirectory;
    private String codeLang;
    private String parserPackage;
    private String parserClassName;
    private String lexerClassName;
    private String baseName;
    private String baseNodeClassName;
    private String baseTokenClassName;
    private Set<String> usedIdentifiers = new HashSet<String>();
    private Set<String> tokensOffByDefault = new LinkedHashSet<String>();
    private Map<String, String> extraTokens = new LinkedHashMap<String, String>();
    private boolean ignoreCase;
    private boolean quiet;
    private int jdkTarget = 8;
    private String booleanSettings = ",FAULT_TOLERANT,PRESERVE_TABS,PRESERVE_LINE_ENDINGS,JAVA_UNICODE_ESCAPE,IGNORE_CASE,LEXER_USES_PARSER,NODE_DEFAULT_VOID,SMART_NODE_CREATION,NODE_USES_PARSER,TREE_BUILDING_DEFAULT,TREE_BUILDING_ENABLED,TOKENS_ARE_NODES,SPECIAL_TOKENS_ARE_NODES,UNPARSED_TOKENS_ARE_NODES,FREEMARKER_NODES,NODE_FACTORY,TOKEN_MANAGER_USES_PARSER,ENSURE_FINAL_EOL,MINIMAL_TOKEN,C_CONTINUATION_LINE,USE_CHECKED_EXCEPTION,LEGACY_GLITCHY_LOOKAHEAD,TOKEN_CHAINING,USES_PREPROCESSOR,";
    private String stringSettings = ",BASE_NAME,PARSER_PACKAGE,PARSER_CLASS,LEXER_CLASS,BASE_SRC_DIR,BASE_NODE_CLASS,BASE_TOKEN_CLASS,NODE_PREFIX,NODE_CLASS,NODE_PACKAGE,DEFAULT_LEXICAL_STATE,NODE_CLASS,OUTPUT_DIRECTORY,DEACTIVATE_TOKENS,EXTRA_TOKENS,ROOT_API_PACKAGE,COPYRIGHT_BLURB,TERMINATING_STRING,";
    private String integerSettings = ",TAB_SIZE,TABS_TO_SPACES,JDK_TARGET,";
    private static Map<String, String> locationAliases = new HashMap<String, String>(){
        {
            this.put("JAVA_IDENTIFIER_DEF", "/include/java/JavaIdentifierDef.ccc");
            this.put("JAVA_LEXER", "/include/java/JavaLexer.ccc");
            this.put("JAVA", "/include/java/Java.ccc");
            this.put("PYTHON_IDENTIFIER_DEF", "/include/python/PythonIdentifierDef.ccc");
            this.put("PYTHON_LEXER", "/include/python/PythonLexer.ccc");
            this.put("PYTHON", "/include/python/Python.ccc");
            this.put("CSHARP", "/include/csharp/CSharp.ccc");
            this.put("CSHARP_LEXER", "/include/csharp/CSharpLexer.ccc");
            this.put("CSHARP_IDENTIFIER_DEF", "/include/csharp/CSharpIdentifierDef.ccc");
            this.put("PREPROCESSOR", "/include/preprocessor/Preprocessor.ccc");
            this.put("JSON", "/include/json/JSON.ccc");
            this.put("JSONC", "/include/json/JSONC.ccc");
            this.put("LUA", "/include/lua/Lua.ccc");
        }
    };

    public AppSettings(Grammar grammar) {
        this.grammar = grammar;
        this.errors = grammar.getErrors();
    }

    public String getCodeLang() {
        return this.codeLang;
    }

    public void setCodeLang(String codeLang) {
        this.codeLang = codeLang;
    }

    public Set<String> getDeactivatedTokens() {
        return this.tokensOffByDefault;
    }

    public Map<String, String> getExtraTokens() {
        return this.extraTokens;
    }

    public List<String> getExtraTokenNames() {
        return new ArrayList<String>(this.extraTokens.keySet());
    }

    public Collection<String> getExtraTokenClassNames() {
        return this.extraTokens.values();
    }

    public boolean isASetting(String key) {
        return this.booleanSettings.contains("," + key + ",") || this.stringSettings.contains("," + key + ",") || this.integerSettings.contains("," + key + ",");
    }

    private void typeCheckSettings(Map<String, Object> settings) {
        for (String key : settings.keySet()) {
            Object value = settings.get(key);
            if (this.booleanSettings.contains("," + key + ",")) {
                if (value instanceof Boolean) continue;
                this.errors.addError("The option " + key + " is supposed to be a boolean (true/false) type");
                continue;
            }
            if (this.stringSettings.contains("," + key + ",")) {
                if (value instanceof String) continue;
                this.errors.addError("The option " + key + " is supposed to be a string");
                continue;
            }
            if (this.integerSettings.contains("," + key + ",")) {
                if (value instanceof Integer) continue;
                this.errors.addError("The option " + key + " is supposed to be an integer");
                continue;
            }
            this.errors.addWarning("The option " + key + " is not recognized and will be ignored.");
        }
    }

    private void sanityCheckSettings() {
        if (!this.getTreeBuildingEnabled()) {
            String msg = "You have specified the OPTION_NAME option but it is meaningless unless the TREE_BUILDING_ENABLED is set to true. This option will be ignored.\n";
            if (this.settings.get("TOKENS_ARE_NODES") != null) {
                this.errors.addWarning(null, msg.replace("OPTION_NAME", "TOKENS_ARE_NODES"));
            }
            if (this.settings.get("UNPARSED_TOKENS_ARE_NODES") != null) {
                this.errors.addWarning(null, msg.replace("OPTION_NAME", "UNPARSED_TOKENS_ARE_NODES"));
            }
            if (this.settings.get("SMART_NODE_CREATION") != null) {
                this.errors.addWarning(null, msg.replace("OPTION_NAME", "SMART_NODE_CREATION"));
            }
            if (this.settings.get("NODE_DEFAULT_VOID") != null) {
                this.errors.addWarning(null, msg.replace("OPTION_NAME", "NODE_DEFAULT_VOID"));
            }
            if (this.settings.get("NODE_USES_PARSER") != null) {
                this.errors.addWarning(null, msg.replace("OPTION_NAME", "NODE_USES_PARSER"));
            }
        }
    }

    public void setSettings(Map<String, Object> settings) {
        this.typeCheckSettings(settings);
        if (!this.grammar.isInInclude()) {
            this.settings = settings;
            this.sanityCheckSettings();
        }
        for (String key : settings.keySet()) {
            StringTokenizer st;
            Object value = settings.get(key);
            if (key.equals("IGNORE_CASE")) {
                this.setIgnoreCase((Boolean)value);
            } else if (key.equals("DEFAULT_LEXICAL_STATE")) {
                this.grammar.setDefaultLexicalState((String)value);
            } else if (key.equals("DEACTIVATE_TOKENS")) {
                String tokens = (String)settings.get(key);
                st = new StringTokenizer(tokens, ", \t\n\r");
                while (st.hasMoreTokens()) {
                    String tokenName = st.nextToken();
                    this.tokensOffByDefault.add(tokenName);
                }
            } else if (key.equals("EXTRA_TOKENS")) {
                String tokens = (String)settings.get(key);
                st = new StringTokenizer(tokens, ",\r\n");
                while (st.hasMoreTokens()) {
                    String tokenNameAndMaybeClass = st.nextToken();
                    Matcher m = extraTokenPattern.matcher(tokenNameAndMaybeClass);
                    if (!m.matches()) continue;
                    MatchResult mr = m.toMatchResult();
                    String tokenName = mr.group(1);
                    String tokenClassName = mr.group(2);
                    tokenClassName = tokenClassName == null ? tokenName + "Token" : tokenClassName.substring(1);
                    this.extraTokens.put(tokenName, tokenClassName);
                }
            } else if ((key.equals("BASE_SRC_DIR") || key.equals("OUTPUT_DIRECTORY")) && !this.grammar.isInInclude() && this.outputDir == null) {
                this.outputDir = Paths.get((String)value, new String[0]);
            }
            if (this.grammar.isInInclude() || !key.equals("JDK_TARGET") || this.jdkTarget != 0) continue;
            int jdkTarget = (Integer)value;
            if (jdkTarget >= 8 && jdkTarget <= 19) {
                this.jdkTarget = (Integer)value;
                continue;
            }
            this.jdkTarget = 8;
            this.errors.addWarning(null, "Invalid JDK Target " + jdkTarget);
        }
    }

    public int getJdkTarget() {
        if (this.jdkTarget == 0) {
            return 8;
        }
        return this.jdkTarget;
    }

    public void setJdkTarget(int jdkTarget) {
        this.jdkTarget = jdkTarget;
    }

    public String getBaseSourceDirectory() {
        return this.outputDir == null ? "." : this.outputDir.toString();
    }

    public Path getParserOutputDirectory() throws IOException {
        String packageName;
        Path dir;
        String baseSrcDir = (String)this.settings.get("BASE_SRC_DIR");
        if (baseSrcDir == null) {
            String string = baseSrcDir = this.outputDir == null ? "." : this.outputDir.toString();
        }
        if (!(dir = Paths.get(baseSrcDir, new String[0])).isAbsolute()) {
            Path inputFileDir = this.filename.toAbsolutePath().getParent();
            dir = inputFileDir.resolve(baseSrcDir);
        }
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        if ((packageName = this.getParserPackage()) != null && packageName.length() > 0) {
            if (this.codeLang.equals("java")) {
                if (!Files.exists(dir = dir.resolve(packageName = packageName.replace('.', '/')), new LinkOption[0])) {
                    Files.createDirectories(dir, new FileAttribute[0]);
                }
            } else if (this.codeLang.equals("python")) {
                int dotPosition = packageName.lastIndexOf(46);
                if (dotPosition >= 0) {
                    packageName = packageName.substring(dotPosition + 1);
                }
                packageName = packageName.concat("parser");
                packageName = this.grammar.getPreprocessorSymbols().getOrDefault("py.package", packageName);
                if (!Files.exists(dir = dir.resolve(packageName), new LinkOption[0])) {
                    Files.createDirectories(dir, new FileAttribute[0]);
                }
            } else if (this.codeLang.equals("csharp")) {
                if (this.outputDir == null) {
                    int dotPosition = packageName.lastIndexOf(46);
                    if (dotPosition >= 0) {
                        packageName = packageName.substring(dotPosition + 1);
                    }
                    if (!Files.exists(dir = dir.resolve(packageName = "cs-".concat(packageName.concat("parser"))), new LinkOption[0])) {
                        Files.createDirectories(dir, new FileAttribute[0]);
                    }
                }
            } else {
                throw new UnsupportedOperationException(String.format("Code generation in '%s' is not currently supported.", this.codeLang));
            }
        }
        return dir;
    }

    public String separatorString() {
        return this.codeLang.equals("java") ? "$" : "\u03a3";
    }

    public String getParserPackage() {
        if (this.parserPackage == null) {
            this.parserPackage = (String)this.settings.get("PARSER_PACKAGE");
        }
        if (this.parserPackage == null || this.parserPackage.length() == 0) {
            this.parserPackage = this.getParserClassName().toLowerCase();
        }
        return this.parserPackage;
    }

    public String getParserClassName() {
        if (this.parserClassName == null) {
            this.parserClassName = (String)this.settings.get("PARSER_CLASS");
        }
        if (this.parserClassName == null) {
            this.parserClassName = this.getBaseName() + "Parser";
        }
        return this.parserClassName;
    }

    public String getLexerClassName() {
        if (this.lexerClassName == null) {
            this.lexerClassName = (String)this.settings.get("LEXER_CLASS");
        }
        if (this.lexerClassName == null) {
            this.lexerClassName = this.getBaseName() + "Lexer";
        }
        return this.lexerClassName;
    }

    String getBaseName() {
        if (this.baseName == null) {
            this.baseName = (String)this.settings.get("BASE_NAME");
        }
        if (this.baseName == null) {
            this.baseName = this.filename.getFileName().toString();
            int lastDot = this.baseName.lastIndexOf(46);
            if (lastDot > 0) {
                this.baseName = this.baseName.substring(0, lastDot);
            }
            this.baseName = AppSettings.removeNonJavaIdentifierPart(this.baseName);
            if (Character.isLowerCase(this.baseName.charAt(0))) {
                this.baseName = this.baseName.substring(0, 1).toUpperCase() + this.baseName.substring(1);
            }
        }
        return this.baseName;
    }

    public Path getNodeOutputDirectory() throws IOException {
        String nodePackage = this.getNodePackage();
        String baseSrcDir = this.getBaseSourceDirectory();
        if (nodePackage == null || nodePackage.equals("") || baseSrcDir.equals("")) {
            return this.getParserOutputDirectory();
        }
        Path baseSource = Paths.get(baseSrcDir, new String[0]);
        if (!baseSource.isAbsolute()) {
            Path grammarFileDir = this.filename.normalize().getParent();
            if (grammarFileDir == null) {
                grammarFileDir = Paths.get(".", new String[0]);
            }
            baseSource = grammarFileDir.resolve(baseSrcDir).normalize();
        }
        if (!Files.isDirectory(baseSource, new LinkOption[0])) {
            if (!Files.exists(baseSource, new LinkOption[0])) {
                throw new FileNotFoundException("Directory " + baseSrcDir + " does not exist.");
            }
            throw new FileNotFoundException(baseSrcDir + " is not a directory.");
        }
        Path result = baseSource.resolve(nodePackage.replace('.', '/')).normalize();
        if (!Files.exists(result, new LinkOption[0])) {
            Files.createDirectories(result, new FileAttribute[0]);
        } else if (!Files.isDirectory(result, new LinkOption[0])) {
            throw new IOException(result + " is not a directory.");
        }
        return result;
    }

    public String getNodePackage() {
        String nodePackage = (String)this.settings.get("NODE_PACKAGE");
        if (nodePackage == null || nodePackage.equals(this.getParserPackage())) {
            nodePackage = this.getParserPackage() + ".ast";
        }
        return nodePackage;
    }

    public String getRootAPIPackage() {
        String rootApiPackage = (String)this.settings.get("ROOT_API_PACKAGE");
        if (rootApiPackage != null && rootApiPackage.equals(this.getParserPackage())) {
            return null;
        }
        return rootApiPackage;
    }

    public String getCopyrightBlurb() {
        String result = (String)this.settings.get("COPYRIGHT_BLURB");
        return result != null ? result : "";
    }

    public Path resolveLocation(String location) {
        Path path = Paths.get(location, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        if (!path.isAbsolute()) {
            path = this.filename.getParent();
            if (path == null) {
                path = Paths.get(".", new String[0]);
            }
            if (Files.exists(path = path.resolve(location), new LinkOption[0])) {
                return path;
            }
        }
        if (this.includedFileDirectory != null && Files.exists(path = this.includedFileDirectory.resolve(location), new LinkOption[0])) {
            return path;
        }
        if (LexerData.isJavaIdentifier(location)) {
            location = this.resolveAlias(location);
            path = this.filename.toAbsolutePath().getParent().resolve(Paths.get(location, new String[0]).getFileName());
            if (Files.exists(path, new LinkOption[0])) {
                return path;
            }
        }
        URI uri = null;
        try {
            uri = this.getClass().getResource(location).toURI();
        }
        catch (Exception e) {
            return null;
        }
        try {
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException fsne) {
            try {
                FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                return fs.getPath(location, new String[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public String resolveAlias(String location) {
        return locationAliases.getOrDefault(location, location);
    }

    public Path resolveLocation(List<String> locations) {
        for (String location : locations) {
            Path path = this.resolveLocation(location);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean getTreeBuildingEnabled() {
        Boolean b = (Boolean)this.settings.get("TREE_BUILDING_ENABLED");
        return b == null || b != false;
    }

    public int getTabSize() {
        Integer i = (Integer)this.settings.get("TAB_SIZE");
        if (i == null) {
            i = (Integer)this.settings.get("TABS_TO_SPACES");
        }
        return i == null ? 1 : i;
    }

    public boolean getUseCheckedException() {
        Boolean b = (Boolean)this.settings.get("USE_CHECKED_EXCEPTION");
        return b != null && b != false;
    }

    public boolean getCppContinuationLine() {
        Boolean b = (Boolean)this.settings.get("C_CONTINUATION_LINE");
        return b != null && b != false;
    }

    public boolean getJavaUnicodeEscape() {
        Boolean b = (Boolean)this.settings.get("JAVA_UNICODE_ESCAPE");
        return b != null && b != false;
    }

    public boolean getPreserveTabs() {
        Boolean b = (Boolean)this.settings.get("PRESERVE_TABS");
        if (b != null) {
            return b;
        }
        if (this.settings.get("TAB_SIZE") == null && this.settings.get("TABS_TO_SPACES") == null) {
            return true;
        }
        return this.getTabSize() == 0;
    }

    public boolean getPreserveLineEndings() {
        Boolean b = (Boolean)this.settings.get("PRESERVE_LINE_ENDINGS");
        return b != null && b != false;
    }

    public boolean getEnsureFinalEOL() {
        Boolean b = (Boolean)this.settings.get("ENSURE_FINAL_EOL");
        return b != null && b != false;
    }

    public boolean getTokenChaining() {
        Boolean b = (Boolean)this.settings.get("TOKEN_CHAINING");
        return b != null && b != false;
    }

    public boolean getMinimalToken() {
        if (this.getTokenChaining()) {
            return false;
        }
        Boolean b = (Boolean)this.settings.get("MINIMAL_TOKEN");
        return b != null && b != false;
    }

    public boolean getNodeUsesParser() {
        Boolean b = (Boolean)this.settings.get("NODE_USES_PARSER");
        return b != null && b != false;
    }

    public boolean getLexerUsesParser() {
        Boolean b = (Boolean)this.settings.get("LEXER_USES_PARSER");
        return b != null && b != false;
    }

    public boolean getFaultTolerant() {
        Boolean b = (Boolean)this.settings.get("FAULT_TOLERANT");
        return b != null && b != false;
    }

    public boolean getTokensAreNodes() {
        Boolean b = (Boolean)this.settings.get("TOKENS_ARE_NODES");
        return b == null || b != false;
    }

    public boolean getUnparsedTokensAreNodes() {
        Boolean b = (Boolean)this.settings.get("TOKENS_ARE_NODES");
        if (b == null) {
            b = (Boolean)this.settings.get("SPECIAL_TOKENS_ARE_NODES");
        }
        return b != null;
    }

    public boolean getFreemarkerNodes() {
        Boolean b = (Boolean)this.settings.get("FREEMARKER_NODES");
        return b != null && b != false;
    }

    public boolean getSmartNodeCreation() {
        Boolean b = (Boolean)this.settings.get("SMART_NODE_CREATION");
        return b == null || b != false;
    }

    public boolean getTreeBuildingDefault() {
        Boolean b = (Boolean)this.settings.get("TREE_BUILDING_DEFAULT");
        return b == null || b != false;
    }

    public boolean getNodeDefaultVoid() {
        Boolean b = (Boolean)this.settings.get("NODE_DEFAULT_VOID");
        return b != null && b != false;
    }

    public boolean getLegacyGlitchyLookahead() {
        Boolean b = (Boolean)this.settings.get("LEGACY_GLITCHY_LOOKAHEAD");
        return b != null && b != false;
    }

    public boolean getUsesPreprocessor() {
        if (this.getCppContinuationLine()) {
            return true;
        }
        Boolean b = (Boolean)this.settings.get("USES_PREPROCESSOR");
        return b != null && b != false;
    }

    public String getNodePrefix() {
        String nodePrefix = (String)this.settings.get("NODE_PREFIX");
        if (nodePrefix == null) {
            nodePrefix = "";
        }
        return nodePrefix;
    }

    public String getTerminatingString() {
        String terminatingString = (String)this.settings.get("TERMINATING_STRING");
        if (terminatingString == null && this.getEnsureFinalEOL()) {
            terminatingString = "\n";
        }
        return terminatingString == null ? "" : terminatingString;
    }

    public String getBaseNodeClassName() {
        if (this.baseNodeClassName == null) {
            this.baseNodeClassName = (String)this.settings.get("BASE_NODE_CLASS");
        }
        if (this.baseNodeClassName == null) {
            this.baseNodeClassName = this.getRootAPIPackage() == null || this.getBaseName().length() == 0 ? "BaseNode" : this.getBaseName() + "Node";
        }
        return this.baseNodeClassName;
    }

    public String getBaseTokenClassName() {
        if (this.baseTokenClassName == null) {
            this.baseTokenClassName = (String)this.settings.get("BASE_TOKEN_CLASS");
            if (this.baseTokenClassName == null) {
                this.baseTokenClassName = this.getRootAPIPackage() == null || this.getBaseName().length() == 0 ? "Token" : this.getBaseName() + "Token";
            }
        }
        return this.baseTokenClassName;
    }

    public void setOutputDir(Path outputDir) {
        this.outputDir = outputDir;
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public Path getIncludedFileDirectory() {
        return this.includedFileDirectory;
    }

    public void setIncludedFileDirectory(Path includedFileDirectory) {
        this.includedFileDirectory = includedFileDirectory;
    }

    public Path getFilename() {
        return this.filename;
    }

    public void setFilename(Path filename) {
        this.filename = filename;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public String generateUniqueIdentifier(String prefix, Node exp) {
        String inputSource = exp.getInputSource();
        String sep = this.separatorString();
        if (inputSource != null) {
            int lastSlash = Math.max(inputSource.lastIndexOf(92), inputSource.lastIndexOf(47));
            if (lastSlash + 1 < inputSource.length()) {
                inputSource = inputSource.substring(lastSlash + 1);
            }
        } else {
            inputSource = "";
        }
        String id = prefix + inputSource + sep + exp.getBeginLine() + sep + exp.getBeginColumn();
        id = AppSettings.removeNonJavaIdentifierPart(id);
        while (this.usedIdentifiers.contains(id)) {
            id = id + sep;
        }
        this.usedIdentifiers.add(id);
        return id;
    }

    public String generateIdentifierPrefix(String basePrefix) {
        return basePrefix + this.separatorString();
    }

    public static String removeNonJavaIdentifierPart(String s) {
        StringBuilder buf = new StringBuilder(s.length());
        for (int ch : s.codePoints().toArray()) {
            boolean addChar;
            boolean bl = addChar = buf.length() == 0 ? Character.isJavaIdentifierStart(ch) : Character.isJavaIdentifierPart(ch);
            if (addChar) {
                buf.appendCodePoint(ch);
            }
            if (ch != 46) continue;
            buf.appendCodePoint(95);
        }
        return buf.toString();
    }
}

