/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.WrappingTemplateModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SimpleSequence
extends WrappingTemplateModel
implements TemplateSequenceModel,
Serializable {
    private static final long serialVersionUID = 789777794622325773L;
    protected final List<Object> list;
    private List<Object> unwrappedList;

    public SimpleSequence() {
        this((ObjectWrapper)null);
    }

    public SimpleSequence(int capacity) {
        this.list = new ArrayList<Object>(capacity);
    }

    public SimpleSequence(Collection collection) {
        this(collection, null);
    }

    public SimpleSequence(TemplateCollectionModel tcm) {
        ArrayList<Object> alist = new ArrayList<Object>();
        TemplateModelIterator it = tcm.iterator();
        while (it.hasNext()) {
            alist.add(it.next());
        }
        alist.trimToSize();
        this.list = alist;
    }

    public SimpleSequence(ObjectWrapper wrapper) {
        super(wrapper);
        this.list = new ArrayList<Object>();
    }

    public SimpleSequence(Collection<?> collection, ObjectWrapper wrapper) {
        super(wrapper);
        this.list = new ArrayList(collection);
    }

    public void add(Object obj) {
        this.list.add(obj);
        this.unwrappedList = null;
    }

    public void add(boolean b) {
        if (b) {
            this.add(TemplateBooleanModel.TRUE);
        } else {
            this.add(TemplateBooleanModel.FALSE);
        }
    }

    public List toList() {
        if (this.unwrappedList == null) {
            Class<?> listClass = this.list.getClass();
            List result = null;
            try {
                result = (List)listClass.newInstance();
            }
            catch (Exception e) {
                throw new TemplateModelException("Error instantiating an object of type " + listClass.getName() + "\n" + e.getMessage());
            }
            BeansWrapper bw = BeansWrapper.getDefaultInstance();
            for (int i = 0; i < this.list.size(); ++i) {
                Object elem = this.list.get(i);
                if (elem instanceof TemplateModel) {
                    elem = bw.unwrap((TemplateModel)elem);
                }
                result.add(elem);
            }
            this.unwrappedList = result;
        }
        return this.unwrappedList;
    }

    @Override
    public TemplateModel get(int i) {
        try {
            Object value = this.list.get(i);
            if (value instanceof TemplateModel) {
                return (TemplateModel)value;
            }
            TemplateModel tm = this.wrap(value);
            this.list.set(i, tm);
            return tm;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public SimpleSequence synchronizedWrapper() {
        return new SynchronizedSequence();
    }

    public String toString() {
        return this.list.toString();
    }

    private class SynchronizedSequence
    extends SimpleSequence {
        private static final long serialVersionUID = 4787474310915789132L;

        private SynchronizedSequence() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(Object obj) {
            SimpleSequence simpleSequence = SimpleSequence.this;
            synchronized (simpleSequence) {
                SimpleSequence.this.add(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TemplateModel get(int i) {
            SimpleSequence simpleSequence = SimpleSequence.this;
            synchronized (simpleSequence) {
                return SimpleSequence.this.get(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            SimpleSequence simpleSequence = SimpleSequence.this;
            synchronized (simpleSequence) {
                return SimpleSequence.this.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List toList() {
            SimpleSequence simpleSequence = SimpleSequence.this;
            synchronized (simpleSequence) {
                return SimpleSequence.this.toList();
            }
        }
    }
}

