/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.dom.NodeModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModel;
import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Node;

public class DefaultObjectWrapper
extends BeansWrapper {
    static final DefaultObjectWrapper instance = new DefaultObjectWrapper();

    @Override
    public TemplateModel wrap(Object obj) {
        if (obj == null) {
            return super.wrap(null);
        }
        if (obj instanceof TemplateModel) {
            return (TemplateModel)obj;
        }
        if (obj instanceof String) {
            return new SimpleScalar((String)obj);
        }
        if (obj instanceof Number) {
            return new SimpleNumber((Number)obj);
        }
        if (obj instanceof java.util.Date) {
            if (obj instanceof Date) {
                return new SimpleDate((Date)obj);
            }
            if (obj instanceof Time) {
                return new SimpleDate((Time)obj);
            }
            if (obj instanceof Timestamp) {
                return new SimpleDate((Timestamp)obj);
            }
            return new SimpleDate((java.util.Date)obj, this.getDefaultDateType());
        }
        if (obj.getClass().isArray()) {
            obj = this.convertArray(obj);
        }
        if (obj instanceof Collection) {
            return new SimpleSequence((Collection)obj, this);
        }
        if (obj instanceof Map) {
            return new SimpleHash((Map)obj, this);
        }
        if (obj instanceof Boolean) {
            return obj.equals(Boolean.TRUE) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
        if (obj instanceof Iterator) {
            return new SimpleCollection((Iterator)obj, (ObjectWrapper)this);
        }
        return this.handleUnknownType(obj);
    }

    protected TemplateModel handleUnknownType(Object obj) {
        if (obj instanceof Node) {
            return this.wrapDomNode(obj);
        }
        return super.wrap(obj);
    }

    public TemplateModel wrapDomNode(Object obj) {
        return NodeModel.wrap((Node)obj);
    }

    protected Object convertArray(Object arr) {
        int size = Array.getLength(arr);
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(Array.get(arr, i));
        }
        return list;
    }
}

