/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.script;

import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.script.ScriptContext;

class ScriptContextHashModel
implements TemplateHashModelEx {
    private final ScriptContext context;
    private final ObjectWrapper wrapper;

    ScriptContextHashModel(ScriptContext context, ObjectWrapper wrapper) {
        this.context = context;
        this.wrapper = wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemplateModel get(String key) throws TemplateModelException {
        Object retval;
        ScriptContext scriptContext = this.context;
        synchronized (scriptContext) {
            retval = this.context.getAttribute(key);
        }
        return this.wrapper.wrap(retval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() throws TemplateModelException {
        ScriptContext scriptContext = this.context;
        synchronized (scriptContext) {
            for (int scope : this.context.getScopes()) {
                if (this.context.getBindings(scope).isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemplateCollectionModel keys() throws TemplateModelException {
        Set<String> keys;
        ScriptContext scriptContext = this.context;
        synchronized (scriptContext) {
            keys = this.getAllKeys();
        }
        return (TemplateCollectionModel)this.wrapper.wrap(keys);
    }

    private Set<String> getAllKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (int scope : this.context.getScopes()) {
            keys.addAll(this.context.getBindings(scope).keySet());
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Set<String> keys;
        ScriptContext scriptContext = this.context;
        synchronized (scriptContext) {
            keys = this.getAllKeys();
        }
        return keys.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemplateCollectionModel values() throws TemplateModelException {
        ArrayList<Object> values;
        ScriptContext scriptContext = this.context;
        synchronized (scriptContext) {
            Set<String> keys = this.getAllKeys();
            values = new ArrayList<Object>(keys.size());
            for (String key : keys) {
                Object value;
                int scope = this.context.getAttributesScope(key);
                if (scope == -1 || (value = this.context.getAttribute(key)) == null) continue;
                values.add(value);
            }
        }
        return (TemplateCollectionModel)this.wrapper.wrap(values);
    }
}

