/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.SimpleMemberModel;
import freemarker.template.Parameters;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public final class SimpleMethodModel
extends SimpleMemberModel<Method>
implements TemplateMethodModelEx,
TemplateSequenceModel {
    private final Object object;
    private final BeansWrapper wrapper;

    SimpleMethodModel(Object object, Method method, Class[] argTypes, BeansWrapper wrapper) {
        super(method, argTypes);
        this.object = object;
        this.wrapper = wrapper;
    }

    @Override
    public Object exec(List arguments) throws TemplateModelException {
        try {
            return this.wrapper.invokeMethod(this.object, (Method)this.getMember(), this.unwrapArguments(arguments, this.wrapper));
        }
        catch (Exception e) {
            Throwable t;
            while (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof Exception) {
                e = (Exception)t;
            }
            if ((((Method)this.getMember()).getModifiers() & 8) != 0) {
                throw new TemplateModelException("Method " + this.getMember() + " threw an exception", e);
            }
            throw new TemplateModelException("Method " + this.getMember() + " threw an exception when invoked on " + this.object, e);
        }
    }

    @Override
    public TemplateModel get(int index) throws TemplateModelException {
        return (TemplateModel)this.exec(Collections.singletonList(new SimpleNumber((Number)index)));
    }

    @Override
    public int size() throws TemplateModelException {
        throw new TemplateModelException("?size is unsupported for: " + this.getClass().getName());
    }

    public Parameters getParametersAnnotation() {
        return ((Method)this.getMember()).getAnnotation(Parameters.class);
    }

    public String toString() {
        return ((Method)this.getMember()).toGenericString();
    }
}

