/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.ArrayModel;
import freemarker.ext.beans.BeansModelCache;
import freemarker.ext.beans.BooleanModel;
import freemarker.ext.beans.ClassBasedModelFactory;
import freemarker.ext.beans.CollectionAdapter;
import freemarker.ext.beans.CollectionModel;
import freemarker.ext.beans.DateModel;
import freemarker.ext.beans.EnumModels;
import freemarker.ext.beans.EnumerationModel;
import freemarker.ext.beans.HashAdapter;
import freemarker.ext.beans.IteratorModel;
import freemarker.ext.beans.ListModel;
import freemarker.ext.beans.MapModel;
import freemarker.ext.beans.MemberAndArguments;
import freemarker.ext.beans.MethodMap;
import freemarker.ext.beans.NumberModel;
import freemarker.ext.beans.ResourceBundleModel;
import freemarker.ext.beans.SequenceAdapter;
import freemarker.ext.beans.SetAdapter;
import freemarker.ext.beans.SimpleMapModel;
import freemarker.ext.beans.SimpleMemberModel;
import freemarker.ext.beans.StaticModels;
import freemarker.ext.beans.StringModel;
import freemarker.ext.util.ModelCache;
import freemarker.ext.util.ModelFactory;
import freemarker.ext.util.WrapperTemplateModel;
import freemarker.log.Logger;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public class BeansWrapper
implements ObjectWrapper {
    public static final Object CAN_NOT_UNWRAP = new Object();
    private static final Class<BigInteger> BIGINTEGER_CLASS = BigInteger.class;
    private static final Class<Boolean> BOOLEAN_CLASS = Boolean.class;
    private static final Class<Character> CHARACTER_CLASS = Character.class;
    private static final Class<Collection> COLLECTION_CLASS = Collection.class;
    private static final Class<Date> DATE_CLASS = Date.class;
    private static final Class<HashAdapter> HASHADAPTER_CLASS = HashAdapter.class;
    private static final Class<Iterable> ITERABLE_CLASS = Iterable.class;
    private static final Class<List> LIST_CLASS = List.class;
    private static final Class<Map> MAP_CLASS = Map.class;
    private static final Class<Number> NUMBER_CLASS = Number.class;
    private static final Class<Object> OBJECT_CLASS = Object.class;
    private static final Class<SequenceAdapter> SEQUENCEADAPTER_CLASS = SequenceAdapter.class;
    private static final Class<Set> SET_CLASS = Set.class;
    private static final Class<SetAdapter> SETADAPTER_CLASS = SetAdapter.class;
    private static final Class<String> STRING_CLASS = String.class;
    private static final boolean DEVELOPMENT = "true".equals(System.getProperty("freemarker.development"));
    private static final Logger logger = Logger.getLogger("freemarker.beans");
    private static final Set<Method> UNSAFE_METHODS = BeansWrapper.createUnsafeMethodsSet();
    static final Object GENERIC_GET_KEY = new Object();
    private static final Object CONSTRUCTORS = new Object();
    private static final Map<AccessibleObject, Class<?>[]> ARGTYPES = new HashMap<AccessibleObject, Class<?>[]>();
    private static final BeansWrapper INSTANCE = new BeansWrapper();
    private final Map<Class<?>, Map> classCache = new ConcurrentHashMap();
    private Set<String> cachedClassNames = new HashSet<String>();
    private final ClassBasedModelFactory staticModels = new StaticModels(this);
    private final ClassBasedModelFactory enumModels = new EnumModels(this);
    private final ModelCache modelCache = new BeansModelCache(this);
    private final BooleanModel FALSE = new BooleanModel(Boolean.FALSE, this);
    private final BooleanModel TRUE = new BooleanModel(Boolean.TRUE, this);
    public static final int EXPOSE_ALL = 0;
    public static final int EXPOSE_SAFE = 1;
    public static final int EXPOSE_PROPERTIES_ONLY = 2;
    public static final int EXPOSE_NOTHING = 3;
    private int exposureLevel = 1;
    private boolean methodsShadowItems = true;
    private boolean exposeFields = false;
    private int defaultDateType = 0;
    private ObjectWrapper outerIdentity = this;
    private boolean simpleMapWrapper = true;
    private boolean strict = false;
    private final ModelFactory BOOLEAN_FACTORY = new ModelFactory(){

        @Override
        public TemplateModel create(Object object, ObjectWrapper wrapper) {
            return (Boolean)object != false ? BeansWrapper.this.TRUE : BeansWrapper.this.FALSE;
        }
    };
    private static final ModelFactory ITERATOR_FACTORY = new ModelFactory(){

        @Override
        public TemplateModel create(Object object, ObjectWrapper wrapper) {
            return new IteratorModel((Iterator)object, (BeansWrapper)wrapper);
        }
    };
    private static final ModelFactory ENUMERATION_FACTORY = new ModelFactory(){

        @Override
        public TemplateModel create(Object object, ObjectWrapper wrapper) {
            return new EnumerationModel((Enumeration)object, (BeansWrapper)wrapper);
        }
    };

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setOuterIdentity(ObjectWrapper outerIdentity) {
        this.outerIdentity = outerIdentity;
    }

    public ObjectWrapper getOuterIdentity() {
        return this.outerIdentity;
    }

    public void setSimpleMapWrapper(boolean simpleMapWrapper) {
        this.simpleMapWrapper = simpleMapWrapper;
    }

    public boolean isSimpleMapWrapper() {
        return this.simpleMapWrapper;
    }

    public void setExposureLevel(int exposureLevel) {
        if (exposureLevel < 0 || exposureLevel > 3) {
            throw new IllegalArgumentException("Illegal exposure level " + exposureLevel);
        }
        this.exposureLevel = exposureLevel;
    }

    int getExposureLevel() {
        return this.exposureLevel;
    }

    public synchronized void setMethodsShadowItems(boolean methodsShadowItems) {
        this.methodsShadowItems = methodsShadowItems;
    }

    boolean isMethodsShadowItems() {
        return this.methodsShadowItems;
    }

    public void setExposeFields(boolean exposeFields) {
        this.exposeFields = exposeFields;
    }

    public boolean isExposeFields() {
        return this.exposeFields;
    }

    public synchronized void setDefaultDateType(int defaultDateType) {
        this.defaultDateType = defaultDateType;
    }

    protected synchronized int getDefaultDateType() {
        return this.defaultDateType;
    }

    public void setUseCache(boolean useCache) {
        this.modelCache.setUseCache(useCache);
    }

    public static final BeansWrapper getDefaultInstance() {
        return INSTANCE;
    }

    @Override
    public TemplateModel wrap(Object object) throws TemplateModelException {
        if (object == null) {
            return TemplateModel.JAVA_NULL;
        }
        return this.modelCache.getInstance(object);
    }

    protected ModelFactory getModelFactory(Class clazz) {
        if (Map.class.isAssignableFrom(clazz)) {
            return this.simpleMapWrapper ? SimpleMapModel.FACTORY : MapModel.FACTORY;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return ListModel.FACTORY;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return CollectionModel.FACTORY;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return NumberModel.FACTORY;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return DateModel.FACTORY;
        }
        if (Boolean.class == clazz) {
            return this.BOOLEAN_FACTORY;
        }
        if (ResourceBundle.class.isAssignableFrom(clazz)) {
            return ResourceBundleModel.FACTORY;
        }
        if (Iterator.class.isAssignableFrom(clazz)) {
            return ITERATOR_FACTORY;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return ENUMERATION_FACTORY;
        }
        if (clazz.isArray()) {
            return ArrayModel.FACTORY;
        }
        return StringModel.FACTORY;
    }

    protected TemplateModel create(Object object, Object factory) {
        return ((ModelFactory)factory).create(object, this);
    }

    public Object unwrap(TemplateModel model) throws TemplateModelException {
        return this.unwrap(model, OBJECT_CLASS);
    }

    public Object unwrap(TemplateModel model, Class requiredType) throws TemplateModelException {
        return this.unwrap(model, requiredType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unwrap(TemplateModel model, Class<?> requiredType, Map<TemplateModel, Object> recursionStops) throws TemplateModelException {
        Date date;
        Number number;
        Number number2;
        boolean isChar;
        if (model == null) {
            throw new TemplateModelException("invalid reference");
        }
        if (model == TemplateModel.JAVA_NULL) {
            return null;
        }
        boolean isBoolean = Boolean.TYPE == requiredType;
        boolean bl = isChar = Character.TYPE == requiredType;
        if (model instanceof AdapterTemplateModel) {
            Object adapted = ((AdapterTemplateModel)model).getAdaptedObject(requiredType);
            if (requiredType.isInstance(adapted)) {
                return adapted;
            }
            if (adapted instanceof Number && (requiredType.isPrimitive() && !isChar && !isBoolean || NUMBER_CLASS.isAssignableFrom(requiredType)) && (number2 = BeansWrapper.convertUnwrappedNumber(requiredType, (Number)adapted)) != null) {
                return number2;
            }
        }
        if (model instanceof WrapperTemplateModel) {
            Object wrapped = ((WrapperTemplateModel)model).getWrappedObject();
            if (requiredType.isInstance(wrapped)) {
                return wrapped;
            }
            if (wrapped instanceof Number && (requiredType.isPrimitive() && !isChar && !isBoolean || NUMBER_CLASS.isAssignableFrom(requiredType)) && (number2 = BeansWrapper.convertUnwrappedNumber(requiredType, (Number)wrapped)) != null) {
                return number2;
            }
        }
        if (STRING_CLASS == requiredType) {
            if (model instanceof TemplateScalarModel) {
                return ((TemplateScalarModel)model).getAsString();
            }
            return CAN_NOT_UNWRAP;
        }
        if ((requiredType.isPrimitive() && !isChar && !isBoolean || NUMBER_CLASS.isAssignableFrom(requiredType)) && model instanceof TemplateNumberModel && (number = BeansWrapper.convertUnwrappedNumber(requiredType, ((TemplateNumberModel)model).getAsNumber())) != null) {
            return number;
        }
        if (isBoolean || BOOLEAN_CLASS == requiredType) {
            if (model instanceof TemplateBooleanModel) {
                return ((TemplateBooleanModel)model).getAsBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            return CAN_NOT_UNWRAP;
        }
        if (MAP_CLASS == requiredType && model instanceof TemplateHashModel) {
            return new HashAdapter((TemplateHashModel)model, this);
        }
        if (LIST_CLASS == requiredType && model instanceof TemplateSequenceModel) {
            return new SequenceAdapter((TemplateSequenceModel)model, this);
        }
        if (SET_CLASS == requiredType && model instanceof TemplateCollectionModel) {
            return new SetAdapter((TemplateCollectionModel)model, this);
        }
        if (COLLECTION_CLASS == requiredType || ITERABLE_CLASS == requiredType) {
            if (model instanceof TemplateCollectionModel) {
                return new CollectionAdapter((TemplateCollectionModel)model, this);
            }
            if (model instanceof TemplateSequenceModel) {
                return new SequenceAdapter((TemplateSequenceModel)model, this);
            }
        }
        if (requiredType.isArray()) {
            if (model instanceof TemplateSequenceModel) {
                if (recursionStops != null) {
                    Object retval = recursionStops.get(model);
                    if (retval != null) {
                        return retval;
                    }
                } else {
                    recursionStops = new IdentityHashMap<TemplateModel, Object>();
                }
                TemplateSequenceModel seq = (TemplateSequenceModel)model;
                Class<?> componentType = requiredType.getComponentType();
                Object array = Array.newInstance(componentType, seq.size());
                recursionStops.put(model, array);
                try {
                    int size = seq.size();
                    for (int i = 0; i < size; ++i) {
                        Object val = this.unwrap(seq.get(i), componentType, recursionStops);
                        if (val == CAN_NOT_UNWRAP) {
                            Object object = CAN_NOT_UNWRAP;
                            return object;
                        }
                        Array.set(array, i, val);
                    }
                }
                finally {
                    recursionStops.remove(model);
                }
                return array;
            }
            return CAN_NOT_UNWRAP;
        }
        if (isChar || requiredType == CHARACTER_CLASS) {
            String s;
            if (model instanceof TemplateScalarModel && (s = ((TemplateScalarModel)model).getAsString()).length() == 1) {
                return Character.valueOf(s.charAt(0));
            }
            return CAN_NOT_UNWRAP;
        }
        if (DATE_CLASS.isAssignableFrom(requiredType) && model instanceof TemplateDateModel && requiredType.isInstance(date = ((TemplateDateModel)model).getAsDate())) {
            return date;
        }
        if (model instanceof TemplateNumberModel && requiredType.isInstance(number = ((TemplateNumberModel)model).getAsNumber())) {
            return number;
        }
        if (model instanceof TemplateDateModel && requiredType.isInstance(date = ((TemplateDateModel)model).getAsDate())) {
            return date;
        }
        if (model instanceof TemplateScalarModel && requiredType.isAssignableFrom(STRING_CLASS)) {
            return ((TemplateScalarModel)model).getAsString();
        }
        if (model instanceof TemplateBooleanModel && requiredType.isAssignableFrom(BOOLEAN_CLASS)) {
            return ((TemplateBooleanModel)model).getAsBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (model instanceof TemplateHashModel && requiredType.isAssignableFrom(HASHADAPTER_CLASS)) {
            return new HashAdapter((TemplateHashModel)model, this);
        }
        if (model instanceof TemplateSequenceModel && requiredType.isAssignableFrom(SEQUENCEADAPTER_CLASS)) {
            return new SequenceAdapter((TemplateSequenceModel)model, this);
        }
        if (model instanceof TemplateCollectionModel && requiredType.isAssignableFrom(SETADAPTER_CLASS)) {
            return new SetAdapter((TemplateCollectionModel)model, this);
        }
        if (requiredType.isInstance(model)) {
            return model;
        }
        return CAN_NOT_UNWRAP;
    }

    private static Number convertUnwrappedNumber(Class<?> hint, Number number) {
        if (hint == Integer.TYPE || hint == Integer.class) {
            return number.intValue();
        }
        if (hint == Long.TYPE || hint == Long.class) {
            return number.longValue();
        }
        if (hint == Float.TYPE || hint == Float.class) {
            return Float.valueOf(number.floatValue());
        }
        if (hint == Double.TYPE || hint == Double.class) {
            return number.doubleValue();
        }
        if (hint == Byte.TYPE || hint == Byte.class) {
            return number.byteValue();
        }
        if (hint == Short.TYPE || hint == Short.class) {
            return number.shortValue();
        }
        if (hint == BigInteger.class) {
            return number instanceof BigInteger ? number : new BigInteger(number.toString());
        }
        if (hint == BigDecimal.class) {
            if (number instanceof BigDecimal) {
                return number;
            }
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            if (number instanceof Long) {
                return new BigDecimal(number.toString());
            }
            return new BigDecimal(number.doubleValue());
        }
        if (hint.isInstance(number)) {
            return number;
        }
        return null;
    }

    TemplateModel invokeMethod(Object object, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException, TemplateModelException {
        Object retval = method.invoke(object, args);
        return method.getReturnType() == Void.TYPE ? TemplateModel.NOTHING : this.getOuterIdentity().wrap(retval);
    }

    public TemplateHashModel getStaticModels() {
        return this.staticModels;
    }

    public TemplateHashModel getEnumModels() {
        if (this.enumModels == null) {
            throw new UnsupportedOperationException("Enums not supported on pre-1.5 JRE");
        }
        return this.enumModels;
    }

    public Object newInstance(Class<?> clazz, List<TemplateModel> arguments) throws TemplateModelException {
        try {
            Object[] objargs;
            this.introspectClass(clazz);
            Map classInfo = this.classCache.get(clazz);
            Object ctors = classInfo.get(CONSTRUCTORS);
            if (ctors == null) {
                throw new TemplateModelException("Class " + clazz.getName() + " has no public constructors.");
            }
            Constructor ctor = null;
            if (ctors instanceof SimpleMemberModel) {
                SimpleMemberModel smm = (SimpleMemberModel)ctors;
                ctor = (Constructor)smm.getMember();
                objargs = smm.unwrapArguments(arguments, this);
            } else if (ctors instanceof MethodMap) {
                MethodMap methodMap = (MethodMap)ctors;
                MemberAndArguments maa = methodMap.getMemberAndArguments(arguments);
                objargs = maa.getArgs();
                ctor = (Constructor)maa.getMember();
            } else {
                throw new Error();
            }
            return ctor.newInstance(objargs);
        }
        catch (TemplateModelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateModelException("Could not create instance of class " + clazz.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void introspectClass(Class clazz) {
        if (!this.classCache.containsKey(clazz)) {
            Map<Class<?>, Map> map = this.classCache;
            synchronized (map) {
                if (!this.classCache.containsKey(clazz)) {
                    this.introspectClassInternal(clazz);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeIntrospectionInfo(Class clazz) {
        Map<Class<?>, Map> map = this.classCache;
        synchronized (map) {
            this.classCache.remove(clazz);
            this.staticModels.removeIntrospectionInfo(clazz);
            if (this.enumModels != null) {
                this.enumModels.removeIntrospectionInfo(clazz);
            }
            this.cachedClassNames.remove(clazz.getName());
            BeansWrapper beansWrapper = this;
            synchronized (beansWrapper) {
                this.modelCache.clearCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void introspectClassInternal(Class clazz) {
        String className = clazz.getName();
        if (this.cachedClassNames.contains(className)) {
            if (logger.isInfoEnabled()) {
                logger.info("Detected a reloaded class [" + className + "]. Clearing BeansWrapper caches.");
            }
            this.classCache.clear();
            this.cachedClassNames = new HashSet<String>();
            BeansWrapper beansWrapper = this;
            synchronized (beansWrapper) {
                this.modelCache.clearCache();
            }
            this.staticModels.clearCache();
            if (this.enumModels != null) {
                this.enumModels.clearCache();
            }
        }
        this.classCache.put(clazz, this.populateClassMap(clazz));
        this.cachedClassNames.add(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getClassKeyMap(Class clazz) {
        Map map = this.classCache.get(clazz);
        if (map == null) {
            Map<Class<?>, Map> map2 = this.classCache;
            synchronized (map2) {
                map = this.classCache.get(clazz);
                if (map == null) {
                    this.introspectClassInternal(clazz);
                    map = this.classCache.get(clazz);
                }
            }
        }
        return map;
    }

    int keyCount(Class clazz) {
        Map map = this.getClassKeyMap(clazz);
        int count = map.size();
        if (map.containsKey(CONSTRUCTORS)) {
            --count;
        }
        if (map.containsKey(GENERIC_GET_KEY)) {
            --count;
        }
        if (map.containsKey(ARGTYPES)) {
            --count;
        }
        return count;
    }

    Set keySet(Class clazz) {
        HashSet set = new HashSet(this.getClassKeyMap(clazz).keySet());
        set.remove(CONSTRUCTORS);
        set.remove(GENERIC_GET_KEY);
        set.remove(ARGTYPES);
        return set;
    }

    private Map populateClassMap(Class clazz) {
        Map<Object, SimpleMemberModel<Constructor<?>>> map = this.populateClassMapWithBeanInfo(clazz);
        try {
            Constructor<?>[] ctors = clazz.getConstructors();
            if (ctors.length == 1) {
                Constructor<?> ctor = ctors[0];
                map.put(CONSTRUCTORS, new SimpleMemberModel(ctor, ctor.getParameterTypes()));
            } else if (ctors.length > 1) {
                MethodMap ctorMap = new MethodMap("<init>", this);
                for (int i = 0; i < ctors.length; ++i) {
                    ctorMap.addMember(ctors[i]);
                }
                map.put(CONSTRUCTORS, (SimpleMemberModel<Constructor<?>>)((Object)ctorMap));
            }
        }
        catch (SecurityException e) {
            logger.warn("Canont discover constructors for class " + clazz.getName(), e);
        }
        switch (map.size()) {
            case 0: {
                map = Collections.EMPTY_MAP;
                break;
            }
            case 1: {
                Map.Entry e = map.entrySet().iterator().next();
                map = Collections.singletonMap(e.getKey(), e.getValue());
                break;
            }
        }
        return map;
    }

    private static Class[] componentizeLastArg(Class[] args, boolean varArg) {
        int lastArg;
        if (varArg && args != null && (lastArg = args.length - 1) >= 0) {
            args[lastArg] = args[lastArg].getComponentType();
        }
        return args;
    }

    private Map<Object, Object> populateClassMapWithBeanInfo(Class clazz) {
        HashMap<Object, Object> classMap = new HashMap<Object, Object>();
        if (this.exposeFields) {
            Field[] fields = clazz.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if ((field.getModifiers() & 8) != 0) continue;
                classMap.put(field.getName(), field);
            }
        }
        Map<MethodSignature, List<Method>> accessibleMethods = BeansWrapper.discoverAccessibleMethods(clazz);
        Method genericGet = BeansWrapper.getFirstAccessibleMethod(MethodSignature.GET_STRING_SIGNATURE, accessibleMethods);
        if (genericGet == null) {
            genericGet = BeansWrapper.getFirstAccessibleMethod(MethodSignature.GET_OBJECT_SIGNATURE, accessibleMethods);
        }
        if (genericGet != null) {
            classMap.put(GENERIC_GET_KEY, genericGet);
        }
        if (this.exposureLevel == 3) {
            return classMap;
        }
        try {
            int i;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] pda = beanInfo.getPropertyDescriptors();
            MethodDescriptor[] mda = beanInfo.getMethodDescriptors();
            for (i = pda.length - 1; i >= 0; --i) {
                PropertyDescriptor pd = pda[i];
                if (pd instanceof IndexedPropertyDescriptor) {
                    IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
                    Method indexedReadMethod = ipd.getIndexedReadMethod();
                    Method publicIndexedReadMethod = BeansWrapper.getAccessibleMethod(indexedReadMethod, accessibleMethods);
                    if (publicIndexedReadMethod == null || !this.isSafeMethod(publicIndexedReadMethod)) continue;
                    try {
                        if (indexedReadMethod != publicIndexedReadMethod) {
                            ipd = new IndexedPropertyDescriptor(ipd.getName(), ipd.getReadMethod(), ipd.getWriteMethod(), publicIndexedReadMethod, ipd.getIndexedWriteMethod());
                        }
                        classMap.put(ipd.getName(), ipd);
                        BeansWrapper.getArgTypes(classMap).put(publicIndexedReadMethod, BeansWrapper.componentizeLastArg(publicIndexedReadMethod.getParameterTypes(), publicIndexedReadMethod.isVarArgs()));
                    }
                    catch (IntrospectionException e) {
                        logger.warn("Failed creating a publicly-accessible property descriptor for " + clazz.getName() + " indexed property " + pd.getName() + ", read method " + publicIndexedReadMethod + ", write method " + ipd.getIndexedWriteMethod(), e);
                    }
                    continue;
                }
                Method readMethod = pd.getReadMethod();
                Method publicReadMethod = BeansWrapper.getAccessibleMethod(readMethod, accessibleMethods);
                if (publicReadMethod == null || !this.isSafeMethod(publicReadMethod)) continue;
                try {
                    if (readMethod != publicReadMethod) {
                        pd = new PropertyDescriptor(pd.getName(), publicReadMethod, pd.getWriteMethod());
                        pd.setReadMethod(publicReadMethod);
                    }
                    classMap.put(pd.getName(), pd);
                    continue;
                }
                catch (IntrospectionException e) {
                    logger.warn("Failed creating a publicly-accessible property descriptor for " + clazz.getName() + " property " + pd.getName() + ", read method " + publicReadMethod + ", write method " + pd.getWriteMethod(), e);
                }
            }
            if (this.exposureLevel < 2) {
                for (i = mda.length - 1; i >= 0; --i) {
                    MethodDescriptor md = mda[i];
                    Method method = md.getMethod();
                    Method publicMethod = BeansWrapper.getAccessibleMethod(method, accessibleMethods);
                    if (publicMethod == null || !this.isSafeMethod(publicMethod)) continue;
                    String name = md.getName();
                    Object previous = classMap.get(name);
                    if (previous instanceof Method) {
                        MethodMap<Method> methodMap = new MethodMap<Method>(name, this);
                        methodMap.addMember((Method)previous);
                        methodMap.addMember(publicMethod);
                        classMap.put(name, methodMap);
                        BeansWrapper.getArgTypes(classMap).remove(previous);
                        continue;
                    }
                    if (previous instanceof MethodMap) {
                        ((MethodMap)previous).addMember(publicMethod);
                        continue;
                    }
                    classMap.put(name, publicMethod);
                    BeansWrapper.getArgTypes(classMap).put(publicMethod, BeansWrapper.componentizeLastArg(publicMethod.getParameterTypes(), publicMethod.isVarArgs()));
                }
            }
            return classMap;
        }
        catch (IntrospectionException e) {
            logger.warn("Couldn't properly perform introspection for class " + clazz, e);
            return new HashMap<Object, Object>();
        }
    }

    private static Map<AccessibleObject, Class<?>[]> getArgTypes(Map classMap) {
        HashMap argTypes = (HashMap)classMap.get(ARGTYPES);
        if (argTypes == null) {
            argTypes = new HashMap();
            classMap.put(ARGTYPES, argTypes);
        }
        return argTypes;
    }

    static Class[] getArgTypes(Map classMap, AccessibleObject methodOrCtor) {
        return (Class[])((Map)classMap.get(ARGTYPES)).get(methodOrCtor);
    }

    private static Method getFirstAccessibleMethod(MethodSignature sig, Map<MethodSignature, List<Method>> accessibles) {
        List<Method> l = accessibles.get(sig);
        if (l == null || l.isEmpty()) {
            return null;
        }
        return l.iterator().next();
    }

    private static Method getAccessibleMethod(Method m, Map<MethodSignature, List<Method>> accessibles) {
        if (m == null) {
            return null;
        }
        MethodSignature sig = new MethodSignature(m);
        List<Method> l = accessibles.get(sig);
        if (l == null) {
            return null;
        }
        for (Method am : l) {
            if (am.getReturnType() != m.getReturnType()) continue;
            return am;
        }
        return null;
    }

    boolean isSafeMethod(Method method) {
        return this.exposureLevel < 1 || !UNSAFE_METHODS.contains(method);
    }

    private static Map<MethodSignature, List<Method>> discoverAccessibleMethods(Class<?> clazz) {
        HashMap<MethodSignature, List<Method>> map = new HashMap<MethodSignature, List<Method>>();
        BeansWrapper.discoverAccessibleMethods(clazz, map);
        return map;
    }

    private static void discoverAccessibleMethods(Class<?> clazz, Map<MethodSignature, List<Method>> map) {
        if (Modifier.isPublic(clazz.getModifiers())) {
            try {
                for (Method method : clazz.getMethods()) {
                    MethodSignature sig = new MethodSignature(method);
                    List<Method> methodList = map.get(sig);
                    if (methodList == null) {
                        methodList = new LinkedList<Method>();
                        map.put(sig, methodList);
                    }
                    methodList.add(method);
                }
                return;
            }
            catch (SecurityException e) {
                logger.warn("Could not discover accessible methods of class " + clazz.getName() + ", attemping superclasses/interfaces.", e);
            }
        }
        for (Class<?> inter : clazz.getInterfaces()) {
            BeansWrapper.discoverAccessibleMethods(inter, map);
        }
        if (clazz.getSuperclass() != null) {
            BeansWrapper.discoverAccessibleMethods(clazz.getSuperclass(), map);
        }
    }

    private static final Set<Method> createUnsafeMethodsSet() {
        Properties props = new Properties();
        InputStream in = BeansWrapper.class.getResourceAsStream("unsafeMethods.txt");
        if (in != null) {
            String string = null;
            try {
                try {
                    props.load(in);
                }
                finally {
                    in.close();
                }
                HashSet<Method> set = new HashSet<Method>(props.size() * 4 / 3, 0.75f);
                Map<String, Class<?>> primClasses = BeansWrapper.createPrimitiveClassesMap();
                for (String string2 : props.keySet()) {
                    try {
                        set.add(BeansWrapper.parseMethodSpec(string2, primClasses));
                    }
                    catch (ClassNotFoundException e) {
                        if (!DEVELOPMENT) continue;
                        throw e;
                    }
                    catch (NoSuchMethodException e) {
                        if (!DEVELOPMENT) continue;
                        throw e;
                    }
                }
                return set;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load unsafe method " + string + " " + e.getClass().getName() + " " + e.getMessage());
            }
        }
        return Collections.emptySet();
    }

    private static Method parseMethodSpec(String methodSpec, Map<String, Class<?>> primClasses) throws ClassNotFoundException, NoSuchMethodException {
        int brace = methodSpec.indexOf(40);
        int dot = methodSpec.lastIndexOf(46, brace);
        Class<?> clazz = Class.forName(methodSpec.substring(0, dot));
        String methodName = methodSpec.substring(dot + 1, brace);
        String argSpec = methodSpec.substring(brace + 1, methodSpec.length() - 1);
        StringTokenizer tok = new StringTokenizer(argSpec, ",");
        int argcount = tok.countTokens();
        Class[] argTypes = new Class[argcount];
        for (int i = 0; i < argcount; ++i) {
            String argClassName = tok.nextToken();
            argTypes[i] = primClasses.get(argClassName);
            if (argTypes[i] != null) continue;
            argTypes[i] = Class.forName(argClassName);
        }
        return clazz.getMethod(methodName, argTypes);
    }

    private static Map<String, Class<?>> createPrimitiveClassesMap() {
        HashMap map = new HashMap();
        map.put("boolean", Boolean.TYPE);
        map.put("byte", Byte.TYPE);
        map.put("char", Character.TYPE);
        map.put("short", Short.TYPE);
        map.put("int", Integer.TYPE);
        map.put("long", Long.TYPE);
        map.put("float", Float.TYPE);
        map.put("double", Double.TYPE);
        return map;
    }

    public static void coerceBigDecimals(Class<?>[] formalTypes, Object[] args) {
        int typeLen = formalTypes.length;
        int argsLen = args.length;
        int min = Math.min(typeLen, argsLen);
        for (int i = 0; i < min; ++i) {
            Object arg = args[i];
            if (!(arg instanceof BigDecimal)) continue;
            args[i] = BeansWrapper.coerceBigDecimal((BigDecimal)arg, formalTypes[i]);
        }
        if (argsLen > typeLen) {
            Class<?> varArgType = formalTypes[typeLen - 1];
            for (int i = typeLen; i < argsLen; ++i) {
                Object arg = args[i];
                if (!(arg instanceof BigDecimal)) continue;
                args[i] = BeansWrapper.coerceBigDecimal((BigDecimal)arg, varArgType);
            }
        }
    }

    public static Object coerceBigDecimal(BigDecimal bd, Class<?> formalType) {
        if (formalType == Integer.TYPE || formalType == Integer.class) {
            return bd.intValue();
        }
        if (formalType == Double.TYPE || formalType == Double.class) {
            return bd.doubleValue();
        }
        if (formalType == Long.TYPE || formalType == Long.class) {
            return bd.longValue();
        }
        if (formalType == Float.TYPE || formalType == Float.class) {
            return Float.valueOf(bd.floatValue());
        }
        if (formalType == Short.TYPE || formalType == Short.class) {
            return bd.shortValue();
        }
        if (formalType == Byte.TYPE || formalType == Byte.class) {
            return bd.byteValue();
        }
        if (BIGINTEGER_CLASS.isAssignableFrom(formalType)) {
            return bd.toBigInteger();
        }
        return bd;
    }

    static /* synthetic */ Class access$400() {
        return STRING_CLASS;
    }

    static /* synthetic */ Class access$500() {
        return OBJECT_CLASS;
    }

    private static final class MethodSignature {
        private static final MethodSignature GET_STRING_SIGNATURE = new MethodSignature("get", new Class[]{BeansWrapper.access$400()});
        private static final MethodSignature GET_OBJECT_SIGNATURE = new MethodSignature("get", new Class[]{BeansWrapper.access$500()});
        private final String name;
        private final Class<?>[] args;

        private MethodSignature(String name, Class<?>[] args) {
            this.name = name;
            this.args = args;
        }

        MethodSignature(Method method) {
            this(method.getName(), method.getParameterTypes());
        }

        public boolean equals(Object o) {
            if (o instanceof MethodSignature) {
                MethodSignature ms = (MethodSignature)o;
                return ms.name.equals(this.name) && Arrays.equals(this.args, ms.args);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.args.length;
        }
    }
}

