/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.parser;

import freemarker.core.ast.AddConcatExpression;
import freemarker.core.ast.AndExpression;
import freemarker.core.ast.ArgsList;
import freemarker.core.ast.ArithmeticExpression;
import freemarker.core.ast.AssignmentInstruction;
import freemarker.core.ast.AttemptBlock;
import freemarker.core.ast.BlockAssignment;
import freemarker.core.ast.BodyInstruction;
import freemarker.core.ast.BooleanLiteral;
import freemarker.core.ast.BreakInstruction;
import freemarker.core.ast.BuiltInExpression;
import freemarker.core.ast.BuiltinVariable;
import freemarker.core.ast.Case;
import freemarker.core.ast.Comment;
import freemarker.core.ast.ComparisonExpression;
import freemarker.core.ast.CompressedBlock;
import freemarker.core.ast.ConditionalBlock;
import freemarker.core.ast.DefaultToExpression;
import freemarker.core.ast.Dot;
import freemarker.core.ast.DynamicKeyName;
import freemarker.core.ast.EmptyArgsList;
import freemarker.core.ast.EscapeBlock;
import freemarker.core.ast.ExistsExpression;
import freemarker.core.ast.Expression;
import freemarker.core.ast.FallbackInstruction;
import freemarker.core.ast.FlushInstruction;
import freemarker.core.ast.HashLiteral;
import freemarker.core.ast.Identifier;
import freemarker.core.ast.IfBlock;
import freemarker.core.ast.Include;
import freemarker.core.ast.Interpolation;
import freemarker.core.ast.InvalidExpression;
import freemarker.core.ast.IteratorBlock;
import freemarker.core.ast.LibraryLoad;
import freemarker.core.ast.ListLiteral;
import freemarker.core.ast.Macro;
import freemarker.core.ast.MethodCall;
import freemarker.core.ast.MixedContent;
import freemarker.core.ast.NamedArgsList;
import freemarker.core.ast.NoEscapeBlock;
import freemarker.core.ast.NoParseBlock;
import freemarker.core.ast.NotExpression;
import freemarker.core.ast.NullLiteral;
import freemarker.core.ast.NumberLiteral;
import freemarker.core.ast.NumericalOutput;
import freemarker.core.ast.OrExpression;
import freemarker.core.ast.Param;
import freemarker.core.ast.ParameterList;
import freemarker.core.ast.ParentheticalExpression;
import freemarker.core.ast.PositionalArgsList;
import freemarker.core.ast.PropertySetting;
import freemarker.core.ast.Range;
import freemarker.core.ast.RecoveryBlock;
import freemarker.core.ast.RecurseNode;
import freemarker.core.ast.ReturnInstruction;
import freemarker.core.ast.StopInstruction;
import freemarker.core.ast.StringLiteral;
import freemarker.core.ast.SwitchBlock;
import freemarker.core.ast.TemplateElement;
import freemarker.core.ast.TemplateHeaderElement;
import freemarker.core.ast.TextBlock;
import freemarker.core.ast.TransformBlock;
import freemarker.core.ast.TrimBlock;
import freemarker.core.ast.TrimInstruction;
import freemarker.core.ast.UnaryPlusMinusExpression;
import freemarker.core.ast.UnifiedCall;
import freemarker.core.ast.VarDirective;
import freemarker.core.ast.VisitNode;
import freemarker.core.parser.FMLexer;
import freemarker.core.parser.NonTerminalCall;
import freemarker.core.parser.ParseException;
import freemarker.core.parser.ParsingProblem;
import freemarker.core.parser.TemplateLocation;
import freemarker.core.parser.Token;
import freemarker.core.parser.TokenSource;
import freemarker.template.Template;
import freemarker.template.utility.StringUtil;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.CancellationException;

public class FMParser {
    Template template;
    private String templateName;
    private boolean stripText;
    private int contentNesting;
    private int trimBlockNesting;
    static final int UNLIMITED = Integer.MAX_VALUE;
    Token lastConsumedToken;
    private Token.TokenType nextTokenType;
    private Token currentLookaheadToken;
    private int remainingLookahead;
    private boolean hitFailure;
    private boolean passedPredicate;
    private String currentlyParsedProduction;
    private String currentLookaheadProduction;
    private int lookaheadRoutineNesting;
    private int passedPredicateThreshold = -1;
    EnumSet<Token.TokenType> outerFollowSet;
    private boolean legacyGlitchyLookahead = false;
    private final Token DUMMY_START_TOKEN = new Token();
    private boolean cancelled;
    public FMLexer token_source;
    private static HashMap<Token.TokenType[], EnumSet<Token.TokenType>> enumSetCache = new HashMap();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$157$7 = FMParser.first_set$FM_ccc$157$7_init();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$176$7 = FMParser.tokenTypeSet(Token.TokenType.DOT, Token.TokenType.BUILT_IN, Token.TokenType.EXISTS, Token.TokenType.EXCLAM, Token.TokenType.OPEN_BRACKET, Token.TokenType.OPEN_PAREN);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$207$4 = FMParser.first_set$FM_ccc$207$4_init();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$211$4 = FMParser.first_set$FM_ccc$211$4_init();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$246$7 = FMParser.tokenTypeSet(Token.TokenType.PLUS, Token.TokenType.MINUS);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$266$10 = FMParser.tokenTypeSet(Token.TokenType.PLUS, Token.TokenType.MINUS);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$302$10 = FMParser.tokenTypeSet(Token.TokenType.TIMES, Token.TokenType.DIVIDE, Token.TokenType.PERCENT);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$329$7 = FMParser.tokenTypeSet(Token.TokenType.EQUALS, Token.TokenType.DOUBLE_EQUALS, Token.TokenType.NOT_EQUALS);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$353$6 = FMParser.tokenTypeSet(Token.TokenType.GREATER_THAN, Token.TokenType.GREATER_THAN_EQUALS, Token.TokenType.LESS_THAN, Token.TokenType.LESS_THAN_EQUALS, Token.TokenType.ESCAPED_GT, Token.TokenType.ESCAPED_GTE);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$354$7 = FMParser.tokenTypeSet(Token.TokenType.GREATER_THAN, Token.TokenType.GREATER_THAN_EQUALS, Token.TokenType.LESS_THAN, Token.TokenType.LESS_THAN_EQUALS, Token.TokenType.ESCAPED_GT, Token.TokenType.ESCAPED_GTE);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$446$7 = FMParser.first_set$FM_ccc$446$7_init();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$448$10 = FMParser.first_set$FM_ccc$448$10_init();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$466$7 = FMParser.tokenTypeSet(Token.TokenType.INTEGER, Token.TokenType.DECIMAL);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$496$7 = FMParser.tokenTypeSet(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.ID);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$534$8 = FMParser.tokenTypeSet(Token.TokenType.DOT, Token.TokenType.BUILT_IN, Token.TokenType.EXISTS, Token.TokenType.EXCLAM, Token.TokenType.OPEN_BRACKET, Token.TokenType.OPEN_PAREN);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$647$7 = FMParser.first_set$FM_ccc$647$7_init();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$663$6 = FMParser.tokenTypeSet(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$693$8 = FMParser.tokenTypeSet(Token.TokenType.FALSE, Token.TokenType.TRUE);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$723$8 = FMParser.first_set$FM_ccc$723$8_init();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$724$9 = FMParser.tokenTypeSet(Token.TokenType.COMMA, Token.TokenType.COLON);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$733$13 = FMParser.tokenTypeSet(Token.TokenType.COMMA, Token.TokenType.COLON);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$948$7 = FMParser.tokenTypeSet(Token.TokenType.SIMPLE_RECURSE, Token.TokenType.RECURSE);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$953$13 = FMParser.first_set$FM_ccc$953$13_init();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1007$7 = FMParser.tokenTypeSet(Token.TokenType.RETURN, Token.TokenType.SIMPLE_RETURN);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1026$7 = FMParser.tokenTypeSet(Token.TokenType.STOP, Token.TokenType.HALT);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1044$7 = FMParser.tokenTypeSet(Token.TokenType.SIMPLE_NESTED, Token.TokenType.NESTED);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1085$6 = FMParser.tokenTypeSet(Token.TokenType.TRIM, Token.TokenType.LTRIM, Token.TokenType.RTRIM, Token.TokenType.NOTRIM);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1112$7 = FMParser.tokenTypeSet(Token.TokenType.ASSIGN, Token.TokenType.GLOBALASSIGN, Token.TokenType.LOCALASSIGN, Token.TokenType.SET);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1125$6 = FMParser.tokenTypeSet(Token.TokenType.EQUALS, Token.TokenType.IN, Token.TokenType.DIRECTIVE_END);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1189$9 = FMParser.tokenTypeSet(Token.TokenType._INCLUDE, Token.TokenType.EMBED);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1338$7 = FMParser.tokenTypeSet(Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.DIRECTIVE_END);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1361$9 = FMParser.tokenTypeSet(Token.TokenType.FUNCTION, Token.TokenType.MACRO);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1406$5 = FMParser.first_set$FM_ccc$1406$5_init();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1447$5 = FMParser.first_set$FM_ccc$1447$5_init();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1450$8 = FMParser.first_set$FM_ccc$1450$8_init();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1480$6 = FMParser.first_set$FM_ccc$1480$6_init();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1496$7 = FMParser.tokenTypeSet(Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.DIRECTIVE_END);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1657$8 = FMParser.tokenTypeSet(Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.DIRECTIVE_END);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1715$7 = FMParser.tokenTypeSet(Token.TokenType.CASE, Token.TokenType.DEFAUL);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1736$5 = FMParser.tokenTypeSet(Token.TokenType.BLOCKTRIM, Token.TokenType.BLOCKTRIML, Token.TokenType.BLOCKTRIMR, Token.TokenType.BLOCKNOTRIM);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1829$7 = FMParser.tokenTypeSet(Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.DIRECTIVE_END);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1902$6 = FMParser.first_set$FM_ccc$1902$6_init();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$1982$10 = FMParser.tokenTypeSet(Token.TokenType.WHITESPACE, Token.TokenType.PRINTABLE_CHARS);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$2023$7 = FMParser.first_set$FM_ccc$2023$7_init();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$2024$10 = FMParser.first_set$FM_ccc$2024$10_init();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$2030$10 = FMParser.first_set$FM_ccc$2030$10_init();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$2064$9 = FMParser.tokenTypeSet(Token.TokenType.WHITESPACE, Token.TokenType.PRINTABLE_CHARS, Token.TokenType.OUTPUT_ESCAPE, Token.TokenType.NUMERICAL_ESCAPE);
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$2099$10 = FMParser.first_set$FM_ccc$2099$10_init();
    private static final EnumSet<Token.TokenType> first_set$FM_ccc$2115$6 = FMParser.tokenTypeSet(Token.TokenType.FTL_HEADER, Token.TokenType.TRIVIAL_FTL_HEADER);
    ArrayList<NonTerminalCall> parsingStack = new ArrayList();
    private ArrayList<NonTerminalCall> lookaheadStack = new ArrayList();

    public static FMParser createExpressionParser(String s) {
        FMLexer lexer;
        try {
            lexer = new FMLexer(s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        lexer.switchTo(FMLexer.LexicalState.EXPRESSION);
        return new FMParser(lexer);
    }

    public FMParser(Template template, Path path) throws IOException {
        this(path);
        this.template = template;
        this.token_source.templateName = this.templateName = template != null ? template.getName() : "";
    }

    public FMParser(Template template, Path path, int syntaxSetting) throws IOException {
        this(template, path);
        if (syntaxSetting != 0) {
            this.token_source.setAltDirectiveSyntax(syntaxSetting == 2);
        }
    }

    public FMParser(Template template, String input, int syntaxSetting) {
        this(input);
        this.template = template;
        String string = this.templateName = template != null ? template.getName() : "";
        if (syntaxSetting != 0) {
            this.token_source.setAltDirectiveSyntax(syntaxSetting == 2);
        }
    }

    public void setTemplate(Template t) {
        this.template = t;
    }

    private String getErrorStart(Token t) {
        return "Error in template: " + this.template.getName() + "\non line " + t.getBeginLine() + ", column " + t.getBeginColumn();
    }

    public boolean isSyntaxSet() {
        return this.token_source.directiveSyntaxEstablished;
    }

    public boolean isAltDirectiveSyntax() {
        return this.token_source.altDirectiveSyntax;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setInputSource(String inputSource) {
        this.token_source.setInputSource(inputSource);
    }

    String getInputSource() {
        return this.token_source.getInputSource();
    }

    public FMParser(String inputSource, CharSequence content) {
        this(new FMLexer(inputSource, content));
    }

    public FMParser(CharSequence content) {
        this("input", content);
    }

    public FMParser(String inputSource, Path path) throws IOException {
        this(inputSource, TokenSource.stringFromBytes(Files.readAllBytes(path)));
    }

    public FMParser(String inputSource, Path path, Charset charset) throws IOException {
        this(inputSource, TokenSource.stringFromBytes(Files.readAllBytes(path), charset));
    }

    public FMParser(Path path) throws IOException {
        this(path.toString(), path);
    }

    public FMParser(FMLexer lexer) {
        this.token_source = lexer;
        this.lastConsumedToken = this.DUMMY_START_TOKEN;
        this.lastConsumedToken.setTokenSource(lexer);
    }

    private final Token nextToken(Token tok) {
        Token result = this.token_source.getNextToken(tok);
        while (result.isUnparsed()) {
            result = this.token_source.getNextToken(result);
        }
        this.nextTokenType = null;
        return result;
    }

    public final Token getNextToken() {
        return this.getToken(1);
    }

    public final Token getToken(int index) {
        int i;
        Token t = this.currentLookaheadToken == null ? this.lastConsumedToken : this.currentLookaheadToken;
        for (i = 0; i < index; ++i) {
            t = this.nextToken(t);
        }
        for (i = 0; i > index && (t = t.getPrevious()) != null; --i) {
        }
        return t;
    }

    private final Token.TokenType nextTokenType() {
        if (this.nextTokenType == null) {
            this.nextTokenType = this.nextToken(this.lastConsumedToken).getType();
        }
        return this.nextTokenType;
    }

    boolean activateTokenTypes(Token.TokenType ... types) {
        boolean result = false;
        for (Token.TokenType tt : types) {
            result |= this.token_source.activeTokenTypes.add(tt);
        }
        if (result) {
            this.token_source.reset(this.getToken(0));
            this.nextTokenType = null;
        }
        return result;
    }

    boolean deactivateTokenTypes(Token.TokenType ... types) {
        boolean result = false;
        for (Token.TokenType tt : types) {
            result |= this.token_source.activeTokenTypes.remove((Object)tt);
        }
        if (result) {
            this.token_source.reset(this.getToken(0));
            this.nextTokenType = null;
        }
        return result;
    }

    private static EnumSet<Token.TokenType> tokenTypeSet(Token.TokenType first, Token.TokenType ... rest) {
        Token.TokenType[] key = new Token.TokenType[1 + rest.length];
        key[0] = first;
        if (rest.length > 0) {
            System.arraycopy(rest, 0, key, 1, rest.length);
        }
        Arrays.sort((Object[])key);
        if (enumSetCache.containsKey(key)) {
            return enumSetCache.get(key);
        }
        EnumSet<Token.TokenType> result = rest.length == 0 ? EnumSet.of(first) : EnumSet.of(first, rest);
        enumSetCache.put(key, result);
        return result;
    }

    public final Expression Expression() {
        Expression exp;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Expression";
        this.pushOntoCallStack("Expression", "src/parser/FM.ccc", 144, 3);
        try {
            exp = this.OrExpression();
        }
        finally {
            this.popCallStack();
        }
        return exp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression PrimaryExpression() {
        Expression exp;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "PrimaryExpression";
        if (this.nextTokenType() == Token.TokenType.INTEGER || this.nextTokenType == Token.TokenType.DECIMAL) {
            this.pushOntoCallStack("PrimaryExpression", "src/parser/FM.ccc", 157, 7);
            try {
                exp = this.NumberLiteral();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.OPEN_BRACE) {
            this.pushOntoCallStack("PrimaryExpression", "src/parser/FM.ccc", 159, 7);
            try {
                exp = this.HashLiteral();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.STRING_LITERAL || this.nextTokenType == Token.TokenType.RAW_STRING) {
            this.pushOntoCallStack("PrimaryExpression", "src/parser/FM.ccc", 161, 7);
            try {
                exp = this.StringLiteral();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.FALSE || this.nextTokenType == Token.TokenType.TRUE) {
            this.pushOntoCallStack("PrimaryExpression", "src/parser/FM.ccc", 163, 7);
            try {
                exp = this.BooleanLiteral();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.NULL) {
            this.pushOntoCallStack("PrimaryExpression", "src/parser/FM.ccc", 165, 7);
            try {
                exp = this.NullLiteral();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.OPEN_BRACKET) {
            this.pushOntoCallStack("PrimaryExpression", "src/parser/FM.ccc", 167, 7);
            try {
                exp = this.ListLiteral();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.ID) {
            this.pushOntoCallStack("PrimaryExpression", "src/parser/FM.ccc", 169, 7);
            try {
                exp = this.Identifier();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.OPEN_PAREN) {
            this.pushOntoCallStack("PrimaryExpression", "src/parser/FM.ccc", 171, 7);
            try {
                exp = this.Parenthesis();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.DOT) {
            this.pushOntoCallStack("PrimaryExpression", "src/parser/FM.ccc", 173, 7);
            try {
                exp = this.BuiltinVariable();
            }
            finally {
                this.popCallStack();
            }
        } else {
            this.pushOntoCallStack("PrimaryExpression", "src/parser/FM.ccc", 157, 7);
            throw new ParseException(this, first_set$FM_ccc$157$7, this.parsingStack);
        }
        while (first_set$FM_ccc$176$7.contains((Object)this.nextTokenType())) {
            this.pushOntoCallStack("PrimaryExpression", "src/parser/FM.ccc", 176, 7);
            try {
                exp = this.AddSubExpression(exp);
            }
            finally {
                this.popCallStack();
            }
        }
        return exp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression Parenthesis() {
        Expression exp;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Parenthesis";
        Token start = this.consumeToken(Token.TokenType.OPEN_PAREN);
        this.pushOntoCallStack("Parenthesis", "src/parser/FM.ccc", 189, 5);
        try {
            exp = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        Token end = this.consumeToken(Token.TokenType.CLOSE_PAREN);
        ParentheticalExpression result = new ParentheticalExpression(exp);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression UnaryExpression() {
        Expression result;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "UnaryExpression";
        if (this.nextTokenType() == Token.TokenType.PLUS || this.nextTokenType == Token.TokenType.MINUS) {
            this.pushOntoCallStack("UnaryExpression", "src/parser/FM.ccc", 207, 4);
            try {
                result = this.UnaryPlusMinusExpression();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.EXCLAM) {
            this.pushOntoCallStack("UnaryExpression", "src/parser/FM.ccc", 209, 4);
            try {
                result = this.NotExpression();
            }
            finally {
                this.popCallStack();
            }
        } else if (first_set$FM_ccc$211$4.contains((Object)this.nextTokenType())) {
            this.pushOntoCallStack("UnaryExpression", "src/parser/FM.ccc", 211, 4);
            try {
                result = this.PrimaryExpression();
            }
            finally {
                this.popCallStack();
            }
        } else {
            this.pushOntoCallStack("UnaryExpression", "src/parser/FM.ccc", 207, 4);
            throw new ParseException(this, first_set$FM_ccc$207$4, this.parsingStack);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression NotExpression() {
        Expression exp;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "NotExpression";
        NotExpression result = null;
        ArrayList<Token> nots = new ArrayList<Token>();
        do {
            Token t = this.consumeToken(Token.TokenType.EXCLAM);
            nots.add(t);
        } while (this.nextTokenType() == Token.TokenType.EXCLAM);
        this.pushOntoCallStack("NotExpression", "src/parser/FM.ccc", 227, 4);
        try {
            exp = this.PrimaryExpression();
        }
        finally {
            this.popCallStack();
        }
        for (int i = 0; i < nots.size(); ++i) {
            result = new NotExpression(exp);
            Token tok = (Token)nots.get(nots.size() - i - 1);
            result.setLocation(this.template, tok, (TemplateLocation)exp);
            exp = result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression UnaryPlusMinusExpression() {
        Expression exp;
        Token t;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "UnaryPlusMinusExpression";
        boolean isMinus = false;
        if (this.nextTokenType() == Token.TokenType.PLUS) {
            t = this.consumeToken(Token.TokenType.PLUS);
        } else if (this.nextTokenType() == Token.TokenType.MINUS) {
            t = this.consumeToken(Token.TokenType.MINUS);
            isMinus = true;
        } else {
            this.pushOntoCallStack("UnaryPlusMinusExpression", "src/parser/FM.ccc", 246, 7);
            throw new ParseException(this, first_set$FM_ccc$246$7, this.parsingStack);
        }
        this.pushOntoCallStack("UnaryPlusMinusExpression", "src/parser/FM.ccc", 250, 4);
        try {
            exp = this.PrimaryExpression();
        }
        finally {
            this.popCallStack();
        }
        UnaryPlusMinusExpression result = new UnaryPlusMinusExpression(exp, isMinus);
        result.setLocation(this.template, t, (TemplateLocation)exp);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression AdditiveExpression() {
        Expression lhs;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "AdditiveExpression";
        this.pushOntoCallStack("AdditiveExpression", "src/parser/FM.ccc", 263, 4);
        try {
            lhs = this.MultiplicativeExpression();
        }
        finally {
            this.popCallStack();
        }
        Expression result = lhs;
        while (this.nextTokenType() == Token.TokenType.PLUS || this.nextTokenType == Token.TokenType.MINUS) {
            Expression rhs;
            boolean plus;
            if (this.nextTokenType() == Token.TokenType.PLUS) {
                this.consumeToken(Token.TokenType.PLUS);
                plus = true;
            } else if (this.nextTokenType() == Token.TokenType.MINUS) {
                this.consumeToken(Token.TokenType.MINUS);
                plus = false;
            } else {
                this.pushOntoCallStack("AdditiveExpression", "src/parser/FM.ccc", 266, 10);
                throw new ParseException(this, first_set$FM_ccc$266$10, this.parsingStack);
            }
            this.pushOntoCallStack("AdditiveExpression", "src/parser/FM.ccc", 270, 7);
            try {
                rhs = this.MultiplicativeExpression();
            }
            finally {
                this.popCallStack();
            }
            result = plus ? new AddConcatExpression(lhs, rhs) : new ArithmeticExpression(lhs, rhs, 0);
            result.setLocation(this.template, (TemplateLocation)lhs, (TemplateLocation)rhs);
            lhs = result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression MultiplicativeExpression() {
        Expression lhs;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "MultiplicativeExpression";
        int operation = 1;
        this.pushOntoCallStack("MultiplicativeExpression", "src/parser/FM.ccc", 299, 4);
        try {
            lhs = this.UnaryExpression();
        }
        finally {
            this.popCallStack();
        }
        Expression result = lhs;
        while (this.nextTokenType() == Token.TokenType.TIMES || this.nextTokenType == Token.TokenType.DIVIDE || this.nextTokenType == Token.TokenType.PERCENT) {
            Expression rhs;
            if (this.nextTokenType() == Token.TokenType.TIMES) {
                this.consumeToken(Token.TokenType.TIMES);
                operation = 1;
            } else if (this.nextTokenType() == Token.TokenType.DIVIDE) {
                this.consumeToken(Token.TokenType.DIVIDE);
                operation = 2;
            } else if (this.nextTokenType() == Token.TokenType.PERCENT) {
                this.consumeToken(Token.TokenType.PERCENT);
                operation = 3;
            } else {
                this.pushOntoCallStack("MultiplicativeExpression", "src/parser/FM.ccc", 302, 10);
                throw new ParseException(this, first_set$FM_ccc$302$10, this.parsingStack);
            }
            this.pushOntoCallStack("MultiplicativeExpression", "src/parser/FM.ccc", 308, 7);
            try {
                rhs = this.UnaryExpression();
            }
            finally {
                this.popCallStack();
            }
            result = new ArithmeticExpression(lhs, rhs, operation);
            result.setLocation(this.template, (TemplateLocation)lhs, (TemplateLocation)rhs);
            lhs = result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression EqualityExpression() {
        Expression lhs;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "EqualityExpression";
        this.pushOntoCallStack("EqualityExpression", "src/parser/FM.ccc", 326, 4);
        try {
            lhs = this.RelationalExpression();
        }
        finally {
            this.popCallStack();
        }
        Expression result = lhs;
        if (this.nextTokenType() == Token.TokenType.EQUALS || this.nextTokenType == Token.TokenType.DOUBLE_EQUALS || this.nextTokenType == Token.TokenType.NOT_EQUALS) {
            Expression rhs;
            Token t;
            if (this.nextTokenType() == Token.TokenType.NOT_EQUALS) {
                t = this.consumeToken(Token.TokenType.NOT_EQUALS);
            } else if (this.nextTokenType() == Token.TokenType.EQUALS) {
                t = this.consumeToken(Token.TokenType.EQUALS);
            } else if (this.nextTokenType() == Token.TokenType.DOUBLE_EQUALS) {
                t = this.consumeToken(Token.TokenType.DOUBLE_EQUALS);
            } else {
                this.pushOntoCallStack("EqualityExpression", "src/parser/FM.ccc", 329, 7);
                throw new ParseException(this, first_set$FM_ccc$329$7, this.parsingStack);
            }
            this.pushOntoCallStack("EqualityExpression", "src/parser/FM.ccc", 335, 6);
            try {
                rhs = this.RelationalExpression();
            }
            finally {
                this.popCallStack();
            }
            result = new ComparisonExpression(lhs, rhs, t.getImage());
            result.setLocation(this.template, (TemplateLocation)lhs, (TemplateLocation)rhs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression RelationalExpression() {
        Expression lhs;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "RelationalExpression";
        this.pushOntoCallStack("RelationalExpression", "src/parser/FM.ccc", 351, 4);
        try {
            lhs = this.RangeExpression();
        }
        finally {
            this.popCallStack();
        }
        Expression result = lhs;
        if (first_set$FM_ccc$353$6.contains((Object)this.nextTokenType())) {
            Expression rhs;
            Token t;
            if (this.nextTokenType() == Token.TokenType.GREATER_THAN_EQUALS) {
                t = this.consumeToken(Token.TokenType.GREATER_THAN_EQUALS);
            } else if (this.nextTokenType() == Token.TokenType.ESCAPED_GTE) {
                t = this.consumeToken(Token.TokenType.ESCAPED_GTE);
            } else if (this.nextTokenType() == Token.TokenType.GREATER_THAN) {
                t = this.consumeToken(Token.TokenType.GREATER_THAN);
            } else if (this.nextTokenType() == Token.TokenType.ESCAPED_GT) {
                t = this.consumeToken(Token.TokenType.ESCAPED_GT);
            } else if (this.nextTokenType() == Token.TokenType.LESS_THAN_EQUALS) {
                t = this.consumeToken(Token.TokenType.LESS_THAN_EQUALS);
            } else if (this.nextTokenType() == Token.TokenType.LESS_THAN) {
                t = this.consumeToken(Token.TokenType.LESS_THAN);
            } else {
                this.pushOntoCallStack("RelationalExpression", "src/parser/FM.ccc", 354, 7);
                throw new ParseException(this, first_set$FM_ccc$354$7, this.parsingStack);
            }
            this.pushOntoCallStack("RelationalExpression", "src/parser/FM.ccc", 366, 6);
            try {
                rhs = this.RangeExpression();
            }
            finally {
                this.popCallStack();
            }
            result = new ComparisonExpression(lhs, rhs, t.getImage());
            result.setLocation(this.template, (TemplateLocation)lhs, (TemplateLocation)rhs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression RangeExpression() {
        Expression lhs;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "RangeExpression";
        Expression rhs = null;
        this.pushOntoCallStack("RangeExpression", "src/parser/FM.ccc", 381, 5);
        try {
            lhs = this.AdditiveExpression();
        }
        finally {
            this.popCallStack();
        }
        Expression result = lhs;
        if (this.nextTokenType() == Token.TokenType.DOT_DOT) {
            this.consumeToken(Token.TokenType.DOT_DOT);
            if (this.scan$FM_ccc$384$10()) {
                this.pushOntoCallStack("RangeExpression", "src/parser/FM.ccc", 384, 10);
                try {
                    rhs = this.AdditiveExpression();
                }
                finally {
                    this.popCallStack();
                }
            }
            Range range = new Range(lhs, rhs);
            if (rhs != null) {
                range.setLocation(this.template, (TemplateLocation)lhs, (TemplateLocation)rhs);
            } else {
                range.setLocation(this.template, (TemplateLocation)lhs, (TemplateLocation)lhs);
            }
            result = range;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression AndExpression() {
        Expression lhs;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "AndExpression";
        this.pushOntoCallStack("AndExpression", "src/parser/FM.ccc", 405, 4);
        try {
            lhs = this.EqualityExpression();
        }
        finally {
            this.popCallStack();
        }
        Expression result = lhs;
        while (this.nextTokenType() == Token.TokenType.AND) {
            Expression rhs;
            this.consumeToken(Token.TokenType.AND);
            this.pushOntoCallStack("AndExpression", "src/parser/FM.ccc", 408, 7);
            try {
                rhs = this.EqualityExpression();
            }
            finally {
                this.popCallStack();
            }
            result = new AndExpression(lhs, rhs);
            result.setLocation(this.template, (TemplateLocation)lhs, (TemplateLocation)rhs);
            lhs = result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression OrExpression() {
        Expression lhs;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "OrExpression";
        this.pushOntoCallStack("OrExpression", "src/parser/FM.ccc", 424, 4);
        try {
            lhs = this.AndExpression();
        }
        finally {
            this.popCallStack();
        }
        Expression result = lhs;
        while (this.nextTokenType() == Token.TokenType.OR) {
            Expression rhs;
            this.consumeToken(Token.TokenType.OR);
            this.pushOntoCallStack("OrExpression", "src/parser/FM.ccc", 427, 7);
            try {
                rhs = this.AndExpression();
            }
            finally {
                this.popCallStack();
            }
            result = new OrExpression(lhs, rhs);
            result.setLocation(this.template, (TemplateLocation)lhs, (TemplateLocation)rhs);
            lhs = result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ListLiteral ListLiteral() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "ListLiteral";
        ArrayList<Expression> values = new ArrayList<Expression>();
        Token begin = this.consumeToken(Token.TokenType.OPEN_BRACKET);
        if (first_set$FM_ccc$446$7.contains((Object)this.nextTokenType())) {
            Expression exp;
            this.pushOntoCallStack("ListLiteral", "src/parser/FM.ccc", 446, 7);
            try {
                exp = this.Expression();
            }
            finally {
                this.popCallStack();
            }
            values.add(exp);
            while (first_set$FM_ccc$448$10.contains((Object)this.nextTokenType())) {
                if (this.nextTokenType() == Token.TokenType.COMMA) {
                    this.consumeToken(Token.TokenType.COMMA);
                }
                this.pushOntoCallStack("ListLiteral", "src/parser/FM.ccc", 449, 10);
                try {
                    exp = this.Expression();
                }
                finally {
                    this.popCallStack();
                }
                values.add(exp);
            }
        }
        Token end = this.consumeToken(Token.TokenType.CLOSE_BRACKET);
        ListLiteral result = new ListLiteral(values);
        result.setLocation(this.template, begin, end);
        return result;
    }

    public final Expression NumberLiteral() {
        Token t;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "NumberLiteral";
        Token op = null;
        if (this.nextTokenType() == Token.TokenType.INTEGER) {
            t = this.consumeToken(Token.TokenType.INTEGER);
        } else if (this.nextTokenType() == Token.TokenType.DECIMAL) {
            t = this.consumeToken(Token.TokenType.DECIMAL);
        } else {
            this.pushOntoCallStack("NumberLiteral", "src/parser/FM.ccc", 466, 7);
            throw new ParseException(this, first_set$FM_ccc$466$7, this.parsingStack);
        }
        String s = t.getImage();
        Number n = this.template != null ? this.template.getArithmeticEngine().toNumber(s) : new BigDecimal(s);
        NumberLiteral result = new NumberLiteral(n);
        Token startToken = op != null ? op : t;
        result.setLocation(this.template, startToken, t);
        return result;
    }

    public final Identifier Identifier() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Identifier";
        Token t = this.consumeToken(Token.TokenType.ID);
        Identifier id = new Identifier(t.getImage());
        id.setLocation(this.template, t, t);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression IdentifierOrStringLiteral() {
        Expression exp;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "IdentifierOrStringLiteral";
        if (this.nextTokenType() == Token.TokenType.ID) {
            this.pushOntoCallStack("IdentifierOrStringLiteral", "src/parser/FM.ccc", 496, 7);
            try {
                exp = this.Identifier();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.STRING_LITERAL || this.nextTokenType == Token.TokenType.RAW_STRING) {
            this.pushOntoCallStack("IdentifierOrStringLiteral", "src/parser/FM.ccc", 498, 7);
            try {
                exp = this.StringLiteral();
            }
            finally {
                this.popCallStack();
            }
        } else {
            this.pushOntoCallStack("IdentifierOrStringLiteral", "src/parser/FM.ccc", 496, 7);
            throw new ParseException(this, first_set$FM_ccc$496$7, this.parsingStack);
        }
        return exp;
    }

    public final BuiltinVariable BuiltinVariable() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "BuiltinVariable";
        Token dot = this.consumeToken(Token.TokenType.DOT);
        Token name = this.consumeToken(Token.TokenType.ID);
        BuiltinVariable result = null;
        try {
            result = new BuiltinVariable(name.getImage());
        }
        catch (ParseException pe) {
            pe.lineNumber = dot.getBeginLine();
            pe.columnNumber = dot.getBeginColumn();
            throw pe;
        }
        result.setLocation(this.template, dot, name);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression AddSubExpression(Expression exp) {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "AddSubExpression";
        Expression result = null;
        if (this.nextTokenType() == Token.TokenType.DOT) {
            this.pushOntoCallStack("AddSubExpression", "src/parser/FM.ccc", 534, 8);
            try {
                result = this.DotVariable(exp);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.OPEN_BRACKET) {
            this.pushOntoCallStack("AddSubExpression", "src/parser/FM.ccc", 536, 8);
            try {
                result = this.DynamicKey(exp);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.OPEN_PAREN) {
            this.pushOntoCallStack("AddSubExpression", "src/parser/FM.ccc", 538, 8);
            try {
                result = this.MethodArgs(exp);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.BUILT_IN) {
            this.pushOntoCallStack("AddSubExpression", "src/parser/FM.ccc", 540, 8);
            try {
                result = this.BuiltIn(exp);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.EXISTS) {
            this.pushOntoCallStack("AddSubExpression", "src/parser/FM.ccc", 542, 8);
            try {
                result = this.Exists(exp);
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.EXCLAM) {
            this.pushOntoCallStack("AddSubExpression", "src/parser/FM.ccc", 544, 8);
            try {
                result = this.DefaultTo(exp);
            }
            finally {
                this.popCallStack();
            }
        } else {
            this.pushOntoCallStack("AddSubExpression", "src/parser/FM.ccc", 534, 8);
            throw new ParseException(this, first_set$FM_ccc$534$8, this.parsingStack);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression DefaultTo(Expression exp) {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "DefaultTo";
        Expression rhs = null;
        Token t = this.consumeToken(Token.TokenType.EXCLAM);
        if ((this.getToken(1).getType() != Token.TokenType.ID || this.getToken(2).getType() != Token.TokenType.EQUALS) && this.scan$FM_ccc$559$10()) {
            this.pushOntoCallStack("DefaultTo", "src/parser/FM.ccc", 560, 13);
            try {
                rhs = this.PrimaryExpression();
            }
            finally {
                this.popCallStack();
            }
        }
        DefaultToExpression result = new DefaultToExpression(exp, rhs);
        if (rhs == null) {
            result.setLocation(this.template, (TemplateLocation)exp, t);
        } else {
            result.setLocation(this.template, (TemplateLocation)exp, (TemplateLocation)rhs);
        }
        return result;
    }

    public final Expression Exists(Expression exp) {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Exists";
        Token t = this.consumeToken(Token.TokenType.EXISTS);
        ExistsExpression result = new ExistsExpression(exp);
        result.setLocation(this.template, (TemplateLocation)exp, t);
        return result;
    }

    public final Expression BuiltIn(Expression exp) {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "BuiltIn";
        Token t = null;
        this.consumeToken(Token.TokenType.BUILT_IN);
        t = this.consumeToken(Token.TokenType.ID);
        BuiltInExpression result = new BuiltInExpression(exp, t.getImage());
        if (result.getBuiltIn() == null) {
            throw new ParseException(this, "Unknown builtin " + t.getImage());
        }
        result.setLocation(this.template, (TemplateLocation)exp, t);
        return result;
    }

    public final Expression DotVariable(Expression exp) {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "DotVariable";
        this.consumeToken(Token.TokenType.DOT);
        this.token_source.justAfterDot = true;
        Token t = this.consumeToken(Token.TokenType.ID);
        this.token_source.justAfterDot = false;
        Dot dot = new Dot(exp, t.getImage());
        dot.setLocation(this.template, (TemplateLocation)exp, t);
        return dot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression DynamicKey(Expression exp) {
        Expression arg;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "DynamicKey";
        this.consumeToken(Token.TokenType.OPEN_BRACKET);
        this.pushOntoCallStack("DynamicKey", "src/parser/FM.ccc", 629, 4);
        try {
            arg = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        Token t = this.consumeToken(Token.TokenType.CLOSE_BRACKET);
        DynamicKeyName dkn = new DynamicKeyName(exp, arg);
        dkn.setLocation(this.template, (TemplateLocation)exp, t);
        return dkn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MethodCall MethodArgs(Expression exp) {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "MethodArgs";
        ArgsList args = new PositionalArgsList();
        this.consumeToken(Token.TokenType.OPEN_PAREN);
        if (first_set$FM_ccc$647$7.contains((Object)this.nextTokenType())) {
            this.pushOntoCallStack("MethodArgs", "src/parser/FM.ccc", 647, 7);
            try {
                args = this.ArgsList();
            }
            finally {
                this.popCallStack();
            }
        }
        Token end = this.consumeToken(Token.TokenType.CLOSE_PAREN);
        MethodCall result = new MethodCall(exp, args);
        result.setLocation(this.template, (TemplateLocation)exp, end);
        args.setLocationInfoIfAbsent(result);
        return result;
    }

    public final Expression StringLiteral() {
        Token t;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "StringLiteral";
        boolean raw = false;
        if (this.nextTokenType() == Token.TokenType.STRING_LITERAL) {
            t = this.consumeToken(Token.TokenType.STRING_LITERAL);
        } else if (this.nextTokenType() == Token.TokenType.RAW_STRING) {
            t = this.consumeToken(Token.TokenType.RAW_STRING);
            raw = true;
        } else {
            this.pushOntoCallStack("StringLiteral", "src/parser/FM.ccc", 663, 6);
            throw new ParseException(this, first_set$FM_ccc$663$6, this.parsingStack);
        }
        String s = t.getImage();
        s = s.substring(1, s.length() - 1);
        if (raw) {
            s = s.substring(1);
        } else {
            try {
                s = StringUtil.FTLStringLiteralDec(s);
            }
            catch (ParseException pe) {
                InvalidExpression invalid = new InvalidExpression("Malformed string literal: " + pe.getMessage());
                invalid.setLocation(this.template, t, t);
                return invalid;
            }
        }
        StringLiteral result = new StringLiteral(s, raw);
        result.setLocation(this.template, t, t);
        return result;
    }

    public final Expression BooleanLiteral() {
        BooleanLiteral result;
        Token t;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "BooleanLiteral";
        if (this.nextTokenType() == Token.TokenType.FALSE) {
            t = this.consumeToken(Token.TokenType.FALSE);
            result = new BooleanLiteral(false);
        } else if (this.nextTokenType() == Token.TokenType.TRUE) {
            t = this.consumeToken(Token.TokenType.TRUE);
            result = new BooleanLiteral(true);
        } else {
            this.pushOntoCallStack("BooleanLiteral", "src/parser/FM.ccc", 693, 8);
            throw new ParseException(this, first_set$FM_ccc$693$8, this.parsingStack);
        }
        result.setLocation(this.template, t, t);
        return result;
    }

    public final Expression NullLiteral() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "NullLiteral";
        Token t = this.consumeToken(Token.TokenType.NULL);
        NullLiteral result = new NullLiteral();
        result.setLocation(this.template, t, t);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HashLiteral HashLiteral() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "HashLiteral";
        ArrayList<Expression> keys = new ArrayList<Expression>();
        ArrayList<Expression> values = new ArrayList<Expression>();
        Token begin = this.consumeToken(Token.TokenType.OPEN_BRACE);
        if (first_set$FM_ccc$723$8.contains((Object)this.nextTokenType())) {
            Expression value;
            Expression key;
            this.pushOntoCallStack("HashLiteral", "src/parser/FM.ccc", 723, 8);
            try {
                key = this.Expression();
            }
            finally {
                this.popCallStack();
            }
            if (this.nextTokenType() == Token.TokenType.COMMA) {
                this.consumeToken(Token.TokenType.COMMA);
            } else if (this.nextTokenType() == Token.TokenType.COLON) {
                this.consumeToken(Token.TokenType.COLON);
            } else {
                this.pushOntoCallStack("HashLiteral", "src/parser/FM.ccc", 724, 9);
                throw new ParseException(this, first_set$FM_ccc$724$9, this.parsingStack);
            }
            this.pushOntoCallStack("HashLiteral", "src/parser/FM.ccc", 725, 8);
            try {
                value = this.Expression();
            }
            finally {
                this.popCallStack();
            }
            keys.add(key);
            values.add(value);
            while (this.nextTokenType() == Token.TokenType.COMMA) {
                this.consumeToken(Token.TokenType.COMMA);
                this.pushOntoCallStack("HashLiteral", "src/parser/FM.ccc", 732, 12);
                try {
                    key = this.Expression();
                }
                finally {
                    this.popCallStack();
                }
                if (this.nextTokenType() == Token.TokenType.COMMA) {
                    this.consumeToken(Token.TokenType.COMMA);
                } else if (this.nextTokenType() == Token.TokenType.COLON) {
                    this.consumeToken(Token.TokenType.COLON);
                } else {
                    this.pushOntoCallStack("HashLiteral", "src/parser/FM.ccc", 733, 13);
                    throw new ParseException(this, first_set$FM_ccc$733$13, this.parsingStack);
                }
                this.pushOntoCallStack("HashLiteral", "src/parser/FM.ccc", 734, 12);
                try {
                    value = this.Expression();
                }
                finally {
                    this.popCallStack();
                }
                keys.add(key);
                values.add(value);
            }
        }
        Token end = this.consumeToken(Token.TokenType.CLOSE_BRACE);
        HashLiteral result = new HashLiteral(keys, values);
        result.setLocation(this.template, begin, end);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TemplateElement StringOutput() {
        Expression exp;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "StringOutput";
        boolean unclosed = false;
        Token begin = this.consumeToken(Token.TokenType.OUTPUT_ESCAPE);
        this.pushOntoCallStack("StringOutput", "src/parser/FM.ccc", 760, 4);
        try {
            exp = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        Token end = this.consumeToken(Token.TokenType.CLOSE_BRACE);
        Interpolation result = new Interpolation(exp);
        result.setLocation(this.template, begin, end);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NumericalOutput NumericalOutput() {
        Expression exp;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "NumericalOutput";
        Token fmt = null;
        Token begin = this.consumeToken(Token.TokenType.NUMERICAL_ESCAPE);
        this.pushOntoCallStack("NumericalOutput", "src/parser/FM.ccc", 774, 4);
        try {
            exp = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        if (this.nextTokenType() == Token.TokenType.SEMICOLON) {
            this.consumeToken(Token.TokenType.SEMICOLON);
            fmt = this.consumeToken(Token.TokenType.ID);
        }
        Token end = this.consumeToken(Token.TokenType.CLOSE_BRACE);
        String formatString = fmt == null ? null : fmt.getImage();
        NumericalOutput result = new NumericalOutput(exp, formatString);
        result.setLocation(this.template, begin, end);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TemplateElement If() {
        Token end;
        Token t;
        TemplateElement block;
        Expression condition;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "If";
        Token start = this.consumeToken(Token.TokenType.IF);
        this.pushOntoCallStack("If", "src/parser/FM.ccc", 797, 4);
        try {
            condition = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        this.consumeToken(Token.TokenType.DIRECTIVE_END);
        this.pushOntoCallStack("If", "src/parser/FM.ccc", 799, 4);
        try {
            block = this.OptionalBlock();
        }
        finally {
            this.popCallStack();
        }
        ConditionalBlock cblock = new ConditionalBlock(condition, block, true);
        cblock.setLocation(this.template, start, (TemplateLocation)block);
        IfBlock ifBlock = new IfBlock(cblock);
        while (this.nextTokenType() == Token.TokenType.ELSE_IF) {
            t = this.consumeToken(Token.TokenType.ELSE_IF);
            this.pushOntoCallStack("If", "src/parser/FM.ccc", 807, 8);
            try {
                condition = this.Expression();
            }
            finally {
                this.popCallStack();
            }
            this.pushOntoCallStack("If", "src/parser/FM.ccc", 808, 8);
            try {
                this.LooseDirectiveEnd();
            }
            finally {
                this.popCallStack();
            }
            this.pushOntoCallStack("If", "src/parser/FM.ccc", 809, 8);
            try {
                block = this.OptionalBlock();
            }
            finally {
                this.popCallStack();
            }
            cblock = new ConditionalBlock(condition, block, false);
            cblock.setLocation(this.template, t, (TemplateLocation)block);
            ifBlock.addBlock(cblock);
        }
        if (this.nextTokenType() == Token.TokenType.ELSE) {
            t = this.consumeToken(Token.TokenType.ELSE);
            this.pushOntoCallStack("If", "src/parser/FM.ccc", 818, 10);
            try {
                block = this.OptionalBlock();
            }
            finally {
                this.popCallStack();
            }
            cblock = new ConditionalBlock(null, block, false);
            cblock.setLocation(this.template, t, (TemplateLocation)block);
            ifBlock.addBlock(cblock);
        }
        this.pushOntoCallStack("If", "src/parser/FM.ccc", 825, 4);
        try {
            end = this.CloseDirectiveBlock("if");
        }
        finally {
            this.popCallStack();
        }
        ifBlock.setLocation(this.template, start, end);
        return ifBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AttemptBlock Attempt() {
        Token end;
        RecoveryBlock recoveryBlock;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Attempt";
        TemplateElement block = null;
        ParseException problem = null;
        Token start = this.consumeToken(Token.TokenType._ATTEMPT);
        this.pushOntoCallStack("Attempt", "src/parser/FM.ccc", 839, 4);
        try {
            block = this.OptionalBlock();
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("Attempt", "src/parser/FM.ccc", 850, 4);
        try {
            recoveryBlock = this.Recover();
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("Attempt", "src/parser/FM.ccc", 851, 4);
        try {
            end = this.CloseDirectiveBlock("attempt, recover");
        }
        finally {
            this.popCallStack();
        }
        AttemptBlock result = new AttemptBlock(block, recoveryBlock);
        result.setLocation(this.template, start, end);
        if (problem != null) {
            ParsingProblem pp = new ParsingProblem(problem.getMessage(), result);
            result.addParsingProblem(pp);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RecoveryBlock Recover() {
        TemplateElement block;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Recover";
        Token start = this.consumeToken(Token.TokenType._RECOVER);
        this.pushOntoCallStack("Recover", "src/parser/FM.ccc", 869, 4);
        try {
            block = this.OptionalBlock();
        }
        finally {
            this.popCallStack();
        }
        RecoveryBlock result = new RecoveryBlock(block);
        result.setLocation(this.template, start, (TemplateLocation)block);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TemplateElement List() {
        Token end;
        TemplateElement block;
        Expression exp;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "List";
        Object as = null;
        Object directiveEnd = null;
        Token start = this.consumeToken(Token.TokenType.LIST);
        this.pushOntoCallStack("List", "src/parser/FM.ccc", 884, 4);
        try {
            exp = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        this.consumeToken(Token.TokenType.AS);
        Token index = this.consumeToken(Token.TokenType.ID);
        this.consumeToken(Token.TokenType.DIRECTIVE_END);
        this.pushOntoCallStack("List", "src/parser/FM.ccc", 888, 4);
        try {
            block = this.OptionalBlock();
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("List", "src/parser/FM.ccc", 889, 4);
        try {
            end = this.CloseDirectiveBlock("list");
        }
        finally {
            this.popCallStack();
        }
        IteratorBlock result = new IteratorBlock(exp, index.getImage(), block, false);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IteratorBlock ForEach() {
        Token end;
        TemplateElement block;
        Expression exp;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "ForEach";
        Token start = this.consumeToken(Token.TokenType.FOREACH);
        Token index = this.consumeToken(Token.TokenType.ID);
        this.consumeToken(Token.TokenType.IN);
        this.pushOntoCallStack("ForEach", "src/parser/FM.ccc", 909, 4);
        try {
            exp = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        this.consumeToken(Token.TokenType.DIRECTIVE_END);
        this.pushOntoCallStack("ForEach", "src/parser/FM.ccc", 911, 4);
        try {
            block = this.OptionalBlock();
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("ForEach", "src/parser/FM.ccc", 912, 4);
        try {
            end = this.CloseDirectiveBlock("foreach");
        }
        finally {
            this.popCallStack();
        }
        IteratorBlock result = new IteratorBlock(exp, index.getImage(), block, true);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final VisitNode Visit() {
        Token end;
        Expression targetNode;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Visit";
        Expression namespaces = null;
        Token start = this.consumeToken(Token.TokenType.VISIT);
        this.pushOntoCallStack("Visit", "src/parser/FM.ccc", 929, 4);
        try {
            targetNode = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        if (this.nextTokenType() == Token.TokenType.USING) {
            this.consumeToken(Token.TokenType.USING);
            this.pushOntoCallStack("Visit", "src/parser/FM.ccc", 932, 8);
            try {
                namespaces = this.Expression();
            }
            finally {
                this.popCallStack();
            }
        }
        this.pushOntoCallStack("Visit", "src/parser/FM.ccc", 934, 4);
        try {
            end = this.LooseDirectiveEnd();
        }
        finally {
            this.popCallStack();
        }
        VisitNode result = new VisitNode(targetNode, namespaces);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RecurseNode Recurse() {
        Token start;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Recurse";
        Token end = null;
        Expression node = null;
        Expression namespaces = null;
        if (this.nextTokenType() == Token.TokenType.SIMPLE_RECURSE) {
            start = this.consumeToken(Token.TokenType.SIMPLE_RECURSE);
        } else {
            if (this.nextTokenType() == Token.TokenType.RECURSE) {
                start = this.consumeToken(Token.TokenType.RECURSE);
                if (first_set$FM_ccc$953$13.contains((Object)this.nextTokenType())) {
                    this.pushOntoCallStack("Recurse", "src/parser/FM.ccc", 953, 13);
                    try {
                        node = this.Expression();
                    }
                    finally {
                        this.popCallStack();
                    }
                }
                if (this.nextTokenType() == Token.TokenType.USING) {
                    this.consumeToken(Token.TokenType.USING);
                    this.pushOntoCallStack("Recurse", "src/parser/FM.ccc", 957, 13);
                    try {
                        namespaces = this.Expression();
                    }
                    finally {
                        this.popCallStack();
                    }
                }
                this.pushOntoCallStack("Recurse", "src/parser/FM.ccc", 959, 10);
                try {
                    end = this.LooseDirectiveEnd();
                }
                finally {
                    this.popCallStack();
                }
            }
            this.pushOntoCallStack("Recurse", "src/parser/FM.ccc", 948, 7);
            throw new ParseException(this, first_set$FM_ccc$948$7, this.parsingStack);
        }
        if (end == null) {
            end = start;
        }
        RecurseNode result = new RecurseNode(node, namespaces);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final FallbackInstruction FallBack() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "FallBack";
        Token tok = this.consumeToken(Token.TokenType.FALLBACK);
        FallbackInstruction result = new FallbackInstruction();
        result.setLocation(this.template, tok, tok);
        return result;
    }

    public final BreakInstruction Break() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Break";
        Token start = this.consumeToken(Token.TokenType.BREAK);
        BreakInstruction result = new BreakInstruction();
        result.setLocation(this.template, start, start);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ReturnInstruction Return() {
        Token start;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Return";
        Token end = null;
        Expression exp = null;
        if (this.nextTokenType() == Token.TokenType.SIMPLE_RETURN) {
            end = start = this.consumeToken(Token.TokenType.SIMPLE_RETURN);
        } else {
            if (this.nextTokenType() == Token.TokenType.RETURN) {
                start = this.consumeToken(Token.TokenType.RETURN);
                this.pushOntoCallStack("Return", "src/parser/FM.ccc", 1010, 7);
                try {
                    exp = this.Expression();
                }
                finally {
                    this.popCallStack();
                }
                this.pushOntoCallStack("Return", "src/parser/FM.ccc", 1011, 7);
                try {
                    end = this.LooseDirectiveEnd();
                }
                finally {
                    this.popCallStack();
                }
            }
            this.pushOntoCallStack("Return", "src/parser/FM.ccc", 1007, 7);
            throw new ParseException(this, first_set$FM_ccc$1007$7, this.parsingStack);
        }
        ReturnInstruction result = new ReturnInstruction(exp);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final StopInstruction Stop() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Stop";
        Token start = null;
        Expression exp = null;
        if (this.nextTokenType() == Token.TokenType.HALT) {
            start = this.consumeToken(Token.TokenType.HALT);
        } else {
            if (this.nextTokenType() == Token.TokenType.STOP) {
                start = this.consumeToken(Token.TokenType.STOP);
                this.pushOntoCallStack("Stop", "src/parser/FM.ccc", 1028, 20);
                try {
                    exp = this.Expression();
                }
                finally {
                    this.popCallStack();
                }
                this.pushOntoCallStack("Stop", "src/parser/FM.ccc", 1028, 35);
                try {
                    this.LooseDirectiveEnd();
                }
                finally {
                    this.popCallStack();
                }
            }
            this.pushOntoCallStack("Stop", "src/parser/FM.ccc", 1026, 7);
            throw new ParseException(this, first_set$FM_ccc$1026$7, this.parsingStack);
        }
        StopInstruction result = new StopInstruction(exp);
        result.setLocation(this.template, start, start);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TemplateElement Nested() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Nested";
        PositionalArgsList args = null;
        BodyInstruction result = null;
        if (this.nextTokenType() == Token.TokenType.SIMPLE_NESTED) {
            Token t = this.consumeToken(Token.TokenType.SIMPLE_NESTED);
            result = new BodyInstruction(null);
            result.setLocation(this.template, t, t);
        } else if (this.nextTokenType() == Token.TokenType.NESTED) {
            Token end;
            Token t = this.consumeToken(Token.TokenType.NESTED);
            this.pushOntoCallStack("Nested", "src/parser/FM.ccc", 1054, 11);
            try {
                args = this.PositionalArgsList();
            }
            finally {
                this.popCallStack();
            }
            this.pushOntoCallStack("Nested", "src/parser/FM.ccc", 1055, 11);
            try {
                end = this.LooseDirectiveEnd();
            }
            finally {
                this.popCallStack();
            }
            result = new BodyInstruction(args);
            result.setLocation(this.template, t, end);
        } else {
            this.pushOntoCallStack("Nested", "src/parser/FM.ccc", 1044, 7);
            throw new ParseException(this, first_set$FM_ccc$1044$7, this.parsingStack);
        }
        return result;
    }

    public final TemplateElement Flush() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Flush";
        Token t = this.consumeToken(Token.TokenType.FLUSH);
        FlushInstruction result = new FlushInstruction();
        result.setLocation(this.template, t, t);
        return result;
    }

    public final TemplateElement Trim() {
        Token t;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Trim";
        TrimInstruction result = null;
        if (this.nextTokenType() == Token.TokenType.TRIM) {
            t = this.consumeToken(Token.TokenType.TRIM);
            result = new TrimInstruction(true, true);
        } else if (this.nextTokenType() == Token.TokenType.LTRIM) {
            t = this.consumeToken(Token.TokenType.LTRIM);
            result = new TrimInstruction(true, false);
        } else if (this.nextTokenType() == Token.TokenType.RTRIM) {
            t = this.consumeToken(Token.TokenType.RTRIM);
            result = new TrimInstruction(false, true);
        } else if (this.nextTokenType() == Token.TokenType.NOTRIM) {
            t = this.consumeToken(Token.TokenType.NOTRIM);
            result = new TrimInstruction(false, false);
        } else {
            this.pushOntoCallStack("Trim", "src/parser/FM.ccc", 1085, 6);
            throw new ParseException(this, first_set$FM_ccc$1085$6, this.parsingStack);
        }
        result.setLocation(this.template, t, t);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TemplateElement Assign() {
        String varName;
        Expression nameExp;
        String assignmentType;
        int type;
        Token start;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Assign";
        Token id = null;
        Expression nsExp = null;
        LinkedHashMap<String, Expression> assignments = new LinkedHashMap<String, Expression>();
        if (this.nextTokenType() == Token.TokenType.ASSIGN) {
            start = this.consumeToken(Token.TokenType.ASSIGN);
            type = 1;
            assignmentType = "assign";
        } else if (this.nextTokenType() == Token.TokenType.GLOBALASSIGN) {
            start = this.consumeToken(Token.TokenType.GLOBALASSIGN);
            type = 2;
            assignmentType = "global";
        } else if (this.nextTokenType() == Token.TokenType.LOCALASSIGN) {
            start = this.consumeToken(Token.TokenType.LOCALASSIGN);
            type = 3;
            assignmentType = "local";
        } else if (this.nextTokenType() == Token.TokenType.SET) {
            start = this.consumeToken(Token.TokenType.SET);
            type = 0;
            assignmentType = "set";
        } else {
            this.pushOntoCallStack("Assign", "src/parser/FM.ccc", 1112, 7);
            throw new ParseException(this, first_set$FM_ccc$1112$7, this.parsingStack);
        }
        AssignmentInstruction result = new AssignmentInstruction(type);
        this.pushOntoCallStack("Assign", "src/parser/FM.ccc", 1121, 5);
        try {
            nameExp = this.IdentifierOrStringLiteral();
        }
        finally {
            this.popCallStack();
        }
        String string = varName = nameExp instanceof StringLiteral ? ((StringLiteral)nameExp).getAsString() : nameExp.toString();
        if (this.nextTokenType() == Token.TokenType.EQUALS) {
            Token end;
            Expression exp;
            this.consumeToken(Token.TokenType.EQUALS);
            this.pushOntoCallStack("Assign", "src/parser/FM.ccc", 1127, 8);
            try {
                exp = this.Expression();
            }
            finally {
                this.popCallStack();
            }
            assignments.put(varName, exp);
            while (this.scan$FM_ccc$1130$13()) {
                if (this.nextTokenType() == Token.TokenType.COMMA) {
                    this.consumeToken(Token.TokenType.COMMA);
                }
                this.pushOntoCallStack("Assign", "src/parser/FM.ccc", 1131, 13);
                try {
                    nameExp = this.IdentifierOrStringLiteral();
                }
                finally {
                    this.popCallStack();
                }
                varName = nameExp instanceof StringLiteral ? ((StringLiteral)nameExp).getAsString() : nameExp.toString();
                this.consumeToken(Token.TokenType.EQUALS);
                this.pushOntoCallStack("Assign", "src/parser/FM.ccc", 1136, 13);
                try {
                    exp = this.Expression();
                }
                finally {
                    this.popCallStack();
                }
                assignments.put(varName, exp);
            }
            if (this.nextTokenType() == Token.TokenType.IN) {
                id = this.consumeToken(Token.TokenType.IN);
                this.pushOntoCallStack("Assign", "src/parser/FM.ccc", 1143, 11);
                try {
                    nsExp = this.Expression();
                }
                finally {
                    this.popCallStack();
                }
                if (type != 0 && type != 1) {
                    ParsingProblem problem = new ParsingProblem("Can only assign to namespace with #set or #assign.", result);
                    this.template.addParsingProblem(problem);
                }
            }
            this.pushOntoCallStack("Assign", "src/parser/FM.ccc", 1149, 8);
            try {
                end = this.LooseDirectiveEnd();
            }
            finally {
                this.popCallStack();
            }
            result.setNamespaceExp(nsExp);
            for (Map.Entry entry : assignments.entrySet()) {
                result.addAssignment((String)entry.getKey(), (Expression)entry.getValue());
            }
            result.setLocation(this.template, start, end);
            return result;
        }
        if (this.nextTokenType() == Token.TokenType.IN || this.nextTokenType == Token.TokenType.DIRECTIVE_END) {
            Token end;
            TemplateElement block;
            if (this.nextTokenType() == Token.TokenType.IN) {
                id = this.consumeToken(Token.TokenType.IN);
                this.pushOntoCallStack("Assign", "src/parser/FM.ccc", 1163, 11);
                try {
                    nsExp = this.Expression();
                }
                finally {
                    this.popCallStack();
                }
                if (type != 1 && type != 0) {
                    throw new ParseException(this.getErrorStart(id) + "\nCannot assign to namespace here.", id.getBeginLine(), id.getBeginColumn());
                }
            }
            this.consumeToken(Token.TokenType.DIRECTIVE_END);
            this.pushOntoCallStack("Assign", "src/parser/FM.ccc", 1166, 8);
            try {
                block = this.OptionalBlock();
            }
            finally {
                this.popCallStack();
            }
            this.pushOntoCallStack("Assign", "src/parser/FM.ccc", 1167, 8);
            try {
                end = this.CloseDirectiveBlock(assignmentType);
            }
            finally {
                this.popCallStack();
            }
            String name = end.getImage().substring(3, end.getImage().length() - 1);
            switch (type) {
                case 3: {
                    if (name.length() <= 0 || name.equals("local")) break;
                    throw new ParseException(this.getErrorStart(end) + "\nMismatched assignment tags.", end.getBeginLine(), end.getBeginColumn());
                }
                case 1: {
                    if (name.length() <= 0 || name.equals("assign")) break;
                    throw new ParseException(this.getErrorStart(end) + "\nMismatched assignment tags.", end.getBeginLine(), end.getBeginColumn());
                }
                case 2: {
                    if (name.length() <= 0 || name.equals("global")) break;
                    throw new ParseException(this.getErrorStart(end) + "\nMismatched assignment tags.", end.getBeginLine(), end.getBeginColumn());
                }
                case 0: {
                    if (name.length() <= 0 || name.equals("set")) break;
                    throw new ParseException(this.getErrorStart(end) + "\nMismatched assignment tags.", end.getBeginLine(), end.getBeginColumn());
                }
            }
            BlockAssignment ba = new BlockAssignment(block, varName, type, nsExp);
            ba.setLocation(this.template, start, end);
            return ba;
        }
        this.pushOntoCallStack("Assign", "src/parser/FM.ccc", 1125, 6);
        throw new ParseException(this, first_set$FM_ccc$1125$6, this.parsingStack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Include Include() {
        Token end;
        Expression nameExp;
        boolean freshNamespace;
        Token start;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Include";
        Expression parseExp = null;
        Expression encodingExp = null;
        if (this.nextTokenType() == Token.TokenType._INCLUDE) {
            start = this.consumeToken(Token.TokenType._INCLUDE);
            freshNamespace = false;
        } else if (this.nextTokenType() == Token.TokenType.EMBED) {
            start = this.consumeToken(Token.TokenType.EMBED);
            freshNamespace = true;
        } else {
            this.pushOntoCallStack("Include", "src/parser/FM.ccc", 1189, 9);
            throw new ParseException(this, first_set$FM_ccc$1189$9, this.parsingStack);
        }
        this.pushOntoCallStack("Include", "src/parser/FM.ccc", 1193, 5);
        try {
            nameExp = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        if (this.nextTokenType() == Token.TokenType.SEMICOLON) {
            this.consumeToken(Token.TokenType.SEMICOLON);
        }
        while (this.nextTokenType() == Token.TokenType.ID) {
            Expression exp;
            Token att = this.consumeToken(Token.TokenType.ID);
            this.consumeToken(Token.TokenType.EQUALS);
            this.pushOntoCallStack("Include", "src/parser/FM.ccc", 1198, 4);
            try {
                exp = this.Expression();
            }
            finally {
                this.popCallStack();
            }
            String attString = att.getImage();
            if (attString.equalsIgnoreCase("parse")) {
                if (parseExp != null) {
                    String msg = this.getErrorStart(att) + "\nparse may not be specified more than once.";
                    throw new ParseException(msg, att.getBeginLine(), att.getBeginColumn());
                }
                parseExp = exp;
                continue;
            }
            if (attString.equalsIgnoreCase("encoding")) {
                if (encodingExp != null) {
                    String msg = this.getErrorStart(att) + "\nencoding may not be specified more than once.";
                    throw new ParseException(msg, att.getBeginLine(), att.getBeginColumn());
                }
                encodingExp = exp;
                continue;
            }
            String msg = this.getErrorStart(att) + "\nexpecting parse= or encoding= to be specified.";
            throw new ParseException(msg, att.getBeginLine(), att.getBeginColumn());
        }
        this.pushOntoCallStack("Include", "src/parser/FM.ccc", 1224, 5);
        try {
            end = this.LooseDirectiveEnd();
        }
        finally {
            this.popCallStack();
        }
        Include result = new Include(this.template, nameExp, freshNamespace, encodingExp, parseExp);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LibraryLoad Import() {
        Token end;
        Expression nameExp;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Import";
        Token start = this.consumeToken(Token.TokenType.IMPORT);
        this.pushOntoCallStack("Import", "src/parser/FM.ccc", 1238, 4);
        try {
            nameExp = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        this.consumeToken(Token.TokenType.AS);
        Token ns = this.consumeToken(Token.TokenType.ID);
        this.pushOntoCallStack("Import", "src/parser/FM.ccc", 1241, 4);
        try {
            end = this.LooseDirectiveEnd();
        }
        finally {
            this.popCallStack();
        }
        LibraryLoad result = new LibraryLoad(this.template, nameExp, ns.getImage());
        result.setLocation(this.template, start, end);
        if (this.template != null) {
            this.template.addImport(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ParameterList ParameterList() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "ParameterList";
        Token arg = null;
        Token firstArg = null;
        Token ellipsis = null;
        Expression defValue = null;
        ParameterList result = new ParameterList();
        Object catchAll = null;
        boolean isCatchAll = false;
        boolean hasDefaults = false;
        HashSet<String> paramNames = new HashSet<String>();
        while (this.nextTokenType() == Token.TokenType.ID) {
            arg = this.consumeToken(Token.TokenType.ID);
            if (firstArg == null) {
                firstArg = arg;
            }
            defValue = null;
            if (paramNames.contains(arg.getImage())) {
                throw new ParseException(this.getErrorStart(arg) + "\nThe parameter " + arg.getImage() + " cannot be repeated.");
            }
            paramNames.add(arg.getImage());
            if (this.nextTokenType() == Token.TokenType.ELLIPSIS) {
                ellipsis = this.consumeToken(Token.TokenType.ELLIPSIS);
                isCatchAll = true;
            }
            if (this.nextTokenType() == Token.TokenType.EQUALS) {
                this.consumeToken(Token.TokenType.EQUALS);
                this.pushOntoCallStack("ParameterList", "src/parser/FM.ccc", 1273, 12);
                try {
                    defValue = this.Expression();
                }
                finally {
                    this.popCallStack();
                }
                hasDefaults = true;
            }
            if (this.nextTokenType() == Token.TokenType.COMMA) {
                this.consumeToken(Token.TokenType.COMMA);
            }
            if (catchAll != null) {
                throw new ParseException(this.getErrorStart(arg) + "\nThere may only be one \"catch-all\" parameter in a macro declaration, and it must be the last parameter.", arg.getBeginLine(), arg.getEndLine());
            }
            if (isCatchAll) {
                if (defValue != null) {
                    throw new ParseException(this.getErrorStart(arg) + "\n\"Catch-all\" macro parameter may not have a default value.", arg.getBeginLine(), arg.getEndLine());
                }
                result.setCatchAll(arg.getImage());
                continue;
            }
            if (defValue == null) {
                if (hasDefaults) {
                    throw new ParseException(this.getErrorStart(arg) + "\nIn a macro declaration, parameters without a default value must all occur before the parameters with default values.", arg.getBeginLine(), arg.getEndLine());
                }
                result.addParam(arg.getImage());
                continue;
            }
            result.addParam(arg.getImage(), defValue);
            hasDefaults = true;
        }
        if (ellipsis != null) {
            result.setLocation(this.template, firstArg, ellipsis);
        } else if (defValue != null) {
            result.setLocation(this.template, firstArg, defValue);
        } else if (firstArg != null) {
            result.setLocation(this.template, firstArg, arg);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Param Param() {
        String name;
        Expression nameExp;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Param";
        Token start = this.consumeToken(Token.TokenType.PARAM);
        this.pushOntoCallStack("Param", "src/parser/FM.ccc", 1330, 2);
        try {
            nameExp = this.IdentifierOrStringLiteral();
        }
        finally {
            this.popCallStack();
        }
        String string = name = nameExp instanceof StringLiteral ? ((StringLiteral)nameExp).getAsString() : nameExp.toString();
        if (this.nextTokenType() == Token.TokenType.OPEN_PAREN) {
            this.consumeToken(Token.TokenType.OPEN_PAREN);
        }
        this.pushOntoCallStack("Param", "src/parser/FM.ccc", 1335, 5);
        try {
            ParameterList params = this.ParameterList();
        }
        finally {
            this.popCallStack();
        }
        if (this.nextTokenType() == Token.TokenType.CLOSE_PAREN) {
            this.consumeToken(Token.TokenType.CLOSE_PAREN);
        }
        if (this.nextTokenType() == Token.TokenType.EMPTY_DIRECTIVE_END) {
            Token end = this.consumeToken(Token.TokenType.EMPTY_DIRECTIVE_END);
        } else {
            if (this.nextTokenType() == Token.TokenType.DIRECTIVE_END) {
                this.consumeToken(Token.TokenType.DIRECTIVE_END);
                this.pushOntoCallStack("Param", "src/parser/FM.ccc", 1342, 10);
                try {
                    TemplateElement block = this.OptionalBlock();
                }
                finally {
                    this.popCallStack();
                }
                this.pushOntoCallStack("Param", "src/parser/FM.ccc", 1343, 10);
                try {
                    Token end = this.CloseDirectiveBlock("param");
                }
                finally {
                    this.popCallStack();
                }
            }
            this.pushOntoCallStack("Param", "src/parser/FM.ccc", 1338, 7);
            throw new ParseException(this, first_set$FM_ccc$1338$7, this.parsingStack);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Macro Macro() {
        Token end;
        TemplateElement block;
        ParameterList params;
        Expression nameExp;
        String functionOrMacro;
        Token start;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Macro";
        Macro result = new Macro();
        if (this.nextTokenType() == Token.TokenType.MACRO) {
            start = this.consumeToken(Token.TokenType.MACRO);
            functionOrMacro = "macro";
        } else if (this.nextTokenType() == Token.TokenType.FUNCTION) {
            start = this.consumeToken(Token.TokenType.FUNCTION);
            result.setFunction(true);
            functionOrMacro = "function";
        } else {
            this.pushOntoCallStack("Macro", "src/parser/FM.ccc", 1361, 9);
            throw new ParseException(this, first_set$FM_ccc$1361$9, this.parsingStack);
        }
        this.pushOntoCallStack("Macro", "src/parser/FM.ccc", 1365, 5);
        try {
            nameExp = this.IdentifierOrStringLiteral();
        }
        finally {
            this.popCallStack();
        }
        String name = nameExp instanceof StringLiteral ? ((StringLiteral)nameExp).getAsString() : nameExp.toString();
        result.setName(name);
        if (this.nextTokenType() == Token.TokenType.OPEN_PAREN) {
            this.consumeToken(Token.TokenType.OPEN_PAREN);
        }
        this.pushOntoCallStack("Macro", "src/parser/FM.ccc", 1371, 5);
        try {
            params = this.ParameterList();
        }
        finally {
            this.popCallStack();
        }
        result.setParams(params);
        if (this.nextTokenType() == Token.TokenType.CLOSE_PAREN) {
            this.consumeToken(Token.TokenType.CLOSE_PAREN);
        }
        this.consumeToken(Token.TokenType.DIRECTIVE_END);
        this.pushOntoCallStack("Macro", "src/parser/FM.ccc", 1374, 5);
        try {
            block = this.OptionalBlock();
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("Macro", "src/parser/FM.ccc", 1375, 5);
        try {
            end = this.CloseDirectiveBlock(functionOrMacro);
        }
        finally {
            this.popCallStack();
        }
        result.setName(name);
        result.setNestedBlock(block);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CompressedBlock Compress() {
        Token end;
        TemplateElement block;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Compress";
        Token start = this.consumeToken(Token.TokenType.COMPRESS);
        this.pushOntoCallStack("Compress", "src/parser/FM.ccc", 1391, 5);
        try {
            block = this.OptionalBlock();
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("Compress", "src/parser/FM.ccc", 1392, 5);
        try {
            end = this.CloseDirectiveBlock("compress");
        }
        finally {
            this.popCallStack();
        }
        CompressedBlock cb = new CompressedBlock(block);
        cb.setLocation(this.template, start, end);
        return cb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PositionalArgsList PositionalArgsList() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "PositionalArgsList";
        Expression firstArg = null;
        Expression arg = null;
        PositionalArgsList result = new PositionalArgsList();
        this.pushOntoCallStack("PositionalArgsList", "src/parser/FM.ccc", 1404, 2);
        try {
            firstArg = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        result.addArg(firstArg);
        arg = firstArg;
        while (first_set$FM_ccc$1406$5.contains((Object)this.nextTokenType())) {
            if (this.nextTokenType() == Token.TokenType.COMMA) {
                this.consumeToken(Token.TokenType.COMMA);
            }
            this.pushOntoCallStack("PositionalArgsList", "src/parser/FM.ccc", 1407, 5);
            try {
                arg = this.Expression();
            }
            finally {
                this.popCallStack();
            }
            result.addArg(arg);
        }
        if (firstArg != null) {
            result.setLocation(this.template, (TemplateLocation)firstArg, (TemplateLocation)arg);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NamedArgsList NamedArgsList() {
        Expression arg;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "NamedArgsList";
        NamedArgsList result = new NamedArgsList();
        Token firstParam = this.consumeToken(Token.TokenType.ID);
        this.consumeToken(Token.TokenType.EQUALS);
        this.pushOntoCallStack("NamedArgsList", "src/parser/FM.ccc", 1423, 2);
        try {
            arg = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        result.addNamedArg(firstParam.getImage(), arg);
        while (this.nextTokenType() == Token.TokenType.COMMA || this.nextTokenType == Token.TokenType.ID) {
            if (this.nextTokenType() == Token.TokenType.COMMA) {
                this.consumeToken(Token.TokenType.COMMA);
            }
            Token id = this.consumeToken(Token.TokenType.ID);
            this.consumeToken(Token.TokenType.EQUALS);
            this.pushOntoCallStack("NamedArgsList", "src/parser/FM.ccc", 1431, 5);
            try {
                arg = this.Expression();
            }
            finally {
                this.popCallStack();
            }
            result.addNamedArg(id.getImage(), arg);
        }
        this.token_source.inInvocation = false;
        result.setLocation(this.template, firstParam, (TemplateLocation)arg);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ArgsList ArgsList() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "ArgsList";
        ArgsList result = null;
        Object exp = null;
        if (this.scan$FM_ccc$1447$5()) {
            this.pushOntoCallStack("ArgsList", "src/parser/FM.ccc", 1448, 8);
            try {
                result = this.NamedArgsList();
            }
            finally {
                this.popCallStack();
            }
        } else if (first_set$FM_ccc$1450$8.contains((Object)this.nextTokenType())) {
            this.pushOntoCallStack("ArgsList", "src/parser/FM.ccc", 1450, 8);
            try {
                result = this.PositionalArgsList();
            }
            finally {
                this.popCallStack();
            }
        } else {
            this.pushOntoCallStack("ArgsList", "src/parser/FM.ccc", 1447, 5);
            throw new ParseException(this, first_set$FM_ccc$1447$5, this.parsingStack);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TemplateElement UnifiedMacroTransform() {
        Token end;
        Expression exp;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "UnifiedMacroTransform";
        Token start = null;
        Object namedArgs = null;
        Object positionalArgs = null;
        String directiveName = null;
        TemplateElement nestedBlock = null;
        UnifiedCall result = new UnifiedCall();
        ArgsList args = null;
        ParameterList bodyParameters = null;
        start = this.consumeToken(Token.TokenType.UNIFIED_CALL);
        this.pushOntoCallStack("UnifiedMacroTransform", "src/parser/FM.ccc", 1472, 5);
        try {
            exp = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        if (exp instanceof Identifier || exp instanceof Dot && ((Dot)exp).onlyHasIdentifiers()) {
            directiveName = exp.getCanonicalForm();
        }
        result.setNameExp(exp);
        if (this.nextTokenType() == Token.TokenType.TERMINATING_WHITESPACE) {
            this.consumeToken(Token.TokenType.TERMINATING_WHITESPACE);
        }
        if (first_set$FM_ccc$1480$6.contains((Object)this.nextTokenType())) {
            this.pushOntoCallStack("UnifiedMacroTransform", "src/parser/FM.ccc", 1480, 6);
            try {
                args = this.ArgsList();
            }
            finally {
                this.popCallStack();
            }
        }
        if (args == null) {
            args = new EmptyArgsList();
        }
        result.setArgs(args);
        if (this.nextTokenType() == Token.TokenType.SEMICOLON) {
            this.consumeToken(Token.TokenType.SEMICOLON);
            if (this.nextTokenType() == Token.TokenType.TERMINATING_WHITESPACE) {
                this.consumeToken(Token.TokenType.TERMINATING_WHITESPACE);
            }
            this.pushOntoCallStack("UnifiedMacroTransform", "src/parser/FM.ccc", 1490, 8);
            try {
                bodyParameters = this.ParameterList();
            }
            finally {
                this.popCallStack();
            }
            result.setBodyParameters(bodyParameters);
        }
        if (this.nextTokenType() == Token.TokenType.EMPTY_DIRECTIVE_END) {
            end = this.consumeToken(Token.TokenType.EMPTY_DIRECTIVE_END);
        } else if (this.nextTokenType() == Token.TokenType.DIRECTIVE_END) {
            this.consumeToken(Token.TokenType.DIRECTIVE_END);
            this.pushOntoCallStack("UnifiedMacroTransform", "src/parser/FM.ccc", 1500, 3);
            try {
                nestedBlock = this.OptionalBlock();
            }
            finally {
                this.popCallStack();
            }
            end = this.consumeToken(Token.TokenType.UNIFIED_CALL_END);
            String s = end.getImage().substring(2);
            if (s.charAt(0) == '@') {
                s = s.substring(1);
            }
            if ((s = s.substring(0, s.length() - 1).trim()).length() > 0 && !s.equals(directiveName)) {
                String msg = this.getErrorStart(end);
                if (directiveName == null) {
                    throw new ParseException(msg + "\nExpecting </@>", end.getBeginLine(), end.getBeginColumn());
                }
                throw new ParseException(msg + "\nExpecting </@> or </@" + directiveName + ">", end.getBeginLine(), end.getBeginColumn());
            }
            result.setNestedBlock(nestedBlock);
        } else {
            this.pushOntoCallStack("UnifiedMacroTransform", "src/parser/FM.ccc", 1496, 7);
            throw new ParseException(this, first_set$FM_ccc$1496$7, this.parsingStack);
        }
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TemplateElement Call() {
        Token end;
        Identifier id;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Call";
        Object macroName = null;
        UnifiedCall result = new UnifiedCall();
        ArgsList args = null;
        Token start = this.consumeToken(Token.TokenType.CALL);
        this.pushOntoCallStack("Call", "src/parser/FM.ccc", 1536, 5);
        try {
            id = this.Identifier();
        }
        finally {
            this.popCallStack();
        }
        result.setNameExp(id);
        if (this.nextTokenType() == Token.TokenType.OPEN_PAREN) {
            this.consumeToken(Token.TokenType.OPEN_PAREN);
        }
        this.pushOntoCallStack("Call", "src/parser/FM.ccc", 1540, 5);
        try {
            args = this.ArgsList();
        }
        finally {
            this.popCallStack();
        }
        result.setArgs(args);
        if (this.nextTokenType() == Token.TokenType.CLOSE_PAREN) {
            this.consumeToken(Token.TokenType.CLOSE_PAREN);
        }
        this.pushOntoCallStack("Call", "src/parser/FM.ccc", 1542, 5);
        try {
            end = this.LooseDirectiveEnd();
        }
        finally {
            this.popCallStack();
        }
        result.setLocation(this.template, start, end);
        args.setLocationInfoIfAbsent(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, Expression> NamedArgs() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "NamedArgs";
        LinkedHashMap<String, Expression> result = new LinkedHashMap<String, Expression>();
        do {
            Expression exp;
            Token t = this.consumeToken(Token.TokenType.ID);
            this.consumeToken(Token.TokenType.EQUALS);
            this.pushOntoCallStack("NamedArgs", "src/parser/FM.ccc", 1559, 6);
            try {
                exp = this.Expression();
            }
            finally {
                this.popCallStack();
            }
            if (result.containsKey(t.getImage())) {
                throw new ParseException(this.getErrorStart(t) + "\nValue of named parameter '" + t.getImage() + "' may only be specified once.", t.getBeginLine(), t.getEndLine());
            }
            result.put(t.getImage(), exp);
        } while (this.nextTokenType() == Token.TokenType.ID);
        return result;
    }

    public final Comment TerseComment() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "TerseComment";
        StringBuilder buf = new StringBuilder();
        Token start = this.consumeToken(Token.TokenType.TERSE_COMMENT);
        while (this.nextTokenType() == Token.TokenType.PRINTABLE_CHARS) {
            Token t = this.consumeToken(Token.TokenType.PRINTABLE_CHARS);
            buf.append(t.getImage());
        }
        Token end = this.consumeToken(Token.TokenType.TERSE_COMMENT_END);
        Comment result = new Comment(buf.toString());
        result.setLocation(this.template, start, end);
        return result;
    }

    public final Comment Comment() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Comment";
        StringBuilder buf = new StringBuilder();
        Token start = this.consumeToken(Token.TokenType.COMMENT);
        while (this.nextTokenType() == Token.TokenType.PRINTABLE_CHARS) {
            Token t = this.consumeToken(Token.TokenType.PRINTABLE_CHARS);
            buf.append(t.getImage());
        }
        Token end = this.consumeToken(Token.TokenType.COMMENT_END);
        Comment result = new Comment(buf.toString());
        result.setLocation(this.template, start, end);
        return result;
    }

    public final NoParseBlock NoParse() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "NoParse";
        StringBuilder buf = new StringBuilder();
        Token start = this.consumeToken(Token.TokenType.NOPARSE);
        while (this.nextTokenType() == Token.TokenType.PRINTABLE_CHARS) {
            Token t = this.consumeToken(Token.TokenType.PRINTABLE_CHARS);
            buf.append(t.getImage());
        }
        Token end = this.consumeToken(Token.TokenType.NOPARSE_END);
        int beginColumn = start.getBeginColumn();
        int beginLine = start.getBeginLine();
        int lastChar = 0;
        for (int n : start.getImage().toCharArray()) {
            switch (n) {
                case 10: {
                    if (lastChar == 13) break;
                }
                case 13: {
                    beginColumn = 1;
                    ++beginLine;
                    break;
                }
                default: {
                    ++beginColumn;
                }
            }
            lastChar = n;
        }
        List<TextBlock> text = TextBlock.breakIntoBlocks(buf.toString(), this.template, beginColumn, beginLine);
        NoParseBlock result = new NoParseBlock(start.getImage(), end.getImage(), text);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TransformBlock Transform() {
        Token end;
        Expression exp;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Transform";
        TemplateElement content = null;
        HashMap<String, Expression> args = null;
        Token start = this.consumeToken(Token.TokenType.TRANSFORM);
        this.pushOntoCallStack("Transform", "src/parser/FM.ccc", 1645, 5);
        try {
            exp = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        if (this.nextTokenType() == Token.TokenType.SEMICOLON) {
            this.consumeToken(Token.TokenType.SEMICOLON);
        }
        while (this.nextTokenType() == Token.TokenType.ID) {
            Expression argExp;
            Token argName = this.consumeToken(Token.TokenType.ID);
            this.consumeToken(Token.TokenType.EQUALS);
            this.pushOntoCallStack("Transform", "src/parser/FM.ccc", 1650, 8);
            try {
                argExp = this.Expression();
            }
            finally {
                this.popCallStack();
            }
            if (args == null) {
                args = new HashMap<String, Expression>();
            }
            args.put(argName.getImage(), argExp);
        }
        if (this.nextTokenType() == Token.TokenType.EMPTY_DIRECTIVE_END) {
            end = this.consumeToken(Token.TokenType.EMPTY_DIRECTIVE_END);
        } else {
            if (this.nextTokenType() == Token.TokenType.DIRECTIVE_END) {
                this.consumeToken(Token.TokenType.DIRECTIVE_END);
                this.pushOntoCallStack("Transform", "src/parser/FM.ccc", 1661, 11);
                try {
                    content = this.OptionalBlock();
                }
                finally {
                    this.popCallStack();
                }
                this.pushOntoCallStack("Transform", "src/parser/FM.ccc", 1662, 11);
                try {
                    end = this.CloseDirectiveBlock("transform");
                }
                finally {
                    this.popCallStack();
                }
            }
            this.pushOntoCallStack("Transform", "src/parser/FM.ccc", 1657, 8);
            throw new ParseException(this, first_set$FM_ccc$1657$8, this.parsingStack);
        }
        TransformBlock result = new TransformBlock(exp, args, content);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final SwitchBlock Switch() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Switch";
        defaultFound = false;
        start = this.consumeToken(Token.TokenType.SWITCH);
        this.pushOntoCallStack("Switch", "src/parser/FM.ccc", 1681, 4);
        try {
            switchExp = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        this.consumeToken(Token.TokenType.DIRECTIVE_END);
        while (true) lbl-1000:
        // 4 sources

        {
            if (this.nextTokenType() == Token.TokenType.WHITESPACE) {
                this.consumeToken(Token.TokenType.WHITESPACE);
                continue;
            }
            if (this.nextTokenType() != Token.TokenType.COMMENT) ** break;
            this.pushOntoCallStack("Switch", "src/parser/FM.ccc", 1683, 18);
            try {
                this.Comment();
            }
            finally {
                this.popCallStack();
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        switchBlock = new SwitchBlock(switchExp);
        while (this.scan$FM_ccc$1688$6()) {
            this.pushOntoCallStack("Switch", "src/parser/FM.ccc", 1688, 16);
            try {
                caseIns = this.Case();
            }
            finally {
                this.popCallStack();
            }
            if (caseIns.isDefault()) {
                if (defaultFound) {
                    msg = this.getErrorStart(start) + "\nYou can only have one default case in a switch statement";
                    throw new ParseException(msg, start.getBeginLine(), start.getBeginColumn());
                }
                defaultFound = true;
            }
            switchBlock.addCase(caseIns);
        }
        this.pushOntoCallStack("Switch", "src/parser/FM.ccc", 1701, 4);
        try {
            end = this.CloseDirectiveBlock("switch");
        }
        finally {
            this.popCallStack();
        }
        switchBlock.setLocation(this.template, start, end);
        return switchBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Case Case() {
        TemplateElement block;
        Token start;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Case";
        Expression exp = null;
        boolean isDefault = false;
        if (this.nextTokenType() == Token.TokenType.CASE) {
            start = this.consumeToken(Token.TokenType.CASE);
            this.pushOntoCallStack("Case", "src/parser/FM.ccc", 1716, 7);
            try {
                exp = this.Expression();
            }
            finally {
                this.popCallStack();
            }
            this.consumeToken(Token.TokenType.DIRECTIVE_END);
        } else if (this.nextTokenType() == Token.TokenType.DEFAUL) {
            start = this.consumeToken(Token.TokenType.DEFAUL);
            isDefault = true;
        } else {
            this.pushOntoCallStack("Case", "src/parser/FM.ccc", 1715, 7);
            throw new ParseException(this, first_set$FM_ccc$1715$7, this.parsingStack);
        }
        this.pushOntoCallStack("Case", "src/parser/FM.ccc", 1721, 4);
        try {
            block = this.OptionalBlock();
        }
        finally {
            this.popCallStack();
        }
        Case result = new Case(exp, block, isDefault);
        result.setLocation(this.template, start, (TemplateLocation)block);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TrimBlock TrimBlock() {
        Token end;
        TemplateElement content;
        Token start;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "TrimBlock";
        boolean left = false;
        boolean right = false;
        String closeTag = null;
        if (this.nextTokenType() == Token.TokenType.BLOCKTRIM) {
            start = this.consumeToken(Token.TokenType.BLOCKTRIM);
            closeTag = "t_lines";
            right = true;
            left = true;
        } else if (this.nextTokenType() == Token.TokenType.BLOCKTRIML) {
            start = this.consumeToken(Token.TokenType.BLOCKTRIML);
            closeTag = "lt_lines";
            left = true;
        } else if (this.nextTokenType() == Token.TokenType.BLOCKTRIMR) {
            start = this.consumeToken(Token.TokenType.BLOCKTRIMR);
            closeTag = "rt_lines";
            right = true;
        } else if (this.nextTokenType() == Token.TokenType.BLOCKNOTRIM) {
            start = this.consumeToken(Token.TokenType.BLOCKNOTRIM);
            closeTag = "nt_lines";
        } else {
            this.pushOntoCallStack("TrimBlock", "src/parser/FM.ccc", 1736, 5);
            throw new ParseException(this, first_set$FM_ccc$1736$5, this.parsingStack);
        }
        ++this.trimBlockNesting;
        this.pushOntoCallStack("TrimBlock", "src/parser/FM.ccc", 1745, 2);
        try {
            content = this.OptionalBlock();
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("TrimBlock", "src/parser/FM.ccc", 1746, 2);
        try {
            end = this.CloseDirectiveBlock(closeTag);
        }
        finally {
            this.popCallStack();
        }
        TrimBlock result = new TrimBlock(content, left, right);
        result.setLocation(this.template, start, end);
        --this.trimBlockNesting;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final EscapeBlock Escape() {
        Token end;
        TemplateElement content;
        Expression escapeExpr;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Escape";
        Token start = this.consumeToken(Token.TokenType.ESCAPE);
        Token variable = this.consumeToken(Token.TokenType.ID);
        this.consumeToken(Token.TokenType.AS);
        this.pushOntoCallStack("Escape", "src/parser/FM.ccc", 1765, 5);
        try {
            escapeExpr = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        this.consumeToken(Token.TokenType.DIRECTIVE_END);
        EscapeBlock result = new EscapeBlock(variable.getImage(), escapeExpr);
        this.pushOntoCallStack("Escape", "src/parser/FM.ccc", 1770, 5);
        try {
            content = this.OptionalBlock();
        }
        finally {
            this.popCallStack();
        }
        result.setContent(content);
        this.pushOntoCallStack("Escape", "src/parser/FM.ccc", 1774, 5);
        try {
            end = this.CloseDirectiveBlock("escape");
        }
        finally {
            this.popCallStack();
        }
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NoEscapeBlock NoEscape() {
        Token end;
        TemplateElement content;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "NoEscape";
        Token start = this.consumeToken(Token.TokenType.NOESCAPE);
        this.pushOntoCallStack("NoEscape", "src/parser/FM.ccc", 1787, 5);
        try {
            content = this.OptionalBlock();
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("NoEscape", "src/parser/FM.ccc", 1788, 5);
        try {
            end = this.CloseDirectiveBlock("noescape");
        }
        finally {
            this.popCallStack();
        }
        NoEscapeBlock result = new NoEscapeBlock(content);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final Token CloseDirectiveBlock(String expectedTags) {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "CloseDirectiveBlock";
        Token t = this.consumeToken(Token.TokenType.CLOSE_DIRECTIVE_BLOCK);
        String name = t.getImage();
        if ((name = name.substring(3, name.length() - 1)).length() > 0) {
            StringTokenizer st = new StringTokenizer(expectedTags, ", ");
            boolean found = false;
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equals(name.trim())) continue;
                found = true;
            }
            if (!found) {
                throw new ParseException(this.getErrorStart(t) + " Expecting " + t.getImage().substring(0, 3) + expectedTags + t.getImage().charAt(t.getImage().length() - 1));
            }
        }
        return t;
    }

    public final Token LooseDirectiveEnd() {
        Token t;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "LooseDirectiveEnd";
        if (this.nextTokenType() == Token.TokenType.DIRECTIVE_END) {
            t = this.consumeToken(Token.TokenType.DIRECTIVE_END);
        } else if (this.nextTokenType() == Token.TokenType.EMPTY_DIRECTIVE_END) {
            t = this.consumeToken(Token.TokenType.EMPTY_DIRECTIVE_END);
        } else {
            this.pushOntoCallStack("LooseDirectiveEnd", "src/parser/FM.ccc", 1829, 7);
            throw new ParseException(this, first_set$FM_ccc$1829$7, this.parsingStack);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PropertySetting Setting() {
        Token end;
        Expression value;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Setting";
        Token start = this.consumeToken(Token.TokenType.SETTING);
        Token key = this.consumeToken(Token.TokenType.ID);
        this.consumeToken(Token.TokenType.EQUALS);
        this.pushOntoCallStack("Setting", "src/parser/FM.ccc", 1846, 4);
        try {
            value = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        this.pushOntoCallStack("Setting", "src/parser/FM.ccc", 1847, 4);
        try {
            end = this.LooseDirectiveEnd();
        }
        finally {
            this.popCallStack();
        }
        PropertySetting result = new PropertySetting(key.getImage(), value);
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final VarDirective Var() {
        Token end;
        Expression var;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Var";
        Expression valueExp = null;
        VarDirective result = new VarDirective();
        Token start = this.consumeToken(Token.TokenType.VAR);
        this.pushOntoCallStack("Var", "src/parser/FM.ccc", 1863, 6);
        try {
            var = this.IdentifierOrStringLiteral();
        }
        finally {
            this.popCallStack();
        }
        if (this.nextTokenType() == Token.TokenType.EQUALS) {
            this.consumeToken(Token.TokenType.EQUALS);
            this.pushOntoCallStack("Var", "src/parser/FM.ccc", 1866, 8);
            try {
                valueExp = this.Expression();
            }
            finally {
                this.popCallStack();
            }
        }
        result.addVar(var, valueExp);
        valueExp = null;
        while (this.nextTokenType() == Token.TokenType.STRING_LITERAL || this.nextTokenType == Token.TokenType.RAW_STRING || this.nextTokenType == Token.TokenType.COMMA || this.nextTokenType == Token.TokenType.ID) {
            if (this.nextTokenType() == Token.TokenType.COMMA) {
                this.consumeToken(Token.TokenType.COMMA);
            }
            this.pushOntoCallStack("Var", "src/parser/FM.ccc", 1876, 9);
            try {
                var = this.IdentifierOrStringLiteral();
            }
            finally {
                this.popCallStack();
            }
            if (this.nextTokenType() == Token.TokenType.EQUALS) {
                this.consumeToken(Token.TokenType.EQUALS);
                this.pushOntoCallStack("Var", "src/parser/FM.ccc", 1879, 12);
                try {
                    valueExp = this.Expression();
                }
                finally {
                    this.popCallStack();
                }
            }
            result.addVar(var, valueExp);
            valueExp = null;
        }
        this.pushOntoCallStack("Var", "src/parser/FM.ccc", 1887, 4);
        try {
            end = this.LooseDirectiveEnd();
        }
        finally {
            this.popCallStack();
        }
        result.setLocation(this.template, start, end);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TemplateElement FreemarkerDirective() {
        TemplateElement tp;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "FreemarkerDirective";
        if (this.nextTokenType() == Token.TokenType.IF) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1902, 6);
            try {
                tp = this.If();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.LIST) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1904, 6);
            try {
                tp = this.List();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.FOREACH) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1906, 6);
            try {
                tp = this.ForEach();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.ASSIGN || this.nextTokenType == Token.TokenType.GLOBALASSIGN || this.nextTokenType == Token.TokenType.LOCALASSIGN || this.nextTokenType == Token.TokenType.SET) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1908, 6);
            try {
                tp = this.Assign();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType._INCLUDE || this.nextTokenType == Token.TokenType.EMBED) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1910, 6);
            try {
                tp = this.Include();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.IMPORT) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1912, 6);
            try {
                tp = this.Import();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.FUNCTION || this.nextTokenType == Token.TokenType.MACRO) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1914, 6);
            try {
                tp = this.Macro();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.COMPRESS) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1916, 6);
            try {
                tp = this.Compress();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.UNIFIED_CALL) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1918, 6);
            try {
                tp = this.UnifiedMacroTransform();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.CALL) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1920, 6);
            try {
                tp = this.Call();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.TERSE_COMMENT) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1922, 6);
            try {
                tp = this.TerseComment();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.COMMENT) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1924, 6);
            try {
                tp = this.Comment();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.NOPARSE) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1926, 6);
            try {
                tp = this.NoParse();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.TRANSFORM) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1928, 6);
            try {
                tp = this.Transform();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.SWITCH) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1930, 6);
            try {
                tp = this.Switch();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.SETTING) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1932, 6);
            try {
                tp = this.Setting();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.VAR) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1934, 6);
            try {
                tp = this.Var();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.BREAK) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1936, 6);
            try {
                tp = this.Break();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.RETURN || this.nextTokenType == Token.TokenType.SIMPLE_RETURN) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1938, 6);
            try {
                tp = this.Return();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.STOP || this.nextTokenType == Token.TokenType.HALT) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1940, 6);
            try {
                tp = this.Stop();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.FLUSH) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1942, 6);
            try {
                tp = this.Flush();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.TRIM || this.nextTokenType == Token.TokenType.LTRIM || this.nextTokenType == Token.TokenType.RTRIM || this.nextTokenType == Token.TokenType.NOTRIM) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1944, 6);
            try {
                tp = this.Trim();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.SIMPLE_NESTED || this.nextTokenType == Token.TokenType.NESTED) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1946, 6);
            try {
                tp = this.Nested();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.ESCAPE) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1948, 6);
            try {
                tp = this.Escape();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.NOESCAPE) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1950, 6);
            try {
                tp = this.NoEscape();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.BLOCKTRIM || this.nextTokenType == Token.TokenType.BLOCKTRIML || this.nextTokenType == Token.TokenType.BLOCKTRIMR || this.nextTokenType == Token.TokenType.BLOCKNOTRIM) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1952, 6);
            try {
                tp = this.TrimBlock();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.VISIT) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1954, 6);
            try {
                tp = this.Visit();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.SIMPLE_RECURSE || this.nextTokenType == Token.TokenType.RECURSE) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1956, 6);
            try {
                tp = this.Recurse();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.FALLBACK) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1958, 6);
            try {
                tp = this.FallBack();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType._ATTEMPT) {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1960, 6);
            try {
                tp = this.Attempt();
            }
            finally {
                this.popCallStack();
            }
        } else {
            this.pushOntoCallStack("FreemarkerDirective", "src/parser/FM.ccc", 1902, 6);
            throw new ParseException(this, first_set$FM_ccc$1902$6, this.parsingStack);
        }
        return tp;
    }

    public final List<TextBlock> PCData() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "PCData";
        StringBuilder buf = new StringBuilder();
        Token t = null;
        Token start = null;
        Token prevToken = null;
        List<TextBlock> result = new ArrayList<TextBlock>();
        do {
            if (this.nextTokenType() == Token.TokenType.PRINTABLE_CHARS) {
                prevToken = t;
                t = this.consumeToken(Token.TokenType.PRINTABLE_CHARS);
            } else if (this.nextTokenType() == Token.TokenType.WHITESPACE) {
                t = this.consumeToken(Token.TokenType.WHITESPACE);
            } else {
                this.pushOntoCallStack("PCData", "src/parser/FM.ccc", 1982, 10);
                throw new ParseException(this, first_set$FM_ccc$1982$10, this.parsingStack);
            }
            buf.append(t.getImage());
            if (start == null) {
                start = t;
            }
            if (prevToken == null) continue;
            this.token_source.uncacheTokens(prevToken);
        } while (this.scan$FM_ccc$1980$7());
        if (this.stripText && this.contentNesting == 1) {
            result.add(TextBlock.EMPTY_BLOCK);
            return result;
        }
        result = this.trimBlockNesting > 0 ? TextBlock.breakIntoBlocksLineByLine(buf.toString(), this.template, start.getBeginColumn(), start.getBeginLine()) : TextBlock.breakIntoBlocks(buf.toString(), this.template, start.getBeginColumn(), start.getBeginLine());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TemplateElement Content() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Content";
        MixedContent nodes = new MixedContent();
        TemplateElement elem = null;
        TemplateElement begin = null;
        ++this.contentNesting;
        List<TextBlock> text = null;
        do {
            if (this.nextTokenType() == Token.TokenType.WHITESPACE || this.nextTokenType == Token.TokenType.PRINTABLE_CHARS) {
                this.pushOntoCallStack("Content", "src/parser/FM.ccc", 2024, 10);
                try {
                    text = this.PCData();
                }
                finally {
                    this.popCallStack();
                }
                elem = null;
            } else if (this.nextTokenType() == Token.TokenType.OUTPUT_ESCAPE) {
                this.pushOntoCallStack("Content", "src/parser/FM.ccc", 2026, 10);
                try {
                    elem = this.StringOutput();
                }
                finally {
                    this.popCallStack();
                }
            } else if (this.nextTokenType() == Token.TokenType.NUMERICAL_ESCAPE) {
                this.pushOntoCallStack("Content", "src/parser/FM.ccc", 2028, 10);
                try {
                    elem = this.NumericalOutput();
                }
                finally {
                    this.popCallStack();
                }
            } else if (first_set$FM_ccc$2030$10.contains((Object)this.nextTokenType())) {
                this.pushOntoCallStack("Content", "src/parser/FM.ccc", 2030, 10);
                try {
                    elem = this.FreemarkerDirective();
                }
                finally {
                    this.popCallStack();
                }
            } else {
                this.pushOntoCallStack("Content", "src/parser/FM.ccc", 2024, 10);
                throw new ParseException(this, first_set$FM_ccc$2024$10, this.parsingStack);
            }
            if (begin == null) {
                TemplateElement templateElement = begin = elem == null ? (TemplateElement)text.get(0) : elem;
            }
            if (elem == null) {
                for (TextBlock tb : text) {
                    nodes.addElement(tb);
                }
            } else {
                nodes.addElement(elem);
            }
        } while (first_set$FM_ccc$2023$7.contains((Object)this.nextTokenType()));
        --this.contentNesting;
        if (elem == null) {
            elem = text.get(text.size() - 1);
        }
        nodes.setLocation(this.template, (TemplateLocation)begin, (TemplateLocation)elem);
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TemplateElement FreeMarkerText() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "FreeMarkerText";
        MixedContent nodes = new MixedContent();
        TemplateElement elem = null;
        TemplateElement begin = null;
        List<TextBlock> text = null;
        do {
            if (this.nextTokenType() == Token.TokenType.WHITESPACE || this.nextTokenType == Token.TokenType.PRINTABLE_CHARS) {
                this.pushOntoCallStack("FreeMarkerText", "src/parser/FM.ccc", 2064, 9);
                try {
                    text = this.PCData();
                }
                finally {
                    this.popCallStack();
                }
                elem = null;
            } else if (this.nextTokenType() == Token.TokenType.OUTPUT_ESCAPE) {
                this.pushOntoCallStack("FreeMarkerText", "src/parser/FM.ccc", 2066, 9);
                try {
                    elem = this.StringOutput();
                }
                finally {
                    this.popCallStack();
                }
            } else if (this.nextTokenType() == Token.TokenType.NUMERICAL_ESCAPE) {
                this.pushOntoCallStack("FreeMarkerText", "src/parser/FM.ccc", 2068, 9);
                try {
                    elem = this.NumericalOutput();
                }
                finally {
                    this.popCallStack();
                }
            } else {
                this.pushOntoCallStack("FreeMarkerText", "src/parser/FM.ccc", 2064, 9);
                throw new ParseException(this, first_set$FM_ccc$2064$9, this.parsingStack);
            }
            if (begin == null) {
                TemplateElement templateElement = begin = elem == null ? (TemplateElement)text.get(0) : elem;
            }
            if (elem != null) {
                nodes.addElement(elem);
                continue;
            }
            for (TextBlock tb : text) {
                nodes.addElement(tb);
            }
        } while (this.nextTokenType() == Token.TokenType.WHITESPACE || this.nextTokenType == Token.TokenType.PRINTABLE_CHARS || this.nextTokenType == Token.TokenType.OUTPUT_ESCAPE || this.nextTokenType == Token.TokenType.NUMERICAL_ESCAPE);
        if (elem == null) {
            elem = text.get(text.size() - 1);
        }
        nodes.setLocation(this.template, (TemplateLocation)begin, (TemplateLocation)elem);
        return nodes;
    }

    public final TemplateElement OptionalBlock() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "OptionalBlock";
        TemplateElement tp = TextBlock.EMPTY_BLOCK;
        if (first_set$FM_ccc$2099$10.contains((Object)this.nextTokenType())) {
            this.pushOntoCallStack("OptionalBlock", "src/parser/FM.ccc", 2099, 10);
            try {
                tp = this.Content();
            }
            finally {
                this.popCallStack();
            }
        }
        return tp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TemplateHeaderElement HeaderElement() {
        Token end;
        Token start;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "HeaderElement";
        LinkedHashMap<String, Expression> params = new LinkedHashMap<String, Expression>();
        if (this.nextTokenType() == Token.TokenType.WHITESPACE) {
            this.consumeToken(Token.TokenType.WHITESPACE);
        }
        if (this.nextTokenType() == Token.TokenType.TRIVIAL_FTL_HEADER) {
            end = start = this.consumeToken(Token.TokenType.TRIVIAL_FTL_HEADER);
        } else {
            if (this.nextTokenType() == Token.TokenType.FTL_HEADER) {
                start = this.consumeToken(Token.TokenType.FTL_HEADER);
                while (this.nextTokenType() == Token.TokenType.ID) {
                    Expression exp;
                    Token key = this.consumeToken(Token.TokenType.ID);
                    this.consumeToken(Token.TokenType.EQUALS);
                    this.pushOntoCallStack("HeaderElement", "src/parser/FM.ccc", 2122, 11);
                    try {
                        exp = this.Expression();
                    }
                    finally {
                        this.popCallStack();
                    }
                    params.put(key.getImage().toLowerCase(), exp);
                }
                this.pushOntoCallStack("HeaderElement", "src/parser/FM.ccc", 2124, 8);
                try {
                    end = this.LooseDirectiveEnd();
                }
                finally {
                    this.popCallStack();
                }
            }
            this.pushOntoCallStack("HeaderElement", "src/parser/FM.ccc", 2115, 6);
            throw new ParseException(this, first_set$FM_ccc$2115$6, this.parsingStack);
        }
        TemplateHeaderElement header = new TemplateHeaderElement(params);
        header.setLocation(this.template, start, end);
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, Expression> ParamList() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "ParamList";
        HashMap<String, Expression> result = new HashMap<String, Expression>();
        do {
            Expression exp;
            Identifier id;
            this.pushOntoCallStack("ParamList", "src/parser/FM.ccc", 2141, 7);
            try {
                id = this.Identifier();
            }
            finally {
                this.popCallStack();
            }
            this.consumeToken(Token.TokenType.EQUALS);
            this.pushOntoCallStack("ParamList", "src/parser/FM.ccc", 2143, 7);
            try {
                exp = this.Expression();
            }
            finally {
                this.popCallStack();
            }
            result.put(id.toString(), exp);
            if (this.nextTokenType() != Token.TokenType.COMMA) continue;
            this.consumeToken(Token.TokenType.COMMA);
        } while (this.nextTokenType() == Token.TokenType.ID);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TemplateElement Root() {
        TemplateElement doc;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Root";
        if (this.scan$FM_ccc$2162$7()) {
            TemplateHeaderElement header;
            this.pushOntoCallStack("Root", "src/parser/FM.ccc", 2163, 8);
            try {
                header = this.HeaderElement();
            }
            finally {
                this.popCallStack();
            }
            this.template.setHeaderElement(header);
            String templateEncoding = this.template.getEncoding();
            if (templateEncoding != null && header.hasParameter("encoding")) {
                String encoding = null;
                try {
                    encoding = header.getStringParameter("encoding");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (encoding != null && !encoding.equals(templateEncoding)) {
                    throw new Template.WrongEncodingException(encoding);
                }
            }
            if (header.hasParameter("strip_text")) {
                try {
                    this.stripText = header.getBooleanParameter("strip_text");
                }
                catch (Exception e) {
                    throw new ParseException(e.getMessage());
                }
            }
        }
        this.pushOntoCallStack("Root", "src/parser/FM.ccc", 2186, 4);
        try {
            doc = this.OptionalBlock();
        }
        finally {
            this.popCallStack();
        }
        this.consumeToken(Token.TokenType.EOF);
        doc.setParentRecursively(null);
        return doc;
    }

    private static EnumSet<Token.TokenType> first_set$FM_ccc$157$7_init() {
        return FMParser.tokenTypeSet(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.FALSE, Token.TokenType.TRUE, Token.TokenType.NULL, Token.TokenType.INTEGER, Token.TokenType.DECIMAL, Token.TokenType.DOT, Token.TokenType.OPEN_BRACKET, Token.TokenType.OPEN_PAREN, Token.TokenType.OPEN_BRACE, Token.TokenType.ID);
    }

    private static EnumSet<Token.TokenType> first_set$FM_ccc$207$4_init() {
        return FMParser.tokenTypeSet(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.FALSE, Token.TokenType.TRUE, Token.TokenType.NULL, Token.TokenType.INTEGER, Token.TokenType.DECIMAL, Token.TokenType.DOT, Token.TokenType.PLUS, Token.TokenType.MINUS, Token.TokenType.EXCLAM, Token.TokenType.OPEN_BRACKET, Token.TokenType.OPEN_PAREN, Token.TokenType.OPEN_BRACE, Token.TokenType.ID);
    }

    private static EnumSet<Token.TokenType> first_set$FM_ccc$211$4_init() {
        return FMParser.tokenTypeSet(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.FALSE, Token.TokenType.TRUE, Token.TokenType.NULL, Token.TokenType.INTEGER, Token.TokenType.DECIMAL, Token.TokenType.DOT, Token.TokenType.OPEN_BRACKET, Token.TokenType.OPEN_PAREN, Token.TokenType.OPEN_BRACE, Token.TokenType.ID);
    }

    private static EnumSet<Token.TokenType> first_set$FM_ccc$446$7_init() {
        return FMParser.tokenTypeSet(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.FALSE, Token.TokenType.TRUE, Token.TokenType.NULL, Token.TokenType.INTEGER, Token.TokenType.DECIMAL, Token.TokenType.DOT, Token.TokenType.PLUS, Token.TokenType.MINUS, Token.TokenType.EXCLAM, Token.TokenType.OPEN_BRACKET, Token.TokenType.OPEN_PAREN, Token.TokenType.OPEN_BRACE, Token.TokenType.ID);
    }

    private static EnumSet<Token.TokenType> first_set$FM_ccc$448$10_init() {
        return FMParser.tokenTypeSet(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.FALSE, Token.TokenType.TRUE, Token.TokenType.NULL, Token.TokenType.INTEGER, Token.TokenType.DECIMAL, Token.TokenType.DOT, Token.TokenType.PLUS, Token.TokenType.MINUS, Token.TokenType.EXCLAM, Token.TokenType.COMMA, Token.TokenType.OPEN_BRACKET, Token.TokenType.OPEN_PAREN, Token.TokenType.OPEN_BRACE, Token.TokenType.ID);
    }

    private static EnumSet<Token.TokenType> first_set$FM_ccc$647$7_init() {
        return FMParser.tokenTypeSet(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.FALSE, Token.TokenType.TRUE, Token.TokenType.NULL, Token.TokenType.INTEGER, Token.TokenType.DECIMAL, Token.TokenType.DOT, Token.TokenType.PLUS, Token.TokenType.MINUS, Token.TokenType.EXCLAM, Token.TokenType.OPEN_BRACKET, Token.TokenType.OPEN_PAREN, Token.TokenType.OPEN_BRACE, Token.TokenType.ID);
    }

    private static EnumSet<Token.TokenType> first_set$FM_ccc$723$8_init() {
        return FMParser.tokenTypeSet(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.FALSE, Token.TokenType.TRUE, Token.TokenType.NULL, Token.TokenType.INTEGER, Token.TokenType.DECIMAL, Token.TokenType.DOT, Token.TokenType.PLUS, Token.TokenType.MINUS, Token.TokenType.EXCLAM, Token.TokenType.OPEN_BRACKET, Token.TokenType.OPEN_PAREN, Token.TokenType.OPEN_BRACE, Token.TokenType.ID);
    }

    private static EnumSet<Token.TokenType> first_set$FM_ccc$953$13_init() {
        return FMParser.tokenTypeSet(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.FALSE, Token.TokenType.TRUE, Token.TokenType.NULL, Token.TokenType.INTEGER, Token.TokenType.DECIMAL, Token.TokenType.DOT, Token.TokenType.PLUS, Token.TokenType.MINUS, Token.TokenType.EXCLAM, Token.TokenType.OPEN_BRACKET, Token.TokenType.OPEN_PAREN, Token.TokenType.OPEN_BRACE, Token.TokenType.ID);
    }

    private static EnumSet<Token.TokenType> first_set$FM_ccc$1406$5_init() {
        return FMParser.tokenTypeSet(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.FALSE, Token.TokenType.TRUE, Token.TokenType.NULL, Token.TokenType.INTEGER, Token.TokenType.DECIMAL, Token.TokenType.DOT, Token.TokenType.PLUS, Token.TokenType.MINUS, Token.TokenType.EXCLAM, Token.TokenType.COMMA, Token.TokenType.OPEN_BRACKET, Token.TokenType.OPEN_PAREN, Token.TokenType.OPEN_BRACE, Token.TokenType.ID);
    }

    private static EnumSet<Token.TokenType> first_set$FM_ccc$1447$5_init() {
        return FMParser.tokenTypeSet(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.FALSE, Token.TokenType.TRUE, Token.TokenType.NULL, Token.TokenType.INTEGER, Token.TokenType.DECIMAL, Token.TokenType.DOT, Token.TokenType.PLUS, Token.TokenType.MINUS, Token.TokenType.EXCLAM, Token.TokenType.OPEN_BRACKET, Token.TokenType.OPEN_PAREN, Token.TokenType.OPEN_BRACE, Token.TokenType.ID);
    }

    private static EnumSet<Token.TokenType> first_set$FM_ccc$1450$8_init() {
        return FMParser.tokenTypeSet(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.FALSE, Token.TokenType.TRUE, Token.TokenType.NULL, Token.TokenType.INTEGER, Token.TokenType.DECIMAL, Token.TokenType.DOT, Token.TokenType.PLUS, Token.TokenType.MINUS, Token.TokenType.EXCLAM, Token.TokenType.OPEN_BRACKET, Token.TokenType.OPEN_PAREN, Token.TokenType.OPEN_BRACE, Token.TokenType.ID);
    }

    private static EnumSet<Token.TokenType> first_set$FM_ccc$1480$6_init() {
        return FMParser.tokenTypeSet(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.FALSE, Token.TokenType.TRUE, Token.TokenType.NULL, Token.TokenType.INTEGER, Token.TokenType.DECIMAL, Token.TokenType.DOT, Token.TokenType.PLUS, Token.TokenType.MINUS, Token.TokenType.EXCLAM, Token.TokenType.OPEN_BRACKET, Token.TokenType.OPEN_PAREN, Token.TokenType.OPEN_BRACE, Token.TokenType.ID);
    }

    private static EnumSet<Token.TokenType> first_set$FM_ccc$1902$6_init() {
        return FMParser.tokenTypeSet(Token.TokenType._ATTEMPT, Token.TokenType.BLOCKTRIM, Token.TokenType.BLOCKTRIML, Token.TokenType.BLOCKTRIMR, Token.TokenType.BLOCKNOTRIM, Token.TokenType.IF, Token.TokenType.LIST, Token.TokenType.FOREACH, Token.TokenType.SWITCH, Token.TokenType.ASSIGN, Token.TokenType.GLOBALASSIGN, Token.TokenType.LOCALASSIGN, Token.TokenType.SET, Token.TokenType._INCLUDE, Token.TokenType.IMPORT, Token.TokenType.FUNCTION, Token.TokenType.MACRO, Token.TokenType.TRANSFORM, Token.TokenType.VISIT, Token.TokenType.STOP, Token.TokenType.RETURN, Token.TokenType.CALL, Token.TokenType.SETTING, Token.TokenType.EMBED, Token.TokenType.VAR, Token.TokenType.COMPRESS, Token.TokenType.COMMENT, Token.TokenType.TERSE_COMMENT, Token.TokenType.NOPARSE, Token.TokenType.BREAK, Token.TokenType.SIMPLE_RETURN, Token.TokenType.HALT, Token.TokenType.FLUSH, Token.TokenType.TRIM, Token.TokenType.LTRIM, Token.TokenType.RTRIM, Token.TokenType.NOTRIM, Token.TokenType.SIMPLE_NESTED, Token.TokenType.NESTED, Token.TokenType.SIMPLE_RECURSE, Token.TokenType.RECURSE, Token.TokenType.FALLBACK, Token.TokenType.ESCAPE, Token.TokenType.NOESCAPE, Token.TokenType.UNIFIED_CALL);
    }

    private static EnumSet<Token.TokenType> first_set$FM_ccc$2023$7_init() {
        return FMParser.tokenTypeSet(Token.TokenType._ATTEMPT, Token.TokenType.BLOCKTRIM, Token.TokenType.BLOCKTRIML, Token.TokenType.BLOCKTRIMR, Token.TokenType.BLOCKNOTRIM, Token.TokenType.IF, Token.TokenType.LIST, Token.TokenType.FOREACH, Token.TokenType.SWITCH, Token.TokenType.ASSIGN, Token.TokenType.GLOBALASSIGN, Token.TokenType.LOCALASSIGN, Token.TokenType.SET, Token.TokenType._INCLUDE, Token.TokenType.IMPORT, Token.TokenType.FUNCTION, Token.TokenType.MACRO, Token.TokenType.TRANSFORM, Token.TokenType.VISIT, Token.TokenType.STOP, Token.TokenType.RETURN, Token.TokenType.CALL, Token.TokenType.SETTING, Token.TokenType.EMBED, Token.TokenType.VAR, Token.TokenType.COMPRESS, Token.TokenType.COMMENT, Token.TokenType.TERSE_COMMENT, Token.TokenType.NOPARSE, Token.TokenType.BREAK, Token.TokenType.SIMPLE_RETURN, Token.TokenType.HALT, Token.TokenType.FLUSH, Token.TokenType.TRIM, Token.TokenType.LTRIM, Token.TokenType.RTRIM, Token.TokenType.NOTRIM, Token.TokenType.SIMPLE_NESTED, Token.TokenType.NESTED, Token.TokenType.SIMPLE_RECURSE, Token.TokenType.RECURSE, Token.TokenType.FALLBACK, Token.TokenType.ESCAPE, Token.TokenType.NOESCAPE, Token.TokenType.UNIFIED_CALL, Token.TokenType.WHITESPACE, Token.TokenType.PRINTABLE_CHARS, Token.TokenType.OUTPUT_ESCAPE, Token.TokenType.NUMERICAL_ESCAPE);
    }

    private static EnumSet<Token.TokenType> first_set$FM_ccc$2024$10_init() {
        return FMParser.tokenTypeSet(Token.TokenType._ATTEMPT, Token.TokenType.BLOCKTRIM, Token.TokenType.BLOCKTRIML, Token.TokenType.BLOCKTRIMR, Token.TokenType.BLOCKNOTRIM, Token.TokenType.IF, Token.TokenType.LIST, Token.TokenType.FOREACH, Token.TokenType.SWITCH, Token.TokenType.ASSIGN, Token.TokenType.GLOBALASSIGN, Token.TokenType.LOCALASSIGN, Token.TokenType.SET, Token.TokenType._INCLUDE, Token.TokenType.IMPORT, Token.TokenType.FUNCTION, Token.TokenType.MACRO, Token.TokenType.TRANSFORM, Token.TokenType.VISIT, Token.TokenType.STOP, Token.TokenType.RETURN, Token.TokenType.CALL, Token.TokenType.SETTING, Token.TokenType.EMBED, Token.TokenType.VAR, Token.TokenType.COMPRESS, Token.TokenType.COMMENT, Token.TokenType.TERSE_COMMENT, Token.TokenType.NOPARSE, Token.TokenType.BREAK, Token.TokenType.SIMPLE_RETURN, Token.TokenType.HALT, Token.TokenType.FLUSH, Token.TokenType.TRIM, Token.TokenType.LTRIM, Token.TokenType.RTRIM, Token.TokenType.NOTRIM, Token.TokenType.SIMPLE_NESTED, Token.TokenType.NESTED, Token.TokenType.SIMPLE_RECURSE, Token.TokenType.RECURSE, Token.TokenType.FALLBACK, Token.TokenType.ESCAPE, Token.TokenType.NOESCAPE, Token.TokenType.UNIFIED_CALL, Token.TokenType.WHITESPACE, Token.TokenType.PRINTABLE_CHARS, Token.TokenType.OUTPUT_ESCAPE, Token.TokenType.NUMERICAL_ESCAPE);
    }

    private static EnumSet<Token.TokenType> first_set$FM_ccc$2030$10_init() {
        return FMParser.tokenTypeSet(Token.TokenType._ATTEMPT, Token.TokenType.BLOCKTRIM, Token.TokenType.BLOCKTRIML, Token.TokenType.BLOCKTRIMR, Token.TokenType.BLOCKNOTRIM, Token.TokenType.IF, Token.TokenType.LIST, Token.TokenType.FOREACH, Token.TokenType.SWITCH, Token.TokenType.ASSIGN, Token.TokenType.GLOBALASSIGN, Token.TokenType.LOCALASSIGN, Token.TokenType.SET, Token.TokenType._INCLUDE, Token.TokenType.IMPORT, Token.TokenType.FUNCTION, Token.TokenType.MACRO, Token.TokenType.TRANSFORM, Token.TokenType.VISIT, Token.TokenType.STOP, Token.TokenType.RETURN, Token.TokenType.CALL, Token.TokenType.SETTING, Token.TokenType.EMBED, Token.TokenType.VAR, Token.TokenType.COMPRESS, Token.TokenType.COMMENT, Token.TokenType.TERSE_COMMENT, Token.TokenType.NOPARSE, Token.TokenType.BREAK, Token.TokenType.SIMPLE_RETURN, Token.TokenType.HALT, Token.TokenType.FLUSH, Token.TokenType.TRIM, Token.TokenType.LTRIM, Token.TokenType.RTRIM, Token.TokenType.NOTRIM, Token.TokenType.SIMPLE_NESTED, Token.TokenType.NESTED, Token.TokenType.SIMPLE_RECURSE, Token.TokenType.RECURSE, Token.TokenType.FALLBACK, Token.TokenType.ESCAPE, Token.TokenType.NOESCAPE, Token.TokenType.UNIFIED_CALL);
    }

    private static EnumSet<Token.TokenType> first_set$FM_ccc$2099$10_init() {
        return FMParser.tokenTypeSet(Token.TokenType._ATTEMPT, Token.TokenType.BLOCKTRIM, Token.TokenType.BLOCKTRIML, Token.TokenType.BLOCKTRIMR, Token.TokenType.BLOCKNOTRIM, Token.TokenType.IF, Token.TokenType.LIST, Token.TokenType.FOREACH, Token.TokenType.SWITCH, Token.TokenType.ASSIGN, Token.TokenType.GLOBALASSIGN, Token.TokenType.LOCALASSIGN, Token.TokenType.SET, Token.TokenType._INCLUDE, Token.TokenType.IMPORT, Token.TokenType.FUNCTION, Token.TokenType.MACRO, Token.TokenType.TRANSFORM, Token.TokenType.VISIT, Token.TokenType.STOP, Token.TokenType.RETURN, Token.TokenType.CALL, Token.TokenType.SETTING, Token.TokenType.EMBED, Token.TokenType.VAR, Token.TokenType.COMPRESS, Token.TokenType.COMMENT, Token.TokenType.TERSE_COMMENT, Token.TokenType.NOPARSE, Token.TokenType.BREAK, Token.TokenType.SIMPLE_RETURN, Token.TokenType.HALT, Token.TokenType.FLUSH, Token.TokenType.TRIM, Token.TokenType.LTRIM, Token.TokenType.RTRIM, Token.TokenType.NOTRIM, Token.TokenType.SIMPLE_NESTED, Token.TokenType.NESTED, Token.TokenType.SIMPLE_RECURSE, Token.TokenType.RECURSE, Token.TokenType.FALLBACK, Token.TokenType.ESCAPE, Token.TokenType.NOESCAPE, Token.TokenType.UNIFIED_CALL, Token.TokenType.WHITESPACE, Token.TokenType.PRINTABLE_CHARS, Token.TokenType.OUTPUT_ESCAPE, Token.TokenType.NUMERICAL_ESCAPE);
    }

    private final boolean scanToken(Token.TokenType expectedType, Token.TokenType ... additionalTypes) {
        Token peekedToken = this.nextToken(this.currentLookaheadToken);
        Token.TokenType type = peekedToken.getType();
        if (type != expectedType) {
            boolean matched = false;
            for (Token.TokenType tt : additionalTypes) {
                if (type != tt) continue;
                matched = true;
                break;
            }
            if (!matched) {
                return false;
            }
        }
        --this.remainingLookahead;
        this.currentLookaheadToken = peekedToken;
        return true;
    }

    private final boolean scanToken(EnumSet<Token.TokenType> types) {
        Token peekedToken = this.nextToken(this.currentLookaheadToken);
        Token.TokenType type = peekedToken.getType();
        if (!types.contains((Object)type)) {
            return false;
        }
        --this.remainingLookahead;
        this.currentLookaheadToken = peekedToken;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$159$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("PrimaryExpression", "src/parser/FM.ccc", 159, 7);
            this.currentLookaheadProduction = "HashLiteral";
            try {
                if (!this.check$HashLiteral(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$167$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("PrimaryExpression", "src/parser/FM.ccc", 167, 7);
            this.currentLookaheadProduction = "ListLiteral";
            try {
                if (!this.check$ListLiteral(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$171$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("PrimaryExpression", "src/parser/FM.ccc", 171, 7);
            this.currentLookaheadProduction = "Parenthesis";
            try {
                if (!this.check$Parenthesis(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$173$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("PrimaryExpression", "src/parser/FM.ccc", 173, 7);
            this.currentLookaheadProduction = "BuiltinVariable";
            try {
                if (!this.check$BuiltinVariable(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$176$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("PrimaryExpression", "src/parser/FM.ccc", 176, 7);
            this.currentLookaheadProduction = "AddSubExpression";
            try {
                if (!this.check$AddSubExpression(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$207$4$(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("UnaryExpression", "src/parser/FM.ccc", 207, 4);
            this.currentLookaheadProduction = "UnaryPlusMinusExpression";
            try {
                if (!this.check$UnaryPlusMinusExpression(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$209$4(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("UnaryExpression", "src/parser/FM.ccc", 209, 4);
            this.currentLookaheadProduction = "NotExpression";
            try {
                if (!this.check$NotExpression(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$211$4(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("UnaryExpression", "src/parser/FM.ccc", 211, 4);
            this.currentLookaheadProduction = "PrimaryExpression";
            try {
                if (!this.check$PrimaryExpression(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$265$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.PLUS, Token.TokenType.MINUS)) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("AdditiveExpression", "src/parser/FM.ccc", 270, 7);
            this.currentLookaheadProduction = "MultiplicativeExpression";
            try {
                if (!this.check$MultiplicativeExpression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$301$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.TIMES, Token.TokenType.DIVIDE, Token.TokenType.PERCENT)) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("MultiplicativeExpression", "src/parser/FM.ccc", 308, 7);
            this.currentLookaheadProduction = "UnaryExpression";
            try {
                if (!this.check$UnaryExpression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$328$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.EQUALS, Token.TokenType.DOUBLE_EQUALS, Token.TokenType.NOT_EQUALS)) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("EqualityExpression", "src/parser/FM.ccc", 335, 6);
            this.currentLookaheadProduction = "RelationalExpression";
            try {
                if (!this.check$RelationalExpression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$353$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(first_set$FM_ccc$354$7)) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("RelationalExpression", "src/parser/FM.ccc", 366, 6);
            this.currentLookaheadProduction = "RangeExpression";
            try {
                if (!this.check$RangeExpression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$383$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.DOT_DOT, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token3875 = this.currentLookaheadToken;
            boolean passedPredicate3875 = this.passedPredicate;
            this.passedPredicate = false;
            try {
                if (!this.check$FM_ccc$384$10(false)) {
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token3875;
                    this.hitFailure = false;
                }
            }
            finally {
                this.passedPredicate = passedPredicate3875;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$384$10(boolean scanToEnd) {
        int prevPassedPredicateThreshold = this.passedPredicateThreshold;
        this.passedPredicateThreshold = -1;
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("RangeExpression", "src/parser/FM.ccc", 384, 10);
            this.currentLookaheadProduction = "AdditiveExpression";
            try {
                if (!this.check$AdditiveExpression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (!scanToEnd && this.lookaheadStack.size() <= 1) {
                if (this.lookaheadRoutineNesting == 0) {
                    this.remainingLookahead = 0;
                } else if (this.lookaheadStack.size() == 1) {
                    this.passedPredicateThreshold = this.remainingLookahead;
                }
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if (this.remainingLookahead <= this.passedPredicateThreshold) {
                this.passedPredicate = true;
                this.passedPredicateThreshold = prevPassedPredicateThreshold;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$407$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.AND, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("AndExpression", "src/parser/FM.ccc", 408, 7);
            this.currentLookaheadProduction = "EqualityExpression";
            try {
                if (!this.check$EqualityExpression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$426$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.OR, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("OrExpression", "src/parser/FM.ccc", 427, 7);
            this.currentLookaheadProduction = "AndExpression";
            try {
                if (!this.check$AndExpression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$FM_ccc$446$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("ListLiteral", "src/parser/FM.ccc", 446, 7);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            boolean passedPredicate3891 = this.passedPredicate;
            try {
                while (this.remainingLookahead > 0 && !this.hitFailure) {
                    Token token3892 = this.currentLookaheadToken;
                    this.passedPredicate = false;
                    if (this.check$FM_ccc$448$10(false)) continue;
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token3892;
                    break;
                }
            }
            finally {
                this.passedPredicate = passedPredicate3891;
            }
            this.hitFailure = false;
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$448$10(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token3895 = this.currentLookaheadToken;
            boolean passedPredicate3895 = this.passedPredicate;
            this.passedPredicate = false;
            try {
                if (!this.scanToken(Token.TokenType.COMMA, new Token.TokenType[0])) {
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token3895;
                    this.hitFailure = false;
                }
            }
            finally {
                this.passedPredicate = passedPredicate3895;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("ListLiteral", "src/parser/FM.ccc", 449, 10);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$534$8$(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("AddSubExpression", "src/parser/FM.ccc", 534, 8);
            this.currentLookaheadProduction = "DotVariable";
            try {
                if (!this.check$DotVariable(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$536$8(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("AddSubExpression", "src/parser/FM.ccc", 536, 8);
            this.currentLookaheadProduction = "DynamicKey";
            try {
                if (!this.check$DynamicKey(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$538$8(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("AddSubExpression", "src/parser/FM.ccc", 538, 8);
            this.currentLookaheadProduction = "MethodArgs";
            try {
                if (!this.check$MethodArgs(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$540$8(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("AddSubExpression", "src/parser/FM.ccc", 540, 8);
            this.currentLookaheadProduction = "BuiltIn";
            try {
                if (!this.check$BuiltIn(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$544$8(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("AddSubExpression", "src/parser/FM.ccc", 544, 8);
            this.currentLookaheadProduction = "DefaultTo";
            try {
                if (!this.check$DefaultTo(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$559$10(boolean scanToEnd) {
        int prevPassedPredicateThreshold = this.passedPredicateThreshold;
        this.passedPredicateThreshold = -1;
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("DefaultTo", "src/parser/FM.ccc", 560, 13);
            this.currentLookaheadProduction = "PrimaryExpression";
            try {
                if (!this.check$PrimaryExpression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (!scanToEnd && this.lookaheadStack.size() <= 1) {
                if (this.lookaheadRoutineNesting == 0) {
                    this.remainingLookahead = 0;
                } else if (this.lookaheadStack.size() == 1) {
                    this.passedPredicateThreshold = this.remainingLookahead;
                }
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if (this.remainingLookahead <= this.passedPredicateThreshold) {
                this.passedPredicate = true;
                this.passedPredicateThreshold = prevPassedPredicateThreshold;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$647$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("MethodArgs", "src/parser/FM.ccc", 647, 7);
            this.currentLookaheadProduction = "ArgsList";
            try {
                if (!this.check$ArgsList(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$FM_ccc$723$8(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("HashLiteral", "src/parser/FM.ccc", 723, 8);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.COMMA, Token.TokenType.COLON)) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("HashLiteral", "src/parser/FM.ccc", 725, 8);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            boolean passedPredicate3925 = this.passedPredicate;
            try {
                while (this.remainingLookahead > 0 && !this.hitFailure) {
                    Token token3926 = this.currentLookaheadToken;
                    this.passedPredicate = false;
                    if (this.check$FM_ccc$731$11(false)) continue;
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token3926;
                    break;
                }
            }
            finally {
                this.passedPredicate = passedPredicate3925;
            }
            this.hitFailure = false;
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$731$11(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.COMMA, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("HashLiteral", "src/parser/FM.ccc", 732, 12);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.COMMA, Token.TokenType.COLON)) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("HashLiteral", "src/parser/FM.ccc", 734, 12);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$776$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.SEMICOLON, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.ID, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$806$8(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.ELSE_IF, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("If", "src/parser/FM.ccc", 807, 8);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.DIRECTIVE_END)) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("If", "src/parser/FM.ccc", 809, 8);
            this.currentLookaheadProduction = "OptionalBlock";
            try {
                if (!this.check$OptionalBlock(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$817$10(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.ELSE, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("If", "src/parser/FM.ccc", 818, 10);
            this.currentLookaheadProduction = "OptionalBlock";
            try {
                if (!this.check$OptionalBlock(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$931$8(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.USING, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Visit", "src/parser/FM.ccc", 932, 8);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$950$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.RECURSE, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token3957 = this.currentLookaheadToken;
            boolean passedPredicate3957 = this.passedPredicate;
            this.passedPredicate = false;
            try {
                if (!this.check$FM_ccc$953$13(false)) {
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token3957;
                    this.hitFailure = false;
                }
            }
            finally {
                this.passedPredicate = passedPredicate3957;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token3959 = this.currentLookaheadToken;
            boolean passedPredicate3959 = this.passedPredicate;
            this.passedPredicate = false;
            try {
                if (!this.check$FM_ccc$956$13(false)) {
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token3959;
                    this.hitFailure = false;
                }
            }
            finally {
                this.passedPredicate = passedPredicate3959;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.DIRECTIVE_END)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$953$13(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Recurse", "src/parser/FM.ccc", 953, 13);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$956$13(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.USING, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Recurse", "src/parser/FM.ccc", 957, 13);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1009$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.RETURN, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Return", "src/parser/FM.ccc", 1010, 7);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.DIRECTIVE_END)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1028$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.STOP, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Stop", "src/parser/FM.ccc", 1028, 20);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.DIRECTIVE_END)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1052$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.NESTED, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Nested", "src/parser/FM.ccc", 1054, 11);
            this.currentLookaheadProduction = "PositionalArgsList";
            try {
                if (!this.check$PositionalArgsList(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.DIRECTIVE_END)) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$FM_ccc$1125$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.EQUALS, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Assign", "src/parser/FM.ccc", 1127, 8);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            boolean passedPredicate4006 = this.passedPredicate;
            try {
                while (this.remainingLookahead > 0 && !this.hitFailure) {
                    Token token4007 = this.currentLookaheadToken;
                    this.passedPredicate = false;
                    if (this.check$FM_ccc$1130$13(false)) continue;
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token4007;
                    break;
                }
            }
            finally {
                this.passedPredicate = passedPredicate4006;
            }
            this.hitFailure = false;
            if (this.hitFailure) {
                boolean token4007 = false;
                return token4007;
            }
            if (this.remainingLookahead <= 0) {
                boolean token4007 = true;
                return token4007;
            }
            Token token4009 = this.currentLookaheadToken;
            boolean passedPredicate4009 = this.passedPredicate;
            this.passedPredicate = false;
            try {
                if (!this.check$FM_ccc$1142$11(false)) {
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token4009;
                    this.hitFailure = false;
                }
            }
            finally {
                this.passedPredicate = passedPredicate4009;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.DIRECTIVE_END)) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1130$13(boolean scanToEnd) {
        int prevPassedPredicateThreshold = this.passedPredicateThreshold;
        this.passedPredicateThreshold = -1;
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token4025 = this.currentLookaheadToken;
            boolean passedPredicate4025 = this.passedPredicate;
            this.passedPredicate = false;
            try {
                if (!this.scanToken(Token.TokenType.COMMA, new Token.TokenType[0])) {
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token4025;
                    this.hitFailure = false;
                }
            }
            finally {
                this.passedPredicate = passedPredicate4025;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.ID)) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.EQUALS, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (!scanToEnd && this.lookaheadStack.size() <= 1) {
                if (this.lookaheadRoutineNesting == 0) {
                    this.remainingLookahead = 0;
                } else if (this.lookaheadStack.size() == 1) {
                    this.passedPredicateThreshold = this.remainingLookahead;
                }
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Assign", "src/parser/FM.ccc", 1136, 13);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if (this.remainingLookahead <= this.passedPredicateThreshold) {
                this.passedPredicate = true;
                this.passedPredicateThreshold = prevPassedPredicateThreshold;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1142$11(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.IN, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Assign", "src/parser/FM.ccc", 1143, 11);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1160$5(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token4039 = this.currentLookaheadToken;
            boolean passedPredicate4039 = this.passedPredicate;
            this.passedPredicate = false;
            try {
                if (!this.check$FM_ccc$1162$11(false)) {
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token4039;
                    this.hitFailure = false;
                }
            }
            finally {
                this.passedPredicate = passedPredicate4039;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.DIRECTIVE_END, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Assign", "src/parser/FM.ccc", 1166, 8);
            this.currentLookaheadProduction = "OptionalBlock";
            try {
                if (!this.check$OptionalBlock(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.CLOSE_DIRECTIVE_BLOCK, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1162$11(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.IN, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Assign", "src/parser/FM.ccc", 1163, 11);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1196$4(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.ID, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.EQUALS, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Include", "src/parser/FM.ccc", 1198, 4);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1259$11(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.ID, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token4064 = this.currentLookaheadToken;
            boolean passedPredicate4064 = this.passedPredicate;
            this.passedPredicate = false;
            try {
                if (!this.scanToken(Token.TokenType.ELLIPSIS, new Token.TokenType[0])) {
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token4064;
                    this.hitFailure = false;
                }
            }
            finally {
                this.passedPredicate = passedPredicate4064;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token4066 = this.currentLookaheadToken;
            boolean passedPredicate4066 = this.passedPredicate;
            this.passedPredicate = false;
            try {
                if (!this.check$FM_ccc$1272$13(false)) {
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token4066;
                    this.hitFailure = false;
                }
            }
            finally {
                this.passedPredicate = passedPredicate4066;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token4068 = this.currentLookaheadToken;
            boolean passedPredicate4068 = this.passedPredicate;
            this.passedPredicate = false;
            try {
                if (!this.scanToken(Token.TokenType.COMMA, new Token.TokenType[0])) {
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token4068;
                    this.hitFailure = false;
                }
            }
            finally {
                this.passedPredicate = passedPredicate4068;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1272$13(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.EQUALS, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("ParameterList", "src/parser/FM.ccc", 1273, 12);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1406$5(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token4086 = this.currentLookaheadToken;
            boolean passedPredicate4086 = this.passedPredicate;
            this.passedPredicate = false;
            try {
                if (!this.scanToken(Token.TokenType.COMMA, new Token.TokenType[0])) {
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token4086;
                    this.hitFailure = false;
                }
            }
            finally {
                this.passedPredicate = passedPredicate4086;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("PositionalArgsList", "src/parser/FM.ccc", 1407, 5);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1428$5(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token4091 = this.currentLookaheadToken;
            boolean passedPredicate4091 = this.passedPredicate;
            this.passedPredicate = false;
            try {
                if (!this.scanToken(Token.TokenType.COMMA, new Token.TokenType[0])) {
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token4091;
                    this.hitFailure = false;
                }
            }
            finally {
                this.passedPredicate = passedPredicate4091;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.ID, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.EQUALS, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("NamedArgsList", "src/parser/FM.ccc", 1431, 5);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1447$5(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - Integer.MAX_VALUE;
        try {
            ++this.lookaheadRoutineNesting;
            if (this.remainingLookahead <= 0) {
                this.passedPredicate = true;
                boolean bl = !this.hitFailure;
                return bl;
            }
            if (!this.check$FM_ccc$1447$10(true)) {
                boolean bl = false;
                return bl;
            }
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("ArgsList", "src/parser/FM.ccc", 1448, 8);
            this.currentLookaheadProduction = "NamedArgsList";
            try {
                if (!this.check$NamedArgsList(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1450$8(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("ArgsList", "src/parser/FM.ccc", 1450, 8);
            this.currentLookaheadProduction = "PositionalArgsList";
            try {
                if (!this.check$PositionalArgsList(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1480$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("UnifiedMacroTransform", "src/parser/FM.ccc", 1480, 6);
            this.currentLookaheadProduction = "ArgsList";
            try {
                if (!this.check$ArgsList(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1489$8(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.SEMICOLON, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token4107 = this.currentLookaheadToken;
            boolean passedPredicate4107 = this.passedPredicate;
            this.passedPredicate = false;
            try {
                if (!this.scanToken(Token.TokenType.TERMINATING_WHITESPACE, new Token.TokenType[0])) {
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token4107;
                    this.hitFailure = false;
                }
            }
            finally {
                this.passedPredicate = passedPredicate4107;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("UnifiedMacroTransform", "src/parser/FM.ccc", 1490, 8);
            this.currentLookaheadProduction = "ParameterList";
            try {
                if (!this.check$ParameterList(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1498$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.DIRECTIVE_END, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("UnifiedMacroTransform", "src/parser/FM.ccc", 1500, 3);
            this.currentLookaheadProduction = "OptionalBlock";
            try {
                if (!this.check$OptionalBlock(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.UNIFIED_CALL_END, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1648$8(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.ID, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.EQUALS, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Transform", "src/parser/FM.ccc", 1650, 8);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1659$8(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.DIRECTIVE_END, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Transform", "src/parser/FM.ccc", 1661, 11);
            this.currentLookaheadProduction = "OptionalBlock";
            try {
                if (!this.check$OptionalBlock(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.CLOSE_DIRECTIVE_BLOCK, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1683$5(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token4143 = this.currentLookaheadToken;
            int remainingLookahead4143 = this.remainingLookahead;
            boolean hitFailure4143 = this.hitFailure;
            boolean passedPredicate4143 = this.passedPredicate;
            try {
                this.passedPredicate = false;
                if (!this.scanToken(Token.TokenType.WHITESPACE, new Token.TokenType[0])) {
                    this.currentLookaheadToken = token4143;
                    this.remainingLookahead = remainingLookahead4143;
                    this.hitFailure = hitFailure4143;
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.passedPredicate = false;
                    if (!this.check$FM_ccc$1683$18(false)) {
                        this.currentLookaheadToken = token4143;
                        this.remainingLookahead = remainingLookahead4143;
                        this.hitFailure = hitFailure4143;
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            finally {
                this.passedPredicate = passedPredicate4143;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1683$18(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Switch", "src/parser/FM.ccc", 1683, 18);
            this.currentLookaheadProduction = "Comment";
            try {
                if (!this.check$Comment(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1688$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 2;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Switch", "src/parser/FM.ccc", 1688, 16);
            this.currentLookaheadProduction = "Case";
            try {
                if (!this.check$Case(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1715$7$(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.CASE, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Case", "src/parser/FM.ccc", 1716, 7);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.DIRECTIVE_END, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1865$8(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.EQUALS, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Var", "src/parser/FM.ccc", 1866, 8);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1874$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token4162 = this.currentLookaheadToken;
            boolean passedPredicate4162 = this.passedPredicate;
            this.passedPredicate = false;
            try {
                if (!this.scanToken(Token.TokenType.COMMA, new Token.TokenType[0])) {
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token4162;
                    this.hitFailure = false;
                }
            }
            finally {
                this.passedPredicate = passedPredicate4162;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.ID)) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token4165 = this.currentLookaheadToken;
            boolean passedPredicate4165 = this.passedPredicate;
            this.passedPredicate = false;
            try {
                if (!this.check$FM_ccc$1878$12(false)) {
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token4165;
                    this.hitFailure = false;
                }
            }
            finally {
                this.passedPredicate = passedPredicate4165;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1878$12(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.EQUALS, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Var", "src/parser/FM.ccc", 1879, 12);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1902$6$(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1902, 6);
            this.currentLookaheadProduction = "If";
            try {
                if (!this.check$If(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1904$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1904, 6);
            this.currentLookaheadProduction = "List";
            try {
                if (!this.check$List(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1906$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1906, 6);
            this.currentLookaheadProduction = "ForEach";
            try {
                if (!this.check$ForEach(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1908$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1908, 6);
            this.currentLookaheadProduction = "Assign";
            try {
                if (!this.check$Assign(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1910$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1910, 6);
            this.currentLookaheadProduction = "Include";
            try {
                if (!this.check$Include(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1912$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1912, 6);
            this.currentLookaheadProduction = "Import";
            try {
                if (!this.check$Import(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1914$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1914, 6);
            this.currentLookaheadProduction = "Macro";
            try {
                if (!this.check$Macro(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1916$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1916, 6);
            this.currentLookaheadProduction = "Compress";
            try {
                if (!this.check$Compress(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1918$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1918, 6);
            this.currentLookaheadProduction = "UnifiedMacroTransform";
            try {
                if (!this.check$UnifiedMacroTransform(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1920$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1920, 6);
            this.currentLookaheadProduction = "Call";
            try {
                if (!this.check$Call(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1922$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1922, 6);
            this.currentLookaheadProduction = "TerseComment";
            try {
                if (!this.check$TerseComment(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1924$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1924, 6);
            this.currentLookaheadProduction = "Comment";
            try {
                if (!this.check$Comment(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1926$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1926, 6);
            this.currentLookaheadProduction = "NoParse";
            try {
                if (!this.check$NoParse(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1928$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1928, 6);
            this.currentLookaheadProduction = "Transform";
            try {
                if (!this.check$Transform(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1930$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1930, 6);
            this.currentLookaheadProduction = "Switch";
            try {
                if (!this.check$Switch(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1932$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1932, 6);
            this.currentLookaheadProduction = "Setting";
            try {
                if (!this.check$Setting(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1934$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1934, 6);
            this.currentLookaheadProduction = "Var";
            try {
                if (!this.check$Var(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1938$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1938, 6);
            this.currentLookaheadProduction = "Return";
            try {
                if (!this.check$Return(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1940$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1940, 6);
            this.currentLookaheadProduction = "Stop";
            try {
                if (!this.check$Stop(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1946$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1946, 6);
            this.currentLookaheadProduction = "Nested";
            try {
                if (!this.check$Nested(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1948$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1948, 6);
            this.currentLookaheadProduction = "Escape";
            try {
                if (!this.check$Escape(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1950$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1950, 6);
            this.currentLookaheadProduction = "NoEscape";
            try {
                if (!this.check$NoEscape(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1952$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1952, 6);
            this.currentLookaheadProduction = "TrimBlock";
            try {
                if (!this.check$TrimBlock(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1954$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1954, 6);
            this.currentLookaheadProduction = "Visit";
            try {
                if (!this.check$Visit(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1956$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1956, 6);
            this.currentLookaheadProduction = "Recurse";
            try {
                if (!this.check$Recurse(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1960$6(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("FreemarkerDirective", "src/parser/FM.ccc", 1960, 6);
            this.currentLookaheadProduction = "Attempt";
            try {
                if (!this.check$Attempt(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1980$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - Integer.MAX_VALUE;
        try {
            ++this.lookaheadRoutineNesting;
            if (this.remainingLookahead <= 0) {
                this.passedPredicate = true;
                boolean bl = !this.hitFailure;
                return bl;
            }
            if (!this.check$FM_ccc$1980$12(true)) {
                boolean bl = false;
                return bl;
            }
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.WHITESPACE, Token.TokenType.PRINTABLE_CHARS)) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$2023$7(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token4237 = this.currentLookaheadToken;
            int remainingLookahead4237 = this.remainingLookahead;
            boolean hitFailure4237 = this.hitFailure;
            boolean passedPredicate4237 = this.passedPredicate;
            try {
                this.passedPredicate = false;
                if (!this.check$FM_ccc$2024$10(false)) {
                    this.currentLookaheadToken = token4237;
                    this.remainingLookahead = remainingLookahead4237;
                    this.hitFailure = hitFailure4237;
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.passedPredicate = false;
                    if (!this.check$FM_ccc$2026$10(false)) {
                        this.currentLookaheadToken = token4237;
                        this.remainingLookahead = remainingLookahead4237;
                        this.hitFailure = hitFailure4237;
                        if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                            boolean bl = false;
                            return bl;
                        }
                        this.passedPredicate = false;
                        if (!this.check$FM_ccc$2028$10(false)) {
                            this.currentLookaheadToken = token4237;
                            this.remainingLookahead = remainingLookahead4237;
                            this.hitFailure = hitFailure4237;
                            if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                boolean bl = false;
                                return bl;
                            }
                            this.passedPredicate = false;
                            if (!this.check$FM_ccc$2030$10(false)) {
                                this.currentLookaheadToken = token4237;
                                this.remainingLookahead = remainingLookahead4237;
                                this.hitFailure = hitFailure4237;
                                boolean bl = false;
                                return bl;
                            }
                        }
                    }
                }
            }
            finally {
                this.passedPredicate = passedPredicate4237;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$2024$10(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Content", "src/parser/FM.ccc", 2024, 10);
            this.currentLookaheadProduction = "PCData";
            try {
                if (!this.check$PCData(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$2026$10(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Content", "src/parser/FM.ccc", 2026, 10);
            this.currentLookaheadProduction = "StringOutput";
            try {
                if (!this.check$StringOutput(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$2028$10(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Content", "src/parser/FM.ccc", 2028, 10);
            this.currentLookaheadProduction = "NumericalOutput";
            try {
                if (!this.check$NumericalOutput(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$2030$10(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Content", "src/parser/FM.ccc", 2030, 10);
            this.currentLookaheadProduction = "FreemarkerDirective";
            try {
                if (!this.check$FreemarkerDirective(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$2099$10(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = this.remainingLookahead - 1;
        try {
            ++this.lookaheadRoutineNesting;
            $reachedScanCode$ = true;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("OptionalBlock", "src/parser/FM.ccc", 2099, 10);
            this.currentLookaheadProduction = "Content";
            try {
                if (!this.check$Content(false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
        }
        finally {
            --this.lookaheadRoutineNesting;
            if ($reachedScanCode$ && this.remainingLookahead <= passedPredicateThreshold) {
                this.passedPredicate = true;
            }
        }
        this.passedPredicate = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean scan$FM_ccc$384$10() {
        this.remainingLookahead = Integer.MAX_VALUE;
        this.currentLookaheadToken = this.lastConsumedToken;
        boolean scanToEnd = false;
        try {
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("RangeExpression", "src/parser/FM.ccc", 384, 10);
            this.currentLookaheadProduction = "AdditiveExpression";
            try {
                if (!this.check$AdditiveExpression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.lookaheadStack.size() <= 1) {
                if (this.lookaheadRoutineNesting == 0) {
                    this.remainingLookahead = 0;
                } else if (this.lookaheadStack.size() == 1) {
                    this.passedPredicateThreshold = this.remainingLookahead;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lookaheadRoutineNesting = 0;
            this.currentLookaheadToken = null;
            this.hitFailure = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean scan$FM_ccc$559$10() {
        this.remainingLookahead = Integer.MAX_VALUE;
        this.currentLookaheadToken = this.lastConsumedToken;
        boolean scanToEnd = false;
        try {
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("DefaultTo", "src/parser/FM.ccc", 560, 13);
            this.currentLookaheadProduction = "PrimaryExpression";
            try {
                if (!this.check$PrimaryExpression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.lookaheadStack.size() <= 1) {
                if (this.lookaheadRoutineNesting == 0) {
                    this.remainingLookahead = 0;
                } else if (this.lookaheadStack.size() == 1) {
                    this.passedPredicateThreshold = this.remainingLookahead;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lookaheadRoutineNesting = 0;
            this.currentLookaheadToken = null;
            this.hitFailure = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean scan$FM_ccc$1130$13() {
        this.remainingLookahead = Integer.MAX_VALUE;
        this.currentLookaheadToken = this.lastConsumedToken;
        boolean scanToEnd = false;
        try {
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token4301 = this.currentLookaheadToken;
            boolean passedPredicate4301 = this.passedPredicate;
            this.passedPredicate = false;
            try {
                if (!this.scanToken(Token.TokenType.COMMA, new Token.TokenType[0])) {
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token4301;
                    this.hitFailure = false;
                }
            }
            finally {
                this.passedPredicate = passedPredicate4301;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.ID)) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.EQUALS, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.lookaheadStack.size() <= 1) {
                if (this.lookaheadRoutineNesting == 0) {
                    this.remainingLookahead = 0;
                } else if (this.lookaheadStack.size() == 1) {
                    this.passedPredicateThreshold = this.remainingLookahead;
                }
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Assign", "src/parser/FM.ccc", 1136, 13);
            this.currentLookaheadProduction = "Expression";
            try {
                if (!this.check$Expression(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lookaheadRoutineNesting = 0;
            this.currentLookaheadToken = null;
            this.hitFailure = false;
        }
    }

    private final boolean scan$FM_ccc$1447$5() {
        this.remainingLookahead = Integer.MAX_VALUE;
        this.currentLookaheadToken = this.lastConsumedToken;
        boolean scanToEnd = false;
        try {
            if (this.remainingLookahead <= 0) {
                this.passedPredicate = true;
                boolean bl = !this.hitFailure;
                return bl;
            }
            if (!this.check$FM_ccc$1447$10(true)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lookaheadRoutineNesting = 0;
            this.currentLookaheadToken = null;
            this.hitFailure = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean scan$FM_ccc$1688$6() {
        this.remainingLookahead = 2;
        this.currentLookaheadToken = this.lastConsumedToken;
        boolean scanToEnd = false;
        try {
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            this.pushOntoLookaheadStack("Switch", "src/parser/FM.ccc", 1688, 16);
            this.currentLookaheadProduction = "Case";
            try {
                if (!this.check$Case(true)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.popLookaheadStack();
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lookaheadRoutineNesting = 0;
            this.currentLookaheadToken = null;
            this.hitFailure = false;
        }
    }

    private final boolean scan$FM_ccc$1980$7() {
        this.remainingLookahead = Integer.MAX_VALUE;
        this.currentLookaheadToken = this.lastConsumedToken;
        boolean scanToEnd = false;
        try {
            if (this.remainingLookahead <= 0) {
                this.passedPredicate = true;
                boolean bl = !this.hitFailure;
                return bl;
            }
            if (!this.check$FM_ccc$1980$12(true)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lookaheadRoutineNesting = 0;
            this.currentLookaheadToken = null;
            this.hitFailure = false;
        }
    }

    private final boolean scan$FM_ccc$2162$7() {
        this.remainingLookahead = Integer.MAX_VALUE;
        this.currentLookaheadToken = this.lastConsumedToken;
        boolean scanToEnd = false;
        try {
            if (this.remainingLookahead <= 0) {
                this.passedPredicate = true;
                boolean bl = !this.hitFailure;
                return bl;
            }
            if (!this.check$FM_ccc$2162$12(true)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lookaheadRoutineNesting = 0;
            this.currentLookaheadToken = null;
            this.hitFailure = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1447$10(boolean scanToEnd) {
        int prevRemainingLookahead = this.remainingLookahead;
        boolean prevHitFailure = this.hitFailure;
        Token prevScanAheadToken = this.currentLookaheadToken;
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.ID, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.EQUALS, new Token.TokenType[0])) {
                boolean bl = false;
                return bl;
            }
            boolean bl = !this.hitFailure;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
            this.currentLookaheadToken = prevScanAheadToken;
            this.remainingLookahead = prevRemainingLookahead;
            this.hitFailure = prevHitFailure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$1980$12(boolean scanToEnd) {
        int prevRemainingLookahead = this.remainingLookahead;
        boolean prevHitFailure = this.hitFailure;
        Token prevScanAheadToken = this.currentLookaheadToken;
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.WHITESPACE, Token.TokenType.PRINTABLE_CHARS)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = !this.hitFailure;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
            this.currentLookaheadToken = prevScanAheadToken;
            this.remainingLookahead = prevRemainingLookahead;
            this.hitFailure = prevHitFailure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FM_ccc$2162$12(boolean scanToEnd) {
        int prevRemainingLookahead = this.remainingLookahead;
        boolean prevHitFailure = this.hitFailure;
        Token prevScanAheadToken = this.currentLookaheadToken;
        try {
            ++this.lookaheadRoutineNesting;
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            Token token4316 = this.currentLookaheadToken;
            boolean passedPredicate4316 = this.passedPredicate;
            this.passedPredicate = false;
            try {
                if (!this.scanToken(Token.TokenType.WHITESPACE, new Token.TokenType[0])) {
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.currentLookaheadToken = token4316;
                    this.hitFailure = false;
                }
            }
            finally {
                this.passedPredicate = passedPredicate4316;
            }
            if (this.hitFailure) {
                boolean bl = false;
                return bl;
            }
            if (this.remainingLookahead <= 0) {
                boolean bl = true;
                return bl;
            }
            if (!this.scanToken(Token.TokenType.FTL_HEADER, Token.TokenType.TRIVIAL_FTL_HEADER)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = !this.hitFailure;
            return bl;
        }
        finally {
            --this.lookaheadRoutineNesting;
            this.currentLookaheadToken = prevScanAheadToken;
            this.remainingLookahead = prevRemainingLookahead;
            this.hitFailure = prevHitFailure;
        }
    }

    private final boolean check$Expression(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Expression", "src/parser/FM.ccc", 144, 3);
        this.currentLookaheadProduction = "OrExpression";
        try {
            if (!this.check$OrExpression(false)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$PrimaryExpression(boolean scanToEnd) {
        block32: {
            if (this.hitFailure) {
                return false;
            }
            if (this.remainingLookahead <= 0) {
                return true;
            }
            Token token4325 = this.currentLookaheadToken;
            int remainingLookahead4325 = this.remainingLookahead;
            boolean hitFailure4325 = this.hitFailure;
            boolean passedPredicate4325 = this.passedPredicate;
            try {
                this.passedPredicate = false;
                if (this.scanToken(Token.TokenType.INTEGER, Token.TokenType.DECIMAL)) break block32;
                this.currentLookaheadToken = token4325;
                this.remainingLookahead = remainingLookahead4325;
                this.hitFailure = hitFailure4325;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (this.check$FM_ccc$159$7(false)) break block32;
                this.currentLookaheadToken = token4325;
                this.remainingLookahead = remainingLookahead4325;
                this.hitFailure = hitFailure4325;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (this.scanToken(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING)) break block32;
                this.currentLookaheadToken = token4325;
                this.remainingLookahead = remainingLookahead4325;
                this.hitFailure = hitFailure4325;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (this.scanToken(Token.TokenType.FALSE, Token.TokenType.TRUE)) break block32;
                this.currentLookaheadToken = token4325;
                this.remainingLookahead = remainingLookahead4325;
                this.hitFailure = hitFailure4325;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (this.scanToken(Token.TokenType.NULL, new Token.TokenType[0])) break block32;
                this.currentLookaheadToken = token4325;
                this.remainingLookahead = remainingLookahead4325;
                this.hitFailure = hitFailure4325;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (this.check$FM_ccc$167$7(false)) break block32;
                this.currentLookaheadToken = token4325;
                this.remainingLookahead = remainingLookahead4325;
                this.hitFailure = hitFailure4325;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (this.scanToken(Token.TokenType.ID, new Token.TokenType[0])) break block32;
                this.currentLookaheadToken = token4325;
                this.remainingLookahead = remainingLookahead4325;
                this.hitFailure = hitFailure4325;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (!this.check$FM_ccc$171$7(false)) {
                    this.currentLookaheadToken = token4325;
                    this.remainingLookahead = remainingLookahead4325;
                    this.hitFailure = hitFailure4325;
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.passedPredicate = false;
                    if (!this.check$FM_ccc$173$7(false)) {
                        this.currentLookaheadToken = token4325;
                        this.remainingLookahead = remainingLookahead4325;
                        this.hitFailure = hitFailure4325;
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            finally {
                this.passedPredicate = passedPredicate4325;
            }
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4327 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4328 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.check$FM_ccc$176$7(false)) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4328;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4327;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    private final boolean check$Parenthesis(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.OPEN_PAREN, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Parenthesis", "src/parser/FM.ccc", 189, 5);
        this.currentLookaheadProduction = "Expression";
        try {
            if (!this.check$Expression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CLOSE_PAREN, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$UnaryExpression(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4338 = this.currentLookaheadToken;
        int remainingLookahead4338 = this.remainingLookahead;
        boolean hitFailure4338 = this.hitFailure;
        boolean passedPredicate4338 = this.passedPredicate;
        try {
            this.passedPredicate = false;
            if (!this.check$FM_ccc$207$4$(false)) {
                this.currentLookaheadToken = token4338;
                this.remainingLookahead = remainingLookahead4338;
                this.hitFailure = hitFailure4338;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (!this.check$FM_ccc$209$4(false)) {
                    this.currentLookaheadToken = token4338;
                    this.remainingLookahead = remainingLookahead4338;
                    this.hitFailure = hitFailure4338;
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.passedPredicate = false;
                    if (!this.check$FM_ccc$211$4(false)) {
                        this.currentLookaheadToken = token4338;
                        this.remainingLookahead = remainingLookahead4338;
                        this.hitFailure = hitFailure4338;
                        boolean bl = false;
                        return bl;
                    }
                }
            }
        }
        finally {
            this.passedPredicate = passedPredicate4338;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$NotExpression(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.EXCLAM, new Token.TokenType[0])) {
            return false;
        }
        boolean passedPredicate4343 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4344 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.scanToken(Token.TokenType.EXCLAM, new Token.TokenType[0])) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4344;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4343;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("NotExpression", "src/parser/FM.ccc", 227, 4);
        this.currentLookaheadProduction = "PrimaryExpression";
        try {
            if (!this.check$PrimaryExpression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    private final boolean check$UnaryPlusMinusExpression(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.PLUS, Token.TokenType.MINUS)) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("UnaryPlusMinusExpression", "src/parser/FM.ccc", 250, 4);
        this.currentLookaheadProduction = "PrimaryExpression";
        try {
            if (!this.check$PrimaryExpression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$AdditiveExpression(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("AdditiveExpression", "src/parser/FM.ccc", 263, 4);
        this.currentLookaheadProduction = "MultiplicativeExpression";
        try {
            if (!this.check$MultiplicativeExpression(false)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4356 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4357 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.check$FM_ccc$265$7(false)) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4357;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4356;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$MultiplicativeExpression(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("MultiplicativeExpression", "src/parser/FM.ccc", 299, 4);
        this.currentLookaheadProduction = "UnaryExpression";
        try {
            if (!this.check$UnaryExpression(false)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4363 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4364 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.check$FM_ccc$301$7(false)) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4364;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4363;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$EqualityExpression(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("EqualityExpression", "src/parser/FM.ccc", 326, 4);
        this.currentLookaheadProduction = "RelationalExpression";
        try {
            if (!this.check$RelationalExpression(false)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4370 = this.currentLookaheadToken;
        boolean passedPredicate4370 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.check$FM_ccc$328$6(false)) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4370;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4370;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$RelationalExpression(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("RelationalExpression", "src/parser/FM.ccc", 351, 4);
        this.currentLookaheadProduction = "RangeExpression";
        try {
            if (!this.check$RangeExpression(false)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4376 = this.currentLookaheadToken;
        boolean passedPredicate4376 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.check$FM_ccc$353$6(false)) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4376;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4376;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$RangeExpression(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("RangeExpression", "src/parser/FM.ccc", 381, 5);
        this.currentLookaheadProduction = "AdditiveExpression";
        try {
            if (!this.check$AdditiveExpression(false)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4382 = this.currentLookaheadToken;
        boolean passedPredicate4382 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.check$FM_ccc$383$7(false)) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4382;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4382;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$AndExpression(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("AndExpression", "src/parser/FM.ccc", 405, 4);
        this.currentLookaheadProduction = "EqualityExpression";
        try {
            if (!this.check$EqualityExpression(false)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4388 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4389 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.check$FM_ccc$407$7(false)) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4389;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4388;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$OrExpression(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("OrExpression", "src/parser/FM.ccc", 424, 4);
        this.currentLookaheadProduction = "AndExpression";
        try {
            if (!this.check$AndExpression(false)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4395 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4396 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.check$FM_ccc$426$7(false)) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4396;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4395;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$ListLiteral(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.OPEN_BRACKET, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4401 = this.currentLookaheadToken;
        boolean passedPredicate4401 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.check$FM_ccc$446$7(false)) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4401;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4401;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CLOSE_BRACKET, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    private final boolean check$BuiltinVariable(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.DOT, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.ID, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$AddSubExpression(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4414 = this.currentLookaheadToken;
        int remainingLookahead4414 = this.remainingLookahead;
        boolean hitFailure4414 = this.hitFailure;
        boolean passedPredicate4414 = this.passedPredicate;
        try {
            this.passedPredicate = false;
            if (!this.check$FM_ccc$534$8$(false)) {
                this.currentLookaheadToken = token4414;
                this.remainingLookahead = remainingLookahead4414;
                this.hitFailure = hitFailure4414;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (!this.check$FM_ccc$536$8(false)) {
                    this.currentLookaheadToken = token4414;
                    this.remainingLookahead = remainingLookahead4414;
                    this.hitFailure = hitFailure4414;
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.passedPredicate = false;
                    if (!this.check$FM_ccc$538$8(false)) {
                        this.currentLookaheadToken = token4414;
                        this.remainingLookahead = remainingLookahead4414;
                        this.hitFailure = hitFailure4414;
                        if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                            boolean bl = false;
                            return bl;
                        }
                        this.passedPredicate = false;
                        if (!this.check$FM_ccc$540$8(false)) {
                            this.currentLookaheadToken = token4414;
                            this.remainingLookahead = remainingLookahead4414;
                            this.hitFailure = hitFailure4414;
                            if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                boolean bl = false;
                                return bl;
                            }
                            this.passedPredicate = false;
                            if (!this.scanToken(Token.TokenType.EXISTS, new Token.TokenType[0])) {
                                this.currentLookaheadToken = token4414;
                                this.remainingLookahead = remainingLookahead4414;
                                this.hitFailure = hitFailure4414;
                                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                    boolean bl = false;
                                    return bl;
                                }
                                this.passedPredicate = false;
                                if (!this.check$FM_ccc$544$8(false)) {
                                    this.currentLookaheadToken = token4414;
                                    this.remainingLookahead = remainingLookahead4414;
                                    this.hitFailure = hitFailure4414;
                                    boolean bl = false;
                                    return bl;
                                }
                            }
                        }
                    }
                }
            }
        }
        finally {
            this.passedPredicate = passedPredicate4414;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$DefaultTo(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.EXCLAM, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4421 = this.currentLookaheadToken;
        boolean passedPredicate4421 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.check$FM_ccc$559$10(false)) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4421;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4421;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    private final boolean check$BuiltIn(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.BUILT_IN, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.ID, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    private final boolean check$DotVariable(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.DOT, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.ID, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    private final boolean check$DynamicKey(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.OPEN_BRACKET, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("DynamicKey", "src/parser/FM.ccc", 629, 4);
        this.currentLookaheadProduction = "Expression";
        try {
            if (!this.check$Expression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CLOSE_BRACKET, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$MethodArgs(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.OPEN_PAREN, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4442 = this.currentLookaheadToken;
        boolean passedPredicate4442 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.check$FM_ccc$647$7(false)) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4442;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4442;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CLOSE_PAREN, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$HashLiteral(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.OPEN_BRACE, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4451 = this.currentLookaheadToken;
        boolean passedPredicate4451 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.check$FM_ccc$723$8(false)) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4451;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4451;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CLOSE_BRACE, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    private final boolean check$StringOutput(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.OUTPUT_ESCAPE, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("StringOutput", "src/parser/FM.ccc", 760, 4);
        this.currentLookaheadProduction = "Expression";
        try {
            if (!this.check$Expression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CLOSE_BRACE, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$NumericalOutput(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.NUMERICAL_ESCAPE, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("NumericalOutput", "src/parser/FM.ccc", 774, 4);
        this.currentLookaheadProduction = "Expression";
        try {
            if (!this.check$Expression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4463 = this.currentLookaheadToken;
        boolean passedPredicate4463 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.check$FM_ccc$776$7(false)) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4463;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4463;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CLOSE_BRACE, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$If(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.IF, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("If", "src/parser/FM.ccc", 797, 4);
        this.currentLookaheadProduction = "Expression";
        try {
            if (!this.check$Expression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.DIRECTIVE_END, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("If", "src/parser/FM.ccc", 799, 4);
        this.currentLookaheadProduction = "OptionalBlock";
        try {
            if (!this.check$OptionalBlock(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4473 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4474 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.check$FM_ccc$806$8(false)) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4474;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4473;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4476 = this.currentLookaheadToken;
        boolean passedPredicate4476 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.check$FM_ccc$817$10(false)) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4476;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4476;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CLOSE_DIRECTIVE_BLOCK, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$Attempt(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType._ATTEMPT, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Attempt", "src/parser/FM.ccc", 839, 4);
        this.currentLookaheadProduction = "OptionalBlock";
        try {
            if (!this.check$OptionalBlock(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Attempt", "src/parser/FM.ccc", 850, 4);
        this.currentLookaheadProduction = "Recover";
        try {
            if (!this.check$Recover(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CLOSE_DIRECTIVE_BLOCK, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    private final boolean check$Recover(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType._RECOVER, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Recover", "src/parser/FM.ccc", 869, 4);
        this.currentLookaheadProduction = "OptionalBlock";
        try {
            if (!this.check$OptionalBlock(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$List(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.LIST, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("List", "src/parser/FM.ccc", 884, 4);
        this.currentLookaheadProduction = "Expression";
        try {
            if (!this.check$Expression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.AS, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.ID, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.DIRECTIVE_END, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("List", "src/parser/FM.ccc", 888, 4);
        this.currentLookaheadProduction = "OptionalBlock";
        try {
            if (!this.check$OptionalBlock(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CLOSE_DIRECTIVE_BLOCK, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$ForEach(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.FOREACH, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.ID, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.IN, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("ForEach", "src/parser/FM.ccc", 909, 4);
        this.currentLookaheadProduction = "Expression";
        try {
            if (!this.check$Expression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.DIRECTIVE_END, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("ForEach", "src/parser/FM.ccc", 911, 4);
        this.currentLookaheadProduction = "OptionalBlock";
        try {
            if (!this.check$OptionalBlock(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CLOSE_DIRECTIVE_BLOCK, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$Visit(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.VISIT, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Visit", "src/parser/FM.ccc", 929, 4);
        this.currentLookaheadProduction = "Expression";
        try {
            if (!this.check$Expression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4511 = this.currentLookaheadToken;
        boolean passedPredicate4511 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.check$FM_ccc$931$8(false)) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4511;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4511;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.DIRECTIVE_END)) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$Recurse(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4517 = this.currentLookaheadToken;
        int remainingLookahead4517 = this.remainingLookahead;
        boolean hitFailure4517 = this.hitFailure;
        boolean passedPredicate4517 = this.passedPredicate;
        try {
            this.passedPredicate = false;
            if (!this.scanToken(Token.TokenType.SIMPLE_RECURSE, new Token.TokenType[0])) {
                this.currentLookaheadToken = token4517;
                this.remainingLookahead = remainingLookahead4517;
                this.hitFailure = hitFailure4517;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (!this.check$FM_ccc$950$7(false)) {
                    this.currentLookaheadToken = token4517;
                    this.remainingLookahead = remainingLookahead4517;
                    this.hitFailure = hitFailure4517;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.passedPredicate = passedPredicate4517;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$Return(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4524 = this.currentLookaheadToken;
        int remainingLookahead4524 = this.remainingLookahead;
        boolean hitFailure4524 = this.hitFailure;
        boolean passedPredicate4524 = this.passedPredicate;
        try {
            this.passedPredicate = false;
            if (!this.scanToken(Token.TokenType.SIMPLE_RETURN, new Token.TokenType[0])) {
                this.currentLookaheadToken = token4524;
                this.remainingLookahead = remainingLookahead4524;
                this.hitFailure = hitFailure4524;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (!this.check$FM_ccc$1009$7(false)) {
                    this.currentLookaheadToken = token4524;
                    this.remainingLookahead = remainingLookahead4524;
                    this.hitFailure = hitFailure4524;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.passedPredicate = passedPredicate4524;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$Stop(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4529 = this.currentLookaheadToken;
        int remainingLookahead4529 = this.remainingLookahead;
        boolean hitFailure4529 = this.hitFailure;
        boolean passedPredicate4529 = this.passedPredicate;
        try {
            this.passedPredicate = false;
            if (!this.scanToken(Token.TokenType.HALT, new Token.TokenType[0])) {
                this.currentLookaheadToken = token4529;
                this.remainingLookahead = remainingLookahead4529;
                this.hitFailure = hitFailure4529;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (!this.check$FM_ccc$1028$7(false)) {
                    this.currentLookaheadToken = token4529;
                    this.remainingLookahead = remainingLookahead4529;
                    this.hitFailure = hitFailure4529;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.passedPredicate = passedPredicate4529;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$Nested(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4534 = this.currentLookaheadToken;
        int remainingLookahead4534 = this.remainingLookahead;
        boolean hitFailure4534 = this.hitFailure;
        boolean passedPredicate4534 = this.passedPredicate;
        try {
            this.passedPredicate = false;
            if (!this.scanToken(Token.TokenType.SIMPLE_NESTED, new Token.TokenType[0])) {
                this.currentLookaheadToken = token4534;
                this.remainingLookahead = remainingLookahead4534;
                this.hitFailure = hitFailure4534;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (!this.check$FM_ccc$1052$7(false)) {
                    this.currentLookaheadToken = token4534;
                    this.remainingLookahead = remainingLookahead4534;
                    this.hitFailure = hitFailure4534;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.passedPredicate = passedPredicate4534;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$Assign(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.ASSIGN, Token.TokenType.GLOBALASSIGN, Token.TokenType.LOCALASSIGN, Token.TokenType.SET)) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.ID)) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4546 = this.currentLookaheadToken;
        int remainingLookahead4546 = this.remainingLookahead;
        boolean hitFailure4546 = this.hitFailure;
        boolean passedPredicate4546 = this.passedPredicate;
        try {
            this.passedPredicate = false;
            if (!this.check$FM_ccc$1125$6(false)) {
                this.currentLookaheadToken = token4546;
                this.remainingLookahead = remainingLookahead4546;
                this.hitFailure = hitFailure4546;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (!this.check$FM_ccc$1160$5(false)) {
                    this.currentLookaheadToken = token4546;
                    this.remainingLookahead = remainingLookahead4546;
                    this.hitFailure = hitFailure4546;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.passedPredicate = passedPredicate4546;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$Include(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType._INCLUDE, Token.TokenType.EMBED)) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Include", "src/parser/FM.ccc", 1193, 5);
        this.currentLookaheadProduction = "Expression";
        try {
            if (!this.check$Expression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4552 = this.currentLookaheadToken;
        boolean passedPredicate4552 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.scanToken(Token.TokenType.SEMICOLON, new Token.TokenType[0])) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4552;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4552;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4554 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4555 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.check$FM_ccc$1196$4(false)) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4555;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4554;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.DIRECTIVE_END)) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    private final boolean check$Import(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.IMPORT, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Import", "src/parser/FM.ccc", 1238, 4);
        this.currentLookaheadProduction = "Expression";
        try {
            if (!this.check$Expression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.AS, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.ID, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.DIRECTIVE_END)) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$ParameterList(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4567 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4568 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.check$FM_ccc$1259$11(false)) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4568;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4567;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$Macro(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.FUNCTION, Token.TokenType.MACRO)) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.ID)) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4589 = this.currentLookaheadToken;
        boolean passedPredicate4589 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.scanToken(Token.TokenType.OPEN_PAREN, new Token.TokenType[0])) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4589;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4589;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Macro", "src/parser/FM.ccc", 1371, 5);
        this.currentLookaheadProduction = "ParameterList";
        try {
            if (!this.check$ParameterList(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4593 = this.currentLookaheadToken;
        boolean passedPredicate4593 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.scanToken(Token.TokenType.CLOSE_PAREN, new Token.TokenType[0])) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4593;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4593;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.DIRECTIVE_END, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Macro", "src/parser/FM.ccc", 1374, 5);
        this.currentLookaheadProduction = "OptionalBlock";
        try {
            if (!this.check$OptionalBlock(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CLOSE_DIRECTIVE_BLOCK, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    private final boolean check$Compress(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.COMPRESS, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Compress", "src/parser/FM.ccc", 1391, 5);
        this.currentLookaheadProduction = "OptionalBlock";
        try {
            if (!this.check$OptionalBlock(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CLOSE_DIRECTIVE_BLOCK, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$PositionalArgsList(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("PositionalArgsList", "src/parser/FM.ccc", 1404, 2);
        this.currentLookaheadProduction = "Expression";
        try {
            if (!this.check$Expression(false)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4607 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4608 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.check$FM_ccc$1406$5(false)) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4608;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4607;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$NamedArgsList(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.ID, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.EQUALS, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("NamedArgsList", "src/parser/FM.ccc", 1423, 2);
        this.currentLookaheadProduction = "Expression";
        try {
            if (!this.check$Expression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4616 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4617 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.check$FM_ccc$1428$5(false)) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4617;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4616;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$ArgsList(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4622 = this.currentLookaheadToken;
        int remainingLookahead4622 = this.remainingLookahead;
        boolean hitFailure4622 = this.hitFailure;
        boolean passedPredicate4622 = this.passedPredicate;
        try {
            this.passedPredicate = false;
            if (!this.check$FM_ccc$1447$5(false)) {
                this.currentLookaheadToken = token4622;
                this.remainingLookahead = remainingLookahead4622;
                this.hitFailure = hitFailure4622;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (!this.check$FM_ccc$1450$8(false)) {
                    this.currentLookaheadToken = token4622;
                    this.remainingLookahead = remainingLookahead4622;
                    this.hitFailure = hitFailure4622;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.passedPredicate = passedPredicate4622;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$UnifiedMacroTransform(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.UNIFIED_CALL, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("UnifiedMacroTransform", "src/parser/FM.ccc", 1472, 5);
        this.currentLookaheadProduction = "Expression";
        try {
            if (!this.check$Expression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4629 = this.currentLookaheadToken;
        boolean passedPredicate4629 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.scanToken(Token.TokenType.TERMINATING_WHITESPACE, new Token.TokenType[0])) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4629;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4629;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4631 = this.currentLookaheadToken;
        boolean passedPredicate4631 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.check$FM_ccc$1480$6(false)) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4631;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4631;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4634 = this.currentLookaheadToken;
        boolean passedPredicate4634 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.check$FM_ccc$1489$8(false)) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4634;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4634;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4637 = this.currentLookaheadToken;
        int remainingLookahead4637 = this.remainingLookahead;
        boolean hitFailure4637 = this.hitFailure;
        boolean passedPredicate4637 = this.passedPredicate;
        try {
            this.passedPredicate = false;
            if (!this.scanToken(Token.TokenType.EMPTY_DIRECTIVE_END, new Token.TokenType[0])) {
                this.currentLookaheadToken = token4637;
                this.remainingLookahead = remainingLookahead4637;
                this.hitFailure = hitFailure4637;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (!this.check$FM_ccc$1498$7(false)) {
                    this.currentLookaheadToken = token4637;
                    this.remainingLookahead = remainingLookahead4637;
                    this.hitFailure = hitFailure4637;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.passedPredicate = passedPredicate4637;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$Call(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CALL, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.ID, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4644 = this.currentLookaheadToken;
        boolean passedPredicate4644 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.scanToken(Token.TokenType.OPEN_PAREN, new Token.TokenType[0])) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4644;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4644;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Call", "src/parser/FM.ccc", 1540, 5);
        this.currentLookaheadProduction = "ArgsList";
        try {
            if (!this.check$ArgsList(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4648 = this.currentLookaheadToken;
        boolean passedPredicate4648 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.scanToken(Token.TokenType.CLOSE_PAREN, new Token.TokenType[0])) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4648;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4648;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.DIRECTIVE_END)) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$TerseComment(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.TERSE_COMMENT, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4664 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4665 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.scanToken(Token.TokenType.PRINTABLE_CHARS, new Token.TokenType[0])) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4665;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4664;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.TERSE_COMMENT_END, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$Comment(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.COMMENT, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4671 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4672 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.scanToken(Token.TokenType.PRINTABLE_CHARS, new Token.TokenType[0])) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4672;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4671;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.COMMENT_END, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$NoParse(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.NOPARSE, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4678 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4679 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.scanToken(Token.TokenType.PRINTABLE_CHARS, new Token.TokenType[0])) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4679;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4678;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.NOPARSE_END, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$Transform(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.TRANSFORM, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Transform", "src/parser/FM.ccc", 1645, 5);
        this.currentLookaheadProduction = "Expression";
        try {
            if (!this.check$Expression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4686 = this.currentLookaheadToken;
        boolean passedPredicate4686 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.scanToken(Token.TokenType.SEMICOLON, new Token.TokenType[0])) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4686;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4686;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4688 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4689 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.check$FM_ccc$1648$8(false)) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4689;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4688;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4692 = this.currentLookaheadToken;
        int remainingLookahead4692 = this.remainingLookahead;
        boolean hitFailure4692 = this.hitFailure;
        boolean passedPredicate4692 = this.passedPredicate;
        try {
            this.passedPredicate = false;
            if (!this.scanToken(Token.TokenType.EMPTY_DIRECTIVE_END, new Token.TokenType[0])) {
                this.currentLookaheadToken = token4692;
                this.remainingLookahead = remainingLookahead4692;
                this.hitFailure = hitFailure4692;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (!this.check$FM_ccc$1659$8(false)) {
                    this.currentLookaheadToken = token4692;
                    this.remainingLookahead = remainingLookahead4692;
                    this.hitFailure = hitFailure4692;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.passedPredicate = passedPredicate4692;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$Switch(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.SWITCH, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Switch", "src/parser/FM.ccc", 1681, 4);
        this.currentLookaheadProduction = "Expression";
        try {
            if (!this.check$Expression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.DIRECTIVE_END, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4699 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4700 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.check$FM_ccc$1683$5(false)) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4700;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4699;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4703 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4704 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.check$FM_ccc$1688$6(false)) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4704;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4703;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CLOSE_DIRECTIVE_BLOCK, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$Case(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4710 = this.currentLookaheadToken;
        int remainingLookahead4710 = this.remainingLookahead;
        boolean hitFailure4710 = this.hitFailure;
        boolean passedPredicate4710 = this.passedPredicate;
        try {
            this.passedPredicate = false;
            if (!this.check$FM_ccc$1715$7$(false)) {
                this.currentLookaheadToken = token4710;
                this.remainingLookahead = remainingLookahead4710;
                this.hitFailure = hitFailure4710;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (!this.scanToken(Token.TokenType.DEFAUL, new Token.TokenType[0])) {
                    this.currentLookaheadToken = token4710;
                    this.remainingLookahead = remainingLookahead4710;
                    this.hitFailure = hitFailure4710;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.passedPredicate = passedPredicate4710;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Case", "src/parser/FM.ccc", 1721, 4);
        this.currentLookaheadProduction = "OptionalBlock";
        try {
            if (!this.check$OptionalBlock(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    private final boolean check$TrimBlock(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.BLOCKTRIM, Token.TokenType.BLOCKTRIML, Token.TokenType.BLOCKTRIMR, Token.TokenType.BLOCKNOTRIM)) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("TrimBlock", "src/parser/FM.ccc", 1745, 2);
        this.currentLookaheadProduction = "OptionalBlock";
        try {
            if (!this.check$OptionalBlock(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CLOSE_DIRECTIVE_BLOCK, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$Escape(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.ESCAPE, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.ID, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.AS, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Escape", "src/parser/FM.ccc", 1765, 5);
        this.currentLookaheadProduction = "Expression";
        try {
            if (!this.check$Expression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.DIRECTIVE_END, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Escape", "src/parser/FM.ccc", 1770, 5);
        this.currentLookaheadProduction = "OptionalBlock";
        try {
            if (!this.check$OptionalBlock(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CLOSE_DIRECTIVE_BLOCK, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    private final boolean check$NoEscape(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.NOESCAPE, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("NoEscape", "src/parser/FM.ccc", 1787, 5);
        this.currentLookaheadProduction = "OptionalBlock";
        try {
            if (!this.check$OptionalBlock(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.CLOSE_DIRECTIVE_BLOCK, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    private final boolean check$Setting(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.SETTING, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.ID, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.EQUALS, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        this.pushOntoLookaheadStack("Setting", "src/parser/FM.ccc", 1846, 4);
        this.currentLookaheadProduction = "Expression";
        try {
            if (!this.check$Expression(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.popLookaheadStack();
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.DIRECTIVE_END)) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$Var(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.VAR, new Token.TokenType[0])) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.ID)) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4751 = this.currentLookaheadToken;
        boolean passedPredicate4751 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.check$FM_ccc$1865$8(false)) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4751;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4751;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4754 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4755 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.check$FM_ccc$1874$7(false)) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4755;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4754;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.DIRECTIVE_END)) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$FreemarkerDirective(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4761 = this.currentLookaheadToken;
        int remainingLookahead4761 = this.remainingLookahead;
        boolean hitFailure4761 = this.hitFailure;
        boolean passedPredicate4761 = this.passedPredicate;
        try {
            this.passedPredicate = false;
            if (!this.check$FM_ccc$1902$6$(false)) {
                this.currentLookaheadToken = token4761;
                this.remainingLookahead = remainingLookahead4761;
                this.hitFailure = hitFailure4761;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (!this.check$FM_ccc$1904$6(false)) {
                    this.currentLookaheadToken = token4761;
                    this.remainingLookahead = remainingLookahead4761;
                    this.hitFailure = hitFailure4761;
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.passedPredicate = false;
                    if (!this.check$FM_ccc$1906$6(false)) {
                        this.currentLookaheadToken = token4761;
                        this.remainingLookahead = remainingLookahead4761;
                        this.hitFailure = hitFailure4761;
                        if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                            boolean bl = false;
                            return bl;
                        }
                        this.passedPredicate = false;
                        if (!this.check$FM_ccc$1908$6(false)) {
                            this.currentLookaheadToken = token4761;
                            this.remainingLookahead = remainingLookahead4761;
                            this.hitFailure = hitFailure4761;
                            if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                boolean bl = false;
                                return bl;
                            }
                            this.passedPredicate = false;
                            if (!this.check$FM_ccc$1910$6(false)) {
                                this.currentLookaheadToken = token4761;
                                this.remainingLookahead = remainingLookahead4761;
                                this.hitFailure = hitFailure4761;
                                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                    boolean bl = false;
                                    return bl;
                                }
                                this.passedPredicate = false;
                                if (!this.check$FM_ccc$1912$6(false)) {
                                    this.currentLookaheadToken = token4761;
                                    this.remainingLookahead = remainingLookahead4761;
                                    this.hitFailure = hitFailure4761;
                                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                        boolean bl = false;
                                        return bl;
                                    }
                                    this.passedPredicate = false;
                                    if (!this.check$FM_ccc$1914$6(false)) {
                                        this.currentLookaheadToken = token4761;
                                        this.remainingLookahead = remainingLookahead4761;
                                        this.hitFailure = hitFailure4761;
                                        if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                            boolean bl = false;
                                            return bl;
                                        }
                                        this.passedPredicate = false;
                                        if (!this.check$FM_ccc$1916$6(false)) {
                                            this.currentLookaheadToken = token4761;
                                            this.remainingLookahead = remainingLookahead4761;
                                            this.hitFailure = hitFailure4761;
                                            if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                boolean bl = false;
                                                return bl;
                                            }
                                            this.passedPredicate = false;
                                            if (!this.check$FM_ccc$1918$6(false)) {
                                                this.currentLookaheadToken = token4761;
                                                this.remainingLookahead = remainingLookahead4761;
                                                this.hitFailure = hitFailure4761;
                                                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                    boolean bl = false;
                                                    return bl;
                                                }
                                                this.passedPredicate = false;
                                                if (!this.check$FM_ccc$1920$6(false)) {
                                                    this.currentLookaheadToken = token4761;
                                                    this.remainingLookahead = remainingLookahead4761;
                                                    this.hitFailure = hitFailure4761;
                                                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                        boolean bl = false;
                                                        return bl;
                                                    }
                                                    this.passedPredicate = false;
                                                    if (!this.check$FM_ccc$1922$6(false)) {
                                                        this.currentLookaheadToken = token4761;
                                                        this.remainingLookahead = remainingLookahead4761;
                                                        this.hitFailure = hitFailure4761;
                                                        if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                            boolean bl = false;
                                                            return bl;
                                                        }
                                                        this.passedPredicate = false;
                                                        if (!this.check$FM_ccc$1924$6(false)) {
                                                            this.currentLookaheadToken = token4761;
                                                            this.remainingLookahead = remainingLookahead4761;
                                                            this.hitFailure = hitFailure4761;
                                                            if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                boolean bl = false;
                                                                return bl;
                                                            }
                                                            this.passedPredicate = false;
                                                            if (!this.check$FM_ccc$1926$6(false)) {
                                                                this.currentLookaheadToken = token4761;
                                                                this.remainingLookahead = remainingLookahead4761;
                                                                this.hitFailure = hitFailure4761;
                                                                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                    boolean bl = false;
                                                                    return bl;
                                                                }
                                                                this.passedPredicate = false;
                                                                if (!this.check$FM_ccc$1928$6(false)) {
                                                                    this.currentLookaheadToken = token4761;
                                                                    this.remainingLookahead = remainingLookahead4761;
                                                                    this.hitFailure = hitFailure4761;
                                                                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                        boolean bl = false;
                                                                        return bl;
                                                                    }
                                                                    this.passedPredicate = false;
                                                                    if (!this.check$FM_ccc$1930$6(false)) {
                                                                        this.currentLookaheadToken = token4761;
                                                                        this.remainingLookahead = remainingLookahead4761;
                                                                        this.hitFailure = hitFailure4761;
                                                                        if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                            boolean bl = false;
                                                                            return bl;
                                                                        }
                                                                        this.passedPredicate = false;
                                                                        if (!this.check$FM_ccc$1932$6(false)) {
                                                                            this.currentLookaheadToken = token4761;
                                                                            this.remainingLookahead = remainingLookahead4761;
                                                                            this.hitFailure = hitFailure4761;
                                                                            if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                                boolean bl = false;
                                                                                return bl;
                                                                            }
                                                                            this.passedPredicate = false;
                                                                            if (!this.check$FM_ccc$1934$6(false)) {
                                                                                this.currentLookaheadToken = token4761;
                                                                                this.remainingLookahead = remainingLookahead4761;
                                                                                this.hitFailure = hitFailure4761;
                                                                                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                                    boolean bl = false;
                                                                                    return bl;
                                                                                }
                                                                                this.passedPredicate = false;
                                                                                if (!this.scanToken(Token.TokenType.BREAK, new Token.TokenType[0])) {
                                                                                    this.currentLookaheadToken = token4761;
                                                                                    this.remainingLookahead = remainingLookahead4761;
                                                                                    this.hitFailure = hitFailure4761;
                                                                                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                                        boolean bl = false;
                                                                                        return bl;
                                                                                    }
                                                                                    this.passedPredicate = false;
                                                                                    if (!this.check$FM_ccc$1938$6(false)) {
                                                                                        this.currentLookaheadToken = token4761;
                                                                                        this.remainingLookahead = remainingLookahead4761;
                                                                                        this.hitFailure = hitFailure4761;
                                                                                        if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                                            boolean bl = false;
                                                                                            return bl;
                                                                                        }
                                                                                        this.passedPredicate = false;
                                                                                        if (!this.check$FM_ccc$1940$6(false)) {
                                                                                            this.currentLookaheadToken = token4761;
                                                                                            this.remainingLookahead = remainingLookahead4761;
                                                                                            this.hitFailure = hitFailure4761;
                                                                                            if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                                                boolean bl = false;
                                                                                                return bl;
                                                                                            }
                                                                                            this.passedPredicate = false;
                                                                                            if (!this.scanToken(Token.TokenType.FLUSH, new Token.TokenType[0])) {
                                                                                                this.currentLookaheadToken = token4761;
                                                                                                this.remainingLookahead = remainingLookahead4761;
                                                                                                this.hitFailure = hitFailure4761;
                                                                                                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                                                    boolean bl = false;
                                                                                                    return bl;
                                                                                                }
                                                                                                this.passedPredicate = false;
                                                                                                if (!this.scanToken(Token.TokenType.TRIM, Token.TokenType.LTRIM, Token.TokenType.RTRIM, Token.TokenType.NOTRIM)) {
                                                                                                    this.currentLookaheadToken = token4761;
                                                                                                    this.remainingLookahead = remainingLookahead4761;
                                                                                                    this.hitFailure = hitFailure4761;
                                                                                                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                                                        boolean bl = false;
                                                                                                        return bl;
                                                                                                    }
                                                                                                    this.passedPredicate = false;
                                                                                                    if (!this.check$FM_ccc$1946$6(false)) {
                                                                                                        this.currentLookaheadToken = token4761;
                                                                                                        this.remainingLookahead = remainingLookahead4761;
                                                                                                        this.hitFailure = hitFailure4761;
                                                                                                        if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                                                            boolean bl = false;
                                                                                                            return bl;
                                                                                                        }
                                                                                                        this.passedPredicate = false;
                                                                                                        if (!this.check$FM_ccc$1948$6(false)) {
                                                                                                            this.currentLookaheadToken = token4761;
                                                                                                            this.remainingLookahead = remainingLookahead4761;
                                                                                                            this.hitFailure = hitFailure4761;
                                                                                                            if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                                                                boolean bl = false;
                                                                                                                return bl;
                                                                                                            }
                                                                                                            this.passedPredicate = false;
                                                                                                            if (!this.check$FM_ccc$1950$6(false)) {
                                                                                                                this.currentLookaheadToken = token4761;
                                                                                                                this.remainingLookahead = remainingLookahead4761;
                                                                                                                this.hitFailure = hitFailure4761;
                                                                                                                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                                                                    boolean bl = false;
                                                                                                                    return bl;
                                                                                                                }
                                                                                                                this.passedPredicate = false;
                                                                                                                if (!this.check$FM_ccc$1952$6(false)) {
                                                                                                                    this.currentLookaheadToken = token4761;
                                                                                                                    this.remainingLookahead = remainingLookahead4761;
                                                                                                                    this.hitFailure = hitFailure4761;
                                                                                                                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                                                                        boolean bl = false;
                                                                                                                        return bl;
                                                                                                                    }
                                                                                                                    this.passedPredicate = false;
                                                                                                                    if (!this.check$FM_ccc$1954$6(false)) {
                                                                                                                        this.currentLookaheadToken = token4761;
                                                                                                                        this.remainingLookahead = remainingLookahead4761;
                                                                                                                        this.hitFailure = hitFailure4761;
                                                                                                                        if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                                                                            boolean bl = false;
                                                                                                                            return bl;
                                                                                                                        }
                                                                                                                        this.passedPredicate = false;
                                                                                                                        if (!this.check$FM_ccc$1956$6(false)) {
                                                                                                                            this.currentLookaheadToken = token4761;
                                                                                                                            this.remainingLookahead = remainingLookahead4761;
                                                                                                                            this.hitFailure = hitFailure4761;
                                                                                                                            if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                                                                                boolean bl = false;
                                                                                                                                return bl;
                                                                                                                            }
                                                                                                                            this.passedPredicate = false;
                                                                                                                            if (!this.scanToken(Token.TokenType.FALLBACK, new Token.TokenType[0])) {
                                                                                                                                this.currentLookaheadToken = token4761;
                                                                                                                                this.remainingLookahead = remainingLookahead4761;
                                                                                                                                this.hitFailure = hitFailure4761;
                                                                                                                                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                                                                                                                                    boolean bl = false;
                                                                                                                                    return bl;
                                                                                                                                }
                                                                                                                                this.passedPredicate = false;
                                                                                                                                if (!this.check$FM_ccc$1960$6(false)) {
                                                                                                                                    this.currentLookaheadToken = token4761;
                                                                                                                                    this.remainingLookahead = remainingLookahead4761;
                                                                                                                                    this.hitFailure = hitFailure4761;
                                                                                                                                    boolean bl = false;
                                                                                                                                    return bl;
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        finally {
            this.passedPredicate = passedPredicate4761;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$PCData(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        if (!this.scanToken(Token.TokenType.WHITESPACE, Token.TokenType.PRINTABLE_CHARS)) {
            return false;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4769 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4770 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.check$FM_ccc$1980$7(false)) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4770;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4769;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean check$Content(boolean scanToEnd) {
        block24: {
            if (this.hitFailure) {
                return false;
            }
            if (this.remainingLookahead <= 0) {
                return true;
            }
            if (this.hitFailure) {
                return false;
            }
            if (this.remainingLookahead <= 0) {
                return true;
            }
            Token token4777 = this.currentLookaheadToken;
            int remainingLookahead4777 = this.remainingLookahead;
            boolean hitFailure4777 = this.hitFailure;
            boolean passedPredicate4777 = this.passedPredicate;
            try {
                this.passedPredicate = false;
                if (this.check$FM_ccc$2024$10(false)) break block24;
                this.currentLookaheadToken = token4777;
                this.remainingLookahead = remainingLookahead4777;
                this.hitFailure = hitFailure4777;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (this.check$FM_ccc$2026$10(false)) break block24;
                this.currentLookaheadToken = token4777;
                this.remainingLookahead = remainingLookahead4777;
                this.hitFailure = hitFailure4777;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.passedPredicate = false;
                if (!this.check$FM_ccc$2028$10(false)) {
                    this.currentLookaheadToken = token4777;
                    this.remainingLookahead = remainingLookahead4777;
                    this.hitFailure = hitFailure4777;
                    if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                        boolean bl = false;
                        return bl;
                    }
                    this.passedPredicate = false;
                    if (!this.check$FM_ccc$2030$10(false)) {
                        this.currentLookaheadToken = token4777;
                        this.remainingLookahead = remainingLookahead4777;
                        this.hitFailure = hitFailure4777;
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            finally {
                this.passedPredicate = passedPredicate4777;
            }
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        boolean passedPredicate4779 = this.passedPredicate;
        try {
            while (this.remainingLookahead > 0 && !this.hitFailure) {
                Token token4780 = this.currentLookaheadToken;
                this.passedPredicate = false;
                if (this.check$FM_ccc$2023$7(false)) continue;
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4780;
                break;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4779;
        }
        this.hitFailure = false;
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead > 0) return true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean check$OptionalBlock(boolean scanToEnd) {
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        Token token4794 = this.currentLookaheadToken;
        boolean passedPredicate4794 = this.passedPredicate;
        this.passedPredicate = false;
        try {
            if (!this.check$FM_ccc$2099$10(false)) {
                if (this.passedPredicate && !this.legacyGlitchyLookahead) {
                    boolean bl = false;
                    return bl;
                }
                this.currentLookaheadToken = token4794;
                this.hitFailure = false;
            }
        }
        finally {
            this.passedPredicate = passedPredicate4794;
        }
        if (this.hitFailure) {
            return false;
        }
        if (this.remainingLookahead <= 0) {
            return true;
        }
        return true;
    }

    private final void pushOntoCallStack(String methodName, String fileName, int line, int column) {
        this.parsingStack.add(new NonTerminalCall("FMParser", this.token_source, fileName, methodName, line, column, null));
    }

    private final void popCallStack() {
        NonTerminalCall ntc = this.parsingStack.remove(this.parsingStack.size() - 1);
        this.currentlyParsedProduction = ntc.productionName;
    }

    private final void pushOntoLookaheadStack(String methodName, String fileName, int line, int column) {
        this.lookaheadStack.add(new NonTerminalCall("FMParser", this.token_source, fileName, methodName, line, column, null));
    }

    private final void popLookaheadStack() {
        NonTerminalCall ntc = this.lookaheadStack.remove(this.lookaheadStack.size() - 1);
        this.currentLookaheadProduction = ntc.productionName;
    }

    void dumpLookaheadStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it = this.lookaheadStack.listIterator(this.lookaheadStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpCallStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it = this.parsingStack.listIterator(this.parsingStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpLookaheadCallStack(PrintStream ps) {
        ps.println("Current Parser Production is: " + this.currentlyParsedProduction);
        ps.println("Current Lookahead Production is: " + this.currentLookaheadProduction);
        ps.println("---Lookahead Stack---");
        this.dumpLookaheadStack(ps);
        ps.println("---Call Stack---");
        this.dumpCallStack(ps);
    }

    public boolean isParserTolerant() {
        return false;
    }

    public void setParserTolerant(boolean tolerantParsing) {
        if (tolerantParsing) {
            throw new UnsupportedOperationException("This parser was not built with that feature!");
        }
    }

    private Token consumeToken(Token.TokenType expectedType) {
        Token nextToken = this.nextToken(this.lastConsumedToken);
        if (nextToken.getType() != expectedType) {
            nextToken = this.handleUnexpectedTokenType(expectedType, nextToken);
        }
        this.lastConsumedToken = nextToken;
        this.nextTokenType = null;
        return this.lastConsumedToken;
    }

    private Token handleUnexpectedTokenType(Token.TokenType expectedType, Token nextToken) {
        throw new ParseException(this, nextToken, EnumSet.of(expectedType), this.parsingStack);
    }

    public boolean isTreeBuildingEnabled() {
        return false;
    }

    private class ParseState {
        Token lastConsumed;
        ArrayList<NonTerminalCall> parsingStack;
        FMLexer.LexicalState lexicalState;

        ParseState() {
            ArrayList parsingStack;
            this.lastConsumed = FMParser.this.lastConsumedToken;
            this.parsingStack = parsingStack = (ArrayList)FMParser.this.parsingStack.clone();
            this.lexicalState = FMParser.this.token_source.lexicalState;
        }
    }
}

