/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.builtins;

import freemarker.core.Environment;
import freemarker.core.ast.BuiltInExpression;
import freemarker.core.ast.Macro;
import freemarker.core.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.TemplateTransformModel;

public class TypeChecks
extends ExpressionEvaluatingBuiltIn {
    @Override
    public TemplateModel get(Environment env, BuiltInExpression caller, TemplateModel model) {
        boolean result = false;
        String builtInName = caller.getName();
        if (builtInName == "is_string") {
            result = model instanceof TemplateScalarModel;
        } else if (builtInName == "is_number") {
            result = model instanceof TemplateNumberModel;
        } else if (builtInName == "is_date") {
            result = model instanceof TemplateDateModel;
        } else if (builtInName == "is_enumerable") {
            result = model instanceof TemplateSequenceModel || model instanceof TemplateCollectionModel;
        } else if (builtInName == "is_sequence" || builtInName == "is_indexable") {
            result = model instanceof TemplateSequenceModel;
        } else if (builtInName == "is_macro") {
            result = model instanceof Macro && !((Macro)model).isFunction();
        } else if (builtInName == "is_directive") {
            result = model instanceof Macro || model instanceof TemplateTransformModel || model instanceof TemplateDirectiveModel;
        } else if (builtInName == "is_boolean") {
            result = model instanceof TemplateBooleanModel;
        } else if (builtInName == "is_hash") {
            result = model instanceof TemplateHashModel;
        } else if (builtInName == "is_hash_ex") {
            result = model instanceof TemplateHashModelEx;
        } else if (builtInName == "is_method") {
            result = model instanceof TemplateMethodModel;
        } else if (builtInName == "is_node") {
            result = model instanceof TemplateNodeModel;
        } else if (builtInName == "is_null") {
            result = model == TemplateModel.JAVA_NULL;
        } else if (builtInName == "is_transform") {
            result = model instanceof TemplateTransformModel;
        } else if (builtInName == "is_collection") {
            result = model instanceof TemplateCollectionModel;
        }
        return result ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
    }
}

