/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.TemplateNamespace;
import freemarker.core.ast.Expression;
import freemarker.core.ast.ListLiteral;
import freemarker.core.ast.StringLiteral;
import freemarker.core.ast.TemplateElement;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;

public class VisitNode
extends TemplateElement {
    private Expression targetNode;
    private Expression namespaces;

    public VisitNode(Expression targetNode, Expression namespaces) {
        this.targetNode = targetNode;
        this.namespaces = namespaces;
    }

    public Expression getTargetNode() {
        return this.targetNode;
    }

    public Expression getNamespaces() {
        return this.namespaces;
    }

    @Override
    public void execute(Environment env) throws IOException, TemplateException {
        TemplateModel nss;
        TemplateModel node = this.targetNode.getAsTemplateModel(env);
        VisitNode.assertNonNull(node, this.targetNode, env);
        if (!(node instanceof TemplateNodeModel)) {
            throw new TemplateException("Expecting an XML node here", env);
        }
        TemplateModel templateModel = nss = this.namespaces == null ? null : this.namespaces.getAsTemplateModel(env);
        if (this.namespaces instanceof StringLiteral) {
            nss = env.importLib(((TemplateScalarModel)nss).getAsString(), null);
        } else if (this.namespaces instanceof ListLiteral) {
            nss = ((ListLiteral)this.namespaces).evaluateStringsToNamespaces(env);
        }
        if (nss != null) {
            if (nss instanceof TemplateNamespace) {
                SimpleSequence ss = new SimpleSequence(1);
                ss.add(nss);
                nss = ss;
            } else if (!(nss instanceof TemplateSequenceModel)) {
                throw new TemplateException("Expecting a sequence of namespaces after 'using'", env);
            }
        }
        env.render((TemplateNodeModel)node, (TemplateSequenceModel)nss);
    }

    @Override
    public String getDescription() {
        return "visit instruction";
    }
}

