/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.BlockScope;
import freemarker.core.Environment;
import freemarker.core.Scope;
import freemarker.core.ast.BlockAssignment;
import freemarker.core.ast.Macro;
import freemarker.core.ast.MixedContent;
import freemarker.core.ast.TemplateNode;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class TemplateElement
extends TemplateNode
implements Iterable<TemplateElement> {
    protected TemplateElement nestedBlock;
    protected List<TemplateElement> nestedElements;
    HashSet<String> declaredVariables;
    static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };

    public abstract void execute(Environment var1) throws TemplateException, IOException;

    public Scope createLocalScope(Scope enclosingScope) {
        return new BlockScope(this, enclosingScope);
    }

    public TemplateElement getParent() {
        return (TemplateElement)this.parent;
    }

    public boolean declaresVariable(String name) {
        return this.declaredVariables != null && this.declaredVariables.contains(name);
    }

    public void declareVariable(String varName) {
        if (this.declaredVariables == null) {
            this.declaredVariables = new HashSet();
        }
        this.declaredVariables.add(varName);
    }

    public TemplateElement getNestedBlock() {
        return this.nestedBlock;
    }

    public List<TemplateElement> getNestedElements() {
        return this.nestedElements;
    }

    public void setNestedBlock(TemplateElement nestedBlock) {
        this.nestedBlock = nestedBlock;
    }

    public void setParent(TemplateElement parent) {
        this.parent = parent;
    }

    public TemplateSequenceModel getChildNodes() {
        if (this.nestedElements != null) {
            return new SimpleSequence(this.nestedElements);
        }
        SimpleSequence result = new SimpleSequence();
        if (this.nestedBlock != null) {
            result.add(this.nestedBlock);
        }
        return result;
    }

    @Override
    public Iterator<TemplateElement> iterator() {
        if (this.nestedElements != null) {
            return this.nestedElements.iterator();
        }
        ArrayList<TemplateElement> l = new ArrayList<TemplateElement>();
        if (this.nestedBlock != null) {
            l.add(this.nestedBlock);
        }
        return l.iterator();
    }

    public void setParentRecursively(TemplateElement parent) {
        this.parent = parent;
        int nestedSize = this.nestedElements == null ? 0 : this.nestedElements.size();
        for (int i = 0; i < nestedSize; ++i) {
            this.nestedElements.get(i).setParentRecursively(this);
        }
        if (this.nestedBlock != null) {
            this.nestedBlock.setParentRecursively(this);
        }
    }

    public boolean isIgnorable() {
        return false;
    }

    public void removeIgnorableChildren() {
        if (this.nestedElements != null) {
            Iterator<TemplateElement> it = this.nestedElements.iterator();
            while (it.hasNext()) {
                TemplateElement child = it.next();
                if (!child.isIgnorable()) continue;
                it.remove();
            }
            if (this.nestedElements instanceof ArrayList) {
                ((ArrayList)this.nestedElements).trimToSize();
            }
        } else if (this.nestedBlock != null && this.nestedBlock.isIgnorable()) {
            this.nestedBlock = null;
        }
    }

    TemplateElement prevTerminalNode() {
        TemplateElement prev = this.previousSibling();
        if (prev != null) {
            return prev.getLastLeaf();
        }
        if (this.parent != null) {
            return this.getParent().prevTerminalNode();
        }
        return null;
    }

    protected TemplateElement nextTerminalNode() {
        TemplateElement next = this.nextSibling();
        if (next != null) {
            return next.getFirstLeaf();
        }
        if (this.parent != null) {
            return this.getParent().nextTerminalNode();
        }
        return null;
    }

    protected TemplateElement previousSibling() {
        if (this.parent == null) {
            return null;
        }
        TemplateElement parentElement = (TemplateElement)this.parent;
        List<TemplateElement> siblings = parentElement.nestedElements;
        if (siblings == null) {
            return null;
        }
        for (int i = siblings.size() - 1; i >= 0; --i) {
            if (siblings.get(i) != this) continue;
            return i > 0 ? siblings.get(i - 1) : null;
        }
        return null;
    }

    protected TemplateElement nextSibling() {
        if (this.parent == null) {
            return null;
        }
        TemplateElement parent = (TemplateElement)this.parent;
        List<TemplateElement> siblings = parent.nestedElements;
        if (siblings == null) {
            return null;
        }
        for (int i = 0; i < siblings.size(); ++i) {
            if (siblings.get(i) != this) continue;
            return i + 1 < siblings.size() ? siblings.get(i + 1) : null;
        }
        return null;
    }

    private TemplateElement getFirstChild() {
        if (this.nestedBlock != null) {
            return this.nestedBlock;
        }
        if (this.nestedElements != null && this.nestedElements.size() > 0) {
            return this.nestedElements.get(0);
        }
        return null;
    }

    private TemplateElement getLastChild() {
        if (this.nestedBlock != null) {
            return this.nestedBlock;
        }
        if (this.nestedElements != null && this.nestedElements.size() > 0) {
            return this.nestedElements.get(this.nestedElements.size() - 1);
        }
        return null;
    }

    private boolean isLeaf() {
        return this.nestedBlock == null && (this.nestedElements == null || this.nestedElements.isEmpty());
    }

    public int getIndex(TemplateElement node) {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.getIndex(node);
        }
        if (this.nestedBlock != null) {
            if (node == this.nestedBlock) {
                return 0;
            }
        } else if (this.nestedElements != null) {
            return this.nestedElements.indexOf(node);
        }
        return -1;
    }

    public int getChildCount() {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.getChildCount();
        }
        if (this.nestedBlock != null) {
            return 1;
        }
        if (this.nestedElements != null) {
            return this.nestedElements.size();
        }
        return 0;
    }

    public Enumeration children() {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.children();
        }
        if (this.nestedBlock != null) {
            return Collections.enumeration(Collections.singletonList(this.nestedBlock));
        }
        if (this.nestedElements != null) {
            return Collections.enumeration(this.nestedElements);
        }
        return EMPTY_ENUMERATION;
    }

    public TemplateElement getChildAt(int index) {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.getChildAt(index);
        }
        if (this.nestedBlock != null) {
            if (index == 0) {
                return this.nestedBlock;
            }
            throw new ArrayIndexOutOfBoundsException("invalid index");
        }
        if (this.nestedElements != null) {
            return this.nestedElements.get(index);
        }
        throw new ArrayIndexOutOfBoundsException("element has no children");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setChildAt(int index, TemplateElement element) {
        if (this.nestedBlock instanceof MixedContent) {
            this.nestedBlock.setChildAt(index, element);
            return;
        } else if (this.nestedBlock != null) {
            if (index != 0) throw new IndexOutOfBoundsException("invalid index");
            this.nestedBlock = element;
            element.parent = this;
            return;
        } else {
            if (this.nestedElements == null) throw new IndexOutOfBoundsException("element has no children");
            this.nestedElements.set(index, element);
            element.parent = this;
        }
    }

    private TemplateElement getFirstLeaf() {
        TemplateElement te = this;
        while (!(te.isLeaf() || te instanceof Macro || te instanceof BlockAssignment)) {
            te = te.getFirstChild();
        }
        return te;
    }

    private TemplateElement getLastLeaf() {
        TemplateElement te = this;
        while (!(te.isLeaf() || te instanceof Macro || te instanceof BlockAssignment)) {
            te = te.getLastChild();
        }
        return te;
    }

    public boolean createsScope() {
        return this.declaredVariables != null && !this.declaredVariables.isEmpty();
    }

    public Macro getEnclosingMacro() {
        TemplateElement parent = this;
        while (parent != null) {
            if (!((parent = parent.getParent()) instanceof Macro)) continue;
            return (Macro)parent;
        }
        return null;
    }

    public void replace(TemplateNode prev, TemplateElement current) {
        if (this.nestedBlock != null) {
            if (prev == this.nestedBlock) {
                this.nestedBlock = current;
            }
            current.parent = this;
        } else if (this.nestedElements != null) {
            for (int i = 0; i < this.nestedElements.size(); ++i) {
                TemplateNode nestedElement = this.nestedElements.get(i);
                if (nestedElement != prev) continue;
                this.nestedElements.set(i, current);
                current.parent = this;
            }
        }
    }
}

