/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.ArgsList;
import freemarker.core.ast.Expression;
import freemarker.core.ast.Macro;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class MethodCall
extends Expression {
    private Expression target;
    private final ArgsList arguments;

    public MethodCall(Expression target, ArgsList args) {
        this.target = target;
        target.parent = this;
        this.arguments = args;
        args.parent = this;
    }

    public ArgsList getArgs() {
        return this.arguments;
    }

    public Expression getTarget() {
        return this.target;
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        TemplateModel targetModel = this.target.getAsTemplateModel(env);
        if (targetModel instanceof TemplateMethodModel) {
            TemplateMethodModel targetMethod = (TemplateMethodModel)targetModel;
            List argumentStrings = this.arguments.getParameterSequence(targetMethod, env);
            Object result = targetMethod.exec(argumentStrings);
            return env.getObjectWrapper().wrap(result);
        }
        if (targetModel instanceof Macro) {
            Macro func = (Macro)targetModel;
            StringWriter sw = null;
            env.setLastReturnValue(null);
            Writer prevOut = env.getOut();
            try {
                env.setOut(Environment.NULL_WRITER);
                if (!func.isFunction()) {
                    sw = new StringWriter();
                    env.setOut(sw);
                }
                env.render(func, this.arguments, null, null);
            }
            catch (IOException ioe) {
                throw new InternalError("This should be impossible.");
            }
            finally {
                env.setOut(prevOut);
            }
            return sw != null ? env.getObjectWrapper().wrap(sw.getBuffer().toString()) : env.getLastReturnValue();
        }
        throw MethodCall.invalidTypeException(targetModel, this.target, env, "method");
    }

    TemplateModel getConstantValue() {
        return null;
    }

    @Override
    boolean isLiteral() {
        return false;
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        return new MethodCall(this.target.deepClone(name, subst), this.arguments.deepClone(name, subst));
    }
}

