/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ast.Expression;
import freemarker.core.ast.TemplateElement;
import freemarker.core.parser.ParseException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;

public final class LibraryLoad
extends TemplateElement {
    private Expression templateName;
    private String namespace;
    private String templatePath = "";

    public LibraryLoad(Template template, Expression templateName, String namespace) {
        this.namespace = namespace;
        if (template != null) {
            String templatePath1 = template.getName();
            int lastSlash = templatePath1.lastIndexOf(47);
            this.templatePath = lastSlash == -1 ? "" : templatePath1.substring(0, lastSlash + 1);
        }
        this.templateName = templateName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Expression getTemplateNameExpression() {
        return this.templateName;
    }

    @Override
    public void execute(Environment env) throws TemplateException, IOException {
        Template importedTemplate;
        String templateNameString = this.templateName.getStringValue(env);
        if (templateNameString == null) {
            String msg = "Error " + this.getStartLocation() + "The expression " + this.templateName + " is undefined.";
            throw new InvalidReferenceException(msg, env);
        }
        try {
            if (templateNameString.indexOf("://") <= 0) {
                int protIndex;
                templateNameString = templateNameString.length() > 0 && templateNameString.charAt(0) == '/' ? ((protIndex = this.templatePath.indexOf("://")) > 0 ? this.templatePath.substring(0, protIndex + 2) + templateNameString : templateNameString.substring(1)) : this.templatePath + templateNameString;
            }
            importedTemplate = env.getTemplateForImporting(templateNameString);
        }
        catch (ParseException pe) {
            String msg = "Error parsing imported template " + templateNameString;
            throw new TemplateException(msg, pe, env);
        }
        catch (IOException ioe) {
            String msg = "Error reading imported file " + templateNameString;
            throw new TemplateException(msg, ioe, env);
        }
        env.importLib(importedTemplate, this.namespace, false);
    }

    @Override
    public String getDescription() {
        return "import " + this.templateName + " as " + this.namespace;
    }

    public String getTemplateName() {
        return this.templateName.toString();
    }
}

