/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.LoopContext;
import freemarker.core.ast.Expression;
import freemarker.core.ast.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;

public class IteratorBlock
extends TemplateElement {
    private String indexName;
    private Expression listExpression;
    private boolean isForEach;

    public IteratorBlock(Expression listExpression, String indexName, TemplateElement nestedBlock, boolean isForEach) {
        this.listExpression = listExpression;
        this.indexName = indexName;
        this.isForEach = isForEach;
        this.nestedBlock = nestedBlock;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Expression getListExpression() {
        return this.listExpression;
    }

    @Override
    public void execute(Environment env) throws TemplateException, IOException {
        TemplateModel baseModel = this.listExpression.getAsTemplateModel(env);
        IteratorBlock.assertNonNull(baseModel, this.listExpression, env);
        env.process(new LoopContext(this, env.getCurrentScope(), baseModel));
    }

    @Override
    public String getDescription() {
        if (this.isForEach) {
            return "foreach " + this.indexName + " in " + this.listExpression;
        }
        return "list " + this.listExpression + " as " + this.indexName;
    }
}

