/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.Expression;
import freemarker.core.ast.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;

public class EscapeBlock
extends TemplateElement {
    private String variable;
    private Expression expr;
    private Expression escapedExpr;

    public EscapeBlock(String variable, Expression expr) {
        this.variable = variable;
        this.expr = expr;
        this.escapedExpr = expr;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public String getVariable() {
        return this.variable;
    }

    public Expression getEscapedExpression() {
        return this.escapedExpr;
    }

    public void setEscapedExpression(Expression escapedExpr) {
        this.escapedExpr = escapedExpr;
    }

    public void setContent(TemplateElement nestedBlock) {
        this.nestedBlock = nestedBlock;
    }

    @Override
    public void execute(Environment env) throws TemplateException, IOException {
        if (this.nestedBlock != null) {
            env.render(this.nestedBlock);
        }
    }

    public Expression doEscape(Expression subst) {
        return this.escapedExpr.deepClone(this.variable, subst);
    }

    @Override
    public String getDescription() {
        return "escape " + this.variable + " as " + this.expr.toString();
    }
}

