/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.InvalidReferenceException;
import freemarker.core.Scope;
import freemarker.core.ast.Expression;
import freemarker.core.ast.TemplateElement;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class BlockAssignment
extends TemplateElement {
    private String varName;
    private Expression namespaceExp;
    private int type;

    public BlockAssignment(TemplateElement nestedBlock, String varName, int type, Expression namespaceExp) {
        this.nestedBlock = nestedBlock;
        this.varName = varName;
        this.namespaceExp = namespaceExp;
        this.type = type;
    }

    public Expression getNamespaceExpression() {
        return this.namespaceExp;
    }

    public String getVarName() {
        return this.varName;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public void execute(Environment env) throws TemplateException, IOException {
        Scope scope = null;
        if (this.namespaceExp != null) {
            try {
                scope = (Scope)this.namespaceExp.getAsTemplateModel(env);
            }
            catch (ClassCastException cce) {
                throw new InvalidReferenceException(this.getStartLocation() + "\nInvalid reference to namespace: " + this.namespaceExp, env);
            }
        } else if (this.type == 1) {
            scope = env.getCurrentNamespace();
        } else if (this.type == 3) {
            scope = env.getCurrentMacroContext();
        } else if (this.type == 2) {
            scope = env.getGlobalNamespace();
        }
        CaptureOutput filter = new CaptureOutput();
        if (this.nestedBlock != null) {
            env.render(this.nestedBlock, filter, null);
        }
        String text = filter.capturedText;
        if (scope != null) {
            scope.put(this.varName, new SimpleScalar(text));
        } else {
            env.unqualifiedSet(this.varName, new SimpleScalar(text));
        }
    }

    @Override
    public String getDescription() {
        return "block assignment to variable: " + this.varName;
    }

    private static class CaptureOutput
    implements TemplateTransformModel {
        String capturedText = "";

        private CaptureOutput() {
        }

        public Writer getWriter(Writer out, List args) {
            return this.getWriter(out, (Map<String, TemplateModel>)null);
        }

        @Override
        public Writer getWriter(Writer out, Map<String, TemplateModel> args) {
            return new StringWriter(){

                @Override
                public void close() {
                    capturedText = this.toString();
                }
            };
        }
    }
}

