/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.InvalidReferenceException;
import freemarker.core.Scope;
import freemarker.core.ast.Expression;
import freemarker.core.ast.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AssignmentInstruction
extends TemplateElement {
    public static final int SET = 0;
    public static final int NAMESPACE = 1;
    public static final int GLOBAL = 2;
    public static final int LOCAL = 3;
    private int type;
    private Expression namespaceExp;
    private ArrayList<String> varNames = new ArrayList();
    private ArrayList<Expression> values = new ArrayList();

    public AssignmentInstruction(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public List<String> getVarNames() {
        return Collections.unmodifiableList(this.varNames);
    }

    public List<Expression> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public void addAssignment(String var, Expression valueExp) {
        this.varNames.add(var);
        this.values.add(valueExp);
    }

    public void setNamespaceExp(Expression namespaceExp) {
        this.namespaceExp = namespaceExp;
    }

    public Expression getNamespaceExp() {
        return this.namespaceExp;
    }

    @Override
    public void execute(Environment env) throws TemplateException, IOException {
        Scope scope = null;
        if (this.namespaceExp != null) {
            try {
                scope = (Scope)this.namespaceExp.getAsTemplateModel(env);
            }
            catch (ClassCastException cce) {
                throw new InvalidReferenceException(this.getStartLocation() + "\nInvalid reference to namespace: " + this.namespaceExp, env);
            }
        } else if (this.type == 1) {
            scope = env.getCurrentNamespace();
        } else if (this.type == 3) {
            scope = env.getCurrentMacroContext();
        } else if (this.type == 2) {
            scope = env.getGlobalNamespace();
        }
        for (int i = 0; i < this.varNames.size(); ++i) {
            String varname = this.varNames.get(i);
            Expression valueExp = this.values.get(i);
            TemplateModel value = valueExp.getAsTemplateModel(env);
            AssignmentInstruction.assertIsDefined(value, valueExp, env);
            if (scope != null) {
                scope.put(varname, value);
                continue;
            }
            env.unqualifiedSet(varname, value);
        }
    }

    @Override
    public String getDescription() {
        return "assignment instruction";
    }
}

