/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.ast.AddConcatExpression;
import freemarker.core.ast.AndExpression;
import freemarker.core.ast.ArithmeticExpression;
import freemarker.core.ast.AssignmentInstruction;
import freemarker.core.ast.AttemptBlock;
import freemarker.core.ast.BlockAssignment;
import freemarker.core.ast.BodyInstruction;
import freemarker.core.ast.BooleanExpression;
import freemarker.core.ast.BreakInstruction;
import freemarker.core.ast.BuiltInExpression;
import freemarker.core.ast.BuiltinVariable;
import freemarker.core.ast.Case;
import freemarker.core.ast.Comment;
import freemarker.core.ast.ComparisonExpression;
import freemarker.core.ast.CompressedBlock;
import freemarker.core.ast.ConditionalBlock;
import freemarker.core.ast.DefaultToExpression;
import freemarker.core.ast.Dot;
import freemarker.core.ast.DynamicKeyName;
import freemarker.core.ast.EscapeBlock;
import freemarker.core.ast.ExistsExpression;
import freemarker.core.ast.Expression;
import freemarker.core.ast.FallbackInstruction;
import freemarker.core.ast.FlushInstruction;
import freemarker.core.ast.HashLiteral;
import freemarker.core.ast.Identifier;
import freemarker.core.ast.IfBlock;
import freemarker.core.ast.Include;
import freemarker.core.ast.Interpolation;
import freemarker.core.ast.InvalidExpression;
import freemarker.core.ast.IteratorBlock;
import freemarker.core.ast.LibraryLoad;
import freemarker.core.ast.ListLiteral;
import freemarker.core.ast.Macro;
import freemarker.core.ast.MethodCall;
import freemarker.core.ast.MixedContent;
import freemarker.core.ast.NamedArgsList;
import freemarker.core.ast.NoEscapeBlock;
import freemarker.core.ast.NoParseBlock;
import freemarker.core.ast.NotExpression;
import freemarker.core.ast.NullLiteral;
import freemarker.core.ast.NumberLiteral;
import freemarker.core.ast.NumericalOutput;
import freemarker.core.ast.OrExpression;
import freemarker.core.ast.ParameterList;
import freemarker.core.ast.ParentheticalExpression;
import freemarker.core.ast.PositionalArgsList;
import freemarker.core.ast.PropertySetting;
import freemarker.core.ast.Range;
import freemarker.core.ast.RecoveryBlock;
import freemarker.core.ast.RecurseNode;
import freemarker.core.ast.ReturnInstruction;
import freemarker.core.ast.StopInstruction;
import freemarker.core.ast.StringLiteral;
import freemarker.core.ast.SwitchBlock;
import freemarker.core.ast.TemplateElement;
import freemarker.core.ast.TemplateHeaderElement;
import freemarker.core.ast.TemplateNode;
import freemarker.core.ast.TextBlock;
import freemarker.core.ast.TransformBlock;
import freemarker.core.ast.TrimBlock;
import freemarker.core.ast.TrimInstruction;
import freemarker.core.ast.UnaryPlusMinusExpression;
import freemarker.core.ast.UnifiedCall;
import freemarker.core.ast.VarDirective;
import freemarker.core.ast.VisitNode;
import freemarker.template.Template;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public abstract class ASTVisitor {
    protected StringBuilder errors = new StringBuilder();
    protected StringBuilder warnings = new StringBuilder();

    public void visit(TemplateNode node) {
        if (node == null) {
            return;
        }
        try {
            Class<?> clazz = node.getClass();
            Method visitMethod = this.getClass().getMethod("visit", clazz);
            visitMethod.invoke((Object)this, node);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(ite);
        }
        catch (NoSuchMethodException nsme) {
            if (node instanceof TemplateElement) {
                this.recurse((TemplateElement)node);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void visit(Template template) {
        TemplateHeaderElement header = template.getHeaderElement();
        if (header != null) {
            this.visit(header);
        }
        this.visit(template.getRootTreeNode());
    }

    public void visit(TemplateHeaderElement node) {
        if (node == null) {
            return;
        }
        Map<String, Expression> params = node.getParams();
        for (Expression exp : params.values()) {
            this.visit(exp);
        }
    }

    public void visit(AddConcatExpression node) {
        this.visit(node.getLeft());
        this.visit(node.getRight());
    }

    public void visit(AndExpression node) {
        this.visit(node.getLeft());
        this.visit(node.getRight());
    }

    public void visit(ArithmeticExpression node) {
        this.visit(node.getLeft());
        this.visit(node.getRight());
    }

    public void visit(AssignmentInstruction node) {
        for (Expression e : node.getValues()) {
            this.visit(e);
        }
    }

    public void visit(AttemptBlock node) {
        this.recurse(node);
    }

    public void visit(BlockAssignment node) {
        this.recurse(node);
    }

    public void visit(BodyInstruction node) {
        this.visit(node.getArgs());
    }

    public void visit(BuiltInExpression node) {
        this.visit(node.getTarget());
    }

    public void visit(BooleanExpression node) {
    }

    public void visit(BreakInstruction node) {
    }

    public void visit(BuiltinVariable node) {
    }

    public void visit(Case node) {
        this.visit(node.getExpression());
        this.recurse(node);
    }

    public void visit(Comment node) {
    }

    public void visit(ComparisonExpression node) {
        this.visit(node.getLeft());
        this.visit(node.getRight());
    }

    public void visit(CompressedBlock node) {
        this.recurse(node);
    }

    public void visit(ConditionalBlock node) {
        this.visit(node.getCondition());
        this.recurse(node);
    }

    public void visit(DefaultToExpression node) {
        this.visit(node.getLeft());
        if (node.getRight() != null) {
            this.visit(node.getRight());
        }
    }

    public void visit(Interpolation node) {
        this.visit(node.getExpression());
        this.visit(node.getEscapedExpression());
    }

    public void visit(Dot node) {
        this.visit(node.getTarget());
    }

    public void visit(DynamicKeyName node) {
        this.visit(node.getTarget());
        this.visit(node.getNameExpression());
    }

    public void visit(EscapeBlock node) {
        this.visit(node.getExpression());
        this.visit(node.getEscapedExpression());
        this.recurse(node);
    }

    public void visit(ExistsExpression node) {
        this.visit(node.getExpression());
    }

    public void visit(FallbackInstruction node) {
    }

    public void visit(FlushInstruction node) {
    }

    public void visit(HashLiteral node) {
        List<Expression> keys = node.getKeys();
        List<Expression> values = node.getValues();
        for (int i = 0; i < keys.size(); ++i) {
            this.visit(keys.get(i));
            this.visit(values.get(i));
        }
    }

    public void visit(Identifier node) {
    }

    public void visit(IfBlock node) {
        this.recurse(node);
    }

    public void visit(Include node) {
        this.visit(node.getIncludedTemplateExpression());
        if (node.getParseExp() != null) {
            this.visit(node.getParseExp());
        }
    }

    public void visit(InvalidExpression node) {
    }

    public void visit(IteratorBlock node) {
        this.visit(node.getListExpression());
        this.recurse(node);
    }

    public void visit(LibraryLoad node) {
        this.visit(node.getTemplateNameExpression());
    }

    public void visit(ListLiteral node) {
        for (Expression exp : node.getElements()) {
            this.visit(exp);
        }
    }

    public void visit(Macro node) {
        this.visit(node.getParams());
        this.recurse(node);
    }

    public void visit(MethodCall node) {
        this.visit(node.getTarget());
        this.visit(node.getArgs());
    }

    public void visit(MixedContent node) {
        this.recurse(node);
    }

    public void visit(NamedArgsList node) {
        for (Expression exp : node.getArgs().values()) {
            this.visit(exp);
        }
    }

    public void visit(NoEscapeBlock node) {
        this.recurse(node);
    }

    public void visit(NoParseBlock node) {
        this.recurse(node);
    }

    public void visit(NotExpression node) {
        this.visit(node.getTarget());
    }

    public void visit(NullLiteral node) {
    }

    public void visit(NumberLiteral node) {
    }

    public void visit(NumericalOutput node) {
        this.visit(node.getExpression());
    }

    public void visit(OrExpression node) {
        this.visit(node.getLeft());
        this.visit(node.getRight());
    }

    public void visit(ParameterList node) {
        for (String paramName : node.getParamNames()) {
            Expression defaultExp = node.getDefaultExpression(paramName);
            if (defaultExp == null) continue;
            this.visit(defaultExp);
        }
    }

    public void visit(ParentheticalExpression node) {
        this.visit(node.getNested());
    }

    public void visit(PositionalArgsList node) {
        for (Expression exp : node.args) {
            this.visit(exp);
        }
    }

    public void visit(PropertySetting node) {
        this.visit(node.getValue());
    }

    public void visit(Range node) {
        this.visit(node.getLeft());
        if (node.getRight() != null) {
            this.visit(node.getRight());
        }
    }

    public void visit(RecoveryBlock node) {
        this.recurse(node);
    }

    public void visit(RecurseNode node) {
        this.visit(node.getTargetNode());
        this.visit(node.getNamespaces());
    }

    public void visit(ReturnInstruction node) {
        this.visit(node.returnExp);
    }

    public void visit(VarDirective node) {
        for (Expression value : node.getVariables().values()) {
            this.visit(value);
        }
    }

    public void visit(StopInstruction node) {
    }

    public void visit(StringLiteral node) {
    }

    public void visit(SwitchBlock node) {
        this.visit(node.getTestExpression());
        this.recurse(node);
    }

    public void visit(TextBlock node) {
    }

    public void visit(TransformBlock node) {
        this.visit(node.getTransformExpression());
        if (node.namedArgs != null) {
            for (Expression exp : node.namedArgs.values()) {
                this.visit(exp);
            }
        }
        this.recurse(node);
    }

    public void visit(TrimBlock node) {
        this.visit(node.nestedBlock);
    }

    public void visit(TrimInstruction node) {
    }

    public void visit(UnaryPlusMinusExpression node) {
        this.visit(node.getTarget());
    }

    public void visit(UnifiedCall node) {
        this.visit(node.getNameExp());
        if (node.getArgs() != null) {
            this.visit(node.getArgs());
        }
        if (node.getBodyParameters() != null) {
            this.visit(node.getBodyParameters());
        }
        this.recurse(node);
    }

    public void visit(VisitNode node) {
        this.visit(node.getTargetNode());
        if (node.getNamespaces() != null) {
            this.visit(node.getNamespaces());
        }
    }

    protected void recurse(TemplateElement node) {
        if (node.nestedElements != null) {
            for (TemplateNode templateNode : node.nestedElements) {
                this.visit(templateNode);
            }
        } else {
            this.visit(node.nestedBlock);
        }
    }

    public ASTVisitor clone() {
        try {
            return (ASTVisitor)super.clone();
        }
        catch (CloneNotSupportedException cse) {
            throw new IllegalStateException("You tried to clone a visitior implementation that was does not implement cloneable");
        }
    }
}

