/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Configurable;
import freemarker.core.ast.Macro;
import freemarker.core.ast.TemplateElement;
import freemarker.template.Configuration;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public abstract class TemplateCore
extends Configurable {
    private TemplateElement rootElement;
    private Map<String, Macro> macros = new HashMap<String, Macro>();

    protected TemplateCore(Configuration config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMacro(Macro macro) {
        String macroName = macro.getName();
        Map<String, Macro> map = this.macros;
        synchronized (map) {
            this.macros.put(macroName, macro);
        }
    }

    public Map<String, Macro> getMacros() {
        return this.macros;
    }

    public void dump(PrintStream ps) {
        ps.print(this.rootElement.getCanonicalForm());
    }

    public void dump(Writer out) throws IOException {
        out.write(this.rootElement.getCanonicalForm());
    }

    protected synchronized TemplateElement getRootElement() {
        return this.rootElement;
    }

    protected synchronized void setRootElement(TemplateElement rootElement) {
        if (this.rootElement != null) {
            throw new IllegalStateException("Root element already set");
        }
        this.rootElement = rootElement;
    }
}

